.DS L
.PV
#ifndef ER_ENTRY_H
#define ER_ENTRY_H
#include "Clib/gring.h"
#include "Clib/stringt.h"
#include "rule.h"
class erule_lex;
.EP

.BC
Table of expansion rules for some compile type.  
It reads definition files and selects version
based on instance-dependent context and global text-macro tables.
Currently, only one compile-type is interesting at a time.
Intended for internal use only.
.EC
class erule_entry {
.PV
    friend class erule_selection;  // Only so that it can iterate the rules
    string _compile_type;
    gringroot(next,erule_rule) rules;

    string _rules_file;
    boolean has_automatic_true;
    boolean has_default;
    void selection_error(int);
    boolean same_file(const string& rules_file);
    void reset(const string& rules_file);
    erule_rule* append(const char* expression, erule_lex*);
.EP
public:
    erule_entry(const string& compile_type);
    ~erule_entry() { fault("~erule_entry() not implemented"); }
    boolean parse(erule_lex*, const string& filename);
				// If called on 0, then only a syntax check
    const string& compile_type();

    erule_rule* select();

    void dump(ostream&);
};
.PV
inline const string& erule_entry::compile_type() { return _compile_type; }
#endif
.EP
.DE
