.DS L

.BC
dwg_version.cl -- The available extensions, versions, and pages for a drawing.
Intended for internal use only.
.EC
.PV
#ifndef ER_DWG_VERS_H
#define ER_DWG_VERS_H
#include "Clib/gavl.h"
#include "Clib/gring.h"
#include "er_heap.h"
#include "scalddir.h"
#include "dwg_extension.h"
class erule_rule;

gring_define(next,erule_drawing_version);

.EP
class erule_drawing_version {
.PV
    gring_inst(next,erule_drawing_version);
    int _version_number;
    gringroot(next,erule_drawing_extension) extensions;
    void delete_menu(erule_drawing_extension* menu);
.EP
public:
    erule_drawing_version(int);
    ~erule_drawing_version();
    erule_drawing_extension* select(erule_rule*);
    int version_number();
    erule_drawing_extension* enter(const string& extension, const erule_scalddir&);
	// Returns 0 if failed (error already reported)
    void read_expressions(erule_drawing_entry*);
    void set_expression_from_menu(erule_drawing_entry*,
				  erule_drawing_extension* menu, 
				  const erule_expression&);
    boolean is_empty();

    void dump(ostream&);
};
.PV
#ifndef VAX
gring_inline(next,erule_drawing_version);
#endif
inline int erule_drawing_version::version_number()
    { return _version_number; }
inline int erule_drawing_extension::version_number()
    { return version->version_number(); }
#endif
.EP
.DE

