#include "error.h"
#include "dwg_version.h"
#include "dwg_entry.h"
#include "rule.h"
#include "table.h"


const MAX_PAGE_NUM = 10000;	// per previous ValidCOMPILERs


#ifdef VAX
gring_functions(next,erule_drawing_version,);
#endif


// Initialized by erule_rule::parse -- these can't be staticly initialized,
// as they depend on the prior initialization of the string table.
static string PRIM;
static string PART;
static void order_dependent_static_init()
{
#   define init(s) s = "s"
    init(PRIM);  init(PART);
#   undef init
}


erule_drawing_version::erule_drawing_version(int i)
{
    AS(!this);
    this = (erule_drawing_version*)erule_heap.mem(sizeof(*this));
    AS(!extensions.first());
    _version_number = i;
}


erule_drawing_version::~erule_drawing_version()
{ 
    erule_drawing_extension* ext;
    while (ext = extensions.remove_first()) delete ext;

    erule_heap.memfree(this, sizeof(*this));  this = 0;
}


void erule_drawing_version::dump(ostream& f)
{
    erule_drawing_extension* ext = extensions.first();
    if (!ext) f <<  "    Version " << _version_number << " (no extensions)\n";
    while (ext) { ext->dump(f);  ext = extensions.next(ext); }
}


erule_drawing_extension*
erule_drawing_version::select(erule_rule* rule)
{
    erule_drawing_extension* selected = 0;
    int selected_val = 0; // The value for "not in the rule"
    erule_drawing_extension* ext;
    for (ext = extensions.first(); ext; ext = extensions.next(ext)) {
	int ext_val;
	if (ext_val = rule->ord(ext, selected_val)) {
	    selected = ext;
	    selected_val = ext_val;
	}
    }
    return selected;
}


erule_drawing_extension* erule_drawing_version::
enter(const string& extension, const erule_scalddir& dir)
{
    if (!(erule_the_rule_table->extension_is_interesting(extension)))
	return 0;   // Just ignore it -- not in any rule.

    // PART and PRIM are the same, so check for collisions of these.
    if (!PART) order_dependent_static_init();
    boolean is_prim = (extension == PART || extension == PRIM);

    erule_drawing_extension* ext;
    for (ext = extensions.first(); ext; ext = extensions.next(ext)) {
        if (!is_prim) {
	    if (ext->name() == extension) break;
	}
	else {
	    if (ext->is_prim()) {
		erule_scalddir ext_dir = ext->scalddir();
		if (ext_dir.type() == dir.type()) break;
	    }
	}
    }

    if (ext) 
	return is_prim ?  
	    ext->check_prim_collision(extension, dir) :
	    ext->check_scalddir_collision(dir);

    ext = new erule_drawing_extension(this, extension, dir);
    extensions.insert_front(ext);
    return ext;
}


void erule_drawing_version::read_expressions(erule_drawing_entry* drawing)
{
    erule_drawing_extension* to_delete = 0;
    erule_drawing_extension* ext;
    for (ext = extensions.first(); ext; ext = extensions.next(ext)) {
    	if (to_delete) { delete_menu(to_delete);  to_delete = 0; }
	if (!(ext->read_expression(drawing))) {
	    if (!drawing->is_single_versioned()) {
		to_delete = ext;
		drawing->read_menu(ext);
	    }
	}
    }
    if (to_delete) delete_menu(to_delete);
}


void erule_drawing_version::
set_expression_from_menu(erule_drawing_entry* drawing, 
                         erule_drawing_extension* menu, 
			 const erule_expression& expression)
{
    erule_drawing_extension* ext = extensions.first();
    for ( ; ext; ext = extensions.next(ext)) if (*ext == *menu) break;

    if (ext) ext->set_expression_from_menu(drawing, expression);
    else {
	drawing->menu_error(ERR_VERS_NOT_FOUND_IN_DIR);
	erule_err ERR_INDENT << "Unfound version=" << 
	          menu->name() << "." << version_number() ERR_NL;
    }
}


void erule_drawing_version::
delete_menu(erule_drawing_extension* menu)
{
    erule_drawing_extension* parent = 0;
    erule_drawing_extension* ext = extensions.first();
    for ( ; ext; ext = extensions.next(ext)) 
	if (ext == menu) break;
	else parent = ext;
    if (!ext) return;
    extensions.remove_successor(parent);
    delete ext;
}


boolean erule_drawing_version::is_empty()
    { return extensions.first() == 0; }
