/*
 * ValidCOMPILER and SCALD compiler version strings.
 */

#define VALID_VERSION "1.4"
#define VALID_MICRO_VERSION "-P4"
/*#define VALID_MICRO_VERSION "-S4"*/
#define SCALD_VERSION "8.4"
#define SCALD_MICRO_VERSION VALID_MICRO_VERSION

#ifdef PMAX
#undef VALID_MICRO_VERSION
#undef SCALD_MICRO_VERSION
#define VALID_MICRO_VERSION "-B1"
#define SCALD_MICRO_VERSION VALID_MICRO_VERSION
#endif

/*

The following routines are defined in this file for use by PASCAL:


function bit_and(
{                %IMMED                                        }(*VAX*)
                 a, b: longint): longint;
  { return the bitwise and of the 2 integers }
cexternal;
{ begin  bit_and := a and b;  end;                             }(*370*)
{ external;                                                    }(*VAX*)
{ external;                                                  }(*ELXSI*)
 

function vversion: xtring;
  { return (in xtring format, but not in the heap) the ValidCOMPILER
    version (including platform specification). }

function sversion: xtring;
  { return (in xtring format, but not in the heap) the SCALD Compiler
    version (including platform specification). }

function gettime(name: xtring; var stamp: Cint): boolean;
  { return a time stamp }

procedure unbuf_stderr; cexternal;
  { make sure that C output to stderr is unbuffered }


*/


/* 
 * Platform definitions: O.S type, parameter reversal and platform name for
 * version string.
 */

#ifdef S32
#define UNIX
#define BSD42
#define REVERSE
#define SYSTEM " S32"
#define SVS
#endif S32

#ifdef SUN3
#define SYSTEM " SUN3"
#define UNIX
#define BSD42
#endif SUN3

#ifdef SUN4
#define SYSTEM " SUN4"
#define UNIX
#define BSD42
#endif SUN4

#ifdef PMAX
#define SYSTEM " DEC3100"
#define UNIX
#define BSD42
#endif PMAX

#ifdef PC_AT
#define SYS5
#define REVERSE
#define SVS
#define UNIX
#define SYSTEM " PC"
#endif PC_AT

#ifdef VAX
#define VMS
#define odd(x) (1&(x))
#define SYSTEM " VMS"
#endif VAX

#ifndef SYSTEM
#define SYSTEM " ???"
#define UNIX
#define BSD42
#endif SYSTEM

/*
 * Now comes the code.
 */

#ifdef UNIX
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#endif UNIX
#ifdef VMS
#include <descrip.h>
#include <errno.h>
#define LNM$_STRING 2
#define $DESCRIPTOR_STRLEN(name,string)	\
    struct dsc$descriptor_s name = \
	{ strlen(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }
#include <rms.h>
#endif VMS
#include <stdio.h>

#define TRUE 1
#define FALSE 0
#define NULL 0
#define PTRUE 1
#define PFALSE 0
#define PBOOLEAN int


#define ALPHA_LENGTH 16
#define MAX_STRING_LENGTH 255
typedef char *xtring; /* a pascal "xtring" type -- it is a string with
                         byte count in the first char. */


/*
 * Convert PASCAL xtring to C string (will work for c == p).
 */
static void
xtring_to_cname(c, p)
register char *c;
register xtring p;
{
    register char *end;
    end = p + *(unsigned char*)p;
    p++;
    while (p <= end) *c++ = *p++;
    *c = '\0';
}


/* to avoid the C library for the VMS version: */
static int
strlen(s)
    char *s;
{
    register char *c;
    for (c = s ; (*c) ; c++) ;
    return(c - s);
}

 
static xtring
do_version(vers, micro)
char *vers;
{
    static char version[32];

    strcpy(version+1, vers);
    strcat(version+1, SYSTEM);
    strcat(version+1, micro);
    *version = strlen(version + 1);
    return(version);
}


xtring
vversion()
{
    return do_version(VALID_VERSION, VALID_MICRO_VERSION);
}
#ifdef PC_AT
asm("vversion: .globl vversion");
asm("	jump @_vversion");
#endif PC_AT


xtring
sversion()
{
    return do_version(SCALD_VERSION, SCALD_MICRO_VERSION);
}
#ifdef PC_AT
asm("sversion: .globl sversion");
asm("	jump @_sversion");
#endif PC_AT


/*
 * Perform a bitwise and on 2 long integers.
 */
long
bit_and(a,b)
long a,b;
{
	return(a & b);
}
#ifdef PC_AT
asm("bit_and: .globl bit_and");
asm("	jump @_bit_and");
#endif PC_AT


#ifdef S32
#define unbuf_stderr unbuf_st
#endif
void
unbuf_stderr() /* Note that stderr is used only for debug statements from
                  modules coded in C */
{
#ifdef UNIX
	setbuf(stderr, NULL);
#endif UNIX
#ifdef VMS
	fclose(stderr);
	if (!(stderr = fopen("MONITOR", "w"))) exit(100);
	setbuf(stderr, NULL);
#endif VMS
}
#ifdef PC_AT
asm("unbuf_stderr: .globl unbuf_stderr");
asm("	jump @_unbuf_stderr");
#endif PC_AT


#ifdef PC_AT


asm("uxclose: .globl uxclose");
asm("	jump @_close");


#else


void
uxclose(fd)
int fd;
{
	close(fd);
}


#ifdef VAX      /* only the VAX version needs "unix" read and write! */
int
#ifdef REVERSE
uxread(nbytes, buf, fd)
#else
uxread(fd, buf, nbytes)
#endif REVERSE
int fd;
char *buf;
int nbytes;
{
	return(read(fd, buf, nbytes));
}


int
#ifdef REVERSE
uxwrite(nbytes, buf, fd)
#else
uxwrite(fd, buf, nbytes)
#endif REVERSE
int fd;
char *buf;
int nbytes;
{
	return(write(fd, buf, nbytes));
}
#endif VAX
#endif PC_AT


#ifdef VMS
static void init_fab(fab, name)
    struct FAB *fab;
    xtring name;
{
    *fab = cc$rms_fab;
    fab->fab$b_fns = (unsigned char)*name;
    fab->fab$l_fna = (long)(++name);
}


static void init_rab(rab, fab)
    struct RAB* rab;
    struct FAB* fab;
{
    *rab = cc$rms_rab;
    rab->rab$l_fab = fab;
}
#endif VMS


PBOOLEAN
#ifdef REVERSE
gettime(stamp, fname)
#else
gettime(fname, stamp)
#endif
xtring fname;
int *stamp;
{
#ifdef UNIX
    char cname[MAX_STRING_LENGTH+1];
    struct stat statbuf;

    xtring_to_cname(cname, fname);
    *stamp = 0;
    if (stat(cname, &statbuf)) return PFALSE;
    *stamp = statbuf.st_mtime;
    return PTRUE;
#endif UNIX
#ifdef VMS
    struct FAB fab;
    struct XABRDT xab;
    int val;

    init_fab(&fab, fname);
    xab = cc$rms_xabrdt;
    fab.fab$l_xab = (long)&xab;
    if (odd(val = SYS$OPEN(&fab, 0, 0))) {
	fab.fab$l_xab = 0;
	SYS$CLOSE(&fab, 0, 0);
	*stamp = shell$fix_time(&(xab.xab$q_rdt));
	return PTRUE;
	}
    *stamp = 0;
    return PFALSE;
#endif VMS
}
#ifdef PC_AT
asm("gettime: .globl gettime");
asm("	jump @_gettime");
#endif PC_AT


#ifdef S32
#define file_exists file_exi
#endif


PBOOLEAN
file_exists(fname)
xtring fname;
{
#ifdef UNIX
    char cname[MAX_STRING_LENGTH+1];
    struct stat statbuf;

    xtring_to_cname(cname, fname);
    return stat(cname, &statbuf) ? PFALSE : PTRUE;
#endif UNIX
#ifdef VMS
    struct FAB fab;
    int val;

    init_fab(&fab, fname);
    if (odd(val = SYS$OPEN(&fab, 0, 0))) {
	SYS$CLOSE(&fab, 0, 0);
	return PTRUE;
	}
    return (val == RMS$_FLK || val == RMS$_PRV) ? PTRUE : PFALSE;
#endif VMS
}
#ifdef PC_AT
asm("file_exists: .globl file_exists");
asm("	jump @_file_exists");
#endif PC_AT


#ifdef UNIX
extern int errno;

static void
report_errno()
{
    char msg[512];

    sprintf(msg, "signal failed: errno %d\n", errno);
    write(2, msg, strlen(msg));
}


static void (*saved_handler)()={NULL};
static char *saved_link={NULL};

static void fake_handler(sig)
    int sig;
{
#ifdef DEBUG
    write(2, "fake_handler_called", 19);
#endif

#ifndef BSD42
    if ((int)signal(sig, SIG_IGN) == -1) report_errno();
#endif BSD42

#ifndef SVS
    (*saved_handler)(saved_link);
#else
    handler_wrap(saved_handler, saved_link);
#endif SVS

#ifndef BSD42
    if ((int)signal(sig, fake_handler) == -1) report_errno();
#endif BSD42
}


#ifdef S32
#define def_handler def_hand /* 8 char truncation of external entry points */
#endif S32

void
#if defined(SVS) || defined(PMAX)
def_handler(static_link, handler)
#else
def_handler(handler, static_link)
#endif
    char *static_link;
    void (*handler)();
{
#ifdef S32
    savea4a5();
#endif S32
#ifdef DEBUG
    {
        char msg[512];
        sprintf(msg, "def_handler(0x%x) static link 0x%x\n", handler, static_link);
        write(2, msg, strlen(msg));
        }
#endif DEBUG
    saved_handler = handler;
    saved_link = static_link;

    if ((int)signal(SIGTERM, fake_handler) == -1) report_errno();
    if ((int)signal(SIGINT, fake_handler) == -1) report_errno();
    if ((int)signal(SIGQUIT, fake_handler) == -1) report_errno();
    if ((int)signal(SIGHUP, fake_handler) == -1) report_errno();
}
#ifdef PC_AT
asm("def_handler: .globl def_handler");
asm("	jump @_def_handler");
#endif PC_AT


void
suicide()
{
    /* Due to a bug in kill under the 8.0 OS, real uid and effective
       uid must be the same for kill to work */
    if (kill(getpid(), SIGINT)) {
        char msg[255];
	sprintf(msg, "kill(%d, SIGINT) failed -- errno %d\n", 
	        getpid(), errno);
        write(2, msg, strlen(msg));
        }
}
#ifdef PC_AT
asm("suicide: .globl suicide");
asm("	jump @_suicide");
#endif PC_AT


#ifdef S32
#define delete_file delete_f
#endif

PBOOLEAN
delete_file(fname)
xtring fname;
{
    char cname[MAX_STRING_LENGTH+1];
    struct stat statbuf;

    xtring_to_cname(cname, fname);
    if (stat(cname, &statbuf)) return PFALSE;
    if ((statbuf.st_mode & S_IFMT) != S_IFREG) return PFALSE;
    return unlink(cname) ? PFALSE : PTRUE;
}
#ifdef PC_AT
asm("delete_file: .globl delete_file");
asm("	jump @_delete_file");
#endif PC_AT
#endif UNIX


static char *
util_getenv(name)
   char *name;
{
#ifdef UNIX
    char *getenv();
    return(getenv(name));
#endif UNIX
#ifdef VMS
    /* The following is necessary as the VAXC library routine getenv()
       requires initialization performed by a C main (not done by a
       PASCAL main). */

    static $DESCRIPTOR(table, "LNM$PROCESS_TABLE");
    $DESCRIPTOR_STRLEN(namedesc, name);
    struct itmlst {
	unsigned short buffer_length;
	unsigned short code;
	char *buffer_address;
	unsigned short *return_length_address;
	long terminator;
	} itmlst;
    char result[256];
    unsigned short result_length;
    int code;
    char *ret_value;
    

    itmlst.code = LNM$_STRING;
    itmlst.buffer_length = 255;
    itmlst.buffer_address = &result;
    itmlst.return_length_address = &result_length;
    itmlst.terminator = 0;

    if (!((code=SYS$TRNLNM(0, &table, &namedesc, 0, &itmlst)) & 1)) result_length = 0;
    result[result_length] = '\0';
#ifdef DEBUG
    fprintf(stderr, "TRNLNM(\"%s\") (%d chars) == \"%s\" (code == 0x%x)\n", 
           namedesc.dsc$a_pointer, namedesc.dsc$w_length, result, code);
#endif DEBUG
    if (!result_length) return(0);

    /* make a copy of result so returned value will not be volatile */

    ret_value = malloc((unsigned int)(result_length + 1));
    strcpy(ret_value, result);
    return(ret_value);
#endif VMS
}


#ifdef VMS
/*
 * Returns 1 for success; RMS condition code for failure.
 * (Initial non-existence of the file is considered a success.)
 * Deletes all revisions.
 */
static int
vms_delete_file(name)
char *name;
{
    struct FAB name_fab;
    int val;

    /* init_fab() takes an xtring, so we just do it by hand here */
    name_fab = cc$rms_fab;
    name_fab.fab$b_fns = (unsigned char)strlen(name);
    name_fab.fab$l_fna = (long)(name);

    while (odd(val = SYS$ERASE(&name_fab, 0, 0))) ;
#ifdef DEBUG
    fprintf(stderr, "vms_delete_file(%s)->%d\n", name, val);
#endif
    if (val == RMS$_FNF) return 1;
    return val;
}
#endif VMS


#ifdef S32
#define delete_logical_file delete_l
#endif

/*
 * NOTE: initial non-existence of the file is here considered success.
 */
PBOOLEAN
delete_logical_file(fname)
char fname[ALPHA_LENGTH];
{
    char cname[ALPHA_LENGTH + 1];
    char *stop = fname + ALPHA_LENGTH;
    char *f = fname;
    char *c = cname;
    char *realname;


    while (f < stop && *f != ' ') *c++ = *f++;
    *c = '\0';
#ifdef DEBUG
    fprintf(stderr, "delete_logical_file(%s)\n", cname);
#endif
    if (!(realname = util_getenv(cname))) return PFALSE;
#ifdef DEBUG
    fprintf(stderr, "realname='%s'\n", realname);
#endif
#ifdef UNIX
    {
	struct stat statbuf;
        if (stat(realname, &statbuf)) return PTRUE;
        if ((statbuf.st_mode & S_IFMT) != S_IFREG) return PFALSE;
        return unlink(realname) ? PFALSE : PTRUE;
	}
#endif UNIX
#ifdef VMS
    return odd(vms_delete_file(realname)) ? PTRUE : PFALSE;
#endif VMS
}
#ifdef PC_AT
asm("delete_logical_file: .globl delete_logical_file");
asm("	jump @_delete_logical_file");
#endif PC_AT


#ifdef VMS
/*
 * Create the named file, if it does not already exist.  The ONLY reason
 * this exists is so that the linker list file can be created by the 
 * compiler (so that the correct permissions are used for files in shadow
 * directories) but will be created as a STREAM-LF file for VMS.  The
 * VAXC library standard I/O functions work only on these files.  This
 * is supposed to be fixed for 4.6 VMS, but we can't wait for that.
 */


static char error_string[80];


#define MAKE_IT 0
#define LOCKED 1
#define ERROR 2
#define EXISTS 3


static void
error_message(code, err)
int code;
xtring *err;
{
    switch(code) {
    case RMS$_ACC: 
        strcpy(error_string+1, "ACP file access failed");
        break;
    case RMS$_ACT:  
        strcpy(error_string+1, "File activity precludes operation");
        break;
    case RMS$_DNF: 
        strcpy(error_string+1, "Directory not found");
        break;
    case RMS$_DNR: 
        strcpy(error_string+1, "Device not ready or not mounted");
        break;
    case RMS$_MKD: 
        strcpy(error_string+1, "ACP could not mark file for deletion");
        break;
    case RMS$_PRV: 
        strcpy(error_string+1, "Insufficient priviledge or file protection violation");
        break;
    case RMS$_WLK: 
        strcpy(error_string+1, "Device currently write locked");
        break;
    default:
        strcpy(error_string+1, "Reason unknown");
        break;
    }

    *error_string = strlen(error_string+1);
    *err = error_string;
}


static int
linker_list_file_exists(file, err)
xtring file;
xtring *err;
{
    /* Return TRUE iff file exists AND is STREAM LF format.
       If wrong format, blow it away. */
    struct FAB fab;
    int code, is_stream_lf;
    char cname[MAX_STRING_LENGTH+1];

#   ifdef DEBUG
    xtring_to_cname(cname, file);
    fprintf(stderr, "checking %s\n", cname);
#   endif DEBUG


    init_fab(&fab, file);
    if (odd(code = SYS$OPEN(&fab, 0, 0))) {
	is_stream_lf = (fab.fab$b_org == FAB$C_SEQ && 
	                fab.fab$b_rfm == FAB$C_STMLF);
	if (is_stream_lf) {
	    /* Truncate the file to get around VAX C runtime bug -- fopen with mode
	       a+ followed by rewind does not truncate the file.   This has been
	       fixed (with this same hack) in the linker, but it is also put here
	       so that this will be fixed for programs using an old linker */
	    struct RAB rab;  int val;
	    init_rab(&rab, &fab);
	    if (odd(val=SYS$CONNECT(&rab, 0, 0)))
		if (odd(val=SYS$FIND(&rab, 0, 0))) {
		    val = SYS$TRUNCATE(&rab, 0, 0);
#ifdef DEBUG
		    if (!odd(val)) fprintf(stderr, "truncate fails %d\n", val);
#endif
		}
#ifdef DEBUG
		else fprintf(stderr, "find fails %d\n", val);
	    else fprintf(stderr, "connect fails %d\n", val);
#endif
	    /* end of truncation workaround */

	    SYS$CLOSE(&fab, 0, 0);
	    return EXISTS;
	}

#       ifdef DEBUG
	fprintf(stderr, "File is not stream-lf\n");
#       endif DEBUG
	
	SYS$CLOSE(&fab, 0, 0);
        xtring_to_cname(cname, file);
	if (odd(code = vms_delete_file(cname))) return MAKE_IT;
    }

#   ifdef DEBUG
    fprintf(stderr, "error %d\n", code);
#   endif DEBUG

    switch (code) {
    case RMS$_FNF: return MAKE_IT;
    case RMS$_FLK: return LOCKED;
    default:
	error_message(code, err);
	return ERROR;
    }
}


PBOOLEAN
hack_around_vaxc_bug_fcreat(name, err)
xtring name, *err;
{
    int code;
    FILE *f;
    char cname[MAX_STRING_LENGTH+1];

    *err = NULL;

    /* Note: it is safe to wait on a locked file as at this point the
       compiler has not locked any other files in the shadow area, so
       deadlocks won't occur. */

    while (TRUE) {
	switch (linker_list_file_exists(name, err)) {
	case LOCKED: sleep(10);  break;
	case EXISTS: return PTRUE;
	case ERROR: return PFALSE;
	case MAKE_IT:
	default:
            xtring_to_cname(cname, name);
	    if (!(f = fopen(cname, "a+"))) {
#               ifdef DEBUG
                fprintf(stderr, "fopen error %d\n", vaxc$errno);
#               endif DEBUG

		if (vaxc$errno == RMS$_FLK) break;
		error_message(vaxc$errno, err);
		return PFALSE;
		}
	    fclose(f);
	    return PTRUE;
	}
    }
}
#endif VMS
