#define SETBUF_BUG
#define FCLOSE_BUG

#ifdef S32
#define UNIX
#define BSD42
#define REVERSE
#endif S32

#if defined(SUN3) || defined(SUN4) || defined(PMAX)
#define UNIX
#define BSD42
#endif

#ifdef PC_AT
#define SYS5
#define UNIX
#define REVERSE
#endif PC_AT

#define DEBUG 1

/* The following set of input routines does not use heap, so it can be
   used with unmodified SVS pascal.  The file variables are different
   (you can't use pascal i/o and this on the same file variable) and
   can be declared as follows:

   const
     BUFSIZ = 1024;  { 4.2 BSD -- BUFSIZ is 512 for 4.1c, so use the larger }
   type
     Cint = longint;
     Cfile_file_ptr = Cint;
     Cfile = record
       f: Cfile_file_ptr;
       buffer: packed array[1..BUFSIZ] of char;
     end;

   var
     myfile: Cfile;


   The SVS external declarations are:

   function creset(var f: Cfile; var logical: alpha; 
                   name: xtring; buffer_size: Cint): boolean;  cexternal;
     { If name is not nullstring (has > 0 length) then reset file
       of that name.  Else reset logical file specified by "logical"
       (meaning get the value of the specified environment variable 
       and open that file.  Use specified buffer size (which must be
       either be 0 or >= BUFSIZ due to (1) that setbuffer only works for
       these 2 values and (2) only setbuf is portable to other than
       4.2 UNIX).  BUFSIZ for our 4.2 UNIX is 1024 and for 4.1c it is
       512.  The larger value can be used for both. }


   function creadln(var f: Cfile;  line: xtring): Cint;  cexternal;
     { read a line from the file into the xtring.  Return
         0 if completely successful
	 1 if overflow (chars lost at end of line)
	 2 if end of file (no line read)                    }


   function crdetab(var f: Cfile;  line: xtring): Cint;  cexternal;
     { read a line from the file into the xtring, expanding tabs.  Return
         0 if completely successful
	 1 if overflow (chars lost at end of line)
	 2 if end of file (no line read)                    }


   function cfclose(var f: Cfile): boolean;  cexternal;
     { close the file f, return TRUE iff successful }


   function cfdsc(var f: Cfile): Cint;  cexternal;
     { return the file descriptor for the open file f }


   function ceof(var f: Cfile): bookean;  cexternal;
     { return TRUE iff f is at end of file }


   function ceoln(var f: Cfile): boolean;  cexternal;
     { return TRUE iff f is at end of line (or end of file). }


*/



#ifdef UNIX

#include <stdio.h>
#include <errno.h>
extern int errno;     /* redundant on some platforms, but not on s32 */
#ifdef SYS5
#include <pwd.h>
#include <fcntl.h>
#endif SYS5
#define MAX_STRING_LENGTH 256
#define TRUE 1
#define FALSE 0
#define PBOOLEAN int
#define PTRUE 1       /* PASCAL boolean values (happen to be same for all */
#define PFALSE 0      /* platforms and same as C values) */
#define ALPHA_LEN 16
#define SUCCESS 0
#define OVERFLOW 1
#define END_OF_FILE 2
#define TAB 9
#define BLANK_CHAR ' '

extern FILE *fopen(/*filename,  mode*/)
/*char *filename, char *mode*/;

extern int fclose(/*f*/)
/*FILE *f*/;

/*
 * Jump table -- we call some functions through here just to give the 
 * security stuff some global data to scramble that will cause the program
 * to blow up if not unscrambled.
 */
typedef int (*func)();
static _creset(), _cfclose(), _xtring_to_cstring(), _alpha_to_cstring();
static func func_table[] = { _creset, _cfclose, _xtring_to_cstring, _alpha_to_cstring };
#define CRESET(f, l, n, s) ((*func_table)(f, l, n, s))
#define CFCLOSE(f) ((*(func_table+1))(f))
#define xtring_to_cstring(c, n) ((*(func_table+2))(c, n))
#define alpha_to_cstring(c, n) ((*(func_table+3))(c, n))


typedef char *xtring; /* a pascal "xtring" type -- it is a string with
                         byte count in the first char. */
extern int errno;

struct cfile {
    FILE *f;
    char buffer[BUFSIZ];
    };


/*
 * Convert the pascal xtring to a C string (in the global array c).
 */
static _xtring_to_cstring(c, name) 
register char *c, *name;
{
    register char *stop = name + *name;
    name++;
    while (name <= stop) *c++ = *name++;
    *c='\0';
}

/*
 * Convert identifier to C string
 */
static _alpha_to_cstring(c, alpha)
register char *c, *alpha;
{
    register char *stop = alpha + ALPHA_LEN;
    while (alpha < stop && *alpha != ' ') *c++ = *alpha++;
    *c=0;
}




int
cfdsc(fi)
    struct cfile *fi;
{
    return(fi->f==NULL?(-1):fileno(fi->f));
}
#ifdef PC_AT
asm("cfdsc: .globl cfdsc");
asm("	jump @_cfdsc");
#endif


int
#ifdef REVERSE
creadln(str, fi)
#else
creadln(fi, str)
#endif
    char *str;
    struct cfile *fi;
{
    register FILE *f;       /* the file */
    register int c;         /* current char from getc */
    register char *i;       /* last char inserted in str */
    register char *lasti;   /* pointer to last possible char in str */
    
    lasti = str + MAX_STRING_LENGTH-1;  i = str;  f = fi->f;

#ifdef SETBUF_BUG
    /* check for preceeding 0's from setbuf UNIX bug */
    while((c=getc(f))==0) ;
    ungetc(c,f);
#endif SETBUF_BUG

    while(((c = getc(f)) != EOF) && (c != (int)('\n'))) {
        if (++i <= lasti) *i = (char)(c);
    }
 
    if ((c==EOF) && (int)(i==str)) {
        *str = 0;
#ifdef DEBUGV
        write(2,"Creadln(EOF):\n",14);
#endif DEBUGV
        return(END_OF_FILE);
    }
    if (i>lasti) {
        *str = MAX_STRING_LENGTH-1;
#ifdef DEBUGV
        write(2,"Creadln(OVF):",13);
	write(2,str+1,(int)(*str));
	write(2,"\n",1);
#endif DEBUGV
	return(OVERFLOW);
    }
    *str = i - str;
#ifdef DEBUGV
    write(2,"Creadln(OK):",12);
    write(2,str+1,(int)(*str));
    write(2,"\n",1);
#endif DEBUGV
    return(SUCCESS);
}	
#ifdef PC_AT
asm("creadln: .globl creadln");
asm("	jump @_creadln");
#endif


int
#ifdef REVERSE
crdetab(str, fi)
#else
crdetab(fi, str)
#endif
    char *str;
    struct cfile *fi;
{
    register FILE *f;       /* the file */
    register int c;         /* current char from getc */
    register char *i;       /* last char inserted in str */
    register char *lasti;   /* pointer to last possible char in str */
    
    lasti = str + MAX_STRING_LENGTH-1;  i = str;  f = fi->f;

#ifdef SETBUF_BUG
    /* check for preceeding 0's from setbuf UNIX bug */
    while((c=getc(f))==0) ;
    ungetc(c,f);
#endif SETBUF_BUG

    while(((c = getc(f)) != EOF) && (c != (int)('\n'))) {
        if (TAB == c) {
	    do {
	        if (++i > lasti) break;
	        *i = BLANK_CHAR;
	        } while (((i - str) % 8) != 0);
	    }
        else if (++i <= lasti) *i = (char)(c);
    }
 
    if ((c==EOF) && (int)(i==str)) {
        *str = 0;
#ifdef DEBUGV
        write(2,"Crdetab(EOF):\n",14);
#endif DEBUGV
        return(END_OF_FILE);
    }
    if (i>lasti) {
        *str = MAX_STRING_LENGTH-1;
#ifdef DEBUGV
        write(2,"Crdetab(OVF):",13);
	write(2,str+1,(int)(*str));
	write(2,"\n",1);
#endif DEBUGV
	return(OVERFLOW);
    }
    *str = i - str;
#ifdef DEBUGV
    write(2,"Crdetab(OK):",12);
    write(2,str+1,(int)(*str));
    write(2,"\n",1);
#endif DEBUGV
    return(SUCCESS);
}	
#ifdef PC_AT
asm("crdetab: .globl crdetab");
asm("	jump @_crdetab");
#endif


static PBOOLEAN
_creset(fi, logical, name, bufsiz)
    /* if name (pascal xtring) has >0 length then open that named file,
       else open the logical file (real name being the value of the
       environment variable given by pascal ALPHA logical.  Return
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *name;                /* file name (pascal xtring) */
    char *logical;             /* logical file name (alpha) */
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    char cname_buffer[MAX_STRING_LENGTH];
    char lname_buffer[MAX_STRING_LENGTH];
    char *cname=0, *lname=0;               /* C string for final name of file */
    char *getenv();
    fprintf(stdout,"In creset cname %s lname %s\n", name, logical);

    if ((bufsiz<BUFSIZ)&&(bufsiz!=0)) {
        sprintf(cname,"creset: buffer size must be 0 or at least %d (not %d)\n",
	              BUFSIZ,bufsiz);
	write(2,cname,strlen(cname));
	return(-1);
	}

#ifdef SETBUF_BUG
    /* be able to catch the setbuf hiccups! */
    {
        register char *i;
        for (i=fi->buffer;(i<fi->buffer+bufsiz);++i) *i=0;
	}
#endif SETBUF_BUG

    if (*name) {
        xtring_to_cstring(cname_buffer, name);
	cname = cname_buffer;
        } else cname = 0;
    if (!cname) {
        alpha_to_cstring(lname_buffer, logical);
    	lname = lname_buffer;
        if(!(cname = getenv(lname_buffer))) cname = lname_buffer;
    }
#ifdef DEBUG
    write(2,"C opening file ", 15);
    write(2,cname,strlen(cname));
    write(2,"\n",1);
#endif DEBUG

    fi->f=fopen(cname, "r");

#ifdef DEBUG
    if (fi->f==NULL) write(2,"open failed\n",13);
    else write(2,"open succeeded\n",16);
#endif DEBUG
    if ((fi->f)!=NULL) setbuf(fi->f,bufsiz==0?NULL:fi->buffer);
    return ((fi->f)==NULL) ? PFALSE : PTRUE;
}
#ifdef PC_AT
asm("creset: .globl creset");
asm("	jump @_creset");
#endif PC_AT


PBOOLEAN
#ifdef REVERSE
creset(bufsiz, name, logical, fi)
#else
creset(fi, logical, name, bufsiz)
#endif
    /* if name (pascal xtring) has >0 length then open that named file,
       else open the logical file (real name being the value of the
       environment variable given by pascal ALPHA logical.  Return
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *name;                /* file name (pascal xtring) */
    char *logical;             /* logical file name (alpha) */
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    return CRESET(fi, logical, name, bufsiz);
}


static PBOOLEAN
_cfclose(fi)
    /* close the file f, returning boolean value for success or failure */
    struct cfile *fi;
{
    int val;

    val = (fclose(fi->f) == -1) ? PFALSE : PTRUE;
#ifdef FCLOSE_BUG
    fi->f->_base = NULL;  /* because fclose is broken (it should do this) */
#endif FCLOSE_BUG
    if (fi->f->_base) write(2, "fclose didn't NULL the buffer !!!\n", 34);
    return val;
}
#ifdef PC_AT
asm("cfclose: .globl cfclose");
asm("	jump @_cfclose");
#endif PC_AT


PBOOLEAN
cfclose(fi)
    /* close the file f, returning boolean value for success or failure */
    struct cfile *fi;
{
    return CFCLOSE(fi);
}


PBOOLEAN
ceof(fi)
    /* return TRUE if at end of file */
    struct cfile *fi;
{
    int c;

#ifdef SETBUF_BUG
    /* check for preceeding 0's from setbuf UNIX bug */
    while((c=getc(fi->f))==0) ;
    ungetc(c,fi->f);
#endif SETBUF_BUG
    c=getc(fi->f);
    ungetc(c,fi->f);
#ifdef DEBUGV
    if (c==EOF) write(2, "Ceof: TRUE (returns 0)\n",23);
    else write(2, "Ceof: FALSE (returns 1)\n",24);
#endif DEBUGV
    return (c==EOF) ? PTRUE : PFALSE;
}
#ifdef PC_AT
asm("ceof: .globl ceof");
asm("	jump @_ceof");
#endif PC_AT


PBOOLEAN
ceoln(fi)
    /* return TRUE if at end of line (empty line) or end of file. */
    struct cfile *fi;
{
    int c;

#ifdef SETBUF_BUG
    /* check for preceeding 0's from setbuf UNIX bug */
    while((c=getc(fi->f))==0) ;
    ungetc(c,fi->f);
#endif SETBUF_BUG
    c=getc(fi->f);
    ungetc(c,fi->f);
#ifdef DEBUGV
    if (c==EOF||c=='n') write(2, "Ceoln: TRUE (returns 0)\n",24);
    else write(2, "Ceoln: FALSE (returns 1)\n",25);
#endif DEBUGV
    return ((c=='\n')||(c==EOF)) ? PTRUE : PFALSE;
}
#ifdef PC_AT
asm("ceoln: .globl ceoln");
asm("	jump @_ceoln");
#endif PC_AT


PBOOLEAN
crewrite(fi, realname, logname, bufsiz)
    /* if realname (pascal xtring) has >0 length then open that named file.
       0 if successful, 1 otherwise. */
    int bufsiz;                /* size of buffer at fi->buffer */
    char *realname;            /* file name (pascal xtring) */
    char *logname;             /* logical name (pascal alfa, not used) */
    struct cfile *fi;          /* space for saving *FILE and buffer */
{
    char name_buffer[MAX_STRING_LENGTH];
    char *cname;               /* C string for final name of file */

    if ((bufsiz<BUFSIZ)&&(bufsiz!=0)) {
        sprintf(cname,"creset: buffer size must be 0 or at least %d (not %d)\n",
	              BUFSIZ,bufsiz);
	write(2,cname,strlen(cname));
	return(1);
	}

#ifdef SETBUF_BUG
    /* be able to catch the setbuf hiccups! */
    {
        register char *i;
        for (i=fi->buffer;(i<fi->buffer+bufsiz);++i) *i=0;
	}
#endif SETBUF_BUG

    if (*realname) {
	strcpy(name_buffer, realname);
	cname = name_buffer;
        }

#ifdef DEBUG
    write(2,"C opening file from crewrite ", 30);
    write(2,cname,strlen(cname));
    write(2,"\n",1);
#endif DEBUG

    if (*cname) fi->f=fopen(cname,"w");

#ifdef DEBUG
    if (fi->f==NULL) write(2,"open failed for crewrite\n",25);
    else write(2,"open succeeded for crewrite\n",28);
#endif DEBUG
    if ((fi->f)!=NULL) setbuf(fi->f,bufsiz==0?NULL:fi->buffer);
    return ((fi->f)==NULL) ? PFALSE : PTRUE;
}

#endif UNIX
