type
{----------------------------------------------------------------------}
{ The following types are used to construct AVL (height-balanced       }
{ binary) trees.  An AVL record contains all of the tree maintenance   }
{ fields and an field which points to the object entered in the tree.  }
{ The AVL_OBJECT_PTR can point to any 1 of a list of objects.  It      }
{ also can (using conditional complilation mechanism) contain a TAG    }
{ field which can remember what kind of object is presumed to be       }
{ represented.  This allows a run-time type checking to be performed   }
{ within the avl_compare function.   The BALANCE_FACTOR field of an    }
{ AVL keeps track of the difference between the left subtree of the    }
{ node and the right subtree of the node.  As long as the tree is      }
{ balanced, these heights can never differ by more than 1, so an       }
{ enumerated type is used.                                             }
{----------------------------------------------------------------------}
  balance_factor_type = (LEFT_HEAVY_BF, EVEN_BF, RIGHT_HEAVY_BF);
  avl_type = (AVL_COMPLEMENTED_ACTUAL);

  avl_object_ptr = record
    case
#if AVLDEBUG
        tag:                                          
#endif
              avl_type of
      AVL_COMPLEMENTED_ACTUAL: 
        (complemented_actual: signal_definition_ptr);
  end;

  avl_ptr = ^avl;
  avl = record
    left_child: avl_ptr;
    right_child: avl_ptr;
    balance_factor: balance_factor_type;
    object: avl_object_ptr;
  end;

