#if VAX
procedure sleep(BYVALUE seconds: integer); external;


function decnet_open_hack(var fab : FAB$TYPE; var rab : RAB$TYPE) : longint;
    { Implement additional actions to be performed upon opening the
      files for write or (especially) read/write over DECNET.
      Also -- check the value of umask (setable by C library calls)
      and use that to determine the protection to use when creating
      new files }
  type
    xab_ptr = ^XAB$TYPE;
  var 
    status : longint;
    xab: xab_ptr;
    umask_val: integer;
    found: boolean;


  function vms_prot(unix_code: integer): integer;
    { given a (3 bit) UNIX code for the permissions for one user class,
      return the corresponding (4 bit) VMS code (with the delete value
      matching the write value).  (Only the lower 3 bits of unix_code are
      examined -- rest can be garbage.)  Higher-order bits of returned
      value are always 0. }
    var
      vprot: integer; { return value }
  begin
    if odd(unix_code) then vprot := XAB$M_NOEXE
    else vprot := 0;
    unix_code := unix_code div 2;
    if odd(unix_code) then vprot := vprot + XAB$M_NOWRITE + XAB$M_NODEL;
    unix_code := unix_code div 2;
    if odd(unix_code) then vprot := vprot + XAB$M_NOREAD;
    vms_prot := vprot;
  end { vms_prot } ;


begin { decnet_open_hack }
  fab.FAB$V_SQO := FALSE;
  status := $OPEN(fab);
  if (not odd(status)) and (status <> RMS$_FLK) and (status <> RMS$_PRV) then
    begin
      xab := (fab.FAB$L_XAB)::xab_ptr;  found := FALSE;

      { Find or create the XAB that determines the protection }

      while (xab <> NIL) and not found do
        if xab^.XAB$B_COD = XAB$C_PRO then found := TRUE
	else xab := (xab^.XAB$L_NXT)::xab_ptr;

      if not found then
        begin
	  new(xab);
	  xab^ := ZERO;
	  xab^.XAB$B_COD := XAB$C_PRO;
          xab^.XAB$B_BLN := XAB$C_PROLEN;
          xab^.XAB$L_NXT := fab.FAB$L_XAB;
	  fab.FAB$L_XAB := xab::unsigned;
	end;
	
      { Set it according to the current "umask" -- this makes calls
        to umask stick on files created here }

      umask_val := umask(0);  if umask(umask_val) = 0 then ;
      xab^.XAB$V_SYS := vms_prot(umask_val div (8*8));
      xab^.XAB$V_OWN := xab^.XAB$V_SYS;
      xab^.XAB$V_GRP := vms_prot(umask_val div 8);
      xab^.XAB$V_WLD := vms_prot(umask_val);

      { now create the file and clean up }

      status := $CREATE(fab);

      if not found then
        begin
	  fab.FAB$L_XAB := xab^.XAB$L_NXT;
	  dispose(xab);
	end;
    end;
  if odd(status) then $CONNECT(rab);
  RMS_error_code := status;            { save for collision checking }
  decnet_open_hack := status;
end { decnet_open_hack } ;


procedure vaxname(filename: xtring; var name: VaxString);
  { returns the filename in VAX readable form }
  var
    min: VaxString_index;
    index: VaxString_index;
begin
  if ord(filename^[0]) < VAXSTRING_LENGTH then min := ord(filename^[0])
  else min := VAXSTRING_LENGTH;
  for index := 1 to min do name[index] := filename^[index];
  for index := min+1 to VAXSTRING_LENGTH do name[index] := ' ';
end { vaxname };


function reset_vms_file(var f: inputfile; filename: xtring; 
                        lock: boolean): longint;
  { reset a named file (VAX-ONLY), returning the correct status code.  If
    lock, open exclusively. }
  var
    name: packed array [1..255] of char;
    min: 1..255;                        { minimum length of name & string }
    index: 1..256;                      { index into the name }
    code: longint;                      { return code from open - 370 }
    first_time: boolean;                { TRUE for first attempt at open }


  function locked_by_another_user(filename: xtring; 
                                   pascal_code: longint): boolean;
    { Return TRUE iff open failed because the file was open to another
      user. }
  begin
    if pascal_code <= 0 then locked_by_another_user := FALSE
    else locked_by_another_user := RMS_error_code = RMS$_FLK;
  end { locked_by_another_user } ;


begin { reset_vms_file }
  if filename <> nullstring then
    begin
      if ord(filename^[0]) < 255 then min := ord(filename^[0])
                                 else min := 255;
      for index := 1 to min do name[index] := filename^[index];
      for index := min+1 to 255 do name[index] := ' ';
    end
  else if lock then
    begin
      assert(0);
      writeln(CmpLog, ' Can''t open a logical file with locking!!!');
      lock := FALSE;
    end;

  first_time := TRUE;
  if lock then
    repeat
      if first_time then first_time := FALSE
      else
        begin
	  if debug_22 then writeln(Outfile, 'File locked -- sleeping');
	  sleep(5);
	  if debug_22 then writeln(Outfile, 'Awake');
	end;
      open(f, name, HISTORY := OLD,
                    USER_ACTION := decnet_open_hack,
                    ERROR := CONTINUE);
      code := status(f);
    until not locked_by_another_user(filename, code)
  else 
    begin
      if filename = nullstring then
        open(f, HISTORY := READONLY, ERROR := CONTINUE)
      else
        open(f, name, HISTORY := READONLY, ERROR := CONTINUE);
      code := status(f);
    end;

  if code <= 0 then
    begin
      reset(f, ERROR := CONTINUE);
      code := status(f);
    end;
  reset_vms_file := code;
end { reset_vms_file } ;


#endif VAX
