(**)     { ------- reserved text macro routines ------- }


procedure add_global_text_macro(name: name_ptr; definition: xtring;
                                  kind: name_types { RESERVED or UNRESERVED or
                                                     PERMANENT });
    { add the given name to the name table and check its type.  If
      PERMANENT, then also make it RESERVED. }
begin
  if RESERVED in name^.kind then
    error(46 { this TM cannot be redefined })
  else
    begin
      if kind = PERMANENT then 
        name^.kind := name^.kind + [PERMANENT,RESERVED]
      else name^.kind := name^.kind + [kind];
      name^.definition := definition;
    end;
end { add_global_text_macro } ;
   

procedure PREDS_init_global_text_macros;
  { init table of reserved/unreserved global text macro names }
  const
    TM_DEF_LENGTH = 17;

  type
    TM_def_range = 1..TM_DEF_LENGTH;
    TM_def_type = packed array [TM_def_range] of char;

  var
    current_text_macro_file: file_list_ptr;  { current file in the file list }
    
      
  procedure add_standard_TM(name: alpha; def: TM_def_type);
    { create a reserved global text macro of the given name and definition }
    var
      i,                         { index into def }
      pos: TM_def_range;         { length of the definition string }
      hash_name: name_ptr;       { name "hashed" into identifier }
      temp,                      { temp "work" string }
      TM_def: xtring;            { definition of the TM as a string }
  begin
    hash_name := enter_name(name);

    pos := TM_DEF_LENGTH;
    while def[pos] = ' ' do pos := pos - 1;

    create_a_string(temp, pos);
    for i := 1 to pos do temp^[i] := def[i];

    TM_def := enter_and_release_string(temp);

    add_global_text_macro(hash_name, TM_def, PERMANENT);
  end { add_standard_TM } ;


  procedure process_text_macros(file_name: xtring);
    { process the text macros in the given file }
    var
      TM_name: name_ptr;     { name of the current text macro }
      TM_def: xtring;        { definition of the current text macro }
      kind: name_types;      { RESERVED or UNRESERVED }
  begin
    if not open_a_file(file_name, STANDARD_FILE) then
      begin
        error(209 { cannot open text macro file });
        error_dump_file_name(file_name);
      end
    else
      if get_file_type <> SPECIAL_TEXT_MACROS then
        begin
          error(9 { wrong file });
          error_dump_file_name(file_name);

          if not close_parse_file(STANDARD_FILE) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;
        end
      else
        begin
          { set up the current parse environment }

          push_error_info;
          current_file_name := file_name;

          repeat
            if sy <> IDENT then
              begin  error(1 { expected ident });  skip([SEMI,PERIOD]);  end
            else
              begin
                TM_name := id.name;
                insymbol;   { eat the text macro ID }

                if sy = EQUAL then insymbol else error(2 { expected = });
                if sy <> STRINGS then
                  begin
                    error(33 { expected string });  skip([SEMI,PERIOD]);
                  end
                else
                  begin
                    TM_def := lex_string;
                    insymbol;    { eat the text macro definition string }

                    if sy = IDENT then
                      begin
                        if id.name = RESERVED_key_name then
                          begin
                            kind := RESERVED;  insymbol;
                          end
                        else if id.name = UNRESERVED_key_name then
                          begin
                            kind := UNRESERVED; insymbol;
                          end
                        else
                          kind := RESERVED { error message follows - expect ; }
                      end
                    else kind := RESERVED;

                    add_global_text_macro(TM_name, TM_def, kind);
                  end;
              end;
            if sy = SEMI then insymbol else error(12 { expected ; });
          until sy <> IDENT;

          if sy = ENDSY then insymbol else error(40 { expected END });
          if sy <> PERIOD then error(37 { expected . });

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;

          pop_error_info;
        end;
  end { process_text_macros } ;


  procedure welcome;
    { display a message to indicate start of the directory parse }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst, ' *  Reading text macro definitions  *');
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Reading text macro definitions.');
    writeln(CmpLog);  writeln(CmpLog, ' Reading text macro definitions.');
  end { welcome } ;


begin { PREDS_init_global_text_macros }
  welcome;

 add_standard_TM('R               ', 'REP="%1"         '); { replication }
 add_standard_TM('G               ', 'SCOPE="GLOBAL"   '); { global signal }
 add_standard_TM('L               ', 'SCOPE="LOCAL"    '); { local signal }
 add_standard_TM('I               ', 'SCOPE="INTERFACE"'); { interface sig }
 add_standard_TM('NWC             ', 'NOWIDTH=""       '); { width check }
 add_standard_TM('NBC             ', 'NOBUBBLE=""      '); { bubble check }
 add_standard_TM('NAC             ', 'NOASSERT=""      '); { inherit assert }
 add_standard_TM('B               ', 'BUBBLED=""       '); { pin has bubble }
 add_standard_TM('TRUE            ', '1                '); { TRUE constant }
 add_standard_TM('FALSE           ', '0                '); { FALSE constant }

  { read in other standard text macros }

  allowed_key_words := directory_keysys;

 { read standard text macros from the Valid supplied file }

 if standard_text_macro_file <> nullstring then
   process_text_macros(standard_text_macro_file); 

   { read standard text macros from the user supplied file }

 current_text_macro_file := text_macro_file;
 while current_text_macro_file <> NIL do
   begin
     process_text_macros(current_text_macro_file^.file_name);
     current_text_macro_file := current_text_macro_file^.next;
   end;

 allowed_key_words := [];
  write(monitor, '   Text macro definitions read ');
  write(CmpLog, '   Text macro definitions read ');
  exec_time(last_elapsed_time, last_CPU_time, TRUE);
end { PREDS_init_global_text_macros } ;
      

