
function resolve_instance_of_parameter(formal_sig_def: signal_definition_ptr;
                                       formal_SD: signal_descriptor_ptr;
                                       var uses_NAC: boolean):
                                                            propertied_CS_ptr;
  { Procedure to coerce an instance of a parameter to its "real" actual:

    formal_sig_def  -- sig def of the formal we want to coerce to real value
    formal_SD       -- specifies the bits of the formal

    We return a concatenated signal list of the real value to which the formal
    is bound. The PCS we return has properties associated with each element
    of the PCS sucked off of the bit properties list on the formal.

    There are several varieties of error recovery in this routine:

    If the whole formal is undefined, a new signal of appropriate width,
    and with local scope is synthesized and returned.
  
    If some bits of the formal do not resolve, then these bits are
    replace with a "NC".

    If some of the bits of the formal resolve to "NC",  we try to "de-NC" it.
    We do this by looking at the actuals synonyms (if any) for a non-NC name.
    If we find one, great, otherwise the NC is replaced with a new signal
    of appropriate width and with local scope.

    If the formal resolved uses the NAC property, return uses_NAC TRUE. }



  var clean_SD,                          { SD to clean out temp_SD in loop }
      temp_SD:  signal_descriptor_ptr;   { SD to SI-ify and glue onto PCS  }
      PCS:      propertied_CS_ptr;       { returned PCS   }
      last_looked_up_formal,             { these two goodies are tell if 2 }
      looked_up_formal,                  { actual bits came from different }
                                         { formals for property copying    }
      last_looked_up_actual,             { used to get scope for temp_sd   }
      looked_up_actual: signal_instance_ptr;{ SI containing the bit of the }
      looked_up_formal_actual:           { pt on fp_ap list last bit was   }
                        formal_actual_ptr;
                                         { actual being processed          }
      formal_bits: subscript_ptr;        { subscripts of formal to look up }
      actual_bit,                        { bit of actual corresponding to  }
                                         { the formal bit looked up        }
      times_through_loop: bit_range;     { number of bits to resolve, = 0
                                           if quick resolve works or error }
      direction: -1..1;                  { loop increment }
      props: property_ptr;
      t,
      i: bit_range;
      lookup_succeeded,
      resolving_simple_subrange,         { => formal_SD is simple subrange }
      first_time_through_loop: boolean;  { what it says   }

      own_SI: signal_instance_ptr;       { state variables used by  }
      own_PCS: propertied_CS_ptr;        { get_bit_of_PCS }
      own_n, 
      own_t:  natural_number;


  procedure init;
    { initialize various random local variables }
  begin
    if (formal_sig_def^.kind = VECTOR) AND (formal_SD^.kind = SINGLE) then
      with formal_SD^ do 
        begin
          { looking up an "whole" formal, but referencing
            it by name only fix up its subscript }

          kind := VECTOR;
          bit_subscript := NIL;  new_subscript(bit_subscript);
          bit_subscript^.left_index := formal_sig_def^.left_index;
          bit_subscript^.right_index := formal_sig_def^.right_index;
        end;

    formal_bits := formal_SD^.bit_subscript;
    if formal_bits <> NIL then
      resolving_simple_subrange := (formal_bits^.next = NIL)
    else
      resolving_simple_subrange := FALSE;
    
    PCS := NIL;
    temp_SD := NIL;
    new_signal_descriptor(temp_SD);
    clean_SD := NIL;
    new_signal_descriptor(clean_SD);

    looked_up_actual := NIL;
    looked_up_formal := NIL;
    last_looked_up_actual := NIL;
    last_looked_up_formal := NIL;
    looked_up_formal_actual := NIL;

    actual_bit := 0;
    times_through_loop := 0;
    first_time_through_loop := TRUE;

    own_SI := NIL;
    own_PCS := NIL;
    own_n := 0;
    own_t := 0;
  end { init } ;


  procedure debug_dump;
    begin
      write(outfile, '      temp_SD: ');
           dump_signal_descriptor(outfile, temp_SD);
      write(outfile, '      looked_up_actual: ');
           dump_signal_instance(outfile, looked_up_actual);
      write(outfile, '      last_looked_up_actual: ');
           dump_signal_instance(outfile, last_looked_up_actual);
      write(outfile, '      looked_up_formal: ');
           dump_signal_instance(outfile, looked_up_formal);
      write(outfile, '      last_looked_up_formal: ');
           dump_signal_instance(outfile, last_looked_up_formal);
      write(outfile, '      PCS: '); dump_PCS(outfile, PCS);
    end { debug_dump } ;


  function get_bit_of_PCS(PCS: propertied_CS_ptr;
                          n: bit_range;
                     var SI: signal_instance_ptr;
                      var b: bit_range): boolean;

  { -- Takes a concatenated signal list and a number "n" (an ordinal)
  returns a pointer to the signal instance containing the "n"th bit and the
  bit number (as "var" parameters). The function is TRUE only if it found the
  bit. State is kept so that looking up successive bits of a PCS is fast. -- }
  
    var CP: PCS_pointer;    { current position in list of bits PCS represents}
         t: natural_number; { size of the PCS elements being searched        }
       ans: boolean;        { return value }
  begin
    ans := FALSE;   b := 0;
     
    if debug_4 then 
      begin
        writeln(OutFile, ' Entered get_bit_of_PCS with: ');
        write  (outfile, ' PCS = '); dump_PCS(outfile, PCS); writeln(outfile);
        writeln(outfile, '   n = ', n:1); 
        write  (outfile, '  SI = ');
        dump_signal_instance(outfile, SI);
        writeln(outfile, '   b = ', b:1);         
      end;

    if PCS = NIL then
      assert(146 {oops!})
    else
      if (n < 1) then
        begin
          assert(145 {PCS is too short});
          write(CmpLog, 'Tried to find: ', n:1, ' in ');
          dump_PCS(CmpLog, PCS);
        end
      else
        begin
          if PCS = own_PCS then     { same actual as last time       }
            if n = (own_n + 1) then { next bit in order as last time }
              if SI = own_SI then   { same instance of actual as last time }
                if n <= own_t then  { actual has enough bits in it   } 
                  begin
                    if debug_4 then
                      writeln(outfile, ' Doing fast get_bit ... ');
                    ans := nth_bit_subscript(n, SI^.bit_subscript);
                    b := n;
                    { set things up for next time we are called }
                    own_t := own_t - 1 ;
                    if own_t <> 0 then own_n := n else own_PCS := NIL;
                  end
                else { could use 'own_CP' to skip to next SI, later };
  
          if NOT ans then
            begin
              init_PCS_pointer(CP, PCS);    SI := NIL;
              t :=  size_of_signal_instance(CP.PCS^.instance);
              while (n > t) AND (CP.PCS <> NIL) do
                begin
                  n:= n - t;    advance_PCS_pointer(CP);
                  if CP.PCS <> NIL then
                    t :=  size_of_signal_instance(CP.PCS^.instance);
                end;
              if CP.PCS = NIL then
                begin
                  assert(61 {PCS is too short});
                  write(CmpLog, 'Tried to find: ', n:1, ' in ');
                  dump_PCS(CmpLog, PCS);
                end
              else
                begin
                  ans := nth_bit_subscript(n, CP.PCS^.instance^.bit_subscript);
                  SI := CP.PCS^.instance;
                  b := n;
                  { set things up for next time we are called }
                  own_PCS := PCS; own_SI := SI; own_n := n; own_t := t;
                end { if CP.PCS ... } ;
            end { if NOT ans (quick lookup failed) };
        end { else };

    get_bit_of_PCS := ans;

    if debug_4 then 
      begin
        writeln(OutFile, ' Exiting get_bit_of_PCS (', ans:5, ') with: ');
        write  (outfile, ' PCS = '); dump_PCS(outfile, PCS); writeln(outfile);
        writeln(outfile, '   n = ', n:1); 
        write  (outfile, '  SI = ');
        dump_signal_instance(outfile, SI);
        writeln(outfile, '   b = ', b:1);         
      end;
  end { get_bit_of_PCS } ;


  function find_actual(formal_sig_def: signal_definition_ptr;
                       i: bit_range;
               var fp_ap: formal_actual_ptr;
               var   FSI: signal_instance_ptr;
               var    SI: signal_instance_ptr;
               var     b: bit_range):boolean;
  { -- FORMAL_SIG_DEF is the formal to find.  I (a cardinal) is the bit
       of the formal.  SI is the instance to be returned.  B is the bit
       of the instance (SI) that maps to I.

       Tries to find the actual that corresponds to the "i" bit of FSD. If
       found, returns true and the sig instance of the actual and the bit
       within the actual. e.g if FSD = Y<0,3,5,6,15>,  i= 6, and Y<0..15>
       is bound to Q<0..4>:Z<89,76>, find_actual will return with SI
       instance pointing to Z's and b will equal 89, the value of
       find_actual will be a pointer to the formal (signal instance) where
       the actual was found.                                  

       During lookup, if we resolve to an NC signal, we remember the
       return value in "saved" variables and try to find another name for
       the formal by looking on the actuals synonym list.                 -- }

    var
      next_fp_ap: formal_actual_ptr;{ formal/actual list of def's mtree node }
      formal: signal_instance_ptr;  {  next possible match for formal        }
      found,                        { => found formal we are looking for     }
      found_name: boolean;          { => found formal w/ correct name only   }


  procedure find_non_NC_actual_bit;
    { find bit in actual that is known to not be NC }
    var
      found: boolean;
      next_actual: actual_list_ptr;
  begin
    next_actual :=  next_fp_ap^.actual_parameter;
    found := get_bit_of_PCS(next_actual^.signal, i, SI, b);
    while (next_actual^.next <> NIL) AND is_NC_instance(SI) do
      begin
        next_actual := next_actual^.next;
        found := get_bit_of_PCS(next_actual^.signal, i, SI, b)
      end;

    if next_fp_ap^.uses_NAC then uses_NAC := TRUE;
  end { find_non_NC_actual_bit } ;


  begin { find_actual }
    find_actual := FALSE;

    found := FALSE;
    found_name := FALSE;
    FSI := NIL;
    SI := NIL;
    b := 0;
    fp_ap := NIL;
  
    if formal_sig_def <> NIL then
      begin
        next_fp_ap := formal_sig_def^.node^.params;
  
        if debug_4 then
          begin
            writeln(outfile, 'Entered find_actual with: ');
            write(outfile,   '   sig_def = ');
            dump_signal_definition(outfile, formal_sig_def);
            writeln(outfile, '         i = ', i:1);
          end;      
  
	while (next_fp_ap <> NIL) AND NOT found do
	  begin
	    formal := next_fp_ap^.formal_parameter;

	    if (formal^.defined_by = formal_sig_def) then
	      begin
		found_name := TRUE; 
		case formal^.defined_by^.kind of
		  SINGLE: found := TRUE;
  
		  VECTOR: if find_subscript(i, formal^.bit_subscript) then
			    found:=TRUE;
  
		  UNDEFINED: begin
			       assert(94 { attempt to reference a bit of
					   formal with undefined width });
			       write(CmpLog, '      signal instance = ');
			       dump_signal_instance(CmpLog, formal);
			       write(CmpLog,'    signal definition = ');
			       dump_signal_definition(CmpLog,
						      formal_sig_def);
			       writeln(CmpLog,',  bit = ',b:1, ')');
			     end;
		end { case };
	      end;
  
	    if NOT found then
	      next_fp_ap := next_fp_ap^.next;
	  end { while } ;
  
	{ find position of bit name i in the formal and  find the 
	  corresponding bit in the formal's actual }
  
	if NOT found_name then
	  begin
	    assert(85 { undefined formal name parameter });
	    dump_signal_definition(CmpLog, formal_sig_def);
	  end
	else if not found then
	  begin
	    error(146 { undefined bit in formal });
	    error_dump_macro_def(current_mtree_node^.macro);
	    error_dump_formal_sig_def(formal_sig_def);
	    error_dump_signal_descriptor(formal_SD);

	    error_dump_indent(indent);
	    error_dump_alpha('Bit=            ');
	    error_dump_integer(i);
	    error_dump_CRLF;

	    next_fp_ap := NIL;

	    if debug_4 then
	      dump_signal_definition(outfile, formal_sig_def);
	  end
	else if formal_sig_def^.kind = VECTOR then    
	  if NOT position_of_bit_in_subscript(i,
					      formal^.bit_subscript) then
	    begin
	      error(146 { undefined bit in formal });
	      error_dump_macro_def(current_mtree_node^.macro);
	      error_dump_formal_sig_def(formal_sig_def);
	      error_dump_signal_descriptor(formal_SD);

	      error_dump_indent(indent);
	      error_dump_alpha('Bit=            ');
	      error_dump_integer(i);
	      error_dump_CRLF;

	      next_fp_ap := NIL;

	      found := FALSE;

	      if debug_4 then
		dump_signal_definition(outfile, formal_sig_def);
	    end
	  else
	    find_non_NC_actual_bit
	else
	  find_non_NC_actual_bit;

	fp_ap := next_fp_ap;
	if fp_ap <> NIL then FSI := fp_ap^.formal_parameter

      end { if formal_sigdef <> NIL ... } ;
  
    find_actual := found;
  
    if debug_4 then
      begin
        writeln(outfile, 'Exited find_actual (= ', found, ') with: ');

        write(outfile,   '  SI = ');
        dump_signal_instance(outfile, SI);

        writeln(outfile, '  b = ', b:1);
        write(outfile,   '  formal = ');
        dump_signal_instance(outfile,formal);

        write(outfile,   '  formal def = ');
        dump_signal_definition(outfile, formal^.defined_by);
        writeln(outfile);
      end;      
  end { find_actual } ;


  procedure build_NC_signal_descriptor(var SD: signal_descriptor_ptr);
    { This is only good inside this function because of a KLUDGEY HACK -
      if we try to resolve a formal with undefined width a special NC signal
      is cons'ed up.  The special NC is an NC vector of undefined width. }
  begin
    SD^ := clean_SD^;

    SD^.signal_name := unique_NC_name;
    SD^.kind := VECTOR;
    if formal_sig_def^.kind = UNDEFINED then
      SD^.kind := UNDEFINED;

    SD^.is_const := FALSE;
    if SD^.kind = VECTOR then
      add_subscript(SD^.bit_subscript,0);
  end { build_NC_signal_descriptor } ;


  procedure append_PIN_properties_to_PCS(PCS: propertied_CS_ptr;
                                  formal_actual_pair: formal_actual_ptr);
    { gather properties from the given pin (FORMAL_ACTUAL_PAIR) and attach
      to the property lists of the given PCS. }
    var
      prop,                            { current property to be copied }
      prop_list: property_ptr;         { list of properties to be copied }
      current_PCS: propertied_CS_ptr;  { current element of the PCS }
  begin
    prop_list := gather_pin_properties(formal_actual_pair, -1);

    current_PCS := PCS;
    while current_PCS <> NIL do
      begin
        prop := prop_list;
        while prop <> NIL do
          begin
            if INHERIT_PIN IN prop^.name^.kind then
              add_to_prop_list(current_PCS^.properties,
                               prop^.name, prop^.text)
            else
              check_and_add_to_prop_list(current_PCS^.properties,
                                         prop^.name, prop^.text);

            prop := prop^.next;
          end;

        current_PCS := current_PCS^.next;
      end;
  end { append_PIN_properties_to_PCS } ;


  procedure append_next_PCS_element;
    { Adds next SI onto return CS and
      cleans up some local variables. This routine is used when doing
      a bit by bit resolution and the looked up bit can not be used
      to augment the next CS element i.e. a "colon is necessary" }
  begin
    if last_looked_up_actual <> NIL then
      append_SD_onto_PCS(temp_SD, last_looked_up_actual^.defined_by, PCS)
    else
      append_SD_onto_PCS(temp_SD, NIL, PCS);

    temp_SD^ := clean_SD^;
    copy_a_bit_of_SI_to_SD(temp_SD, looked_up_actual, actual_bit);

    temp_SD^.properties := gather_pin_properties(looked_up_formal_actual, t);

    last_looked_up_actual := looked_up_actual;
    last_looked_up_formal := looked_up_formal;
  end { append_next_PCS_element } ;


  function quick_resolve(formal_sig_def:signal_definition_ptr;
                         formal_SD: signal_descriptor_ptr): boolean;
    { This kludge tests for some special cases where resolving a formal
      can be done without a bit-by-bit lookup. Returns TRUE if formal
      was resolved. A formal can be quickly resolved if:

      the formal is a SCALAR    or

      the formal is a vector and an identical instance of it occurs on
      the formal actual list of the father }
    var
      formal_actual_pair: formal_actual_ptr;
      formal: signal_instance_ptr;
      resolve_quickly,
      found_name,
      found: boolean;
  begin
    if debug_4 then
      begin
        writeln(outfile, 'Entered quick_resolve with: ');
        write(outfile, ' formal_sig_def=');
        dump_signal_definition(outfile, formal_sig_def);
        write(outfile, ' formal_SD=');
        dump_signal_descriptor(outfile, formal_SD);
      end;

    number_interfaces_resolved := number_interfaces_resolved + 1;

    quick_resolve := FALSE;  found := FALSE;  found_name := FALSE;

    if (formal_bits <> NIL) AND (formal_sig_def^.kind = SINGLE) then
      begin
        assert(63 {formal is a scalar - no bits to look up});
        write(CmpLog, ' formal signal def = ');
        dump_signal_definition(CmpLog, formal_sig_def);
        write(CmpLog, ' formal signal desc = ');
        dump_signal_descriptor(CmpLog, formal_SD);

        { set this guy to NIL to short circuit body }
        formal_actual_pair := NIL;
      end
    else
      formal_actual_pair := formal_sig_def^.node^.params;

    while (formal_actual_pair <> NIL) AND NOT found do
      begin
        formal := formal_actual_pair^.formal_parameter;

        if (formal^.defined_by = formal_sig_def) then
          found_name := TRUE;

        if found_name then
          begin
            { The lookup succeeded. I can resolve the formal descriptor
              quickly if:

              a) the formal has undefined width -- simply return the
                 entire actual.
              or

              b) the actual contains no NC signals. (If the actual had
                 NC signals they must be replaced with a LOCAL$ signal.)

               AND

                 the properties on the formal, conform to the formal }
 
            found := TRUE; { make sure we do not continue to loop }

            if formal_sig_def^.kind = UNDEFINED then
              resolve_quickly := TRUE
            else
              if no_NC_PCS(formal_actual_pair^.actual_parameter^.signal) then
                begin
                  resolve_quickly := (formal_actual_pair^.properties = NIL);
                  if NOT resolve_quickly then
                    resolve_quickly :=
                             (formal_actual_pair^.properties^.left_index < 0);

                  if NOT resolve_quickly then
                    with formal_actual_pair^.formal_parameter^ do
                      resolve_quickly := 
                            (formal_actual_pair^.properties^.left_index =
                                                    bit_subscript^.left_index)
                                AND
                            (formal_actual_pair^.properties^.right_index =
                                                  bit_subscript^.right_index);
                end
              else
                resolve_quickly := FALSE;

            if resolve_quickly then
              case formal_SD^.kind of
  
                SINGLE:
                    if (formal_sig_def^.kind = SINGLE) OR
                       (formal_sig_def^.kind = UNDEFINED) then
                      begin
                        PCS := copy_PCS(formal_actual_pair^.
                                                    actual_parameter^.signal);
                        append_PIN_properties_to_PCS(PCS, formal_actual_pair);
                      end
                    else
                      assert(90 { init should prevent this } );
  
                VECTOR:
                    if formal_sig_def^.kind = SINGLE then
                      begin
                        error(215 { ref of scalar formal as vector });
                        error_dump_macro_def(formal_sig_def^.node^.macro);
                        error_dump_formal_sig_def(formal_sig_def);
                        error_dump_signal_descriptor(formal_SD);
                      end
                    else
                      if formal_sig_def^.kind = VECTOR then
                        begin
                          if identical_bit_subscripts(formal_bits,
                                                   formal^.bit_subscript) then
                            begin
                              PCS := copy_PCS(
                                formal_actual_pair^.actual_parameter^.signal);
                              append_PIN_properties_to_PCS(PCS,
                                                          formal_actual_pair);
                            end;
                        end
                      else
                        begin
                          assert(91 {oops!});
                          write(CmpLog, ' formal_sig_def: ');
                          dump_signal_definition(CmpLog, formal_sig_def);
                          write(CmpLog, ' formal_SD: ');
                          dump_signal_descriptor(CmpLog,formal_SD);
                        end;
  
                UNDEFINED:
                    begin
                      assert(91{ no can ref bit of undef formal });
                      write(CmpLog, ' formal_sig_def: ');
                      dump_signal_definition(CmpLog,formal_sig_def);
                      write(CmpLog, ' formal_SD: ');
                      dump_signal_descriptor(CmpLog,formal_SD);
                    end;
              end { case };
          end { if found_name ... };

        if found and formal_actual_pair^.uses_NAC then uses_NAC := TRUE;

        formal_actual_pair := formal_actual_pair^.next;
      end { while };

    if NOT found_name then { -- formal is undefined, evaluate bindings flagged
                                the error. To recover, return LOCAL instance
                                with the name of the undefined formal -- }
      begin
        new_propertied_CS(PCS);
        PCS^.instance := fix_weird_formal(formal_sig_def, formal_SD, NIL);
      end;

    quick_resolve := (PCS <> NIL);      { resolved param here !!}

    if (PCS <> NIL) then
      number_quick_resolved := number_quick_resolved + 1;

    if debug_4 then
      begin
        write(outfile, 'Exited quick_resolve with PCS = ');
        dump_PCS(outfile, PCS);
      end;
  end { quick_resolve };
              

  procedure resolution_failure(var PCS: propertied_CS_ptr;
                               var SD: signal_descriptor_ptr);
    { This procedure is called when a formal is being resolved bit by
      bit and a lookup of some bit on the father's formal actual list
      fails. An NC signal is generated and used to stand for the
      missing bit. Being zealous about space efficiency, the procedure
      checks to see if the signal descriptor under construction is
      already an NC signal. If so it simply expands its width by one
      rather than starting a new descriptor. }
  begin
    if debug_4 then
      begin
        writeln(outfile, 'Entered resolution_failure with:');
        dump_PCS(outfile, PCS);
        dump_signal_descriptor(outfile, SD);
      end;

    if is_NC_signal(SD^.signal_name) AND (last_looked_up_actual = NIL) then
      { already working on NC vector, just augment it }
      SD^.bit_subscript^.right_index := SD^.bit_subscript^.right_index+1

    else
      begin
        { add what we got so far, use NC for failed formal }

        if NOT first_time_through_loop then
          begin
            if last_looked_up_actual <> NIL then
              append_SD_onto_PCS(SD, last_looked_up_actual^.defined_by, PCS)
            else
              append_SD_onto_PCS(SD, NIL, PCS);
          end
        else
          first_time_through_loop := FALSE;

        { setting last... to NIL ensures that when ersatz NC signal
          is glued on the PCS it will get a scope of LOCAL }

        last_looked_up_actual := NIL;
        last_looked_up_formal := NIL;
        build_NC_signal_descriptor(SD);
      end { else } ;

    if debug_4 then
      begin
        writeln(outfile, 'Exited resolution_failure with:');

        write(outfile, '  PCS = ');
        dump_PCS(outfile, PCS);

        write(outfile, '  SD = ');
        dump_signal_descriptor(outfile, SD);
      end;
  end { resolution_failure } ;


    procedure cook_up_ersatz_actual;
      { create an NC signal for a formal parameter }
    begin
      if debug_4 then
        begin
          writeln(outfile,'!! Resolved to NC cook up signal !!');
          debug_dump;
        end;

      { build a new signal descriptor with the correct subscript }

      formal_SD^.bit_subscript := NIL; { don't worry, the old 
                                         sub is in formal_bits }
      if formal_SD^.kind = VECTOR then
        add_subscript_element(formal_SD^.bit_subscript, t);

      looked_up_actual := 
        fix_weird_formal(formal_sig_def, formal_SD, looked_up_formal_actual);

      actual_bit := t;

      if formal_SD^.kind = VECTOR then
        begin
          release_subscript(formal_SD^.bit_subscript);
          formal_SD^.bit_subscript := formal_bits;
        end;
    end { cook_up_ersatz_actual } ;


begin { resolve_instance_of_parameter }
  if debug_4 then
    begin
      writeln(outfile, 'Entered resolve_instance_of_parameter with:');
      write(outfile, '  formal_sig_def = ');
      dump_signal_definition(outfile, formal_sig_def);
      write(  outfile, '  bit subscript = ');
      dump_bit_subscript(outfile, formal_SD^.bit_subscript, VECTOR);
      writeln(outfile);
      dump_formal_actual_list(outfile, formal_sig_def^.node^.params);
    end;

  uses_NAC := FALSE;

  if formal_sig_def = NIL then
    begin
      assert(71 {expected a formal that can be looked up});    
      PCS := NIL;
    end
  else
    begin
      init;

      { test for special cases and do the whole job if possible.
        quick_resolve will return TRUE if it de-referenced the formal }

      if NOT quick_resolve(formal_sig_def, formal_SD) then
        if (formal_sig_def^.kind = SINGLE)  AND (formal_bits = NIL) then
          { we are looking up a scalar formal }
          times_through_loop := 1

        else
          if formal_sig_def^.kind = VECTOR then
            times_through_loop := width_of_subscript_list(formal_bits)
          else
            { formal def has undef width once through to build NC signal }
            times_through_loop := 1

      else
        { quick_resolve worked, skip main body }
        times_through_loop := 0;
 
      if resolving_simple_subrange then
        with formal_bits^ do begin
          if left_index > right_index then direction := -1
                                      else direction := 1;
          t := left_index - direction;
        end;

      for i:=1 to times_through_loop do
        begin
          if resolving_simple_subrange then
            t := t + direction
          else
            begin
              t := i;
              lookup_succeeded := nth_bit_subscript(t, formal_bits);
              if NOT lookup_succeeded then
                begin
                  assert(62 { oops! });
                  t := formal_bits^.left_index;
                end;
            end;

          if NOT find_actual(formal_sig_def, t, looked_up_formal_actual,
                             looked_up_formal, looked_up_actual,
                             actual_bit) then
            begin
              { find_actual does detailed error report }

              resolution_failure(PCS, temp_SD);
            end
          else
            begin
              { if pin isn't bound to anything cook up local name for it }

              if is_NC_signal(looked_up_actual^.defined_by^.signal^.name) then
                cook_up_ersatz_actual;

                if debug_4 then
                  begin
                    writeln(outfile,'!!!!! Entering Main Loop !!!!!');
                    debug_dump;
                  end;

              if first_time_through_loop then
                begin
                  { -- build initial signal descriptor and init the
                       "last" variables.                                -- }

                  copy_a_bit_of_SI_to_SD(temp_SD,
                                         looked_up_actual, actual_bit);

                  temp_SD^.properties := 
                            gather_pin_properties(looked_up_formal_actual, t);

                  last_looked_up_actual := looked_up_actual;
                  last_looked_up_formal := looked_up_formal;
                  first_time_through_loop := FALSE;
                end
              else

                { If the just looked up formal matches the last one  try to
                  expand the current signal descriptor. If not, or if we
                  can't expand the descriptor add the next element to the
                  concatenated signal ( ": ..." ). }

                if (last_looked_up_formal = looked_up_formal) AND
                   (last_looked_up_actual = looked_up_actual) then
                  begin
                    props := gather_pin_properties(looked_up_formal_actual, t);

                    if compare_properties(props, temp_SD^.properties)=EQ then
                      if NOT append_bit_to_SD(temp_SD, actual_bit) then
                        append_next_PCS_element
                      else
                        { nuttin }
                    else
                      append_next_PCS_element;
                  end
                else
                  append_next_PCS_element;
  
              if debug_4 then
                begin
                  writeln(outfile,'!!!! After work in main loop !!!!');
                  debug_dump;
                end;
  
            end { else  no lookup errors ... };
        end { for ... };

      if times_through_loop <> 0 then
        if last_looked_up_actual <> NIL then
          append_SD_onto_PCS(temp_SD, last_looked_up_actual^.defined_by, PCS)
        else
          append_SD_onto_PCS(temp_SD, NIL, PCS);

      if debug_4 then
        begin
          writeln(outfile,'!!!!! Goodies on exit from main loop !!!!!');
          debug_dump;
        end;
    end { begin  no argument errors  } ;
 
  replicate_PCS(PCS, formal_SD^.replication_factor);

  release_complete_signal_descriptor(temp_SD);
  release_complete_signal_descriptor(clean_SD);

  resolve_instance_of_parameter := PCS;

  if debug_4 then writeln(outfile, 'Exited resolve_instance_of_parameter');
end { resolve_instance_of_parameter } ;

