(**)     { ------- read a macro page ------------------------- }


function read_macro_page(macro_name: xtring): macro_def_ptr;
  { read the current page of the macro into a macro definition.
    Return a pointer to the descriptor of the macro definition. }
  var
    MDP: macro_def_ptr;               { macro def to be returned }


  function get_the_page(version: macro_module_ptr): macro_def_ptr;
    { read the page of the macro into the given macro def }
    var
      current_file_type: file_types;     { type of the file being read }
      macro_def: macro_def_ptr;          { macro def being read }
      error_detected: boolean;           { TRUE if file error detected }
  begin
    if debug_20 then writeln(outfile, '  Starting to get the page');

    new_macro_def(macro_def);
    macro_def^.next := root_macro_def;  root_macro_def := macro_def;

    get_the_page := macro_def;
    macro_def^.is_leaf_macro := er_isprim(version);
    macro_def^.macro_name := macro_name;
    macro_def^.version := version;

    push_error_info;
    current_macro_def := macro_def;

    error_detected := FALSE;

    allowed_key_words := macrodef_keysys + directory_keysys;

    { set up the current parse environment }

    current_page := page_being_compiled;
    current_file_name := nullstring;
    copy_string(er_filename(module_being_compiled, ord(CONNECTIVITY), 
                            page_being_compiled, NIL),
                current_file_name);

    if (current_file_name <> nullstring) then
      if not open_a_file(current_file_name, STANDARD_FILE) then
	begin
	  error(205 { cannot open this file });
	  error_dump_current_parse_environment;
  
	  error_detected := TRUE;
	end
      else
	begin
	  current_file_type := get_file_type;
  
	  if current_file_type = MACRO_DEFINITION then
	    parse_macro_definition(macro_def)
	  else if current_file_type = CONNECTIVITY then
	    begin
	      if parse_connectivity_file(macro_def) then ;
	    end
	  else 
	    begin
	      error(86 { invalid file type });
	      error_detected := TRUE;
	    end;
  
	  if not close_parse_file(STANDARD_FILE) then
	    begin
	      error(168 { cannot close the file });
	      error_dump_file_name(current_file_name);
	    end;
	end;

    release_string(current_file_name);
    allowed_key_words := [];
    pop_error_info;
    if error_detected then get_the_page := NIL
		      else get_the_page := macro_def;
  end { get_the_page } ;


begin { read_macro_page }
  if debug then
    disp_line('enter read_macro_');

  if debug_20 then writeln(outfile, 'Starting to read a macro page');

  MDP := NIL;
  if (module_being_compiled = NIL)  then assert(227 { not allowed})
  else
    begin
      if extension_being_compiled = null_name then assert(227)
      else MDP := get_the_page(module_being_compiled);

      if printmacros_ok and (MDP <> NIL) then print_macro(outfile, MDP);
    end;

  read_macro_page := MDP;

  if debug then disp_line('read_Mpage       ');
end { read_macro_page } ;
