#include "lib/misc/platform.h"

#if VAX
(*$S-*) (* allow non-standard Pascal features                       *)
(*$C+*) (* turn on range checking (It's default OFF!!!!!?????)      *)
(*$X-*) (* save a few trees                                         *)
(*$W-*) (* if there are any warnings, I don't want to see them      *)
#endif
#if SVS
 {$R+}   { turn on range checking!!!!!!!                            }
#endif




(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(*    SSS   CCC    A   L     DDDD                                          *)
(*   S   S C   C  A A  L     D   D                                         *)
(*   S     C     A   A L     D   D  ccc  oo  m   m ppp  i l     ee  rrr    *)
(*    SSS  C     A   A L     D   D c    o  o mm mm p  p i l    e  e r  r   *)
(*       S C     AAAAA L     D   D c    o  o m m m ppp  i l    eeee rrr    *)
(*   S   S C   C A   A L     D   D c    o  o m   m p    i l    e    r r    *)
(*    SSS   CCC  A   A LLLLL DDDD   ccc  oo  m   m p    i llll  eee r  r   *)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)







(*****************************************************************************

                          Copyright 1981,1985
                             
                    VALID LOGIC SYSTEMS INCORPORATED


This  listing  contains  confidential  proprietary information which is not to
be disclosed to unauthorized persons without the written consent of an officer
of Valid Logic Systems Incorporated.

The  copyright  notice  appearing  above  is  included  to  provide  statutory
protection  in the event of  unauthorized or unintentional  public disclosure.

Luigi "Kneebreaker" Cordola knows where your children live!

*****************************************************************************)


(**)

#if !PMAX
#if VAX
[INHERIT('[-.SHARED]VOPEN','SYS$LIBRARY:STARLET')]
#endif
program compiler(input, output, monitor, outfile, CmpLog, CmpLst, CmpTmp,
#if VAX
                 infile, CmpStan, CmpDraw, 
#endif
                 Design);
#endif !PMAX

#if SVS
  uses 
    {$U vopen.obj} vopenunit, 
    {$U unixtime.obj} unixtime; 
#define OTHERWISE otherwise:
#endif

#if SUN || PMAX
#include "vopen.h" 
#include "unixtime.h" 
#endif


#if SUN
#define cexternal external c
#endif
#if VAX || PMAX
#define cexternal external 
#endif


#if VAX
#define BYVALUE %IMMED
#else
#define BYVALUE
#endif


const
#include "consts.h"
type
#include "types.h"
var
#include "vars.h"

#include "externals.p"


#if PMAX
#define OTHERWISE otherwise:

type 
  prog_name_type = packed array[1..80] of char;
var
  program_name : prog_name_type;

procedure authorize(var name: prog_name_type);  external;

program compiler(input, output, monitor, outfile, CmpLog, CmpLst, CmpTmp, Design);
#endif PMAX

#if S32
procedure main_procedure; 
  { Forces other procedures to levels > 1 so names aren't shortened }
#endif


#include "procs.p"
#include "stringio.p"

#include "newerror.p"
#include "ds.p"



procedure dump_tree_information(var f: textfile; what: dump_debug_info_type);
                                                                      FORWARD;
procedure dump_basescript_list(var f: text; BS: basescript_ptr);      FORWARD;
procedure record_instance_for_synonyms(instance: signal_instance_ptr);
                                                                      FORWARD;


(**)     { ------- initialization routines ------- }


procedure init_output_files;
  { open output files and print list of files to be created }
begin
  if debugging then
    begin  post_compile_time(outfile, list_file);  writeln(outfile);  end;

  post_compile_time(CmpLog, list_file);  writeln(CmpLog);

  if files_to_generate * [CMPERR_FILE] <> [] then writeln(monitor);

  if CMPERR_FILE in files_to_generate then
    if rewrite_file(CmpErr, nullstring, CMPERR_FILE_NAME) then
      begin
        PrintCmpErr := TRUE;
        writeln(monitor, ' Writing editor error info in .......... ',
                         CmpErr_file_name);
        writeln(CmpErr, 'FILE_TYPE=CMP_ERRORS;');
      end;
end { init_output_files } ;


#include "timeutils.p"


(**)     { ------- check the path name for debug enable ------- }


procedure check_path_debug(node: mtree_node_ptr);
  { check the current PATH property against the match path name and set the
    debug flags if a match is found. }
  var
    i: debug_flag_range;      { enumerates all debug flags for test }
    prop: property_ptr;       { path property }
begin
  if find_property(node^.called_by^.properties, PATH_prop_name, prop) then
    begin
      if CmpStrEQ(prop^.text, path_for_debug) then
        begin
          for i := 0 to MAX_DEBUG_FLAG_NUMBER do
            if i IN debug_flags then
              case i of
                0:   debug     := TRUE;
                1:   debug_1   := TRUE;
                2:   debug_2   := TRUE;
                3:   debug_3   := TRUE;
                4:   debug_4   := TRUE;
                5:   debug_5   := TRUE;
                6:   debug_6   := TRUE;
                7:   debug_7   := TRUE;
                8:   debug_8   := TRUE;
                9:   debug_9   := TRUE;
                10:  debug_10  := TRUE;
                11:  debug_11  := TRUE;
                12:  debug_12  := TRUE;
                13:  debug_13  := TRUE;
                14:  debug_14  := TRUE;
                15:  debug_15  := TRUE;
                16:  debug_16  := TRUE;
                17:  debug_17 := TRUE;
                18:  debug_18 := TRUE;
                19:  debug_19 := TRUE;
                20:  debug_20 := TRUE;
                21:  debug_21 := TRUE;
                22:  debug_22 := TRUE;
                23:  debug_23 := TRUE;
                24:  debug_24 := TRUE;
                25:  debug_25 := TRUE;
                26:  debug_26 := TRUE;
                27:  debug_27 := TRUE;
                28:  debug_28 := TRUE;
                29:  debug_29 := TRUE;
                30:  debug_30 := TRUE;
                31:  debug_31 := TRUE;
                32:  debug_32 := TRUE;
              end;
          debug_at_path := FALSE;
        end;

      if CmpStrEQ(prop^.text, path_for_undebug) then
        begin
          for i := 0 to MAX_DEBUG_FLAG_NUMBER do
            if i IN undebug_flags then
              case i of
                0:   debug     := FALSE;
                1:   debug_1   := FALSE;
                2:   debug_2   := FALSE;
                3:   debug_3   := FALSE;
                4:   debug_4   := FALSE;
                5:   debug_5   := FALSE;
                6:   debug_6   := FALSE;
                7:   debug_7   := FALSE;
                8:   debug_8   := FALSE;
                9:   debug_9   := FALSE;
                10:  debug_10  := FALSE;
                11:  debug_11  := FALSE;
                12:  debug_12  := FALSE;
                13:  debug_13  := FALSE;
                14:  debug_14  := FALSE;
                15:  debug_15  := FALSE;
                16:  debug_16  := FALSE;
                17:  debug_17 := FALSE;
                18:  debug_18 := FALSE;
                19:  debug_19 := FALSE;
                20:  debug_20 := FALSE;
                21:  debug_21 := FALSE;
                22:  debug_22 := FALSE;
                23:  debug_23 := FALSE;
                24:  debug_24 := FALSE;
                25:  debug_25 := FALSE;
                26:  debug_26 := FALSE;
                27:  debug_27 := FALSE;
                28:  debug_28 := FALSE;
                29:  debug_29 := FALSE;
                30:  debug_30 := FALSE;
                31:  debug_31 := FALSE;
                32:  debug_32 := FALSE;
              end;
          undebug_at_path := FALSE;
        end;
    end;
end { check_path_debug } ;


(**)     { ------- dump routines ------- }


function copy_bit_subscript(source_subscript: subscript_ptr): subscript_ptr;
                                                                      FORWARD;

procedure dump_bit_property_list(var f: textfile;
                                 list: bit_property_ptr);             FORWARD;


procedure dump_subscript_property(var f: textfile;
                                  prop: subscript_property_ptr);      FORWARD;


procedure dump_subscript_property_list(var f: textfile;
                                       list: subscript_property_ptr); FORWARD;


procedure dump_path_name(var f: textfile;  node: mtree_node_ptr);
  { dump the path name to f, with parens }
  var
    prop: property_ptr;  { path property }
begin
  if node^.called_by = NIL then prop := NIL
  else if find_property(node^.called_by^.properties,
                        PATH_prop_name, prop) then  ;

  if (prop <> NIL) then
    begin
      write(f, '(');
      if prop <> NIL then print_string(f, prop^.text);
      write(f, ')');
    end;
end { dump_path_name } ;


procedure print_signal_name(var f: textfile; polarity: signal_polarity;
                            name: xtring; is_const: boolean;
                            node: mtree_node_ptr);
  { write the signal name with path name to the file with closing ' }
begin
  write(f, OUTPUT_QUOTE_CHAR);
  if is_const or (node = NIL) then dump_signal_polarity(f, polarity)
  else
    begin
      dump_signal_polarity(f, polarity);
      dump_path_name(f, node);
    end;

  print_string_repeat_quotes(f, name);

  write(f, OUTPUT_QUOTE_CHAR);
end { print_signal_name } ;


procedure dump_virtual_spec(var f: textfile; def: signal_definition_ptr);
  { dump a specification of the "virtualness" of the def }
begin
  if (def^.net_id <> nullstring) or not def^.is_virtual_base then
    begin
      write(f, ' (');
      print_string(f, def^.net_id);
      if not def^.is_virtual_base then write(f, '+');
      write(f, ') ');
    end;
end { dump_virtual_spec } ;


procedure dump_signal_instance_noCRLF(var f: textfile;
                                      instance: signal_instance_ptr);
  { print the signal instance to the specified file with no CRLF }
    var
      negation: signal_polarity; { Whether or not to print a negation char }


  procedure dump_constant(var f: textfile; instance: signal_instance_ptr);
    { dump out a constant bit by bit as a concatenated signal.
      A constant is, by definition, bit numbered starting with 0 }
    var
      signal_name: xtring;       { name of the signal (constant digits) }
      length: string_range;      { length of the constant 'signal name' }
      bit: -1..MAX_BIT_VALUE;    { bit being printed }
      sub: subscript_ptr;        { current subscript }
      first_digit: boolean;      { TRUE if this is the first digit of const }
      replication: replication_range;    { replication of the signal }
      rep_value: replication_range;      { current replicated value }
      last_bit: char;                    { last constant output value }


    procedure write_bit(bit: bit_range);
      { write out the bit.  If complemented, then complement it }
      var
        ch: char;        { constant 'digit' to be output }
    begin
      if left_to_right then ch := signal_name^[bit+1]
                       else ch := signal_name^[length-bit];
      if ch = last_bit then rep_value := rep_value + 1
      else
        begin
          if first_digit then first_digit := FALSE
          else
            begin
              write(f, OUTPUT_QUOTE_CHAR);
              if rep_value > 1 then
                write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR,
                         'REP=''', rep_value:1, '''');
              rep_value := 1;
              write(f, concatenation_char);
            end;

          write(f, OUTPUT_QUOTE_CHAR);

          write(f, ch);
        end;

      last_bit := ch;
    end { write_bit } ;


  begin { dump_constant }
    signal_name := instance^.defined_by^.signal^.name;
    first_digit := TRUE;  replication := instance^.replication_factor;
    last_bit := chr(0);  rep_value := 1;
    repeat
      sub := instance^.bit_subscript;  length := ord(signal_name^[0]);
      if sub = NIL then write_bit(0)    { it's a scalar }
      else
        while sub <> NIL do
          begin
            bit := sub^.left_index;
            if bit <= sub^.right_index then
              repeat
                write_bit(bit);  bit := bit + 1;
              until bit > sub^.right_index
            else
              repeat
                write_bit(bit);  bit := bit - 1;
              until bit < sub^.right_index;
            sub := sub^.next;
          end;

      replication := replication - 1;
    until replication <= 0;
    write(f, OUTPUT_QUOTE_CHAR);

    if rep_value > 1 then
      write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR,
               'REP=''', rep_value:1, '''');
  end { dump_constant } ;


begin { dump_signal_instance_noCRLF }
  if instance <> NIL then
    with instance^.defined_by^ do
      if is_const then
        dump_constant(f, instance)
      else
        begin
	  if instance^.low_asserted then
	    if polarity = COMPLEMENTED then negation := NORMAL
	    else if polarity = NORMAL then negation := COMPLEMENTED
	    else negation := polarity
	  else negation := polarity;

          print_signal_name(f, negation, signal^.name, is_const, node);

          dump_bit_subscript(f, instance^.bit_subscript, kind);

          if instance^.low_asserted then write (f, '*');

          if debugging then
            dump_virtual_spec(f, instance^.defined_by);

          if instance^.replication_factor <> 1 then
            write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR, 'REP=''',
                     instance^.replication_factor:1, '''');
        end;
end { dump_signal_instance_noCRLF } ;


procedure dump_signal_instance(var f:textfile; instance: signal_instance_ptr);
  { dump the given signal instance to the given file with a CRLF }
begin
  dump_signal_instance_noCRLF(f, instance);
  writeln(f);
end { dump_signal_instance } ;


(**)     { ------- dump a signal definition ------- }


procedure dump_signal_definition(var f: textfile; sig: signal_definition_ptr);
  { dump the given signal definition and its signal instances }
  var
    instance: signal_instance_ptr;     { the instance to be dumped }
begin
  if sig = NIL then writeln(f)
  else
    begin
      print_signal_name(f, sig^.polarity, sig^.signal^.name,
                           sig^.is_const, sig^.node);

      dump_virtual_spec(f, sig);

      if sig^.kind = VECTOR then
        dump_left_and_right(f, sig^.left_index, sig^.right_index)
      else if sig^.kind = UNDEFINED then
        write(f, '<UNDEFINED>');

      if sig^.is_const then writeln(f)
      else
        begin
          write(f, ' {');
          writestring(f, scope_table[sig^.scope]);
          write(f, '} ->defined in: ');
          writestring(f, sig^.node^.macro_name);
          writeln(f, '(', sig^.node^.level:1, ')');
        end;

      instance := sig^.instances;
      while instance <> NIL do
        begin
          write(f, '    ');

          dump_signal_instance(f, instance);

          instance := instance^.next;
        end;

      if sig^.synonym_bits <> NIL then writeln(f, '  -- properties --');
      dump_bit_property_list(f, sig^.properties);
    end;
end { dump_signal_definition } ;


procedure dump_def(var f: textfile; sig: signal_definition_ptr);
  { dump the signal definition to the given file }
begin
  if sig = NIL then writeln(f, '<NIL sig def>')
  else 
    begin
      if sig^.signal = NIL then write(f, '<NIL sig^.signal>')
      else print_signal_name(f, sig^.polarity, sig^.signal^.name,
                                sig^.is_const, NIL);

      dump_virtual_spec(f, sig);

      if sig^.kind = VECTOR then
        dump_left_and_right(f, sig^.left_index, sig^.right_index)
      else if sig^.kind = UNDEFINED then
        write(f, '<UNDEFINED>');

      writeln(f);
    end;
end { dump_def } ;


procedure dump_virtual_defs(var f: textfile; def: signal_definition_ptr);
  { dump the given signal definition and all of its virtual defs }
  var
    found: boolean;                        { TRUE if base def found }
    current_def,                           { current def in search }
    virtual_def: signal_definition_ptr;    { current virtual def }
begin
  if not def^.is_virtual_base then
    begin
      write(f, 'Def supplied is not virtual base: ');
      dump_def(f, def);

      { this def is not the non-virtual base: find the correct def }

      current_def := def^.node^.signals;  found := FALSE;
      while (current_def <> NIL) and not found do
        if (current_def^.signal^.name = def^.signal^.name) and
	   (current_def^.polarity = def^.polarity) then
          found := TRUE
        else
          current_def := current_def^.next;

      if found then def := current_def else assert(195);
    end;

  write(f, 'Virtual base signal: ');
  dump_def(f, def);

  virtual_def := def^.next_virtual_def;
  while virtual_def <> NIL do
    begin
      write(f, '            virtual: ');
      dump_def(f, virtual_def);

      virtual_def := virtual_def^.next_virtual_def;
    end;
end { dump_virtual_defs } ;


(**)     { ------- dump a list of signal definitions ------- }


procedure dump_signal_definition_list(var f: textfile;
                                      list: signal_definition_list_ptr);
  { dump the signal definitions in the given list }
  var
    current_signal: signal_definition_list_ptr; { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal^.definition);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_signal_definition_list } ;


procedure dump_list_of_signal_definitions(var f: textfile;
                                          list: signal_definition_ptr);
  { dump a list of signal definitions headed by the given signal def }
  var
    current_signal: signal_definition_ptr;    { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_list_of_signal_definitions } ;


procedure dump_signal_definitions_with_basescripts(
  var f: textfile;  list: signal_definition_ptr);
  { dump a list of signal definitions (with basescripts) 
    headed by the given signal def }
  var
    current_signal: signal_definition_ptr;    { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal);

      writeln(f, '  -- basescripts --');
      dump_basescript_list(f, current_signal^.synonym_bits);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_signal_definitions_with_basescripts } ;


(**)     { ------- dump the signal scope ------- }


procedure print_signal_scope(var f: textfile;  scope: scope_type);
  { print the signal scope to the given file }
begin
  case scope of
    UNKNOWN_SCOPE:  ;
    XINTERFACE:     write(f, general_property_prefix_char, 'I');
    LOCAL:          write(f, general_property_prefix_char, 'L');
    GLOBAL:         write(f, general_property_prefix_char, 'G');
    DECLARED:       write(f, general_property_prefix_char, 'D');
    SIG_CONST:      ;
  end;
end { print_signal_scope } ;


(**)     { ------- dump a concatenated list of signals ------- }


procedure dump_propertied_CS(var f: textfile; signal: propertied_CS_ptr);
  { dump the concatenated signal to the specified file }
  var
    PCSP: propertied_CS_ptr;      { concatenated signal being printed }
    prop: property_ptr;           { current property in the property list }
begin
  PCSP := signal;
  if PCSP = NIL then writeln(f, '<NIL>');
  while PCSP <> NIL do
    begin
      if debug_11 then
        case PCSP^.control of
          IGNORE_ALL:     write(f, 'IA>');
          IGNORE_PIN:     write(f, 'IP>');
          NORMAL_SIGNAL:  write(f, 'NS>');
        end;

      dump_signal_instance_noCRLF(f, PCSP^.instance);

      prop := PCSP^.properties;
      while prop <> NIL do
        begin
          write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR);
          writealpha(f, prop^.name^.name);
          write(f, '=');
          print_string_with_quotes(f, prop^.text);

          prop := prop^.next;
          writeln(f);
        end;

      PCSP := PCSP^.next;

      if PCSP <> NIL then
        begin  writeln(f, ':');  write(f, '    ');  end;
    end;

  writeln(f);
end { dump_propertied_CS } ;


(**)     { ------- dump a formal/actual parameter list ------- }


procedure dump_actual_list_element(var f: textfile; actual: actual_list_ptr);
  { dump the given acutal list element to the given file }
begin
  write(f, '  Actual (');
  if actual^.width_is_unknown then write(f, 'width unknown')
                              else write(f, 'width known');
  write(f, ';assertion ');
  case actual^.assertion_state of
    ASSERTION_KNOWN: write(f, 'KNOWN');
    ASSERTION_UNKNOWN: write(f, 'UNKNOWN');
    ASSERTION_CHECKED: write(f, 'CHECKED');
    OTHERWISE write(f, ord(actual^.assertion_state):1);
  end;
  write(f, '): ');
 
  write(f, '    ');

  dump_propertied_CS(f, actual^.signal);
end { dump_actual_list_element } ;


procedure dump_actual_list(var f: textfile; actual_list: actual_list_ptr);
  { dump all of the elements of the given actual list }
  var
    actual: actual_list_ptr;     { current actual list element }
begin
  actual := actual_list;
  while actual <> NIL do
    begin
      dump_actual_list_element(f, actual);

      actual := actual^.next;
    end;
end { dump_actual_list } ;


procedure dump_simple_signal(var f: textfile; signal: simple_signal_ptr);
  { dump the given signal to the given file }
begin
  dump_polarity(f, signal^.polarity);
  print_string_with_quotes(f, signal^.signal_name);
  dump_bit_subscript(f, signal^.bit_subscript, signal^.kind);
end { dump_simple_signal } ;


procedure dump_formal_actual(var f: textfile; FAP: formal_actual_ptr);
  { dump the given formal/actual }
  var
    actual: actual_list_ptr;   { current actual on formal }
begin
  if FAP <> NIL then
    begin
      write(f, 'Formal (width=', FAP^.width:1, '; pol=');
      dump_polarity(f, FAP^.polarity);
      write(f, '): ');
      if FAP^.formal_parameter <> NIL then
        dump_signal_instance(f, FAP^.formal_parameter)
      else
        begin
          dump_simple_signal(f, FAP^.pin_name);  writeln(f);
        end;
          

      if FAP^.properties <> NIL then
        begin
          writeln(f, '  Subscript properties:');
          dump_subscript_property_list(f, FAP^.properties);
        end;

      actual := FAP^.actual_parameter;
      while actual <> NIL do
        begin
          dump_actual_list_element(f, actual);

          actual := actual^.next;
        end;
    end;
end { dump_formal_actual } ;


procedure dump_formal_actual_list(var f: textfile;
                                  list: formal_actual_ptr);
  { dump the list of formal/actual signals }
  var
    FAP: formal_actual_ptr;    { current pair to be printed }
begin
  writeln(f, 'Dump of the Formal/Actual list');

  FAP := list;
  while FAP <> NIL do
    begin
      dump_formal_actual(f, FAP);

      FAP := FAP^.next;
    end;
end { dump_formal_actual_list } ;


(**)     { ------- dump a signal stack ------- }


procedure dump_def_stack(var f: textfile; signal_def: signal_definition_ptr);
  { dump the stack starting with the given signal definition (SIGNAL_DEF) }
  var
    def: signal_definition_ptr;    { current definition in the stack }
    last_level: level_range;       { last level of the stack }
begin
  def := signal_def;
  if def <> NIL then
    if def^.is_const then writeln(f, '  constant stack')
    else
      begin
        last_level := MAX_TREE_DEPTH;
        while def <> NIL do
          begin
            write(f, '  ');
            dump_path_name(f, def^.node);
            writestring(f, def^.node^.macro_name);
            write(f, ' (lev=', def^.node^.level:1, ');  scope=');
            writestring(f, scope_table[def^.scope]);
            writeln(f);

            if last_level <= def^.node^.level then
              begin
                writeln(f, '  ** BOGUS STACK!! **');
                def := NIL;
              end
            else
              begin
                last_level := def^.node^.level;
                def := def^.stack;
              end;
          end;
      end;
end { dump_def_stack } ;


procedure dump_stack(var f: textfile; entry: signal_entry_ptr);
  { dump the signal stack associated with ENTRY }
begin
  writeln(f);
  writestring(f, entry^.name);  writeln(f, '  -> the NORMAL stack <-');
  dump_def_stack(f, entry^.high_asserted);

  writestring(f, entry^.name);  writeln(f, '  -> the COMPLEMENTED stack <-');
  dump_def_stack(f, entry^.low_asserted);
end { dump_stack } ;


(**)     { ------- dump an mtree node  ------- }


procedure dump_mtree_node(var f: textfile; node: mtree_node_ptr);
  { print the node (pathn and macro name) to f unless it is the root node }
  var
    prop: property_ptr;       { path property }
begin
  if node^.father_node <> NIL then
    begin
      write(f, 'Body=''');
      print_string(f, node^.macro_name);
      write(f,'''');
      if node^.called_by = NIL then writeln(f)
      else
        if not find_property(node^.called_by^.properties,
	                     PATH_prop_name, prop) then writeln(f)
        else
          begin
            write(f, '  Path (''');
            print_string(f, prop^.text);
            writeln(f, ')''');
          end;

      if node^.father_node^.father_node <> NIL then
        begin
          write(f, 'Drawing=''');
	  print_string(f, node^.father_node^.macro_name);
	  writeln(f, '''');
        end;
    end;
end { dump_mtree_node } ;


(**)     { ------- dump a signal definition to the error files ------- }


procedure error_dump_signal_def(def: signal_definition_ptr);
  { dump a signal definition to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, def^.polarity);

    print_string(f, def^.signal^.name);

    if def^.kind = VECTOR then
      dump_left_and_right(f, def^.left_index, def^.right_index);

    if not def^.is_const then
      if (def^.scope <> LOCAL) or not scope_is_local then
        print_signal_scope(f, def^.scope);
  end { print_signal } ;


begin { error_dump_signal_def }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');
  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_def } ;


procedure error_dump_subscript(s: subscript_ptr);
begin
  if ok_to_print_error then
    begin
      dump_bit_subscript(CmpLog, s, VECTOR);
      if PrintCmpLst then dump_bit_subscript(CmpLst, s, VECTOR)
                     else dump_bit_subscript(Monitor, s, VECTOR);
      if debugging then dump_bit_subscript(Outfile, s, VECTOR);
    end;
end {  error_dump_subscript } ;


procedure error_dump_signal_instance(instance: signal_instance_ptr);
  { dump a signal instance to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript,
                          instance^.defined_by^.kind);

    if instance^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               instance^.replication_factor:1);

    if not instance^.defined_by^.is_const then
      print_signal_scope(f, instance^.defined_by^.scope);
  end { print_signal } ;


begin { error_dump_signal_instance }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_instance } ;


(**)     { ------- dump a signal descriptor to the error files ------- }


procedure error_dump_signal_descriptor(*signal: signal_descriptor_ptr*);
  { dump a signal descriptor to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, signal^.polarity);

    print_string(f, signal^.signal_name);

    dump_bit_subscript(f, signal^.bit_subscript, signal^.kind);

    if signal^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               signal^.replication_factor:1);

    print_signal_scope(f, signal^.scope);
  end { print_signal } ;


begin { error_dump_signal_descriptor }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_descriptor } ;


(**)     { ------- dump a formal sig descrip to the error files ------- }


procedure error_dump_formal(formal: signal_descriptor_ptr);
  { dump a formal signal descriptor to the error files }
  var
    p: property_ptr;      { used to search for bubbled property }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, formal^.polarity);

    print_string(f, formal^.signal_name);

    dump_bit_subscript(f, formal^.bit_subscript, formal^.kind);
  end { print_signal } ;


begin { error_dump_formal }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_char(' ');

  if find_property(formal^.properties, BUBBLED_prop_name, p) then
    error_dump_alpha('(has BUBBLE)    ')
  else
    error_dump_alpha('(no BUBBLE)     ');

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal } ;


(**)     { ------- dump a formal sig def to the error files ------- }


procedure error_dump_formal_sig_def(formal: signal_definition_ptr);
  { dump a formal signal definition to the error files }
  var
    p: bit_property_ptr;      { used to search for bubbled property }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, formal^.polarity);

    print_string(f, formal^.signal^.name);

    if formal^.kind = VECTOR then
      dump_left_and_right(f, formal^.left_index, formal^.right_index);
  end { print_signal } ;


begin { error_dump_formal_sig_def }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_char(' ');

  if find_bit_property(formal^.properties, BUBBLED_prop_name, p) then
    error_dump_alpha('(has BUBBLE)    ')
  else
    error_dump_alpha('(no BUBBLE)     ');

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal_sig_def } ;


(**)     { ------- dump a formal param instance ------- }


procedure error_dump_formal_instance(instance: signal_instance_ptr);
  { dump a formal signal instance to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript, instance^.defined_by^.kind);
  end { print_signal } ;


begin { error_dump_formal_instance }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal_instance } ;


(**)     { ------- dump a list of pin names ------- }


procedure error_dump_all_pin_names(pin_name_list: formal_actual_ptr);
  { dump a list of pin names to the error files }
  var
    element: formal_actual_ptr;    { element of formal/actual list }


  procedure print_signal(var f: textfile; instance: signal_instance_ptr);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript, instance^.defined_by^.kind);

    if instance^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               instance^.replication_factor:1);
  end { print_signal } ;


begin { error_dump_all_pin_names }
  error_dump_indent(INDENT);
  error_dump_alpha('Pins of the body');
  error_dump_char(':');
  error_dump_CRLF;

  element := pin_name_list;
  while element <> NIL do
    begin
      error_dump_indent(indent + DEFAULT_INDENT);
      if ok_to_print_error then
        if PrintCmpLst then print_signal(CmpLst, element^.formal_parameter)
                       else print_signal(monitor, element^.formal_parameter);

      print_signal(CmpLog, element^.formal_parameter);

      if debugging then print_signal(outfile, element^.formal_parameter);

      error_dump_CRLF;

      element := element^.next;
    end;
end { error_dump_all_pin_names } ;


(**)     { ------- dump a signal to the error files ------- }


procedure error_dump_signal(polarity: signal_polarity; name: xtring;
                            sub: subscript_ptr);
  { dump a signal name for error listings }


  procedure print_signal(var f: textfile);
    { print the signal to the file }
  begin
    dump_signal_polarity(f, polarity);

    print_string(f, name);

    if sub = NIL then dump_bit_subscript(f, sub, SINGLE)
                 else dump_bit_subscript(f, sub, VECTOR);
  end { print_signal } ;


begin
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);
end { error_dump_signal } ;


(**)     { ------- dump a concatenated signal to the error files ------- }


procedure error_dump_propertied_CS(signal: propertied_CS_ptr);
  { dump a concatenated signal to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
    var
      PCSP: propertied_CS_ptr;   { current signal to be output }
  begin
    PCSP := signal;
    while PCSP <> NIL do
      with PCSP^.instance^ do
        begin
          dump_signal_polarity(f, defined_by^.polarity);

          print_string(f, defined_by^.signal^.name);

          dump_bit_subscript(f, bit_subscript, defined_by^.kind);

          if replication_factor <> 1 then
            write(f, general_property_prefix_char, 'R ', replication_factor:1);

          if PCSP^.next <> NIL then
            begin  
	      writeln(f, ':');  write(f, ' ':indent + (2 * DEFAULT_INDENT));
            end;

          PCSP := PCSP^.next;
        end;
  end { print_signal } ;


begin { error_dump_propertied_CS }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);
  if debugging then print_signal(outfile);

  error_dump_CRLF;
end { error_dump_propertied_CS } ;


(**)     { ------- dump a path name to the error files ------- }


procedure error_dump_path_name(node: mtree_node_ptr);
  { print the path name to the error files }
  var
    prop: property_ptr;  { path property }
begin
  if ok_to_print_error then
    begin
      if node^.called_by = NIL then prop := NIL
      else if find_property(node^.called_by^.properties, 
	                    PATH_prop_name, prop) then  ;

      if (prop <> NIL) then
        begin
          error_dump_char('(');
	  if prop <> NIL then error_dump_string(prop^.text);
	  error_dump_char(')');
        end;
    end;
end { error_dump_path_name } ;


(**)     { ------- dump an mtree node to the error files ------- }


procedure error_dump_mtree_node(node: mtree_node_ptr);
  { print the node (path and macro name) on the error files unless it
    is the root }
  var
    prop: property_ptr;  { path property }
begin
  if node^.father_node <> NIL then
    begin
      error_dump_indent(INDENT);
      error_dump_alpha('Body=           ');
      error_dump_path_name(node);
      error_dump_string(node^.macro_name);
      error_dump_CRLF;
  
      if node^.father_node^.father_node <> NIL then
        begin
          error_dump_alpha('Drawing=        ');
	  error_dump_string(node^.father_node^.macro_name);
	  error_dump_CRLF;
        end;
    end;
end { error_dump_mtree_node } ;


(**)     { ------- subscript utilities ------- }


function bits_in_common(subscript1, subscript2: subscript_ptr): boolean;
  { return TRUE if the given subscripts have any bits in common }
  var
    sub1,                        { current element of first subscript }
    sub2: subscript_ptr;         { current element of second subscript }
    found: boolean;              { TRUE if a bit in common was found }
    left,                        { left index of current first subscript }
    right: bit_range;            { right index of current first subscript }
begin
  sub1 := subscript1;  found := FALSE;
  while (sub1 <> NIL) and not found do
    begin
      left := sub1^.left_index;
       right := sub1^.right_index;

      sub2 := subscript2;
      while (sub2 <> NIL) and not found do
        begin
          if sub2^.left_index >= sub2^.right_index then
            begin
              if (left <= sub2^.left_index) and
                 (left >= sub2^.right_index) then
                found := TRUE
              else if (right <= sub2^.left_index) and
                      (right >= sub2^.right_index) then
                found := TRUE;
            end
          else
            if (left >= sub2^.left_index) and
               (left <= sub2^.right_index) then
              found := TRUE
            else if (right >= sub2^.left_index) and
                    (right <= sub2^.right_index) then
              found := TRUE;
            
          if not found then sub2 := sub2^.next;
        end;

      if not found then sub1 := sub1^.next;
    end;

  bits_in_common := found;
end { bits_in_common } ;


(**)     { ------- subscript property utilities ------- }


  (************************************************************************)
  (*                                                                      *)
  (*  Subscript properties are used to represent properties on a signal.  *)
  (*  Each property list has an associated subscript describing the bits  *)
  (*  of the signal possessing that property.                             *)
  (*                                                                      *)
  (*  It is assumed that:                                                 *)
  (*      1.  Properties that refer to the entire signal are given left   *)
  (*          and right indexes of -1.                                    *)
  (*      2.  A specific left and right index only appears once in a      *)
  (*          subscript property list.                                    *)
  (*  There is no attempt to compress subscripts.                         *)
  (*                                                                      *)
  (************************************************************************)


procedure dump_subscript_property(*var f: textfile;
                                  prop: subscript_property_ptr*);
  { dump the given subscript property (PROP) to the given file (F). }
begin
  if prop <> NIL then
    begin
      write(f, '  <', prop^.left_index:1);
      if prop^.left_index <> prop^.right_index then
        write(f, '..', prop^.right_index:1);
      writeln(f, '>:');

      dump_property_list(f, prop^.properties);
    end;
end { dump_subscript_property } ;


procedure dump_subscript_property_list(*var f: textfile;
                                       list: subscript_property_ptr*);
  { dump the given subscript property list (LIST) to the given file (F). }
  var
    prop: subscript_property_ptr;    { current property }
begin
  prop := list;
  while prop <> NIL do
    begin
      dump_subscript_property(f, prop);

      prop := prop^.next;
    end;
end { dump_subscript_property_list } ;


procedure delete_duplicate_subscript_properties
                                      (var properties: subscript_property_ptr;
                                       property_name: name_ptr;
                                       property_value: xtring);
  { delete the given property from any property lists other than the one
    referring to the entire bit subscript }
  var
    previous_prop,                          { previous element in list }
    next_prop,                              { next element in the list }
    current_prop: subscript_property_ptr;   { current element in the list }
    previous,                               { previous property in list }
    next,                                   { next property in the list }
    prop: property_ptr;                     { current property in the list }
begin
  current_prop := properties;  previous_prop := NIL;
  while current_prop <> NIL do
    begin
      next_prop := current_prop^.next;

      if (current_prop^.left_index <> -1) then
        begin
          { search for and delete identical properties to one added }

          prop := current_prop^.properties;  previous := NIL;
          while prop <> NIL do
            if (prop^.name = property_name) and
               (prop^.text = property_value) then
              begin
                next := prop^.next;
                if previous = NIL then
                  current_prop^.properties^.next := next
                else
                  previous^.next := next;
                release_property(prop);
                prop := next;
              end
            else
              begin  previous := prop;  prop := prop^.next;  end;

          { if all properties have been deleted from the subscript
            property, remove subscript property from the list }

          if current_prop^.properties = NIL then
            if previous_prop = NIL then
              begin
                properties := next_prop;
                release_subscript_property(current_prop);
                current_prop := NIL;
              end
            else
              begin
                previous_prop^.next := next_prop;
                release_subscript_property(current_prop);
                current_prop := previous_prop;
              end;
        end { if } ;

      previous_prop := current_prop;
      current_prop := next_prop;
    end { while } ;
end { delete_duplicate_subscript_properties } ;


procedure add_properties_to_subscript_property
                                   (var property_list: subscript_property_ptr;
                                    left_bit, right_bit: bit_range;
                                    properties: property_ptr);
  { add the properties from the given property list (PROPERTIES) to the given
    destination list (PROPERTY_LIST).  The subscript for which the property
    applies is given by LEFT_BIT and RIGHT_BIT.  If these are -1, the
    property applies to the entire signal (this is also the representation
    for a scalar's bits). }
  var
    source_prop: property_ptr;        { current source property }
    prop: subscript_property_ptr;     { current property in the list }
    found: boolean;                   { TRUE if subscript bits found }
begin
  if properties <> NIL then
    begin
      { find the proper subscript property element }

      prop := property_list;  found := FALSE;
      while (prop <> NIL) and not found do
        begin
          if (prop^.left_index = left_bit) and
             (prop^.right_index = right_bit) then
            found := TRUE;

          if not found then prop := prop^.next;
        end;

      if not found then
        begin
          new_subscript_property(property_list);
          prop := property_list;
          prop^.left_index := left_bit;
          prop^.right_index := right_bit;
        end;

      { add the properties to the list }

      source_prop := properties;
      while source_prop <> NIL do
        begin
          add_to_prop_list(prop^.properties,
                           source_prop^.name, source_prop^.text);

          if (left_bit = -1) and (right_bit = -1) then
            delete_duplicate_subscript_properties(property_list,
                                                  source_prop^.name,
                                                  source_prop^.text);

          source_prop := source_prop^.next;
        end;
    end;
end { add_properties_to_subscript_property } ;


procedure add_pin_properties_to_subscript_property
                                   (var property_list: subscript_property_ptr;
                                    left_bit, right_bit: bit_range;
                                    properties: property_ptr);
  { add the inherit pin properties from the given property list (PROPERTIES)
    to the given destination list (PROPERTY_LIST).  The subscript for which
    the property applies is given by LEFT_BIT and RIGHT_BIT.  If these are -1,
    the property applies to the entire signal (this is also the representation
    for a scalar's bits).  }
  var
    props: property_ptr;              { new property list of just pin props }
    source_prop: property_ptr;        { current source property }
begin
  source_prop := properties;  props := NIL;
  while source_prop <> NIL do
    begin
      if INHERIT_PIN IN source_prop^.name^.kind then
        add_to_prop_list(props, source_prop^.name, source_prop^.text);

      source_prop := source_prop^.next;
    end;

  if props <> NIL then
    begin
      new_subscript_property(property_list);
      property_list^.properties := props;
      property_list^.left_index := left_bit;
      property_list^.right_index := right_bit;
    end;
end { add_pin_properties_to_subscript_property } ;


procedure copy_unique_properties_to_subscript
                                      (var properties: subscript_property_ptr;
                                       prop_list: property_ptr);
  { copy the properties in the given list (PROP_LIST) to the given
    subscript property list (PROPERTIES).  Do not copy the property if it
    already appears in the list.  A subscript of -1 implies that the property
    is a property of the entire signal.  This routine assumes that the
    properties to be added to the destination list apply to every bit of the
    signal. }
  var
    source_prop: property_ptr;           { current property in source list }
    dest_prop: subscript_property_ptr;   { "entire" signal element }
    found: boolean;                      { TRUE if source prop exists }
begin
  if prop_list <> NIL then
    begin
      if debug_7 then
        begin
          writeln(outfile, 'Entered copy_unique_props_to_subscr:');
          writeln(outfile, '  sub props:');
          dump_subscript_property_list(outfile, properties);
          writeln(outfile, '  source props:');
          dump_property_list(outfile, prop_list);
        end;

      { look for the element containing entire signal properties }

      dest_prop := properties;  found := FALSE;
      while (dest_prop <> NIL) and not found do
        if dest_prop^.left_index = -1 then found := TRUE
        else dest_prop := dest_prop^.next;

      { if an entire signal property element does not exist, create it }

      if not found then
        begin
          new_subscript_property(properties);
          dest_prop := properties;
          dest_prop^.left_index := -1;  dest_prop^.right_index := -1;
        end;

      { add the source properties to the given element in the dest list }

      source_prop := prop_list;
      while source_prop <> NIL do
        begin
          check_and_add_to_prop_list(dest_prop^.properties,
                                     source_prop^.name, source_prop^.text);

          { make sure this property does not appear anywhere else in the
            subscript property lists }

          delete_duplicate_subscript_properties(properties,
                                                source_prop^.name,
                                                source_prop^.text);

          source_prop := source_prop^.next;
        end;

      if debug_7 then
        begin
          writeln(outfile, 'Exiting copy_unique_props_to_subscr:');
          dump_subscript_property_list(outfile, properties);
        end;
    end;
end { copy_unique_properties_to_subscript } ;


(**)     { ------- bit property utilities ------- }


  (*************************************************************************)
  (*                                                                       *)
  (*  Bit properties are used to represent properties on a signal.  Each   *)
  (*  element in the list is a property along with the bits of the signal  *)
  (*  for which it applies.  It is assumed that:                           *)
  (*      1.  Properties that refer to the entire signal are given NIL     *)
  (*          bit subscripts.                                              *)
  (*      2.  A specific property name and value can only appears once in  *)
  (*          the bit property list.                                       *)
  (*      3.  Property names that appear more than once, because of        *)
  (*          different property values, are adjacent in the list.         *)
  (*                                                                       *)
  (*************************************************************************)


procedure dump_bit_property_list(*var f: textfile;
                                 list: bit_property_ptr*);
  { dump the given bit property list (LIST) to the given file (F). }
  var
    prop: bit_property_ptr;    { current property }
begin
  prop := list;
  while prop <> NIL do
    begin
      write(f, '    ');

      if prop^.bit_subscript = NIL then write(f, '<ALL>')
      else
        dump_bit_subscript(f, prop^.bit_subscript, VECTOR);

      writealpha(f, prop^.name^.name);
      write(f, '=');
      writestring(f, prop^.text);

      if prop^.next = NIL then  writeln(f, ';')  else  writeln(f, ',');

      prop := prop^.next;
    end;
end { dump_bit_property_list } ;


procedure add_property_to_bit_property_list(var prop_list: bit_property_ptr;
                                            property_name: name_ptr;
                                            property_value: xtring;
                                            bits: subscript_ptr);
  { add the given property (PROPERTY_NAME and PROPERTY_VALUE) to the given
    property list (PROP_LIST) with the given bits (BITS).   It is assumed
    that the property cannot have the INHERIT_PIN attribute.  }
  var
    prop: bit_property_ptr;           { current property in the list }
    done,                             { TRUE if search is done }
    found: boolean;                   { TRUE if property found in the list }
    same_name_prop: bit_property_ptr; { property in list with same name }
    new_prop: bit_property_ptr;       { new property in the list }
begin
  if debug_7 then
    begin
      writeln(outfile, 'Entering add_property_to_bit_property_list: prop=');
      dump_bit_subscript(outfile, bits, VECTOR);
      writeln(outfile);
      writealpha(outfile, property_name^.name);
      write(outfile, '=');
      writestring(outfile, property_value);
      writeln(outfile);

      writeln(outfile, 'Property list=');
      dump_bit_property_list(outfile, prop_list);
    end;

  { !!!! THIS IS NOT IMPLEMENTED !!!!!! }
  { search for the property in the list.  It is known that all properties
    with the same name (but different values) are adjacent in the list. }

  prop := prop_list;  found := FALSE;  done := FALSE;  same_name_prop := NIL;
  while (prop <> NIL) and not (found or done) do
    if prop^.name = property_name then
      begin
        if same_name_prop = NIL then same_name_prop := prop;

        (*****   THIS IS NOT IMPLEMENTED    ****
        while (prop <> NIL) and not (found or done) do
          if prop^.name <> property_name then done := TRUE
          else if prop^.text = property_value then found := TRUE
          else prop := prop^.next;
         *****   THIS IS NOT IMPLEMENTED    ****)

        if prop^.text = property_value then
          found := TRUE
        else
          prop := prop^.next;
      end
    else
      prop := prop^.next;
 
  { if not found in the list, add.  If name match was found, add after name }

  if not found then
    begin
      new_prop := NIL;
      new_bit_property(new_prop);
      new_prop^.name := property_name;
      new_prop^.text := property_value;

      if same_name_prop = NIL then
        begin
          new_prop^.next := prop_list;
          prop_list := new_prop;
        end
      else
        begin
          new_prop^.next := same_name_prop^.next;
          same_name_prop^.next := new_prop;
        end;
      prop := new_prop;
    end;

  { merge the subscripts of the bit property and the subscript of the property
    being added.  If the property being added applies to the entire subscript
    (BITS = NIL) then make sure that the subscript of the bit property is
    NIL as well. }

  if bits = NIL then
    begin
      if prop^.bit_subscript <> NIL then
        release_entire_subscript(prop^.bit_subscript);
    end
  else
    add_to_bit_union(bits, prop^.bit_subscript);

  if debug_7 then
    begin
      writeln(outfile, 'Exiting add_property_to_bit_property_list: list=');
      dump_bit_property_list(outfile, prop_list);
    end;
end { add_property_to_bit_property_list } ;


procedure add_pin_property_to_bit_property(var properties: bit_property_ptr;
                                           property_name: name_ptr;
                                           property_value: xtring;
                                           bits: subscript_ptr);
  { add the given property (PROPERTY_NAME and PROPERTY_VALUE), assumed to
    be an INHERIT_PIN property, to the given property list (PROPERTIES)
    with the associated bits (BITS). }
begin
  new_bit_property(properties);
  properties^.name := property_name;
  properties^.text := property_value;
  properties^.bit_subscript := copy_bit_subscript(bits);
end { add_pin_property_to_bit_property } ;


procedure copy_unique_properties_to_bit_property
                                            (var properties: bit_property_ptr;
                                             prop_list: property_ptr;
                                             bits: subscript_ptr);
  { copy the properties in the given list (PROP_LIST) to the given bit
    property list (PROPERTIES) for the given bits (BITS).  Do not copy the
    property if it already appears in the list.  A NIL bit subscript implies
    that the property is a property of the entire signal.  Only copy
    properties that do NOT have the INHERIT_PIN attribute.}
  var
    source_prop: property_ptr;        { current property in source list }
begin
  if debug_7 then
    begin
      writeln(outfile, 'Entered copy_unique_props_to_bit:');
      writeln(outfile, '  bit props:');
      dump_bit_property_list(outfile, properties);
      writeln(outfile, '  source props:');
      dump_property_list(outfile, prop_list);
      write(outfile, 'For bits: ');
      dump_bit_subscript(outfile, bits, VECTOR);
      writeln(outfile);
    end;

  source_prop := prop_list;
  while source_prop <> NIL do
    begin
      if not (INHERIT_PIN IN source_prop^.name^.kind) then
        add_property_to_bit_property_list(properties,
                                          source_prop^.name,
                                          source_prop^.text,
                                          bits);

      source_prop := source_prop^.next;
    end;

  if debug_7 then
    begin
      writeln(outfile, 'Exiting copy_unique_props_to_bit: props=');
      dump_bit_property_list(outfile, properties);
    end;
end { copy_unique_properties_to_bit_property } ;


procedure copy_inherit_pin_properties_to_BP(var properties: bit_property_ptr;
                                            prop_list: property_ptr;
                                            bits: subscript_ptr);
  { copy the INHERIT_PIN propertues from the given property list (PROP_LIST)
    to the given bit property list (PROPERTIES).  The bits for which the
    properties apply is given by BITS. }
  var
    source_prop: property_ptr;     { current property in the list }
begin
  if debug_7 then
    begin
      writeln(outfile, 'Entered copy_inherit_pin_propertiess_to_BP:');
      writeln(outfile, '  bit props:');
      dump_bit_property_list(outfile, properties);
      writeln(outfile, '  source props:');
      dump_property_list(outfile, prop_list);
      write(outfile, 'For bits: ');
      dump_bit_subscript(outfile, bits, VECTOR);
      writeln(outfile);
    end;

  source_prop := prop_list;
  while source_prop <> NIL do
    begin
      if INHERIT_PIN IN source_prop^.name^.kind then
        add_pin_property_to_bit_property(properties,
                                         source_prop^.name,
                                         source_prop^.text,
                                         bits);
      source_prop := source_prop^.next;
    end;

  if debug_7 then
    begin
      writeln(outfile, 'Exiting copy_inherit_pin_properties_to_BP: props=');
      dump_bit_property_list(outfile, properties);
    end;
end { copy_inherit_pin_properties_to_BP } ;


function width_of_subscript(sub: subscript_ptr; kind: signal_kind): bit_range;
                                                                      FORWARD;

function width_of_signal_instance(instance: signal_instance_ptr): bit_range;
                                                                      FORWARD;

procedure copy_props_from_PCS_to_formal_actual
                                      (formal_actual_pair: formal_actual_ptr;
                                       actual_signal: propertied_CS_ptr);
  { copy the properties of the propertied CS (SIGNAL) to the subscript
    property of the given formal actual pair.  It is known that ALL formal
    parameters (pin names) are simple subranges. }
  var
    left_to_right: boolean;      { TRUE if bits ordered that way }
    left, right: bit_range;      { current formal bit subscript }
    signal: propertied_CS_ptr;   { current portion of the actual }
begin
  if debug_7 then
    begin
      writeln(outfile, 'Entering copy_props_from_PCS_to_f/a: F/A=');
      dump_formal_actual(outfile, formal_actual_pair);
      writeln(outfile, 'Actual:');
      dump_propertied_CS(outfile, actual_signal);
    end;

  if formal_actual_pair^.formal_parameter^.bit_subscript = NIL then
    add_properties_to_subscript_property(formal_actual_pair^.properties,
                                         -1,-1,
                                         signal^.properties)
  else
    begin
      with formal_actual_pair^.formal_parameter^.bit_subscript^ do
        begin
          left := left_index;  right := left;
          left_to_right := (left_index <= right_index);
        end;
    
      signal := actual_signal;
      while signal <> NIL do
        begin
          if left_to_right then
            right := left + width_of_subscript(signal^.instance^.bit_subscript,
                                               VECTOR) - 1
          else
            right := left - width_of_subscript(signal^.instance^.bit_subscript,
                                               VECTOR) + 1;

          add_properties_to_subscript_property(formal_actual_pair^.properties,
                                               left, right,
                                               signal^.properties);

          if left_to_right then
            left := right+1
          else
            left := right-1;

          signal := signal^.next;
        end;
    end;

  if debug_7 then
    begin
      writeln(outfile, 'Exiting copy_props_from_PCS_to_f/a: props:');
      dump_subscript_property_list(outfile, formal_actual_pair^.properties);
    end;
end { copy_props_from_PCS_to_formal_actual } ;


function find_subscript_property(prop_list: subscript_property_ptr;
                                 property_name: name_ptr;
                                 var return_prop: property_ptr): boolean;
  { find the given property in the given property list.  If not found, return
    NIL.  Only search for properties that are properties of the entire sub. }
  var
    current_prop: subscript_property_ptr; { current element in list }
    prop: property_ptr;                   { current property in the list }
    found_subscript: boolean;             { TRUE if "entire" subscript found }
    found_prop: boolean;                  { TRUE if property found in list }
begin
  current_prop := prop_list;  found_subscript := FALSE;
  while (current_prop <> NIL) and not found_subscript do
    if current_prop^.left_index = -1 then found_subscript := TRUE
    else current_prop := current_prop^.next;

  found_prop := FALSE;
  if found_subscript then
    begin
      prop := current_prop^.properties;
      while (prop <> NIL) and not found_prop do
        if (prop^.name = property_name) then found_prop := TRUE
        else prop := prop^.next;
    end;

  if found_prop then return_prop := prop else return_prop := NIL;

  find_subscript_property := found_prop;
end { find_subscript_property } ;


(**)     { ------- signal utilities ------- }


function copy_bit_subscript(*source_subscript: subscript_ptr): subscript_ptr*);
  { make a copy of the given subscript (SOURCE_SUBSCRIPT) and return it }
  var
    source,                      { current element of source subscript }
    dest,                        { new subscript being created }
    last: subscript_ptr;         { last element of new subscript }
begin
  source := source_subscript;  dest := NIL;  last := NIL;
  while source <> NIL do
    begin
      if last <> NIL then
        begin  new_subscript(last^.next);  last := last^.next;  end
      else
        begin  new_subscript(last);  dest := last;  end;
      last^ := source^;  last^.next := NIL;
      source := source^.next;
    end;

  copy_bit_subscript := dest;
end { copy_bit_subscript } ;


function identical_bit_subscripts(dest, source: subscript_ptr): boolean;
  { return TRUE if the two subscripts are identical }
  var
    same: boolean;       { function result }
begin
  same := TRUE;
  while (dest <> NIL) and (source <> NIL) and same do
    if dest^.left_index <> source^.left_index then same := FALSE
    else if dest^.right_index <> source^.right_index then same := FALSE
    else
      begin  dest := dest^.next;  source := source^.next;  end;

  { check for left-over subscripts }

  if (dest <> NIL) or (source <> NIL) then same := FALSE;

  identical_bit_subscripts := same;
end { identical_bit_subscripts } ;


(**)     { ------- virtual signal utilities ------- }


function virtual_base(def: signal_definition_ptr): signal_definition_ptr;
  { search for the virtual base signal of the given DEF and return it.
    If not found, return DEF. }
  var
    found: boolean;                      { TRUE if virtual base def is found }
    current_def: signal_definition_ptr;  { current def in the list }
begin
  if def^.is_virtual_base then virtual_base := def
  else
    begin
      current_def := def^.node^.signals;  found := FALSE;
      while (current_def <> NIL) and not found do
        if (current_def^.signal^.name = def^.signal^.name) and
           (current_def^.polarity = def^.polarity) then
          found := TRUE
        else
          current_def := current_def^.next;

      if found then virtual_base := current_def
      else
        begin
          virtual_base := def;
          assert(195);
        end;

      if debug_15 or debug_12 then
        begin
          write(outfile, ' found non-virtual def: ');
          dump_def(outfile, current_def);
        end;
    end;
end { virtual_base } ;


(**)     { ------- signal stack routines ------- }


#include "sigstack.p"


(**)     { ------- fix unresolvable or non-existent formal ------- }


function fix_weird_formal(formal_def: signal_definition_ptr;
                          signal: signal_descriptor_ptr;
			  formal_act: formal_actual_ptr): signal_instance_ptr;
  { create a local signal derived in name from the formal signal definition
    given and return an instance of it described by the given descriptor.
    formal_def is the signal definition for the formal.  signal is the
    local instance of the interface signal within the drawing.  formal_act
    binds the formal to an actual for the current instance of the drawing
    and may be NIL (as when handling the error of a non-existent formal). }
  var
    signal_name: xtring;            { local signal name }
    sig: signal_descriptor_ptr;     { copy of input signal descriptor }
begin
  create_a_string(signal_name, MAX_STRING_LENGTH);
  signal_name^[0] := chr(0);

  if not add_string_to_string(signal_name, special_pin_name_prefix) then ;

  if not add_string_to_string(signal_name, formal_def^.signal^.name) then ;

  new_signal_descriptor(sig);  sig^ := signal^;
  sig^.signal_name := enter_string(signal_name);
  if formal_act <> NIL then
    if formal_act^.uses_NAC or (formal_act^.polarity = NO_POLARITY) then
      begin
        sig^.polarity := NO_POLARITY;
        sig^.low_asserted := FALSE;
      end;

  sig^.scope := LOCAL;

  fix_weird_formal := enter_signal_instance(sig, NIL);

  release_signal_descriptor(sig);
  signal_name^[0] := chr(MAX_STRING_LENGTH);
  release_string(signal_name);
end { fix_weird_formal } ;


(**)     { ------- some signal utilities ------- }


function width_of_subscript(*sub: subscript_ptr;
                            kind: signal_kind): bit_range*);
  { calculate the width of the given subscript given the signal kind.
    A value of 0 returned implies an undefined width }
  var
    width: bit_range;       { calculated width of the subscript }
begin
  case kind of
    UNDEFINED: width := 0;

    SINGLE:    width := 1;

    VECTOR:    begin
                 width := 0;
                 if sub = NIL then
                   begin  assert(163 { NIL subscript });  width := 1;  end;
                 while sub <> NIL do
                   with sub^ do
                     begin
                       width := width + abs(left_index-right_index) + 1;
                       sub := sub^.next;
                     end;
               end;
  end;

  width_of_subscript := width;
end { width_of_subscript } ;
  
      
function width_of_signal_instance(*instance: signal_instance_ptr): bit_range*);
  { calculate the width of the signal instance and return it }
begin
  if instance = NIL then
    assert(56 { cannot have this! })
  else
    width_of_signal_instance := width_of_subscript(instance^.bit_subscript,
                                                instance^.defined_by^.kind) *
                                instance^.replication_factor;
end { width_of_signal_instance } ;

  
function width_of_propertied_CS(signal: propertied_CS_ptr): bit_range;
  { Calculate the width of a propertied concatenated signal }
  var
    sig: propertied_CS_ptr;     { current piece of the signal }
    width: natural_number;       { width of signal so far }
begin
  sig := signal;  width := 0;
  while sig <> NIL do
    begin
      width := width + width_of_subscript(sig^.instance^.bit_subscript,
                                          sig^.instance^.defined_by^.kind) *
                                            sig^.instance^.replication_factor;
      sig := sig^.next;
    end;

  width_of_propertied_CS := width;
end { width_of_propertied_CS } ;
  

(**)     { ------- timing assertion check routine ------- }


function signal_name_has_timing_assertion(signal_name: xtring): boolean;
  { check the given signal name for a timing assertion (!) and return TRUE
    if found. }
  var
    i: string_range;          { index into the signal name }
    found: boolean;           { TRUE if "!" found in the signal name }
begin
  i := 1;  found := FALSE;
  while (i <= ord(signal_name^[0])) and not found do
    if signal_name^[i] = TIMING_ASSERTION_CHAR then found := TRUE
    else i := i + 1;

  signal_name_has_timing_assertion := found;
end { signal_name_has_timing_assertion } ;


(**)


#include "sig.p"


(**)     { ------- properties of def ------- }


function bit_properties_of_def(sig_def: signal_definition_ptr;
                               which: property_selector):
                                                       subscript_property_ptr;
  { for each bit of the given signal (SIG_DEF), return a list of its
    properties.  WHICH = INHERIT_PROPERTIES means that only those properties
    with INHERIT_SIGNAL or INHERIT_PIN attributes are returned. }
  var
    direction: -1..1;                  { index increment direction }
    bit,                               { current bit in the subscript }
    times_through_loop: bit_range;     { # bits in the signal def }
    new_props: property_ptr;           { properties of current bit (BIT) }
    current_prop,                      { end of the return prop list }
    sub_prop: subscript_property_ptr;  { property list being created }
    augmentable: boolean;              { TRUE if we might augment it }
begin
  if debug_7 then
    begin
      writeln(outfile, 'Entering bit_properties_of_def:  def=');
      dump_signal_definition(outfile, sig_def);
    end;

  { This is a REAL simple implementation of this function, i.e. SLOW

    for each bit of the sig def do
      build the prop list for that bit
      can this new bit augment the last sub prop element
        if not append a new sub prop element
        if so compare new prop list with prop list on last sub prop element
          if =   add bit to last sub prop element
          if <>  append a new sub prop element
                                                                             }

  sub_prop := NIL;  current_prop := NIL;

  bit := sig_def^.left_index;

  times_through_loop := width_of_signal_definition(sig_def);

  if sig_def^.left_index > sig_def^.right_index then
    direction := -1
  else if sig_def^.left_index < sig_def^.right_index then
    direction := 1
  else
    direction := 0;

  while times_through_loop > 0 do
    begin
      new_props := bit_properties_of_this_bit(sig_def^.properties, bit, which);

      augmentable := FALSE;

      if (current_prop <> NIL) and (new_props <> NIL) then
        if bit = (current_prop^.right_index + direction) then
          if compare_properties(new_props,
                                current_prop^.properties) = EQ then
            begin
              augmentable := TRUE;

              current_prop^.right_index := 
                                        current_prop^.right_index + direction;

              release_entire_property_list(new_props);
            end;

      if not augmentable and (new_props <> NIL) then
        begin
          if sub_prop = NIL then
            begin
              new_subscript_property(sub_prop);
              current_prop := sub_prop;
            end
          else
            begin
              new_subscript_property(current_prop^.next);
              current_prop := current_prop^.next;
            end;

          with current_prop^ do
            begin
              left_index  := bit;
              right_index := bit;
              properties  := new_props;
            end;
        end;

      bit := bit + direction;

      times_through_loop := times_through_loop - 1;
    end { while ... } ;

  if (sig_def^.kind = SINGLE) and (sub_prop <> NIL) then
    begin
      sub_prop^.left_index := -1;
      sub_prop^.right_index := -1;
    end;

  bit_properties_of_def := sub_prop;

  if debug_7 then
    begin
      writeln(outfile, 'Exiting bit_properties_of_def: props=');
      dump_subscript_property_list(outfile, sub_prop);
    end;
end { bit_properties_of_def } ;


(**)     { ------- signal package utilities ------- }


function build_NC_signal(width: natural_number): signal_instance_ptr;
  { build an NC signal of the specified width, enter it into the signal
    table, and return the signal instance.  It builds it in the current
    created context (signal stacks). }
  var
    signal: signal_descriptor_ptr;  { signal to be created }
begin
  signal := NIL;
  new_signal_descriptor(signal);
  signal^.signal_name := unique_NC_name;
  signal^.kind := VECTOR;
  signal^.bit_subscript := create_a_subscript(width);

  signal^.scope := LOCAL;
  signal^.net_id := nullstring;

  build_NC_signal := enter_signal_instance(signal, NIL);

  release_entire_subscript(signal^.bit_subscript);
  release_signal_descriptor(signal);
end { build_NC_signal } ;


#include "width.p"


(**)     { ------- check assertions of signals ------- }


#include "assertion.p"


(**)     { ------- assign all synonyms ------- }


procedure assign_synonyms(node: mtree_node_ptr);
  { assign synonyms for all of the bodies in the given drawing (NODE).
    If the 1st actual in the list contains NC signals, it is replaced
    by one that doesn't. }

  var
    son: mtree_node_ptr;                   { current body within drawing }
    formal_actual_pair: formal_actual_ptr; { current formal/actual pair }
    actual: actual_list_ptr;               { current actual of the formal }
    actual_without_NCs: actual_list_ptr;   { signal without NC components }

begin
  son := node^.son;
  while son <> NIL do
    begin
      if son^.is_plumbing_node and not son^.is_cardinal_tap then
        assign_synonyms(son);

      formal_actual_pair := son^.params;
      while formal_actual_pair <> NIL do
        begin
          actual :=  formal_actual_pair^.actual_parameter^.next;
          while actual <> NIL do
            begin
              actual_without_NCs :=
                         create_synonym(formal_actual_pair^.actual_parameter);
              if actual_without_NCs <> NIL then
                begin
                  actual_without_NCs^.next :=
                                         formal_actual_pair^.actual_parameter;
                  formal_actual_pair^.actual_parameter := actual_without_NCs;
                end;

              actual := actual^.next;
            end;

          formal_actual_pair := formal_actual_pair^.next;
        end;

      son := son^.next;
    end { while } ;
end { assign_synonyms } ;


(**)     { ------- synonym all virtual signals ------- }


procedure synonym_virtual_defs(node: mtree_node_ptr);
  { synonym all virtual defs on this node and any sons.  The virtual defs
    are in a list rooted on the "base" def and threaded by the NEXT_VIRTUAL_DEF
    field.  The NEXT field of the def normally serves to thread together defs
    on a node.  Virtual defs, on the other hand, have a NIL NEXT field.  The
    "base" def is therefore recognized by checking for a non-NIL NEXT field.
    This is the only signal of the group that will be recognized when
    outputting synonyms or signal properties.  The other signals are
    considered to be "virtual" and are ignored. }
  var
    son: mtree_node_ptr;            { current son of this node }
    virtual_def,                    { current virtual def }
    def: signal_definition_ptr;     { current signal of this node }
    virtuals: actual_list_ptr;      { signals to be synonymed together }
    descriptor: signal_descriptor_ptr;  { temp structure }
    bits: subscript_ptr;            { temp subscript }


  procedure make_descriptor_from_def(descriptor: signal_descriptor_ptr;
                                     def: signal_definition_ptr;
                                     left, right: bit_range);
    { make a signal descriptor from the given signal def.  It is assumed that
      the descriptor has already been created.  The particular subscript is
      given by LEFT and RIGHT. }
  begin
    with descriptor^ do
      begin
        signal_name := def^.signal^.name;
        net_id := def^.net_id;
        polarity := def^.polarity;
        scope := def^.scope;
        low_asserted := (def^.polarity = COMPLEMENTED);
        kind := def^.kind;
        if kind <> VECTOR then
          bit_subscript := NIL
        else
          begin
            bits^.left_index := left;
            bits^.right_index := right;
            bit_subscript := bits;
          end;
        is_const := def^.is_const;
      end;
  end { make_descriptor_from_def } ;


  procedure create_virtual_synonym(base_def, def: signal_definition_ptr);
    { create a synonym between the two given defs }
  begin
    { create a signal instance for the base def }

    make_descriptor_from_def(descriptor, base_def,
                             def^.left_index, def^.right_index);
    virtuals^.signal^.instance := enter_signal_instance(descriptor, base_def);

    { make an instance for the "virtual" def }

    make_descriptor_from_def(descriptor, def,
                             def^.left_index, def^.right_index);
    virtuals^.next^.signal^.instance :=
                                       enter_signal_instance(descriptor, def);

    synonym_actuals(virtuals);

    if debug_15 then
      begin
        writeln(outfile, 'Exiting create_virtual_synonym: signals=');
        dump_actual_list(outfile, virtuals);
      end;
  end { create_virtual_synonym } ;


begin { synonym_virtual_defs }
  if debug_15 then
    begin
      write(outfile, 'Entering synonym_virtual_defs: node=');
      if node = NIL then write(outfile, 'node=NIL')
      else if node^.macro = NIL then write(outfile, 'macro=NIL')
      else print_string(outfile, node^.macro_name);
      writeln(outfile);
    end;

  { initialize some structures } 

  virtuals := NIL;
  new_actual_list(virtuals);
  new_propertied_CS(virtuals^.signal);

  new_actual_list(virtuals^.next);
  new_propertied_CS(virtuals^.next^.signal);

  new_signal_descriptor(descriptor);

  bits := NIL;
  new_subscript(bits);

  { process all plumbing bodies first }

  son := node^.son;
  while son <> NIL do
    begin
      if son^.is_plumbing_node and not son^.is_cardinal_tap then
        synonym_virtual_defs(son);

      son := son^.next;
    end;

  { synonym virtual signals found in the signals list }

  if debug_15 then
    begin
      write(outfile, 'Starting synonyming for: ');
      print_string(outfile, node^.macro_name);
      writeln(outfile);
    end;

  def := node^.signals;
  while def <> NIL do
    begin
      if def^.next_virtual_def <> NIL then
        begin
          if debug_15 then dump_virtual_defs(outfile, def);

          virtual_def := def^.next_virtual_def;
          while virtual_def <> NIL do
            begin
              create_virtual_synonym(def, virtual_def);

              virtual_def := virtual_def^.next_virtual_def;
            end;
        end;

      def := def^.next;
    end;

  release_subscript(bits);
  descriptor^.bit_subscript := NIL;
  release_signal_descriptor(descriptor);
  release_complete_actual_list(virtuals);

  if debug_15 then
    writeln(outfile, 'Exiting synonym_virtual_defs');
end { synonym_virtual_defs } ;


(**)     { ------- copy properties to formal parameters ------- }


procedure copy_properties_from_actuals(node: mtree_node_ptr);
  { copy INHERIT_PIN properties from the actuals of the bodies in the
    specified drawing to the formals.  The properties are found on the
    signal definitions.  }
  var
    son: mtree_node_ptr;                    { current body in the drawing }
    formal_actual_pair: formal_actual_ptr;  { current pin on body }
    actual: propertied_CS_ptr;              { current actual on pin }
    left, right: bit_range;                 { current subscript of formal }
    direction: -1..1;                       { subscript increment offset }
    width: bit_range;                       { width of current property }
    props_of_instance,                      { instance's properties }
    current_prop: subscript_property_ptr;   { current property of instance }
begin
  if debug_14 then writeln(outfile, 'Entering copy_properties_from_actuals');

  son := node^.son;
  while son <> NIL do
    begin
      if not son^.is_plumbing_node then
        begin
          if debug_14 then
            begin
              write(outfile, 'Copy_properties_from_actuals: body=');
              print_string(outfile, son^.macro_name);
              writeln(outfile);

              writeln(outfile, 'Before copy to F/A:');
              dump_formal_actual_list(outfile, son^.params);
            end;

          formal_actual_pair := son^.params;
          while formal_actual_pair <> NIL do
            begin
              with formal_actual_pair^.formal_parameter^ do
                if defined_by^.kind = VECTOR then
                  begin
                    left := bit_subscript^.left_index;
                    right := bit_subscript^.right_index;
                  end
                else
                  begin
                    left := -1;  right := -1;
                  end;

              if left > right then direction := -1 else direction := 1;

              actual := formal_actual_pair^.actual_parameter^.signal;
              while (actual <> NIL) do
                begin
                  width := width_of_signal_instance(actual^.instance);

                  right := left + (width-1)*direction;

                  { copy the properties from the PCS of the actual }

                  (********* don't need this, causes property duplication
                  if actual^.properties <> NIL then
                    add_pin_properties_to_subscript_property
                                              (formal_actual_pair^.properties,
                                               left, right,
                                               actual^.properties);
                   ********************)

                  { copy the properties from the actual signals themselves }

                  props_of_instance := get_all_properties(actual^.instance,
                                                          left, right,
                                                          TRUE);

                  current_prop := props_of_instance;
                  while current_prop <> NIL do
                    begin
                      add_pin_properties_to_subscript_property
                                              (formal_actual_pair^.properties,
                                               current_prop^.left_index,
                                               current_prop^.right_index,
                                               current_prop^.properties);

                      current_prop := current_prop^.next;
                    end;

                  left := right + direction;

                  actual := actual^.next;
                end;

              formal_actual_pair := formal_actual_pair^.next;
            end;
        end { not a plumbing body } ;

      if debug_14 then
        begin
          writeln(outfile, 'After copy to F/A:');
          dump_formal_actual_list(outfile, son^.params);
        end;

      son := son^.next;
    end;

  if debug_14 then
    writeln(outfile, 'Exiting copy_properties_from_actuals');
end { copy_properties_from_actuals } ;


(**)     { ------- remove pin properties from signals ------- }


procedure remove_all_pin_properties(node: mtree_node_ptr);
  { remove the pin properties from all of the signals used in this node and
    its plumbing body sons. }
  var
    son: mtree_node_ptr;                    { current son of this node }
    formal_actual_pair: formal_actual_ptr;  { current pin }
    actual: actual_list_ptr;                { current actual on pin }
    signal: propertied_CS_ptr;              { current signal in actual }


  function pin_has_INHERIT_PIN_property(pin: formal_actual_ptr): boolean;
    { return TRUE if the pin has any INHERIT_PIN properties attached }
    var
      sub_prop: subscript_property_ptr;     { current subscript property }
      prop: property_ptr;                   { current property of subscript }
      found: boolean;                       { TRUE if pin prop was found }
  begin
    sub_prop := pin^.properties;  found := FALSE;
    while (sub_prop <> NIL) and not found do
      begin
        prop := sub_prop^.properties;
        while (prop <> NIL) and not found do
          if INHERIT_PIN IN prop^.name^.kind then found := TRUE
          else prop := prop^.next;

        if not found then sub_prop := sub_prop^.next;
      end;

    pin_has_INHERIT_PIN_property := found;

    if debug_14 then
      begin
        writeln(outfile, 'Exiting pin_has_INHERIT_PIN_property=', ord(found):1,
                         '; f/a=');
        dump_formal_actual(outfile, pin);
      end;
  end { pin_has_INHERIT_PIN_property } ;


  procedure delete_pin_properties(def: signal_definition_ptr);
    { delete all pin properties from the given signal definition.  Mark the
      current signal definition as being "processed" by setting the
      instance list to NIL (normally an impossibility. }
    var
      saved_instances: signal_instance_ptr;   { list of instances of def }
      previous,                  { previous property on signal }
      next,                      { next property in the list }
      prop: bit_property_ptr;    { current property on signal }
      synonym: basescript_ptr;   { current "synonym" of this def }
  begin
    if debug_14 then
      begin
        writeln(outfile, 'Entering delete_pin_properties: def=');
        dump_signal_definition(outfile, def);
      end;

    { mark the current def; save the instances }

    saved_instances := def^.instances;
    def^.instances := NIL;

    { remove properties from the signals synonymed to this signal }

    synonym := def^.synonym_bits;
    while (synonym <> NIL) do
      begin
        if synonym^.instance^.defined_by^.instances <> NIL then
          delete_pin_properties(synonym^.instance^.defined_by);

        synonym := synonym^.next;
      end;

    { remove all of the properties from this signal }

    prop := def^.properties;  previous := NIL;
    while prop <> NIL do
      if INHERIT_PIN IN prop^.name^.kind then
        begin
          if previous = NIL then
            def^.properties := prop^.next
          else
            previous^.next := prop^.next;

          next := prop^.next;
          release_bit_property(prop);
          prop := next;
        end
      else
        begin  previous := prop;  prop := prop^.next;  end;

    { restore the instance list }

    def^.instances := saved_instances;

    if debug_14 then
      begin
        writeln(outfile, 'Exiting delete_pin_properties: prop_list=');
        dump_bit_property_list(outfile, def^.properties);
      end;
  end { delete_pin_properties } ;


begin { remove_all_pin_properties }
  if debug_14 then
    begin
      write(outfile, 'Entering remove_all_pin_properties: node=');
      print_string(outfile, node^.macro_name);
      writeln(outfile);
    end;

  son := node^.son;
  while son <> NIL do
    begin
      if son^.is_plumbing_node and not son^.is_cardinal_tap then
        remove_all_pin_properties(son);

      if debug_14 then
        begin
          write(outfile, ' processing body: ');
          print_string(outfile, son^.macro_name);
          writeln(outfile);
        end;

      formal_actual_pair := son^.params;
      while formal_actual_pair <> NIL do
        begin
          if pin_has_INHERIT_PIN_property(formal_actual_pair) then
            begin
              actual := formal_actual_pair^.actual_parameter;
              while actual <> NIL do
                begin
                  signal := actual^.signal;
                  while signal <> NIL do
                    begin
                      delete_pin_properties(signal^.instance^.defined_by);

                      signal := signal^.next;
                    end;

                  actual := actual^.next;
                end;

              { release all but the first actual in the list }

              release_complete_actual_list(formal_actual_pair^.
                                                      actual_parameter^.next);
            end;

          formal_actual_pair := formal_actual_pair^.next;
        end;

      son := son^.next;
    end;

  if debug_14 then
    writeln(outfile, 'Exiting remove_all_pin_properties');
end { remove_all_pin_properties } ;


(**)     { ------- check for the existence of unresolved signals ------- }


procedure check_for_unresolved_signals(node: mtree_node_ptr);
  { check all of the signals used within the given drawing (NODE) to see that
    they have resolved widths and assertions.  Since the only signals that
    matter are those connected to the pins of bodies within the drawing,
    signals connected to bodies within plumbing drawings called by the
    given drawing (NODE) do not have to be checked.  If bubble checking is
    OFF, the assertion_state flag will be KNOWN. }

  var
    son: mtree_node_ptr;                   { current body }
    formal_actual_pair: formal_actual_ptr; { current formal/actual pair }
    actual: actual_list_ptr;               { current actual on body }
    signal: propertied_CS_ptr;             { current signal in actual }
    found_width_error: boolean;            { TRUE if unresolved width found }
    width_not_known: boolean;              { TRUE if one actual's width unkn }
    found_assertion_error: boolean;        { TRUE if unresolved assert found }
    error_signal_list: signal_definition_list_ptr;


  procedure generate_error_message(error_num: error_range);
    { generate an error message for the current signal defined by the globals:
      SIGNAL^.INSTANCE^.DEFINED_BY.   Make sure that only one error message 
      per signal definition is produced.  ERROR_SIGNAL_LIST contains a list
      of all of the signal definitions for which errors have been reported.
      This routine cannot tell whether the error reported was a width or an
      assertion error.  Therefore, only one of these errors per signal is
      reported. }

    var
      def: signal_definition_ptr;            { def that is in error }
      error_def: signal_definition_list_ptr; { current element in list }
      found: boolean;                        { TRUE if signal is found }

  begin
    def := signal^.instance^.defined_by;

    error_def := error_signal_list;  found := FALSE;
    while (error_def <> NIL) and not found do
      if error_def^.definition = def then found := TRUE
      else error_def := error_def^.next;

    if not found then
      begin
        error(error_num { signal's width or assertion cannot be determined });
        error_dump_current_parse_environment;

        error_dump_formal_instance(formal_actual_pair^.formal_parameter);

        error_dump_signal_def(def);

        { add the def to the definition list so that we don't output again }

        new_signal_definition_list(error_signal_list);
        error_signal_list^.definition := def;
      end;
  end { generate_error_message } ;


  procedure fix_width_of_formal(formal_actual_pair: formal_actual_ptr);
    { If the formal's width is known, make sure ALL actuals have that width.
      If they don't, fix them by appending an NC signal.  If the formal's
      width is not known, find the actual with the largest width, assign
      the formal that width and make sure all other actuals have that width. }
    var
      actual: actual_list_ptr;      { current actual of the formal/actual }
      max_width,                    { maximum width of all signals }
      width: bit_range;             { current signal's width }
      signal: propertied_CS_ptr;    { current signal in actual }
  begin
    { determine the width for all the actuals by either finding the formal's
      width or the maximum actual signal's width. }

    if formal_actual_pair^.formal_parameter^.defined_by^.kind = UNDEFINED then
      begin
        { find the actual with the greatest width }

        actual := formal_actual_pair^.actual_parameter;  max_width := 0;
        while actual <> NIL do
          begin
            width := width_of_propertied_CS(actual^.signal);
            if width > max_width then max_width := width;

            actual := actual^.next;
          end;

        fix_instance_width(formal_actual_pair^.formal_parameter, max_width);
        formal_actual_pair^.width := max_width;
      end
    else
      max_width := 
               width_of_signal_instance(formal_actual_pair^.formal_parameter);

    { make sure all of the signals in the actual list have the correct width }

    actual := formal_actual_pair^.actual_parameter;
    while actual <> NIL do
      begin
        width := width_of_propertied_CS(actual^.signal);
        if width <> max_width then
          begin
            if not actual^.width_is_unknown then
              begin
                error(166 { signals with different widths on same pin });
                error_dump_current_parse_environment;
                error_dump_formal_instance
                                       (formal_actual_pair^.formal_parameter);
              end;

            signal := actual^.signal;
            while signal^.next <> NIL do signal := signal^.next;

            new_propertied_CS(signal^.next);
            signal := signal^.next;
            signal^.instance := build_NC_signal(max_width - width);
            signal^.control := IGNORE_ALL;
          end;

        actual^.width_is_unknown := FALSE;

        actual := actual^.next;
      end;
  end { fix_width_of_formal } ;


begin { check_for_unresolved_signals }
  if debug_1 or debug_11 then
    writeln(outfile, 'Entering check_for_unresolved_signals');

  error_signal_list := NIL;

  { check all of the bodies in the current drawing }

  push_error_info;
  init_error_info;
  current_macro_def := node^.macro;

  son := node^.son;
  while son <> NIL do
    begin
      if debug_1 or debug_11 then
        begin
          writeln(outfile, '  checking node: ');
          dump_path_name(outfile, son);
          writestring(outfile, son^.macro_name);
          writeln(outfile);

          writeln(outfile, '  F/A list:');
          dump_formal_actual_list(outfile, son^.params);
        end;

      current_body_node := son;
      current_page := son^.called_by^.page_number;

      { check each of the formal/actual pairs on the body }

      formal_actual_pair := son^.params;
      while formal_actual_pair <> NIL do
        begin
          width_not_known := FALSE;

          { check actual signal connected to the pin }

          actual := formal_actual_pair^.actual_parameter;
          while actual <> NIL do
            begin
              found_width_error := FALSE;  found_assertion_error := FALSE;
              if actual^.width_is_unknown or
                 (actual^.assertion_state = ASSERTION_UNKNOWN) then
                begin
                  { check each instance in the concatenated signal }

                  signal := actual^.signal;
                  while signal <> NIL do
                    begin
                      { check for unresolved width }

                      if actual^.width_is_unknown then
                        if signal^.instance^.defined_by^.kind = UNDEFINED then
                          begin
                            generate_error_message(156 { width is unknown });
                            fix_instance_width(signal^.instance, 1);
                            found_width_error := TRUE;
                          end;

                      { check for unresolved assertion }

                      if actual^.assertion_state = ASSERTION_UNKNOWN then
                        if signal^.instance^.defined_by^.polarity =
                                                         UNKNOWN_POLARITY then
                          begin
                            if bubble_check and report_unknown_assertions then
                              generate_error_message(154 {assertion unknown});
                            found_assertion_error := TRUE;
                            fix_polarity(signal^.instance^.defined_by,
			                 ASSERT_HIGH);
                          end;

                      signal := signal^.next;
                    end;
                end;

              actual^.assertion_state := ASSERTION_CHECKED;

              if found_width_error then width_not_known := TRUE;

              actual := actual^.next;
            end;

          if width_not_known then
            fix_width_of_formal(formal_actual_pair);

          if debug_1 or debug_11 then
            begin
              writeln(outfile, '  After fix in loop: F/A=');
              dump_formal_actual(outfile, formal_actual_pair);
            end;

          formal_actual_pair := formal_actual_pair^.next;
        end;

      son := son^.next;
    end;

  pop_error_info;

  release_entire_signal_definition_list(error_signal_list);

  if debug_1 or debug_11 then
    writeln(outfile, 'Exiting check_for_unresolved_signals');
end { check_for_unresolved_signals } ;


#include "expfile.p"
#include "fixsyn.p"
#include "invokes.p"


(**)     { ------- actual parameter evaluation ------- }


#include "bindings.p"
#include "pass1.p"


(**)     { ------- Macro expansion ------- }


procedure perform_macro_expansion(var p: pipe);
  { invoke the routines for each pass after setting up environment }
begin
  { root node has already been created (to initialize context) }

  mtree_root^.macro_name := root_macro_name;

  { process all drawings, parse signals, etc. }

  if PASS1(mtree_root, 1, FALSE) then ;

  init_output_continue;
  process_nodes_for_separate_compilation;
  process_signals_for_separate_compilation;

  output_numbered_dictionary(p, expansion_string_dictionary, 
                             FINISHED_DICTIONARY);
  output_numbered_dictionary(p, expansion_id_dictionary, 
                             FINISHED_DICTIONARY);
  output_heading(p, UNDEFINED_PAGE_NUMBER);
  output_context(p);
  output_drawing_properties(p);
  pipe_dump_char(p, ';');  { where old dependencies were }
  output_modules(p);
  output_synonyms(p);

  generate_expansion_file(p);

  output_signal_properties(p, mtree_root);
  pipe_dump_CRLF(p);

  pipe_dump_alpha(p, 'END.            ');
  pipe_dump_CRLF(p);
end { perform_macro_expansion } ;


(**)     { ------- gather statistics about synonyms ------- }


procedure calculate_synonym_statistics(sig_def: signal_definition_ptr);
  { gather statistics about synonyms from the given signal definition.  The
    information is kept in a number of global variables. }
  var
    sig_defs_non_base_bits: basescript_ptr;
    len: natural_number;


  function chain_length(BS: basescript_ptr): natural_number;
    { calculate the length of the longest synonym chain for the basescript }
    var
      len: natural_number;        { length of the current chain }
      length_so_far: bit_range;   { length of the chain as calculated }
      next_SI,                    { next signal instance in chain }
      SI: signal_instance_ptr;    { current signal instance }
      min_index,max_index,
      bit_of_interest,            { current bit of interest }
      next_bit,                   { next bit of the subscript }
      i: bit_range;               { index through the basescript }
      dummy: boolean;             { dummy return from function }
  begin
    length_so_far := 0;
    max_index := MAX(BS^.left_index,BS^.right_index);
    min_index := MIN(BS^.left_index,BS^.right_index);
    if BS <> NIL then
      for i := min_index to max_index do
        begin
          SI := sig_def^.instances;
          len := 0;
          bit_of_interest := i;
          { !!!! Change this crock to a repeat loop or else die !!!! }
          while NOT get_next_base_bit(SI, bit_of_interest, next_SI, next_bit)
                AND (len < BIGGEST_SYNONYM_CHAIN_BUCKET) do
            begin
              SI := next_SI;  bit_of_interest := 1 + next_bit; len := len + 1;
              dummy := nth_bit_of_signal_instance(bit_of_interest, SI);
            end;
          length_so_far := MAX(len, length_so_far);
        end;
    chain_length := length_so_far;
  end { chain_length } ;


  function number_of_SIs(sig_def: signal_definition_ptr): natural_number;
    { calculate number of signal instances on the definition }
    var
      SI_list: signal_instance_ptr;      { list of signal instances }
      number_instances: natural_number;  { number signal instances }
  begin
    number_instances := 0;  SI_list := sig_def^.instances;
    while SI_list <> NIL do
      begin
        number_instances := number_instances + 1;
        SI_list := SI_list^.next;
      end;
    number_of_SIs := number_instances;
  end { number_of_SIs } ;
    
  
  function number_of_base_SIs(sig_def: signal_definition_ptr): natural_number;
    { calculate the number of signal instances that are base entirely }
    var
      SI_list: signal_instance_ptr;     { current signal instance }
      number_instances: natural_number; { number of base signal instances }
  begin
    number_instances := 0;  SI_list := sig_def^.instances;
    while SI_list <> NIL do
      begin
        if is_base_instance(SI_list) then
          number_instances := number_instances + 1;
        SI_list := SI_list^.next;
      end;
    number_of_base_SIs := number_instances;
  end { number_of_base_SIs } ;


begin { calculate_synonym_statistics }
  sig_defs_non_base_bits := sig_def^.synonym_bits;

  if sig_defs_non_base_bits <> NIL then
    begin
      number_of_sig_defs_with_synonyms := number_of_sig_defs_with_synonyms+1;
      while sig_defs_non_base_bits <> NIL do
        begin
          number_of_basescripts := number_of_basescripts + 1;
          with sig_defs_non_base_bits^ do
            begin
              if left_index = right_index then 
                number_of_single_bit_basescripts :=
                                         number_of_single_bit_basescripts + 1;
              if offset = 0 then
                number_of_basescripts_with_non_zero_offset :=
                               number_of_basescripts_with_non_zero_offset + 1;
              total_width_of_basescripts := total_width_of_basescripts +
                                            1 + ABS(left_index - right_index);
            end;

          len := chain_length(sig_defs_non_base_bits);
          total_synonym_chain_length := total_synonym_chain_length + len;

          if len > BIGGEST_SYNONYM_CHAIN_BUCKET then
            synonym_chain_length[BIGGEST_SYNONYM_CHAIN_BUCKET] :=
                        synonym_chain_length[BIGGEST_SYNONYM_CHAIN_BUCKET] + 1
          else
            synonym_chain_length[len]:= synonym_chain_length[len] + 1;

          sig_defs_non_base_bits:= sig_defs_non_base_bits^.next;
        end;

      number_of_base_signal_instances := number_of_base_signal_instances +
                                                  number_of_base_SIs(sig_def);
    end
  else
    number_of_base_signal_instances := number_of_base_signal_instances +
                                                       number_of_SIs(sig_def);
end { calculate_synonym_statistics } ;


(**)     { ------- output various info about signals in the tree ------- }


procedure dump_tree_information(*var f: textfile; what: dump_debug_info_type*);
  { walk the mtree and output the specified information (WHAT) for each node }


  procedure init_synonym_statistics;
    { initialize the statistics for synonyms }
    var
      i: synonym_chain_range;    { index into histogram table }
  begin
    number_of_sig_defs_with_synonyms := 0;
    number_of_basescripts := 0;
    number_of_single_bit_basescripts := 0;
    number_of_basescripts_with_non_zero_offset := 0;
    total_width_of_basescripts := 0;
    number_of_base_signal_instances := 0;
    total_synonym_chain_length := 0;
    for i := 0 to BIGGEST_SYNONYM_CHAIN_BUCKET do
      synonym_chain_length[i] := 0;
  end { init_synonym_statistics } ;


  procedure dump_information(var f: textfile;  node: mtree_node_ptr;
                             what: dump_debug_info_type);
    { dump the specified information (WHAT) for the specified node (NODE)
      to the given file (F). }
    var
      signal: signal_definition_ptr;    { current signal }
  begin { dump_information }
    case what of
      DEBUG_DUMP_SYNONYMS:
        begin
          signal := node^.signals;
          while signal <> NIL do
            begin
              dump_synonyms_of_signal_definition(f, signal);

              signal := signal^.next;
            end;
        end;

      DEBUG_DUMP_SIGNAL_DEFINITIONS:
        dump_signal_definitions_with_basescripts(f, node^.signals);

      DEBUG_GATHER_SYNONYM_STATS:
        begin
          signal := node^.signals;
          while signal <> NIL do
            begin
              calculate_synonym_statistics(signal);

              signal := signal^.next;
            end;
        end;
    end { case } ;
  end { dump_information } ;


  procedure output_synonym_stats(var f: textfile);
    { output the statistics gathered from the signal in the mtree }
    var
      number_non_interface_signals: natural_number;   { everything else }


    procedure output_chain_bucket_histogram(var f: textfile);
      { output the chain bucket histogram to the given file }
      var
        i: synonym_chain_range;     { index into chain bucket table }
        j: natural_number;          { number in bucket }
        max: natural_number;        { maximum value in the table }
    begin
      writeln(f, ' Synonym chain length histogram');

      max := 1;
      for i := 0 to BIGGEST_SYNONYM_CHAIN_BUCKET do
        if synonym_chain_length[i] > max then
          max := synonym_chain_length[i];

      for i := 0 to BIGGEST_SYNONYM_CHAIN_BUCKET do
        begin
          write(f, i:4, ': ');

          for j := 1 to trunc((synonym_chain_length[i]/max)*60) do
            write(f, '*');

          if synonym_chain_length[i] = 0 then
            writeln(f)
          else
            writeln(f, synonym_chain_length[i]:1);
        end;
    end { output_chain_bucket_histogram } ;


    procedure output_number(n, total: natural_number);
      { output the given number (N) along with the percentage of the total }
    begin
      if total <= 0 then writeln(f)
      else writeln(f, n:1, ' (', (n/total)*100:3:1, '%)');
    end { output_number } ;


  begin { output_synonyms_stats }
    number_non_interface_signals := total_number_signals -
                                                     number_interface_signals;
    write(f, ' Number of sig defs with synonyms: ');
    output_number(number_of_sig_defs_with_synonyms,
                  number_non_interface_signals);

    writeln(f, ' Number of base scripts used:      ',
               number_of_basescripts:1);

    write(f, ' Number of single-bit basescripts: ');
    output_number(number_of_single_bit_basescripts,
                  number_of_basescripts);

    write(f, ' Number basescripts w/ <>0 offset: ');
    output_number(number_of_basescripts_with_non_zero_offset,
                  number_of_basescripts);

    writeln(f, ' Total width of basescripts:       ',
               total_width_of_basescripts:1);

    write(f, ' Number of base signal instances:  ');
    output_number(number_of_base_signal_instances,
                  number_non_interface_signal_instances);

    output_chain_bucket_histogram(f);

    writeln(f, ' Total synonym chain length:       ',
               total_synonym_chain_length:1);

    writeln(f);  writeln(f);
  end { output_synonym_stats } ;


  procedure dump_hierarchical_nodes(node: mtree_node_ptr);
    { output the information for this node and its sons }
    var
      son: mtree_node_ptr;          { current son node being processed }
  begin
    if node <> NIL then
      begin
        dump_information(f, node, what);
        if not node^.is_leaf_node then
          begin
            son := node^.son;
            while son <> NIL do
              begin  dump_hierarchical_nodes(son);  son := son^.next;  end;
          end;
      end;
  end { dump_hierarchical_nodes } ;


begin { dump_tree_information }
  if debug_20 then writeln(outfile, ' enter dump_tree_information');
  writeln(f);
  case what of
    DEBUG_DUMP_SIGNAL_DEFINITIONS:
      writeln(f, 'Dump of all the signals in the expansion tree');

    DEBUG_DUMP_SYNONYMS:
      writeln(f, 'Dump of all the synonyms in the expansion tree');

    DEBUG_GATHER_SYNONYM_STATS:
      begin
	writeln(f, ' -- Signal synonym stats --');
	init_synonym_statistics;
      end;

  end;
  writeln(f);

  dump_hierarchical_nodes(mtree_root);

  case what of
    DEBUG_GATHER_SYNONYM_STATS:
        output_synonym_stats(f);

    OTHERWISE
        { do nothing }
  end;
  if debug_20 then writeln(outfile, ' exit dump_tree_information');
end { dump_tree_information } ;


(**)     { ------- report pre 5.5 drawings ------- }


procedure report_pre_5_5_drawings;
  { report all drawings that have not been written with the 5.5 GED }
  var
    macro: macro_def_ptr;    { current macro in the design }
    first: boolean;          { TRUE if first macro yet to be printed }


  procedure output_macro_name(var f: textfile;  macro: macro_def_ptr);
    { output the name of the given macro }
  begin
    write(f, ' ');
    print_string(f, macro^.macro_name);
    
    write(f, '.');

    dump_string(f, er_extension(macro^.version));

    writeln(f, '.', er_version(macro^.version):1);
  end { output_macro_name } ;


  procedure welcome(var f: textfile);
    { report a header for the macro name list }
  begin
    writeln(f);
    writeln(f, ' The following drawings have not been written with the 5.5 ');
    writeln(f, ' or later version of the Graphics Editor:');
    writeln(f);
  end { welcome } ;
  

  procedure report_it(macro: macro_def_ptr);
    { report the macro as pre 5.5 }
  begin
    if first then
      begin
        if PrintCmpLst then page(CmpLst);
        error(95 { drawings have not been written with 5.5 GED });

        if PrintCmpLst then welcome(CmpLst);
        welcome(CmpLog);
        first := FALSE;
      end;

    if PrintCmpLst then output_macro_name(CmpLst, macro);
    output_macro_name(CmpLog, macro);
  end { report_it } ;


begin { report_pre_5_5_drawings }
  if not (95 IN suppress_errors) then
    begin
      macro := root_macro_def;  first := TRUE;
      while macro <> NIL do
        begin
          if not macro^.written_with_GED then report_it(macro);
          macro := macro^.next;
        end;

      macro := macro_def_list_root;
      while macro <> NIL do
        begin
          if not macro^.written_with_GED then report_it(macro);
          macro := macro^.next;
        end;
    end;
end { report_pre_5_5_drawings } ;


#include "linkercomm.p"
#include "page.p"
#include "../avl/compare.p"


(**)     { ------- The Program's Body! ------- }


procedure welcome;
  { announce the start of the compilation }
  const
    PREFIX_LENGTH = 13;       { length of '*  Compiling ' }
    SUFFIX_LENGTH = 3;        { length of '  *' }
    NO_PARAMS_LENGTH = 13;    { length of 'No parameters' }
  var
    param: property_ptr;                { current context parameter }
    i: string_range;                    { output index counter }
    length: string_range;               { length row of '*'s for Cmplst }
    drawing_spec_length: string_range;  { length of drawing.ext.ver.page }


  procedure dump_property(var f: textfile;  prop: property_ptr);
    { dump the property to f separated by an = and with the value quoted. }
  begin
    print_alpha(f, prop^.name^.name);
    write(f, '=');
    writestring(f, prop^.text);
  end { dump_property } ;


  function property_length(prop: property_ptr): natural_number;
    { Return the number of characters required to print the property with
      dump_property. }
  begin
    property_length :=
      ord(prop^.text^[0]) + alpha_length(prop^.name^.name) + 3;
  end { property_length } ;


begin { welcome }
  drawing_spec_length := 
    3           { 3 '.'s } +
    ord(root_macro_name^[0]) +
    alpha_length(extension_being_compiled^.name) + 
    width_of_integer(version_being_compiled) +
    width_of_integer(page_being_compiled);

  length := drawing_spec_length;

  length := max(NO_PARAMS_LENGTH, length);
  param := specified_context;
  while param <> NIL do
    begin
      length := max(property_length(param), length);
      param := param^.next;
    end;

  length := length + PREFIX_LENGTH + SUFFIX_LENGTH;

  if PrintCmpLst then
    begin
      writeln(CmpLst);

      write(CmpLst, ' ');
      for i := 1 to length do write(CmpLst, '*');
      writeln(CmpLst);

      write(CmpLst, ' *  Compiling ');
      print_string(CmpLst, root_macro_name);

      write(CmpLst, '.');
      print_alpha(CmpLst, extension_being_compiled^.name);
      write(CmpLst, '.', version_being_compiled:1,
                    '.', page_being_compiled:1);   
      write(CmpLst, ' ':(length - PREFIX_LENGTH - drawing_spec_length - 1));
      writeln(CmpLst, '*');
    end;

  writeln(monitor);
  write(monitor, ' Compiling ');
  print_string(monitor, root_macro_name);
  write(monitor, '.');
  print_alpha(monitor, extension_being_compiled^.name);
  write(monitor, '.', version_being_compiled:1,
                 '.', page_being_compiled:1);
  writeln(monitor);

  writeln(CmpLog);
  write(CmpLog, ' Compiling: ');
  print_string(CmpLog, root_macro_name);
  write(CmpLog, '.');
  print_alpha(CmpLog, extension_being_compiled^.name);
  write(CmpLog, '.', version_being_compiled:1,
                 '.', page_being_compiled:1);
  writeln(CmpLog);

  param := specified_context;
  if param = NIL then
    begin
      writeln(Monitor, '           No parameters');
      writeln(CmpLog, '            No parameters');
      if PrintCmpLst then
        begin
          write(CmpLst, ' *');  write(CmpLst, ' ':(prefix_length - 1));
          write(CmpLst, 'No parameters');
          write(Cmplst, ' ':(length - PREFIX_LENGTH - NO_PARAMS_LENGTH - 1));
          writeln(Cmplst, '*');
        end;
    end;

  while param <> NIL do
    begin
      write(Monitor, '           ');
      dump_property(Monitor, param);  Writeln(Monitor);

      write(CmpLog, '            ');
      dump_property(CmpLog, param);  Writeln(CmpLog);

      if PrintCmpLst then
        begin
          write(CmpLst, ' *');  write(CmpLst, ' ':(PREFIX_LENGTH - 1));
          dump_property(CmpLst, param);
          write(Cmplst, ' ':(length - PREFIX_LENGTH - 
                             property_length(param) - 1));
          writeln(Cmplst, '*');
        end;
      param := param^.next;
    end;

  if PrintCmpLst then
    begin
      write(CmpLst, ' ');
      for i := 1 to length do write(CmpLst, '*');
      writeln(CmpLst);
      writeln(CmpLst);
      write(CmpLst, ' ');
      dump_string(CmpLst, expansion_compile_time);
      writeln(CmpLst);
    end;
end { welcome } ;


#include "sepcomp.p"
#include "errordoc.p"
#include "comperr.p"


procedure catch_up_on_debug_flags;
  { Dump appropriate debug information that we could not dump before
    processing the directives (and opening outfile). }
begin
  if debug_21 then dump_command_line_arguments(outfile);
  if debug_22 then 
    begin
      writeln(Outfile, 'MONITOR opened to fd ', text_file_descr(Monitor):1);
      writeln(Outfile, 'CMPLOG opened to fd ', text_file_descr(CmpLog):1);
      writeln(Outfile, 'OUTFILE opened to fd ', text_file_descr(Outfile):1);
    end;
end { catch_up_on_debug_flags } ;


begin { main procedure }
#if PMAX
  argv(0, program_name);
  authorize(program_name);
#endif
#if PC_AT
  auth(argv[1]^);
#endif
  unbuf_stderr;
  init_interrupt;
#if VAX
  init_comp_vms; 
#endif

  init_time_and_date(start_elapsed_time, start_CPU_time, compile_date);
  last_elapsed_time := start_elapsed_time;
  last_CPU_time := start_CPU_time;

  initialise_data_services;

  init;                              { initialize the input routines }
  setup_directives_from_ds_module;
  {read_compiler_directives_file;      read in the compiler directives }

  catch_up_on_debug_flags;

  init_output_files;                 { open up appropriate output files }


  if command = COMPERR_COMMAND then comperr
  else perform_separate_compilation;

  exec_time(start_elapsed_time, start_CPU_time, FALSE);
  close_all_files;
  halt_with_status(SUCCESSFUL_COMPLETION); 

#if S32
end { main_procedure } ; 
begin { main } 
  main_procedure; 
#endif S32
end.
