

(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(*    SSS   CCC    A   L     DDDD                                          *)
(*   S   S C   C  A A  L     D   D                                         *)
(*   S     C     A   A L     D   D  ccc  oo  m   m ppp  i l     ee  rrr    *)
(*    SSS  C     A   A L     D   D c    o  o mm mm p  p i l    e  e r  r   *)
(*       S C     AAAAA L     D   D c    o  o m m m ppp  i l    eeee rrr    *)
(*   S   S C   C A   A L     D   D c    o  o m   m p    i l    e    r r    *)
(*    SSS   CCC  A   A LLLLL DDDD   ccc  oo  m   m p    i llll  eee r  r   *)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)


(*****************************************************************************

                          Copyright 1981,1985
                             
                    VALID LOGIC SYSTEMS INCORPORATED


This  listing  contains  confidential  proprietary information which is not to
be disclosed to unauthorized persons without the written consent of an officer
of Valid Logic Systems Incorporated.

The  copyright  notice  appearing  above  is  included  to  provide  statutory
protection  in the event of  unauthorized or unintentional  public disclosure.

Luigi "Kneebreaker" Cordola knows where your children live!

*****************************************************************************)


(**)


program compiler(input, output, monitor, outfile, CmpLog, CmpLst, CmpTmp,


                 Design);


(* NOTE -- this file now declares the constant max_string_length
   and the types string_range, char_array and sstring, so you
   should not also declare them.

   Sstring is a Valid (SCALD) string, with char count in the first byte.  
   Some of our programs use sstring for this type and some use xtring.
   There are many ways to resolve the conflict for those that use
   xtring.
*)

   
(* If platform is undefined, assume 1 *)


const
    stderrname = 'STANDARD_ERROR';
    stdoutname = 'STANDARD_OUTPUT';

    alfasize = 16;

    max_string_length = 255;
    bigenvalsize = 560;   { lcf added  & changed - used to be 255 }
    { This must be big enough to hold a termcap entry if we have to pick it
    up from the environment.  Some of the termcap entries for the Ann Arbor
    Ambassador -- which resembles the BBN window package -- are as big as
    558 chars. }
type

    alfa = packed array [1..alfasize] of char;

    binaryfile = file of integer;              { for binary output files }
    open_mode = (read_mode, write_mode, unbuf_read, unbuf_write);
    big_env_val_str = packed array [1..bigenvalsize] of char;

    string_range  = 0..max_string_length;
    char_array = packed array[string_range] of char;
    sstring = ^char_array;


function vopen(
    var fi : text;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code : integer
    ) : boolean; external;
{ Vopen is used by the compiler, simulator etc. to open 1 files by treating
an environment variable for that file's name as a logical name for the file. 
It is also capable of opening files directly by name -- if strname is non-NIL
and has non-0 length, then it is used as the name of the file. 
ret_code is a system-dependent error code -- it is an ioresult code for
the S32 and an errno code for the 1.  It can be converted into an SVS
code (for use with write_ioresult) by calling to_ioresult(ret_code). }

function ds_vopen(
    var fi : text;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code : integer
    ) : boolean; external;

procedure write_ioresult(var fi : text; iores : integer); external;
{ Given an error code returned by ioresult, print the appropriate error
message on file f. }

function to_ioresult(sys_code: integer): integer;  external;
{ Given a system dependent error code (as returned by vopen), return
  an approximately equivalent ioresult error code }

function text_file_descr(var f: text): integer; external;
{ Get the 1 file descriptor for this file.  Returns meaningless garbage
if the file is not open. }

function vclose(var fi : text): boolean; external;

function ds_vclose(var fi : text): boolean; external;

function vbinopen(
    var fi : binaryfile;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code: integer
    ) : boolean; external;
{ Same as fopen, but for binary files.  Used for Simulator trace file. }

function ds_vbinopen(
    var fi : binaryfile;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code: integer
    ) : boolean; external;

function vbinclose(var fi : binaryfile): boolean; external;

function ds_vbinclose(var fi : binaryfile): boolean; external;

function get_environment_variable(
    vbl: alfa;
    var val: big_env_val_str
    ): boolean; external;
{ Get the contents of an environment variable; return true if the variable
was defined.  Used by the Simulator to get screen length and width from
the environment. }


(* Clean up defines *)


(* If platform is undefined, assume 1 *)


const
    time_string_size = 26;
type
    time_string = packed array [1..time_string_size] of char;
    time_string_ptr = ^time_string;

function epochsec: integer; external;

function vclock: integer; external;

procedure convert_time(var secs: integer; var s: time_string); external;


(* Clean up defines *)


const


 {----------------------------  CONSTS  --------------------------------}

  WELCOME_MESSAGE = ' Valid Logic Systems, Inc.  ValidPAGECOMP  ';
  COMPERR_WELCOME = ' Valid Logic Systems, Inc.  ValidCOMPERR  ';
  COPYRIGHT_NOTICE = ' (C) Copyright 1982,1989 Valid Logic Systems, Inc.';


  MAXINT            = 2147483647;   { Maximum longint }


  EOL                   = 0;       { end of line character }
  TAB_CHAR              = 9;       { ASCII tab character }
  CONTINUATION_CHAR     = '~';     { line continuation character }
  NC_PREFIX_CHAR        = 1;       { prefixes NC signals to make special }
  VIRTUAL_PREFIX_CHAR   = '*';     { char used when creating NET_ID props }
  UNIQUE_PREFIX_CHAR    = '%';     { char used for creating NET_ID props }
  TIMING_ASSERTION_CHAR = '!';     { character flagging timing assertions }

  ID_LENGTH           = 16;        { number of characters in an id }
  MAX_BIT_VALUE       = MAXINT;    { maximum bit value for bit subscripts }
  INPUT_BUFFER_LENGTH = 80;        { length of the input line buffer }
  MAX_TM_PARAMETERS   = 4;         { maximum number of text macro parameters }
  MAX_TM_RECURSION    = 128;       { MAXIMUM ALLOWED DEPTH OF TM RECURSION }
  MAX_TREE_DEPTH      = MAXINT;    { maximum depth of expansion tree }
  MAX_NET_NUMBER_VALUE= MAXINT;    { maximum # nets per drawing }

  MAX_PATH_STRING_LENGTH = MAX_STRING_LENGTH;

  MAX_OUTPUT_FILE_LENGTH = 76;     { length of output files }

  BIGGEST_SYNONYM_CHAIN_BUCKET = 33;

  MAX_STACK           = 10;        { maximum text macro nesting }
  MAX_ENVIRONMENTS    = 15;        { maximum # of nested parse environments }

  SIGNAL_TABLE_SIZE         = 1114; { size of the signal table - 1 }
  SYNONYM_SIGNAL_TABLE_SIZE = 56;   { size of the synonym signal table - 1 }
  NAME_TABLE_SIZE           = 126;  { size of the identifier name table - 1 }
  SYNTAX_TABLE_SIZE         = 5;    { # elements of signal syntax }
  NET_GROUP_SIZE            = 19;   { # elements in net group - 1 }

  MIN_RADIX           = 2;         { minimum allowed input radix }
  MAX_RADIX           = 16;        { maximum allowed input radix }

  MESSAGE_LENGTH      = 17;        { length of debug messages }
  
  MAX_PAGE_NUMBER     = 10000;     { maximum number of pages of a drawing }
  MAX_VERSION_NUMBER  = 10000;     { maximum number of boolexprs for a macro }
  MAX_MENU_ENTRIES    = 256;       { max number of entries in a menu body }


  CLOCK_UNITS         = 1000;      { basic CLOCK time units }


  SUCCESSFUL_COMPLETION = 0; 
  WARNING_COMPLETION    = 8; 
  OVERSIGHT_COMPLETION  = 9; 
  ERROR_COMPLETION      = 10; 
  FATAL_COMPLETION      = 11;


  TIME_BUFFER_LENGTH  = 26; 


  NULL_ALPHA          = '                ';  

  CLOSED_ALPHA        = 'CLOSED          ';
  DEFINE_ALPHA        = 'DEFINE          ';

  DEBUG_PASSWORD      = 'FRAMITZ         ';
  CONFIGURE_PASSWORD  = 'ZZYZYX          ';

    
  { -- special characters -- }

  PATH_ELEMENT_SEPARATOR    = ' ';  { separator char for path names }
  PATH_PIECE_SEPARATOR      = '.';  { separator char between element pieces }
  SIZE_PREFIX_CHAR          = '#';  { prefix for size spec in path names }
  TM_PARAMETER_PREFIX_CHAR  = '%';  { prefix char for text macro parameters }
  OUTPUT_QUOTE_CHAR         = '"';  { quote character for separate compilation
				      output files (expansion file) }
  ERROR_POSITION_CHAR       = '^';  { pointer to position of error in line }
  OUTPUT_NWC_CHAR           = 'N';  { flags formal as NWC pin for linker }


  { -- consts for procedure parameters -- }

  MENUS_ONLY          = TRUE;      { parse menu bodies only in parse_macro_d }
  ALL_BODIES          = FALSE;     { parse all bodies in parse_macro_def }

  ALLOW_DUPLICATIONS  = TRUE;      { allow text macro duplications in add_TM }
  NO_DUPLICATIONS     = FALSE;     { the opposite of above }

  CRLF                = TRUE;      { output CRLF (passed parameter) }
  NOCRLF              = FALSE;     { don't output CRLF (passed parameter) }

  CHECK_AND_FIX       = FALSE;     { check AND fix unresolved width synonyms }
  JUST_CHECK          = TRUE;      { just check for existence of unresolved }

  PAD                 = TRUE;      { pad the output line (print_string_for) }
  NOPAD               = FALSE;     { don't pad the line }

  READ_AS_PARAMETERS  = TRUE;      { read user body parameters }
  READ_AS_PROPERTIES  = FALSE;     { read user body properties }

  ASSERT_LOW          = TRUE;      { signal is asserted low }
  ASSERT_HIGH         = FALSE;     { signal is asserted high }


  { -- special text macro defaults -- }

  DEFAULT_SIZE               = '1               ';
  DEFAULT_X_FIRST            = '0               ';
  DEFAULT_X_STEP             = 'SIZE            ';
  DEFAULT_X_STEP_FOR_LEAF    = '1               ';
  DEFAULT_X                  = 'X_FIRST         ';


  { -- consts for separate compilation -- }

  NO_SIZE_CONTEXT_NUMBER = 0;      { context assigned when there is no SIZE }
  UNDEFINED_VERSION_NUMBER = 0;    { indicates (to linker) that no version 
				     was identified (for context) due to error }
  UNDEFINED_PAGE_NUMBER = 0;       { indicates (to linker) that no page 
				     was actually compiled due to error }


  {------- string consts ---------------}

{ MAX_STRING_LENGTH   = 255;   }(*maximum length of character string*)(*370*)
  HASH_STRING_TABLE_SIZE    = 1110; { hash string table size - 1 }
  NUMBER_STRING_SIZES       = 33;   { number of discrete string sizes }

    { - misc -- }

    BUFSIZ = 1024; { 4.2 BSD -- BUFSIZ is 512 for 4.1c, so use the larger }

    UNIX_SUCCESS = 0;
    IBM_SUCCESS  = 0;
    VAX_SUCCESS = 0;

(**){--------- Constants that must match those used by et. -----}

  { attributes which can be initialized by the compiler, which passes an
     integer set as follows. }

ET_PERMIT_BODY        =    1;  { #define PERMIT_BODY    0x0001 }
ET_PERMIT_PIN         =    2;  { #define PERMIT_PIN     0x0002 }
ET_PERMIT_SIGNAL      =    4;  { #define PERMIT_SIGNAL  0x0004 }
ET_INHERIT_BODY       =    8;  { #define INHERIT_BODY   0x0008 }
ET_INHERIT_PIN        =   16;  { #define INHERIT_PIN    0x0010 }
ET_INHERIT_SIGNAL     =   32;  { #define INHERIT_SIGNAL 0x0020 }
ET_FILTER             =   64;  { #define FILTER         0x0040 }
ET_CONTROL            =  128;  { #define CONTROL        0x0080 }
ET_PARAMETER          =  256;  { #define PARAMETER      0x0100 }
ET_INT_PARAMETER      =  512;  { #define INT_PARAMETER  0x0200 }

{


}


  MAX_CLI_ARG_NUMBER = 10; { maximum number of command line arguments 
			     other than the program name }

  { If the CMPTMP_ARGS_NUMBERth command line argument = CMPTMP_ARGS_FLAG, 
    then the command line arguments are obtained from line one of the
    (logical) CMPTMP file.  This kludge bypasses the command line 
    mechanism for systems that munge arguments -- such as CMS }

  CMPTMP_ARGS_NUMBER = 3;   { same as separate compilation arg number }
  CMPTMP_ARGS_FLAG         = 'CMPTMP          ';

  DEFAULT_INDENT = 4;  { indentation for subsequent lines of broken strings }
  ERROR_MESSAGE_LENGTH = 44;
  MAX_ERROR_NUM        = 511;       { maximum error number }
  MAX_ASSERT_NUM       = 511;       { maximum assertion error number }

  MAX_DEBUG_FLAG_NUMBER      = 40;    { highest debug flag number }


  { NOTE: DIST_COMPILER locates DEFAULT_ERROR_FILE.  It should really
    be in /u0/scald/compiler, but has historically always been in
    /u0/scald.  If it is decided to correct this, then DIST_COMPILER
    can be changed to scald/compiler as would be expected. }


  DISTRIBUTION_DIR    = '/usr/valid/     '; 
  DIST_LANGUAGE       = 'tools/language/ '; 
  DIST_LIBRARY        = 'lib/            '; 
  DIST_COMPILER       = 'tools/compiler/ '; 


  DEFAULT_CONFIG_FILE = 'config.dat      '; 
  DEFAULT_PROP_FILE   = 'property.dat    '; 
  DEFAULT_TEXT_MACROS = 'textmacro.dat   '; 
  DEFAULT_MASTER_FILE = 'master.lib      '; 
  DEFAULT_ERROR_FILE  = 'cmperrors.mem   '; 
  DEFAULT_RULES_FILE  = 'expansion.dat   '; 
  DEFAULT_TEMP_FILE   = 'cmptmp.dat      '; 

  { -- logical output file names -- }

  MONITOR_FILE_NAME         = 'MONITOR         ';
  CMPLOG_FILE_NAME          = 'CMPLOG          ';
  DEBUG_FILE_NAME           = 'OUTFILE         ';
  CONFIG_FILE_NAME          = 'CONFIG          ';
  CMPLST_FILE_NAME          = 'CMPLST          ';
  CMPEXP_FILE_NAME          = 'CMPEXP          ';
  CMPERR_FILE_NAME          = 'CMPERR          ';
  CMPSYN_FILE_NAME          = 'CMPSYN          ';
  CMPTMP_FILE_NAME          = 'CMPTMP          ';
  CMPDRAW_FILE_NAME         = 'CMPDRAW         ';
  CMPXREF_FILE_NAME         = 'CMPXREF         ';
  CHIPS_FILE_NAME           = 'CHIPS           ';
  CMPHIER_FILE_NAME         = 'CMPHIER         ';
  DESIGN_FILE_NAME          = 'DESIGN          ';
  CMPSCHEM_FILE_NAME        = 'CMPSCHEM        ';

  LAST_PLUMBING_BUCKET          = 30;  { hash table size - 1 }
  PIPE_EOL = 10;           { ord of 'newline' char for pipe communication }


  LAST_NUMBERED_TOKEN_INDEX = 100; { Size of numbered token hash tables - 1 }

  UNKNOWN_TOKEN_NUMBER = 0;        { Indicates token number is unknown (so }
				   { requests lookup based on token value) }

  FINISHED_DICTIONARY = TRUE;      { Indicates to output_dictionary that      }
				   { dictionary is compiete and OUTPUT_NUMBER }
				   { fields may be assigned and used.         }

  UNFINISHED_DICTIONARY = FALSE;   { Indicates to output_dictionary that      }
				   { dictionary is not complete - use NUMBER  }
                                   { fields.                                  }

  {------ NUMBERED_TOKEN assertion message numbers -------}

  ASSERT_BUCKET_UNORDERED = 201;
  ASSERT_DUPLICATE_TOKEN_VALUE = 202;
  ASSERT_EXPECTED_CONST = 19;
  ASSERT_EXPECTED_CONSTANT = 19;
  ASSERT_EXPECTED_DOLLAR = 115;
  ASSERT_EXPECTED_EXCLAMATION = 217;
  ASSERT_EXPECTED_IDENT = 113;
  ASSERT_EXPECTED_SHARP = 114;
  ASSERT_EXPECTED_STRINGS = 18;
  ASSERT_LOOKING_FOR_UNKOWN_TOKEN = 203;
  ASSERT_NEW_NUMBER_IS_OLD = 204;
  ASSERT_UNRECOGNIZED_TOKEN_TYPE = 209;


  { The SCHEMA_SYNTAX_VERSION number is incremented each time there
    is a change to the syntax or semantics of the schema file or the
    expand file.  Incrementing the number causes all old expand and schema
    files to be re-generated (by recompilation). }

  SCHEMA_SYNTAX_VERSION = 48;

  { The following mask values are used to write the current values of some
    binary directives to the schema file as one integer. }

  BUBBLE_CHECK_MASK = 1;
  CARDINAL_TAP_MASK = 2;


  {----- SCHEMA error/assertion message numbers -----}

  ASSERT_DUPLICATE_EXPANDABLE_ID_NUMBERS = 214;
  ASSERT_DUPLICATE_PROPERTY_NUMBERS = 214; { same as preceeding }
  ASSERT_EXPECTED_AMPERSAND = 117;
  ASSERT_EXPECTED_PLUS = 118;
  ASSERT_EXPECTED_D = 119;
  ASSERT_EXPECTED_TIME = 120;
  ASSERT_EXPECTED_ID_LIST = 121;
  ASSERT_EXPECTED_ID_NUMBER = 122;
  ASSERT_EXPECTED_LOCAL_TM = 125;
  ASSERT_EXPECTED_MINUS = 125;
  ASSERT_EXPECTED_NUMBERED_ID = 122;
  ASSERT_EXPECTED_NUMBERED_STRING = 123;
  ASSERT_EXPECTED_PARAMETERS = 126;
  ASSERT_EXPECTED_PERCENT = 128;
  ASSERT_EXPECTED_PERIOD = 44;
  ASSERT_EXPECTED_R = 129;
  ASSERT_EXPECTED_RESERVED = 129;
  ASSERT_EXPECTED_DEPENDENCIES = 127;
  ASSERT_EXPECTED_STRING_NUMBER = 123;
  ASSERT_EXPECT_CONSTANT_OR_STRING_NUMBER = 130;
  ASSERT_EXPECT_EXPANDABLE_ID_ATTRIBUTES = 131;
  ASSERT_FAILED_ENTER_EXPANDABLE_ID = 210;
  ASSERT_NIL_NAME_TO_ENTER_EXPANDABLE = 211;
  ASSERT_UNRECOGNIZED_EVALUATION_KIND = 212;

  FATAL_SCHEMA_FILE_WRONG_TYPE = 223;


  { -- special signal names -- }

  SHORT_UNNAMED_SIGNAL       = 'UN              ';
  UNNAMED_SIGNAL             = 'UNNAMED         ';
  UNNAMED_SIGNAL_NAME_LENGTH = 7;

  NO_CONNECT_SIGNAL          = 'NC              ';
  SPECIAL_NC_NAME            = ' NC             ';
  LOCAL_SIGNAL_PREFIX        = 'PINNAME$        ';


  { -- default directive values -- }

  DEFAULT_RADIX              = 2;     { default signal const radix (<=10) }
  DEFAULT_WARNINGS           = TRUE;  { whether warnings are displayed }
  DEFAULT_OVERSIGHTS         = TRUE;  { whether oversights are displayed }
  DEFAULT_BUBBLE_CHECK       = TRUE;  { whether to bubble check }
  DEFAULT_CONST_BUBBLE_CHECK = FALSE; { whether to bubble chk constants }
  DEFAULT_MAX_ERRORS         = 1000;  { default maximum number of errors }
  DEFAULT_SCOPE_IS_LOCAL     = TRUE;  { initial default signal scope }
  DEFAULT_LEFT_TO_RIGHT      = FALSE; { bit ordering is right to left }
  MAX_PRINT_WIDTH            = 132;   { maximum output line length (chars) }
  MIN_PRINT_WIDTH            = 80;    { minimum output line width }
  DEFAULT_PRINT_FILES        = TRUE;  { generate ALL output files }
  

  { -- global defaults -- }

  DEFAULT_TM_EXPANSION    = FALSE; { do not expand TMs always }


  { -- default signal configuration characters -- }

  DEFAULT_CONCATENATION_CHAR           = ':';


  DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR = '\'; 


  { -- allocation sizes -- }


  MINIMUM_HEAP_INCREMENT = 2;
  HEAP_OVERHEAD          = 2;  { ? }


  POINTER_SIZE        = 4;         { number of bytes in a pointer }
  INT_SIZE            = 4;         { number of bytes in an integer }
  ALPHA_SIZE          = ID_LENGTH; { number of bytes in an alpha }
  BOOL_SIZE           = 2;         { number of bytes in a boolean }
  ENUM_SIZE           = 2;         { number of bytes in an enumerated scalar }


(**){--------- EXPANSION FILE CONSTANTS ----------------------}

  EXP_FILE_INHERIT_BODY_CHAR = 'I';
  EXP_FILE_INHERIT_PIN_CHAR = 'I';
  EXP_FILE_INHERIT_SIGNAL_CHAR = 'I';

  
  LAST_MODULE_TABLE_ENTRY = 101;
  
  { the following is value for force_to_primitive parameter of the
    output_heading procedure }

  USE_ACTUAL_EXTENSION = FALSE;

  EFS_PREFIX = '/net/           ';

  RIDICULOUS_KILL_COUNT = 3; { number of nice messages that will be 
                               printed in response to extra KILL signals }

type

 {-----------------------------  TYPES  --------------------------------}


  {---------------------}
  { miscellaneous types }
  {---------------------}


  natural_number    = 0..MAXINT;                  { natural number range }


  short_int         = -32767..32767;

  radix_range       = MIN_RADIX .. MAX_RADIX;     { valid radix range }
  print_width_range = 1..MAX_PRINT_WIDTH;         { range of print widths }
  unique_number     = natural_number;             { for NC signal creation }
  output_line_range = 0..MAX_OUTPUT_FILE_LENGTH;  { output file line length }

  xtring = sstring;          { sstring is declared in vopen }

  Cstring = ^char_array;     { a null-terminated string as used in the C
                               language }

  set_of_char = set of char;                      { to appease 1 pascal's
                                                    type checking. }
  synonym_chain_range = 0..BIGGEST_SYNONYM_CHAIN_BUCKET;
  synonym_chain_bucket = array[synonym_chain_range] of natural_number;


  file_kind_type = (LIST_FILE, DATA_FILE);        { see post_compile_time }

  version_page_error_type = 
    (VERSION_ERROR, PAGE_ERROR, CONN_ERROR); { see diplay_version_page_error }


  dummy_expansion_control_type = integer;  { some type of unknown structure to
					     which we can have a pointer }

  proc_status_type = -2..5 ;


  {-----------------------------------------------------------------}
  {  An exception handler is used to intercept Pascal run-time and  }
  {  operating system errors so that the Compiler can handle them.  }
  {  This is especially true for file opening and I/O.  This type   }
  {  is used to characterize the error that occurred.               }
  {-----------------------------------------------------------------}


  { EXCEPTION_ERROR_TYPE is used to specify the exception encountered }


  exception_error_type = (NULL_ERROR_CODE,       { no exception encountered }
                          OPEN_CREATE_FAIL,      { file open/create failure }
                          OPEN_ACCESS_FAIL,      { file open/access failure }
                          CLOSE_FAIL,            { file close failure }
                          RESET_FAIL,            { file RESET failure }
                          REWRITE_FAIL,          { file REWRITE failure }
                          BUFFER_NOT_ALLOCATED,  { file buffer not allocated }
                          INAPPROPRIATE_FILE_TYPE,{ just that }
                          LINE_LENGTH_EXCEEDED,  { output line len exceeded }
                          HEAP_OVERFLOW,         { HEAP overflow }
                          STACK_OVERFLOW);       { STACK overflow }


  { special types needed by VAX/VMS exception processor }

  signal_parameter_type = array [0..9] of integer;
  mechanism_parameter_type = array [0..4] of integer;


  { special types needed by the 370/CMS exception processor }

  errortype = 1..90;               { number of exception errors }
  erroractions = (XHALT,           { terminate program }
                  XPMSG,           { print pascal diagnostic }
                  XUMSG,           { print user's message }
                  XTRACE,          { print a trace back }
                  XDEBUG,          { invoke the debugger }
                  XDECERR,         { decrement error counter }
                  XRESERVED6, XRESERVED7, XRESERVED8, XRESERVED9,
                  XRESERVEDA, XRESERVEDB, XRESERVEDC, XRESERVEDD,
                  XRESERVEDE, XRESERVEDF);

  errorset = set of erroractions;


  {------------------------------------------------------------------}
  {  Procedure parameter types used to control operation of various  }
  {  procedures.                                                     }
  {------------------------------------------------------------------}

  property_selector = (ALL_PROPERTIES, INHERIT_PROPERTIES);


  {----------------------------------------------------------------------}
  {  The Compiler has a lexical analyzer that scans the input character  }
  {  stream and returns a series of tokens representing objects in the   }
  {  input.  These tokens are described via the following type.          }
  {----------------------------------------------------------------------}

  symbols = (NULLSY,                   { no symbol read }
             CONSTANT,                 { constant - string of digits }
             IDENT,                    { identifier }
             SIGNALCONST,              { constant with radix specification }
             STRINGS,                  { character string }

             { -- ASCII characters -- }
             SPACE, EXCLAMATION, QUOTE, SHARP, DOLLAR, PERCENT, AMPERSAND,
             LPAREN, RPAREN, ASTERISK, PLUS, COMMA, MINUS, PERIOD, SLASH,
             COLON, SEMI, LESSTHAN, EQUAL, GREATERTHAN, QUESTION, ATSY,
             LBRACKET, BACKSLASH, RBRACKET, CIRCUMFLEX, UNDERBAR,
             ACCENTGRAVE, VERTICALBAR, TILDA,
             
             { -- two-character symbols -- }
             LESY, GESY, NESY, LTSY, GTSY, DOTDOTSY, COLONCOLONSY,
             
             { -- arithmetic key words -- }
             ORSY, XORSY, MODSY, ANDSY, NOTSY, ABSSY, ORDSY, MINSY, MAXSY,
     
             { -- special signal key words -- }
             LOW_ASSERTED_SY, HIGH_ASSERTED_SY, NEGATION_SY,

             { -- special key words -- }
             ENDSY,

             { -- macro symbols -- }
             MACROSY, ENDMACROSY, INVOKESY, ENDINVOKESY, PROPERTYSY, 
             ENDPROPERTYSY, PINSY, ENDPINSY, BODYSY, 
             ENDBODYSY, BINDINGSY, ENDBINDSY, PARAMETERSY, ENDPARAMETERSY,
             
             { -- file symbols -- }
             FILETYPESY,

             { -- end of type and input data -- }
             ENDOFDATASY);

  setofsymbols = set of symbols;


  {-------------------------------------------------------------------}
  { An IDENTIFIER is used to describe an array of characters of fixed }
  { length.  All identifiers are hashed into a table and identifier   }
  { comparison for equality can be done by comparing pointers.  Each  }
  { identifier has a set of attributes used to interpret its meaning  }
  { when the identifier is a property name.  When the identifier is   }
  { found in the context of input parsing, the SY field is used to    }
  { specify whether the identifier is a symbol and which it is.       }
  {-------------------------------------------------------------------}

  
  id_range = 1..ID_LENGTH;                    { range of an identifier }
  alpha = packed array [id_range] of char;    { identifier type }


  {-----------------------------------------------------------------------}
  { Each identifier has attributes that describe its characteristics:     }
  {    PERMANENT        a text macro whose definition is assumed to never }
  {                     change, so will not be logged in schema files for }
  {                     use in "make" operations.  These should also be   }
  {                     RESERVED (though having the PERMANENT attribute   }
  {                     does not, by itself, imply this).                 }
  {    RESERVED         a global reserved (standard) text macro read from }
  {                     a text macro file.  This can not be overridden by }
  {                     local text macros or parameters.                  }
  {    UNRESERVED       a global unreserved text macro read from a text   }
  {                     macro file.  This can be overridden by local text }
  {                     macros or parameters.                             }
  {    KEY_WORD         a key word token (in some context).               }
  {    INHERIT_PIN      inherits from pin to signal to pin if property.   }
  {    INHERIT_SIGNAL   inherits from signal to signal across synomyms.   }
  {    INHERIT_BODY     inherits from father to son - on output.          }
  {    IS_PARAMETER     is parsed and expanded if body property.          }
  {    IS_INT_PARAMETER parsed as integer expression if body property.    }
  {    PERMIT_SIGNAL    permitted to be connected to a signal.            }
  {    PERMIT_PIN       permitted to be connected to a pin.               }
  {    PERMIT_BODY      permitted to be connected to a body.              }
  {    DONT_OUTPUT      property not output to files.                     }
  {    IS_ET_CONTROL    property is needed for controlling et (linker)    }
  {                         so it is output even if DONT_OUTPUT is set.   }
  {                         (TERMINAL is an example of this).             }
  {-----------------------------------------------------------------------}

  name_types = (FIRST_NAME_TYPE,
                PERMANENT, RESERVED, UNRESERVED, KEY_WORD,
                INHERIT_PIN, INHERIT_SIGNAL, INHERIT_BODY,
                IS_PARAMETER, IS_INT_PARAMETER,
                PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY,
                DONT_OUTPUT, IS_ET_CONTROL,
                LAST_NAME_TYPE);

  name_type_set = packed set of name_types;


  name_ptr = ^name_element;
  name_element = record
                   next: name_ptr;           { next in hash table thread }
                   name: alpha;              { identifier name }
                   kind: name_type_set;
                   definition: xtring;       { if RESERVED in kind }
                   sy: symbols;              { if KEY_WORD in kind }
                 end;

  name_table_range = 0..NAME_TABLE_SIZE;      { range of identifier table }

  name_table_type = array [name_table_range] of name_ptr;


  { length of the input line buffer }

  line_buffer_type = packed array [1..INPUT_BUFFER_LENGTH] of char;


  {-------------------------------------------------------------------------}
  { Symbol tables are used to store text macros, structures, and parameters }
  { for each drawing instance (mtree node).  Each table is organized as a   }
  { binary tree.                                                            }
  {-------------------------------------------------------------------------}

  compare_type = (LT, EQ, GT);       { for comparing links in tree }

  identifier_ptr = ^identifier;
  identifier = record
                 next: identifier_ptr;    { used to link fields of a record }
                 name: name_ptr;          { name of this identifier }
                 definition: xtring;      { definition of the identifier }
		 resolves: boolean;       { True if definition was resolved
					    without error }
               end;

  bit_range = -1..MAX_BIT_VALUE;


  {---------------------------------}
  { A property is a name/value pair }
  {---------------------------------}
  
  property_types = (BODY_PROPERTY, PIN_PROPERTY, PARAMETER_PROPERTY);

  property_set = set of property_types;
  
  property_ptr  = ^property_list;
  property_list = record
                    next: property_ptr;   { ^ next property in the list }
                    name: name_ptr;       { property name }
                    text: xtring;         { property value }
                    free: boolean;
                  end;


  make_pass_type = (NO_PASS, MAKE_PASS_1, MAKE_PASS_2);


  avl_ptr = ^avl; { forward reference -- see ../avl/types.pas }


{ ----------------------------------------------------------------------- }


  {---------------------------------------------------------------------}
  { A STRING is represented as a pointer to a packed array of char:     }
  {                                                                     }
  {    string = ^packed array [0..255] of char;                         }
  {                                                                     }
  { Each string, however, is usually less than 255 characters.  The     }
  { actual length of the string is found in the first byte:  string^[0].}
  { The length of the string is static;  it should not be changed once  }
  { the string has been created.                                        }
  {                                                                     }
  { Strings can be up to 255 characters long.  The programmer must make }
  { sure that characters are not written beyond the end of the string.  }
  {                                                                     }
  { Strings are created on the heap in quantized lengths.  There are 33 }
  { different length arrays created.  The CREATE_A_STRING routine       }
  { creates an array on the heap big enough to support the given string.}
  { Strings may be released for use at a later time (RELEASE_STRING).   }
  {                                                                     }
  { Strings are hashed into a table so that string compare for equality }
  { can be done by comparing pointers.                                  }
  {                                                                     }
  { The basic types are declared in the vopen unit.                     }
  {---------------------------------------------------------------------}

  {------- string table types ---------------}

  freeptr = ^free_element;
  free_element = record
                   next: freeptr;     { next in linked list of free strings }
                   str: xtring;       { ^ free string element }
                 end;            

  hash_string_ptr = ^hash_string;
  hash_string = record
                  next_hash_string: hash_string_ptr;   { next in bucket }
                  str: xtring;                         { the string }
                end;

  hash_string_range = 0..HASH_STRING_TABLE_SIZE;   { size of hash table }

  hash_string_table_type = array [hash_string_range] of hash_string_ptr;


  { for h of type string_hack and xtring x, use the following to write xtring
    x to some file --
      h.i := ord(x) + 1;
      write(f, h.s^:ord(x^[0]));
    this is MUCH faster than 1 char at a time and works on all of
    our supported platforms.                                         }

  nolength_string = packed array[1..MAX_STRING_LENGTH] of char;


  string_hack = record

    case boolean of
      TRUE: (i: integer);
      FALSE:(s: ^nolength_string);
  end;
    { 1 types }

    Cint      = integer;
    Clong     = integer;
    Cptr      = integer;
  
    Cfile = record  { See file fio.c for use of this record }
      f: Cptr;
      buffer: packed array[1..BUFSIZ] of char;
    end;

{-----------------------------------------------------------------------}
{ Records are scratch records for sargv and sargc, (which imitate       }
{ 1 argv and argc).  They must be initialized by calling             }
{ init_cli_structures.  They are not to be accessed directly            }
{ other than by sargc and sargv, as they may or may not be used         }
{ depending on the implementation of those routines on the              }
{ current operating system.                                             }
{                                                                       }
{ These ideally would be local and static to those routines, but that   }
{ is not always possible in PASCAL.                                     }
{-----------------------------------------------------------------------}


  { scratch structures for sargv and sargc }
  cli_arg_range = 0..MAX_CLI_ARG_NUMBER;   
  cli_arg_index = -1..MAX_CLI_ARG_NUMBER;
  cli_arg_array_type =  array[cli_arg_range] of xtring;


  {-----------------------------------------------------------------------}
  {  Error handling is done through a number of common routines.  Errors  }
  {  are specified by number.  The current environment in which parsing   }
  {  takes place is described by a stack.  The top of the stack describes }
  {  the current environment.  This is output whenever a parse error is   }
  {  detected or can be output explicitly.                                }
  {-----------------------------------------------------------------------}

  assert_range  = 0..MAX_ASSERT_NUM;
  error_range   = 0..MAX_ERROR_NUM;  { error 0 is ALWAYS suppressed }
  assert_set    = set of assert_range;
  error_set     = set of error_range;
  error_message = packed array [1..ERROR_MESSAGE_LENGTH] of char;
  error_type    = array [error_range] of error_message;
  assert_type   = array [assert_range] of error_message;
  message_type  = packed array [1..MESSAGE_LENGTH] of char;

  output_page_range = 0..MAXINT;

  mtree_node_ptr = ^mtree_node;  { forward pointer declaration }
  macro_def_ptr = ^macro_def;    { forward pointer declaration }

  environment_ptr = ^environment;
  environment = record
                  next: environment_ptr;           { next environment(father) }
                  file_name: xtring;               { current_file_name }
                  macro: macro_def_ptr;            { macro being processed }
                  page_number: 0..MAX_PAGE_NUMBER; { current page number }
                  body_node: mtree_node_ptr;       { body mtree node }
                  body_name: xtring;               { body within macro }
                  path_name: xtring;               { path prop for body }
                  property_name: name_ptr;         { current_property_name }
                  property_value: xtring;          { current_property_value }
                end;


  {-------------------------------------------------------------------}
  { debug flags are used to enable/disable output to the OUTFILE file }
  {-------------------------------------------------------------------}

  debug_controls = (FIRST_CONTROL,
                    CONTROL_DUMPTREE,         { symbol table dumps }
                    CONTROL_DUMPSIGNALS,      { signal def dump at end }
                    CONTROL_PRINTMACROS,      { macro def dump }
                    CONTROL_PRINTDIRECTORY,   { SCALD directory dump }
                    CONTROL_PRINTHISTOGRAMS,  { histograms of hash tables }
                    CONTROL_DUMPSIGDEFLIST,   { dump of node's signals }
                    CONTROL_DUMP_ALL_NAMES,   { dump of NAME hash table }
		    CONTROL_ERULE_XFACE,      { dump activity of erule module }
                    LAST_CONTROL);

  debug_control_list = array [debug_controls] of name_ptr;

  debug_flag_range = 0..MAX_DEBUG_FLAG_NUMBER;

  histogram_types = (FIRST_HISTOGRAM,
                     DIRECTORY_HISTOGRAM,     { SCALD directory histogram }
                     SIGNAL_HISTOGRAM,        { signal table histogram }
                     NAME_TABLE_HISTOGRAM,    { name hash table histogram }
                     STRING_TABLE_HISTOGRAM,  { string hash table histogram }
                     LAST_HISTOGRAM);

  histogram_set = set of histogram_types;
  histogram_table = array [histogram_types] of name_ptr;

  dump_debug_info_type = (DEBUG_DUMP_SYNONYMS,
                          DEBUG_DUMP_SIGNAL_DEFINITIONS,
                          DEBUG_GATHER_SYNONYM_STATS);

  debug_flag_set = set of debug_flag_range;


  {-------------------------------------------------------------------}
  { The lexical analyzer scans the input stream returning a string of }
  { tokens (see SYMBOLS type).  When a new input stream is opened for }
  { scanning, the old stream can be pushed onto a stack so that the   }
  { scanner can return to it when done with the new stream.  This is  }
  { how, for example, text macros are processed.                      }
  {-------------------------------------------------------------------}


  parse_type = (PARSE_TRANSPARENTLY,       { parse string transparently }
                PARSE_SEPARATELY);         { parse string stand-alone }

  { NOTE on parse_type: PARSE_TRANSPARENTLY implies that the current
    string is a text macro definition.  This implication is important, as
    it is used to control the TM nesting depth count.  When a string
    that has been parsed "transparently" is popped, the depth is decremented.
    See parse_string and pop_parse_string (procedures). }

  parse_state = (FINIT, FINPUT, FGOT_CHAR);    { input scanner state }

  parse_file_type = (UNKNOWN_FILE,       { state when no file is open }
                     DIRECTIVES_FILE,    { directives file is open (infile) }
                     STANDARD_FILE,      { standard file is open (CmpStan) }
                     TEMP_FILE,          { Temp file is open (CmpTmp)}
                     CMPDRAW_FILE,       { cmpdraw file is in use (CmpDraw)}
		     CMPSCHEM_FILE);     { Schema file is in use 
		                           NOTE: if the drawing is going to
					   be compiled, then CmpSchemI stays
					   open until readly to write it
					   out to keep it locked }

  saved_parse_info = record
                       str: xtring;         { save of INSTRING }
                       last_pos,            { save of LAST_SYM_POS }
                       pos: string_range;   { save of LINEPOS }
                       state: parse_state;  { save of READ_STATE }
                       last: char;          { save of LASTCHAR }
                       symbol: symbols;     { save of SY }
                       constant: integer;   { save of CONST_VAL }
                       how: parse_type;     { save of HOW_TO_PARSE }
                       allow_TM: boolean;   { save of ALLOW_TM_EXPAND }
                       keys: setofsymbols;  { save of ALLOWED_KEY_WORDS }
                     end;

  parse_stack = array [1..MAX_STACK] of saved_parse_info;
  
  stack_index_range = 0..MAX_STACK;

  radix_characters = array[radix_range] of set_of_char;

  digit_width_list = array[radix_range] of natural_number;
  

  {------------------------------------------------------------------------}
  { The parser consists of a number of procedures designed to parse, using }
  { the lexical analyzer, the input files or contents of strings.          }
  {------------------------------------------------------------------------}

  expression_type = (ALLOW_RELOPS, NO_RELOPS);

  syntax_specifier_type = (FIRST_SYNTAX_SPECIFIER,
                           NEGATION_SPECIFIER,
                           NAME_SPECIFIER,
                           SUBSCRIPT_SPECIFIER,
                           ASSERTION_SPECIFIER,
                           PROPERTY_SPECIFIER,
                           NULL_SPECIFIER,
                           LAST_SYNTAX_SPECIFIER);

  syntax_specifier_set = set of syntax_specifier_type;

  syntax_specifier_name_type = array [syntax_specifier_type] of name_ptr;

  signal_syntax_range = 1..SYNTAX_TABLE_SIZE;

  signal_syntax_table_type =
                         array [signal_syntax_range] of syntax_specifier_type;


  { Basic file types }

  textfile = text;             { output files }

  inputfile = Cfile; 


  time_stamp = integer;

  { lists of files to be read as specified by directives }

  file_list_ptr = ^file_list_type;
  file_list_type = record
    next: file_list_ptr;             { next file in the list }
    file_name: xtring;               { name of the file }
  end;

  file_types = (FIRST_FILE_TYPE,

                { NOTE: the PASCAL interface to the expansion rules package 
		  counts on the ordinal values of the following  -- 
		  leave them alone or coordinate with it. }

                CONNECTIVITY,            { post 6.0 GED connectivity file }
                SPECIAL_MODEL_FILE,      { non-graphical "primitive"      }
                SCHEMA_FILE,
                EXPANSION_FILE,
                LISTING_FILE,
                LINKER_LIST_FILE,

                { End of values required by expansion rules package }

                MACRO_DEFINITION,        { pre 7.0 GED connectivity file  }
                SPECIAL_TEXT_MACROS,     { TEXT MACRO specifications      }
                PROPERTY_ATTRIBUTES,     { PROPERTY attributes file       }
                EXPANSION_RULES,         { Expansion rules file           }
                CONFIGURATION_SPEC,      { signal configuration file      }
                MASTER_LIBRARY,          { master library description     }
		SCALD_DIRECTORY_FILE,
                LAST_FILE_TYPE);

  set_of_file_types = set of file_types;
  list_of_file_types = array [file_types] of name_ptr;
  {------------------------------------------------------------------}
  { A directory_list is a list of SCALD directories or libraries     }
  { specified by the directory or library directives.                }
  {------------------------------------------------------------------}

  directory_list_ptr = ^directory_list;
  directory_list = record
    next: directory_list_ptr;   { ^next input directory }
    name: xtring;               { scald directory / library name }
    add: xtring;                { add directory name }
  end;
  version_range = 0..MAX_VERSION_NUMBER;  { 0 being undefined }
  page_range = 0..MAX_PAGE_NUMBER;        { 0 being undefined }

  {----------------------------------------------------------------}
  { The plumbing_table contains an entry for each plumbing drawing }
  { already processed.  It contains the macro def as well as a     }
  { list of the files comprising it (so that they can be added to  }
  { dependency lists without further need of system calls.         }
  {----------------------------------------------------------------}

  { linked list of files containing pages of the same plumbing drawing }

  plumbing_page_ptr = ^plumbing_page;
  plumbing_page = record
    next: plumbing_page_ptr;    { next: page order list }
    page_number: page_range;
    filename: xtring;
    last_modified_time: time_stamp;  { time file was last modified }
  end;

  plumbing_module_ptr = ^plumbing_module;
  plumbing_module = record
    next: plumbing_module_ptr;       { Within bucket }
    macro_name: xtring;              { Key has 3 parts }
    extension: name_ptr;             { "    "  "  "    }
    version_number: version_range;   { "    "  "  "    }
    pages: plumbing_page_ptr;
    macro: macro_def_ptr;
  end;

  plumbing_table_range = 0..LAST_PLUMBING_BUCKET;
  plumbing_table_type = array [plumbing_table_range] of plumbing_module_ptr;

  {------------------------------------------------------------}
  { A pipe is a record that describes a pipe or file open for  }
  { reading or writing.  The structure is passed to a set of   }
  { routines which factor out system dependencies in           }
  { reading/writing pipes or files.  As a matter of style,     }
  { these are always passed by reference (as are file          }
  { variables).                                                }
  {------------------------------------------------------------}


  pipe_open_state = (PIPE_NOT_OPEN, PIPE_OPEN_FOR_READ, PIPE_OPEN_FOR_WRITE);
  pipe_files = (FIRST_PIPE,
		EXPANSION_PIPE,
                SCHEMA_PIPE,
                TO_ET_PIPE,
                FROM_ET_PIPE,
		TEMP_PIPE,
		LAST_PIPE);
  read_result = (READ_OK, READ_OVERFLOW, READ_EOF);
  pipe = record
    which: pipe_files;       { which file/pipe is this ? }
    fd: Cint;                { file descriptor for pipe (if is_pipe) }
    name: xtring;            { file name (if a file opened by name -- else
                               nullstring. }
    state: pipe_open_state;  { what can we legally do? }
    is_pipe: boolean;        { else is file }
    written: boolean;        { TRUE iff we have written to pipe }
  end;


(**){--------- NUMBERED_TOKEN STRUCTURES ----------------------------}


  {----------------------------------------------------------------}
  { Numbered tokens are used in the schema file to save space.     }
  { A numbered_token (hash) table is built for each type of token  }
  { and is  used to find the actual token.  References to tokens   }
  { within schema structures are made via pointers to these table  }
  { entries.  This allows access to the number or associated token }
  { as well as pointer comparison for EQ or NE.                    }
  { When inserting tokens into the dictionary, a check is made to  }
  { insure that the proper dictionary is being used for the token  }
  { type and that HIGHEST is kept updated for that dictionary.     }
  { (When new elements are added that were not previously in the   }
  { dictionary, they are assigned the number HIGHEST+1, with       }
  { HIGHEST then being incremented.                                }
  {                                                                }
  { The TABLE field of a dictionary sorts the entries by number.   }
  { The INVERSE_TABLE field of a dictionary contains entries which }
  { point to the entries in the TABLE field, but the are sorted    }
  { on the (string or id) value.                                   }
  {                                                                }
  { The buckets are sorted in descending order when read in, and   }
  { then reversed and written in ascending order when the file is  }
  { written.  This causes all insertions into the table to be to   }
  { the front of the appropriate bucket.                           }
  {                                                                }
  { The OUTPUT_NUMBER  field exists to allow the elements of the   }
  { table to be renumbered prior to output so as to re-use numbers }
  { that have been deleted.  The USED field allows detection of    }
  { obsolete tokens. A flag on the output_token_dictionary         }
  { procedure indicates whether or not to use these fields to do   }
  { "clean up".  This sort of clean up must only be done when      }
  { writing out the entire file when completely done with it AND   }
  { when the entire file has been parsed, so that it is known that }
  { all used tokens have been seen.                                }
  {                                                                }
  { Tokens are numbered from 1 to MAXINT, with 0 being used to     }
  { represent "unknown".  0 is never output from the dictionary as }
  { the linker implements the 2 kinds of dictionaries by inverting }
  { the values for one of them.                                    }
  {                                                                }
  { Access to dictionaries is done ONLY through the following      }
  { routines:                                                      }
  {   init_numbered_token                                          }
  {   new_numbered_token                                           }
  {   release_numbered_token                                       }
  {   new_numbered_token_list                                      }
  {   release_numbered_token_list                                  }
  {   insert_numbered_token                                        }
  {   find_numbered_token                                          }
  {   delete_numberd_token                                         }
  {   output_numbered_dictionary                                   }
  {   parse_numbered_dictionary                                    }
  {   release_numbered_dictionary                                  }
  {   init_numbered_dictionary                                     }
  {   enter_numbered_id                                            }
  {   enter_numbered_string                                        }
  {   find_numbered_id                                             }
  {   find_numbered_string                                         }
  { which are found (and fully described) in file "numbtoken.pas". }
  {----------------------------------------------------------------}


  numbered_token_type = (STRING_NUMBER, IDENTIFIER_NUMBER);
  numbered_token_range = 0..MAXINT;

  numbered_token_ptr = ^numbered_token;
  numbered_token = record
    next: numbered_token_ptr;            { next item in bucket }
    number: numbered_token_range;        { the token number }
    output_number: numbered_token_range; { the number to be used on final 
					   output }
    used: boolean;                       { TRUE iff this token is in use - 
					   meaning it has been found or 
					   inserted since reading in the table }
    case numbered_token_type of
      STRING_NUMBER: (string_p: xtring);           { represented string }
      IDENTIFIER_NUMBER: (identifier_p: name_ptr); { represented id }
  end;

  numbered_token_list_ptr= ^numbered_token_list;
  numbered_token_list = record
    next: numbered_token_list_ptr;     { next item in list (or bucket) } 
    token: numbered_token_ptr;         { numbered token in the list }
  end;

  numbered_token_table_range = 0..LAST_NUMBERED_TOKEN_INDEX;
  numbered_token_table = array[numbered_token_table_range] of
    numbered_token_ptr;
  numbered_token_list_table = array[numbered_token_table_range] of
    numbered_token_list_ptr;

  numbered_dictionary = record
    highest: numbered_token_range; { Highest number in this table }
    kind: numbered_token_type;     { The type of token allowed in this dic }
    active: boolean;               { TRUE iff insertions can be done }
    table: numbered_token_table;   { The table of numbered tokens            }
				   { (all of the same type) sorted by number }
    inverted_table:                { Inverted (sorted by value) table refering }
      numbered_token_list_table;   { to the same set of tokens.                }
  end;


(**){--------- SCHEMA STRUCTURES ----------------------------------}


  {----------------------------------------------------------------}
  { A context describes a list of parameters and their values that }
  { have been defined for an invocation of a drawing.              }
  { PARAMETERs are always sorted on the parameter name with        }
  { SIZE first and the remaining parameters following in           }
  { lexicographic order.                                           }
  { Contexts are numbered within the schema file so that each page }
  { can have a list of them for which its results are thought to   }
  { be up-to-date.                                                 }
  {----------------------------------------------------------------}

  parameter_ptr = ^parameter;
  parameter = record
    next: parameter_ptr;                { next parameter in context }
    name: numbered_token_ptr;           { parameter name (an identifier) }
    text: numbered_token_ptr;           { parameter value (a string) }
  end;

  context_definition_ptr = ^context_definition;
  context_definition = record
    next: context_definition_ptr;    { next context for this drawing }
    number: integer;                 { The context number }
    version: version_range;          { version that maps to this context }
    parameters: parameter_ptr;       { The parameters in the context }
  end;


  {----------------------------------------------------------------}
  { Schema files list local macro definitions on a page-by-page    }
  { basis.  This allows them to be known when compiling any page.  }
  { Global macros defined for identifiers used in the drawing are  }
  { also listed.                                                   }
  {----------------------------------------------------------------}

  text_macro_ptr = ^text_macro;
  text_macro = record
    next: text_macro_ptr;      { link }
    reserved: boolean;         { TRUE iff is a reserved global macro }
    name: numbered_token_ptr;  { name of the text macro }
    text: numbered_token_ptr;  { text macro definition }
  end;


  {----------------------------------------------------------------}
  { The file dependency list contains the files (other than the    }
  { drawing page itself) that were read to compile the page.  This }
  { includes all plumbing drawing pages encountered and allows     }
  { these to be taken into account when doing a "make" on the      }
  { drawing.   This is a kludge, as it does not allow plumbing     }
  { drawings to be moved without causing drawings using them to be }
  { re-made.                                                       }
  {----------------------------------------------------------------}

  dependency_list_ptr = ^dependency_list;
  dependency_list = record
    next: dependency_list_ptr;       { next in the list }
    file_name: numbered_token_ptr;   { rooted name of file }
    last_modified_time: time_stamp;  { time stamp on the file }
  end;
  
  {----------------------------------------------------------------}
  { A PAGED_SCHEMA describes the expandable identifiers that have  }
  { been found for a page of a drawing.  They also list the local  }
  { macro definitions that are defined on that page, the           }
  { properties occuring in the page and the dependency of that     }
  { page's results on other drawings (plumbing drawings).          }
  { It also lists the contexts for which the page has been         }
  { compiled (that are beleived to be up-to-date).                 }
  {----------------------------------------------------------------}


  expandable_id_ptr = ^expandable_id;
  expandable_id = record
    next: expandable_id_ptr;     { Next expandable id in page }
    name: numbered_token_ptr;    { table entry for id }
  end;

  compiled_context_list_ptr = ^compiled_context_list;
  compiled_context_list = record
    next: compiled_context_list_ptr;  { next in the list }
    context: context_definition_ptr;  { a context for which this page has
                                        been compiled }
    dirty: boolean;                   { Out-of-date for recompilation on
                                        pass 1. }
    dirty_for_pass_2: boolean;        { Dirty by way of factors discovered
                                        while compiling pages during the
					first pass (such as changes to
					local text macro defs }
  end;

  paged_schema_ptr = ^paged_schema;
  paged_schema = record
    next: paged_schema_ptr;              { next one for this drawing }
    drawing_type: numbered_token_ptr;    { logic, time, sim, etc. }
    version: version_range;              { version }
    page: page_range;                    { page }
    last_modified_time: time_stamp;      { time stamp on connectivity file }
    expandable_ids: expandable_id_ptr;   { The identifiers that are       
				           "expandable" within this page }
    local_text_macros: text_macro_ptr;   { Local text macros defined in
					   this page }
    dependencies: dependency_list_ptr;   { Plumbing bodies encountered }
    properties: numbered_token_list_ptr; { properties occurring in page }
    compiled_contexts: 
      compiled_context_list_ptr;         { list of contexts for which this
                                           page has been compiled }
    has_expr: boolean;                   { Has expression property ?? }
    make_performed: boolean;             { TRUE when time stamp has been
                                           checked }
  end;


  {----------------------------------------------------------------}
  { A PROPERTY_ATTRIBUTE describes the defined attributes for all  }
  { a property used in some page or pages of the drawing.  These   }
  { are checked against the currently defined attributes to        }
  { determine whether some pages need to be recompiled based on a  }
  { change in property attributes.                                 }
  {----------------------------------------------------------------}

  property_attribute_ptr = ^property_attribute;
  property_attribute = record
    next: property_attribute_ptr;  { next in list of properties used }
    property: numbered_token_ptr;  { name of property (identifier) }
    attributes: name_type_set;     { last defined attributes of the property }
  end;


  {----------------------------------------------------------------}
  { A schema definition describes all of the information found in  }
  { a schema file.  The only schema of interest is the one for the }
  { drawing currently being checked or compiled.                   }
  {                                                                }
  { The ID_DICTIONARY and STRING_DICTIONARY are updated dynamicly  }
  { as needed.  When a drawing is checked, the USED_GLOBAL_TMS are }
  { checked against current definitions.  If any have changed,     }
  { the pages that use them are marked dirty.  The USED_PROPERTIES }
  { are handled similarly (though some changes in attributes do    }
  { not cause recompilation.  See make.pas for the exact           }
  { implementation.  When a page is recompiled, any local text     }
  { macros it contains are compared with its old schema entry, and }
  { if any have been changed, then all pages using those that were }
  { changed are marked dirty_by_local_tms (and are recompiled      }
  { during a second pass through the pages).                       }
  { After this local text macro check, the paged_schema for the    }
  { page is updated.                                               }
  {                                                                }
  { USED_PROPERTIES and USED_GLOBAL_MACROS are updated when the    }
  { schema file is written.                                        }
  {----------------------------------------------------------------}

  schema_definition = record
    id_dictionary: numbered_dictionary;      { numbered identifiers }
    string_dictionary: numbered_dictionary;  { numbered strings }
    contexts: context_definition_ptr;        { contexts in which this drawing
					       has been used }
    highest_context_number: natural_number;  { highest number used for a 
                                               context number }
    paged_schemas: paged_schema_ptr;         { expandable ids and local }
					     { text macro defs          }
    used_global_TMs: text_macro_ptr;         { invoked global text macros }
    used_properties: property_attribute_ptr; { list of used properties and
                                               their last-defined attributes }
    file_name: xtring;                       { Name of file }
    directory: Xtring;                       { SCALD directory from which
                                               this was read }
    local_TMS: property_ptr;                 { All local text macro 
                                               definitions for the module
					       begin compiled }
    local_TMs_defined: boolean;              { TRUE if local_TMs field
                                               contains valid data }
    file_accessible: boolean;                { TRUE if able to access }
    changed: boolean;                        { TRUE if any page compiled }
    bubble_check: boolean;                   { Value of this directive when
                                               last compiled }
    enable_cardinal_tap: boolean;            { Value of this directive when
                                               last compiled }
  end;


  { -- signal types -- }
  

  {------------------------------------------------------------------}
  {  A SUBSCRIPT is used to represent a bit subscript for a signal.  }
  {  SUBSCRIPTS can be used in linked lists (threaded with the NEXT  }
  {  field) to represent bit lists.                                  }
  {------------------------------------------------------------------}

  subscript_ptr = ^subscript;
  subscript = record
                next: subscript_ptr;       { ^ next in list of bits }
                left_index,                { left most index value }
                right_index: bit_range;    { right most index value }
              end;

  {----------------------------------------------------------------------}
  {  A SUBSCRIPT_PROPERTY is a list of bit vectors.  They are threaded   }
  {  by the NEXT field.  The bit vector is defined by LEFT_INDEX and     }
  {  RIGHT_INDEX.  The property list for these bits is specified by      }
  {  PROPERTIES.  If the bits are -1, the properties apply to every bit. }
  {----------------------------------------------------------------------}

  subscript_property_ptr = ^subscript_property;
  subscript_property = record
                         next: subscript_property_ptr;
                         left_index,
                         right_index: bit_range;
                         properties: property_ptr;
                       end;

  {--------------------------------------------------------------------}
  {  A BIT_PROPERTY describes a property and the bits it applies to.   }
  {  A list of these properties is threaded by NEXT.  The bits are     }
  {  described by BIT_SUBSCRIPT.  The name of the property is          }
  {  PROPERTY_NAME and its value is PROPERTY_VALUE.                    }
  {  If the BIT_SUBSCRIPT is NIL, the property applies to every bit.   }
  {--------------------------------------------------------------------}

  signal_instance_ptr = ^signal_instance;

  bit_property_ptr = ^bit_property;
  bit_property = record
                   next: bit_property_ptr;
                   bit_subscript: subscript_ptr;
                   name: name_ptr;
                   text: xtring;
                 end;


  {------------------------------------------------------------------}
  {  Used to specify the type of signal.  SINGLE means scalar which  }
  {  has no bit subscript.  VECTOR means that the signal has a bit   }
  {  subscript which may represent one or more bits.  UNDEFINED is   }
  {  used to identify a signal whose width is unknown.               }
  {------------------------------------------------------------------}

  signal_kind = (SINGLE, VECTOR, UNDEFINED);          { type of signal }


  {------------------------------------------------------------------}
  { SCOPE is used to identify the scope for a signal.  A signal may  }
  { have only one scope within a particular scope (drawing).         }
  {------------------------------------------------------------------}

  scope_type = (FIRST_SCOPE,
                UNKNOWN_SCOPE,          { scope is unknown (local or global) }
                XINTERFACE,             { interface parameter of the macro }
                LOCAL,                  { strictly local to defining macro }
                GLOBAL,                 { global (to all scopes) }
                DECLARED,               { declared within current scope }
                SIG_CONST,              { a signal constant (set global) }
                LAST_SCOPE);

  scope_conversion_type = array [0..10] of scope_type;
      

  {----------------------------------------------------------------------}
  {  Range for the value for the REP property used to replicate a signal }
  {----------------------------------------------------------------------}

  replication_range = 0..MAXINT;                      { range for multiplier }
      

  {-------------------------------------------------------------------------}
  {  Used to specify the polarity of a signal.  A high-asserted signal has  }
  {  NORMAL polarity.  A low-asserted signal has COMPLEMENTED polarity. If  }
  {  the assertion is not yet known (as in the case of UNNAMED signals,     }
  {  the polarity is UNKNOWN_POLARITY.                                      }
  {-------------------------------------------------------------------------}

  signal_polarity = (NORMAL,               {  FOO  or  -FOO* }
                     COMPLEMENTED,         { -FOO  or   FOO* }
                     UNKNOWN_POLARITY,     { not known; will be inherited }
                     NO_POLARITY);         { there is no polarity }

  polarity_fix_specification = (FIX_NONE,
                                FIX_FORMAL,
                                FIX_ACTUAL);


  {--------------------------------------------------------------------------}
  { A SIGNAL_INSTANCE is used to represent a unique "instance" of a signal.  }
  { The NEXT field links together all the instances of the basic signal.     }
  { The basic signal is pointed to by the DEFINED_BY field.  If a REP        }
  { property appears, the REPLICATION_FACTOR field contains its value.  The  }
  { bit subscript for the instance is specified by BIT_SUBSCRIPT.            }
  { The LOW_ASSERTED bit was taken away from the SIGNAL_DEFINITION structure }
  { and put here.                                                            }
  {--------------------------------------------------------------------------}

  signal_definition_ptr = ^signal_definition;

  signal_instance = record
                      next: signal_instance_ptr;
                      defined_by: signal_definition_ptr;
                      replication_factor: replication_range;
                      bit_subscript: subscript_ptr;
                      low_asserted: boolean;
                    end;


  {----------------------------------------------------------------------}
  { The SIGNAL_ENTRY structure is used to hold signal names in the hash  }
  { table and to point to the top of the stack of signals with the same  }
  { name and assertion but nested scopes.  There are two stacks rooted   }
  { here: one for low asserted (LOW_ASSERTED) and one for high asserted  }
  { (HIGH_ASSERTED) signals of the same name (NAME).  The elements in    }
  { hash table are threaded by the NEXT field.                           }
  {----------------------------------------------------------------------}

  signal_entry_ptr = ^signal_entry;
  signal_entry = record
                   next: signal_entry_ptr;
                   name: xtring;
                   high_asserted: signal_definition_ptr;
                   low_asserted: signal_definition_ptr;
                 end;


  {------------------------------------------------------------------------}
  { The signal table is a hash table of all signals in the design.  Each   }
  { signal name has a stack of SIGNAL_DEFINITIONs associated with it that  }
  { represent the currently active scopes for that signal name.            }
  {------------------------------------------------------------------------}

  signal_table_range = 0..SIGNAL_TABLE_SIZE;

  table_of_signals = array [signal_table_range] of signal_entry_ptr;


  {-----------------------------------------------------------------------}
  {  A basescript is used to represent the "base" signals corresponding   }
  {  to each bit of the particular signal (see SIGNAL_DEFINITION.)  If a  }
  {  bit does not appear in the list of basescripts, it is base itself.   }
  {-----------------------------------------------------------------------}

  basescript_ptr = ^basescript;
  basescript = record
                  next: basescript_ptr;           { next in list of bits }
                  instance: signal_instance_ptr;  { base signal }
                  offset: bit_range;              { offset into instance }
                  left_index: bit_range;          { left subscript index }
                  right_index: bit_range;         { right subscript index }
                end;

  base_descriptor_ptr = ^base_descriptor;
  base_descriptor = record
                      next:  base_descriptor_ptr;
                      instance: signal_instance_ptr;
                      offset,
                      width: bit_range;
                    end;


  {--------------------------------------------------------------------------}
  { The SIGNAL_DEFINITION structure is used to describe a particular signal. }
  { It contains the information that is common to all instances of that      }
  { signal.  The NEXT field is used to link together all of the signals for  }
  { a node.  The STACK field is a link through all signals in the stack.     }
  { The SIGNAL points to the hash table entry.  A simple subrange union of   }
  { the bits referenced by all of the instances is given by LEFT_INDEX and   }
  { RIGHT_INDEX.  The properties of the signal are given by PROPERTIES.  The }
  { polarity of the signal is given by POLARITY.                             }
  { A list of the signal's instances is pointed                              }
  { to by INSTANCES.  The signals type is given by the KIND field.  A list   }
  { of the bits of the signal that are synonymed to more base signals is     }
  { given in SYNONYM_BITS.  IS_CONST is TRUE is the signal is a constant.    }
  { SCOPE gives the scope of the signal and NODE is the node in which the    }
  { signal is defined.  The NEXT_VIRTUAL_DEF field points to the next        }
  { signal def among several defs on different nets.  The NET_ID field is    }
  { used to separate defs with the same name but are different nets.         }
  {--------------------------------------------------------------------------}

  signal_definition = record
    next: signal_definition_ptr;
    stack: signal_definition_ptr;
    signal: signal_entry_ptr;
    is_virtual_base: boolean;
    next_virtual_def: signal_definition_ptr;
    net_id: xtring;
    left_index: bit_range;
    right_index: bit_range;
    properties: bit_property_ptr;
    polarity: signal_polarity;
    instances: signal_instance_ptr;
    kind: signal_kind;
    synonym_bits: basescript_ptr;
    is_const: boolean;
    scope: scope_type;
    node: mtree_node_ptr;
  end;

  signal_definition_list_ptr = ^signal_definition_list;
  signal_definition_list = record
                             next: signal_definition_list_ptr;
                             definition: signal_definition_ptr;
                           end;


  {--------------------------------------------------------------------------}
  {  Assertion control as follows:                                           }
  {      NORMAL_SIGNAL -> used to coerce assertions, used to determine       }
  {                       synonym's assertion, used for bubble checking      }
  {      IGNORE_ALL    -> not used for assertion processing anytime          }
  {      IGNORE_PIN    -> not used to coerce assertions,  used to determine  }
  {                       synonym's assertion, not used for bubble checking  }
  {--------------------------------------------------------------------------}

  control_type = (IGNORE_ALL, IGNORE_PIN, NORMAL_SIGNAL);


  {-----------------------------------------------------------------------}
  {  A PROPERTIED_CS structure is used to represent a signal that is      }
  {  composed of several signals appended into one.  Each of the signals  }
  {  is represented by a SIGNAL_INSTANCE.                                 }
  {-----------------------------------------------------------------------}

  propertied_CS_ptr = ^propertied_CS;
  propertied_CS = record
                    next: propertied_CS_ptr;
                    instance: signal_instance_ptr;
                    properties: property_ptr;
                    control: control_type;
                  end;

  PCS_pointer = record
                  PCS: propertied_CS_ptr;
                  replication_count: replication_range;
                end;


  {-----------------------------------------------------------------------}
  {  An ACTUAL_LIST is used to specify a parsed actual parameter.  It is  }
  {  connected to a formal parameter.  The NEXT field is used to link     }
  {  actuals that are synonymed together.  The SIGNAL field points to the }
  {  parsed actual signal.  The WIDTH_IS_UNKNOWN field is TRUE if the     }
  {  width of the actual signal is not known.  The ASSERTION_STATE field  }
  {  specifies the state of assertion checking for the actual signals.    }
  {-----------------------------------------------------------------------}

  assertion_known_type = (ASSERTION_KNOWN,       { assertion of all is known }
                          ASSERTION_UNKNOWN,     { assertion is not known }
                          ASSERTION_CHECKED);    { assertion was checked }

  actual_list_ptr = ^actual_list;
  actual_list = record
                  next: actual_list_ptr;
                  signal: propertied_CS_ptr;
                  width_is_unknown: boolean;
                  assertion_state: assertion_known_type;
                end;


  simple_signal_ptr = ^simple_signal;

  {----------------------------------------------------------------------}
  {  A FORMAL_ACTUAL structure is used to represent a pin name and the   }
  {  signal connected to it.  These are stored in a list rooted on an    }
  {  MTREE_NODE.  The NEXT field links all of the pins on a body.  The   }
  {  pin name is decribed by the FORMAL_PARAMETER field and a simplified }
  {  version of the name is specified by PIN_NAME (set after PASS 1).    }
  {  POLARITY describes the polarity of the pin as described by the      }
  {  NBC property (NO_POLARITY), the NAC property (UNKNOWN_POLARITY),    }
  {  the BUBBLED property (COMPLEMENTED), or none (NORMAL).  The signals }
  {  connected to the pin are specified by ACTUAL_PARAMETER.  The number }
  {  of bits of the pin is given by WIDTH.  The properties of the pin    }
  {  are listed in PROPERTIES.  USES_NAC is TRUE if the pin name has the }
  {  NAC property.  IS_NWC_PIN is TRUE if the pin name has the NWC prop. }
  {----------------------------------------------------------------------}

  formal_actual_ptr = ^formal_actual_list;
  formal_actual_list = record
                         next: formal_actual_ptr;
                         formal_parameter: signal_instance_ptr;
                         pin_name: simple_signal_ptr;
                         polarity: signal_polarity;
                         actual_parameter: actual_list_ptr;
                         width: bit_range;
                         properties: subscript_property_ptr;
                         uses_NAC: boolean;
			 is_NWC_pin: boolean;
                       end;


  {----------------------------------------------------------------------}
  {  A SIGNAL_DESCRIPTOR is used to represent all the information about  }
  {  a signal as parsed.  The NEXT field is used to link concatenated    }
  {  signals.  The name of the signal is given by SIGNAL_NAME.  The      }
  {  POLARITY and LOW_ASSERTED fields describe the signal's assertions.  }
  {  REPLICATION_FACTOR is the parsed value of the replication property  }
  {  (1 if no such property exists on the signal).  KIND describes the   }
  {  structure of the signal and BIT_SUBSCRIPT describes the bits of the }
  {  signal.  PROPERTIES is a list of the properties on the signal.  If  }
  {  the signal has the NN property (used to denote unique nets) its     }
  {  value is in NET_ID.  If the signal is a constant, the IS_CONST flag }
  {  is TRUE.                                                            }
  {----------------------------------------------------------------------}

  signal_descriptor_ptr = ^signal_descriptor;
  signal_descriptor = record
                        next: signal_descriptor_ptr;
                        signal_name: xtring;
                        polarity: signal_polarity;
                        low_asserted: boolean;
                        scope: scope_type;
                        replication_factor: natural_number;
                        kind: signal_kind;
                        bit_subscript: subscript_ptr;
                        properties: property_ptr;
                        net_id: xtring;
                        is_const: boolean;
                      end;


  {----------------------------------------------------------------------}
  {  A SIMPLE_SIGNAL is a descriptor for a "simple" signal.  It is used  }
  {  to describe a formal parameter after the need for the formal signal }
  {  definition is over.                                                 }
  {----------------------------------------------------------------------}

  simple_signal = record
                    next: simple_signal_ptr;       { next in a list }
                    polarity: signal_polarity;     { signal's polarity }
                    signal_name: xtring;           { name of the signal }
                    kind: signal_kind;             { kind of the signal }
                    bit_subscript: subscript_ptr;  { signal's bits }
                  end;


  {-------------------------------------------------------------------}
  {  A SYNONYM_SIGNAL is used to describe a signal in a hash table of }
  {  synonyms read from the on-the-fly synonyms file.  NEXT is the    }
  {  hash bucket thread.  SIGNAL_NAME is the signal's name.  POLARITY }
  {  is the signal's polarity.   All signals are actuals.             }
  {  DEF points to the signal's signal definition.                    }
  {  The bits that are used in this page are given by USED_BITS.      }
  {  Only bits that are used in a page are written to the synonyms    }
  {  section for that page.                                           }
  {  Lookups are keyed on (SIGNAL_NAME,POLARITY) and these fields     }
  {  appear here only to speed up dereferencing the key, as the same  }
  {  information can be obtained from def^.polarity and               }
  {  def^.signal^.name.                                               }
  {-------------------------------------------------------------------}

  synonym_signal_ptr = ^synonym_signal;
  synonym_signal = record
                     next: synonym_signal_ptr;
                     signal_name: xtring;
                     def: signal_definition_ptr;
                     used_bits: subscript_ptr;
                     polarity: signal_polarity;
                   end;

  synonym_signal_table_range = 0..SYNONYM_SIGNAL_TABLE_SIZE;
  synonym_table_type =
    array [synonym_signal_table_range] of synonym_signal_ptr;

  {-----------------------------------------------------------------------}
  {  The NET table is a table of enumerated nets.  Each net is given an   }
  {  identifying number and a corresponding name and list of properties.  }
  {-----------------------------------------------------------------------}

  net_number_range = 0..MAX_NET_NUMBER_VALUE;

  net_descriptor_ptr = ^net_descriptor;
  net_descriptor = record
                     next: net_descriptor_ptr;     { thread for free list }
                     net_name: xtring;
                     properties: property_ptr;
                     net_id: xtring;
                   end;

  net_group_range = 0..NET_GROUP_SIZE;

  net_group_table = array [net_group_range] of net_descriptor_ptr;

  net_table_ptr = ^net_table_type;
  net_table_type = record
                     next: net_table_ptr;             { next in the table }
                     group_number: net_number_range;  { start of group }
                     nets: net_group_table;           { nets in group }
                   end;


  {--------------------------------------------------------------------------}
  {  A CLEAR_TEXT_ACTUAL_LIST is used to list the clear text of the signals  }
  {  connected to a particular pin of some body.  See BINDINGS_LIST.  All    }
  {  actuals in the list will eventually be synonymed together.              }
  {--------------------------------------------------------------------------}

  clear_text_actual_list_ptr = ^clear_text_actual_list;
  clear_text_actual_list = record
                             next: clear_text_actual_list_ptr;
                             actual_parameter: xtring;
                             properties: property_ptr;
                             net_id: xtring;
                           end;


  {-----------------------------------------------------------------------}
  {  Linked list of the pin names for a body.  Each pin name occurs once  }
  {  in the list.  For each pin name there is a list of the actual        }
  {  parameter(s) connected to it and a list of its pin properties.       }
  {-----------------------------------------------------------------------}

  bindings_list_ptr = ^bindings_list;
  bindings_list = record
                    next: bindings_list_ptr;      { next in list of pinnames }
                    formal_parameter: xtring;     { the formal pin name }
                    pin_properties: property_ptr; { pin property list }
                    actual_parameter: clear_text_actual_list_ptr;
                  end;


  {-------------------------------------------------}
  {  Linked list of clear text signals attached to  }
  {  DECLARE or PIN_NAME bodies.                    }
  {-------------------------------------------------}

  signal_list_ptr = ^signal_list;
  signal_list = record
                  next: signal_list_ptr;         { next in the list }
                  signal_name: xtring;           { the signal }
                end;


  { list of signal instances to take the place of the cmptmp file -- this
    is a serious hack and must be cleaned up or else !!! }

  signal_instance_list_ptr = ^signal_instance_list;
  signal_instance_list = record
    next: signal_instance_list_ptr;
    instance: signal_instance_ptr;
  end;


  body_type = (FIRST_BODY,
               MENU_BODY,
               DEFINE_BODY,
               DRAWING_BODY,
               PIN_NAMES_BODY,
               USER_BODY,
               DECLARE_BODY,
               LAST_BODY);

  body_type_set = set of body_type;
  body_list = array [body_type] of xtring;


  {-------------------------------------------------------------------}
  { Linked list of invoked bodies within a macro; one entry per body. }
  {-------------------------------------------------------------------}

  invoke_list_ptr = ^invoke_list;
  invoke_list = record
    next: invoke_list_ptr;       { next in list of invoked macros }
    macro_name: xtring;          { name of invoked macro }
    parameters,                  { macro parameters }
    properties: property_ptr;    { list of body properties }
    path: xtring;                { path property }
    bindings: bindings_list_ptr; { list of formal/actuals }
    page_number: page_range;     { page in which invoke appears }
  end;


  {------------------------------------------------------------------}
  {  The MTREE_NODE structure is used to represent an instance of a  }
  {  particular drawing.  It contains all the information specific   }
  {  to the instance as well as links to the drawing in which it is  }
  {  used and the drawings which it uses.  The MTREE_NODEs are used  }
  {  to form the "expansion tree".  MACRO points to the description  }
  {  of the macro.  CALLED_BY points to the invoking instance.       }
  {  NEXT_NODE_WITH_SAME_MDEF is a thread of all the nodes that are  }
  {  instances of the same macro (rooted in a macro def).            }
  {  FATHER_NODE points to the node's father.  NEXT links sibling    }
  {  nodes.  LEVEL is the node's tree level (top=1).  PATH_ELEMENT   }
  {  is this node's incremental path name.  PARAMS is the formal     }
  {  actual list for this instance.  SIGNALS is a list of the        }
  {  signals at this node.  SYMBOL_TABLE contains the symbols for    }
  {  this node.  IS_LEAF_NODE is TRUE if this is a leaf node.  SON   }
  {  points to the head of a list of nodes (threaded with NEXT) that }
  {  are the sons of this node.                                      }
  {  MODULE_NUMBER numbers unique modules (a context of a drawing).  }
  {  X_VALUE is the value of X for the node.                         }
  {------------------------------------------------------------------}

  level_range = 0..MAX_TREE_DEPTH;

  mtree_node = record
                 macro: macro_def_ptr;
                 macro_name: xtring;
                 called_by: invoke_list_ptr;
                 next_node_with_same_mdef,
                 father_node,
                 next: mtree_node_ptr;
                 level: level_range;
                 params: formal_actual_ptr;
                 signals: signal_definition_ptr;
                 symbol_table: identifier_ptr;
                 is_leaf_node: boolean;
                 is_plumbing_node: boolean;
                 is_cardinal_tap: boolean;
                 uses_SIZE_property: boolean;
                 son: mtree_node_ptr;
		 module_number: natural_number;
                 x_value: integer;
               end;

  {-------------------------------------------------------------------------}
  {  The MACRO_DEF structure is used to represent a drawing.  The drawing   }
  {  is "generic";  that is, is does NOT represent a specific instance.     }
  {  This structure is created from information read from the connectivity  }
  {  file.  It refers to all the instances of that drawing in the tree.     }
  {                                                                         }
  {  Those fields marked with an * are not used during separate compilation }
  {  (except for the root node and plumbing nodes).                         }
  {-------------------------------------------------------------------------}

  macro_module = dummy_expansion_control_type;
  macro_module_ptr = ^macro_module;

  macro_def = record
    next: macro_def_ptr;         { invoke order list of macros }
    macro_name: xtring;          { the name of this macro }
    version: macro_module_ptr;   { pointer to directory entry }{*}
    occurances: mtree_node_ptr;  { list all nodes of this macro }
    params: signal_list_ptr;     { list macro parameters }
    properties: property_ptr;    { list of macro properties }{*}
    text_macros: property_ptr;   { list of text macros }{*}
    is_plumbing: boolean;        { TRUE if this is plumbing }
    written_with_GED: boolean;   { TRUE if written w/ 5.5 GED }{*}
    is_leaf_macro: boolean;      { TRUE if macro = PRIM or PART }{*}
    invokes: invoke_list_ptr;    { list of invoked macs }{*}
  end;


  { -- configure types -- }

  configure_types = (FIRST_CONFIGURE_SPECIFIER,
                     CONFIGURE_SUBRANGE,
                     CONFIGURE_BIT_ORDERING,
                     CONFIGURE_LOW_ASSERTED,
                     CONFIGURE_HIGH_ASSERTED,
                     CONFIGURE_NEGATION,
                     CONFIGURE_NAME_PREFIX,       { not configurable }
                     CONFIGURE_GENERAL_PREFIX,
                     CONFIGURE_CONCATENATION,     { not configurable }
                     LAST_CONFIGURE_SPECIFIER);

  configure_specifier_type = array [configure_types] of name_ptr;

  { -- directive types:  these are declared in alphabetical order so
                         that output can be done alphabetically  -- }

  directive_type = (FIRST_DIRECTIVE,
                    ALLOW_PART_NAME_DIRECTIVE,
                    AMUSING_MESSAGES_DIRECTIVE,
                    BUBBLECHECK_DIRECTIVE,
                    CLASSGEN_DIRECTIVE,
                    COMMAND_DIRECTIVE,
                    COMPILE_DIRECTIVE,
                    CONFIG_FILE_DIRECTIVE,
                    CONST_BUBBLE_CHK_DIRECTIVE,
                    CONTEXT_DIRECTIVE,
                    DEBUG_DIRECTIVE,
                    DEBUG_AT_PATH_DIRECTIVE,
                    DEBUG_CONTROL_DIRECTIVE,
                    DECLARE_BODIES_DIRECTIVE,
		    DEFAULT_FILTER_DIRECTIVE,
                    DEFAULT_L_OR_G_DIRECTIVE,
                    DIRECTORY_DIRECTIVE,
                    ENABLE_CARDINAL_TAP_DIRECTIVE,
                    ERROR_HELP_DIRECTIVE,
                    EVACUATE_DIRECTIVE,
		    EXPANSION_RULES_DIRECTIVE,
                    FILTER_PROPERTY_DIRECTIVE,
                    HIERARCHICAL_NWC_DIRECTIVE,
                    LIBRARY_DIRECTIVE,
		    LOCALLY_GLOBAL_DIRECTIVE,
                    MASTER_LIBRARY_DIRECTIVE,
                    MAX_ERROR_DIRECTIVE,
                    NET_PROCESSING_DIRECTIVE,
                    OUTPUT_DIRECTIVE,
                    OVERSIGHT_DIRECTIVE,
                    PAGE_SYNONYM_DIRECTIVE,
                    PASS_PROPERTY_DIRECTIVE,
                    PASSWORD_DIRECTIVE,
                    PERMIT_NO_ASSERTION_DIRECTIVE,
		    PICK_DIRECTIVE,
                    PRIMITIVE_DIRECTIVE,
                    PROPERTY_DIRECTIVE,
                    PRINT_WIDTH_DIRECTIVE,
                    READ_ALL_UDIRS_DIRECTIVE,
                    REPORT_DIRECTIVE,
		    REPORT_UNKASSERT_DIRECTIVE,
                    ROOT_DIRECTIVE,
                    SEPARATE_COMPILE_DIRECTIVE,
		    SHADOW_ROOT_DIRECTIVE,
		    SHAREABLE_DIRECTIVE,
                    SINGLE_LEVEL_DIRECTIVE,
                    SUPPRESS_DIRECTIVE,
                    TEXT_MACRO_DIRECTIVE,
                    TOKENIZE_PARAMS_DIRECTIVE,
                    WARN_DIRECTIVE,
                    LAST_DIRECTIVE);

  directive_list = array [directive_type] of name_ptr;
  directive_set = set of directive_type;

  shareable_value = (FIRST_SHAREABLE_VALUE,
                     DEFAULT_SHARING, { umask uninfluenced by compiler }
		     GROUP_SHARING,   { this is the actual "default" value of
		                        the directive }
		     GLOBAL_SHARING,
		     LAST_SHAREABLE_VALUE);

  shareable_directive_options = record
    values: array[shareable_value] of name_ptr;
    umasks: array[shareable_value] of integer;
  end;

  command_type = (FIRST_COMMAND,
		  SEPCOMP_COMMAND,
		  SEPLINK_COMMAND,
		  COMPERR_COMMAND,
		  LAST_COMMAND);
  output_file_names = (FIRST_FILE_NAME,
                       CMPLST_FILE,
                       CMPEXP_FILE,
                       CMPERR_FILE,
                       CMPSYN_FILE,
                       CHIPS_FILE,
                       CMPHIER_FILE,
                       LAST_FILE_NAME);

  output_file_list = array [output_file_names] of name_ptr;
  output_file_set = set of output_file_names;

  report_types = (FIRST_REPORT_TYPE,
                  PATH_NAMES,
                  HIERARCHY,
                  SUMMARY,
                  LAST_REPORT_TYPE);

  report_set = set of report_types;

  report_table_type = array [report_types] of name_ptr;
  drawing_list_ptr = ^drawing_list;
  drawing_list = record
    next: drawing_list_ptr;
    drawing, context: xtring;
  end;

  selection_exception_ptr = ^selection_exception;
  selection_exception = record
    next: selection_exception_ptr;
    compile_type: name_ptr;
    extension: name_ptr;
    attribute: name_ptr;
    drawings: drawing_list_ptr;
  end;

  {-----------------------------------------------------------------------}
  {  The HEAP_STRUCTURES type is used to refer to each of the structures  }
  {  that is created on the heap.  The Compiler keeps an estimate of the  }
  {  space it uses on the heap indexed by the elements of this type.      }
  {-----------------------------------------------------------------------}

  heap_structures = (FIRST_HEAP_STRUCTURE,
                     HEAP_BINDINGSLIST,
                     HEAP_INVOKELIST,
                     HEAP_SIGNALLIST,
                     HEAP_MACRODEF,
                     HEAP_MTREENODE,
                     HEAP_IDENTIFIER,
                     HEAP_FREEELEMENT,
                     HEAP_STRING,
                     HEAP_PROPERTY,
                     HEAP_DIRECTORY,
                     HEAP_MACROENTRY,
                     HEAP_FILELIST,
                     HEAP_MACROVERSION,
                     HEAP_SIGNALDESCR,
                     HEAP_SUBSCRIPT,
                     HEAP_BASESCRIPT,
                     HEAP_BASE_DESCRIPTOR,
                     HEAP_SIMPLE_SIGNAL,
                     HEAP_SIGNAL_DEFINITION_LIST,
                     HEAP_SIGNALENTRY,
                     HEAP_SIGNAL_DEFINITION,
                     HEAP_SIGNAL_INSTANCE,
                     HEAP_FORMAL_ACTUAL_LIST,
                     HEAP_CLEAR_TEXT_ACTUAL_LIST,
                     HEAP_NAME_ENTRY,
                     HEAP_ENVIRONMENT_ENTRY,
                     HEAP_HASH_STRINGS,
                     HEAP_ACTUAL_LIST,
                     HEAP_SYNONYM_SIGNAL,
                     HEAP_SUBSCRIPT_PROPERTY,
                     HEAP_BIT_PROPERTY,
                     HEAP_PROPERTIED_CONCATSIG,
                     HEAP_FILE_LIST,
                     HEAP_NET_DESCRIPTOR,
                     HEAP_NET_TABLE,
                     HEAP_NAME_LIST,
                     HEAP_BIG_DATA,
                     HEAP_NUMBERED_TOKEN,
                     HEAP_NUMBERED_TOKEN_LIST,
                     HEAP_TEXT_MACRO,
                     HEAP_EXPANDABLE_ID,
                     HEAP_PAGED_SCHEMA,
                     HEAP_PARAMETER,
                     HEAP_CONTEXT_DEFINITION,
                     HEAP_MACRO_CHOICE,
                     HEAP_MODULE_LIST,
                     HEAP_DEPENDENCY_LIST,
                     HEAP_SEPCOMP_LIST,
		     HEAP_AVL,
		     HEAP_COMPILED_CONTEXT_LIST,
		     HEAP_PROPERTY_ATTRIBUTE,
		     HEAP_PLUMBING_MODULE,
		     HEAP_PLUMBING_PAGE,
                     LAST_HEAP_STRUCTURE);
  
  structure_array = array [heap_structures] of record
                                                 number,
                                                 size: natural_number;
                                               end;

(**){--------- MODULES LIST STRUCTURES -----------------------}

  {----------------------------------------------------------------}
  { The modules list contains the list of modules encountered in   }
  { the page.  Its strings and identifiers are entered in the      }
  { expansion file dictionaries for output to the expansion file.  }
  { The modules are numbered from 1 to n and invocations of them   }
  { later in the expansion file are by number.                     }
  {----------------------------------------------------------------}

  module_list_ptr = ^module_list;
  module_list = record
    next: module_list_ptr;        { next in the list }
    drawing: numbered_token_ptr;  { drawing name }
    context: parameter_ptr;       { context of the invoke }
    number: natural_number;       { module number }
  end;


  module_table_range = 0..LAST_MODULE_TABLE_ENTRY;
  module_table = record
    highest: natural_number;              { highest number entered }
    table: array[module_table_range] of 
           module_list_ptr;               { buckets }
  end;


(**){--------- LINKER COMMUNICATION STRUCTURES -----------------------}


  {------------------------------------------------------------------}
  { This structure holds information obtained from the CMPDRAW       }
  { file.  This                                                      }
  { is the file generated by the linker to tell the compiler what    }
  { drawings are to be compiled.                                     }
  {                                                                  }
  { COMMAND specifies what to do with the drawing (described below). }
  { DRAWING uniquely specifies the drawing.                          }
  { COMPILE_TYPE specifies the type to be compiled.                  }
  { CONTEXT specifies the context to be compiled.                    }
  { FORCECOMPILE = TRUE says just compile it - don't check to see    }
  { if it is necessary.                                              }
  {                                                                  }
  { Wildcards are to be implemented but are not as yet.              }
  {------------------------------------------------------------------}

  compile_command = (
    FIRST_COMPILE_COMMAND,
    COMPILE_ROOT,   { Update all pages and emit linker directives to open
                      the appropriate linker list file for this drawing }
    COMPILE_SUB,    { Update all pages }
    CHECK_FOR_PRIM, { If drawing is a primitive, update it; otherwise just
                      informe the linker it is not a primitive.  Used for
		      leaf drawings of SINGLE_DRAWING ON compilations }
    STOP_AT_SUBCKT, { Turn on special analog designer compilation }
    LAST_COMPILE_COMMAND);
    
  sepcomp_list_ptr = ^sepcomp_list;
  sepcomp_list = record
    next: sepcomp_list_ptr;   { next in the list }
    drawing: xtring;          { drawing name }
    compile_type: name_ptr;   { compile type }
    context: property_ptr;    { context }
    forcecompile: boolean;    { TRUE if context is to be compiled 
				regardless of "make" }
    command: compile_command; { what to do with the drawing }
  end;

{------------- Records needed by the COMPERR command -------------}

    comperr_drawing_ptr = ^comperr_drawing;
    comperr_module_ptr = ^comperr_module;

    comperr_module = record
      queue_next: comperr_module_ptr;   { threads the stack }
      queue_back: comperr_module_ptr;   { reverse stack thread }
      drawing: comperr_drawing_ptr;     { drawing represented }
      context: property_ptr;            { context of drawing }
      context_str: xtring;		{ context represented as a string }
    end;

    comperr_drawing = record
      queue_entry: comperr_module_ptr;  { last entry of this drawing
                                          in queue }
      macro_name: xtring;               { name of the drawing }
      modules: avl_ptr;                 { table of modules (by context) }
    end;


    { The following severity levels determine what severity of error is
      necessary in a page for its listing to be included in CMPLST by
      COMPERR.  They are ordered from least severe to most severe.  This
      allows the use expressions of the form 
      ord(specified_severity) <= ord(OVERSIGHT_SEVERITY). }
      
      
    comperr_severity_level = (FIRST_SEVERITY,
                              NO_SEVERITY { print all pages } ,
                              WARNING_SEVERITY,
			      OVERSIGHT_SEVERITY,
			      ERROR_SEVERITY,
			      LAST_SEVERITY);
			     

{----------------------------------------------------------------------}
{ The following types are used to construct AVL (height-balanced       }
{ binary) trees.  An AVL record contains all of the tree maintenance   }
{ fields and an field which points to the object entered in the tree.  }
{ The AVL_OBJECT_PTR can point to any 1 of a list of objects.  It      }
{ also can (using conditional complilation mechanism) contain a TAG    }
{ field which can remember what kind of object is presumed to be       }
{ represented.  This allows a run-time type checking to be performed   }
{ within the avl_compare function.   The BALANCE_FACTOR field of an    }
{ AVL keeps track of the difference between the left subtree of the    }
{ node and the right subtree of the node.  As long as the tree is      }
{ balanced, these heights can never differ by more than 1, so an       }
{ enumerated type is used.                                             }
{----------------------------------------------------------------------}
  balance_factor_type = (LEFT_HEAVY_BF, EVEN_BF, RIGHT_HEAVY_BF);
  avl_type = (AVL_FIRST,
              AVL_COMPLEMENTED_ACTUAL, 
	      AVL_INVOKE, 
	      AVL_CONTEXT,
	      AVL_CONTEXT_NUMBER,
	      AVL_STRING,
	      AVL_NUMBSTRING_BY_LENGTH,
	      AVL_COMPERR_DRAWING,
	      AVL_COMPERR_MODULE,
	      AVL_LAST);

  avl_object_ptr = record
    case


              avl_type of
      AVL_FIRST:
        (dummy_first: integer);                     { never used }
      AVL_COMPLEMENTED_ACTUAL: 
        (complemented_actual: signal_definition_ptr);
      AVL_INVOKE:
        (invoke: invoke_list_ptr);
      AVL_CONTEXT:
        (context: context_definition_ptr);          { sort by parameters }
      AVL_CONTEXT_NUMBER:
        (context_number: context_definition_ptr);   { sort by number }
      AVL_STRING:
        (str: xtring);                              { sort by ord of pointer }
      AVL_COMPERR_DRAWING:
        (cerr_drawing: comperr_drawing_ptr);        { sort by macro name (not
	                                              necessarily 
						      lexicographically) }
      AVL_COMPERR_MODULE:
        (cerr_module: comperr_module_ptr);          { sort by context }
      AVL_LAST:
        (dummy_last: integer);                      { never used }
  end;

{ avl_ptr = ^avl; } { given a forward reference earlier }
  avl = record
    left_child: avl_ptr;
    right_child: avl_ptr;
    balance_factor: balance_factor_type;
    object: avl_object_ptr;
  end;


var


  {-----------------------------  VARS  --------------------------------}


  { -- SCALD vars -- }

  { NOTE: for separate compilation, the macro def list has been split, 
    keeping the root macro def separate from the 
    This facilitates between page cleanup in separate compilation as
    only the root macro is released, leaving all of the plumbing
    drawings in memory so that they are only read once. 
    For full compilation, all defs are still headed by macro_def_list_root. }

  macro_def_list_root: macro_def_ptr;   { Full compilation list of macros/
                                          Separate compilation list of
					  plumbing macros. }
  root_macro_def: macro_def_ptr;        { separate comp root macro def(s) }
  mtree_root: mtree_node_ptr;           { root of mtree and of sorted mtree }


  { -- separate comp string constants -- }

  default_CONTEXT_name: xtring;       { name of context having no parms }

  { -- global info -- }

  default_master_library: xtring;     { default library used by add package }

  unique_PATH_number,                 { unique number to force unique PATHs }
  unique_NET_ID_number,               { unique # for creating net ids }
  unique_NC_number: unique_number;    { counter for generating unique names }
  uses_SIZE_parameter: boolean;       { TRUE if SIZE parameter used }

  global_found_def_in_enter_signal:
                             boolean; { See enter_signal_instance }

  TM_expansion_buffer: xtring;        { temp used for TM expansion }
  text_macro_recursion: boolean;      { TRUE if text macro recursion occurs }


  { -- output state variables -- }

  column: output_line_range;          { current output file column }


  { -- VAX dependent run time calculations -- }

  compile_date: time_string;          { current date }
  start_elapsed_time,                 { entire run start elapsed time }
  page_elapsed_time,                  { page compilation start elapsed time }
  last_elapsed_time,                  { previous elpased time value }
  start_CPU_time,                     { entire run start CPU time }
  page_CPU_time,                      { page compilation CPU time }
  last_CPU_time: integer;             { previous CPU time value }

 
  make_pass: make_pass_type;   { for pass 1, do the normal make.  
                                 for pass 2, make pages that are
				 dirty_by_local_TMs only }
  {------- string variables and string table ---------------}

  free_strings: array [1..33] of freeptr;  { list of free strings (by size) }
  s_length: array [1..33] of 0..256;       { list of possible string lengths }
  free_pointers: freeptr;                  { list of free "freeptr"s }
  nullstring: xtring;                      { a null string constant }

  string_table: hash_string_table_type;    { table of all strings }


  { scratch structures for sargv and sargc }
  cli_arg_last : cli_arg_index;        { last defined argument number }
  cli_arg_array: cli_arg_array_type;   { array of arguments }

  { flag for compiler command line arguments from CMPTMP kludge }
  use_CMPTMP_args: boolean;            { TRUE iff args from CMPTMP file
					 instead of command line }


  { -- error routine constants -- }

  suppress_errors: error_set;         { error messages to suppress }
  scan_past_errors: error_set;        { error really in last symbol }
  warning_errors: error_set;          { warning error numbers }
  oversight_errors: error_set;        { oversight error numbers }
  fatal_errors: error_set;            { all fatal errors }
  echo_to_monitor_errors: error_set;  { errors to be echoed to monitor }
  parse_errors: error_set;            { errors during parsing }
  scope_conflict_errors: error_set;   { just that }
  keep_the_page_dirty_errors:
                          error_set;  { errors whose fix cannot be detected
			                my the normal "make", so page must
					remain marked "dirty" }
  assert_strings: assert_type;        { table of assertion error messages }
  error_strings: error_type;          { table of error messages }
  parse_asserts: assert_set;          { set of assertion failures in parsing }


  { -- error display -- }

  environment_stack: environment_ptr; { stack of parse environments }
  current_mtree_node: mtree_node_ptr; { current mtree_node during PASS1, 2 }
  current_macro_def: macro_def_ptr;   { current macro being processed }
  current_page: 0..MAX_PAGE_NUMBER;   { current page number }
  current_body_node: mtree_node_ptr;  { current body mtree node }
  current_body_name: xtring;          { current body being processed }
  current_path_prop: xtring;          { PATH property of current body }
  current_file_name: xtring;          { current file being read }
  current_property_name: name_ptr;    { current property being parsed }
  current_property_value: xtring;     { current property value being parsed }

  num_oversights,                     { number of oversights encountered }
  num_warnings,                       { number of warnings encountered }
  num_errors: 0..MAXINT;              { number of errors encountered }
  last_error: error_range;            { last error encountered }
  ok_to_print_error: boolean;         { TRUE if last error was printed }
  ignore_parse_errors: boolean;       { TRUE if input line NOT to be printed
                                        for parse_errors }
  errors_encountered: error_set;      { all errors encountered }
  
  indent: natural_number;             { number of spaces to indent error
                                        message lines for the current error }

  { -- debugging vars -- }

  outfile: textfile;      { output file for debug information }
  debug_at_path,          { TRUE if path match debug enabled }
  undebug_at_path,        { TRUE if path match undebug enabled }
  debug_1,                { width resolving }
  debug_2,                { find_base_of_signal }
  debug_3,                { evaluate_binding }
  debug_4,                { sig }
  debug_5,                { NC remove }
  debug_6,                { synonym processing (in depth) }
  debug_7,                { property processing }
  debug_8,                { macro and directory tables }
  debug_9,                { synonym file }
  debug_10,               { 1 file I/O }
  debug_11,               { signal assertion checking }
  debug_12,               { enter_sig + found_sig }
  debug_13,               { PASS1 }
  debug_14,               { INHERIT_PIN properties }
  debug_15,               { virtual signals }
  debug_16,               { basescript processing }
  debug_17,               { expansion file }
  debug_18,               { %text macro processing }
  debug_19,               { nth_bit_subscript + base_bit }
  debug_20,               { global procedure entry/exit trace }
  debug_21,               { command line arguments debug }
  debug_22,               { file open/close }
  debug_23,               { "make" }
  debug_24,               { schema updating }
  debug_25,               { parse stack }
  debug_26,               { communication with et (linker) }
  debug_27,               { basescript fixing and synonym check }
  debug_28,               { AVL maintenance }
  debug_29,               { TEMPORARY -- slave flag for debug_30 }
  debug_30,               { TEMPORARY -- clear_text_actual property disposal }
  debug_31,               { Test signal catching by triggering suicide }
  debug_32,               { ADD package interface }
  debug_33,               { parameter value TM expansion }
  debug_34,               { synonym processing -- overview }
  debug_35,               { evaluate_bindings -- brief }
  debug_36,               { bit sets }
  debug_37,
  debug_38,
  debug_39,
  debug_40,
  debug,                              { parse debugging control }
  debugging: boolean;                 { TRUE if any debug flag is on }
  debug_control_specifier:
                 debug_control_list;  { table of debug control directives }
  path_for_debug: xtring;             { path name to watch for }
  path_for_undebug: xtring;           { path name to watch for }
  debug_flags: debug_flag_set;        { set of flags to set on path match }
  undebug_flags: debug_flag_set;      { set of flags to clear on path match }
  dumpsigdeflist_ok,                  { controls execution of dumpsigdeflist }
  dumptree_ok,                        { controls execution of dumptree }
  dumpsignals_ok,                     { controls execution of dumpsignals }
  dump_all_names_ok,                  { controls execution of dump_all_names }
  trace_erule_xface,                  { trace execution of expansion rules module }
  printmacros_ok,                     { controls execution of printmacros }
  printdirectory_ok: boolean;         { controls execution of printdirectory }
  histograms: histogram_set;          { set of histograms to print }
  histogram_specifiers:
                     histogram_table; { table of histograms to display }


  { -- "constant" symbol tables -- }

  name_table: name_table_type;             { table of identifier names }
  special_body_list: body_list;            { special body names }
  MEMORY_prim_name: xtring;                { Too anomalous even for the 
                                             special body list }
  scope_table:
            array [scope_type] of xtring;  { names corresponding to scopes }
  scope_values: scope_conversion_type;     { conversion table }
  syntax_specifier_names:
              syntax_specifier_name_type;  { names for syntax specification }
  signal_syntax_table:
                signal_syntax_table_type;  { signal syntax specification }


  { -- static information for INSYMBOL -- }

  line_pos: string_range;             { char pos of last char read }
  last_char: char;                    { last char read (for look ahead) }
  last_sym_pos: string_range;         { end of last symbol }
  last_string,                        { last input buffer }
  instring: xtring;                   { text line being parsed from }
  stack: parse_stack;                 { stack of saved parse information }
  how_to_parse: parse_type;           { how to parse the current string }
  read_state: parse_state;            { controls lookahead & initialization }
  valid_chars: radix_characters;      { sets of valid chars by radix }
  current_file: parse_file_type;      { what is current input file }
  radix_width: digit_width_list;      { width (bits) of digit by radix }
  copy_error,                         { TRUE if error occurred in copying }
  copy_input: boolean;                { TRUE if input to be copied }
  current_pos,                        { start of index into copy_buffer }
  copy_pos: string_range;             { index into copy_buffer for copy }
  copy_buffer: char_array;            { buffer used to expand TMs in string }
  parse_SCALDconstants: boolean;      { TRUE indicates look for Radix specs,
                                        etc. FALSE indicates parse decimal
					numbers in vanilla fashion. }


  stack_top: stack_index_range;           { index to top element of stack }
  parse_stack_pointer: stack_index_range; { stack element being parsed OR
                                            (stack_top + 1) indicates parsing
                                            a string not yet on stack }

  { NOTE on use of stack_top and parse_stack_ptr -- stack_top points to the
    top-most element in the stack.  Parse_stack_pointer indicates the
    string currently being parsed, which may not yet be on the stack itself.
    In fact, parse_stack_pointer <= stack_top only when parsing text macro 
    definitions found by insymbol.  A text macro definition string is
    left on the stack until all of its nested macros have been completely
    resolved.  This prevents right-side text macro infinite recursion. 
    See virtual_pop_string, parse_string, and fix_parse_stack for how
    this is done.  virtual_pop_string and fix_parse_stack are used only
    by insymbol. }


  { -- lexical analyzer -- }

  sy: symbols;                        { symbol that was parsed }
  id: identifier;                     { if sy=ident then identifier descrip }
  const_val: integer;                 { if sy=constant then constant value }
  const_width: integer;               { width of the last parsed constant }
  lex_string: xtring;                 { if sy=strings then string value }
  upper_case_strings: boolean;        { upper case all strings }
  input_buffer: xtring;               { string read from the input }
  allowed_key_words: setofsymbols;    { current valid key words }
  allow_TM_expansion: boolean;        { whether to expand text macros or not }
  TM_depth: 1..MAX_TM_RECURSION;      { current depth of TM recursion }
  subrangesy,                         { symbol for subrange }
  fieldsy: symbols;                   { symbol for field }


  { -- symbol constants -- }

  forbidden_symbols,                  { reserved symbols }
  expression_symbols,                 { symbols used in expressions }
  mulops,                             { multiplying operators }
  addops,                             { adding operators }
  relops,                             { relational operators }
  schema_keysys,                      { key symbols valid in schema file }
  expansion_keysys,                   { key symbols valid in expansion file }
  directives_keysys,                  { key symbols valid in directives file }
  directory_keysys,                   { key symbols valid in directories }
  macrodef_keysys,                    { key symbols valid in macro defs }
  signal_keysys,                      { key symbols valid in signals }
  config_keysys,                      { those special user-configured sys }
  bitsubendsys,                       { symbols that start bit subscripts }
  signal_name_end_sys,                { end of the signal name }
  propbeginsys: setofsymbols;         { symbols that start property defn }
  

  { -- special name constants -- }

  SEPARATE_COMPILE_place_holder,      { '*' for path name abbrev placeholder }
  FLAG_BODY_string,                   { "FLAG_BODY"  for BODY_TYPE property }
  PLUMBING_string,                    { "PLUMBING" for BODY_TYPE property }
  COMMENT_string,                     { "COMMENT" string for BODY_TYPE }
  TRUE_string,                        { "TRUE" constant string }
  FALSE_string,                       { "FALSE" constant string }
  DEFAULT_string,                     { "DEFAULT" constant string }
  PASS_string,                        { "PASS" constant string }
  FILTER_string,                      { "FILTER" constant string }
  default_SIZE_string,                { default value for SIZE }
  default_X_FIRST_string,             { default value for X_FIRST }
  default_X_STEP_string,              { default value for X_STEP }
  default_X_STEP_for_leaf_string,     { default value for X_STEP for a leaf }
  default_X_string,                   { default value for X }
  special_pin_name_prefix,            { prefix class for pin names }
  DEFINE_string,                      { a string = 'DEFINE' }
  CLOSED_string,                      { a string = 'CLOSED' }
  TIMES_string,                       { a string = 'TIMES' }
  SIZE_string,                        { a string = 'SIZE' }
  X_FIRST_string,                     { a string = 'X_FIRST' }
  X_STEP_string,                      { a string = 'X_STEP' }
  X_string: xtring;                   { a string = 'X' }


  { -- other constants -- }

  default_attributes: name_type_set;  { default property attributes }
  inheritance_attributes:
                      name_type_set;  { all inheritance attributes }
  signal_inheritance_attributes:
                      name_type_set;  { inheritance attributes for signals }
  permission_attributes:
                      name_type_set;  { all permission attributes }
  parameter_attributes:
                      name_type_set;  { id types that are parameters }
  bodies_with_bindings: 
                      body_type_set;  { bodies with bindings sections }


  { -- identifier name constants -- }

  UNDEFINED_identifier,     ALL_identifier,
  X_FIRST_identifier,       X_STEP_identifier,      X_identifier,

  LOCAL_specifier,          GLOBAL_specifier,       ON_specifier,
  OFF_specifier,            L_to_R_specifier,       R_to_L_specifier,

  PRIMITIVE_specifier,      SPECIAL_specifier,

  LOGIC_compile_type,       PRIM_extension_name,    PART_extension_name,
  LOGIC_connectivity,       PRIM_connectivity,      PART_connectivity,
  TIME_connectivity,        SIM_connectivity,       SIM_compile_type,

  ABBREV_prop_name,         PATH_prop_name,         SIZE_prop_name,
  EXPR_prop_name,           VERSION_prop_name,      TIMES_prop_name,
  SIG_NAME_prop_name,       SCOPE_prop_name,        NO_WIDTH_prop_name,
  NO_BUBBLE_prop_name,      BUBBLED_prop_name,      NO_ASSERT_prop_name,
  CARDINAL_TAP_prop_name,
  REPLICATION_prop_name,    TERMINAL_prop_name,     TITLE_prop_name,
  SIGNAL_prop_name,         PIN_prop_name,          AUTO_GEN_prop_name,
  BODY_prop_name,           OUTPUT_TYPE_prop_name,  XY_prop_name,
  NEEDS_NO_SIZE_prop_name,  COMMENT_BODY_prop_name, PART_NAME_prop_name,
  HAS_FIXED_SIZE_prop_name, BODY_TYPE_prop_name,    NET_ID_prop_name,
  DIRECTORY_prop_name,      ROTATION_prop_name,     VER_prop_name,
  CONTEXT_prop_name,        WARNING_prop_name,      OVERSIGHT_prop_name,
  ERROR_prop_name,          DRAWING_prop_name,      PAGE_prop_name,
  TYPE_prop_name,           PATH_NAME_prop_name,    BODY_NAME_prop_name,
  TIME_prop_name,           SUBCKT_prop_name,
  PRIM_TYPE_prop_name,      PRIM_FILE_prop_name,

  I_identifier,             SS_identifier,           D_identifier,
  R_identifier,             

  E_identifier,             P_identifier,           C_identifier,
  L_identifier,

  RESERVED_key_name,      UNRESERVED_key_name,

  null_name: name_ptr;               { hash table entries for these names }


  { -- signal name symbols -- }

  signal_negation_symbol,               { indicates a negated signal }
  signal_is_asserted_low_symbol,        { indicates signal is asserted low }
  signal_is_asserted_high_symbol,       { indicates signal is asserted high }
  name_property_prefix_symbol,          { prefix char for name properties }
  general_property_prefix_symbol,       { prefix char for general properties }
  class_name_separator_symbol,          { suffix char for class names }
  text_macro_delimiter_symbol,          { delimiter char for text macros }
  concatenation_symbol: symbols;        { used to concatenate signals }
  signal_negation_char,                 { character corresponding to above }
  signal_is_asserted_low_char,          { " }
  signal_is_asserted_high_char,         { " }
  name_property_prefix_char,            { " }
  general_property_prefix_char,         { " }
  concatenation_char: char;             { " }
  
  upshift: packed array[char] of char;  { char set with upshifted letters }
  upshift_dummy: packed array[char] of char;
  islegal: array[char] of boolean;      { legal SCALD char ? }
  islegal_dummy: array[char] of boolean;
  isidentchar: array[char] of boolean;  { legal id char ? }
  isidentchar_dummy: array[char] of boolean;
  isupper: array[char] of boolean;      { Upper case letter ? }
  isupper_dummy: array[char] of boolean;
  isdigit: array[char] of boolean;      { A digit ? }
  isdigit_dummy: array[char] of boolean;
  is_signal_name_terminator:
    array[char] of boolean;             { Char that can terminate a signal
                                          name ? }
  is_signal_name_term_dummy:    array[char] of boolean;
  { names of standard files }

  standard_property_file: xtring;     { standard property attribute file }
  standard_text_macro_file: xtring;   { standard text macro file }
  standard_library_file_name: xtring; { name of the MASTER library file }
  error_documentation_file: xtring;   { file containing error documentation }
  global_expansion_rules_file: xtring;

  page_expansion_file_name: xtring;      { current page expansion file name }
  page_list_file_name: xtring;           { current page list file name }

  { -- file vars --}

  Monitor:   textfile;            { status info to terminal }
  CmpLst:    textfile;            { listing files }
  CmpExp:    textfile;            { expansion output }
  CmpErr:    textfile;            { errors for the graphics editor }
  CmpLog:    textfile;            { runtime errors }
  CmpSchem:  textfile;            { record schema and contexts }
  Design:    textfile;            { talk to linker }

  infile:    inputfile;           { compiler directives file }
  CmpStan:   inputfile;           { standard input file }
  CmpDraw:   inputfile;           { listen to linker }
  CmpSchemI: inputfile;           { read schema and contexts }

  CmpTmp:    textfile;            { temp file for command line args on 370
                                    and for creating files }

  CmpDraw_fd: Cint;               { file descriptor for Cmpdraw (if specified
                                    in command line) }
  Design_fd:  Cint;               { file descriptor for Design (if specified
                                    in command line) }
  property_file: file_list_ptr;       { user's property attribute files }
  text_macro_file: file_list_ptr;     { user's text macro files }
  expansion_rules_file: file_list_ptr;{ user's expansion rules files }
  master_library_file: file_list_ptr; { name of the user's MASTER lib files }

  file_type_list: list_of_file_types;   { "constant" recognized file types }

  directory_list_root: directory_list_ptr;
  library_list_root: directory_list_ptr;

  plumbing_table: plumbing_table_type;


  RMS_error_code: integer; 

  cmpdraw_pipe: pipe;        { pipe associated with CmpDraw file }
  CmpTmp_pipe: pipe;         { pipe associated with CmpTmp file }
  Design_pipe: pipe;         { pipe associated with Design file }
  CmpExp_pipe: pipe;         { pipe associated with CmpExp file }
  CmpSchem_pipe: pipe;       { pipe assiciated with CmpSchem file }


  schema_of_drawing_being_compiled: schema_definition; { just that }

  context_being_compiled: context_definition_ptr;  
    { points to entry in schema_of_drawing_being_compiled }

  current_compiled_context: compiled_context_list_ptr; 
    { For recording the cleanliness of the expandion file being produced }

  paged_schema_of_this_page: paged_schema;            
    { expandable ids, local text macro defs, properties and dependencies
      for this page as found in this compilation }

  old_schema_page: paged_schema_ptr;
    { entry for current page in schema_of_drawing_being_compiled -- 
      reflects the last compilation of the page. }

  old_schema_page_parent: paged_schema_ptr;   
    { parent of old_schema_page }

  synonym_signal_table: synonym_table_type;  { synonym signal table }


  { -- signal constants -- }

  NC_signal: xtring;                  { NC signal name }
  Zero_signal: xtring;                { The signal '0' }
  One_signal: xtring;                 { The signal '1' }


  { -- signal structures -- }

  signal_table: table_of_signals;          { signal hash table }


  bogus_cmptmp_list: signal_instance_list_ptr;
  module_being_compiled: macro_module_ptr;
    { Ptr to object describing the current module and page (understood by
      expansion rules package). }

  specified_context: property_ptr;
    { parameters specified as context for compilation }

  root_macro_name: xtring;               { For FOO.LOGIC.1.2, this is "FOO" }
  extension_being_compiled: name_ptr;    {                    this is LOGIC }
  version_being_compiled: version_range; {                    this is 1 }
  page_being_compiled: page_range;       {                    this is 2 }

  invoke_path_table: avl_ptr; { table of invokes sorted by path }
  { -- "constant" configuration table -- }
  configure_specifiers:
                configure_specifier_type;  { configure directive params }


  { -- "const" directives tables -- }

  compiler_directive: directive_list;      { compiler directives }
  file_name_directives,                    { directives expecting file names }
  debug_directives,                        { secret debug directives }
  one_time_directives: directive_set;      { those that can only appear once }

  shareable: shareable_directive_options;  { directive values and resulting
                                             umasks }
  specified_shareable_value: shareable_value; { global variable }
  
  command_value:
    array[command_type] of name_ptr;       { Id values for command directive }


  output_file: output_file_list;            { output file names }
  SCALD_only_output_files: output_file_set; { files producable only
                                                       by (old) SCALD
						       compiler }

  report_type_table: report_table_type;  { table of report names }
  SCALD_only_reports: report_set;        { reports requiring SCALD compiler }
  

  selection_exceptions: selection_exception_ptr;
  selecting_module: boolean;

  { A flag to indicate whether to use data services or not }
  DATA_SERVICES_FLAG : integer;

  { -- global flags: directives -- }

  enable_cardinal_tap: boolean;       { TRUE if these are enabled }
  allow_missing_high_assertion,       { TRUE if this is allowed }
  tokenize_params: boolean;           { TRUE if non-integer param values
                                        are to be tokenized }
  report_unknown_assertions: boolean; { TRUE if undeterminable signal
                                        assertions are to be errors (within
					bubble checking) }
  allow_PART_NAME_property: boolean;  { TRUE if PART_NAME to be processed }
  produce_amusing_messages: boolean;  { TRUE if messages should be amusing }
  single_level_compile: boolean;      { TRUE iff SINGLE_DRAWING ON specified
                                        in directives (for comperr) }
  max_errors: natural_number;         { maximum number of errors before quit }
  display_error_doc: boolean;         { TRUE if error description to be disp }
  print_width: print_width_range;     { specified output line width }
  scope_is_local,                     { default signal scope (local/global) }
  bubble_check,                       { TRUE if bubble checking to be done }
  const_bubble_check,                 { TRUE if constants to be bubble chked }
  display_warnings,                   { warnings displayed if TRUE }
  display_oversights,                 { oversight messages displayed if TRUE }
  found_debug_password,               { TRUE if secret debug directives OK }
  ROOT_specified_in_command_line,     { TRUE if root drawing in command line }
  TYPE_specified_in_command_line,     { TRUE if compile type in command line }
  net_processing,                     { TRUE if nets to be processed }
  left_to_right: boolean;             { TRUE if bit ordering left to right }  
  user_directory_type: name_ptr;      { valid directories for expansion }
  specified_compile_type: name_ptr;   { type being compiled for }
  reports_to_generate: report_set;    { set of reports to generate }
  default_configuration_file: xtring; { default file with configuration info }
  configuration_file: xtring;         { name of file with configuration info }
  PrintCmpLst: boolean;               { TRUE if CmpLst file to be generated }
  PrintCmpErr: boolean;               { TRUE if CmpErr file to be generated }
  exception_code:
               exception_error_type;  { descriptor of run time exception }
  files_to_generate: output_file_set; { output files to be generated }
  properties_assigned_filters:
                       property_ptr;  { properties assigned filters }
  read_all_UNIX_directories: boolean; { TRUE if old style directory reading
					is to be done.  If FALSE, then 1
					directories will be read only when
					needed. }
  shadow_root: xtring;                { value of SHADOW_ROOT directive }
  command: command_type;              { What command we are doing
					(COMPILE, SEPCOMP, SEPLINK) }
  COMMAND_specified_in_command_line:  { TRUE if command specified in command }
    boolean;                          { line }
  CONTEXT_specified_in_command_line:  { TRUE if context specified in command }
    boolean;                          { line }
  CMPDRAW_specified_in_command_line:  { TRUE if CMPDRAW file descriptor in }
    boolean;                          { command line }
  DESIGN_specified_in_command_line:   { TRUE if DESIGN file descriptor in }
    boolean;                          { command line }


  analog_designer_compile: boolean;   { TRUE if looking for SUBCKT files --
                                        set only by directive from linker }

  force_primitives:
                 avl_ptr;  { table of macros to "delete" per old PRIMITIVE
		              directive semantics }


  { -- statistics vars -- }

  heap_usage,                            { count of heap structures }
  structure_size: structure_array;       { size of each structure (in bytes) }
  total_number_nodes,                    { total number of mtree nodes }
  number_leaf_nodes,                     { number of nodes that are leaves }
  number_terminal_nodes: natural_number; { number of nodes that are terminal }

  total_number_signals,                  { total number of signals }
  number_signal_instances,               { number of signal instances }
  number_non_interface_signal_instances, { number instances of non-pin sigs }
  number_unnamed_signals,                { number of unnamed signals }
  number_global_signals,                 { number of global signals }
  number_interface_signals,              { number of interface signals }
  number_local_signals: natural_number;  { number of local signals }

  number_of_sig_defs_with_synonyms,      { synonyms structure statistics }
  number_of_basescripts,
  number_of_single_bit_basescripts,
  number_of_basescripts_with_non_zero_offset,
  total_width_of_basescripts,
  number_of_base_signal_instances,
  total_synonym_chain_length: natural_number;
  synonym_chain_length: synonym_chain_bucket;

  number_interfaces_resolved,            { # interface sigs in resolve_inst }
  number_quick_resolved: natural_number; { number quick resolved }


  { -- free list vars -- }

  free_signal_instances:
                signal_instance_ptr;  { head of free signal instances }
  free_signal_definitions:
              signal_definition_ptr;  { head of free signal definitions }
  free_signal_definition_lists:
         signal_definition_list_ptr;  { head of free signal definitions list }
  free_simple_signals:
                  simple_signal_ptr;  { head of free simple signals }
  free_synonym_signals:
                 synonym_signal_ptr;  { head of free synonym signals }
  free_formal_actual_lists:
                  formal_actual_ptr;  { head of free formal/actual lists }
  free_actual_lists:
                    actual_list_ptr;  { head of list of free actual lists }
  free_subscripts:  subscript_ptr;    { head of free subscripts list }
  free_basescripts: basescript_ptr;   { head of free basescripts list }
  free_signal_descriptors:
              signal_descriptor_ptr;  { head of free signal descriptors list }
  free_base_descriptors:
                base_descriptor_ptr;  { head of free base_descriptor list }
  free_identifiers: identifier_ptr;   { head of free identifiers list }
  free_properties: property_ptr;      { head of free properties list }
  free_environments: environment_ptr; { head of list of free environments }
  free_invoke_lists: invoke_list_ptr; { head of list of free invoke_lists }
  free_subscript_properties:
              subscript_property_ptr; { head of list of free elements }
  free_bit_properties:
                    bit_property_ptr; { head of list of free bit properties }
  free_propertied_CSs:
                   propertied_CS_ptr; { head of the list of free elements }
  free_net_descriptors:
                  net_descriptor_ptr; { head of list of free net descriptors }
  free_net_tables: net_table_ptr;     { head of list of free net tables }

  free_numbered_tokens: 
    numbered_token_ptr;         { head of list of free numbered_tokens }
  free_numbered_token_lists: 
    numbered_token_list_ptr;    { head of list of free numbered_token_lists }
  free_text_macros: 
    text_macro_ptr;             { head of list of free text_macros }
  free_expandable_ids: 
    expandable_id_ptr;          { head of list of free expandable_ids }
  free_paged_schemas: 
    paged_schema_ptr;           { head of list of free paged_schemas }
  free_parameters: 
    parameter_ptr;              { head of list of free parameters }
  free_context_definitions: 
    context_definition_ptr;     { head of list of free context_definitions }
  free_directory_lists: 
    directory_list_ptr;         { head of list of free directory_lists }
  free_module_lists: 
    module_list_ptr;            { head of list of free module_lists }
  free_dependency_lists: 
    dependency_list_ptr;        { head of list of free dependency_lists }
  free_sepcomp_lists: 
    sepcomp_list_ptr;           { head of list of free sepcomp_lists }
  free_mtree_nodes: 
    mtree_node_ptr;             { head of list of free mtree_nodes }
  free_signal_entrys: 
    signal_entry_ptr;           { head of list of free signal_entrys }
  free_bindings_lists: 
    bindings_list_ptr;          { head of list of free bindings_lists }
  free_macro_defs: 
    macro_def_ptr;              { head of list of free macro_defs }
  free_clear_text_actual_lists:
    clear_text_actual_list_ptr; { head of free list of these }
  free_signal_lists:
    signal_list_ptr;            { head of free list of these }
  free_avls: avl_ptr;           { head of free list of these }
  free_signal_instance_lists:
    signal_instance_list_ptr;   { head of free list of these }
  free_compiled_context_lists:
    compiled_context_list_ptr;  { head of free list of these }
  free_property_attributes:
    property_attribute_ptr;     { head of free list of these }


  modules_in_page: module_table;      { modules encountered in compile }

  { -- Expansion file dictionaries -- }
  expansion_string_dictionary: 
    numbered_dictionary;           { string dic for expansion file }
  expansion_id_dictionary: 
    numbered_dictionary;           { id dic for expansion file }

  { -- Expansion file "constants" -- }
  expansion_NC_string: 
    numbered_token_ptr;      { prevents repeated table lookups for NCs }
  expansion_0_string: 
    numbered_token_ptr;      { prevents repeated table lookups for constants }
  expansion_1_string: 
    numbered_token_ptr;      { prevents repeated table lookups for constants }

  { -- misc -- }
  expansion_compile_time: xtring;      { compile time for expansion file }

  compile_command_table: 
    array[compile_command] of name_ptr; { Table of secomp commands }

  sepcomp_list_root: sepcomp_list_ptr; { head of list of drawings to be
					 compiled }
  current_sepcomp: sepcomp_list_ptr;   { The drawing/context being
					 compiled.  This is either NIL, or
					 the first or second element of the
					 list. }
  last_sepcomp: sepcomp_list_ptr;      { The last drawing/context that was
					 compiled (parent of current_sepcomp).
					 This is either NIL or the first 
					 element of the list }

  temp_file_name: xtring;              { The name of the CmpTmp file (which
                                         must be known literally as it must
					 be written to the design file.  It
					 is only used when the design file
					 is specified as a file descriptor
					 in the command line. }


    specified_severity: 
      comperr_severity_level; { Pages have their list files prined if they
                                contain anomalies of this severity or
			        greater. }
  EFS_PREFIX_string: xtring;        { string containing EFS_PREFIX }


  kill_received: boolean;          { TRUE iff KILL signal has been received }
  expansion_file_open: boolean;    { TRUE iff cmpexp_pipe open }
  schema_file_open: boolean;       { TRUE iff schema file open }
  monitor_open: boolean;           { TRUE iff monitor is open }
  in_critical_section: 
    natural_number;                { semaphore is > 0 if in a critical
                                     section.  All modifications to
				     schema data after its initial read-in
				     and the writing of the
				     schema file are considered critical and
				     exit due to signal will be postponded
				     until these are completed and the
				     open schema file has been written. }
  writing_schema_file: boolean;    { TRUE while writing expansion file }

  kill_count: 0..RIDICULOUS_KILL_COUNT; { number of extra "kill's" received
                                          for which a nice message has been
					  printed. }


(**)     { ------- system dependent external routines  ------- }


function bit_and( a, b: integer): integer;  external c;
   

{ (The following function has params in usual order -- need to 
  reverse them in calls from SVS }
function dup2(oldfd,newfd : Cint) : Cint;  external c;

function creadln(var f: inputfile;  line: xtring): Cint;  external c;
function cfclose(var f: inputfile): boolean; external c;
function cfdsc(var f: inputfile): Cint;  external c;
function creset(var f: inputfile; var logical: alpha;
                name: xtring; buffer_size: Cint): boolean;  external c;
function ds_creset(var f: inputfile; var logical: alpha;
                name: xtring; buffer_size: Cint): boolean;  external c;
function delete_file(name: xtring): boolean; external c;
procedure def_handler(procedure handler);  external c;
procedure suicide;  external c;


procedure exit(code: integer);  external c;


function umask( new_umask: Cint): Cint;  external c;
  

{ The following are mine, so parameter reversal is handled in the C code }


function gettime( name: xtring; var stamp: Cint): boolean;  external c;
function vversion: xtring;  external c;
procedure unbuf_stderr; external c;
function delete_logical_file(var name: alpha): boolean; external c;
function file_exists( name: xtring): boolean; external c;
procedure add_init(procedure parse_err_notifier); external c;


function efs_lock(uid: Cint; node, name, err: xtring): boolean;
  { lock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
external c;


function efs_unlock(uid: Cint; node, name, err: xtring): boolean;
  { unlock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
external c; 


(* --------------  Expansion control ------------------------------------*)


{ Functions provided by expansion control module }

procedure er_init(function parse_bool(s: xtring): integer;
                  procedure err(n: integer);
                  procedure err_assert(n: integer);
                  procedure err_int(n: integer);
                  procedure err_indent;
                  procedure err_string(s: xtring);
                  procedure err_context;
                  procedure err_crlf;
                  procedure err_add
		  );  external c;
  { init expansion control }

procedure er_type(var compile_type: alpha);  external c;
  { set up expansion control for compile type }

function er_read( filename: xtring): boolean; external c;
  { read expansion rules file -- return TRUE if ok (else fatal error) }

function er_select( drawing_name, context: xtring; 
   check_for_prim: integer): macro_module_ptr;  external c;
  { select module to be compiled for given drawing. If check_for_prim is 
    non-0, ignore "Drawing not found" and "No acceptable extension found"
    errors -- it's single_drawing on mode. }

procedure er_release(var modl: macro_module_ptr);  external c;
  { release version and set to NIL }

function er_special( modl: macro_module_ptr): xtring;  external c;
  { returns special non-graphical model for current module }

function er_extension( modl: macro_module_ptr): xtring;  external c;
  { returns extension (drawing type, e.g. LOGIC) of chosen module }

function er_version( modl: macro_module_ptr): version_range;  external c;
  { returns version number }

function er_page( modl: macro_module_ptr): page_range;  external c;
  { returns NEXT page number -- this is an iterator }

function er_dirtype( modl: macro_module_ptr): xtring;  external c;
  { returns type of SCALD directory containing the selected module.  (If
    module is a combined special/primitive, then this is the type of the
    directory containing the .PRIM or .PART.) }

function er_filename( modl: macro_module_ptr;
                      which_file: integer; { ord of file_types value }
		      page: natural_number;
		      context: xtring): xtring;  external c;
  { returns next page number }

function er_isprim( modl: macro_module_ptr): boolean;  external c;
  { returns TRUE iff this is a primitive -- that is it is a PRIM or PART
    extension and/or a special or a drawing type that is forced to
    primitive. }

function er_force_to_prim( modl: macro_module_ptr): boolean;  external c;
  { returns TRUE iff this is a non-PRIM/PART extension that is to be
    forced to primitive. }

function er_issimple( modl: macro_module_ptr): page_range;  external c;
  { if this is a single-versioned, single-paged primitive, return the
    page number, else return 0. }

function er_samedwg( modl1, modl2: macro_module_ptr): boolean;  external c;
  { TRUE iff both modules are from the same drawing AND scald directory }

procedure er_dump;  external c;
  { Dump SCALD directories }


procedure er_except(var comptype: alpha; 
	             drawing: xtring;   context: xtring;
                    var extension, attribute: alpha);  external c;
  { Pick the given extension(attribute) when compiling drawing for comptype }

procedure er_debug;  external c;
  { Turn on interface debugging -- messages to stderr }


(**)     { ------- Machine dependent procedures ------- }


procedure halt_with_status(halt_code: integer);
  { halt the program generating some termination status }


begin


  exit(halt_code);

end { halt_with_status } ;


(**)     { ------- FORWARD procedure declarations ------- }


function rewrite_file(var txtfil: textfile; filename: xtring; 
                      logical: alpha): boolean;
forward;

function rewrite_ds_file(var txtfil: textfile; filename: xtring; 
                      logical: alpha): boolean;
forward;

procedure remove_logical_file(fname: alpha);
forward;

function close_parse_file(which: parse_file_type): boolean;
forward;

procedure close_file(var f: textfile; logical: alpha; file_name: xtring);
forward;


procedure post_compile_time(var f: textfile; file_kind: file_kind_type);
forward;

procedure exec_time(var last_elapsed_time, last_CPU_time: integer;
                    just_delta: boolean);
forward;

function reset_file(filename: xtring; which: parse_file_type): boolean;
forward;

function reset_ds_file(filename: xtring; which: parse_file_type): boolean;
forward;


procedure init_time_and_date(var current_elapsed_time,
                                 current_CPU_time: integer;
                             var current_date: time_string);
forward;


procedure init_time(var current_elapsed_time, current_CPU_time: integer);
forward;

procedure enter_expandable_id(id: name_ptr);
forward;

procedure report_expandable_id_to_ds(id: name_ptr);
forward;

procedure log_property_use(id: name_ptr);
forward;

procedure init_numbered_dictionary(var dic: numbered_dictionary; 
				   token_kind: numbered_token_type);
forward;

function enter_name(name: alpha): name_ptr;
forward;

function make_and_enter_string(name: alpha): xtring;
forward;

function enter_and_release_string(str: xtring): xtring;
forward;

function enter_string(str: xtring): xtring;
forward;

procedure assert(assertion_num: assert_range);
forward;

function alpha_length(name: alpha): id_range;
forward;

procedure error_dump_signal_descriptor(signal: signal_descriptor_ptr);

forward;

procedure new_identifier(var id: identifier_ptr);
forward;

procedure error_dump_current_parse_environment;
forward;

procedure init_error_info;
forward;

function find_property(prop_list: property_ptr;  name: name_ptr;
                       var property: property_ptr): boolean;
forward;

procedure insymbol;
forward;

function avl_compare(obj1, obj2: avl_object_ptr; 
                      kind: avl_type): compare_type;
forward;

procedure dump_text_macros(var f: textfile; list: text_macro_ptr);
forward;

procedure mark_dirty_for_pass_2(page: paged_schema_ptr);
forward;

procedure enter_critical_section;  forward;
procedure exit_critical_section;  forward;
procedure kill_self;  forward;


procedure error(error_num: error_range);  forward;


function select_module(drawing_name, context: xtring; check_for_prim: integer):
  macro_module_ptr;
  { Call er_select() via this, so that we ddon't get bougs warnings about
    using default value for SIZE. }
begin
  selecting_module := TRUE;
  select_module := er_select(drawing_name, context, check_for_prim);
  selecting_module := FALSE;
end;

procedure setup_signal_configuration_from_ds_module; forward;


{ Functions leveraged by expansion control module }

procedure error_without_parse_line(num: integer);  forward;
procedure assert_without_parse_line(num: integer);  forward;
function evaluate_boolean_expr(str: xtring): integer;  forward;
procedure error_dump_integer(int: integer);  forward;
procedure error_dump_string(str: xtring);  forward;
procedure error_dump_standard_indent;  forward;
procedure error_dump_current_context;  forward;
procedure error_dump_crlf;  forward;
procedure parse_error_notifier;  forward;

(**)     { ------- trivia ------- }


function min(a, b: integer): integer;
  { return the min }
begin
  if a < b then   min := a  else  min := b;
end { min } ;


function max(a, b: integer): integer;
  { return the max }
begin
  if a > b then   max := a  else  max := b;
end { max } ;


function et_property_attributes(kind: name_type_set): integer;
  { return the property attribute code for the set using the values
    declared for use with et (the linker). }
  var
    val: integer;  { value for return }
begin
  val := 0;
  if (PERMIT_BODY in kind) then val := val + ET_PERMIT_BODY;
  if (PERMIT_PIN in kind) then val := val + ET_PERMIT_PIN;
  if (PERMIT_SIGNAL in kind) then val := val + ET_PERMIT_SIGNAL;
  if (INHERIT_BODY in kind) then val := val + ET_INHERIT_BODY;
  if (INHERIT_PIN in kind) then val := val + ET_INHERIT_PIN;
  if (INHERIT_SIGNAL in kind) then val := val + ET_INHERIT_SIGNAL;
  if (IS_PARAMETER in kind) then val := val + ET_PARAMETER;
  if (IS_INT_PARAMETER in kind) then val := val + ET_INT_PARAMETER;
  if (DONT_OUTPUT in kind) then val := val + ET_FILTER;
  if (IS_ET_CONTROL in kind) then val := val + ET_CONTROL;
  et_property_attributes := val;
end { et_property_attributes } ;

  
(**)     { ------- I/O utilities ------- }


procedure dump_boolean(var f: textfile; val: boolean);
begin
  if val then write(f, 'T')
         else write(f, 'F');
end { dump_boolean };


function width_of_integer(i: integer): integer;
  { Returns the minimum number of places PASCAL uses to print i }
  var
    width: integer;     { width of the integer i in print positions }
begin
  width := 1;
  if i < 0 then
    begin  width := 2;  i := -1;  end;

  if i < 10 then  { ok as is }
  else if i < 100 then width := width + 1
  else if i < 1000 then width := width + 2
  else if i < 10000 then width := width + 3
  else if i < 100000 then width := width + 4
  else if i < 1000000 then width := width + 5
  else if i < 10000000 then width := width + 6
  else if i < 100000000 then width := width + 7
  else if i < 1000000000 then width := width + 8
  else width := width + 9;

  width_of_integer := width;
end { width_of_integer } ;


procedure dump_string(var f: textfile; str: xtring);
  { dump the given string (STR) to the given file (F) as is }
  var
    hack: string_hack;
begin
  if ord(str^[0]) > 0 then
    begin
      hack.i := ord(str) + 1;  write(f, hack.s^:ord(str^[0]));
    end;
end { dump_string } ;
    

procedure writestring(var f: textfile; str: Xtring);
  { write the given string (STR) to the given file (F) as is with quotes }
begin
  write(f, OUTPUT_QUOTE_CHAR);

  dump_string(f, str);

  write(f, OUTPUT_QUOTE_CHAR);
end { writestring } ;
    

procedure print_string(var f: textfile; str: xtring);
  { print the given string (STR) to the given file (F) }
  var
    i: string_range;
    len: string_range;
    hack: string_hack;
begin
  { NOTE: Illegal characters can ONLY occur in str^[1] -- used there
    to quickly signify an NC. Illegal chars in input files are filtered
    by insymbol. }
  len := ord(str^[0]);
  if (len > 0) and islegal[str^[1]] then                           
    begin
      hack.i := ord(str) + 1;  write(f, hack.s^:len);
    end
  else if (len > 1) then
    begin
      hack.i := ord(str) + 2;  write(f, hack.s^:len-1);
    end;
end { print_string } ;


procedure print_string_repeat_quotes(var f: textfile; str: xtring);
  { print the string (STR) to the given file (F) doubling up any quotes }
  var
    len, start: string_range;
    stop: integer;  { may overflow string_range by 1 }
    hack: string_hack;
    found_quote: boolean;
begin
  len := ord(str^[0]);  
  stop := 1;
  while stop <= len do
    begin
      start := stop;  found_quote := FALSE;
      while (stop <= len) and not found_quote do
	begin
	  found_quote := str^[stop] = OUTPUT_QUOTE_CHAR;
	  stop := stop + 1;
	end;
      hack.i := ord(str) + start;
      write(f, hack.s^:(stop - start));
      if found_quote then write(f, OUTPUT_QUOTE_CHAR:1);
    end;
end { print_string_repeat_quotes } ;


procedure print_string_with_quotes(var f: textfile; str: xtring);
  { write a string to the output file }
begin
  write(f, OUTPUT_QUOTE_CHAR);
  print_string_repeat_quotes(f, str);
  write(f, OUTPUT_QUOTE_CHAR);
end { print_string_with_quotes } ;
    

procedure print_alpha(var f: textfile; name: alpha);
  { print the given alpha (NAME) to the given file (F) }
begin
  write(f, name:alpha_length(name));
end { print_alpha } ;


procedure writealpha(var f: textfile; name: alpha);
  { write an identifier to the output file removing trailing blanks }
begin
  write(f, name:alpha_length(name));
end { writealpha } ;


(**)     { ------- statistics routines ------- }


procedure increment_heap_count(structure: heap_structures;
                               numbytes: natural_number);
  { advance count of the size of elements created on the heap }
begin
  with heap_usage[structure] do
    begin
      number := number + 1;
      size := size + numbytes;
    end;
end { increment_heap_count } ;


procedure report_heap_usage(var f: textfile);
  { report the sizes and number of the structures used }
  const
    struct_length = 19;          { output print width for structure names }
  var
    structure: heap_structures;  { structure to be reported }
    corrected_total,             { heap corrected total }
    total: natural_number;       { total number of bytes of all structures }
    number: natural_number;      { number of elements for current structure }
    size: natural_number;        { size (bytes) of current structure }
    diff_size: natural_number;   { difference between min heap size and elem }


  procedure report_free_list;
    { report the number of free elements in the free structure lists }
    var
      num: natural_number;          { number of free elements in a free list }

      { following vars used to count up elements of free lists }

      SDP: signal_descriptor_ptr;
      DEF: signal_definition_ptr;
      SIP: signal_instance_ptr;
      FP: freeptr;
      j: string_range;
      id: identifier_ptr;
      SP: subscript_ptr;
      PP: property_ptr;
      EP: environment_ptr;
      ILP: invoke_list_ptr;
      BP: basescript_ptr;
      BDP: base_descriptor_ptr;
      SDLP: signal_definition_list_ptr;
      FAP: formal_actual_ptr;
      SSP: simple_signal_ptr;
      SynSP: synonym_signal_ptr;
      SbP: subscript_property_ptr;
      BiP: bit_property_ptr;
      PCSP: propertied_CS_ptr;
      ALP: actual_list_ptr;
      NDP: net_descriptor_ptr;
      NTP: net_table_ptr;
  begin
    num := 0;
    case structure of
      HEAP_SIGNAL_DEFINITION:
        begin
          DEF := free_signal_definitions;
          while DEF <> NIL do
            begin  num := num + 1;  DEF := DEF^.next;  end;
        end;

      HEAP_SIGNAL_DEFINITION_LIST:
        begin
          SDLP := free_signal_definition_lists;
          while SDLP <> NIL do
            begin  num := num + 1;  SDLP := SDLP^.next;  end;
        end;

      HEAP_SIGNAL_INSTANCE:
        begin
          SIP := free_signal_instances;
          while SIP <> NIL do
            begin  num := num + 1;  SIP := SIP^.next;  end;
        end;

      HEAP_SIGNALDESCR:
        begin
          SDP := free_signal_descriptors;
          while SDP <> NIL do
            begin  num := num + 1;  SDP := SDP^.next;  end;
        end;

      HEAP_SIMPLE_SIGNAL:
        begin
          SSP := free_simple_signals;
          while SSP <> NIL do
            begin  num := num + 1;  SSP := SSP^.next;  end;
        end;

      HEAP_INVOKELIST:
        begin
          ILP := free_invoke_lists;
          while ILP <> NIL do
            begin  num := num + 1;  ILP := ILP^.next;  end;
        end;

      HEAP_FORMAL_ACTUAL_LIST:
        begin
          FAP := free_formal_actual_lists;
          while FAP <> NIL do
            begin  num := num + 1;  FAP := FAP^.next;  end;
        end;

      HEAP_FREEELEMENT:
        begin
          FP := free_pointers;
          while FP <> NIL do
            begin  num := num + 1;  FP := FP^.next;  end;
        end;

      HEAP_STRING:
        for j := 1 to 33 do
          begin
            FP := free_strings[j];
            while FP <> NIL do
              begin  num := num + 1;  FP := FP^.next;  end;
          end;

      HEAP_IDENTIFIER:
        begin
          id := free_identifiers;
          while id <> NIL do
            begin  num := num + 1;  id := id^.next;  end;
        end;

      HEAP_SUBSCRIPT:
        begin
          SP := free_subscripts;
          while SP <> NIL do
            begin  num := num + 1;  SP := SP^.next;  end;
        end;

      HEAP_PROPERTY:
        begin
          PP := free_properties;
          while PP <> NIL do
            begin  num := num + 1;  PP := PP^.next;  end;
        end;

      HEAP_ENVIRONMENT_ENTRY:
        begin
          EP := free_environments;
          while EP <> NIL do
            begin  num := num + 1;  EP := EP^.next;  end;
        end;

      HEAP_BASESCRIPT:
        begin
          BP := free_basescripts;
          while BP <> NIL do
            begin  num := num + 1;  BP := BP^.next;  end;
        end;

      HEAP_BASE_DESCRIPTOR:
        begin
          BDP := free_base_descriptors;
          while BDP <> NIL do
            begin  num := num + 1;  BDP := BDP^.next;  end;
        end;

      HEAP_SYNONYM_SIGNAL:
        begin
          SynSP := free_synonym_signals;
          while SynSP <> NIL do
            begin  num := num + 1;  SynSP := SynSP^.next;  end;
        end;

      HEAP_SUBSCRIPT_PROPERTY:
        begin
          SbP := free_subscript_properties;
          while SbP <> NIL do
            begin  num := num + 1;  SbP := SbP^.next;  end;
        end;

      HEAP_BIT_PROPERTY:
        begin
          BiP := free_bit_properties;
          while BiP <> NIL do
            begin  num := num + 1;  BiP := BiP^.next;  end;
        end;

      HEAP_PROPERTIED_CONCATSIG:
        begin
          PCSP := free_propertied_CSs;
          while PCSP <> NIL do
            begin  num := num + 1;  PCSP := PCSP^.next;  end;
        end;

      HEAP_ACTUAL_LIST:
        begin
          ALP := free_actual_lists;
          while ALP <> NIL do
            begin  num := num + 1;  ALP := ALP^.next;  end;
        end;

      HEAP_NET_DESCRIPTOR:
        begin
          NDP := free_net_descriptors;
          while NDP <> NIL do
            begin  num := num + 1;  NDP := NDP^.next;  end;
        end;

      HEAP_NET_TABLE:
        begin
          NTP := free_net_tables;
          while NTP <> NIL do
            begin  num := num + 1;  NTP := NTP^.next;  end;
        end;
    end { case } ;

    writeln(f, ' (', num:1, ')');
  end { report_free_list } ;


begin { report_heap_usage }
  if debug_20 then writeln(outfile, ' enter report_heap_usage');
  total := 0;
  corrected_total := 0;

  page(f);
  writeln(f, ' Heap Statistics');  writeln(f);
  writeln(f, ' # Elements  # Bytes  Structure type (# free)');

  for structure := succ(FIRST_HEAP_STRUCTURE) to pred(LAST_HEAP_STRUCTURE) do
    begin
      number := heap_usage[structure].number;
      size := heap_usage[structure].size;

      write(f, number:7);

      write(f, size:12);

      total := total + size;

      { calculate heap corrected total }

      if number > 0 then
        begin
          corrected_total := corrected_total + size + HEAP_OVERHEAD * number;

          diff_size := ((size+1) DIV number) MOD MINIMUM_HEAP_INCREMENT;
          if diff_size <> 0 then
            corrected_total := corrected_total +
                                (MINIMUM_HEAP_INCREMENT - diff_size) * number;
        end;

      case structure of
        HEAP_BINDINGSLIST:  writeln(f, 'Bindings list':struct_length);

        HEAP_INVOKELIST:    begin
                              write(f, 'Invoke list':struct_length);
                              report_free_list;
                            end;

        HEAP_SIGNALLIST:    writeln(f, 'Signal list':struct_length);

        HEAP_MACRODEF:      writeln(f, 'Macro def':struct_length);

        HEAP_MTREENODE:     writeln(f, 'Mtree node':struct_length);

        HEAP_IDENTIFIER:    begin
                              write(f, 'Identifier':struct_length);
                              report_free_list;
                            end;

        HEAP_FREEELEMENT:   begin
                              write(f, 'Free element':struct_length);
                              report_free_list;
                            end;

        HEAP_STRING:        begin
                              write(f, 'String':struct_length);
                              report_free_list;
                            end;

        HEAP_PROPERTY:      begin
                              write(f, 'Property':struct_length);
                              report_free_list;
                            end;

        HEAP_DIRECTORY:     writeln(f, 'Directory':struct_length);

        HEAP_MACROENTRY:    writeln(f, 'Macro entry':struct_length);

        HEAP_FILELIST:      writeln(f, 'File list':struct_length);

        HEAP_MACROVERSION:  writeln(f, 'Macro version':struct_length);

        HEAP_SIGNALDESCR:   begin
                              write(f, 'Signal descr':struct_length);
                              report_free_list;
                            end;

        HEAP_SIMPLE_SIGNAL: begin
                              write(f, 'Simple signal':struct_length);
                              report_free_list;
                            end;

        HEAP_SYNONYM_SIGNAL:
                            begin
                              write(f, 'Synonym signal':struct_length);
                              report_free_list;
                            end;

        HEAP_SUBSCRIPT:     begin
                              write(f, 'Subscript':struct_length);
                              report_free_list;
                            end;

        HEAP_SIGNAL_DEFINITION_LIST:
                            begin
                              write(f, 'Sig def list':struct_length);
                              report_free_list;
                            end;

        HEAP_SIGNALENTRY:   writeln(f, 'Signal entry':struct_length);

        HEAP_SIGNAL_DEFINITION:
                            begin
                              write(f, 'Signal def':struct_length);
                              report_free_list;
                            end;

        HEAP_SIGNAL_INSTANCE:
                            begin
                              write(f, 'Signal inst':struct_length);
                              report_free_list;
                            end;

        HEAP_FORMAL_ACTUAL_LIST:
                            begin
                              write(f, 'For/act list':struct_length);
                              report_free_list;
                            end;

        HEAP_CLEAR_TEXT_ACTUAL_LIST:
                            writeln(f, 'Clear text act':struct_length);

        HEAP_NAME_ENTRY:    writeln(f, 'Identifier names':struct_length);

        HEAP_ENVIRONMENT_ENTRY:
                            begin
                              write(f, 'Environment elem':struct_length);
                              report_free_list;
                            end;

        HEAP_HASH_STRINGS:  writeln(f, 'Hash Strings':struct_length);

        HEAP_ACTUAL_LIST:   begin
                              write(f, 'Actual lists':struct_length);
                              report_free_list;
                            end;

        HEAP_BASESCRIPT:    begin
                              write(f, 'Base subscripts':struct_length);
                              report_free_list;
                            end;

        HEAP_BASE_DESCRIPTOR:
                            begin
                              write(f, 'Base descriptors':struct_length);
                              report_free_list;
                            end;

        HEAP_SUBSCRIPT_PROPERTY:
                            begin
                              write(f, 'Subscr props':struct_length);
                              report_free_list;
                            end;

        HEAP_BIT_PROPERTY:  begin
                              write(f, 'Bit properties':struct_length);
                              report_free_list;
                            end;

        HEAP_PROPERTIED_CONCATSIG:
                            begin
                              write(f, 'CS with props':struct_length);
                              report_free_list;
                            end;

        HEAP_FILE_LIST:     writeln(f, 'File lists':struct_length);

        HEAP_NET_DESCRIPTOR:
                            begin
                              write(f, 'Net descriptors':struct_length);
                              report_free_list;
                            end;

        HEAP_NET_TABLE:     begin
                              write(f, 'Net tables':struct_length);
                              report_free_list;
                            end;

        HEAP_NAME_LIST:     writeln(f, 'Name lists':struct_length);

        HEAP_AVL:           writeln(f, 'Avl members':struct_length);

	OTHERWISE
	  begin 
            writeln(f, 'Other':struct_length);
	  (*
	    assert(219);
	    writeln(cmplog, ' structure ', ord(structure):1);
	    if debugging then 
              writeln(outfile, ' structure ', ord(structure):1);
	  *)
	  end;
      end { case } ;
    end;

  writeln(f);
  writeln(f, total:19, 'Total':struct_length);
  writeln(f, corrected_total:19);
  writeln(f);

  if PrintCmpLst then
    begin
      page(CmpLst);
      writeln(CmpLst, ' Compiler structures used an estimated ',
                      corrected_total:1, ' bytes of heap storage.');
    end;

  writeln(f);
  writeln(f);
  writeln(f, ' Major static table sizes');  writeln(f);
  writeln(f, ' # Elements  # Bytes    Structure type');

  writeln(f, (SIGNAL_TABLE_SIZE+1):7,
                  (SIGNAL_TABLE_SIZE+1)*POINTER_SIZE:12,
                  'Signal table':struct_length);
  writeln(f, (NAME_TABLE_SIZE+1):7,
                  (NAME_TABLE_SIZE+1)*POINTER_SIZE:12,
                  'Identifier table':struct_length);
  writeln(f, (HASH_STRING_TABLE_SIZE+1):7,
                  (HASH_STRING_TABLE_SIZE+1)*POINTER_SIZE:12,
                  'String table':struct_length);

  total := (SIGNAL_TABLE_SIZE+1 +
            NAME_TABLE_SIZE+1 +
            HASH_STRING_TABLE_SIZE+1) * POINTER_SIZE;

  writeln(f);
  writeln(f, total:19, 'Total':struct_length);
  writeln(f);
  if debug_20 then writeln(outfile, ' exit report_heap_usage');
end { report_heap_usage } ;


(**)     { ------- string package routines ------- }


{
               ***********************************
               *                                 *
               *       String description        *
               *                                 *
               ***********************************


   A string is represented as a pointer to a packed array of char:

       string = ^packed array [0..255] of char;

   Each string, however, is usually less than 256 characters.  The
   actual length of the string is found in the first byte:  string^[0].
   The length of the string is static;  it should not be changed once
   the string has been created.

   Strings can be up to 255 characters long.  The programmer must make
   sure that characters are not written beyond the end of the string.

   Strings are created on the heap in quantized lengths.  There are 33
   different length arrays created.  The create_a_string routine
   creates an array on the heap big enough to support the given string. }


procedure new_free_element(var f: freeptr);
  { create a new free element for released strings }
begin
  new(f);
  increment_heap_count(HEAP_FREEELEMENT, 2*POINTER_SIZE);
  f^.next := NIL;
  f^.str := NIL;
end { new_free_element } ;


procedure create_a_string(var str: xtring; length: string_range);
  { Create a string on the heap of the given length.  This routine uses a
    variant record to represent strings of various lengths with one
    pointer.  First, the free lists are checked for a string of the
    appropriate length.  If none are available, a string is newed from
    the heap.  This scheme works only if the Pascal compiler creates only
    as much space as needed for a variant when the tag field is specified
    in the new.  }
  type
    size_type = (s4,s8,s12,s16,s20,s24,s28,sz32,s36,s40,s44,
                 s48,s52,s56,s60,s64,s68,s72,s76,s80,s84,s88,
                 s92,s96,s100,s120,s140,s160,s180,s200,s220,s240,s256);

    trick_ptr = ^trick_record;
    trick_record = record case size_type of
                     s4: (f4: packed array [0..3] of char);
                     s8: (f8: packed array [0..7] of char);
                     s12: (f12: packed array [0..11] of char);
                     s16: (f16: packed array [0..15] of char);
                     s20: (f20: packed array [0..19] of char);
                     s24: (f24: packed array [0..23] of char);
                     s28: (f28: packed array [0..27] of char);
                     sz32: (f32: packed array [0..31] of char);
                     s36: (f36: packed array [0..35] of char);
                     s40: (f40: packed array [0..39] of char);
                     s44: (f44: packed array [0..43] of char);
                     s48: (f48: packed array [0..47] of char);
                     s52: (f52: packed array [0..51] of char);
                     s56: (f56: packed array [0..55] of char);
                     s60: (f60: packed array [0..59] of char);
                     s64: (f64: packed array [0..63] of char);
                     s68: (f68: packed array [0..67] of char);
                     s72: (f72: packed array [0..71] of char);
                     s76: (f76: packed array [0..75] of char);
                     s80: (f80: packed array [0..79] of char);
                     s84: (f84: packed array [0..83] of char);
                     s88: (f88: packed array [0..87] of char);
                     s92: (f92: packed array [0..91] of char);
                     s96: (f96: packed array [0..95] of char);
                     s100: (f100: packed array [0..99] of char);
                     s120: (f120: packed array [0..119] of char);
                     s140: (f140: packed array [0..139] of char);
                     s160: (f160: packed array [0..159] of char);
                     s180: (f180: packed array [0..179] of char);
                     s200: (f200: packed array [0..199] of char);
                     s220: (f220: packed array [0..219] of char);
                     s240: (f240: packed array [0..239] of char);
                     s256: (f256: packed array [0..255] of char);
                    end;
var
  k: record case boolean of      { "trick" record to fiddle with pointers }
       TRUE:  (tp: trick_ptr);
       FALSE: (ap: xtring);
     end;
  p: trick_ptr;                  { pointer to the created string }
  fp: freeptr;                   { pointer to head of free strings }
  size: 1..33;                   { the size (index into table) of string }

begin
  if length > 100 then size := ((length+1)+420) DIV 20
                  else size := ((length+1) DIV 4) + 1;
  if free_strings[size] <> NIL then
    begin
      str := free_strings[size]^.str;
      fp := free_strings[size]^.next;
      free_strings[size]^.next := free_pointers;
      free_pointers := free_strings[size];
      free_strings[size] := fp;
    end
  else
    begin
      case s_length[size] of
          4: new(p,s4);
          8: new(p,s8);
         12: new(p,s12);
         16: new(p,s16);
         20: new(p,s20);
         24: new(p,s24);
         28: new(p,s28);
         32: new(p,sz32);
         36: new(p,s36);
         40: new(p,s40);
         44: new(p,s44);
         48: new(p,s48);
         52: new(p,s52);
         56: new(p,s56);
         60: new(p,s60);
         64: new(p,s64);
         68: new(p,s68);
         72: new(p,s72);
         76: new(p,s76);
         80: new(p,s80);
         84: new(p,s84);
         88: new(p,s88);
         92: new(p,s92);
         96: new(p,s96);
        100: new(p,s100);
        120: new(p,s120);
        140: new(p,s140);
        160: new(p,s160);
        180: new(p,s180);
        200: new(p,s200);
        220: new(p,s220);
        240: new(p,s240);
        256: new(p,s256);
      end;
      k.tp := p;  str := k.ap;
      increment_heap_count(HEAP_STRING, s_length[size]);
    end;
  str^[0] := chr(length);
end { create_a_string } ;


procedure release_string(var str: xtring);
  { free the storage used by the given string and place on free list }
  var
    size: string_range;     { size (index into table) of the string }
    f: freeptr;             { head of list of free strings }
begin
  if str <> nullstring then
    begin
      if ord(str^[0]) > 100 then size := (ord(str^[0])+420) DIV 20
                            else size := (ord(str^[0]) DIV 4) + 1;
      if free_pointers = NIL then new_free_element(f)
      else
        begin f := free_pointers; free_pointers := free_pointers^.next; end;
      f^.next := free_strings[size];
      free_strings[size] := f;  f^.str := str;
      str := nullstring;
    end;
end { release_string } ;


procedure copy_string(source: xtring;  var dest: xtring);
  { copy from the source to the destination.  The destination string must 
    exist (= nullstring or some other string).  If the source length is not
    equal to the destination length the destination string is "free"d and a
    new string of the proper size is created. }
  var
    pos: string_range;        { index into string for copy }
begin
  if source = NIL then source := nullstring;
  if source^[0] <> dest^[0] then
    begin
      release_string(dest);  create_a_string(dest, ord(source^[0]));
    end;

  for pos := 1 to ord(source^[0]) do  dest^[pos] := source^[pos];
end { copy_string } ;

    
procedure copy_from_string(str: xtring; var name: alpha);
  { copy from a string to an identifier.  Pad with blanks if the string
    has fewer characters than the identifier;  truncate if longer. }
  var
    min,            { smaller of ID_LENGTH and length(string) }
    i: id_range;    { index into the alpha }
begin
  name := null_alpha;
  if ord(str^[0]) < ID_LENGTH then min := ord(str^[0]) else min := ID_LENGTH;
  for i := 1 to min do name[i] := str^[i];
end { copy_from_string } ;


procedure copy_to_string(name: alpha;  var str: xtring);
  { copy from an alpha to a string.  Trailing blanks are deleted. }
  var
    len: id_range;    { length of the identifer }
    i: id_range;      { index into alpha and string for copy }
begin
  len := alpha_length(name);

  if ord(str^[0]) <> len then 
    begin  release_string(str);  create_a_string(str, len);  end;
  for i := 1 to len do  str^[i] := name[i];
end { copy_to_string } ;


function CmpStrLEQ(s1, s2: xtring): boolean;
  { returns TRUE if s1 <= s2, FALSE otherwise. }
  var
    min_length,             { minimum length of the two strings }
    i: string_range;        { index into the strings }
    done: boolean;          { TRUE if comparison complete }
begin
  if s1^[0] > s2^[0] then 
    begin  min_length := ord(s2^[0]);  CmpStrLEQ := FALSE;  end
  else
    begin  min_length := ord(s1^[0]);  CmpStrLEQ := TRUE;  end;

  i := 0;  done := FALSE;
  while (i < min_length) and not done do
    begin
      i := i + 1;
      if s1^[i] > s2^[i] then
        begin  CmpStrLEQ := FALSE;  done := TRUE;  end
      else
        if s1^[i] < s2^[i] then
          begin  CmpStrLEQ := TRUE;  done := TRUE;  end;
    end;
end { CmpStrLEQ } ;


function CmpStrLT(s1, s2: xtring): boolean;
  { returns TRUE if s1 < s2, FALSE otherwise. }
  var
    min_length,             { minimum length of the two strings }
    i: string_range;        { index into the strings }
    done: boolean;          { TRUE if comparison complete }
begin
  if s1^[0] <= s2^[0] then 
    begin  min_length := ord(s1^[0]);  CmpStrLT := TRUE;  end
  else 
    begin  min_length := ord(s2^[0]);  CmpStrLT := FALSE;  end;

  i := 0;  done := FALSE;
  while (i < min_length) and not done do
    begin
      i := i + 1;
      if s1^[i] > s2^[i] then 
        begin  CmpStrLT := FALSE;  done := TRUE;  end
      else if s1^[i] < s2^[i] then
        begin  CmpStrLT := TRUE;  done := TRUE;  end;
    end;
end { CmpStrLT } ;


function CmpStrGT(s1, s2: xtring): boolean;
  { returns TRUE if s1 > s2, FALSE otherwise. }
  var
    min_length,             { minimum length of the two strings }
    i: string_range;        { index into the strings }
    done: boolean;          { TRUE if comparison complete }
begin
  if s1^[0] <= s2^[0] then 
    begin  min_length := ord(s1^[0]);  CmpStrGT := FALSE;  end
  else 
    begin  min_length := ord(s2^[0]);  CmpStrGT := TRUE;  end;

  i := 0;  done := FALSE;
  while (i < min_length) and not done do
    begin
      i := i + 1;
      if s1^[i] < s2^[i] then 
        begin  CmpStrGT := FALSE;  done := TRUE;  end
      else if s1^[i] > s2^[i] then
        begin  CmpStrGT := TRUE;  done := TRUE;  end;
    end;
end { CmpStrGT } ;


function CmpStrEQ(s1, s2: xtring): boolean;
  { returns TRUE if s1 = s2, FALSE otherwise. }
  var
    i: string_range;        { index into the strings }
    done: boolean;          { TRUE if comparison complete }
begin
  CmpStrEQ := FALSE;

  if s2^[0] = s1^[0] then
    begin
      i := 0;  done := FALSE;
      while (i < ord(s1^[0])) and not done do
        begin
          i := i + 1;
          if s1^[i] <> s2^[i] then done := TRUE;
        end;
      if not done then CmpStrEQ := TRUE;
    end;
end { CmpStrEQ } ;


function compare_strings(s1, s2: xtring): compare_type;
  { compare the strings and return the result }
  var
    min_length,             { minimum length of the two strings }
    i: string_range;        { index into the strings }
    result: compare_type;   { result of the comparison }
    still_equal: boolean;   { TRUE if strings are equal to current position }
begin
  if s1^[0] = s2^[0] then
    begin  min_length := ord(s1^[0]);  result := EQ;  end
  else if s1^[0] < s2^[0] then
    begin  min_length := ord(s1^[0]);  result := LT;  end
  else 
    begin  min_length := ord(s2^[0]);  result := GT;  end;

  i := 0;  still_equal := TRUE;
  while (i < min_length) and still_equal do
    begin
      i := i + 1;
      if s1^[i] < s2^[i] then
        begin  result := LT;  still_equal := FALSE;  end
      else if s1^[i] > s2^[i] then
        begin  result := GT;  still_equal := FALSE;  end;
    end;

  compare_strings := result;
end { compare_strings } ;


function add_char_to_string(str: xtring;  ch: char): boolean;
  { add the character to the end of the string.  It is assumed that the
    string has been created with length = MAX_STRING_LENGTH and the 
    current length of the string (STR^[0]) is correct.  Always leave the
    last char of the string empty (for path string closing paren). }
begin
  if ord(str^[0])+1 >= MAX_STRING_LENGTH then
    add_char_to_string := FALSE
  else
    begin
      str^[0] := chr(ord(str^[0]) + 1);  str^[ord(str^[0])] := ch;
      add_char_to_string := TRUE;
    end;
end { add_char_to_string } ;


function add_string_to_string(dest, source: xtring): boolean;
  { add the source string to the end of the destination string.  Return
    FALSE if the destination string length is exceeded. It is assumed that
    the destination string has been created as MAX_STRING_LENGTH long and
    its length can be extended that far.  If the resulting string will be
    too long, copy as much as possible. }
  var
    i: string_range;            { index into the strings }
    source_length,              { length of the source string }
    dest_length: string_range;  { length of the destination string }
begin
  add_string_to_string := TRUE;

  if source <> nullstring then
    begin
      dest_length := ord(dest^[0]);  source_length := ord(source^[0]);
      if source_length + dest_length >= MAX_STRING_LENGTH then
        begin
          add_string_to_string := FALSE;
          source_length := MAX_STRING_LENGTH - dest_length - 1;
        end;

      for i := 1 to source_length do dest^[dest_length+i] := source^[i];

      dest^[0] := chr(dest_length + source_length);
    end;
end { add_string_to_string } ;


function add_quoted_string_to_string(dest, source: xtring): boolean;
  { add the source string, quoted, to the end of the destination string.
    Double quotes occurring inside the string.  Return FALSE if the
    destination string length is exceeded. It is assumed that the
    destination string has been created as MAX_STRING_LENGTH long and its
    length can be extended that far.  If the resulting string will be
    too long, copy as much as possible. }
  var
    i: string_range;            { index into source }
    j: string_range;            { index into dest }
    len: string_range;          { length of source }
    overflow: boolean;          { TRUE iff string overflows }
begin
  i := 0;
  j := ord(dest^[0]);
  len := ord(source^[0]);
  overflow := FALSE;

  if j < MAX_STRING_LENGTH then
    begin
      j := j + 1;
      dest^[j] := OUTPUT_QUOTE_CHAR;
    end;
  
  while (j < MAX_STRING_LENGTH) and (i < len) do
    begin
      i := i + 1;
      j := j + 1;
      dest^[j] := source^[i];
      if source^[i] = OUTPUT_QUOTE_CHAR then
        if j < MAX_STRING_LENGTH then
	  begin
	    j := j + 1;
	    dest^[j] := OUTPUT_QUOTE_CHAR;
	  end;
    end;

  if j < MAX_STRING_LENGTH then
    begin
      j := j + 1;
      dest^[j] := OUTPUT_QUOTE_CHAR;
    end
  else overflow := TRUE;

  dest^[0] := chr(j);
  add_quoted_string_to_string := not overflow;
end { add_quoted_string_to_string } ;


function add_substr_to_string(dest, source: xtring;
                              first, len: string_range): boolean;
  { add the specified substring of source to the end of the destination
    string.  Subrange is len chars long beginning with source^[first].
    Return FALSE if the destination string length is exceeded. 
    It is assumed that the destination string has been created as 
    MAX_STRING_LENGTH long and its length can be extended that far.  
    If the resulting string will be too long, copy as much as possible. }
  var
    i: string_range;            { index into the strings }
    offset: string_range;       { offset to first char (first - 1) }
    source_length,              { length of the source string }
    dest_length: string_range;  { length of the destination string }
begin
  add_substr_to_string := TRUE;

  if len > 0 then
    begin
      offset := first - 1;
      dest_length := ord(dest^[0]);  
      source_length := min(len, max(0, ord(source^[0]) - offset));
      if source_length + dest_length >= MAX_STRING_LENGTH then
        begin
          add_substr_to_string := FALSE;
          source_length := MAX_STRING_LENGTH - dest_length - 1;
        end;

      for i := 1 to source_length do 
        dest^[dest_length + i] := source^[i + offset];

      dest^[0] := chr(dest_length + source_length);
   end;
end { add_substr_to_string } ;


function add_alpha_to_string(dest: xtring; ident: alpha): boolean;
  { append the identifier (alpha) to the end of the destination string.
    It is assumed that the string has been created MAX_STRING_LENGTH long
    and its length can be extended to there.  If the resulting string
    exceeds MAX_STRING_LENGTH (leaving the last character empty), do
    as much as possible and return FALSE.  Delete trailing spaces from the
    alpha. }
  var
    i: id_range;                  { next char of the_alpha to copy in }
    identifier_length: id_range;  { length of the identifier }
    dest_length: string_range;    { length of the destination string }
begin
  identifier_length := alpha_length(ident);

  dest_length := ord(dest^[0]);
  if dest_length + identifier_length >= MAX_STRING_LENGTH then
    begin
      add_alpha_to_string := FALSE;
      identifier_length := MAX_STRING_LENGTH - dest_length - 1;
    end
  else add_alpha_to_string := TRUE;

  for i := 1 to identifier_length do
    dest^[dest_length+i] := ident[i];
  dest^[0] := chr(dest_length + identifier_length);
end { add_alpha_to_string } ;


function add_number_to_string(str: xtring; number: integer): boolean;
  { Append the given number (NUMBER) to the end of the input string (STR).
    If the number is < 0 then append a '-' at the start.  It is assumed that
    the input string has been created with length = MAX_STRING_LENGTH and
    that the length of the string (STR^[0]) is the current length.  Always
    leave the last char of the string empty (for path string closing ')'). }


  procedure build_number(n: natural_number);
    { add the given number to the string }
  begin
    if n > 9 then build_number(n DIV 10);
    if ord(str^[0])+1 >= MAX_STRING_LENGTH then
      add_number_to_string := FALSE
    else
      if not add_char_to_string(str, chr((n mod 10) + ord('0'))) then
        add_number_to_string := FALSE;
  end { build_number } ;


begin { add_number_to_string }
  add_number_to_string := TRUE;

  if number < 0 then
    begin
      number := abs(number);
      if not add_char_to_string(str, '-') then
        add_number_to_string := FALSE;
    end;

  build_number(number);
end { add_number_to_string } ;


function number_to_string(numb: integer): xtring;
  { return string representing the number in decimal }
  var
    temp: xtring;   { for building number }
begin
  create_a_string(temp, MAX_STRING_LENGTH);
  temp^[0] := chr(0);
  if add_number_to_string(temp, numb) then ;
  number_to_string := enter_string(temp);
  temp^[0] := chr(MAX_STRING_LENGTH);
  release_string(temp);
end { number_to_string } ;


function string_to_natural_number(str: xtring): natural_number;
  { convert string containing a decimal natural number into that number }
  const
    RADIX = 10;  { decimal number }
  var
    temp: natural_number;        { value of the function to be returned }
    len: string_range;           { length of str }
    i: string_range;             { index into str }
    ch: char;                    { current char }
    next_digit: 0..9;            { numeric value of current digit }
    trailing_junk: boolean;      { TRUE if chars follow the last digit }
    done: boolean;               { TRUE when done with a loop }
begin
  temp := 0;

  { ignore preceeding blanks }
  len := ord(str^[0]);
  i := 0;  done := FALSE;
  while (i < len) and not done do
    begin
      i := i + 1;
      if str^[i] <> ' ' then done := TRUE;
    end;

  { add up the digits }
  if i > 0 then i := i - 1;  done := FALSE;  trailing_junk := FALSE;
  while (i < len) and not done do 
    begin
      i := i + 1;
      ch := str^[i];
      case ch of
	'0': next_digit := 0;  '1': next_digit := 1;
	'2': next_digit := 2;  '3': next_digit := 3;
	'4': next_digit := 4;  '5': next_digit := 5;
	'6': next_digit := 6;  '7': next_digit := 7;
	'8': next_digit := 8;  '9': next_digit := 9;
	OTHERWISE 
	  begin
	    done := TRUE;
	    trailing_junk := TRUE;
	  end;
      end;
      if not done then 
	if (temp > MAXINT div RADIX) or 
	   ((temp = MAXINT div RADIX) and
	    (next_digit > MAXINT mod RADIX)) then
	  begin  assert(240 { ovf });  done := TRUE;   end
	else
	  begin  temp := RADIX * temp + next_digit;  end;
    end { while } ;
  
  { ignore blanks but report other extraneous trailing junk }
  if trailing_junk then 
    begin
      i := i - 1;  done := FALSE;
      while (i < len) and not done do
	begin
	  i := i + 1;
	  if str^[i] <> ' ' then
	    begin
	      done := TRUE;
	      error(50 { extraneous junk at end of number });
	      error_dump_string(str);
	      error_dump_CRLF;
	    end;
	end;
    end;
  
  string_to_natural_number := temp;
end { string_to_natural_number } ;


function upper_case(str: xtring): xtring;
  { upper case the given string }
  var
    i: string_range;         { index into the string }
    new_string: xtring;      { new string to be created }
begin
  create_a_string(new_string, ord(str^[0]));
  for i := 1 to ord(str^[0]) do new_string^[i] := upshift[str^[i]];
  upper_case := enter_and_release_string(new_string);
end { upper_case } ;


function substring(str : xtring; start,len : string_range): xtring;
  { returns the specified substring of str.  substring starts
    at start and is len chars long.  It will be truncated if 
    start+len-1 > length of str.  Returned string is a string table
    entry. }
  var 
    offset: string_range;      { index offset in str }
    temp: xtring;              { temp for building substring }
    i: string_range;           { index into str and temp }
begin
  if start <= ord(str^[0]) then 
    begin
      offset := start - 1;
      if offset+len > ord(str^[0]) then len := ord(str^[0]) - offset;
      if len > 0 then 
	begin
	  create_a_string(temp, len);
	  for i := 1 to len do temp^[i] := str^[i + offset];
          substring := enter_and_release_string(temp);
	end
      else substring := nullstring;
    end
  else substring := nullstring;
end; {substring}


(**)     { ------- name  utilities ------- }


function alpha_length(*name: alpha): id_range*);
  { find the length of an identifier by scanning for its end }
  var
    i: id_range;         { index into the identifier }
    done: boolean;       { TRUE when end of alpha found }
begin
  i := ID_LENGTH;  done := FALSE;
  while (i > 1) and not done do
    if name[i] <> ' ' then done := TRUE else i := i - 1;

  alpha_length := i;
end { alpha_length } ;


(**)     { ------- create an abbreviation ------- }


function concoct_abbrev(name: xtring): xtring;
  { create an abbreviation from the given name }
  var
    i,                        { index into the created abbreviation }
    left,                     { number chars left in abbreviation }
    pos,                      { index into the returned string }
    len: string_range;        { length of the created abbreviation }
    found: boolean;           { TRUE if vowel found in string }
    temp : char_array;        { temp storage for the new name }
    new_string: xtring;       { abbreviation string to be returned }
begin
  { step 1; throw out garbage }

  len := 0;
  for i := 1 to ord(name^[0]) do
    if isupper[name^[i]] or isdigit[name^[i]] then
      begin  len := len + 1;  temp[len] := name^[i];  end;

  { step 2: if nothing left, add an 'A' }

  if len = 0 then
    begin  len := 1;  temp[len] := 'A';  end;

  { step 3; if > 3 characters, remove vowels till 3 or less }

  left := len;  found := TRUE;
  while (left > 3) AND found do
    begin
      i := 1;  found := FALSE;
      while (i <= len) and (not found) do
        if temp[i] IN ['A', 'E', 'I', 'O', 'U'] then
          begin  temp[i] := ' ';  left := left - 1;  found := TRUE;  end
        else i := i + 1;
    end;

  { step 4: if still more than 3, take the first 3 }

  i := len;
  while (i > 1) and (left > 3) do
    begin
      if temp[i] <> ' ' then
        begin  temp[i] := ' ';  left := left - 1;  end;
      i := i - 1;
    end;

  { step 5: create the string and copy }

  create_a_string(new_string, left);  pos := 0;
  for i := 1 to len do
    if temp[i] <> ' ' then
      begin  pos := pos + 1;  new_string^[pos] := temp[i];  end;
  if pos <> left then assert(39 { no way Jose });

  concoct_abbrev := enter_and_release_string(new_string);
end { concoct_abbrev } ;


(**)     { ------- AVL routines ---------------------------- }


{ ../avl/compare.p is included in compiler.p so that it follows
  all of the procedures it uses. }


(**){--------------- NEW & RELEASE for AVL objects --------}

{---------------------------------------------------------------}
{ All new and release routines for avl objects are simple news  }
{ and releases.  They do not insert or delete the objects from  }
{ lists (other than, of course, the free list).  Release        }
{ routines always return NIL.                                   }
{---------------------------------------------------------------}

procedure new_avl(var avlp: avl_ptr;  tag_val: avl_type);
  { new an avl and initialize for the appropriate type.
    The free list is threaded by left_child. }
begin
  if free_avls <> NIL then
    begin  
      avlp := free_avls;
      free_avls := free_avls^.left_child;  
    end
  else
    begin
      new(avlp);
      increment_heap_count(HEAP_AVL, 3*POINTER_SIZE+ENUM_SIZE


                                                              );
    end;
  with avlp^ do
    begin
      left_child := NIL;  right_child := NIL;
      balance_factor := EVEN_BF;


      case tag_val of
        AVL_FIRST: object.dummy_first := 0;
        AVL_COMPLEMENTED_ACTUAL: object.complemented_actual := NIL;
        AVL_INVOKE: object.invoke := NIL;
	AVL_CONTEXT: object.context := NIL;
	AVL_CONTEXT_NUMBER: object.context_number := NIL;
	AVL_STRING: object.str := nullstring;
	AVL_COMPERR_DRAWING: object.cerr_drawing := NIL;
	AVL_COMPERR_MODULE: object.cerr_module := NIL;
        AVL_LAST: object.dummy_last := 0;
	OTHERWISE
	  begin
	    assert(244 { unknown AVL type });
	    object.complemented_actual := NIL;
	  end;
      end;
    end;
end { new_avl } ;


procedure release_avl(var avlp: avl_ptr);
  { Release the avl and return NIL }
begin
  if avlp <> NIL then
    begin
      avlp^.left_child := free_avls;  free_avls := avlp;  avlp := NIL;
    end;
end { release_avl } ;


procedure release_entire_avl_tree(var root: avl_ptr);
  { release all avl elements in the tree and return NIL }
begin
  if root <> NIL then
    begin
      if root^.left_child <> NIL then
        release_entire_avl_tree(root^.left_child);
      if root^.right_child <> NIL then
        release_entire_avl_tree(root^.right_child);
      root^.left_child := free_avls;  free_avls := root;  root := NIL;
    end;
end { release_entire_avl_tree } ;


procedure dump_avl_object(var f: textfile;
                          obj: avl_object_ptr; kind: avl_type);
  { report the key of the object }
begin
  case kind of
    AVL_INVOKE:
      if obj.invoke = NIL then writeln(f, '<NIL>')
      else
        begin
          writestring(f, obj.invoke^.path);
	  write(f, ' ');
	  writestring(f, obj.invoke^.macro_name);
          writeln(f);
        end;
    OTHERWISE writeln(f, '***  UNKOWN AVL TYPE  ***');
  end;
end { dump_avl_object } ;


procedure dump_avl_tree(var f: textfile; root: avl_ptr; kind: avl_type);
  { dump the tree inorder (including level and balance factor) to f }
  var
    level: natural_number;    { current height of the tree }


  procedure dump_avl_node(node: avl_ptr);
    { dump the node }
  begin
    if node <> NIL then
      begin
        level := level + 1;
        dump_avl_node(node^.left_child);

        write(outfile, '  ', level:2, ' ');
        case node^.balance_factor of
          LEFT_HEAVY_BF: write(f, 'LH');
          EVEN_BF: write(f, 'EV');
          RIGHT_HEAVY_BF: write(f, 'RH');
        end;
        write(f, ' ');
	dump_avl_object(f, node^.object, kind);

      dump_avl_node(node^.right_child);
      level := level - 1;
    end;
          
  end { dump_avl_node } ;


begin
  level := 0;
  writeln(f, '----  AVL tree (', ord(kind):1, ') ----');
  dump_avl_node(root);
  writeln(f, '---- end of tree ----');
end { dump_avl_tree } ;


function avl_insert(obj: avl_object_ptr;  var root: avl_ptr;
                    kind: avl_type): avl_ptr;
  { insert obj into the tree (unless already there).  Return a pointer
    to its entry in the tree }
  label
    90; { return }
    
  { a direction table is used to keep track of which way we went (left
    or right) at each level of the tree starting either with the root
    or the last node having a non-zero balance factor.
    The table is long enough to handle a tree up to 32 levels deep, which
    would contain as many elements than there are addresses in a 32 bit
    address space.
    The reason this table exists is to avoid having to redo the sometimes
    expensive avl_compare operations when rebalancing the tree. }

  const
    LAST_DIRECTION_TABLE_INDEX = 32;
  type
    direction = (GO_LEFT, GO_RIGHT);
    direction_range = 1..LAST_DIRECTION_TABLE_INDEX;
    direction_index_range = 0..LAST_DIRECTION_TABLE_INDEX;
    direction_table = array[direction_range] of direction;
  var
    last_non_zero: avl_ptr;       { lowest node above insertion with BF <> 0 }
    parent_of_LNZ: avl_ptr;       { parent of past_non_zero }
    current: avl_ptr;             { current node }
    parent: avl_ptr;              { parent of current }
    directions: direction_table;  { road map (see above) }
    direction_index: 
      direction_index_range;      { index into directions }
    newnode: avl_ptr;             { inserted node }
    current_child: avl_ptr;       { interesting child of current }
begin
  if debug_28 then
    begin
      writeln(Outfile, '-- avl_insert (', ord(kind):1, ') --');
      write(Outfile, '  insert: ');
      dump_avl_object(Outfile, obj, kind);
    end;
      
      
  last_non_zero := NIL;  parent_of_LNZ := NIL;
  current := root;  parent := NIL;
  direction_index := 0;

  { Locate insertion point }

  while current <> NIL do
    begin
      direction_index := direction_index + 1;
      if current^.balance_factor <> EVEN_BF then
        begin
	  last_non_zero := current;  parent_of_LNZ := parent;
          direction_index := 1;
	end;
      parent := current;
      case avl_compare(obj, current^.object, kind) of
        LT: 
	  begin
	    current := current^.left_child;
	    directions[direction_index] := GO_LEFT;
	  end;
	GT: 
	  begin
	    current := current^.right_child;
	    directions[direction_index] := GO_RIGHT;
	  end;
	EQ:
	  begin
	    avl_insert := current;
	    if debug_28 then
	      writeln(Outfile, '-- exit avl_insert (found) --');
	    goto 90 { return } ;
	  end;
      end;
    end;

  { insert new element }

  new_avl(newnode, kind);  newnode^.object := obj;
  avl_insert := newnode;
  
  if root = NIL then
    begin
      root := newnode;
      if debug_28 then 
        begin
	  writeln(Outfile, 'First node');
	  dump_avl_tree(Outfile, root, kind);
	  writeln(Outfile, '-- exit avl_insert --');
	end;
      goto 90 { return } ;
    end;
  if directions[direction_index] = GO_LEFT then
    parent^.left_child := newnode
  else parent^.right_child := newnode;
  
  { adjust balance factors from last non-zero BF node - all nodes
    between this node and newnode formerlay had an even balance factor. }
  
  if last_non_zero = NIL then
      { all nodes down to newnode were evenly balanced }
    if directions[1] = GO_LEFT then
      begin
        root^.balance_factor := LEFT_HEAVY_BF;
        current := root^.left_child;
      end
    else
      begin
        root^.balance_factor := RIGHT_HEAVY_BF;
	current := root^.right_child;
      end
  else 
    if directions[1] = GO_LEFT then 
      current := last_non_zero^.left_child
    else current := last_non_zero^.right_child;

  direction_index := 1;
  while current <> newnode do
    begin
      direction_index := direction_index + 1;
      
      if directions[direction_index] = GO_LEFT then
        begin
          current^.balance_factor := LEFT_HEAVY_BF;
          current := current^.left_child;
        end
      else
        begin
          current^.balance_factor := RIGHT_HEAVY_BF;
          current := current^.right_child;
        end;
    end;
    
  if last_non_zero = NIL then 
    begin
      if debug_28 then
        begin
	  writeln(Outfile, 'All path nodes were evenly balanced');
	  dump_avl_tree(Outfile, root, kind);
	  writeln(Outfile, '-- exit avl_insert --');
	end;
      goto 90 { return } ;  { balancing done }
    end;
  
  if directions[1] = GO_LEFT then
    begin
      if last_non_zero^.balance_factor = RIGHT_HEAVY_BF then
        begin
	  last_non_zero^.balance_factor := EVEN_BF;
	  if debug_28 then
	    begin
	      writeln(Outfile, 'No rotation (Left)');
	      dump_avl_tree(Outfile, root, kind);
	      writeln(Outfile, '-- exit avl_insert --');
	    end;
	  goto 90 { return } ;
	end;
      current := last_non_zero^.left_child;
      if current^.balance_factor = LEFT_HEAVY_BF then
        begin
	  { LL rotation }

	  if debug_28 then writeln(Outfile, 'LL rotation');
          last_non_zero^.left_child := current^.right_child;
	  current^.right_child := last_non_zero;
	  last_non_zero^.balance_factor := EVEN_BF;
	  current^.balance_factor := EVEN_BF;
	end
      else
        begin
	  { LR rotation }
          
	  if debug_28 then writeln(Outfile, 'LR rotation');
          current_child := current^.right_child;
	  current^.right_child := current_child^.left_child;
	  last_non_zero^.left_child := current_child^.right_child;
	  current_child^.left_child := current;
	  current_child^.right_child := last_non_zero;
	  case current_child^.balance_factor of
	    LEFT_HEAVY_BF:
	      begin
	        last_non_zero^.balance_factor := RIGHT_HEAVY_BF;
	        current^.balance_factor := EVEN_BF;
	      end;
	    RIGHT_HEAVY_BF:
	      begin
		last_non_zero^.balance_factor := EVEN_BF;
	        current^.balance_factor := LEFT_HEAVY_BF;
	      end;
	    EVEN_BF:
	      begin
	        last_non_zero^.balance_factor := EVEN_BF;
	        current^.balance_factor := EVEN_BF;
	      end;
	  end { case } ;
	  current_child^.balance_factor := EVEN_BF;
	  current := current_child;  { current is root of balanced subtree }
	end;
    end { left side checking and rotations }
  else
    begin { directions[1] = GO_RIGHT }
      if last_non_zero^.balance_factor = LEFT_HEAVY_BF then
        begin
	  last_non_zero^.balance_factor := EVEN_BF;
	  if debug_28 then
	    begin
	      writeln(Outfile, 'No rotation (Right)');
	      dump_avl_tree(Outfile, root, kind);
	      writeln(Outfile, '-- exit avl_insert --');
	    end;
	  goto 90 { return } ;
	end;
      current := last_non_zero^.right_child;
      if current^.balance_factor = RIGHT_HEAVY_BF then
        begin
	  { RR rotation }

	  if debug_28 then writeln(Outfile, 'RR rotation');
          last_non_zero^.right_child := current^.left_child;
	  current^.left_child := last_non_zero;
	  last_non_zero^.balance_factor := EVEN_BF;
	  current^.balance_factor := EVEN_BF;
	end
      else
        begin
	  { RL rotation }
          
	  if debug_28 then writeln(Outfile, 'RL rotation');
          current_child := current^.left_child;
	  current^.left_child := current_child^.right_child;
	  last_non_zero^.right_child := current_child^.left_child;
	  current_child^.right_child := current;
	  current_child^.left_child := last_non_zero;
	  case current_child^.balance_factor of
	    RIGHT_HEAVY_BF:
	      begin
	        last_non_zero^.balance_factor := LEFT_HEAVY_BF;
	        current^.balance_factor := EVEN_BF;
	      end;
	    LEFT_HEAVY_BF:
	      begin
		last_non_zero^.balance_factor := EVEN_BF;
	        current^.balance_factor := RIGHT_HEAVY_BF;
	      end;
	    EVEN_BF:
	      begin
	        last_non_zero^.balance_factor := EVEN_BF;
	        current^.balance_factor := EVEN_BF;
	      end;
	  end { case } ;
	  current_child^.balance_factor := EVEN_BF;
	  current := current_child;  { current is root of balanced subtree }
	end;
    end { right side checking and rotations } ;

  { re-attach balanced subtree rooted by current (formerly rooted by
    last_non_zero }
    
  if parent_of_LNZ = NIL then root := current
  else if parent_of_LNZ^.left_child = last_non_zero then
    parent_of_LNZ^.left_child := current
  else
    parent_of_LNZ^.right_child := current;

  if debug_28 then
    begin
      dump_avl_tree(Outfile, root, kind);
      writeln(Outfile, '-- exit avl_insert --');
    end;
90:  
end { avl_insert } ;


function avl_find(obj: avl_object_ptr;  root: avl_ptr;
                  kind: avl_type): avl_ptr;
  { find object in the tree and return a pointer to its entry.  If
    not found, return NIL }
  var
    current: avl_ptr;             { current node }
    found: boolean;               { TRUE iff found }
begin
  current := root;  found := FALSE;

  while not found and (current <> NIL) do
    case avl_compare(obj, current^.object, kind) of
      LT: current := current^.left_child;
      GT: current := current^.right_child;
      EQ: found := TRUE;
    end;

  avl_find := current;  
end { avl_insert } ;


{ The inorder iterator maintains a stack for each tree being iterated.
  avls are used because they are already part of the package.  The
  stack is threaded though the left_child field.  The tree member
  refered to by the stack entry is indicated by the right_child field. }


procedure avl_push(item: avl_ptr; var stack: avl_ptr);
  var
    stack_item: avl_ptr;
begin
  new_avl(stack_item, AVL_FIRST);
  stack_item^.right_child := item;
  stack_item^.left_child := stack;
  stack :=stack_item;
end { avl_push } ;


procedure avl_pop(var stack: avl_ptr);
  var
   item: avl_ptr;
begin
  item := stack;
  stack := stack^.left_child;
  release_avl(item);
end { avl_pop } ;

  
function avl_inorder_init(root: avl_ptr; var stack: avl_ptr): avl_ptr;
  var
    item: avl_ptr;
begin
  stack := NIL;
  item := root;
  while item <> NIL do
    begin
      avl_push(item, stack);
      item := item^.left_child;
    end;
  if stack <> NIL then item := stack^.right_child;
  avl_inorder_init := item;
end { avl_inorder_init } ;


function avl_inorder(var stack: avl_ptr): avl_ptr;
  var
    item: avl_ptr;
begin
  if stack = NIL then item := NIL
  else
    begin
      item := stack^.right_child;
      avl_pop(stack);
      item := item^.right_child;
      while item <> NIL do
        begin
	  avl_push(item, stack);
	  item := item^.left_child;
	end;
      if stack <> NIL then item := stack^.right_child;
    end;
  avl_inorder := item;
end { avl_inorder } ;


(**)     { ------- continuation char output routines ------- }


   (********************************************************************)
   (*                                                                  *)
   (*  These routines are used for controlling output to a SCALD       *)
   (*  interface file.  They check to make sure that no line exceeds   *)
   (*  MAX_OUTPUT_FILE_LENGTH number of characters.  If it does, a     *)
   (*  SCALD continuation character is output (CONTINUATION_CHAR) and  *)
   (*  the line is continued on the next line.                         *)
   (*                                                                  *)
   (********************************************************************)


procedure init_output_continue;
  { set up the output state variables for continuation output }
begin
  column := 0;
end { init_output_continue } ;


(**) 
{----------------- Get command line arguments ---------------------------}
{ These interfaces provide  1 like access to command line arguments.
  The idea is to map whatever command line argument access exists on 
  the host to this format.

  sargc returns the number of command line arguments (including 1 for
  the program name).

  sargv(n,str) returns the nth argument as a xtring which has been
  entered into the string hash table.

  sargv(0,str) returns the program name. (but see NOTE)
  sargv(1,str) returns the first argument following the program name,
  etc.  
  (The above is the 1 convention - not the SVS convention)
  sargv returns nullstring if n >= sargc.  

  NOTE: The program name return is actually only implemented for
  the SVS PASCAL (1) version.  On the 370 and VAX versions
  sargv(0,str) returns nullstring (although it is still counted
  in arriving at the value of sargc.)

  init_cli_arg_structures exists to initialize the global scratch
  structures used by these routines.                                    }
{-----------------------------------------------------------------------}


function sargc : integer;
  { return command argument count (including 0th argument) }
begin
  sargc := 0 ; { default for unimplemented hosts }

  sargc := argc; 


end; {sargc}


procedure sargv(which_arg : cli_arg_range; var arg : xtring);
  { sets arg to the indicated argument. }
var 
  i: integer;           { index into SVS argv }
  j,len: string_range;  { length of and index into SVS argv[i]^ }
  temp: xtring;

  buf: packed array[1..MAX_STRING_LENGTH] of char;

  done: boolean;
begin
  if which_arg < sargc then
    begin


      argv(which_arg, buf);
      len := MAX_STRING_LENGTH;  done := FALSE;
      while (len > 0) and not done do
        if buf[len] = ' ' then len := len - 1
                          else done := TRUE;


      temp := nullstring;
      create_a_string(temp,len);


      for j := 1 to len do temp^[j] := buf[j];


      arg := enter_and_release_string(temp);


    end
  else arg := nullstring;
end; {sargv}
    

procedure init_cli_arg_structures;
  { initializes the global variables used by sargv and sargc.
    On 370 and VAX, they are initialized to hold the command line
    arguments.  On 1 and unimplemented machines they are 
    nulled.                                                        }


  var
    i: cli_arg_index;
begin
  cli_arg_last := 0;
  for i := 0 to MAX_CLI_ARG_NUMBER do cli_arg_array[i] := nullstring;

end { init_cli_arg_structures };


(**)     { ------- other utilities ------- }


procedure disp_line(message: message_type);
  { write a message and a pointer to the output file }
  var
    width: string_range;    { position to place circumflex }
begin
  if line_pos > 0 then  width := line_pos  else  width := 1;
  writeln(outfile, '^':width, message:message_length+4);
end { disp_line } ;


procedure output_configuration(var f: textfile; indent: natural_number);
  { output all configuration to the specified file.  Indentation can be
    specified. }
  var
    config_index: configure_types;       { index into configuration table }
    syntax_index: signal_syntax_range;   { index into syntax table }


  procedure dump_char(ch: char);
    { output the character;  print NULL if null }
  begin
    if ch = chr(255) then write(f, '''''') else write(f, '''', ch, '''');
  end { dump_char } ;


begin { output_configuration }
  { output signal syntax order }

  if indent > 0 then write(f, ' ':indent);

  write(f, 'SYNTAX = ');

  for syntax_index := 1 to SYNTAX_TABLE_SIZE do
    if signal_syntax_table[syntax_index] <> NULL_SPECIFIER then
      begin
        write(f, '<');
        writealpha(f, syntax_specifier_names[
                                    signal_syntax_table[syntax_index]]^.name);
        write(f, '> ')
      end;
  writeln(f, ';');

  { output the configurable portions of the signal syntax }

  for config_index := succ(FIRST_CONFIGURE_SPECIFIER) to
                                             pred(LAST_CONFIGURE_SPECIFIER) do
    begin
      if indent > 0 then write(f, ' ':indent);

      print_alpha(f, configure_specifiers[config_index]^.name);

      write(f, ' = ');

      case config_index of
        CONFIGURE_SUBRANGE:
            if subrangesy = COLON then write(f, ''':''')
                                  else write(f, '''..''');

        CONFIGURE_BIT_ORDERING:
            if left_to_right then write(f, 'LEFT_TO_RIGHT')
                             else write(f, 'RIGHT_TO_LEFT');

        CONFIGURE_LOW_ASSERTED:
            dump_char(signal_is_asserted_low_char);

        CONFIGURE_HIGH_ASSERTED:
            dump_char(signal_is_asserted_high_char);

        CONFIGURE_NEGATION:
            dump_char(signal_negation_char);

        CONFIGURE_NAME_PREFIX:
{           dump_char(name_property_prefix_char); }
            write(f, '''!''');

        CONFIGURE_GENERAL_PREFIX:
            dump_char(general_property_prefix_char);

        CONFIGURE_CONCATENATION:
            write(f, ''':''');
      end { case } ;

      writeln(f, ';');
    end;
end { output_configuration } ;


procedure dump_command_line_arguments(var f: textfile);
  { report command line results to f }
  var
    i: natural_number;       { current arg number }
    arg: xtring;             { current arg }
begin
  writeln(outfile, 'Command line arguments:');
  write(outfile, '   ');
  for i := 0 to sargc - 1 do 
    begin
      sargv(i, arg);
      write(f, ' ');  writestring(f, arg);
    end;
  writeln(outfile);
  
  if COMMAND_specified_in_command_line then
    begin
      write(outfile, '    command: ');
      writealpha(outfile, command_value[command]^.name);
      if command = COMPERR_COMMAND then
        begin
	  write(Outfile, ' Severity: ');
	  case specified_severity of
	    NO_SEVERITY: write(Outfile, ' ALL');
	    WARNING_SEVERITY: write(Outfile, ' WARNING');
	    OVERSIGHT_SEVERITY: write(Outfile, ' OVERSIGHT');
	    ERROR_SEVERITY: write(Outfile, ' ERROR');
	    OTHERWISE write(Outfile, ' ???');
	  end;
	end ;
      writeln(Outfile);
    end;
  if ROOT_specified_in_command_line then
    begin
      write(Outfile, '    root_drawing: ');
      writestring(Outfile, root_macro_name);
      writeln(Outfile);
    end;
  if TYPE_specified_in_command_line then
    begin
      write(Outfile, '    compile: ');
      writealpha(Outfile, specified_compile_type^.name);
      writeln(Outfile);
    end;
  if CMPDRAW_specified_in_command_line then
    writeln(Outfile, '    CmpDraw specified');
  if DESIGN_specified_in_command_line then
    writeln(Outfile, '    Design specified');
  if CONTEXT_specified_in_command_line then
    writeln(Outfile, '    context: specified!!! (but not used)');
end { dump_command_line_arguments } ;


(**)     { ------- error environment stack ------- }


procedure init_error_info;
  { initialize the error environment variables }
begin
  current_file_name := nullstring;
  current_macro_def := NIL;
  current_page := 0;
  current_body_node := NIL;
  current_body_name := nullstring;
  current_path_prop := nullstring;
  current_property_name := null_name;
  current_property_value := nullstring;
end { init_error_info } ;


procedure push_error_info;
  { push the current parse environment onto the stack and create a new one }
  var
    current: environment_ptr;     { save space for current environment }
begin
  if free_environments = NIL then
    begin
      new(current);
      increment_heap_count(HEAP_ENVIRONMENT_ENTRY, 4*POINTER_SIZE+INT_SIZE);
    end
  else
    begin
      current := free_environments;  free_environments := current^.next;
    end;

  with current^ do
    begin
      next := environment_stack;
      environment_stack := current;

      file_name := current_file_name;
      macro := current_macro_def;
      page_number := current_page;
      body_node := current_body_node;
      body_name := current_body_name;
      path_name := current_path_prop;
      property_name := current_property_name;
      property_value := current_property_value;
    end;
end { 
push_error_info } ;


procedure pop_error_info;
  { pop the old parse environment from the stack }
  var
    next: environment_ptr;    { next in the environment stack }
begin
  if environment_stack = NIL then assert(161 { parse environment underflow })
  else
    begin
      with environment_stack^ do
        begin
          current_file_name := file_name;
          current_macro_def := macro;
          current_page := page_number;
          current_body_node := body_node;
          current_body_name := body_name;
          current_path_prop := path_name;
          current_property_name := property_name;
          current_property_value := property_value;
        end;

      next := environment_stack^.next;
      environment_stack^.next := free_environments;
      free_environments := environment_stack;
      environment_stack := next;
    end;
end { pop_error_info } ;


(**)     { ------- error output routines ------- }


procedure error_dump_CRLF;
  { print the CRLF to the appropriate files }
begin
  if ok_to_print_error then
    if PrintCmpLst then writeln(CmpLst) else writeln(monitor);

  writeln(CmpLog);
  if debugging then writeln(outfile);
end { error_dump_CRLF } ;


procedure error_dump_indent(indentation: natural_number);
  { outputs a specified number of spaces to the error files.  If
    printing a CmpLst, then 2 extra spaces are printed to
    CmpLog (as PrintCmpLst implies that we are in the process of 
    printing a page and error messages are to be indented under the
    page heading). }
begin
  if ok_to_print_error then
    if PrintCmpLst then write(CmpLst, ' ':indentation)
                   else write(monitor, ' ':indentation);

  if PrintCmpLst then write(CmpLog, ' ':indentation+2)
                else write(CmpLog, ' ':indentation);

  if debugging then write(outfile, ' ':indentation);
end { error_dump_indent } ;


procedure error_dump_char(ch: char);
  { output a character to the error files }
begin
  if ok_to_print_error then
    if PrintCmpLst then write(CmpLst, ch) else write(monitor, ch);

  write(CmpLog, ch);

  if debugging then write(outfile, ch);
end { error_dump_char } ;


procedure error_dump_integer(*int: integer*);
  { print the integer on the error files }
begin
  if ok_to_print_error then
    if PrintCmpLst then write(CmpLst, int:1) else write(monitor, int:1);

  write(CmpLog, int:1);

  if debugging then write(outfile, int:1);
end { error_dump_integer } ;


procedure error_dump_alpha(data: alpha);
  { print an alpha to the error files }
begin
  if ok_to_print_error then
    if PrintCmpLst then writealpha(CmpLst,data) else writealpha(monitor,data);

  writealpha(CmpLog, data);

  if debugging then writealpha(outfile, data);
end { error_dump_alpha } ;


procedure error_dump_line(data: error_message);
  { indented and CRLFed without trailing blanks (but at least one char will
    be written). }
  var
    len: 1..ERROR_MESSAGE_LENGTH;  
    done: boolean;
begin
  error_dump_indent(indent);

  len := ERROR_MESSAGE_LENGTH;  done := FALSE;
  while (len > 1) and not done do
    if data[len] = ' ' then len := len - 1
                       else done := TRUE;

  if ok_to_print_error then
    if PrintCmpLst then writeln(CmpLst,data:len) 
		   else writeln(monitor,data:len);

  writeln(CmpLog, data:len);

  if debugging then writeln(outfile, data:len);
end { error_dump_line } ;


procedure error_dump_string(*str: xtring*);
  { print the given string to the error files }
begin
  if ok_to_print_error then
    if PrintCmpLst then print_string(CmpLst, str)
    else print_string(monitor, str);

  print_string(CmpLog, str);

  if debugging then print_string(outfile, str);
end { error_dump_string } ;


procedure error_dump_property(name: name_ptr;  text: xtring);
  { print the property name and the property value (if the value <> NULL) }
begin
  error_dump_indent(indent);
  error_dump_alpha('Property name=  ');
  error_dump_alpha(name^.name);
  error_dump_CRLF;

  if text <> nullstring then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Property value= ');
      error_dump_string(text);
      error_dump_CRLF;
    end;
end { error_dump_property } ;


procedure error_dump_expanded_value(val: xtring);
  { dump the string to the error files labled "expanded value". }
begin
  error_dump_indent(indent);
  error_dump_alpha('Expanded value= ');
  error_dump_string(val);
  error_dump_CRLF;
end { error_dump_expanded_value } ;


procedure error_dump_ioresult(iores: integer);
  { output an ioresult error message. Do not print anything if
    iores = 0 (no error). }
begin
  if iores <> 0 then
    begin
      error_dump_indent(indent);
      if ok_to_print_error then
        if PrintCmpLst then write_ioresult(CmpLst, iores)
                       else write_ioresult(Monitor, iores);
      write_ioresult(CmpLog, iores);
      if debugging then write_ioresult(Outfile, iores);
      error_dump_CRLF;
    end;
end { error_dump_ioresult } ;


procedure error_dump_file_name(name: xtring);
  { dump the name of the file to the error files }
begin
  if (name <> NIL) then
    begin
      error_dump_indent(indent);
      error_dump_alpha('File name=      ');
      error_dump_string(name);
      error_dump_CRLF;
    end;
end { error_dump_file_name } ;


procedure error_dump_directory_name(name: xtring);
  { dump the name of the directory to the error files }
begin
  if (name <> NIL) then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Directory name= ');
      error_dump_string(name);
      error_dump_CRLF;
    end;
end { error_dump_file_name } ;


procedure error_dump_alpha_file_name(file_name: alpha);
  { dump the name of the file to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('File name=      ');
  error_dump_alpha(file_name);
  error_dump_CRLF;
end { error_dump_alpha_file_name } ;


procedure error_dump_text_macro(name: name_ptr);
  { dump the text macro name to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('Text macro=     ');
  error_dump_alpha(name^.name);
  error_dump_CRLF;

  if PrintCmpErr then
    begin
      write(CmpErr, '  property = ');
      writealpha(CmpErr, name^.name);
      writeln(CmpErr, ';');
    end;
end { error_dump_text_macro } ;


procedure error_dump_macro_def(macro: macro_def_ptr);
  { dump the macro name and its version to the error files }
begin
  if (macro <> NIL) and (macro <> root_macro_def) then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Drawing name=   ');
      error_dump_string(macro^.macro_name);
      if macro^.version <> NIL then
        if (er_extension(macro^.version) <> NIL) then
	  begin
	    error_dump_char('.');
	    error_dump_string(er_extension(macro^.version));
	    error_dump_char('.');
	    error_dump_integer(er_version(macro^.version));
	    if current_page <> 0 then
	      begin
		error_dump_char('.');
		error_dump_integer(current_page);
	      end;
	  end
        else if (er_special(macro^.version) <> NIL) then
	  begin
	    error_dump_CRLF;
	    error_dump_indent(indent);
	    error_dump_alpha('Special file=   ');
	    error_dump_string(er_special(macro^.version));
	  end;
      error_dump_CRLF;
    end;
end { error_dump_macro_def } ;


procedure error_dump_macro_name(name: xtring; version: natural_number);
  { dump the macro name and its version (if <> 0) to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('Drawing name=   ');
  if version = 0 then
    error_dump_string(name)
  else
    begin
      error_dump_string(name);
      error_dump_alpha('.LOGIC.         ');
      error_dump_integer(version);
    end;
  error_dump_CRLF;
end { error_dump_macro_name } ;


procedure error_dump_body_name(body_name: xtring);
  { dump the body name to the error files along with the PATH property }
begin
  if body_name <> nullstring then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Name of body=   ');
      error_dump_string(body_name);
      if current_path_prop <> nullstring then
        begin
          error_dump_char(' ');
          error_dump_alpha('(path prop=     ');
          error_dump_string(current_path_prop);
          error_dump_char(')');
        end;
      error_dump_CRLF;

      if PrintCmpErr then
        if ok_to_print_error then
          begin
            write(CmpErr, '  body = ');
            writestring(CmpErr, body_name);
            writeln(CmpErr, ';');
            if current_path_prop <> nullstring then
              begin
                write(CmpErr, '  path = ');
                writestring(CmpErr, current_path_prop);  writeln(CmpErr, ';');
              end;
          end;
    end;
end { error_dump_body_name } ;


procedure error_dump_body_node(body: mtree_node_ptr);
  { dump the body name to the error files along with the PATH property }
begin
  if body <> NIL then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Name of body=   ');
      error_dump_string(body^.macro_name);
      if body^.called_by <> NIL then
        begin
          error_dump_char(' ');
          error_dump_alpha('(path prop=     ');
          error_dump_string(body^.called_by^.path);
          error_dump_char(')');
        end;
      error_dump_CRLF;
    end;
end { error_dump_body_node } ;


procedure error_dump_page_number(page_number: page_range);
  { dump the current page number to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('Page=           ');
  error_dump_integer(page_number);
  error_dump_CRLF;
end { error_dump_current_page_number } ;


procedure error_dump_current_parse_environment;
  { dump the current parse environment }
begin
  if current_file_name <> nullstring then
    error_dump_file_name(current_file_name);

  if (current_macro_def <> NIL) then error_dump_macro_def(current_macro_def);

  if current_body_node <> NIL then error_dump_body_node(current_body_node)
  else
    begin
      if (current_macro_def = NIL) and (current_page <> 0) then
        error_dump_page_number(current_page);

      if current_body_name <> nullstring then
        error_dump_body_name(current_body_name);
    end;

  if current_property_name <> null_name then
    error_dump_property(current_property_name, current_property_value);
end { error_dump_current_parse_environment } ;


procedure error_dump_signal_name_string(name: xtring);
  { dump the signal name (clear text) to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('Signal name=    ');
  error_dump_string(name);
  error_dump_CRLF;
end { error_dump_signal_name_string } ;


procedure error_dump_pin_name_string(name: xtring);
  { dump the pin name (clear text) to the error files }
begin
  error_dump_indent(indent);
  error_dump_alpha('Pin name=       ');
  error_dump_string(name);
  error_dump_CRLF;
end { error_dump_pin_name_string } ;


(**)     { ------- general utility routines ------- }


function check_calculation(var val1: integer; val2: integer; 
                           is_sub: boolean): integer;
  { check to see that the calculation specified (val1 := val1+val2; or
    val1 := val1-val2;  does not overflow.  Return the result. }
begin
  if is_sub then
    if val2 > -MAXINT-1 then val2 := -val2
    else if val1 = MAXINT then begin error(24 { ovf });  val2 := 0;  end
         else val1 := val1 + 1;
  if val2 < 0 then
    begin
      if (val1 < 0) and (val1 < -MAXINT-1-val2) then 
        begin  error(24 { ovf });  val2 := 0;  end
    end
  else if (val1 > 0) and (val1 > MAXINT-val2) then
    begin  error(24 { ovf });  val2 := 0;  end;
  check_calculation := val1 + val2;
end { check_calculation } ;


(**)     { ------- memory usage utilities ------- }


  procedure print_histograms(var f: textfile);
    { print a histogram of each of the various tables }
    var
      i: natural_number;           { index into the tables }
      SEP: signal_entry_ptr;       { signal table element }
      NP: name_ptr;                { name table element }
      HSP: hash_string_ptr;        { hash string table element }
      num_elements,                { total number of elements in one bucket }
      max_num_entries,             { maximum entries in any one bucket }
      min_num_entries,             { minimum entries in any one bucket }
      total_entries: natural_number; { total number of entries in the table }
  begin
    if debug_20 then writeln(outfile, ' enter print_histograms');
    if signal_histogram IN histograms then
      begin
        writeln(f);
        writeln(f, '++++++++ Histogram of the signal table ++++++++');
        writeln(f);
        total_entries := 0;  min_num_entries := maxint;  max_num_entries := 0;
        for i := 0 to SIGNAL_TABLE_SIZE do
          begin
            num_elements := 0;  SEP := signal_table[i];
            write(f, i:3, ': ');
            while SEP <> NIL do
              begin
                num_elements := num_elements + 1;
                write(f, '*');
                SEP := SEP^.next;
              end;
            writeln(f);
            if num_elements > max_num_entries then
              max_num_entries := num_elements;
            if num_elements < min_num_entries then
              min_num_entries := num_elements;
            total_entries := total_entries + num_elements;
          end;
        writeln(f);
        writeln(f, 'Total number of entries: ', total_entries:1);
        writeln(f,'Cell lengths: ',min_num_entries:1,'..',max_num_entries:1);
        writeln(f);
      end;

    if name_table_histogram IN histograms then
      begin
        writeln(f);
        writeln(f, '++++++++ Histogram of the identifier name table ++++++++');
        writeln(f);
        total_entries := 0;  min_num_entries := maxint;  max_num_entries := 0;
        for i := 0 to NAME_TABLE_SIZE do
          begin
            num_elements := 0;  NP := name_table[i];
            write(f, i:3, ': ');
            while NP <> NIL do
              begin
                num_elements := num_elements + 1;
                write(f, '*');
                NP := NP^.next;
              end;
            writeln(f);
            if num_elements > max_num_entries then
              max_num_entries := num_elements;
            if num_elements < min_num_entries then
              min_num_entries := num_elements;
            total_entries := total_entries + num_elements;
          end;
        writeln(f);
        writeln(f, 'Total number of entries: ', total_entries:1);
        writeln(f,'Cell lengths: ',min_num_entries:1,'..',max_num_entries:1);
        writeln(f);
      end;

    if string_table_histogram IN histograms then
      begin
        writeln(f);
        writeln(f, '++++++++ Histogram of the string hash table ++++++++');
        writeln(f);
        total_entries := 0;  min_num_entries := maxint;  max_num_entries := 0;
        for i := 0 to HASH_STRING_TABLE_SIZE do
          begin
            num_elements := 0;  HSP := string_table[i];
            write(f, i:3, ': ');
            while HSP <> NIL do
              begin
                num_elements := num_elements + 1;
                write(f, '*');
                HSP := HSP^.next_hash_string;
              end;
            writeln(f);
            if num_elements > max_num_entries then
              max_num_entries := num_elements;
            if num_elements < min_num_entries then
              min_num_entries := num_elements;
            total_entries := total_entries + num_elements;
          end;
        writeln(f);
        writeln(f, 'Total number of entries: ', total_entries:1);
        writeln(f,'Cell lengths: ',min_num_entries:1,'..',max_num_entries:1);
        writeln(f);
      end;
    if debug_20 then writeln(outfile, ' exit print_histograms');
  end { print_histograms } ;


(**)     { ------- signal dump procedure ------- }

   
procedure dump_signal_polarity(var f: textfile; polarity: signal_polarity);
  { print out the polarity of the signal }
begin
  if polarity = COMPLEMENTED then write(f, '-')
  else if (polarity = UNKNOWN_POLARITY) and debugging then write(f, '#UN#')
  else if (polarity = NO_POLARITY) and debugging then write(f, '#NO#');
end { dump_signal_polarity } ;


procedure dump_polarity(var f: textfile; polarity: signal_polarity);
  { print the signal polarity }
begin
  case polarity of
    NORMAL:            write(f, 'NORMAL');
    COMPLEMENTED:      write(f, 'COMPLEMENTED');
    UNKNOWN_POLARITY:  write(f, 'UNKNOWN_POLARITY');
    NO_POLARITY:       write(f, 'NO_POLARITY');
  end;
end { dump_polarity } ;


procedure dump_left_and_right(var f: textfile; left, right: bit_range);
  { output a left and right subscript with the specified bits }
begin
  if left <> -1 then
    begin
      write(f, '<', left:1);
      if left <> right then
        write(f, '..', right:1);
      write(f, '>');
    end;
end { dump_left_and_right } ;


procedure dump_bit_subscript(var f: textfile; bits: subscript_ptr;
                             kind: signal_kind);
  { print the bit subscript }
  var
    SP: subscript_ptr;       { current subscript element }
    first: boolean;          { TRUE if no preceding comma to be printed }
begin
  if bits = NIL then
    if kind = undefined then
      begin
        write(f,'<');
        writealpha(f, UNDEFINED_identifier^.name);  write(f,'>');
      end
    else if kind = vector then write(f, '<none>')
    else { it's a scalar, don't print anything }
  else
    if (kind = undefined) or (kind = single) then write(f, '<BAD>')
    else
      begin
        SP := bits;  first := TRUE;
        write(f, '<');
        while SP <> NIL do
          begin
            if first then first := FALSE
            else write(f, ',');
            write(f, SP^.left_index:1);
            if SP^.left_index <> SP^.right_index then
              write(f, '..', SP^.right_index:1);
            SP := SP^.next;
          end;
        write(f, '>');
      end;
end { dump_bit_subscript } ;


procedure dump_signal_descriptor(var f: textfile;
                                 signal: signal_descriptor_ptr);
  { dump the signal from the given signal descriptor }
  var
    prop: property_ptr;
begin
  while signal <> NIL do 
    begin
      if signal^.polarity IN [NORMAL,COMPLEMENTED] then
        begin
          if signal^.low_asserted then
            begin
              if signal^.polarity = NORMAL then
                write(f, '-');
            end
          else
            if signal^.polarity = COMPLEMENTED then
              write(f, '-');
        end
      else if debugging then
        if signal^.polarity = UNKNOWN_POLARITY then
          write(f, '#UN#')
        else if signal^.polarity = NO_POLARITY then
          write(f, '#NO#');
        
      writestring(f, signal^.signal_name);
        
      dump_bit_subscript(f, signal^.bit_subscript, signal^.kind);

      if signal^.low_asserted then write(f, '*');

      if signal^.replication_factor <> 1 then
        write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR, 'R ',
                 signal^.replication_factor:1);

      prop := signal^.properties;
      while prop <> NIL do
        begin
	  write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR);
	  writealpha(f, prop^.name^.name);
	  write(f, '=');
	  writestring(f, prop^.text);
	  prop := prop^.next;
	end;

      if debugging and (signal^.net_id <> nullstring) then
        begin
          write(f, '(');
          dump_string(f, signal^.net_id);
          write(f, ')');
        end;

      if signal^.next <> NIL then writeln(f, ':');
        
      signal := signal^.next;
    end;

  writeln(f);
end { dump_signal_descriptor } ;

        
(**)     { ------- print the macro definition ------- }


procedure print_bindings_list(var f: textfile;  BP: bindings_list_ptr);
  { print the bindings list in a format suitable for print_macro 
    (following). }
  var
    ALP: clear_text_actual_list_ptr;  { list of actuals bound to pin }
begin
  while BP <> NIL do
    begin
      write(f, ' ':8);
      print_string(f, BP^.formal_parameter);

      ALP := BP^.actual_parameter;
      while ALP <> NIL do
	begin
	  if ALP <> BP^.actual_parameter then
	    write(f, ' ':11);

	  write(f, ' = ');
	  print_string(f, ALP^.actual_parameter);
	  writeln(f);

	  ALP := ALP^.next;
	end;

      BP := BP^.next;
    end;

end { print_bindings_list } ;


procedure print_macro(var f: textfile;  macro: macro_def_ptr);
  { print the macro definition to the specified file }
  var
    ILP: invoke_list_ptr;        { current invoked macro element }


  procedure output_signal_list(SLP: signal_list_ptr);
    { output a signal list. }
  begin
    while SLP <> NIL do
      begin
        write(f, ' ':4); writestring(f, SLP^.signal_name); 
        writeln(f);
        SLP := SLP^.next;
      end;
    writeln(f);
  end { output_signal_list } ;


  procedure output_properties(PP: property_ptr; indent: print_width_range);
    { output a property list }
  begin
    if PP = NIL then writeln(f)
    else
      while PP <> NIL do
        begin
          write(f, ' ':indent);
          print_alpha(f, PP^.name^.name);
          write(f, ' = ');
          writestring(f, PP^.text);  writeln(f);
          PP := PP^.next;
        end;
  end { output_properties } ;


begin { print_macro }
  writeln(f);
  writeln(f, 'Dump of the Macro definitions');
  writeln(f);
  writeln(f, '--------------------------------------------------');

  write(f, 'Macro being defined: ');
  writestring(f, macro^.macro_name);
  writeln(f);  writeln(f);

  if macro^.version <> NIL then
    if (er_extension(macro^.version) <> NIL) then
      begin
        write(f, 'Macro version ');
        print_string(f, er_extension(macro^.version));
	writeln(f, '.', er_version(macro^.version):1);
      end;

  writeln(f);
  if macro^.is_leaf_macro then writeln(f, 'This is a LEAF macro')
                          else writeln(f, 'This is not a LEAF macro');

  writeln(f);  
  writeln(f, 'Dump of the parameter list');
  output_signal_list(macro^.params);

  writeln(f, 'Dump of macro properties');
  output_properties(macro^.properties, 4);

  writeln(f, 'Dump of the text macros');
  output_properties(macro^.text_macros, 4);

  if not macro^.is_leaf_macro then
    begin
      writeln(f);
      writeln(f, 'The macros called are as follows:');  
      writeln(f);

      ILP := macro^.invokes;
      while ILP <> NIL do
        begin
          writeln(f, '    **************************************');
          write  (f, '    Macro: ');
          writestring(f, ILP^.macro_name);
          writeln(f);

          writeln(f, '    Dump of the properties');
          output_properties(ILP^.properties, 8);

          writeln(f, '    Dump of the body parameters');
          output_properties(ILP^.parameters, 8);

          writeln(f, '    Formal/Actual parameters');
	  print_bindings_list(f, ILP^.bindings);

          writeln(f);  writeln(f);

          ILP := ILP^.next;
        end;
    end { is_leaf_macro = FALSE } ;
end { print_macro } ;


(**)     { ------- SYMBOL DUMP procedure ------- }


procedure dump_symbol_table(var f: textfile; symbol_table: identifier_ptr);
  { dump the given symbol table to the given file }
  var
    current_id: identifier_ptr;    { current identifier in the table }
begin
  writeln(f, '--- dump of the symbol table ---');

  current_id := symbol_table;
  while current_id <> NIL do
    begin
      print_alpha(f, current_id^.name^.name);
      write(f, ' = "');
      print_string(f, current_id^.definition);
      writeln(f, '"');

      current_id := current_id^.next;
    end;
end { dump_symbol_table } ;


(**)     { ------- dump out all the identifiers ------- }


procedure dump_all_names;
  { dump all the names in the name table to outfile }
  var
    i: name_table_range;      { current index into the name table }
    name: name_ptr;           { element in the list from table }
    form: name_types;         { type of the identifier }
begin
  if debug_20 then writeln(outfile, ' enter dump_all_names');
  if dump_all_names_ok then
    for i := 0 to NAME_TABLE_SIZE do
      begin
        name := name_table[i];
        while name <> NIL do
          begin
            print_alpha(outfile, name^.name);
            writeln(outfile, '(', i:1, ')');

            for form := succ(FIRST_NAME_TYPE) to pred(LAST_NAME_TYPE) do
              if form IN name^.kind then
                case form of
                  RESERVED:          
		    begin
		      write(outfile, '    reserved ');
		      writestring(outfile, name^.definition);
		      writeln(outfile);
		    end;
                  UNRESERVED:
		    begin
		      write(outfile, '    unreserved ');
		      writestring(outfile, name^.definition);
		      writeln(outfile);
		    end;
                  KEY_WORD:          writeln(outfile, '    key word');
                  INHERIT_PIN:       writeln(outfile, '    inherit pin');
                  INHERIT_SIGNAL:    writeln(outfile, '    inherit signal');
                  INHERIT_BODY:      writeln(outfile, '    inherit body');
                  IS_PARAMETER:      writeln(outfile, '    is parameter');
                  IS_INT_PARAMETER:  writeln(outfile, '    is int parameter');
                  PERMIT_BODY:       writeln(outfile, '    permit body');
                  PERMIT_SIGNAL:     writeln(outfile, '    permit signal');
                  PERMIT_PIN:        writeln(outfile, '    permit pin');
                  DONT_OUTPUT:       writeln(outfile, '    filtered');
                  IS_ET_CONTROL:     writeln(outfile, '    et control');
                  OTHERWISE          writeln(outfile, '    attribute number ',
                                             ord(form):1);
                end;

            name := name^.next;
          end;
      end;
  if debug_20 then writeln(outfile, ' enter dump_all_names');
end { dump_all_names } ;


procedure new_identifier(*var id: identifier_ptr*);
  { create an identifier }
begin
  if free_identifiers <> NIL then
    begin  id := free_identifiers;  free_identifiers := id^.next;  end
  else
    begin
      new(id);
      increment_heap_count(HEAP_IDENTIFIER, 3*POINTER_SIZE+BOOL_SIZE);
    end;

  id^.next := NIL;
  id^.name := NIL;
  id^.definition := nullstring;
  id^.resolves := TRUE;
end { new_identifier } ;


procedure release_identifier(var id: identifier_ptr);
  { release the identifier for later reuse }
begin
  if id <> NIL then
    begin
      id^.next := free_identifiers;  free_identifiers := id;  id := NIL;
    end;
end { release_identifier } ;


procedure release_symbol_table(var symbol_table: identifier_ptr);
  { release all elements in the symbol table }
  var
    next,                       { next element in the table }
    element: identifier_ptr;    { current element in the table }
begin
  element := symbol_table;
  while element <> NIL do
    begin
      next := element^.next;
      release_identifier(element);
      element := next;
    end;
end { release_symbol_table } ;


procedure new_directory_list(var element: directory_list_ptr);
  { create a new directory entry }
begin
  if free_directory_lists = NIL then
    begin
      new(element);  
      increment_heap_count(HEAP_DIRECTORY, 3*POINTER_SIZE);
    end
  else
    begin
      element := free_directory_lists;
      free_directory_lists := free_directory_lists^.next;
    end;

  element^.next := NIL;  
  element^.name := nullstring;
  element^.add := nullstring;
end { new_directory_list } ;

procedure release_directory_list(var element: directory_list_ptr);
  { delete and release a directory entry }
  var
    oldnext: directory_list_ptr; { value to be returned }
begin
  if element <> NIL then
    begin
      oldnext := element^.next;
      element^.next := free_directory_lists;
      free_directory_lists := element;
      element := oldnext;
    end;
end { release_directory_list } ;


(**)     { ------- file utilities ------- }


function context_string(context: property_ptr): xtring;
  { build the string that describes the context }
  var
    temp: xtring;              { for construction }
    string_overflow: boolean;
begin { build_local_filename_extension }
  create_a_string(temp, MAX_STRING_LENGTH);
  temp^[0] := chr(0);
  string_overflow := FALSE;

  if context <> NIL then with context^ do
    if name = SIZE_prop_name then
      begin
	if add_string_to_string(temp, text) then ;
	context := next;
      end;

  while (context <> NIL) and not string_overflow do
    with context^ do
      begin
	if add_alpha_to_string(temp, name^.name) then ;
	if not add_quoted_string_to_string(temp, text) then
	  string_overflow := TRUE;
	context := next;
      end;

  if string_overflow then
    begin
      assert(235 { string length exceeded internally });
      write(CmpLog, ' string = ');
      writestring(CmpLog, temp);
      writeln(CmpLog);
      writeln(CmpLog, ' Too many parameters on this drawing');
      if debugging then
	begin
	  write(Outfile, ' string = ');
	  writestring(Outfile, temp);
	  writeln(Outfile);
	  writeln(Outfile, ' Too many parameters on this drawing');
	end;
    end;
  context_string := enter_string(temp);
  temp^[0] := chr(MAX_STRING_LENGTH);
  release_string(temp);
end; { context_string }
      

(**){ -- 1 only file utilities -- }


function dup_file_descriptor(var fi: textfile; 
			     desc: Cint; mode: open_mode): boolean;
  { Do a dup to get the textfile var fi to refer to the file descriptor
    described by desc.  (note: does not close the original descriptor.)
    Returns TRUE iff successful. }
  var
    ok: boolean;      { value for return }
    dev_null: xtring; { '/dev/null' }
    code: integer;    { system dependent return code }
begin
  dev_null := nullstring;
  copy_to_string('/dev/null       ', dev_null);
  ok := vopen(fi, null_alpha, dev_null, mode, code);
  release_string(dev_null);

  if debug_22 then
    if ok then write(outfile, 'dup of file descriptor ', desc:1)
    else 
      write(outfile, 'reset/rewrite failed -- dup of file descriptor ',
            desc:1);


  if ok then ok := (dup2(desc, text_file_descr(fi)) <> - 1);


  if debug_22 then
    if ok then writeln(outfile, ' SUCCEEDS')
          else writeln(outfile, ' FAILS');

  dup_file_descriptor := ok;
end { dup_file_descriptor } ;


function dup_inputfile_descriptor(var fi: inputfile; desc: Cint): boolean;
  { Do a dup to get the inputfile var fi to refer to the file descriptor
    described by desc.  (note: does not close the original descriptor.)
    Returns TRUE iff successful. }
  var
    ok: boolean;     { value for return }
    logical: alpha;  { dummy logical name }
    name: xtring;    { name of bit bucket }
begin
  ok := FALSE;
  name := nullstring;
  copy_to_string('/dev/null       ', name);
  logical := NULL_ALPHA;
  ok := creset(fi, logical, name, 0);
 
  release_string(name);

  if debug_22 then
    if ok then write(outfile, 'dup of file descriptor ', desc:1)
    else
      write(outfile, 'creset failed -- dup of file descriptor ', desc:1);


  if ok then ok := (dup2(desc, cfdsc(fi)) <> - 1); 


  if debug_22 then
    if ok then writeln(outfile, ' SUCCEEDS')
          else writeln(outfile, ' FAILS');

  dup_inputfile_descriptor := ok;
end { dup_inputfile_descriptor } ;


function get_time_stamp(name: xtring; var stamp: time_stamp): boolean;
  { Returns the time stamp of the file.  Returns FALSE and emits error
    if unable to do this.  Existence of the file is assumed. }
  var
    success: boolean;      { indicates success }
begin
  if debug_23 then
    begin
      write(outfile, 'get_time_stamp ');
      writestring(outfile, name);
    end;

  stamp := 0;
  success := gettime(name, stamp);
  if debug_23 then
    if success then writeln(outfile, ' ', stamp:1)
    else writeln(outfile, ' FAILED');

  if not success then
    begin
      error(237 { can't get it });
      error_dump_file_name(name);
    end;
  get_time_stamp := success;
end { get_time_stamp };


function remove_file(name: xtring): boolean;
  { Remove the named file. Return TRUE iff successful. }
  var 


    success: boolean;
begin

  success := delete_file(name);


  remove_file := success;
end { remove_file };


(**)     { ------- file utilities ------- }


procedure printParseType(var f: textfile;
                         parsefile: parse_file_type);
  { print out the enumerated type "parse_file_type" into the given file f. }
begin
  case parsefile of
    DIRECTIVES_FILE:    write(f, 'DIRECTIVES_FILE');
    STANDARD_FILE:      write(f, 'STANDARD_FILE');
    CMPDRAW_FILE:       write(f, 'CMPDRAW_FILE');
    CMPSCHEM_FILE:      write(f, 'CMPSCHEM_FILE');
    OTHERWISE          begin  write(f, 'UNKNOWN_FILE')  end;
  end;
end { printParseType } ;


function rewrite_file(*var txtfil: textfile; filename: xtring; 
                      logical: alpha): boolean*);
  { rewrite a file of the given name.  Return FALSE if not successful }
  var
    mode: open_mode;     { buffered or unbuffered ? }
    val: boolean;        { return value }
    code: integer;       { system dependent return code }
begin
  if debug_22 then
    begin
      write(outfile, 'rewriting file: ');
      if filename = nullstring then print_alpha(outfile, logical)
      else writestring(outfile, filename);
      writeln(outfile);
    end;

  if debugging then mode := UNBUF_WRITE else mode := WRITE_MODE;

  val := vopen(txtfil, logical, filename, mode, code);

  if debug_22 and val then 
    writeln(Outfile, '  fd = ', text_file_descr(txtfil):1); 

  if not val then
    if logical = MONITOR_FILE_NAME then
      begin


        writeln(output, 'pcomp: unable to open MONITOR (fatal)');
        write_ioresult(output, to_ioresult(code));
        halt_with_status(FATAL_COMPLETION);
      end
    else if logical = CMPLOG_FILE_NAME then
      begin
        writeln(Monitor, 'pcomp: unable to open CMPLOG (fatal)');
        write_ioresult(Monitor, to_ioresult(code));
        halt_with_status(FATAL_COMPLETION);
      end
    else
      begin
        error(169 { cannot open this file });
        if filename = nullstring then error_dump_alpha_file_name(logical)
	else error_dump_file_name(filename);
	error_dump_ioresult(to_ioresult(code));
	if debug_22 then writeln(Outfile, '  Original error code ', code:1);
      end;
 
  rewrite_file := val;

end { rewrite_file } ;

{Thie is the Pascal call to be used for rewriting files maintained in the data services
The logical name used here should be defined as a part of the DS environment. Hence 
there are are two environments, one maintained by the data services, the other
being the 1 environment.}

function rewrite_ds_file(*var txtfil: textfile; filename: xtring; 
                      logical: alpha): boolean*);
  { rewrite a file of the given name.  Return FALSE if not successful }
  var
    mode: open_mode;     { buffered or unbuffered ? }
    val: boolean;        { return value }
    code: integer;       { system dependent return code }
begin
  if debug_22 then
    begin
      write(outfile, 'rewriting ds file: ');
      if filename = nullstring then print_alpha(outfile, logical)
      else writestring(outfile, filename);
      writeln(outfile);
    end;

  if debugging then mode := UNBUF_WRITE else mode := WRITE_MODE;

  val := ds_vopen(txtfil, logical, filename, mode, code);

  if debug_22 and val then 
    writeln(Outfile, '  fd = ', text_file_descr(txtfil):1); 

  if not val then
    if logical = MONITOR_FILE_NAME then
      begin


        writeln(output, 'pcomp: unable to open MONITOR (fatal)');
        write_ioresult(output, to_ioresult(code));
        halt_with_status(FATAL_COMPLETION);
      end
    else if logical = CMPLOG_FILE_NAME then
      begin
        writeln(Monitor, 'pcomp: unable to open CMPLOG (fatal)');
        write_ioresult(Monitor, to_ioresult(code));
        halt_with_status(FATAL_COMPLETION);
      end
    else
      begin
        error(169 { cannot open this file });
        if filename = nullstring then error_dump_alpha_file_name(logical)
	else error_dump_file_name(filename);
	error_dump_ioresult(to_ioresult(code));
	if debug_22 then writeln(Outfile, '  Original error code ', code:1);
      end;
 
  rewrite_ds_file := val;

end { rewrite_ds_file } ;


function reset_file(*filename: string; which: parse_file_type): boolean*);
  { reset a file of the given name.  If the name is NULL, open nameless.  If
    no file can be opened, return FALSE.  WHICH specifies which logical 
    file is to be opened. }
  var
    logical: alpha;                     { for passing logical name }
    val: boolean;                       { return value }
    code: integer;                      { system dependent code }


  procedure dump_fd(var f: inputfile);
    { dump the file descripter to outfile }
  begin
    writeln(Outfile, '  fd = ', cfdsc(f):1); 
  end { dump_fd } ;


begin { reset_file }
  if current_file <> UNKNOWN_FILE then
    begin
      val := FALSE;
      assert(169 { tried to open two files at once });

      write(CmpLog, ' Current file open = ');
      printParseType(CmpLog, current_file);
      writeln(CmpLog);
      write(CmpLog, ' New file to open = '); 
      printParseType(CmpLog, which);
      writeln(CmpLog);
    end
  else
    begin
      if (debug or debug_22) and (which <> DIRECTIVES_FILE) then 
        begin
          write(outfile, 'reseting ');
          printParseType(outfile, which);
	  if filename <> nullstring then
	    begin
	      write(outfile, ' as ');
	      writestring(outfile, filename);
	    end;
	  writeln(outfile);
        end;

      case which of
        DIRECTIVES_FILE:
          begin
            logical := 'INFILE          ';


            val := creset(infile, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(infile); 

          end;

        STANDARD_FILE:
          begin
            logical := 'CMPSTAN         ';


            val := creset(CmpStan, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpStan); 

          end;

        CMPDRAW_FILE:
          begin
            logical := 'CMPDRAW         ';


            val := creset(CmpDraw, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpDraw);

          end;

        CMPSCHEM_FILE:
          begin
            logical := 'CMPSCHEM        ';


            val := creset(CmpSchemI, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpSchemI);

          end;

        OTHERWISE
          begin
            val := FALSE;
            assert(170 { attempt to open an unknown file });
          end;
      end { case } ;
    end;
  if val then current_file := which;
  reset_file := val;
end { reset_file } ;

{This is the call to reset files maintained by data services}
function reset_ds_file(*filename: string; which: parse_file_type): boolean*);
  { reset a file of the given name.  If the name is NULL, return FALSE.  If
    no file can be opened, return FALSE.  WHICH specifies which logical 
    file is to be opened. }
  var
    logical: alpha;                     { for passing logical name }
    val: boolean;                       { return value }
    code: integer;                      { system dependent code }


  procedure dump_fd(var f: inputfile);
    { dump the file descripter to outfile }
  begin
    writeln(Outfile, '  fd = ', cfdsc(f):1); 
  end { dump_fd } ;


begin { reset_ds_file }
  if current_file <> UNKNOWN_FILE then
    begin
      val := FALSE;
      assert(169 { tried to open two files at once });

      write(CmpLog, ' Current file open = ');
      printParseType(CmpLog, current_file);
      writeln(CmpLog);
      write(CmpLog, ' New file to open = '); 
      printParseType(CmpLog, which);
      writeln(CmpLog);
    end
  else
    begin
      if debug or debug_22 then 
        begin
          write(outfile, 'reseting ');
          printParseType(outfile, which);
	  if filename <> nullstring then
	    begin
	      write(outfile, ' as ');
	      writestring(outfile, filename);
	    end;
	  writeln(outfile);
        end;

      case which of
        DIRECTIVES_FILE:
          begin
            logical := 'INFILE          ';

            val := ds_creset(infile, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(infile); 
          end;

        STANDARD_FILE:
          begin
            logical := 'CMPSTAN         ';
            val := ds_creset(CmpStan, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpStan); 
          end;

        CMPDRAW_FILE:
          begin
            logical := 'CMPDRAW         ';
            val := ds_creset(CmpDraw, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpDraw);
          end;

        CMPSCHEM_FILE:
          begin
            logical := 'CMPSCHEM        ';
            val := ds_creset(CmpSchemI, logical, filename, BUFSIZ); 
	    if debug_22 and val then dump_fd(CmpSchemI);
          end;

        OTHERWISE
          begin
            val := FALSE;
            assert(170 { attempt to open an unknown file });
          end;
      end { case } ;
    end;
  if val then current_file := which;
  reset_ds_file := val;
end { reset_ds_file } ;


function close_parse_file(*which: parse_file_type): boolean*);
  { close the input file }
var           
   val: boolean;       { return value }
begin
  if debug_22 then
    begin
      write(outfile, 'closing file ');
      printParseType(outfile, which);

      write(outfile, ' file descriptor: ');
      case which of
        DIRECTIVES_FILE:  writeln(outfile, cfdsc(infile):1);
        STANDARD_FILE:    writeln(outfile, cfdsc(CmpStan):1);
        CMPDRAW_FILE:     writeln(outfile, cfdsc(CmpDraw):1);
        CMPSCHEM_FILE:    writeln(outfile, cfdsc(CmpSchemI):1);
        UNKNOWN_FILE:     writeln(outfile);
      end;


    end;

  { NOTE: CMPSCHEM_FILE can be closed out of turn -- it is kept open on
    some platforms until after being written to preserve file locking.
    In fact it is never the "current_file" when it is actually closed. }

  if (which <> current_file) and (which <> CMPSCHEM_FILE) then
    begin
      assert(171 { tried to close wrong file! });
      writeln(CmpLog, 'Current_file = ', ord(current_file),
                      ';  File to be closed = ', ord(which));
      val := FALSE;
    end
  else
    begin
      case which of
        DIRECTIVES_FILE:  

          val := cfclose(infile);


        STANDARD_FILE:    

          val := cfclose(CmpStan);


        CMPDRAW_FILE:     

          val := cfclose(CmpDraw);


        CMPSCHEM_FILE:     

          val := cfclose(CmpSchemI);


        UNKNOWN_FILE:
	  begin
	    assert(172 { attempt to close an unknown file });
	    val := FALSE;
	  end;
      end;

    end;
  current_file := UNKNOWN_FILE;
  close_parse_file := val;
end { close_parse_file } ;


procedure close_file(*var f: textfile; logical: alpha; file_name: xtring*);
  { close the given file }
begin
  if debug_22 then 
    begin
      write(outfile, 'close file ');
      if file_name = nullstring then writealpha(outfile, logical)
      else writestring(outfile, file_name);

      write(outfile, ' file descriptor: ', text_file_descr(f):1);

      writeln(outfile);
    end;

  if not vclose(f) then
    begin
      error(168 { cannot close specified file });
      if file_name = nullstring then
        error_dump_alpha_file_name(logical)
      else error_dump_file_name(file_name);
    end;
end { close_file } ;

procedure close_ds_file(var f: textfile; file_name: xtring);
  { close the given ds file }
begin
  if debug_22 then 
    begin
      write(outfile, 'close ds file ');
      writestring(outfile, file_name);

{      write(outfile, ' file descriptor: ', text_file_descr(f):1);}

      writeln(outfile);
    end;

  if not ds_vclose(f) then
    begin
      error(168 { cannot close specified file });
      error_dump_file_name(file_name);
    end;
end { close_ds_file } ;


function rewrite_locked_file(which: parse_file_type;
                             filename: xtring;  logical: alpha): boolean;
  { Rewrite the parse file (which is open, though it may not be current_file)
    without losing the lock on it.  filename (or logical) describe the
    open file accurately. }


begin
  if debug_22 then 
    begin
      writeln(outfile, 'rewrite_locked_file ');
      writealpha(outfile, logical);
      write(outfile, ' as ');
      writestring(outfile, filename);
      writeln(outfile);
    end;

  if which <> CMPSCHEM_FILE then
    begin
      assert(0 { should never happen });
      write(CmpLog, ' Rewrite_locked_file ');
      writealpha(CmpLog, logical);
      write(CmpLog, ' as ');
      writestring(CmpLog, filename);
      writeln(CmpLog, ' (not CMPSCHEM file!!)');
    end;

  { The 1 lock is good til undone by efs_unlock -- we can open and close
    the file with impunity }


  if close_parse_file(CMPSCHEM_FILE) then ;
  if rewrite_file(CmpSchem, filename, logical) then
    rewrite_locked_file := TRUE
  else rewrite_locked_file := FALSE; 


end { rewrite_locked_file } ;


procedure remove_logical_file(*fname: alpha*);
  { delete the specified file, if it exists }
begin
  if not delete_logical_file(fname) { external C function } then ;
end { remove_locical_file } ;


procedure print_alpha_continue(var f: textfile; name: alpha);
  { print the given alpha (NAME) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
  var
    i,len: id_range;
begin
  len := alpha_length(name);
  if (len > 0) and (len + column < MAX_OUTPUT_FILE_LENGTH - 1) then
    begin
      write(f, name:len);
      column := column + len;
    end
  else
    for i := 1 to len do
      begin
	if column >= MAX_OUTPUT_FILE_LENGTH-2 then
	  begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;
  
	write(f, name[i]);  column := column + 1;
      end;
end { print_alpha_continue } ;


procedure print_char_continue(var f: textfile; ch: char);
  { print the given string (STR) to the given file (F).  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
begin
  if column >= MAX_OUTPUT_FILE_LENGTH-2 then
    begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;

  write(f, ch);  column := column + 1;
end { print_char_continue } ;


procedure print_string_quoted_continue(var f: textfile; str: xtring);
  { print the given string (STR) quoted to the given file (F).  Double
    any embedded quoted in the string.  If the current
    line is overflowed (MAX_OUTPUT_FILE_LENGTH), print a continuation
    character and continue on the next line. }
  var
    start,len: string_range;
    stop: integer;  { may exceed MAX_STRING_LENGTH by 1 }
    hack: string_hack;
    found_quote: boolean;
begin
  print_char_continue(f, OUTPUT_QUOTE_CHAR);

  len := ord(str^[0]);  
  stop := 1;
  while stop <= len do
    begin
      if column >= MAX_OUTPUT_FILE_LENGTH-2 then
	begin  writeln(f, CONTINUATION_CHAR);  column := 0;  end;
      start := stop;  found_quote := FALSE;
      while (stop <= len) and (column < MAX_OUTPUT_FILE_LENGTH - 2) and
        not found_quote do
	begin
	  column := column + 1;
	  found_quote := str^[stop] = OUTPUT_QUOTE_CHAR;
	  stop := stop + 1;
	end;
      hack.i := ord(str) + start;
      write(f, hack.s^:(stop - start));
      if found_quote then print_char_continue(f, OUTPUT_QUOTE_CHAR);
    end;

  print_char_continue(f, OUTPUT_QUOTE_CHAR);
end { print_string_quoted_continue } ;


procedure pipe_init(var p: pipe);
  { initialize the pipe to "undefined" }
begin
  p.which := FIRST_PIPE;
  p.state := PIPE_NOT_OPEN;
  p.is_pipe := FALSE;
  p.fd := -1;
  p.name := nullstring;
  p.written := FALSE;
end { pipe_init } ;


procedure dump_pipe(var f: textfile; var p: pipe; 
                    indentation: natural_number);
  { Dump the pipe record to file f (for debugging). }
begin
  if indentation > 0 then write(f, ' ':indentation);
  case p.which of
    SCHEMA_PIPE: write(f, 'SCHEMA_PIPE ');
    EXPANSION_PIPE: write(f, 'EXPANSION_PIPE ');
    TO_ET_PIPE: write(f, 'TO_ET_PIPE ');
    TEMP_PIPE: write(f, 'TEMP_PIPE ');
    FROM_ET_PIPE: write(f, 'FROM_ET_PIPE ');
    OTHERWISE write(f, 'UNKNOWN_PIPE ');
  end;
  case p.state of
    PIPE_NOT_OPEN: write(f, 'unopened');
    PIPE_OPEN_FOR_READ: write(f, 'reading from ');
    PIPE_OPEN_FOR_WRITE: write(f, 'writing to ');
  end;
  if p.state <> PIPE_NOT_OPEN then
    if p.is_pipe then write(f, 'fd ', p.fd:1)
    else
      if p.name = nullstring then write(f, 'logical file')
      else writestring(f, p.name);
  writeln(f, '.');
end { dump_pipe } ;


function pipe_readln(var p: pipe; line: xtring): read_result;
  { Read a line from the pipe/file.  Return TRUE if this has been
    done (FALSE if eof or not open). }
  label
    90;  { return }
  const
    C_EOF = 2;         { eof in Creadln }
    C_OVF = 1;         { line overflow in Creadln }
    C_OK = 0;          { Creadln succeeded }
  var
    Cval: Cint;         { condition code returned by Creadln }


begin { pipe_readln }
  { This routine assumes for now that there is only 1 possible input
    pipe -- FROM_ET_PIPE.  If more are added, then case statements will
    be necessary here. }

  pipe_readln := READ_EOF;
  if p.state <> PIPE_OPEN_FOR_READ then
    begin
      assert(0);
      writeln(Cmplog, ' Reading an pipe not open for read !!');
      goto 90 { return } ;
    end;
  if p.which <> FROM_ET_PIPE then
    begin
      assert(0);
      writeln(Cmplog, ' Read(Unknown PIPE/file ', ord(p.which):1, ')');
      goto 90 { return } ;
    end;


  Cval := creadln(CmpDraw, line);
  case Cval of
    C_EOF: pipe_readln := READ_EOF;
    C_OVF: pipe_readln := READ_OVERFLOW;
    C_OK: pipe_readln := READ_OK;
  end;


90:
end { pipe_readln } ;


procedure pipe_dump_string_quoted(p: pipe;  str: xtring);
  { dump the string, quoted (and parseable) to the given pipe/file }


begin
  p.written := TRUE;
  case p.which of 
    EXPANSION_PIPE:
      begin


          print_string_quoted_continue(CmpExp, str);
      end;
    SCHEMA_PIPE:
      begin


          print_string_quoted_continue(CmpSchem, str);
      end;
    TO_ET_PIPE:
      begin


          print_string_quoted_continue(Design, str);
      end;
    TEMP_PIPE:
      begin


          print_string_quoted_continue(CmpTmp, str);
      end;
    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
end { pipe_dump_string_quoted } ;


procedure pipe_dump_alpha(var p: pipe; name: alpha);
  { Write the name to the pipe }
begin
  p.written := TRUE;
  case p.which of 
    EXPANSION_PIPE:
      begin


          print_alpha_continue(CmpExp, name);
      end;
    SCHEMA_PIPE:
      begin


          print_alpha_continue(CmpSchem, name);
      end;
    TO_ET_PIPE:
      begin


        print_alpha_continue(Design, name);
      end;
    TEMP_PIPE:
      begin


        print_alpha_continue(CmpTmp, name);
      end;
    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
end { pipe_dump_alpha } ;


procedure pipe_dump_integer(var p: pipe; i: integer);
  { Write the integer to the pipe }
var
  numb: alpha;     { buffer for number }
  index: id_range; { index into numb }


  procedure build_number(n: natural_number);
    { add the given number to the string }
  begin
    if n > 9 then build_number(n DIV 10);
    numb[index] := chr((n mod 10) + ord('0'));
    index := index + 1;
  end { build_number } ;


begin { pipe_dump_integer }
  { It is assumed that alphas are always more than long enough to hold 
    the textual representation of a integer. }
  p.written := TRUE;
  numb := NULL_ALPHA;
  if i < 0 then
    begin  i := -i;  numb[1] := '-';  index := 2;  end
  else index := 1;
  build_number(i);
  pipe_dump_alpha(p, numb);
end { pipe_dump_integer } ;


procedure pipe_dump_char(var p: pipe; ch: char);
  { Write the char to the pipe }


begin
  p.written := TRUE;


  case p.which of 
    EXPANSION_PIPE:
      begin


          print_char_continue(CmpExp, ch);
      end;
    SCHEMA_PIPE:
      begin


          print_char_continue(CmpSchem, ch);
      end;
    TO_ET_PIPE:
      begin


          print_char_continue(Design, ch);
      end;
    TEMP_PIPE:
      begin


          print_char_continue(CmpTmp, ch);
      end;
    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
end { pipe_dump_char } ;


procedure pipe_dump_CRLF(var p: pipe);
  { Write CRLF to the pipe }
begin
  p.written := TRUE;


  case p.which of 
    EXPANSION_PIPE:
      begin
        writeln(CmpExp);
      end;
    SCHEMA_PIPE:
      begin
        writeln(CmpSchem);
      end;
    TO_ET_PIPE:
      begin
        writeln(Design);
      end;
    TEMP_PIPE:
      begin
        writeln(CmpTmp);
      end;
    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  column := 0;
end { pipe_dump_CRLF } ;


function pipe_is_pipe(var p: pipe): boolean;
  { return TRUE if pipe is actually opened to inter-process communication
    (rather than to a file) }
begin
  pipe_is_pipe := p.is_pipe;
end { pipe_is_pipe } ;


function pipe_reset_file(var p: pipe; which: pipe_files; name: xtring): 
  boolean;
  { perform reset file on the file associated with "which" and format the
    pipe record to indicate this.  Return TRUE iff successful.  Name is
    presumed to remain a viable string pointer until after pipe is closed. }
begin
  pipe_init(p);
  p.is_pipe := FALSE;
  p.which := which;
  p.name := name;
  case which of
    FROM_ET_PIPE: 
      if reset_file(name, CMPDRAW_FILE) then p.state := PIPE_OPEN_FOR_READ;
    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  pipe_reset_file := (p.state = PIPE_OPEN_FOR_READ);
  if debug_22 then
    begin
      write(Outfile, 'pipe_reset_file');
      if (p.state = PIPE_OPEN_FOR_READ) then write(Outfile, '(T): ')
                                        else write(Outfile, '(F): ');
      dump_pipe(Outfile, p, 0);
    end;
end { pipe_reset_file } ;


function pipe_rewrite_file(var p: pipe; which: pipe_files; name: xtring): 
  boolean;
  { perform rewrite file on the file associated with "which" and format the
    pipe record to indicate this.  Return TRUE iff successful. Name is
    presumed to remain a viable string pointer until after pipe is closed. }
begin
  pipe_init(p);
  p.is_pipe := FALSE;
  p.which := which;
  p.name := name;
  case which of
    EXPANSION_PIPE: 
      if rewrite_file(CmpExp, name, CMPEXP_FILE_NAME) then
        p.state := PIPE_OPEN_FOR_WRITE;
    TO_ET_PIPE: 
      if rewrite_file(Design, name, DESIGN_FILE_NAME) then
        p.state := PIPE_OPEN_FOR_WRITE;
    TEMP_PIPE: 
      if rewrite_file(CmpTmp, name, CMPTMP_FILE_NAME) then
        p.state := PIPE_OPEN_FOR_WRITE;
    OTHERWISE
      begin
        assert(0);

        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  pipe_rewrite_file := (p.state = PIPE_OPEN_FOR_WRITE);
  debug_22 := TRUE;
  if debug_22 then
    begin
      write(Outfile, 'pipe_rewrite_file');
      if (p.state = PIPE_OPEN_FOR_WRITE) then write(Outfile, '(T): ')
                                         else write(Outfile, '(F): ');
      dump_pipe(Outfile, p, 0);
    end;
end { pipe_rewrite_file } ;


function pipe_reset_descriptor(var p: pipe; which: pipe_files; fd: Cint): 
  boolean;
  { Set up pipe p to read from the given (presumed open) descriptor. 
    Return TRUE iff successful. }
begin
  pipe_init(p);
  p.is_pipe := TRUE;
  p.which := which;
  p.fd := fd;
  case which of
    FROM_ET_PIPE: 

      if dup_inputfile_descriptor(CmpDraw, fd) then
        begin
          p.state := PIPE_OPEN_FOR_READ;
	  p.fd := cfdsc(CmpDraw);
	end;


    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  pipe_reset_descriptor := (p.state = PIPE_OPEN_FOR_READ);
  if debug_22 then
    begin
      write(Outfile, 'pipe_reset_desc');
      if (p.state = PIPE_OPEN_FOR_READ) then write(Outfile, '(T): ')
                                        else write(Outfile, '(F): ');
      dump_pipe(Outfile, p, 0);
    end;
end { pipe_reset_descriptor } ;


function pipe_rewrite_descriptor(var p: pipe; which: pipe_files; fd: Cint): 
  boolean;
  { Set up pipe p to write to the given (presumed open) descriptor.
    Return TRUE iff successful. }
begin
  pipe_init(p);
  p.is_pipe := TRUE;
  p.which := which;
  p.fd := fd;
  case which of
    EXPANSION_PIPE: 

      if dup_file_descriptor(CmpExp, fd, UNBUF_WRITE) then
        begin
          p.state := PIPE_OPEN_FOR_WRITE;
	  p.fd := text_file_descr(CmpExp);
	end;


    SCHEMA_PIPE:

      if dup_file_descriptor(CmpSchem, fd, UNBUF_WRITE) then
        begin
          p.state := PIPE_OPEN_FOR_WRITE;
	  p.fd := text_file_descr(CmpSchem);
	end;


    TO_ET_PIPE: 

      if dup_file_descriptor(Design, fd, UNBUF_WRITE) then
        begin
          p.state := PIPE_OPEN_FOR_WRITE;
	  p.fd := text_file_descr(Design);
	end;


    TEMP_PIPE: 

      if dup_file_descriptor(CmpTmp, fd, UNBUF_WRITE) then
        begin
          p.state := PIPE_OPEN_FOR_WRITE;
	  p.fd := text_file_descr(CmpTmp);
	end;


    OTHERWISE
      begin
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  pipe_rewrite_descriptor := (p.state = PIPE_OPEN_FOR_WRITE);
  if debug_22 then
    begin
      write(Outfile, 'pipe_rewrite_desc');
      if (p.state = PIPE_OPEN_FOR_WRITE) then write(Outfile, '(T): ')
                                         else write(Outfile, '(F): ');
      dump_pipe(Outfile, p, 0);
    end;
end { pipe_rewrite_descriptor } ;


procedure pipe_close(var p: pipe);
  { close the pipe -- it is not an error to attempt to close an
    unopened pipe. }
begin
  if debug_22 then
    begin
      write(Outfile, 'Closing ');  dump_pipe(Outfile, p, 0);
    end;


  if (p.state = PIPE_OPEN_FOR_READ) or (p.state = PIPE_OPEN_FOR_WRITE) then
    case p.which of
      EXPANSION_PIPE:


          close_file(CmpExp, CMPEXP_FILE_NAME, p.name);
      SCHEMA_PIPE:


          close_file(CmpSchem, CMPSCHEM_FILE_NAME, p.name);
      TEMP_PIPE:


          close_file(CmpTmp, CMPTMP_FILE_NAME, p.name);
      FROM_ET_PIPE:


        if cfclose(CmpDraw) then ;

      TO_ET_PIPE:


          close_file(Design, DESIGN_FILE_NAME, p.name);
      OTHERWISE
        begin
          assert(0);
          writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
        end;
    end;
  pipe_init(p);
end { pipe_close } ;


procedure pipe_from_open_file(var p: pipe; which: pipe_files; name: xtring);
  { Construct pipe record for access to the indicated file as a "pipe".
    The file is presumed open.  Name is presumed to remain a viable
    string pointer until after pipe is closed. }
begin
  pipe_init(p);
  p.is_pipe := FALSE;
  p.which := which;
  p.name := name;
  case which of
    SCHEMA_PIPE: p.state := PIPE_OPEN_FOR_WRITE;
    EXPANSION_PIPE: p.state := PIPE_OPEN_FOR_WRITE;
    TO_ET_PIPE: p.state := PIPE_OPEN_FOR_WRITE;
    TEMP_PIPE: p.state := PIPE_OPEN_FOR_WRITE;
    FROM_ET_PIPE: p.state := PIPE_OPEN_FOR_READ;
    OTHERWISE
      begin
        p.state := PIPE_NOT_OPEN;
        assert(0);
        writeln(CmpLog, ' Unknown pipe/file ', ord(p.which):1);
      end;
  end;
  if debug_22 then
    begin
      write(Outfile, 'Pipe_from_file: ');  dump_pipe(Outfile, p, 0);
    end;
end { pipe_from_open_file } ;

  
function open_a_file(file_name: xtring; which: parse_file_type): boolean;
  { open the specified file for read and parse the first token from it.
    If the FILE_NAME is not empty (NULLSTRING), open the file named.  If
    it is empty, open the file as specified in the file equation. }
  var
    ok: boolean;         { TRUE iff file open successful }
begin
  ok := reset_file(file_name, which);

  if ok then  
    begin
      read_state := FINIT;
      insymbol;
    end;
  open_a_file := ok;
end { open_a_file } ;

function open_a_ds_file(file_name: xtring; which: parse_file_type): boolean;
  { open the specified file for read and parse the first token from it.
    If the FILE_NAME is not empty (NULLSTRING), open the file named.  If
    it is empty, open the file as specified in the file equation. }
  var
    ok: boolean;         { TRUE iff file open successful }
begin
  ok := reset_ds_file(file_name, which);

  if ok then  
    begin
      read_state := FINIT;
      insymbol;
    end;
  open_a_ds_file := ok;
end { open_a_ds_file } ;


function get_file_type: file_types;
  { check to see that the current file has correct type and return type }
  var
    this_file: file_types;      { type of this file }
    found: boolean;             { TRUE if file type found in table }


begin { get_file_type }
  this_file := FIRST_FILE_TYPE;
  if sy <> FILETYPESY then error(85 { expected FILE_TYPE })
  else
    begin
      insymbol;
      if sy = EQUAL then insymbol else error(2 { expected = });
      if sy <> IDENT then error(1 { expected ident })
      else
        begin
          this_file := succ(FIRST_FILE_TYPE);  found := FALSE;
          while (this_file < LAST_FILE_TYPE) and not found do
            if file_type_list[this_file] = id.name then found := TRUE
            else this_file := succ(this_file);

          if not found then this_file := FIRST_FILE_TYPE;
          insymbol;
          if sy = SEMI then insymbol else assert(35 { expected ; });
        end;
    end;

  get_file_type := this_file;
end { get_file_type } ;


(**)     { ------- string hash table routines ------- }


function make_and_enter_string(*name: alpha): string*);
  { convert an alpha into a string and enter it into the hash table }
  var
    temp_string: xtring;        { temporary string }
    original_string: xtring;    { original string value }
begin
  temp_string := nullstring;
  copy_to_string(name, temp_string);

  original_string := temp_string;
  temp_string := enter_string(temp_string);

  if temp_string <> original_string then release_string(original_string);

  make_and_enter_string := temp_string;
end { make_and_enter_string } ;


function enter_and_release_string(*str: string): string*);
  { enter the given string, and release the original pointer }
  var
    new_string: xtring;    { string from the table }
begin
  new_string := enter_string(str);

  if new_string <> str then release_string(str);

  enter_and_release_string := new_string;
end { enter_and_release_string } ;

  
function enter_string(*str: string): string*);
  { enter or find the string in the string hash table and return it.
    If not found in the table, the string's value is copied to a new
    string created afresh. }
  var
    i: string_range;           { index into STR }
    sum: natural_number;       { checksum of the string }
    index: hash_string_range;  { index into the string table }
    last,                      { last element checked in list }
    element: hash_string_ptr;  { element in the list of names }
    compare: compare_type;     { result of string compare }
    done: boolean;             { TRUE when place in table found }


  procedure insert_entry(list_element: hash_string_ptr);
    { insert a new entry after the given list element.  If the list element
      is NIL, insert at the head of the list. }
    var
      new_element: hash_string_ptr; { new element to be placed into the list }
  begin
    new(new_element);
    increment_heap_count(HEAP_HASH_STRINGS, 2*POINTER_SIZE);

    new_element^.str := nullstring;
    copy_string(str, new_element^.str);
    if list_element = NIL then
      begin
        new_element^.next_hash_string := string_table[index];
        string_table[index] := new_element;
      end
    else
      begin
        new_element^.next_hash_string := list_element^.next_hash_string;
        list_element^.next_hash_string := new_element;
      end;

    enter_string := new_element^.str;
  end { insert_entry } ;


begin { enter_string }
  if (str = NIL) then enter_string := nullstring
  else if ord(str^[0]) = 0 then enter_string := nullstring
  else
    begin
      { create a hash index from the specified name }

      sum := 0;  i := 0;
      for i := 1 to ord(str^[0]) do
         sum := sum + ord(str^[i]);

      index := sum MOD (HASH_STRING_TABLE_SIZE+1);

      element := string_table[index];
      if element = NIL then insert_entry(NIL)
      else
        begin
          last := NIL;  done := FALSE;
          repeat
            if element^.next_hash_string = NIL then
              begin
                done := TRUE;
                compare := compare_strings(str, element^.str);
              end
            else
              begin
                compare := compare_strings(str, element^.str);
                if compare <> GT then done := TRUE
                else
                  begin
                    last := element;  element := element^.next_hash_string;
                  end;
              end;
          until done;

          case compare of
            LT:  insert_entry(last);
            EQ:  enter_string := element^.str;
            GT:  insert_entry(element);
          end;
        end;
    end;
end { enter_string } ;


(**)     { ------- identifier name routines ------- }


function compare_identifiers(id1, id2: name_ptr): compare_type;
  { compare the 2 names and return the result }
begin
  if (id1 = NIL) or (id2 = NIL) then 
    begin
      assert(221 { nil name passed });
      writeln(cmplog, ' compare_identifiers');
      if id1 <> NIL then compare_identifiers := GT 
      else if id2 <> NIL then compare_identifiers := LT 
      else compare_identifiers := EQ;
    end
  else if (id1^.name < id2^.name) then compare_identifiers := LT
  else if (id1^.name = id2^.name) then compare_identifiers := EQ
  else compare_identifiers := GT;
end { compare_identifiers } ;


function enter_name(*name: alpha): name_ptr*);
  { enter or find the name in the name hash table and return a pointer }
  var
    i: 0..ID_LENGTH;           { index into NAME }
    sum: natural_number;       { checksum of the name }
    index: name_table_range;   { index into the name table }
    last,                      { last element checked in list }
    element: name_ptr;         { element in the list of names }
    done: boolean;             { TRUE when end of alpha found }


  procedure insert_entry(list_element: name_ptr);
    { insert a new entry after the given list element.  If the list element
      is NIL, insert at the head of the list. }
    var
      new_element: name_ptr;  { new element to be placed into the list }
  begin
    new(new_element);
    increment_heap_count(HEAP_NAME_ENTRY,
                         2*POINTER_SIZE+ALPHA_SIZE+2*INT_SIZE);

    new_element^.name := name;
    new_element^.kind := default_attributes;
    new_element^.definition := nullstring;
    new_element^.sy := NULLSY;

    if list_element = NIL then
      begin
        new_element^.next := name_table[index];
        name_table[index] := new_element;
      end
    else
      begin
        new_element^.next := list_element^.next;
        list_element^.next := new_element;
      end;

    enter_name := new_element;
  end { insert_entry } ;


begin { enter_name }
  { create a hash index from the specified name }

  sum := 0;  i := 0;  done := FALSE;
  while (i < ID_LENGTH) and not done do
    begin
      i := i + 1;
      if name[i] = ' ' then done := TRUE else sum := sum + ord(name[i]);
    end;
  index := sum MOD (name_table_size+1);

  element := name_table[index];
  if element = NIL then insert_entry(NIL)
  else
    begin
      last := NIL;
      while (name > element^.name) and (element^.next <> NIL) do
        begin  last := element;  element := element^.next;  end;
      if name = element^.name then enter_name := element
      else if name < element^.name then insert_entry(last)
      else insert_entry(element);
    end;
end { enter_name } ;


function name_from_string(s: xtring): name_ptr;
  { assume that resulting id is legal }
  var
    n: alpha;
begin
  if (s = NIL) then name_from_string := null_name
  else
    begin
      copy_from_string(s, n);
      name_from_string := enter_name(n);
    end;
end { name_from_string } ;


(**)     { ------- property utilities ------- }


procedure new_property(var p: property_ptr);
  { create a new property element }
begin
  if free_properties <> NIL then
    begin
      p := free_properties;  free_properties := p^.next;
      if not p^.free then
        begin
          writeln(Monitor, 'ASSERT: Non-free property in free list');
          p:=NIL; p^.next:=NIL;  { blow up }
        end;
    end
  else
    begin
      new(p);
      increment_heap_count(HEAP_PROPERTY, 3*POINTER_SIZE);
    end;

  p^.next := NIL;  p^.text := nullstring;
  p^.free := FALSE;
end { new_property } ;


procedure release_property(var p: property_ptr);
  { release a property element for later reuse }
begin
  if debug_29 then writeln(outfile, 'release_property ',ord(p):1);
  if p <> NIL then
    begin
      if p^.free then
        if debug_30 then
          begin
            writeln(Monitor, 'ASSERT: Releasing free property to free list');
            p := NIL;  p^.next := NIL; { blow up }
          end
        else p := NIL { and do nothing else -- a HORRIBLE band-aid }
      else
        begin
          p^.free := TRUE;
          p^.next := free_properties;  free_properties := p;  p := NIL;
        end;
    end;
end { release_property } ;


procedure release_entire_property_list(var list: property_ptr);
  { release every element of the given property list }
  var
    next: property_ptr;    { next property to be released }
begin
  while list <> NIL do
    begin
      next := list^.next;
      release_property(list);
      list := next;
    end;
end { release_entire_property_list } ;


procedure delete_property(var p: property_ptr);
  { releases p, returning p^.next }
  var
    next: property_ptr;  { saves return value }
begin
  next := p^.next;
  p^.next := free_properties;
  free_properties := p;
  p := next;
end { delete_property } ;


procedure add_to_prop_list(var prop_list: property_ptr;
                           property_name: name_ptr;
                           property_value: xtring);
  { add the given property to head of prop_list }
  var
    P: property_ptr;      { new property created }
begin
  new_property(P); 
  P^.name := property_name;  P^.text := property_value;
  P^.next := prop_list;  prop_list := P;
end { add_to_prop_list } ;


function find_property(*prop_list: property_ptr;  name: name_ptr;
                       var property: property_ptr): boolean*);
  { look for the given property in an unordered list of properties }
  var
    prop: property_ptr;       { current property element }
    found: boolean;           { TRUE when property found }
begin
  property := NIL;  prop := prop_list;  found := FALSE;
  while (prop <> NIL) and not found do
    if prop^.name = name then
      begin  property := prop;  found := TRUE;  end
    else  prop := prop^.next;

  find_property := found;
end { find_property } ;


function find_bit_property(prop_list: bit_property_ptr;  name: name_ptr;
                           var property: bit_property_ptr): boolean;
  { look for the given property in an unordered list of properties }
  var
    prop: bit_property_ptr;   { current property element }
    found: boolean;           { TRUE when property found }
begin
  property := NIL;  prop := prop_list;  found := FALSE;
  while (prop <> NIL) and not found do
    if prop^.name = name then
      begin  property := prop;  found := TRUE;  end
    else  prop := prop^.next;

  find_bit_property := found;
end { find_bit_property } ;


procedure check_and_add_to_prop_list(var dest: property_ptr;
                                     name: name_ptr;  text: xtring);
  { add the given property to the DEST property list.  If the property is
    already in the list, add it only if the property values are different. }
  var
    prop: property_ptr;    { property returned from search }
    skip_it: boolean;      { TRUE iff same name, value alread in list }
    found: boolean;        { Prevents extra call to find_property }
begin
  prop := dest;  skip_it := FALSE;
  repeat
    found := find_property(prop, name, prop);
    if found then
      if prop^.text = text then skip_it := TRUE
                           else prop := prop^.next;
  until skip_it or not found;
  if not skip_it then add_to_prop_list(dest, name, text);
end { check_and_add_to_prop_list } ;


function end_of_property_list(list: property_ptr): property_ptr;
  { find the end of the list and return a pointer to it }
  var
    PP,                         { current property list element }
    last: property_ptr;         { previous property list element }
begin
  PP := list;  last := NIL;
  while PP <> NIL do
    begin  last := PP;  PP := PP^.next;  end;
  end_of_property_list := last;
end { end_of_property_list } ;


function compare_properties(list1, list2: property_ptr): compare_type;
  { compare the two property lists and return a compare type: EQ if
    the property lists are the same; GT if they are not }
  var
    p1, p2: property_ptr;      { current properties for compare }
    equal_so_far: boolean;     { TRUE if property lists are equal so far }
begin
  p1 := list1;  p2 := list2;  compare_properties := GT;  equal_so_far := TRUE;
  while (p1 <> NIL) and (p2 <> NIL) and equal_so_far do
    if p1^.name <> p2^.name then equal_so_far := FALSE
    else if p1^.text <> p2^.text then equal_so_far := FALSE
    else
      begin  p1 := p1^.next;  p2 := p2^.next;  end;
  if equal_so_far then
    if p1 <> p2 then compare_properties := GT
                else compare_properties := EQ;
end { compare_properties } ;


procedure copy_properties(source_list: property_ptr;
                          var dest_list: property_ptr);
  { copy the source list to the destination list }
  var
    source: property_ptr;      { source property to copy }
begin
  source := source_list;
  while source <> NIL do
    begin
      add_to_prop_list(dest_list, source^.name, source^.text);
      source := source^.next;
    end;
end { copy_properties } ;


procedure copy_inherit_pin_properties(var dest_list: property_ptr;
                                      source_list: property_ptr);
  { copy properties from the source list to the dest list if they have the
    INHERIT_PIN attribute.  Duplicate properties in the dest list are OK. }
  var
    source_prop: property_ptr;       { current source property }
begin
  source_prop := source_list;
  while source_prop <> NIL do
    begin
      if INHERIT_PIN IN source_prop^.name^.kind then
        add_to_prop_list(dest_list, source_prop^.name, source_prop^.text);

      source_prop := source_prop^.next;
    end;
end { copy_inherit_pin_properties } ;


procedure copy_specific_properties(which: name_type_set;
                                   var dest: property_ptr;
                                   source: property_ptr);
  { copy only those properties with the specified attributes from the SOURCE
    property list to the DEST property list.  If more than one attribute is
    specified, any attribute present will cause the property to be copied.
    If the property already exists, it is not copied again if its value is
    the same as the one already present. }
  var
    current,                  { current property to be copied }
    prop: property_ptr;       { property returned from search }
begin
  current := source;
  while current <> NIL do
    begin
      if (current^.name^.kind * which) <> [] then
        if find_property(dest, current^.name, prop) then
          if prop^.text = current^.text then
            { do not copy, leave as is }
          else
            add_to_prop_list(dest, current^.name, current^.text)
        else
          add_to_prop_list(dest, current^.name, current^.text);
      current := current^.next;
    end;
end { copy_specific_properties } ;


procedure dump_property_list(var f: textfile; list: property_ptr);
  { dump the given property list to the given file }
  var
    PP: property_ptr;      { current property to be output }
begin
  PP := list;
  while PP <> NIL do
    with PP^ do
      begin
        write(f, '    ');
        writealpha(f, name^.name);
        write(f, '=');
        writestring(f, text);
        if next = NIL then writeln(f, ';') else writeln(f, ',');

        PP := next;
      end;

  if list = NIL then writeln(f);     { this is a KLUDGE! }
end { dump_property_list } ;


(**)     { ------- heap management routines ------- }


{----------------------------------------------------------------------------}
{  The NEW procedures fall into two types:  those that create a new element  }
{  of the particular type and return it, and those that create the element   }
{  and return it as the first element of the list passed in.  Every NEW      }
{  procedure increments a count of the heap space used so that a structure   }
{  by structure accounting can be reported.                                  }
{                                                                            }
{  The RELEASE procedures take the given element and add it to a list of     }
{  free elements.  The associated NEW procedures will remove the element     }
{  from the free list rather than creating one from the heap.  The RELEASE   }
{  procedures come in three forms:  RELEASE_<structure> releases the single  }
{  element adn adds it to the free list.  RELEASE_ENTIRE_<structure> adds    }
{  all of the elements in a list of elements headed by the given element.    }
{  RELEASE_COMPLETE_<structure> releases all elements of the list headed     }
{  by the given element and all of the fields of the element as well.  This  }
{  never includes STRINGs, NAME_PTRs, SIGNAL_DEFINITIONs,                    }
{  or SIGNAL_INSTANCEs.                                                      }
{  Some of the RELEASE <structure> routines delete the passed element from   }
{  its list (in other words, they return the old value of element^.next)     }
{  others don't do this.  Some of these also release all of their fields     }
{  (with the same exceptions as the RELEASE_COMPLETE) routines.              }
{----------------------------------------------------------------------------}


procedure new_subscript(var subscript_list: subscript_ptr);
  { create a new subscript element and add to head of the list }
  var
    SP: subscript_ptr;     { new subscript being created }
begin
  if free_subscripts <> NIL then
    begin  SP := free_subscripts;  free_subscripts := SP^.next;  end
  else
    begin
      new(SP);  increment_heap_count(HEAP_SUBSCRIPT, POINTER_SIZE+2*INT_SIZE);
    end;

  SP^.left_index := 0;
  SP^.right_index := 0;
  SP^.next := subscript_list;  subscript_list := SP;
end { new_subscript } ;


procedure release_subscript(var sub: subscript_ptr);
  { release a subscript element for later reuse }
begin
  if sub <> NIL then
    begin
      sub^.next := free_subscripts;  free_subscripts := sub;  sub := NIL;
    end;
end { release_subscript } ;


procedure release_entire_subscript(var sub: subscript_ptr);
  { release all the subscripts in the list }
  var
    next: subscript_ptr;    { next subscript to release }
begin
  while sub <> NIL do
    begin  next := sub^.next;  release_subscript(sub);  sub := next;  end;
end { release_entire_subscript } ;


procedure new_subscript_property(var list: subscript_property_ptr);
  { return a new element and add to the beginning of the list }
  var
    sub: subscript_property_ptr;     { new element being created }
begin
  if free_subscript_properties <> NIL then
    begin
      sub := free_subscript_properties;
      free_subscript_properties := sub^.next;
    end
  else
    begin
      new(sub);
      increment_heap_count(HEAP_SUBSCRIPT_PROPERTY,
                           2*POINTER_SIZE+2*INT_SIZE);
    end;

  sub^.left_index := -1;
  sub^.right_index := -1;
  sub^.properties := NIL;
  sub^.next := list;  list := sub;
end { new_subscript_property } ;


procedure release_subscript_property(var sub: subscript_property_ptr);
  { add the given element to the free list }
begin
  if sub <> NIL then
    begin
      sub^.next := free_subscript_properties;
      free_subscript_properties := sub;
      sub := NIL;
    end;
end { release_subscript_properties } ;


procedure release_entire_subscript_property(var sub: subscript_property_ptr);
  { add the given element to the free list }
begin
  if sub <> NIL then
    begin
      sub^.next := free_subscript_properties;
      free_subscript_properties := sub;
      sub := NIL;
    end;
end { release_entire_subscript_property } ;


procedure new_bit_property(var list: bit_property_ptr);
  { create a new element and add to the beginning of the list }
  var
    prop: bit_property_ptr;     { new element to be created and returned }
begin
  if free_bit_properties <> NIL then
    begin
      prop := free_bit_properties;  free_bit_properties := prop^.next;
    end
  else
    begin
      new(prop);
      increment_heap_count(HEAP_BIT_PROPERTY, 4*POINTER_SIZE);
    end;

  prop^.bit_subscript := NIL;
  prop^.name := null_name;
  prop^.text := nullstring;
  prop^.next := list;  list := prop;
end { new_bit_property } ;


procedure release_bit_property(var prop: bit_property_ptr);
  { add the given element to the free list }
begin
  if prop <> NIL then
    begin
      prop^.next := free_bit_properties;
      free_bit_properties := prop;
      prop := NIL;
    end;
end { release_bit_property } ;


procedure release_entire_bit_property_list(var list: bit_property_ptr);
  { release every element of the given property list }
  var
    next: bit_property_ptr;    { next property to be released }
begin
  while list <> NIL do
    begin
      next := list^.next;  release_bit_property(list);  list := next;
    end;
end { release_entire_bit_property_list } ;


procedure new_basescript(var basescript_list: basescript_ptr);
  { create a new basescript element and add to head of the list }
  var
    BSP: basescript_ptr;     { new subscript being created }
begin
  if free_basescripts <> NIL then
    begin  BSP := free_basescripts;  free_basescripts := BSP^.next;  end
  else
    begin
      new(BSP);
      increment_heap_count(HEAP_BASESCRIPT, 2*POINTER_SIZE + 3*INT_SIZE);
    end;

  with BSP^ do
    begin
      next := basescript_list;
      instance := NIL;
      left_index := 0;
      right_index := 0;
      offset := 0;
    end;
  basescript_list := BSP;
end { new_basescript } ;


procedure release_basescript(var BSP: basescript_ptr);
  { release a basescript element for later reuse }
begin
  if BSP <> NIL then
    begin
      BSP^.next := free_basescripts;  free_basescripts := BSP;  BSP := NIL;
    end;
end { release_basescript } ;


procedure release_entire_basescript_list(var list: basescript_ptr);
  { release all of the basescripts in the given list }

  var
    next: basescript_ptr;     { next element in the list }

begin
  while list <> NIL do
    begin
      next := list^.next;
      release_basescript(list);
      list := next;
    end;
end { release_entire_basescript_list } ;


procedure new_base_descriptor(var BD: base_descriptor_ptr);
  { create a new base descriptor }
begin
  if free_base_descriptors <> NIL then
    begin
      BD := free_base_descriptors;  free_base_descriptors := BD^.next;
    end
  else
    begin
      new(BD);
      increment_heap_count(HEAP_BASE_DESCRIPTOR, 2*POINTER_SIZE+2*INT_SIZE);
    end;

  with BD^ do
    begin
      width := 0;
      offset := 0;
      next := NIL;
      instance := NIL;
    end;
end { new_base_descriptor } ;


procedure release_base_descriptor(var BD: base_descriptor_ptr);
  { release a base descriptor for later reuse }
begin
  if BD <> NIL then
    begin
      BD^.next := free_base_descriptors;  free_base_descriptors := BD;
      BD := NIL;
    end;
end { release_basescript } ;


procedure new_signal_descriptor(var signal: signal_descriptor_ptr);
  { create a new signal descriptor }
begin
  if free_signal_descriptors <> NIL then
    begin
      signal := free_signal_descriptors;
      free_signal_descriptors := signal^.next;
    end
  else
    begin
      new(signal);
      increment_heap_count(HEAP_SIGNALDESCR,
                           5*POINTER_SIZE+2*BOOL_SIZE+4*INT_SIZE);
    end;

  with signal^ do
    begin
      next := NIL;
      signal_name := nullstring;
      polarity := NORMAL;
      low_asserted := FALSE;
      scope := UNKNOWN_SCOPE;
      replication_factor := 1;
      kind := UNDEFINED;
      bit_subscript := NIL;
      properties := NIL;
      net_id := nullstring;
      is_const := FALSE;
    end;
end { new_signal_descriptor } ;


procedure release_signal_descriptor(var signal: signal_descriptor_ptr);
  { release a signal descriptor for later reuse }
begin
  if signal <> NIL then
    begin
      signal^.next := free_signal_descriptors;
      free_signal_descriptors := signal;
      signal := NIL;
    end;
end { release_signal_descriptor } ;


procedure release_entire_signal_descriptor(var list: signal_descriptor_ptr);
  { release all signal descriptors in a concatenated list }
  var
    next,                            { next signal to release }
    sig: signal_descriptor_ptr;      { signal to be released }
begin
  sig := list;
  while sig <> NIL do
    begin
      next := sig^.next;  release_signal_descriptor(sig);  sig := next;
    end;
end { release_entire_signal_descriptor } ;


procedure release_complete_signal_descriptor(var sig: signal_descriptor_ptr);
  { release the signal and all of its fields }
begin
  release_entire_property_list(sig^.properties);
  release_entire_subscript(sig^.bit_subscript);
  release_signal_descriptor(sig);
end { release_complete_signal_descriptor } ;


procedure release_complete_SD_list(var sig: signal_descriptor_ptr);
  { release the signal and all of its fields }
  var
    next: signal_descriptor_ptr;
begin
  while sig <> NIL do
    begin
      release_entire_property_list(sig^.properties);
      release_entire_subscript(sig^.bit_subscript);
      next := sig^.next;
      release_signal_descriptor(sig);
      sig := next;
    end;
end { release_complete_SD_list } ;


procedure new_simple_signal(var signal: simple_signal_ptr);
  { create a new simple signal on the heap and return it }
begin
  if free_simple_signals = NIL then
    begin
      new(signal);
      increment_heap_count(HEAP_SIMPLE_SIGNAL, 3*POINTER_SIZE+2*INT_SIZE);
    end
  else
    begin
      signal := free_simple_signals;  free_simple_signals := signal^.next;
    end;

  with signal^ do
    begin
      polarity := NORMAL;
      signal_name := nullstring;
      kind := SINGLE;
      bit_subscript := NIL;
      next := NIL;
    end;
end { new_simple_signal } ;


procedure release_simple_signal(var signal: simple_signal_ptr);
  { add the given signal list to the free list }
begin
  if signal <> NIL then
    begin
      signal^.next := free_simple_signals;  free_simple_signals := signal;
      signal := NIL;
    end;
end { release_simple_signals } ;


procedure new_signal_entry(var entry: signal_entry_ptr);
  { create a new signal entry }
begin
  if free_signal_entrys = NIL then
    begin
      new(entry);
      increment_heap_count(HEAP_SIGNALENTRY, 4*POINTER_SIZE);
    end
  else
    begin
      entry := free_signal_entrys;
      free_signal_entrys := free_signal_entrys^.next;
    end;

  entry^.name := nullstring;
  entry^.high_asserted := NIL;
  entry^.low_asserted := NIL;
  entry^.next := NIL;
end { new_signal_entry } ;


procedure new_signal_definition(var sig: signal_definition_ptr);
  { create a new signal definition and return it }
begin
  if free_signal_definitions <> NIL then
    begin
      sig := free_signal_definitions;
      free_signal_definitions := sig^.next;
    end
  else
    begin
      new(sig);
      increment_heap_count(HEAP_SIGNAL_DEFINITION,
                           9*POINTER_SIZE+3*BOOL_SIZE+6*INT_SIZE);
    end;

  with sig^ do
    begin
      next := NIL;
      stack := NIL;
      signal := NIL;
      is_virtual_base := TRUE;
      next_virtual_def := NIL;
      net_id := nullstring;
      left_index := 0;
      right_index := 0;
      properties := NIL;
      polarity := NORMAL;
      instances := NIL;
      kind := UNDEFINED;
      synonym_bits := NIL;
      is_const := FALSE;
      if scope_is_local then scope := LOCAL else scope := GLOBAL;
      node := NIL;
    end;
end { new_signal_definition } ;


procedure release_signal_definition(var SDP: signal_definition_ptr);
  { release the specified signal definition and add to the free list }
begin
  if SDP <> NIL then
    begin
      SDP^.next := free_signal_definitions;
      free_signal_definitions := SDP;
    end;

  SDP := NIL;
end { release_signal_definition } ;


procedure new_signal_definition_list(var list: signal_definition_list_ptr);
  { create a new signal definition list element and add to head of list }
  var
    SDLP: signal_definition_list_ptr;    { signal definition being created }
begin
  if free_signal_definition_lists <> NIL then
    begin
      SDLP := free_signal_definition_lists; 
      free_signal_definition_lists := SDLP^.next;
    end
  else
    begin
      new(SDLP);
      increment_heap_count(HEAP_SIGNAL_DEFINITION_LIST, 2*POINTER_SIZE);
    end;

  SDLP^.definition := NIL;
  SDLP^.next := list;  list := SDLP;
end { new_signal_definition_list } ;


procedure release_signal_definition_list(var SDLP: signal_definition_list_ptr);
  { release the signal definition list element and add to the free list }
begin
  if SDLP <> NIL then
    begin
      SDLP^.next := free_signal_definition_lists;
      free_signal_definition_lists := SDLP;
      SDLP := NIL;
    end;
end { release_signal_definition_list } ;


procedure release_entire_signal_definition_list
                                       (var list: signal_definition_list_ptr);
  { release all of the elements of the given list }
  var
    next: signal_definition_list_ptr;    { next in the list }
begin
  while list <> NIL do
    begin
      next := list^.next;
      release_signal_definition_list(list);
      list := next;
    end;
end { release_entire_signal_definition_list } ;


procedure new_signal_instance(var instance: signal_instance_ptr);
  { create a new signal instance }
begin
  if free_signal_instances <> NIL then
    begin
      instance := free_signal_instances;
      free_signal_instances := instance^.next;
    end
  else
    begin
      new(instance);
      increment_heap_count(HEAP_SIGNAL_INSTANCE, 3*POINTER_SIZE
                           +BOOL_SIZE+INT_SIZE);
    end;

  with instance^ do
    begin
      next := NIL;
      defined_by := NIL;
      replication_factor := 1;
      bit_subscript := NIL;
      low_asserted := FALSE;
    end;
end { new_signal_instance } ;


procedure release_signal_instance(var instance: signal_instance_ptr);
  { add the given signal signal instance to the free list }
begin
  if instance <> NIL then
    begin
      instance^.next := free_signal_instances;
      free_signal_instances := instance;
      instance := NIL;
    end;
end { release_signal_instance } ;


procedure release_complete_signal_def(var def: signal_definition_ptr);
  { free all the signal instances of the given def.  Release the properties
    of each instance as well as the subscripts.   Release the signal def and
    its properties.  If def is virtual base then release all virtual defs }
  var
    instance,                    { current signal instance being released }
    next: signal_instance_ptr;   { next signal instance to be released }
    vdef: signal_definition_ptr;      { current def/virtual def for release }
    next_vdef: signal_definition_ptr; { next virtual def }

begin
  if def <> NIL then
    begin
      if def^.is_virtual_base then
        begin
          vdef := def^.next_virtual_def;
          while vdef <> NIL do
            begin
              next_vdef := vdef^.next;
              vdef^.is_virtual_base := FALSE; { redundant }
              release_complete_signal_def(vdef);
              vdef := next_vdef;
            end;
        end;
      instance := def^.instances;
      while instance <> NIL do
        begin
          release_entire_subscript(instance^.bit_subscript);

          next := instance^.next;
          release_signal_instance(instance);
          instance := next;
        end;

      def^.instances := NIL;

      release_entire_basescript_list(def^.synonym_bits);
      release_entire_bit_property_list(def^.properties);
      release_signal_definition(def);
    end;
end { release_complete_signal_def } ;


procedure new_synonym_signal(var list: synonym_signal_ptr);
  { create a new signal on the heap and add to the head of the list }
  var
    signal: synonym_signal_ptr;     { new signal to be created }
begin
  if free_synonym_signals = NIL then
    begin
      new(signal);
      increment_heap_count(HEAP_SYNONYM_SIGNAL, 4*POINTER_SIZE+ENUM_SIZE);
    end
  else
    begin
      signal := free_synonym_signals;
      free_synonym_signals := signal^.next;
    end;

  with signal^ do
    begin
      signal_name := nullstring;
      polarity := NORMAL;
      def := NIL;
      used_bits := NIL;
      next := list;  list := signal;
    end;
end { new_synonym_signal } ;


procedure release_synonym_signal(var signal: synonym_signal_ptr);
  { release the given signal (and its used_bits list) and add 
    to the free list }
begin
  if signal <> NIL then
    begin
      release_entire_subscript(signal^.used_bits);
      signal^.next := free_synonym_signals;
      free_synonym_signals := signal;
      signal := NIL;
    end;
end { release_synonym_signal } ;


procedure new_formal_actual_list(var list: formal_actual_ptr);
  { create a new formal/actual list element and add to list }
  var
    FAP: formal_actual_ptr;     { new formal/actual list element }
begin
  if free_formal_actual_lists <> NIL then
    begin
      FAP := free_formal_actual_lists;  free_formal_actual_lists := FAP^.next;
    end
  else
    begin
      new(FAP);
      { assume 2 booleans together are efficiently allocated to share
        the same word }
      increment_heap_count(HEAP_FORMAL_ACTUAL_LIST,
                           5*POINTER_SIZE+2*INT_SIZE+BOOL_SIZE);
    end;

  with FAP^ do
    begin
      next := list;  list := FAP;
      formal_parameter := NIL;
      pin_name := NIL;
      polarity := NORMAL;
      actual_parameter := NIL;
      width := 0;
      properties := NIL;
      uses_NAC := FALSE;
      is_NWC_pin := FALSE;
    end;
end { new_formal_actual_list } ;


procedure release_formal_actual_list(var FAP: formal_actual_ptr);
  { add the given formal/actual list to the free list }
begin
  if FAP <> NIL then
    begin
      FAP^.next := free_formal_actual_lists;
      free_formal_actual_lists := FAP;
      FAP := NIL;
    end;
end { release_formal_actual_list } ;


procedure new_clear_text_actual_list(var list: clear_text_actual_list_ptr);
  { create a new clear text actual list element and add to the given list }
  var
    CTALP: clear_text_actual_list_ptr;       { new element being created }
begin
  new(CTALP);
  increment_heap_count(HEAP_CLEAR_TEXT_ACTUAL_LIST, 4*POINTER_SIZE);

  with CTALP^ do
    begin
      actual_parameter := nullstring;
      properties := NIL;
      net_id := nullstring;
      next := list;  list := CTALP;
    end;
end { new_clear_text_actual_list } ;


procedure new_actual_list(var list: actual_list_ptr);
  { create a new element and add to the head of the given list }
  var
    ALP: actual_list_ptr;      { new element being created }
begin
  if free_actual_lists = NIL then
    begin
      new(ALP);
      increment_heap_count(HEAP_ACTUAL_LIST,
                           2*POINTER_SIZE+INT_SIZE+BOOL_SIZE);
    end
  else
    begin
      ALP := free_actual_lists;  free_actual_lists := ALP^.next;
    end;

  ALP^.signal := NIL;
  ALP^.width_is_unknown := FALSE;
  ALP^.assertion_state := ASSERTION_KNOWN;
  ALP^.next := list;  list := ALP;
end { new_actual_list } ;


procedure release_actual_list(var ALP: actual_list_ptr);
  { release the given element }
begin
  if ALP <> NIL then
    begin
      ALP^.next := free_actual_lists;
      free_actual_lists := ALP;
      ALP := NIL;
    end;
end { release_actual_list } ;


procedure new_bindings_list(var bindings_list: bindings_list_ptr);
{ create a new bindings element and add to head of the list }
  var
    BLP: bindings_list_ptr;     { element being created }
begin
  if free_bindings_lists = NIL then
    begin
      new(BLP);
      increment_heap_count(HEAP_BINDINGSLIST, 4*POINTER_SIZE);
    end
  else
    begin
      BLP := free_bindings_lists;
      free_bindings_lists := free_bindings_lists^.next;
    end;
  with BLP^ do
    begin
      formal_parameter := nullstring;
      pin_properties := NIL;
      actual_parameter := NIL;
      next := bindings_list;  bindings_list := BLP;
    end;
end { new_bindings_list } ;


procedure new_invoke_list(var invoke_list: invoke_list_ptr);
  { create a new invoke element and add to the head of the list }
  var
    ILP: invoke_list_ptr;       { element being created }
begin
  if free_invoke_lists <> NIL then
    begin  ILP := free_invoke_lists;  free_invoke_lists := ILP^.next;  end
  else
    begin
      new(ILP);
      increment_heap_count(HEAP_INVOKELIST, 6*POINTER_SIZE+INT_SIZE);
    end;

  with ILP^ do
    begin
      macro_name := nullstring;
      parameters := NIL;
      properties := NIL;
      bindings := NIL;
      path := nullstring;
      page_number := 1;
    end;

  ILP^.next := invoke_list;  invoke_list := ILP;
end { new_invoke_list } ;


procedure release_invoke_list(var list: invoke_list_ptr);
  { release the given invoke list and add to the free list }
begin
  if list <> NIL then
    begin
      list^.next := free_invoke_lists;
      free_invoke_lists := list;
      list := NIL;
    end;
end { release_invoke_list } ;


procedure new_signal_list(var signal_list: signal_list_ptr);
  { create a new signal list element and add to the head of the list }
  var
    SLP: signal_list_ptr;       { element being created }
begin
  if free_signal_lists = NIL then
    begin
      new(SLP);  increment_heap_count(HEAP_SIGNALLIST, 2*POINTER_SIZE);
    end
  else
    begin
      SLP := free_signal_lists;
      free_signal_lists := free_signal_lists^.next;
    end;

  SLP^.signal_name := nullstring;
  SLP^.next := signal_list;  signal_list := SLP;
end { new_signal_list } ;

    
procedure new_macro_def(var MDP: macro_def_ptr);
  { create a new macro definition }
begin
  if free_macro_defs = NIL then
    begin
      new(MDP);
      increment_heap_count(HEAP_MACRODEF, 9*POINTER_SIZE+2*BOOL_SIZE);
    end
  else
    begin
      MDP := free_macro_defs;
      free_macro_defs := free_macro_defs^.next;
    end;

  with MDP^ do
    begin
      next := NIL;
      macro_name := nullstring;
      version := NIL;
      occurances := NIL;
      params := NIL;
      properties := NIL;
      text_macros := NIL;
      written_with_GED := TRUE;
      is_leaf_macro := FALSE;
      invokes := NIL;
    end;
end { new_macro_def } ;
        

procedure new_mtree_node(var mtree_list: mtree_node_ptr);
  { create a new mtree node and add to the head of the list }
  var
    new_mtree: mtree_node_ptr;     { node being created }
begin 
  if free_mtree_nodes = NIL then
    begin
      new(new_mtree);
      increment_heap_count(HEAP_MTREENODE, 
                           10*POINTER_SIZE+3*BOOL_SIZE+2*INT_SIZE);
    end
  else
    begin
      new_mtree := free_mtree_nodes;
      free_mtree_nodes := free_mtree_nodes^.next;
    end;

  total_number_nodes := total_number_nodes + 1;

  with new_mtree^ do
    begin
      macro := NIL;
      macro_name := nullstring;
      called_by := NIL;
      next_node_with_same_mdef := NIL;
      father_node := NIL;
      level := 0;
      x_value := 0;
      params := NIL;
      signals := NIL;
      symbol_table := NIL;
      is_plumbing_node := FALSE;
      is_cardinal_tap := FALSE;
      is_leaf_node := FALSE;
      uses_SIZE_property := FALSE;
      son := NIL;
    end;

  new_mtree^.next := mtree_list;  mtree_list := new_mtree;
end { new_mtree_node } ;


procedure new_propertied_CS(var PCSP: propertied_CS_ptr);
  { create a new propertied concatenated signal return it }
begin
  if free_propertied_CSs <> NIL then
    begin
      PCSP := free_propertied_CSs;
      free_propertied_CSs := PCSP^.next;
    end
  else
    begin
      new(PCSP);
      increment_heap_count(HEAP_PROPERTIED_CONCATSIG,
                           3*POINTER_SIZE+INT_SIZE);
    end;

  PCSP^.next := NIL;
  PCSP^.instance := NIL;
  PCSP^.properties := NIL;
  PCSP^.control := NORMAL_SIGNAL;
end { new_propertied_CS } ;


procedure release_propertied_CS(var CSP: propertied_CS_ptr);
  { release a propertied concatenated signal for later reuse }
begin
  if CSP <> NIL then
    begin
      CSP^.next := free_propertied_CSs;
      free_propertied_CSs := CSP;
      CSP := NIL;
    end;
end { release_propertied_CS } ;


procedure release_entire_propertied_CS(var list: propertied_CS_ptr);
  { release all elements in a propertied concatenated signal list }
  var
    next: propertied_CS_ptr;    { next element to be released }
begin
  while list <> NIL do
    begin
      next := list^.next;
      release_propertied_CS(list);  list := next;
    end;
end { release_entire_propertied_CS } ;


procedure release_complete_propertied_CS(var list: propertied_CS_ptr);
  { release all elements in the list as well as its fields }
  var
    next_signal: propertied_CS_ptr;    { next signal in the list }
begin
  while list <> NIL do
    begin
      release_entire_property_list(list^.properties);

      next_signal := list^.next;
      release_propertied_CS(list);
      list := next_signal;
    end;
end { release_complete_propertied_CS } ;


procedure release_complete_actual_list(var list: actual_list_ptr);
  { release all elements in the given list and all of its fields as well }

  var
    next_actual: actual_list_ptr;    { next actual in the list }
begin
  while list <> NIL do
    begin
      release_complete_propertied_CS(list^.signal);

      next_actual := list^.next;
      release_actual_list(list);
      list := next_actual;
    end;
end { release_complete_actual_list } ;


procedure release_complete_formal_actual_list(var list: formal_actual_ptr);
  { release all of the formal actual elements in the given list and all of
    its fields as well. }
  var
    next_formal_actual: formal_actual_ptr;  { next pair in list }
begin
  while list <> NIL do
    begin
      release_complete_actual_list(list^.actual_parameter);

      release_entire_subscript_property(list^.properties);

      next_formal_actual := list^.next;
      release_formal_actual_list(list);
      list := next_formal_actual;
    end;
end { release_complete_formal_actual_list } ;


procedure new_file_list(var list: file_list_ptr);
  { create a new element and add to the head of the list }
  var
    FLP: file_list_ptr;     { new element created for the list }
begin
  new(FLP);
  increment_heap_count(HEAP_FILE_LIST, 2*POINTER_SIZE);

  FLP^.next := list;  list := FLP;
  FLP^.file_name := nullstring;
end { new_file_list } ;


procedure new_net_descriptor(var net: net_descriptor_ptr);
  { create a new net descriptor, init, and return }
begin
  if free_net_descriptors <> NIL then
    begin
      net := free_net_descriptors;
      free_net_descriptors := net^.next;
    end
  else
    begin
      new(net);
      increment_heap_count(HEAP_NET_DESCRIPTOR, 4*POINTER_SIZE);
    end;

  net^.next := NIL;
  net^.net_name := nullstring;
  net^.properties := NIL;
  net^.net_id := nullstring;
end { new_net_descriptor } ;


procedure release_net_descriptor(var net: net_descriptor_ptr);
  { release the given net and add to free list }
begin
  if net <> NIL then
    begin
      net^.next := free_net_descriptors;
      free_net_descriptors := net;
      net := NIL;
    end;
end { release_net_descriptor } ;


procedure new_net_table(var table: net_table_ptr);
  { create a new net table type, init, insert, and return }
  var
    i: net_group_range;      { index into the net table }
    newone: net_table_ptr;   { new element }
begin
  if free_net_tables <> NIL then
    begin
      newone := free_net_tables;
      free_net_tables := newone^.next;
    end
  else
    begin
      new(newone);
      increment_heap_count(HEAP_NET_TABLE, (NET_GROUP_SIZE+3)*POINTER_SIZE);
    end;

  newone^.next := table;  table := newone;
  table^.group_number := 0;
  for i := 0 to NET_GROUP_SIZE do
    table^.nets[i] := NIL;
end { new_net_table } ;


procedure release_net_table(var table: net_table_ptr);
  { release the given net table }
begin
  if table <> NIL then
    begin
      table^.next := free_net_tables;
      free_net_tables := table;
      table := NIL;
    end;
end { release_net_table } ;


procedure release_entire_net_table(var table: net_table_ptr);
  { release all elements in the given table and add to free list }
  var
    index: net_group_range;    { index into the net table }
    next: net_table_ptr;       { next table in the list }
begin
  while table <> NIL do
    begin
      next := table^.next;
      for index := 0 to NET_GROUP_SIZE do
        release_net_descriptor(table^.nets[index]);
      release_net_table(table);

      table := next;
    end;
end { release_entire_net_table } ;


(**)     { ------- symbol table routines ------- }


function found_id(node: mtree_node_ptr; name: name_ptr;
                  var id: identifier_ptr): boolean;
  { look for the given id (NAME) in the symbol table of the given node (NODE)
    and return a pointer to it if found.  Return TRUE if found.  Return FALSE
    if not present in the table and return ID = NIL.  It is assumed that the
    symbol table is not sorted in any way. }
  var
    current_id: identifier_ptr;  { current ID in the symbol table }
    found: boolean;              { TRUE if name found in symbol table }
begin
  id := NIL;  found := FALSE;
  if node <> NIL then
    begin
      current_id := node^.symbol_table;
      while (current_id <> NIL) and not found do
        if current_id^.name = name then found := TRUE
        else
          current_id := current_id^.next;

      id := current_id;
    end;

  found_id := found;
end { found_id } ;
      
  
procedure enter_id(node: mtree_node_ptr; name: name_ptr;
                   var id: identifier_ptr);
  { enter the given name (NAME) into the symbol table of the given node
    (NODE).  Return a pointer to the symbol table entry (ID).  If the name
    is already in the table, return ID = NIL. }
begin
  if found_id(node, name, id) then id := NIL
  else
    begin
      new_identifier(id);
      id^.name := name;
      id^.next := node^.symbol_table;
      node^.symbol_table := id;
    end;
end { enter_id } ;


function search_id(id_name: name_ptr): xtring;
  { search the current symbol table (CURRENT_MTREE_NODE) for the given name.
    If name is not found, return nullstring else return a pointer to its
    value. }
  var
    id: identifier_ptr;            { entry in symbol table }
    val: xtring;                   { return value }


  function add_default_SIZE_to_symbol_table: xtring;
    { report an error that the SIZE property was not found and add its
      default value to the given symbol table.  Also, if this is not the
      root drawing, add SIZE to the parameter list of the invoke (so that
      it will become part of the context of the invoke).  Issue the
      appropriate message. }
    var
      id: identifier_ptr;     { entry in the symbol table }
      curr: mtree_node_ptr;   { follows path up to root }
  begin
    enter_id(current_mtree_node, SIZE_prop_name, id);

    id^.definition := default_SIZE_string;

    { If the drawing is size replicated then we only need to handle the
      error message and parameter addition for one replication of the node;
      so we pick the direct descendents of mtree_root for this treatment. }

    curr := current_mtree_node;
    while curr^.father_node <> NIL do curr := curr^.father_node;
    if curr = mtree_root then
      if (current_mtree_node^.called_by <> NIL) then
        begin
          add_to_prop_list(current_mtree_node^.called_by^.parameters,
                           SIZE_prop_name, default_SIZE_string);
	  if not selecting_module then
            begin
              error(196 { SIZE property was not found });
              error_dump_current_parse_environment;
	    end;
        end
      else 
        if not selecting_module then
	  error(108 { No SIZE in context for SIZEd drawing });
	  { don't emit message while processing selection expressions }

    add_default_SIZE_to_symbol_table := default_SIZE_string;
  end { add_default_SIZE_to_symbol_table } ;


begin { search_id }
  val := nullstring;

  if found_id(current_mtree_node, id_name, id) then val := id^.definition

  else if parameter_attributes * id_name^.kind <> [] then
    begin
      if id_name = SIZE_prop_name then
        val := add_default_SIZE_to_symbol_table;
    end;

  if val = nullstring then
    if UNRESERVED in id_name^.kind then val := id_name^.definition;

  { if this ID is SIZE then flag same in current symbol table }

  if id_name = SIZE_prop_name then
    current_mtree_node^.uses_SIZE_property := TRUE;

  search_id := val;
end { search_id } ;


(**)     { ------- current parse string output (error) ------- }


procedure print_input_line(var f: textfile; error_num: error_range;
                           indent: boolean);
  { print the input parse line to the given file. If indent, then
    indent 2 extra spaces. }
  var
    base_of_stack: stack_index_range;  { position in stack of base string }
    done: boolean;                     { TRUE when stack dump complete }
    position: string_range;            { position to print pointer (^) }
    base_pos,                          { starting position of current string }
    curr_pos: string_range;            { current output string length }


  procedure output_parse_string(stack_pos: natural_number);
    { outdut the parse string, expanding current text macro }
    var
      start: string_range;        { start of last half of parse string }
      i: string_range;            { index into the string }
  begin
    if (stack_pos > stack_top) or (stack_pos = 0) then
      begin
        dump_string(f, instring);
        curr_pos := curr_pos + ord(instring^[0]);
      end
    else
      with stack[stack_pos] do
        begin
          if stack_pos = base_of_stack then
            begin
              dump_string(f, str);
              writeln(f);  write(f, ' ');
            end;

          for i := 1 to last_pos do write(f, str^[i]);

          curr_pos := curr_pos + last_pos;
          i := last_pos+1;
          while (i < line_pos) and (str^[i] = ' ') do
            begin  write(f, ' ');  curr_pos := curr_pos + 1;  i := i+1;  end;

          base_pos := curr_pos;
          if (stack_pos < max(stack_top, parse_stack_pointer)) then
	    output_parse_string(stack_pos+1);

          if (state = FGOT_CHAR) and (pos < ord(str^[0])) then start := pos
                                                          else start := pos+1;
          for i := start to ord(str^[0]) do
            begin  write(f, str^[i]);  curr_pos := curr_pos + 1;  end;
        end;
  end { output_parse_string } ;


begin { print_input_line }
  curr_pos := 0;  base_pos := 0;  done := FALSE;
  base_of_stack := stack_top;
  if parse_stack_pointer > stack_top then
    begin
      base_of_stack := parse_stack_pointer;
      if how_to_parse <> PARSE_TRANSPARENTLY then done := TRUE
      else base_of_stack := base_of_stack - 1
    end;
  while (base_of_stack > 0) and not done do
    if stack[base_of_stack].how <> PARSE_TRANSPARENTLY then done := TRUE
    else base_of_stack := base_of_stack - 1;

  if indent then write(f, '   ')
            else write(f, ' ');

  output_parse_string(base_of_stack);
  writeln(f);

  { LAST_SYM_POS points to last character preceding current symbol.  If the
    the compiler does not understand the current symbol, the pointer should
    point to the 1st place in the symbol (e.g., expected > ), hence, need to
    use LAST_SYM_POS+1.  If READ_STATE = FINPUT, then LINE_POS points to the
    last character read in and should be used as is.  If READ_STATE = 
    FGOT_CHAR, then LINE_POS points to the character following the last char
    read in.  If, however, LINE_POS points to the last position in the string,
    use it as is. }

  if parse_stack_pointer <= stack_top then position := 0
  else
    if error_num IN scan_past_errors then position := last_sym_pos+1
    else
      if read_state = FINPUT then position := line_pos
      else
        if line_pos = ord(instring^[0]) then position := line_pos
        else if line_pos > 1 then position := line_pos-1
                             else position := line_pos;

  position := position {in line} + base_pos {text macro} + 1 {leading space};
  if indent then position := position + 2 { indentation };
  if sy = ENDOFDATASY then position := position + 1;
  if position > 1 then writeln(f, error_position_char:position)
                  else writeln(f, ' ', error_position_char);
end { print_input_line } ;


(**)     { ------- parse stack utilities ------- }


procedure dump_parse_state(var f: textfile; heading: boolean);
  { dump the current state of the parse stack for debugging purposes.
    If heading, then preceed the dump with a heading. }
  const
    INDENT1 = 10;  { Number of chars written before calling dump...element }
    INDENT2 = 11;  { Additional chars written before writing quoted string }
  var
    i: stack_index_range;


  procedure dump_current_string;
    { dump info for current parse string in this format }
  begin
    { Write misc data }

    write(f, ord(read_state):1); write(f, ' ');
    if islegal[last_char] then write(f, last_char)
                          else write(f, ' ');
    write(f, ' ');
    write(f, ord(sy):2);  write(f, ' ');
    case how_to_parse of
      PARSE_TRANSPARENTLY: write(outfile, 'T');
      PARSE_SEPARATELY: write(outfile, 'S');
    end { case } ;
    write(f, ' ');
    if allow_TM_expansion then write(f, 'T ')
                          else write(f, 'F ');

    { Write string }

    writestring(f, instring);  writeln(f, ' (instring)');

    { Indicate position of linepos and last_sym_pos }

    write(f, ' ':(INDENT1 + INDENT2 + min(last_sym_pos, line_pos)));
    if last_sym_pos = line_pos then write(f, '^')
    else if last_sym_pos < line_pos then
      begin
        write(f, 'S');
        if line_pos > (last_sym_pos + 1) then
          write(f, ' ':(line_pos - last_sym_pos - 1));
        write(f, '^');
      end
    else
      begin
        write(f, '^');
        if last_sym_pos > (line_pos + 1) then
          write(f, ' ':(last_sym_pos - line_pos - 1));
        write(f, 'S');
      end;
   { write(f, '(pos=', line_pos:1, 'sym=', last_sym_pos:1, ')'); }
    writeln(f);
  end { dump_current_string } ;


  procedure dump_parse_stack_element(i: stack_index_range);
    { dump the ith element of the stack }
  begin { dump_parse_stack_element }
    if i <= 0 then
      begin
        writeln(f, ' ':INDENT2, '<', i:1, '>');
      end
    else if i > stack_top then
      if i = parse_stack_pointer then dump_current_string
      else
        begin
          writeln(f, ' ': INDENT2, '<UNDEFINED>');
        end
    else with stack[i] do
      begin
        { Write misc data }

        write(f, ord(state):1); write(f, ' ');
        if islegal[last] then write(f, last)
                         else write(f, ' ');
        write(f, ' ');
        write(f, ord(symbol):2);  write(f, ' ');
        case how of
          PARSE_TRANSPARENTLY: write(outfile, 'T');
          PARSE_SEPARATELY: write(outfile, 'S');
        end { case } ;
        write(f, ' ');
        if allow_TM then write(f, 'T ')
                    else write(f, 'F ');

        { Write string }

        writestring(f, str);  writeln(f);

        { Indicate position of linepos and last_sym_pos }

        write(f, ' ':(INDENT1 + INDENT2 + min(last_pos, pos)));
        if last_pos = pos then write(f, '^')
        else if last_pos < pos then
          begin
            write(f, 'S');
            if pos > (last_pos + 1) then write(f, ' ':(pos - last_pos - 1));
            write(f, '^');
          end
        else
          begin
            write(f, '^');
            if last_pos > (pos + 1) then write(f, ' ':(last_pos - pos - 1));
            write(f, 'S');
          end;
      { write(f, '(pos=', pos:1, 'sym=', last_pos:1, ')'); }
        writeln(f);
      end;
  end { dump_parse_stack_element } ;


  procedure dump_heading;
    { Dump a heading to describe what happens in dump...element }
  begin
    write(f, ' ':INDENT1);
    writeln(f, 'S L      E');
    write(f, ' ':INDENT1);
    writeln(f, 'T A      X');
    write(f, ' ':INDENT1);
    writeln(f, 'A S  S H P');
    write(f, ' ':INDENT1);
    writeln(f, 'T T  Y O T');
    write(f, ' ':INDENT1);
    writeln(f, 'E C  M W M');
  end;
    

begin
  if heading then dump_heading;
  for i := 0 to max(stack_top, parse_stack_pointer) do
    begin
      if i = stack_top then write(f, ' TOS')
                       else write(f, '    ');
      if i = parse_stack_pointer then write(f, ' SP')
                                 else write(f, '   ');
      if (i = stack_top) or (i = parse_stack_pointer) then write(f, ' ->')
                                                      else write(f, '   ');
      dump_parse_stack_element(i);
    end;
  if stack_top >= parse_stack_pointer then
    begin
      write(f, ' ':INDENT1);
      dump_current_string;
    end;
end { dump_parse_state } ;


procedure parse_string(string_to_parse: xtring; way_to_parse: parse_type);
  { push the given string onto the parse stack }
begin
  if debug_25 then
    begin
      write(outfile, 'enter parse_string(');
      writestring(outfile, string_to_parse);
      case way_to_parse of
        PARSE_TRANSPARENTLY: write(outfile, ', T');
        PARSE_SEPARATELY: write(outfile, ', S');
      end { case } ;
      writeln(outfile, ')');
      dump_parse_state(outfile, TRUE);
    end;

  if (stack_top >= MAX_STACK) or (parse_stack_pointer >= MAX_STACK) then
    error(137 { text macro depth exceeded })
  else
    begin
      if parse_stack_pointer > stack_top then
        stack_top := parse_stack_pointer;

      { save state of current environment }
            
      with stack[parse_stack_pointer] do
        begin
          str      := instring;
          last_pos := last_sym_pos;
          pos      := line_pos;
          state    := read_state;
          last     := last_char;
          symbol   := sy;
          constant := const_val;
          how      := how_to_parse;
          allow_TM := allow_TM_expansion;
          keys     := allowed_key_words;
        end;

      parse_stack_pointer := stack_top + 1;

      instring     := string_to_parse;
      line_pos     := 0;
      last_sym_pos := 0;
      how_to_parse := way_to_parse;
      read_state   := finput;

      if way_to_parse <> PARSE_TRANSPARENTLY then
        begin
          if copy_input then allowed_key_words := []
	                     else allowed_key_words := signal_keysys;
          allow_TM_expansion := TRUE;
        end;

      if debug_25 then
        begin
          writeln(outfile, 'stack after push: ');
          dump_parse_state(outfile, FALSE);
        end;

      insymbol;
    end;
end { parse_string } ;


procedure pop_parsed_string(string_to_pop: xtring);
  { pop the top of the parse string stack until a non-transparent string
    has been popped. }
  var
    done: boolean;       { TRUE when proper string popped }
begin
  if debug_25 then
    begin
      write(outfile, 'enter pop_parsed_string(');
      writestring(outfile, string_to_pop);
      writeln(outfile, ')');
      dump_parse_state(outfile, TRUE);
    end;

  { Get rid of any "virtually" popped signals and get stack into its
    usual parse_stack_pointer = stack_top + 1 configuration. (HACK) }

  if parse_stack_pointer > 0 then stack_top := parse_stack_pointer - 1
  else stack_top := 0;

  if stack_top = 0 then assert(8 { stack underflow })
  else
    begin
      repeat
        done := (instring = string_to_pop) and 
                (how_to_parse <> PARSE_TRANSPARENTLY);
        with stack[stack_top] do
          begin
            if how_to_parse <> PARSE_TRANSPARENTLY then
              begin  sy := symbol;  const_val := constant;  end;
            instring           := str;
            last_sym_pos       := last_pos;
            line_pos           := pos;
            read_state         := state;
            last_char          := last;
            allow_TM_expansion := allow_TM;
            allowed_key_words  := keys;

            how_to_parse := how;
          end;

        stack_top := stack_top - 1;
      until done or (stack_top <= 0);
      
      if not done then assert(157 { oops! });
    end;

  parse_stack_pointer := stack_top + 1;

  if debug_25 then
    begin
      writeln(outfile, 'exit pop_parsed_string with');
      dump_parse_state(outfile, FALSE);
    end;
end { pop_parsed_string } ;


procedure virtual_pop_string;
  { move stack pointer down to next string without actually popping the
    top string.  This allows insymbol to get the next char following the
    last char of its current text macro definition without popping the
    string.  This is done so that if text macro recursion occurs at the
    end of a TM def, the stack will still grow so that infinite recursion
    will be caught.  insymbol fixes the results of this routine before
    when it proceeds on to the next character of the appropriate
    underlying string. }
begin
  if debug_25 then
    begin
      writeln(outfile, 'enter virtual_pop_string with');
      dump_parse_state(outfile, TRUE);
    end;
  if (parse_stack_pointer <= 0) then assert(8 { stack underflow })
  else if how_to_parse <> PARSE_TRANSPARENTLY then 
    begin
      assert(241 { not allowed });
      writeln(cmplog, 'Not parsing transparently');
      if debugging then writeln(outfile, 'Not parsing transparently');
    end
  else
    begin
      if (parse_stack_pointer > (stack_top + 1)) then 
        begin
          assert(241 { illegal });
          writeln(CmpLog, 'stack_top = ', stack_top:1, 
                          ' parse_stack_pointer = ', parse_stack_pointer:1);
          if debugging then
            writeln(Outfile, 'stack_top = ', stack_top:1, 
                    ' parse_stack_pointer = ', parse_stack_pointer:1);
        end;
      if parse_stack_pointer > stack_top then
        begin

          { current instring is not yet in the stack }

          if stack_top >= MAX_STACK then
            begin 
              assert(241 { This should be impossible });
              writeln(CmpLog, 'Uncaught overflow');
              if debugging then writeln(Outfile, 'Uncaught overflow');
              stack_top := MAX_STACK - 1;
            end;

          stack_top := stack_top + 1;
          
          with stack[stack_top] do
            begin
              str      := instring;
              last_pos := last_sym_pos;
              pos      := line_pos;
              state    := read_state;
              last     := last_char;
              symbol   := ENDOFDATASY; { we fell off the end of this string }
              constant := const_val;
              how      := how_to_parse;
              allow_TM := allow_TM_expansion;
              keys     := allowed_key_words;
            end;
        end;

      parse_stack_pointer := parse_stack_pointer - 1;

      with stack[parse_stack_pointer] do
        begin
          instring           := str;
          last_sym_pos       := last_pos;
          line_pos           := pos;
          read_state         := state;
          last_char          := last;
          allow_TM_expansion := allow_TM;
          allowed_key_words  := keys;
          how_to_parse       := how;
        end;
    end;

  if debug_25 then
    begin
      writeln(outfile, 'exit virtual_pop_string with');
      dump_parse_state(outfile, FALSE);
    end;
end { virtual_pop_string } ;


procedure fix_parse_stack;
  { remove wasted "virtually" popped signals from the top of the stack. 
    This is used by insymbol to clean up before returning. When done,
    parse_stack_pointer = stack_top + 1. }
begin
  if debug_25 then
    begin
      writeln(outfile, 'enter fix_parse_stack with');
      dump_parse_state(outfile, TRUE);
    end;
  if parse_stack_pointer <= 0 then 
    begin
      assert(8 { stack underflow !});  parse_stack_pointer := 1;
    end;
  while (stack_top > parse_stack_pointer) do
    begin
      if not ((stack[stack_top].how = PARSE_TRANSPARENTLY) and
             (stack[stack_top].pos >= ord(stack[stack_top].str^[0]))) then
        begin
          assert(241 { these should be spent });
          writeln(CmpLog, 'fix_parse_stack');
          if debugging then writeln(Outfile, 'fix_parse_stack');
          if stack[stack_top].how <> PARSE_TRANSPARENTLY then
            begin
              writeln(CmpLog, 'popping a non transparent string');
              if debugging then 
                writeln(Outfile, 'popping a non transparent string');
            end;
          if stack[stack_top].pos < ord(stack[stack_top].str^[0]) then
            begin
              writeln(CmpLog, 'popping an unspent string');
              writestring(CmpLog, stack[stack_top].str);  writeln(CmpLog);
              write(CmpLog, ' ':(stack[stack_top].pos + 1));
              writeln(Cmplog, '^');
              if debugging then
                begin
                  writeln(Outfile, 'popping an unspent string');
                  writestring(Outfile, stack[stack_top].str);
                  writeln(Outfile);
                  write(Outfile, ' ':(stack[stack_top].pos + 1));
                  writeln(Outfile, '^');
                end;
            end;
        end;
      stack_top := stack_top - 1;
    end;
  if stack_top = parse_stack_pointer then stack_top := stack_top - 1;

  if debug_25 then
    begin
      writeln(outfile, 'exit fix_parse_stack with');
      dump_parse_state(outfile, FALSE);
    end;
end { fix_parse_stack } ;


function fix_signal_name(signal: xtring): xtring;
  { scan the signal name and insert quotes where neccessary to make it
    LR(1), LL(1) parseable. }
  type
    string_range_set = set of string_range;
  var
    stopper,                            { char needed to close string }
    ch: char;                           { current char from SIGNAL }
    const_pos,                          { position of start of constant }
    pos,                                { current position in SIGNAL }
    start,                              { start of the signal name in SIGNAL }
    last,                               { end of the signal name in SIGNAL }
    num_constants,                      { number of constants in signal }
    num_inserts,                        { number of quotes to insert }
    num_double,                         { number of double quotes in signal }
    num_single: string_range;           { number of single quotes in signal }
    insert_positions,                   { places to insert quotes }
    insert_radix: string_range_set;     { places to insert binary radix }
    temp: xtring;                       { string to be returned }
    is_const,                           { TRUE if signal name is a constant }
    finished,                           { TRUE when a signal name found }
    done: boolean;                      { TRUE when entire signal scanned }
    syntax_index: signal_syntax_range;  { index into signal syntax table }
    found_non_digit: boolean;           { TRUE if non digit encountered 
                                          within potential constant }
    found_non_constant_char: boolean;   { TRUE if char not in digits + 
                                          ['(',')',' '] is found in a
					  potential constant }


  procedure read_char;
    { get the next character from SIGNAL.  Return 0 if end of string reached }
  begin
    if pos >= ord(signal^[0]) then ch := chr(EOL)
    else
      begin  pos := pos + 1;  ch := signal^[pos];  end;
  end { read_char } ;


  function previous_char: char;
    { return the previous character in the string }
  begin
    if pos > 1 then previous_char := signal^[pos-1]
               else previous_char := chr(EOL);
  end { previous_char } ;


  function next_char: char;
    { return the next character in the string }
  begin
    if pos < ord(signal^[0]) then next_char := signal^[pos+1]
                             else next_char := chr(EOL);
  end { next_char } ;


  function insert_quotes(signal: xtring): xtring;
    { create a new string.  Copy SIGNAL to it inserting quotes }
    var
     num_quotes,                        { number of quotes in signal }
     source_pos,                        { current position within SIGNAL }
     dest_pos: string_range;            { current position within TEMP }
     in_string: boolean;                { TRUE if within signal name string }
     temp: xtring;                      { string to be returned }
     separator: char;                   { string delimiter char }


    procedure add_char(ch: char);
      { add the character to the output string (TEMP) }
    begin
      dest_pos := dest_pos + 1;  temp^[dest_pos] := ch;
    end { add_char } ;


  begin { insert_quotes }
    if (num_double = 0) and (num_single <> 0) then
      begin  separator := '"';  num_quotes := num_double;  end
    else
      begin  separator := '''';  num_quotes := num_single;  end;
    create_a_string(temp,
                    (ord(signal^[0])+num_inserts+num_quotes+2*num_constants));

    source_pos := 0;  dest_pos := 0;  in_string := FALSE;
    while (source_pos < ord(signal^[0])) and (dest_pos < ord(temp^[0])) do
      begin
        source_pos := source_pos + 1;
        if source_pos IN insert_radix then
          begin  add_char(chr(default_radix + ord('0')));  add_char('#');  end
        else if source_pos IN insert_positions then
          begin  add_char(separator);  in_string := not in_string;  end;
        add_char(signal^[source_pos]);
        if in_string and (signal^[source_pos] = separator) then
          add_char(separator);
      end;
    { take care of special case for end of signal name = end of string }
    if (source_pos+1) IN insert_positions then add_char(separator);

    if (source_pos <> ord(signal^[0])) or (dest_pos <> ord(temp^[0])) then
      assert(7 { some kind of problem here! });
    insert_quotes := temp;
  end { insert_quotes } ;


  procedure skip_past_subscript;
    { skip the subscript }
    var
      num_subscripts: natural_number;      { number of subscripts found }
  begin
    read_char;  num_subscripts := 1;
    repeat
      if ch = '<' then num_subscripts := num_subscripts + 1
      else if ch = '>' then num_subscripts := num_subscripts - 1;
      read_char;
    until (num_subscripts = 0) or (ch = chr(EOL)) or
          (ch = general_property_prefix_char);
    if ch = '>' then read_char;    { eat the '>' }

    while ch = ' ' do read_char;
  end { skip_past_subscript } ;


  procedure scan_until(stopper: char);
    { scan the input until the given character is found.  Then read in the
      next character. }
  begin
    read_char;    { eat the current character (assumed to be = stopper ) }
    while (ch <> stopper) and (ch <> chr(EOL)) do read_char;
    if ch = stopper then read_char
    else
      begin
	error(214 { string not closed });
	error_dump_current_parse_environment;
	error_dump_indent(indent);
	error_dump_alpha('Signal="        ');
	error_dump_string(signal);
	error_dump_char('"');
	error_dump_CRLF;
      end;
  end { scan_until } ;

    
  procedure scan_until_end_of_signal;
    { scan until the end of this signal: another signal, end of string.
      NOTE: Concatenation character is NOT configurable }
    var
      done: boolean;                   { TRUE when end of signal is found }
      stopper: char;                   { stopper character for search }
  begin
    done := (ch = ':') or (ch = chr(EOL));  stopper := ':';
    while not done do
      begin
        if ch = '<' then skip_past_subscript
        else if ch = '''' then scan_until('''')
        else if ch = '"' then scan_until('"')
        else if (ch = chr(EOL)) or (ch = ':') then done := TRUE
        else read_char;
      end;
  end { scan_until_end_of_signal } ;


begin { fix_signal_name }
  if debug then disp_line('enter fix_signal_');

  pos := 0;
  insert_positions := [];
  insert_radix := [];
  num_constants := 0;
  num_single := 0;
  num_double := 0;
  num_inserts := 0;

  read_char;  done := FALSE;
  repeat
    for syntax_index := 1 to SYNTAX_TABLE_SIZE do
      case signal_syntax_table[syntax_index] of

        NEGATION_SPECIFIER:
            begin
              if ch = signal_negation_char then read_char;
              while ch = ' ' do read_char;
            end;

        NAME_SPECIFIER:
            begin
              while ch = ' ' do read_char;
              start := pos;  const_pos := 0;
              stopper := chr(EOL);  is_const := FALSE;
	      found_non_digit := FALSE;  found_non_constant_char := FALSE;
              repeat
                if ch <> ' ' then last := pos;
                if ch = '''' then num_single := num_single + 1
                else if ch = '"' then num_double := num_double + 1;
                if stopper = chr(EOL) then
                  begin
                    if isdigit[ch] and (const_pos = 0) then
                      const_pos := pos
                    else if ch = '#' then
                      if not found_non_digit then is_const := TRUE;
		    if not isdigit[ch] then
		      begin
		        found_non_digit := TRUE;
			if (ch <> '(') and (ch <> ')') and (ch <> ' ') then
			  found_non_constant_char := TRUE;
		      end;
                  end;
                if ch = stopper then stopper := chr(EOL)
                else
                  if stopper = chr(EOL) then
                    if (ch = '''') or (ch = '"') then stopper := ch;
                read_char;
                finished := (ch = chr(EOL));
                if stopper = chr(EOL) then
                  if is_signal_name_terminator[ch] then
                    if not isupper[ch] then finished := TRUE
                    else
                       if not (isupper[previous_char] or 
		               isdigit[previous_char] or
			       (previous_char = '$')) and
                          (  (next_char = ' ') or 
			     (is_signal_name_terminator[next_char] and
			      not isupper[next_char])  ) then
                         finished := TRUE
              until finished;
              if stopper <> chr(EOL) then
                begin
                  error(214 { string not closed });
                  error_dump_current_parse_environment;
                  error_dump_indent(indent);
                  error_dump_alpha('Signal="        ');
                  error_dump_string(signal);
                  error_dump_char('"');
                  error_dump_CRLF;
                end;
  
              if not found_non_constant_char or is_const then
                begin
                  if not is_const then   { does not already have radix spec }
                    begin
                      insert_radix := insert_radix + [const_pos];
                      num_constants := num_constants + 1;
                    end;
                end
              else
                begin
                  { this algorythm blows up when last = MAX_STRING_LENGTH }
                  insert_positions := insert_positions + [start, last+1];
                  num_inserts := num_inserts + 2;
                end;
            end;

        ASSERTION_SPECIFIER:
            if (ch = signal_is_asserted_low_char) or
               (ch = signal_is_asserted_high_char) then
              repeat
                read_char
              until ch <> ' ';

        SUBSCRIPT_SPECIFIER:
            if ch = '<' then skip_past_subscript;

        PROPERTY_SPECIFIER:
            scan_until_end_of_signal;

        NULL_SPECIFIER: ;
      end { case } ;

    if ch = concatenation_char then read_char else done := TRUE;
  until done;

  temp := insert_quotes(signal);
  fix_signal_name := enter_and_release_string(temp);

  if debug then
    begin  writestring(outfile, temp);  writeln(outfile);  end;

  if debug then disp_line('fix_signal_name  ');
end { fix_signal_name } ;


(**)     { ------- lexical analyzer ------- }


procedure insymbol;
  { parse the next token from the input string expanding any text macros
    that are found  If copy_input then ignore tokenization - just expand
    text macros. }
  type
    line_read_type = (NORMAL, CONTINUATION);

  var
    ch,                             { last character read in }
    next: char;                     { the next character in the input stream }
    looking_for_string,             { TRUE if reading in a string }
    done: boolean;                  { TRUE when symbol has been parsed }
    upper_case_on_input: boolean;   { TRUE if upper casing of all characters }
    delimited: boolean;             { TRUE if ch is not proceeded by a legal
                                      identifier char, thus it can begin an
				      identifier if it is a letter.  This is
				      only used if copy_input and not
				      tokenize_params -- it should otherwise
				      be considered undefined. }


  procedure copy_to_buffer(ch: char);
    { copy the character to a global buffer }
  begin
    if (copy_pos < MAX_STRING_LENGTH) and (ch >= ' ') and not copy_error then
      begin
        copy_pos := copy_pos + 1;  copy_buffer[copy_pos] := ch;
      end
    else if not copy_error and (ch >= ' ') then
      begin
        error(116 { too big });  copy_error := TRUE;
      end;
  end { copy_to_buffer } ;


  function get_line(which: line_read_type): boolean;
    { read the next line from the input file.  Return TRUE if a string
      was popped from the stack instead of reading in another line.
      If a string was popped, the state of the lexical analyzer was
      restored from stack.  Otherwise, the character returned is space.
      Don't read in a new line if currently reading a string. }

    var
      pipe_result: read_result;   { condition of line read from pipe }


    procedure read_a_line(var f: inputfile); 
      { read a line from the specified input file }
      const
        END_OF_FILE = 2;
        OVERFLOW_ERR = 1;
        SUCCESS = 0;
      var
        result: 0..2;  { SUCCESS,OVERFLOW,END_OF_FILE returns from C }
    begin
      repeat
        result := creadln(f, instring);
      until (result = END_OF_FILE) or (ord(instring^[0]) > 0);
      case result of
        END_OF_FILE: ch := chr(EOL);
        OVERFLOW_ERR:
          begin
            error(53 { line too long });
            ch := ' ';
          end;
        SUCCESS: ch := ' ';
      end;
    end { read_a_line } ;


  begin { get_line }
    get_line := FALSE;

    if parse_stack_pointer > 1 then       { pop the stack }
      if how_to_parse = PARSE_TRANSPARENTLY then
        begin
          virtual_pop_string;
          get_line := TRUE;

          if copy_input and (read_state = FGOT_CHAR) then
            copy_to_buffer(last_char);
        end
      else
        ch := chr(EOL)    { end of string }

    { don't allow strings to cross lines }

    else if looking_for_string and (which = NORMAL) then
      ch := chr(EOL)

    else
      begin
        case current_file of
          DIRECTIVES_FILE:  read_a_line(infile);
          STANDARD_FILE:    read_a_line(CmpStan);

          CMPDRAW_FILE:
            begin
	      repeat
	        pipe_result := pipe_readln(CmpDraw_pipe, instring);
              until (pipe_result = READ_EOF) or (ord(instring^[0]) <> 0);
	      case pipe_result of
	        READ_EOF: ch := CHR(EOL);
		READ_OVERFLOW: ch := ' ';
		READ_OK: ch := ' ';
	      end;
	    end;

          CMPSCHEM_FILE:    read_a_line(CmpSchemI); 


          UNKNOWN_FILE:     assert(173 { no file has been opened });
        end;
        line_pos := 0;  read_state := FINPUT;
      end;

    if debug then
      begin 
        dump_string(outfile, instring);
        writeln(outfile);
      end;
  end { get_line } ;


  procedure get_char(var ch: char);
    { read the next char from the input buffer } 
    var
      need_a_char: boolean; {  whether or not we still need a character } 
  begin
    repeat
      if parse_stack_pointer <= stack_top then
        if (read_state = FGOT_CHAR) or (line_pos < ord(instring^[0])) then
          begin
            if read_state = finput then last_sym_pos := line_pos
            else
              if line_pos >= 1 then last_sym_pos := line_pos-1
                               else last_sym_pos := 0;
	    fix_parse_stack;
	  end;
      if read_state = FGOT_CHAR then
        begin  ch := last_char;  need_a_char := FALSE;  end
      else
        if (read_state = FINIT) or (line_pos >= ord(instring^[0])) then 
          need_a_char := get_line(NORMAL)
        else
          begin
            line_pos := line_pos + 1;
            ch := instring^[line_pos];
            if (ch = CONTINUATION_CHAR) and (line_pos = ord(instring^[0])) then
              begin
                need_a_char := get_line(CONTINUATION);
                need_a_char := TRUE;
              end
            else
              begin
                if ch = chr(TAB_char) then ch := ' '
                else if not islegal[ch] then
                  begin
                    error(32);  ch := ' ';
                  end
                else if upper_case_on_input then ch := upshift[ch];
                if copy_input then copy_to_buffer(ch);
                need_a_char := FALSE;
              end;
          end;
    until not need_a_char;
    read_state := FINPUT;
    last_char := ch;
  end { get_char } ;


  procedure nextchar(var next: char);
    { get the next char. Set a flag indicating that the next char was read } 
  begin
    get_char(ch);  next := ch;
    if ch <> chr(EOL) then read_state := FGOT_CHAR;
  end { nextchar } ;
        

(**)     { ------- process text macros ------- }


  procedure process_text_macro(text_macro_name: name_ptr);
    { if the given name is really a text macro, then (1) expand it
      (2) log it as an expandable id (ValidCOMPILER, not SCALD compiler). }
    var 
      temp: char_array;            { expanded text macro }
      i,                           { index of temp for copy }
      pos: string_range;           { last character in temp }
      saved_copy_input: boolean;   { save of copy_input global }
      curr_char: char;             { save for last_char global }
      saved_state: parse_state;    { save of read_state }
      TM_def,                      { definition for the text macro passed in }
      str: xtring;                 { TM string to be returned }
      parameter_found: boolean;    { TRUE if parameter found }
      ovf_error: boolean;          { TRUE if TM expands too big }


    procedure init;
      { initialize pointers into the buffers and global flags }
    begin
      pos := 0;
      saved_copy_input := copy_input;
      copy_input := FALSE;
      curr_char := last_char;
      saved_state := read_state;
      read_state := finput;
      parameter_found := FALSE;
      ovf_error := FALSE;
    end { init } ;


    procedure expand_with_parameters(TM_name: name_ptr; definition: xtring);
      { expand the text macro and its parameters }
      type 
        param_range = 1..MAX_TM_PARAMETERS;
        parameters = record
                       parameter_value: alpha;
		       param_name: name_ptr; { defined only if an id }
		       param_tm_def: xtring;
                       parameter_length: 0..ID_LENGTH;
                     end;
      var
        parameter_list: array [param_range] of parameters;  { params read }
        found_error: boolean;             { TRUE if error found }
        i,                                { index used to copy parameter }
        spos: string_range;               { index into text macro defn }
        def_char: char;                   { last char read from definition }
        last_read: 0..max_TM_parameters;  { max last read param number }
        num: {natural_number}integer;     { parameter number needed }


      procedure nextchar(var next: char);
        { get the next character from the text macro definition } 
      begin
        if spos < ord(definition^[0]) then
          begin  spos := spos + 1;  next := definition^[spos];  end
        else next := chr(EOL);
      end { nextchar } ;


      procedure read_parameter_list(parameter_num: param_range);
        { read parameters from the input string until the specified parameter
          is found.  Text macro parameters are delimited with spaces. }
        var
          i: param_range;                { current parameter # }


        procedure eat_separators;
          { swallow up all the separators }
        begin
          while ch = ' ' do get_char(ch);
        end { eat_separators } ;


        procedure check_for_text_macro(parameter_num: param_range);
          { check the parameter just read and see if it is a text macro.  If
            it is, process it.  ValidCOMPILER logs all identifers found here
	    as expandable ids. }
	  

          var
            i: 0..ID_LENGTH;          { index into parameter }
            ok: boolean;              { TRUE if name still identifier }
        begin
          with parameter_list[parameter_num] do
            begin
              i := 0;  ok := TRUE;
              while (i < parameter_length) and ok do
                begin
                  i := i + 1;
                  if not isidentchar[parameter_value[i]] then
                    ok := FALSE;
                end;

              if ok and isupper[parameter_value[1]] then
                begin
                  param_name := enter_name(parameter_value);

                  enter_expandable_id(param_name);

                  if RESERVED in param_name^.kind then
                    param_tm_def := param_name^.definition;

                  if param_tm_def = nullstring then
                    param_tm_def := search_id(param_name);

                  if debug then if param_tm_def <> nullstring then
                    disp_line('found TM         ');
                end;
            end { with } ;
        end { check_for_text_macro } ;


      begin { read_parameter_list }
        for i := last_read+1 to parameter_num do
          with parameter_list[i] do
            begin
              eat_separators;

              parameter_length := 0;  parameter_value := null_alpha;
	      param_name := NIL;  param_tm_def := nullstring;

              while (ch <> ' ') and (ch <> chr(EOL)) do
                if parameter_length >= ID_LENGTH then
                  begin
                    error(43 { too long });
                    while (ch <> ' ') and (ch <> chr(EOL)) do  get_char(ch);
                  end
                else
                  begin
                    parameter_length := parameter_length + 1;
                    parameter_value[parameter_length] := ch;
                    get_char(ch);
                  end;

              if parameter_length > 0 then check_for_text_macro(i)
              else
                begin
                  error(56 { text macro parameter not found });
                  error_dump_text_macro(TM_name);
                  error_dump_indent(indent);
                  error_dump_alpha('Parameter number');
                  error_dump_char('=');
                  error_dump_integer(i);
                  error_dump_CRLF;
                end;
            end;

        last_read := parameter_num;
        parameter_found := TRUE;
      end { read_parameter_list } ;


      procedure display_error;
        { display length error, the macro name, and the definition }
      begin
        error(117 { text macro + parameters is too long });
        error_dump_text_macro(TM_name);
      end { display_error } ;


    begin { expand_with_parameters }
      if TM_depth >= MAX_TM_RECURSION then
        begin
          error(64 { TM recursion depth exceeded });
          error_dump_text_macro(text_macro_name);

          found_error := TRUE;
        end
      else
        found_error := FALSE;

      if not found_error then
        begin
          TM_depth := TM_depth + 1;  spos := 0;  last_read := 0;

          if definition = nullstring then
            begin
              error(110 { undefined text macro });
              error_dump_text_macro(TM_name);
            end;

          while (spos < ord(definition^[0])) and not found_error do
            begin
              nextchar(def_char);
              if def_char = TM_parameter_prefix_char then
                begin
                  nextchar(def_char);
                  num := ord(def_char) - ord('0');

                  if (num < 1) or (num > MAX_TM_PARAMETERS) then
                    error(35 { parameter value out of range })
                  else
                    begin
                      if num > last_read then read_parameter_list(num);

                      if not found_error then with parameter_list[num] do
			if param_tm_def <> nullstring then
			  begin
			    expand_with_parameters(param_name, param_tm_def);
                            if ovf_error then found_error := TRUE;
			  end
			else
			  begin
			    i := 0;
			    while (i < parameter_length) and
			          not found_error do
			      begin
				i := i + 1;
				if pos+i > MAX_STRING_LENGTH then
				  begin
				    display_error;
				    found_error := TRUE;
				  end
				else
				  temp[pos+i] := parameter_value[i];
			      end;

			    pos := pos + parameter_length;

			  end;
                    end;
                end
              else
                if def_char <> chr(EOL) then
                  if pos >= MAX_STRING_LENGTH then
                    begin  display_error;  found_error := TRUE;  end
                  else 
                    begin  pos := pos + 1;  temp[pos] := def_char;  end;
            end { while } ;

          if not found_error then
            if TM_depth <= 1 then assert(160 { underflow!!! })
                             else TM_depth := TM_depth - 1;

        end { if not found_error } ;
    end { expand_with_parameters } ;


  begin { process_text_macro }

    enter_expandable_id(text_macro_name);

    if TM_depth >= MAX_TM_RECURSION then
      begin
        error(64 { TM recursion depth exceeded });
        error_dump_text_macro(text_macro_name);
      end
    else
      begin
        TM_depth := TM_depth + 1;

        TM_def := nullstring;

        if RESERVED in text_macro_name^.kind then
          TM_def := text_macro_name^.definition;

        if TM_def = nullstring then
          TM_def := search_id(text_macro_name);

        if TM_def <> nullstring then
          begin
            if copy_input then current_pos := current_pos-1;
            if debug then
              if RESERVED in text_macro_name^.kind then
                disp_line('found reserved TM')
              else
                disp_line('found TM         ');

            init;

            expand_with_parameters(text_macro_name, TM_def);

            if ovf_error then str := nullstring
            else
              if parameter_found and not ovf_error then
                begin
                  create_a_string(str, pos);
                  for i := 1 to pos do str^[i] := temp[i];
                  str := enter_and_release_string(str);
                end
              else str := TM_def;

            copy_input := saved_copy_input;
            last_char := curr_char;
            if not parameter_found then read_state := saved_state;
            parse_string(str, PARSE_TRANSPARENTLY);
          end;

        if TM_depth <= 1 then assert(160 { underflow!!! })
        else TM_depth := TM_depth - 1;
      end;
  end { process_text_macro } ;


(**)     { ------- scan for an identifier ------- }


  procedure get_identifier;
    { read in an identifier }
    var
      i: 0..ID_LENGTH;            { index into the identifier }
      temp: alpha;                { identifier being parsed }
      id_error: boolean;          { TRUE iff id too long }
  begin
    temp := NULL_ALPHA;  id.name := NIL;

    i := 0;  sy := IDENT;  id_error := FALSE;
    repeat
      if i >= ID_LENGTH then
        begin
          if not copy_input or tokenize_params then
            error(41 { identifier length exceeded });
          id_error := TRUE;
          while isidentchar[ch] do get_char(ch);
        end
      else
        begin  
          i := i + 1;  temp[i] := ch;  get_char(ch);
        end;
    until not isidentchar[ch];

    if ch <> chr(EOL) then read_state := FGOT_CHAR;
    
    if debug then disp_line('identifier       ');

    if not copy_input or tokenize_params or not id_error then
      begin
        id.name := enter_name(temp);

        if (not copy_input) and (KEY_WORD in id.name^.kind) then
          if id.name^.sy in allowed_key_words then sy := id.name^.sy;

        if (sy = IDENT) and allow_TM_expansion then
	  process_text_macro(id.name);
      end;
  end { get_identifier } ;

    
(**)     { ------- scan for constant ------- }


  procedure get_constant;
    { read in one of three different constant types }
    var
      new_radix: natural_number;     { radix specified in constant }


    procedure skip_to_end_of_constant(number_radix: radix_range);
      { skip to the end of the constant;  error recovery }
    begin
      while ch in valid_chars[number_radix] do get_char(ch);
    end { skip_to_end_of_constant } ;


    function build_number(radix: radix_range): natural_number;
      { build a number with the specified radix }
      var
        temp: natural_number;      { value of the function to be returned }
        next_digit: 0..MAX_RADIX;  { numeric value of current digit }
    begin
      temp := 0;  const_width := 0;
      repeat
        const_width := const_width + 1;
        if ch <= '9' then  next_digit := ord(ch) - ord('0')
                     else  next_digit := ord(ch) - ord('A') + 10;

        if (temp > MAXINT DIV radix) or 
           ((temp = MAXINT DIV radix) and
            (next_digit > MAXINT MOD radix)) then
          begin  
            error(24 { ovf });
            skip_to_end_of_constant(radix);
          end
        else
          begin  temp := radix * temp + next_digit;  get_char(ch);  end;
      until not (ch IN valid_chars[radix]);

      const_width := const_width * radix_width[radix];

      build_number := temp;
    end { build_number } ;


  begin { get_constant }
    sy := CONSTANT;
    const_val := build_number(10);

    if parse_SCALDconstants then
      if isupper[ch] then
        begin
          repeat
            if copy_input and tokenize_params then
              copy_pos := copy_pos - 1; { don't copy SCALDconstant characters }

            get_char(ch);
          until not isupper[ch];
        end

      else
        begin
          if ch = '#' then
            begin
              new_radix := const_val;
              if (new_radix < min_radix) or (new_radix > max_radix) then
                begin  error(61 { out of range });  new_radix := 10;  end;

              get_char(ch);
              const_val := build_number(new_radix);

              sy := SIGNALCONST;
            end;

          if ch = '(' then    { width specification }
            begin
              get_char(ch);
              const_width := build_number(10);

              if (const_width <= 0) or (const_width > max_bit_value) then
                begin  error(44 { invalid width });  const_width := 1;  end;

              if ch = ')' then get_char(ch) else error(7 { expected ) });

              sy := SIGNALCONST;
            end;
        end;

    read_state := FGOT_CHAR;

    if debug then disp_line('constant         ');
  end { get_constant } ;


(**)     { ------- scan for string ------- }


  procedure get_string(stopper: char);
    { read a string }
    var
      len: string_range;   { length of the string read in }
      done: boolean;       { TRUE when end of the string has been found }
      nch: char;           { next charactar }
  begin
    len := 0;  done := FALSE;  looking_for_string := TRUE;

    if not upper_case_strings then upper_case_on_input := FALSE; 

    repeat
      get_char(ch);
      if ch = stopper then
        begin
	  nextchar(nch);
          if nch = stopper then get_char(ch) else done := TRUE;
	end;

      if (ch = chr(EOL)) and not done then
        begin  error(89 { string not closed });  done := TRUE;  end;

      if not done then
        if len >= MAX_STRING_LENGTH then
          begin error(22 { string length exceeded });
            while (ch <> stopper) and (ch <> chr(EOL)) do get_char(ch);
          end
        else
          begin len := len + 1;  input_buffer^[len] := ch;  end;
    until done;

    input_buffer^[0] := chr(len);
    sy := STRINGS;
    looking_for_string := FALSE;
    upper_case_on_input := TRUE;

    lex_string := enter_string(input_buffer);

    if debug then disp_line('string           ');
  end { get_string } ;


(**)     { ------- main lexical analyzer ------- }


begin { insymbol }
  looking_for_string := FALSE;
  upper_case_on_input := TRUE;
  copy_pos := current_pos;


  if parse_stack_pointer >= stack_top then
    begin
      if read_state = finput then last_sym_pos := line_pos
      else
        if line_pos >= 1 then last_sym_pos := line_pos-1
                         else last_sym_pos := 0;
    end
  else with stack[stack_top] do
    begin
      if state = FINPUT then last_pos := pos
      else
        if pos >= 1 then last_pos := pos-1
                         else last_pos := 0;
    end;

  if copy_input and not tokenize_params then
    begin
      delimited := TRUE;
      repeat
        get_char(ch);
	current_pos := copy_pos;
        if isupper[ch] then
	  begin
            { only delimited (not preceeded by a legal identifier char)
	      letters can begin an identifier in this mode }
	    if delimited then get_identifier;
	    delimited := FALSE;
	  end
        else delimited := not isidentchar[ch];
      until ch = chr(EOL);
      sy := ENDOFDATASY;
    end
  else
    repeat
      done := TRUE;
      get_char(ch);
      while ch = ' ' do get_char(ch);  current_pos := copy_pos;
  
      if ch = chr(EOL) then sy := ENDOFDATASY
      else
	case ch of
	  '!':  sy := EXCLAMATION;
	  '"':  get_string(ch);
	  '#':  sy := SHARP;
	  '$':  sy := DOLLAR;
	  '%':  sy := PERCENT;
	  '&':  sy := AMPERSAND;
	 '''':  get_string(ch);
	  '(':  sy := LPAREN;
	  ')':  sy := RPAREN;
	  '*':  sy := ASTERISK;
	  '+':  sy := PLUS;
	  ',':  sy := COMMA;
	  '-':  sy := MINUS;
	  '.':  begin
		  nextchar(next);
		  if next = '.' then
		    begin
		      sy := DOTDOTSY;  read_state := FINPUT;
		    end
		  else sy := PERIOD;
		end;
	  '/':  sy := SLASH;
	  '0','1','2','3','4','5','6','7','8','9':  get_constant;
	  ':':  begin
		  nextchar(next);
		  if next = ':' then
		    begin
		      sy := COLONCOLONSY;  read_state := FINPUT;
		    end
		  else sy := COLON;
		end;
	  ';':  sy := SEMI;
	  '<':  begin
		  nextchar(next);
		  if next = '=' then
		    begin
		      sy := LESY;  read_state := FINPUT;
		    end
		  else if next = '>' then
		    begin
		      sy := NESY;  read_state := FINPUT;
		    end
		  else sy := LESSTHAN;
		end;
	  '=':  sy := EQUAL;
	  '>':  begin
		  nextchar(next);
		  if next = '=' then
		    begin
		      sy := GESY;  read_state := FINPUT;
		    end
		  else sy := GREATERTHAN;
		end;
	  '?':  sy := QUESTION;
  {       '@':  sy := ATSY;      this symbol is not used: @=^ in EBCDIC! }
	  'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
	  'O','P','Q','R','S','T','U','V','W','X','Y','Z':  get_identifier;
	  '[':  sy := LBRACKET;


	  '\': sy := BACKSLASH;

	  ']':  sy := RBRACKET;
	  '^':  sy := CIRCUMFLEX;
	  '_':  sy := UNDERBAR;
	  '`':  sy := ACCENTGRAVE;
	  '{':  begin
		  repeat
		    get_char(ch)
		  until (ch='}')  or (ch=chr(EOL));
  
		  if ch = chr(EOL) then error(34 { comment not closed });
		  done := FALSE;
		end;
	  '|':  sy := VERTICALBAR;
	  '}':  begin  error(20 { unmatched symbol });  done := FALSE;  end;
	  '~':  sy := TILDA;
	  OTHERWISE
	    begin
		error(23 { illegal character in input });
		error_dump_alpha('Character       ');
		error_dump_integer(ord(ch));
		error_dump_CRLF;
	    end;
	end;
    until done;

  if parse_stack_pointer <= stack_top then
    stack[stack_top].last_pos := stack[stack_top].pos;

  if debug then writeln(outfile, 'insymbol: ', ord(sy)); 
end { insymbol } ;


(**)     { ------- parsing utilities ------- }


procedure skip(syms: setofsymbols);
  { used to try to gracefully recover from errors }
begin
  while not (sy IN syms+[ENDOFDATASY]) do insymbol;
end { skip } ;


function check_bit (bit: integer): bit_range;
  { check the value of a bit specifier and return }
begin
  if (bit < 0) or (bit > MAX_BIT_VALUE) then 
    begin
      error(16 { incorrect bit value });
      error_dump_indent(indent);
      error_dump_alpha('Bit value=      ');
      error_dump_char(' ');
      error_dump_integer(bit);
      error_dump_CRLF;

      bit := 0;
    end;

  check_bit := bit;
end { check_bit } ;

      
function check_addition(val1, val2: integer): integer;
  { check to see if the result of an addition of the two numbers is in range.
    If not, generate an error message and return the first argument. }
  var
    ok: boolean;      { TRUE if addition is in bounds }
begin
  ok := TRUE;
  if val1 >= 0 then
    begin
      if val2 > 0 then
        if val1 > MAXINT - val2 then ok := FALSE;
    end
  else
    if val2 < 0 then
      if val1 < -MAXINT-1 - val2 then ok := FALSE;

  if ok then check_addition := val1 + val2
  else
    begin  error(24 { overflow });  check_addition := val1;  end;

  if debug then
    begin
      disp_line('check_addition   ');
      writeln(outfile, 'CHECK: ', val1:1, '+', val2:1, '; OK=', ord(ok):1);
    end;
end { check_addition } ;


function check_subtraction(val1, val2: integer): integer;
  { check the subtraction of the two operands.  If the result is in bounds,
    return the difference otherwise generate an error and return the minuend }
  var
    ok: boolean;           { TRUE if subtraction is in bounds }
begin
  ok := TRUE;
  if val1 >= 0 then
    begin
      if val2 < 0 then
        if val1 > MAXINT + val2 then ok := FALSE;
    end
  else
    if val2 > 0 then
      if val1 < -MAXINT-1 + val2 then ok := FALSE;

  if ok then check_subtraction := val1 - val2
  else
    begin  error(24 { overflow });  check_subtraction := val1;  end;

  if debug then
    begin
      disp_line('check_subtraction');
      writeln(outfile, 'CHECK: ', val1:1, '-', val2:1, '; OK=', ord(ok):1);
    end;
end { check_subtraction } ;


(**)     { ------- expression parsing routines ------- }


function expression(expr_kind: expression_type): integer;
  { parse an expression and return its value. All identifiers are
    logged as hard expandable ids (which handles logging for
    selection expressions, integer parameter values, signal subscripts, 
    and any similar thing which might come along all in one swell foop!). }
  var
    val: integer;           { value of expression to be returned }

    
  function boolean_expression: integer;
    { parse a boolean expression }
    var
      val: integer;      { value of the expression so far }
      tmp_val: integer;  { temp value to parse relation expr in AND expr }
			 { because when code is translated to c, c stops }
			 { if first and condition is false, thereby exiting }
			 { midway from parsing }


    function string_expression: xtring;
      { return value of current string expression }
      var
	val: xtring;
    begin
      if sy = IDENT then
	begin
	  val := make_and_enter_string(id.name^.name);
	  insymbol;
	end
      else if sy = STRINGS then
	begin
	  val := lex_string;
	  insymbol;
	end
      else
	begin
	  val := nullstring;
	  error(4 { expected a string or identifier });
	end;
      string_expression := val;
      if debug then
	begin
	  disp_line('string_expression');
	  write(outfile, 'VALUE=');
	  writestring(Outfile, val);
	  writeln(Outfile);
	end;
    end { string_expression } ;
  
  
    function simple_expression: integer;
      { parse a simple expression and return its value }
      var
	val: integer;         { value of simple expression to be returned }
	sym: symbols;         { addition operator }
	negative: boolean;    { TRUE if expression has unary minus }
  
  
      function term: integer;
	{ parse a term and return its value }
	var
	  val,                  { value of term to be returned }
	  temp: integer;        { temp for calculations }
	  sym: symbols;         { multiplying operator }
  
  
	function factor: integer;
	  { parse a factor and return its value }
	  var
	    temp1, temp2: integer;    { temp results for MIN and MAX }
	    ret: integer;             { final result }
	begin
	  { <unsigned constant> }
  
	  if sy = CONSTANT then 
	    begin  ret := const_val;  insymbol;  end
  
	  { ( <expression> ) }
  
	  else if sy = LPAREN then
	    begin
	      insymbol;
	      ret := expression(expr_kind);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { not <factor> }
  
	  else if sy = NOTSY then
	    begin  insymbol;  ret := ord(not (factor<>0));  end
  
	  { ABS ( <expression> ) }
  
	  else if sy = ABSSY then
	    begin
	      insymbol;  
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      ret := abs( expression(expr_kind) );
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { ORD ( <expression> ) }
  
	  else if sy = ORDSY then
	    begin
	      insymbol;  
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      if expression(ALLOW_RELOPS) = 0 then ret := 0
					      else ret := 1;
	      if sy = RPAREN then insymbol else error(7 { expected ) });
	    end
  
	  { MIN ( <expression> , <expression> ... ) }
  
	  else if sy = MINSY then
	    begin
	      insymbol;
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      temp1 := expression(expr_kind);
	      repeat
		if sy = COMMA then insymbol else error(5 { expected , });
		temp2 := expression(expr_kind);
		if temp1 > temp2 then temp1 := temp2;
	      until (sy <> COMMA);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
  
	      ret := temp1;
	    end
  
	  { MAX ( <expression> , <expression> ... ) }
  
	  else if sy = MAXSY then
	    begin
	      insymbol;
	      if sy = LPAREN then insymbol else error(15 { expected ( });
	      temp1 := expression(expr_kind);
	      repeat
		if sy = COMMA then insymbol else error(5 { expected , });
		temp2 := expression(expr_kind);
		if temp1 < temp2 then temp1 := temp2;
	      until (sy <> COMMA);
	      if sy = RPAREN then insymbol else error(7 { expected ) });
  
	      ret := temp1;
	    end
  
	  { error conditions }
  
	  else if sy = IDENT then
	    begin  
	      error(39 { undefined });  ret := 1;  
	    end
	  else if sy = ENDOFDATASY then
	    begin  error(57 { end of input! });  ret := 1;  end
	  else
	    begin  error(14 { error in factor });  ret := 1;  end;
  
	  factor := ret;
  
	  if debug then 
	    begin
	      disp_line('factor           ');
	      writeln(outfile, 'VALUE=', ret:1);
	    end;
	end { factor } ;
  
  
      begin { term } 
	val := factor;
  
	while sy IN mulops do
	  begin
	    sym := sy;  insymbol;  temp := factor;
	    case sym of
	      ASTERISK: if temp = 0 then val := 0
			else 
			  if abs(MAXINT DIV temp) < abs(val) then error(24)
			  else val := val * temp;                    
	      SLASH:    if temp = 0 then error(25 { divide by 0 })
			else val := val DIV temp;
	      MODSY:    if temp = 0 then error(25 { divide by 0 })
			else val := val MOD temp;
	    end;
	  end;
  
	term := val;
  
	if debug then
	  begin
	    disp_line('term             ');
	    writeln(outfile, 'VALUE=', val:1);
	  end;
      end { term } ;
  
  
    begin { simple_expression }
      if sy IN [PLUS,MINUS] then
	begin  negative := (sy = MINUS);  insymbol;  end
      else negative := FALSE;
  
      val := term;
  
      if negative then 
	if val <> -MAXINT-1 then val := -val else error(24 { ovf });
  
      while sy IN addops do
	begin
	  sym := sy;  insymbol;
	  case sym of
	    PLUS:  val := check_addition(val, term);
	    MINUS: val := check_subtraction(val, term);
	  end;
	end;
  
      simple_expression := val;
  
      if debug then
	begin
	  disp_line('simple_expression');
	  writeln(outfile, 'VALUE=', val:1);
	end;
    end { simple_expression } ;


    function relational_expression: integer;
      { parse a relational expression }
      var
        val: integer;    { value of the expression so far }
        sym: symbols;    { relational oeprator }
	str: xtring;     { value of first string_expression }
	comparison: compare_type;  { comparison of string expressions }


      { Would nest simple_expression and string_expression here, but
        this exceeds SVS PASCAL's nesting depth limitiations. }


    begin { relational_expression }
      if ((sy = IDENT) or (sy = STRINGS)) and (expr_kind = ALLOW_RELOPS) then
	  begin
	    str := string_expression;
	    if not (sy in relops) then
	      begin
		val := 0;
	        error(8 { Expected boolean operator });
	      end
	    else
	      begin
	        sym := sy;  insymbol;
		comparison := compare_strings(str, string_expression);
		case sym of
		  EQUAL:        val := ord(comparison = EQ);
		  NESY:         val := ord(comparison <> EQ);
		  LESSTHAN:     val := ord(comparison = LT);
		  LESY:         val := ord(comparison <> GT);
		  GREATERTHAN:  val := ord(comparison = GT);
		  GESY:         val := ord(comparison <> LT);
		end;
	      end;
	  end
      else
        begin
	  val := simple_expression;
    
	  if (expr_kind = ALLOW_RELOPS) and (sy IN relops) then
	    begin
	      sym := sy;  insymbol;
	      case sym of
		EQUAL:        val := ord(val =  simple_expression);
		NESY:         val := ord(val <> simple_expression);
		LESSTHAN:     val := ord(val <  simple_expression);
		LESY:         val := ord(val <= simple_expression);
		GREATERTHAN:  val := ord(val >  simple_expression);
		GESY:         val := ord(val >= simple_expression);
	      end;
	    end;
          end;
    
      relational_expression := val;

      if debug then
        begin
          disp_line('relational_expres');
          writeln(outfile, 'VALUE=', val:1);
        end;
    end { relational_expression } ;


  begin { boolean_expression }
    val := relational_expression;

    while (sy = ANDSY) do
      begin
        insymbol;
	tmp_val := relational_expression;
        val := ord((val <> 0) and (tmp_val <> 0));
      end;

    boolean_expression := val;

    if debug then
      begin
        disp_line('boolean_expressio');
        writeln(outfile, 'VALUE=', val:1);
      end;
  end { boolean_expression } ;


begin { expression }
  val := boolean_expression;

  while (sy = ORSY) or (sy = XORSY) do
    if sy = ORSY then
      begin
        insymbol;
        val := ord((val <> 0) or (boolean_expression <> 0));
      end
    else
      begin
        insymbol;
        if (boolean_expression <> 0) then val := ord(val = 0)
	                             else val := ord(val <> 0);
      end;

  expression := val;

  if debug then
    begin
      disp_line('expression       ');  writeln(outfile, 'VALUE=', val:1);
    end;

end { expression } ;


(**)     { ------- bit selection parsing routines ------- }


function check_bit_range(bit1, bit2: bit_range): bit_range;
  { check the sum of the two bits to make sure it resides in the proper
    range for a bit subscript.  It is assumed that the first bit
    is a valid bit range already. }
begin
  if bit2 > MAX_BIT_VALUE - bit1 then
    begin  error(24 { overflow });  check_bit_range := bit1;  end
  else
    check_bit_range := bit1 + bit2;
end { check_bit_range } ;


procedure reverse_bit_subscript(var sub: subscript_ptr);
  { reverse a bit subscript }
  var
    last,                 { last subscript element encountered }
    next: subscript_ptr;  { next subscript element }
begin
  last := NIL;
  while sub <> NIL do
    begin
      next := sub^.next;  sub^.next := last;  last := sub;  sub := next;
    end;
  sub := last;
end { reverse_bit_subscript } ;


function parse_bit_subscript: subscript_ptr;
  { parse a bit subscript (with associated structures) }
  var
    bit_val: bit_range;              { current bit parsed }
    done: boolean;                   { TRUE when all of subscript read }
    new_sub,                         { start of new subscript in list }
    last,                            { last subscript parsed (current) }
    sub: subscript_ptr;              { subscript representation to return }


  function end_of_list(sub: subscript_ptr): subscript_ptr;
    { find the end of the given subscript list }
    var
      next,                       { next element in the list }
      last: subscript_ptr;        { last element of the list }
  begin
    next := sub;  last := NIL;
    while next <> NIL do 
      begin  last := next;  next := next^.next;  end;
    end_of_list := last;
  end { end_of_list } ;


  procedure add_subscript(var list, last: subscript_ptr);
    { create a new subscript and add it to the end of the list }
    var
      sub: subscript_ptr;     { subscript being added }
  begin
    sub := NIL;  new_subscript(sub);
    if last <> NIL then last^.next := sub;  last := sub;
    if list = NIL then list := last;
  end { add_subscript } ;


  function process_increment(var sub: subscript_ptr): subscript_ptr;
    { parse the increment.  Check to see that the subscript is properly
      formed.  If the increment <> -1,0,1, then expand the subscript
      into a bit list and return as SUB.  Return a pointer to the last
      element in the subscript list. }
    var
      increment: integer;            { specified increment }
      new_list: subscript_ptr;       { expansion of the subscript }
      done: boolean;                 { TRUE when subscript expansion done }
      bit: integer;                  { current bit of expanded subscript }

    
    procedure swap(SP: subscript_ptr);
      { swap the subscript indices }
      var
	temp: bit_range;      { temp storage during swap }
    begin
      temp := SP^.left_index;
      SP^.left_index := SP^.right_index;  SP^.right_index := temp;
    end { swap } ;


  begin { process_increment }
    if debug then disp_line('enter process_inc');

    if sy <> fieldsy then increment := 1
    else
      begin
	insymbol;     { eat the fieldsy }
	increment := expression(NO_RELOPS);
	if increment = 0 then
	  begin  error(171 { not permitted });  increment := 1;  end;
      end;

    { legal combinations of left, right, and increment are:

	   OK            not OK
	a. 7..0:1     b. 7..0:-1        right to left
	c. 0..7:-1    d. 0..7:1         right to left

	e. 0..7:1     f. 0..7:-1        left to right
	g. 7..0:-1    g. 7..0:1         left to right

      Check to make sure this is a legal combination of above. }

    if sub^.left_index < sub^.right_index then
      begin
	if (increment < 0) and left_to_right then                 { case f }
	  begin  error(173 { should be left to right });  swap(sub);  end
	else if (increment > 0) and not left_to_right then        { case d }
	  begin  error(172 { should be right to left });  swap(sub);  end
      end
    else if sub^.left_index > sub^.right_index then
      if (increment > 0) and left_to_right then                   { case g }
	begin  error(173 { should be left to right });  swap(sub);  end
      else if (increment < 0) and not left_to_right then          { case b }
	begin  error(172 { should be right to left });  swap(sub);  end;

    { given the increment, generate a subscript }

    if abs(increment) = 1 then
      process_increment := sub        { done.  Leave as is }
    else
      begin
	{ generate a list of bits }
	{ NOTE: sub is at the end of the bit subscript list }

	if left_to_right then increment := -increment;
      
	new_list := NIL;  bit := sub^.right_index;
	repeat
	  if new_list <> NIL then new_subscript(new_list)
	  else
	    begin
	      new_subscript(new_list);
	      process_increment := new_list;
	    end;

	  new_list^.left_index := bit;
	  new_list^.right_index := bit;

	  bit := bit + increment;
	  if increment > 0 then done := (bit > sub^.left_index)
			   else done := (bit < sub^.left_index);
	until done;

	{ it is assumed that the subscript passed is the last element in
	  a subscript.  It has been initialized with the left and right
	  fields.  It should be replaced by an increment-expanded subscript.
	  Append the list and get rid of the first element since it is
	  redundant. }

	sub^ := new_list^;
	release_subscript(new_list);
      end;

    if debug then
      begin
	write(outfile, 'Subscript=');
	dump_bit_subscript(outfile, sub, VECTOR);  writeln(outfile);
	disp_line('process_increment');
      end;
  end { process_increment } ;


begin { parse_bit_subscript }
  if debug then disp_line('enter bit_subscri');

  sub := NIL;  last := NIL;  done := FALSE;
  repeat
    new_sub := last;

    bit_val := check_bit(expression(no_relops));

    if sy = subrangesy then
      begin
	insymbol;
	add_subscript(sub, last);
	last^.left_index := bit_val;
	last^.right_index := check_bit(expression(no_relops));
	last := process_increment(last);
      end

    else if sy = fieldsy then
      begin
	insymbol;
	add_subscript(sub, last);
	last^.left_index := bit_val;
	if left_to_right then
	  last^.right_index := check_bit(last^.left_index +
						  expression(no_relops) - 1)
	else
	  last^.right_index := check_bit(last^.left_index -
						 expression(no_relops) + 1);
	last := process_increment(last);
      end

    else if sy IN bitsubendsys then
      begin
	add_subscript(sub, last);
	last^.left_index := bit_val;
	last^.right_index := bit_val;
      end

    else
      begin
	if sy = IDENT then
	  error(59 { undefined identifier })
	else
	  error(30 { unexpected sy });
	skip(bitsubendsys);
	add_subscript(sub, last);
	last^.left_index := bit_val;
	last^.right_index := bit_val;
      end;

    last := end_of_list(sub);

    if sy = COMMA then insymbol else done := TRUE;
  until done;

  parse_bit_subscript := sub;

  if debug then disp_line('bit_subscript    ');
end { parse_bit_subscript } ;


function bit_selector: subscript_ptr;
  { parse the subscript and return a description of it }
begin
  if debug then disp_line('enter bit_selecto');

  if sy = LESSTHAN then 
    begin
      insymbol;
      bit_selector := parse_bit_subscript;
      if sy = GREATERTHAN then insymbol
      else
	begin  error(11 { expected > });  skip(signal_name_end_sys);  end;
    end
  else bit_selector := NIL;

  if debug then disp_line('bit selector     ');
end { bit_selector } ;


(**)     { ------- expression evaluation routines ------- }


function evaluate_string(str: xtring): integer;
  { evaluate numeric value -- no relational operators and no null strings }
  var
    t: integer;   { the expression value calculated }
begin
  if str = nullstring then
    begin  assert(4 { invalid string } );  t := 0;  end
  else
    begin
      parse_string(str, PARSE_SEPARATELY);
      t := expression(NO_RELOPS);
      if sy <> ENDOFDATASY then error(58 { extraneous junk });
      pop_parsed_string(str);
    end;
  evaluate_string := t;
end { evaluate_string } ;
  

function evaluate_boolean_expr(*str: xtring): integer*);
  { allow nullstring (return TRUE) and relational operators. Intended for
    use by C++ expansion control module -- thus the integer return rather
    than boolean.  "DEFAULT" will never appear here. }
  var
    t: integer;   { the expression value calculated }
begin
  if ord(str^[0]) = 0 then t := 1
      { string may come from C++ -- can't check str = nullstring }
  else
    begin
      parse_string(str, PARSE_SEPARATELY);
      t := expression(ALLOW_RELOPS);
      if sy <> ENDOFDATASY then error(63 { extraneous junk });
      pop_parsed_string(str);
    end;
  evaluate_boolean_expr := t;
end { evaluate_boolean_expr } ;


function evaluate_selection_expression(str: xtring): boolean;
  { str is a true string -- in compiler (pascal-side) string table. 
    "DEFAULT" always returns TRUE here -- we assume we have already
    chosen the proper version and are just checking the individual pages. }
begin
    if str = DEFAULT_string then evaluate_selection_expression := TRUE
    else evaluate_selection_expression := evaluate_boolean_expr(str) <> 0;
end {  evaluate_selection_expression } ;


(**){--------------- NEW & RELEASE for NUMBERED_TOKENs --------}

{---------------------------------------------------------------}
{ All new routines for numbered tokens obtain a new object and  }
{ insert it to the head of the list.  All release routines      }
{ (for these) delete the object from its list.                  }
{ All release_all_<object>s... routines relase an entire list   }
{ and return NIL.                                               }
{ Examples:                                                     }
{   new_object(head_of_list);                                   }
{   new_object(parent_of_new_one^.next);                        }
{   release_object(head_of_list);                               }
{   release_all_lists(head_of_list);                        }
{   release_object(parent_of_one_to_delete^.next);              }
{---------------------------------------------------------------}

procedure init_numbered_token(var tok: numbered_token;
			     token_kind: numbered_token_type);
  { Initializes a numbered_token record to UNKNOWN_TOKEN_NUMBER, 
    token_kind, NOT used and NIL. This is automatically done by 
    new_numbered_token, but this routine should be used when needing 
    to initialize a local (non-dynamic) record of this type. 
    NOTE: sets tok.next = NIL }
begin
  with tok do 
    begin
      number := UNKNOWN_TOKEN_NUMBER;
      output_number := UNKNOWN_TOKEN_NUMBER;
      next := NIL;
      case token_kind of
	STRING_NUMBER: string_p := NIL;
	IDENTIFIER_NUMBER: identifier_p := NIL;
	OTHERWISE 
	  begin
	    assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	    string_p := NIL;
	  end;
      end;
    end;
end { init_numbered_token } ;


procedure new_numbered_token(var tok: numbered_token_ptr;
			     token_kind: numbered_token_type);
  { Gets a new numbered_token (from freelist, if possible) and
    initializes (per init_numbered_token) and inserts it at the
    head of the list. }
  var
    nt: numbered_token_ptr; { new one }
begin
  if free_numbered_tokens <> NIL then
    begin  
      nt := free_numbered_tokens;  
      free_numbered_tokens := nt^.next;  
    end
  else
    begin
      new(nt);  
      increment_heap_count(HEAP_NUMBERED_TOKEN, 
        2*POINTER_SIZE+2*INT_SIZE+BOOL_SIZE);
    end;
  init_numbered_token(nt^, token_kind);
  nt^.next := tok;  tok := nt;
end { new_numbered_token } ;


procedure release_numbered_token(var tok: numbered_token_ptr;
				 token_kind: numbered_token_type);
  { Releases a numbered_token for re-use. Sets tok to
    the former tok^.next (so can be used for list deletion). }
  var
    nt: numbered_token_ptr; { saves old tok for release }
begin
  if tok <> NIL then
    begin
      nt := tok;
      tok := tok^.next;
      nt^.next := free_numbered_tokens;
      free_numbered_tokens := nt;
    end;
end { release_numbered_token } ;


procedure new_numbered_token_list(
  var toklist: numbered_token_list_ptr);
  { Gets a new numbered_token (from freelist, if possible) and
    initializes it to NIL values and inserts it to head of list. }
  var
    ntl: numbered_token_list_ptr; { new one }
begin
  if free_numbered_token_lists <> NIL then
    begin  
      ntl := free_numbered_token_lists;  
      free_numbered_token_lists := ntl^.next;  
    end
  else
    begin
      new(ntl);  
      increment_heap_count(HEAP_NUMBERED_TOKEN_LIST, 2*POINTER_SIZE);
    end;
  ntl^.token := NIL;
  ntl^.next := toklist;  toklist := ntl;
end { new_numbered_token_list } ;


procedure release_all_numbered_token_lists(
  var toklist: numbered_token_list_ptr);
  { releases a numbered_token_list list by insertion into freelist. 
    Returns NIL. Has no effect on numbered tokens referenced. }
  var
    last: numbered_token_list_ptr; { last element of list }
begin
  if toklist <> NIL then
    begin
      last := toklist;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_numbered_token_lists;
      free_numbered_token_lists := toklist;
      toklist := NIL;
    end;
end { release_all_numbered_token_lists } ;


procedure release_numbered_token_list(
  var toklist: numbered_token_list_ptr);
  { deletes and releases a numbered_token_list object. 
    Has no effect on numbered tokens referenced. }
  var
    ntl: numbered_token_list_ptr; { saves old toklist for release }
begin
  if toklist <> NIL then
    begin
      ntl := toklist;
      toklist := toklist^.next;
      ntl^.next := free_numbered_token_lists;
      free_numbered_token_lists := ntl;
    end;
end { release_numbered_token_list } ;


(**){--------------- DICTIONARY ACCESS for NUMBERED_TOKENs --------}


{--------------------------------------------------------------------}
{ In the access routines, lookups can be based on number or token    }
{ value.  Each procedure takes a parameter TOK which is passed by    }
{ reference.  The lookup rule is:                                    }
{                                                                    }
{   if tok.number = UNKNOWN_TOKEN_NUMBER then perform lookup based   }
{     on token value                                                 }
{   else perform lookup based on token number.                       }
{                                                                    }
{ It is an assertion violation to attempt to enter Nil values or     }
{ illegal identifiers.                                               }
{--------------------------------------------------------------------}


function find_numbered_token_by_number(
  var {const} tok: numbered_token; 
  var {const} dic: numbered_dictionary;
  var index: numbered_token_table_range; 
  var parent: numbered_token_ptr;
  var found_item: numbered_token_ptr): boolean;
  { Finds parent of token in dic.table (if parent is NIL, then
    token goes at head of INDEXth bucket).  If token is found,
    it is returned as found_item (which will be NIL if not found).
    Function returns FALSE iff brain damage is detected. }
  label
   90; { return }
  var
    found: boolean;  { TRUE when and if found }
begin
  find_numbered_token_by_number := TRUE;
  if tok.number = UNKNOWN_TOKEN_NUMBER then
    begin
      index := 0;
      found_item := NIL;
      parent := NIL;
      assert(ASSERT_LOOKING_FOR_UNKOWN_TOKEN);
      find_numbered_token_by_number := FALSE;
      goto 90 { return } ;
    end;

  index := tok.number mod (LAST_NUMBERED_TOKEN_INDEX + 1);

  found_item :=  dic.table[index];  parent := NIL;  found := FALSE;
  while (found_item <> NIL) and not found do
    if found_item^.number = tok.number then found := TRUE
    else if found_item^.number < tok.number then
      begin
        parent := found_item;  found_item := found_item^.next;
      end
    else found_item := NIL;
90:
end { find_numbered_token_by_number } ;


function find_numbered_token_by_value(
  var {const} tok: numbered_token; 
  var {const} dic: numbered_dictionary;
  var index: numbered_token_table_range; 
  var parent: numbered_token_list_ptr;
  var found_item: numbered_token_list_ptr
): boolean;
  { Finds parent of token in dic.inverted_table (if parent is NIL, then
    token goes at head of INDEXth bucket).  If token is found,
    it is returned as found_item (which will be NIL if not found).
    Function returns FALSE iff brain damage is detected (in which case
    the returned values are undefined). }
  var
    found: boolean;               { TRUE if and when we find the value }
begin
  find_numbered_token_by_value := TRUE;

  case dic.kind of

    STRING_NUMBER:
      begin
        index := (ord(tok.string_p) div 4) mod
	         (LAST_NUMBERED_TOKEN_INDEX + 1);
        found_item :=  dic.inverted_table[index];
	parent := NIL;  found := FALSE;
        while (found_item <> NIL) and not found do
          begin
            if found_item^.token = NIL then
	      begin
	        assert(206 { Nil token field in token list });
                found_item := NIL;
	        find_numbered_token_by_value := FALSE;
	      end;
            if found_item^.token^.string_p = tok.string_p then found := TRUE
            else if ord(found_item^.token^.string_p) < ord(tok.string_p) then
	      begin
	        parent := found_item;  found_item := found_item^.next;
	      end
	    else found_item := NIL; { not there and parent is correct parent }
          end;
      end;

    IDENTIFIER_NUMBER:
      begin
        index := (ord(tok.identifier_p) div 4) mod 
	         (LAST_NUMBERED_TOKEN_INDEX + 1);
        found_item :=  dic.inverted_table[index];
	parent := NIL;  found := FALSE;
        while (found_item <> NIL) and not found do
          begin
            if found_item^.token = NIL then
	      begin
	        assert(206 { Nil token field in token list });
		found_item := NIL;
	        find_numbered_token_by_value := FALSE;
	      end;
            if found_item^.token^.identifier_p = tok.identifier_p then
	      found := TRUE
            else if ord(found_item^.token^.identifier_p) < 
	            ord(tok.identifier_p) then
	      begin
	        parent := found_item;  found_item := found_item^.next;
	      end
	    else found_item := NIL; { not there and parent is correct parent }
          end;
      end;

    OTHERWISE 
      begin
	assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
        find_numbered_token_by_value := FALSE;
      end;
  end;

end { find_numbered_token_by_value } ;


function insert_numbered_token(
  var {const} tok: numbered_token; 
  var dic: numbered_dictionary): numbered_token_ptr;
  { Searches table for numbered token in specified dictionary. 
    Returns pointer to found (or newly inserted) numbered token.
    The token is marked USED.
    Tok is NOT altered.  NIL is returned if assertion violation has
    occurred. Note -- this routine is GUARANTEED not to enter into the
    table a token with a non-kosher value (Non kosher values are NIL for
    all both types of tokens and an identifier entry for NULL_ALPHA. }
  label
    90; { return }
  var
    result: numbered_token_ptr;            { returned value }
    table_index: numbered_token_table_range;     { bucket in table }
    inv_table_index: numbered_token_table_range; { bucket in inverted table }
    parent: numbered_token_ptr;            { parent in table bucket }
    inv_parent: numbered_token_list_ptr;   { parent in inverted table bucket }
    the_item: numbered_token_ptr;          { found or created table entry }
    the_inv_item: numbered_token_list_ptr; { found or created inv table entry }
    temp: numbered_token;                  { copy of tok with new number }


  function alpha_is_id(id: alpha):  boolean;
    { return TRUE iff the id is a legal id }
    var
      ok: boolean;           { TRUE as long as id is ok }
      in_blanks: boolean;    { TRUE when in trailing blanks }
      i: id_range;           { index into id }
  begin
    ok := isupper[id[1]];  in_blanks := FALSE;  i := 1;
    while ok and not in_blanks and (i < ID_LENGTH) do
      begin
        i := i + 1;
        if id[i] = ' ' then in_blanks := TRUE
        else ok := isidentchar[id[i]];
      end;
    while ok and (i < ID_LENGTH) do
      begin
        i := i + 1;
        ok := (id[i] = ' ');
      end;
    alpha_is_id := ok;
  end { alpha_is_id } ;


  function value_is_kosher(var {const} tok: numbered_token;
                           kind: numbered_token_type): boolean;
    { test whether value is kosher -- non-NIL and if an identifer, then
      a legal one. }
  begin
    case kind of
      STRING_NUMBER:
        if tok.string_p = NIL then
	  begin
	    assert(221 { null string });
	    value_is_kosher := FALSE;
	  end
	else value_is_kosher := TRUE;
      IDENTIFIER_NUMBER:
        if tok.identifier_p = NIL then
	  begin
	    assert(221 { null string });
	    value_is_kosher := FALSE;
	  end
	else if not alpha_is_id(tok.identifier_p^.name) then
	  begin
	    assert(233 { bad id });
	    value_is_kosher := FALSE;
	  end
	else value_is_kosher := TRUE;
      OTHERWISE 
	begin
	  assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	  value_is_kosher := FALSE;
	end;
    end;
  end { value_is_kosher } ;
      
	
  function insert_number_only({const}var tok: numbered_token): 
    numbered_token_ptr;
    { inserts tok into table and returns pointer to new object. }
    var
      newtok: numbered_token_ptr;
  begin
    if dic.highest < tok.number then dic.highest := tok.number;
    if parent = NIL then
      begin
        new_numbered_token(dic.table[table_index], dic.kind);
        newtok := dic.table[table_index];
      end
    else
      begin
        new_numbered_token(parent^.next, dic.kind);
        newtok := parent^.next;
      end;
    with newtok^ do
      begin
	number := tok.number;
	case dic.kind of
	  IDENTIFIER_NUMBER: identifier_p := tok.identifier_p;
	  STRING_NUMBER: string_p := tok.string_p;
	  OTHERWISE
	    begin
	      assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	      string_p := NIL;
	    end;
	end;
      end;
    insert_number_only := newtok;
  end { insert_number_only } ;


  function insert_new_token({const}var tok: numbered_token): numbered_token_ptr;
    { inserts tok into both lists. Returns pointer to the new element }
    var
      newtok: numbered_token_ptr;  { new token }
  begin
    newtok := insert_number_only(tok);
    if inv_parent = NIL then
      begin
	new_numbered_token_list(dic.inverted_table[inv_table_index]);
	dic.inverted_table[inv_table_index]^.token := newtok;
      end
    else
      begin
	new_numbered_token_list(inv_parent^.next);
	inv_parent^.next^.token := newtok;
      end;
    insert_new_token := newtok;
  end { insert_new_token } ;


begin { insert_numbered_token }
  insert_numbered_token := NIL;  result := NIL;

  if not dic.active then
    begin
      assert(249 { insertion to non-active dictionary });
      goto 90 { return } ;
    end;

  if tok.number = UNKNOWN_TOKEN_NUMBER then
    begin
      if not find_numbered_token_by_value(tok, dic, inv_table_index, 
				          inv_parent, the_inv_item) then
	goto 90 { return } ;  { assertion message already issued }

      if the_inv_item <> NIL then
	begin { found it }
	  result := the_inv_item^.token;
	  if the_inv_item^.token = NIL then
	    begin
	      assert(206 { Nil token field in token list });
	    end;
	end
      else 
	begin { create new entry }
          if not value_is_kosher(tok, dic.kind) then goto 90 { return } ;
	  if dic.highest = MAXINT then
	    begin
	      assert(208 { numbered token table overflow });
	      goto 90 { return } ;
	    end;
	  dic.highest := dic.highest + 1;
	  temp := tok;
	  temp.number := dic.highest;

	  if not find_numbered_token_by_number(temp, dic, table_index, 
					       parent, the_item) then
	    goto 90 { return } ;  { assertion message already issued }

	  if the_item = NIL then
	    begin
	      result := insert_new_token(temp);
	    end
	  else
	    begin
	      assert(ASSERT_NEW_NUMBER_IS_OLD); { serious abberation }
	      goto 90 { return } ;
	    end;
	end;
    end
  else
    begin
      if not find_numbered_token_by_number(tok, dic, table_index, 
				           parent, the_item) then
	goto 90 { return } ;  { assertion message already issued }

      if the_item <> NIL then 
	begin { found it }
	  result := the_item; 
	end
      else
	begin { create new entry }
          if not value_is_kosher(tok, dic.kind) then goto 90 { return } ;

	  if not find_numbered_token_by_value(tok, dic, inv_table_index, 
					      inv_parent, the_inv_item) then
	    goto 90 { return } ;  { assertion message already issued }

	  if the_inv_item = NIL then
	    begin
	      result := insert_new_token(tok);
	    end
	  else
	    begin
	      assert(ASSERT_DUPLICATE_TOKEN_VALUE); { warning }
	      result := insert_number_only(tok);
	    end;
	  if dic.highest < tok.number then dic.highest := tok.number;
	end;

    end;

    if result <> NIL then result^.used := TRUE;

    insert_numbered_token := result;
90:
end { insert_numbered_token } ;


function find_numbered_token(
  var {const} tok: numbered_token; 
  var {const} dic: numbered_dictionary): numbered_token_ptr;
  { Searches table for numbered token in specified dictionary. 
    If found, returns pointer to found numbered token and the
    found token is marked USED.
    Tok is NOT altered.  NIL is returned if assertion violation has
    occurred or token was not found. This function does not assume
    that not finding the item is an assertion violation.  }
  label
    90; { return }
  var
    table_index: numbered_token_table_range;     { bucket in table }
    inv_table_index: numbered_token_table_range; { bucket in inverted table }
    parent: numbered_token_ptr;            { parent in table bucket }
    inv_parent: numbered_token_list_ptr;   { parent in inverted table bucket }
    the_item: numbered_token_ptr;          { found or created table entry }
    the_inv_item: numbered_token_list_ptr; { found or created inv table entry }
begin
  find_numbered_token := NIL;

  if tok.number = UNKNOWN_TOKEN_NUMBER then
    begin
      if not find_numbered_token_by_value(tok, dic, inv_table_index, 
				          inv_parent, the_inv_item) then
	goto 90 { return } ;  { assertion message already issued }
      if the_inv_item <> NIL then
	begin { found it }
	  find_numbered_token := the_inv_item^.token;
	  if the_inv_item^.token = NIL then
	    begin
	      assert(206 { Nil token field in token list });
	    end
	  else the_inv_item^.token^.used := TRUE;
	end;
    end
  else
    begin
      if not find_numbered_token_by_number(tok, dic, table_index, 
				           parent, the_item) then
	goto 90 { return } ;  { assertion message already issued }

      find_numbered_token := the_item;
      if the_item <> NIL then the_item^.used := TRUE;
    end;
90:
end { find_numbered_token } ;


procedure delete_numbered_token(var {const} tok: numbered_token; 
			       var dic: numbered_dictionary);
  { Searches table for numbered token in specified dictionary. 
    If found, that token is deleted from the dictionary.
    (Deletion is implemented by marking the token USED=FALSE)
    Tok is NOT altered.                                   }
  var temp: numbered_token_ptr;
begin
  temp := find_numbered_token(tok, dic);
  if temp <> NIL then temp^.used := FALSE;
end { delete_numbered_token } ;


function enter_numbered_string(str: xtring;  var dic: numbered_dictionary):
  numbered_token_ptr;
  { enter the string into the dictionary and returns a pointer to
    the entered element (may return NIL if SEVERE brain damage is
    detected). NEVER return non-NIL token with a NIL value. }
  var
    temptok: numbered_token;
begin
  if dic.kind <> STRING_NUMBER then
    begin
      assert(224 { illegal dict insertion });
      writeln(cmplog, ' enter_numbered_string');
      enter_numbered_string := NIL;
    end
  else
    begin
      init_numbered_token(temptok, STRING_NUMBER);
      temptok.string_p := str;
      enter_numbered_string := insert_numbered_token(temptok, dic);
    end;
end { enter_numbered_string } ;


function enter_numbered_id(id: name_ptr;  var dic: numbered_dictionary):
  numbered_token_ptr;
  { enter the id into the dictionary and returns a pointer to
    the entered element (may return NIL if severe brain damage is
    detected).  }
  var
    temptok: numbered_token;
begin
  if dic.kind <> IDENTIFIER_NUMBER then
    begin
      assert(224 { illegal dict insertion });
      writeln(cmplog, ' enter_numbered_id');
      enter_numbered_id := NIL;
    end
  else
    begin
      init_numbered_token(temptok, IDENTIFIER_NUMBER);
      temptok.identifier_p := id;
      enter_numbered_id := insert_numbered_token(temptok, dic);
    end;
end { enter_numbered_id } ;


(**){--------------- NUMBERED_TOKEN  OUTPUT  ----------------------}


procedure output_numbered_token(var f: pipe; var tok: numbered_token; 
			       kind: numbered_token_type);
  { Prints a numbered token to f using the _continue routines.
    tok.output_number is the number that is used (as it is assumed that
    the dictionary has already been printed, thus the output number
    will match the number printed for the dictionary entry). }
begin
  case kind of
    IDENTIFIER_NUMBER: 
      begin
	pipe_dump_char(f, '#');
        if tok.output_number = UNKNOWN_TOKEN_NUMBER then
          begin
            assert(225 { should be defined });
            writeln(cmplog, ' output_numbered_token !');
	    pipe_dump_string_quoted(f, tok.string_p);
          end
	else pipe_dump_integer(f, tok.output_number);
      end;
    STRING_NUMBER: 
      begin
	pipe_dump_char(f, '$');
        if tok.output_number = UNKNOWN_TOKEN_NUMBER then
          begin
            assert(225 { should be defined });
            writeln(cmplog, ' output_numbered_token !');
	    pipe_dump_alpha(f, tok.identifier_p^.name);
          end
	else pipe_dump_integer(f, tok.output_number);
      end;
    OTHERWISE assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
  end;
end { output_numbered_token } ;


procedure lookup_and_print_string_continue(var f: pipe;
					   str: xtring;
					   var dic: numbered_dictionary);
  { looks up the string, if found prints it as number, if not prints
    it as literal  NOTE this procedure will not print anything if str
    is NIL, so calling procedure better be sure that it isn't }
  var
    temptok: numbered_token;    { for passing to find_numbered_token }
    result: numbered_token_ptr; { found entry } 
begin
  if str = NIL then
    begin
      assert(220 { NIL string});
      writeln(cmplog, ' lookup_and_print_string_continue ! ');
    end
  else if dic.kind <> STRING_NUMBER then
    begin
      assert(224 { illegal dict insertion });
      writeln(cmplog, ' lookup_and_print_string_continue ! ');
    end
  else
    begin
      pipe_dump_char(f, '$');
      init_numbered_token(temptok, STRING_NUMBER);
      temptok.string_p := str;
      result := find_numbered_token(temptok, dic);
      if result = NIL then pipe_dump_string_quoted(f, str)
      else if result^.output_number = UNKNOWN_TOKEN_NUMBER then
        begin
	  assert(225 {should not be there});
          writeln(cmplog, ' lookup_and_print_string_continue ! ');
	  pipe_dump_string_quoted(f, str);
	end
      else pipe_dump_integer(f, result^.output_number);
    end;
end { lookup_and_print_string_continue } ;


procedure lookup_and_print_id_continue(var f: pipe;
                                       id: name_ptr;
				       var dic: numbered_dictionary);
  { looks up the id, if found prints it as number, if not prints
    it as literal. }
  var
    temptok: numbered_token;    { for passing to find_numbered_token }
    result: numbered_token_ptr; { found entry } 
begin
  if id = NIL then
    begin
      assert(221 { NIL name_ptr });
      writeln(cmplog, ' lookup_and_print_id_continue ! ');
    end
  else if dic.kind <> IDENTIFIER_NUMBER then
    begin
      assert(224 { illegal dict insertion });
      writeln(cmplog, ' lookup_and_print_id_continue ! ');
    end
  else
    begin
      pipe_dump_char(f, '#');
      init_numbered_token(temptok, IDENTIFIER_NUMBER);
      temptok.identifier_p := id;
      result := find_numbered_token(temptok, dic);
      if result = NIL then pipe_dump_alpha(f, id^.name)
      else if result^.output_number = UNKNOWN_TOKEN_NUMBER then
        begin
	  assert(225 {should not be there});
          writeln(cmplog, ' lookup_and_print_id_continue ! ');
	  pipe_dump_alpha(f, id^.name);
        end
      else pipe_dump_integer(f, result^.output_number);
    end;
end { lookup_and_print_id_continue } ;


(**){------------- NUMBERED_DICTIONARY OPERATIONS --------------}


procedure output_numbered_dictionary(var f: pipe;
			    var dic: numbered_dictionary;
			    final_output: boolean);
  { Writes the dictionary to the (already opened for writing) file.
    If FINAL_OUTPUT, then the OUTPUT_NUMBER fields of the entries
    are set to "take up the slack" (so that numbers 1..n are used
    to represent n entries) and these OUTPUT_NUMBERs are written
    to correspond with the tokens.  
    Note that these OUTPUT_NUMBERs MUST then be used when 
    writing references to these tokens later in the file.
    If not FINAL_OUTPUT, then the usual NUMBERs are used and
    the OUTPUT_NUMBERs are set to match them.
    It is highly illegal to attempt to insert objects into a
    dictionary after it has been written for final output. }
  var
    i: numbered_token_table_range;  { current bucket index }
    nt: numbered_token_ptr;         { current element of bucket }


  procedure number_dictionary;
    { Assigns output_number := number for all entries in dictionary }
    var
      i: numbered_token_table_range; { current bucket }
      nt: numbered_token_ptr;        { entry in bucket }
  begin
    for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
      begin
	nt := dic.table[i];
	while nt <> NIL do 
	  begin
	    nt^.output_number := nt^.number;  nt := nt^.next;
	  end;
      end;
  end {number_dictionary } ;


  procedure renumber_dictionary;
    { Assigns numbers to output_number fields so as to compress
      the range of numbers used. }
    label
      90; { return }
    type
      ptr_table = array[numbered_token_table_range] of numbered_token_ptr;
    var
      i: numbered_token_range;           { current number }
      index: numbered_token_table_range; { current bucket }
      missing: numbered_token_range;     { number missing }
      ntptr: ptr_table;                  { current element of each bucket }
  begin
    dic.active := FALSE;  { No further insertions allowed }

    with dic do
      for index := 0 to LAST_NUMBERED_TOKEN_INDEX do
        ntptr[index] := table[index];

    missing := 0;
    index := 1;    { we never use 0 as a token number }

    for i := 1 to dic.highest do
      begin
	if ntptr[index] = NIL then missing := missing + 1
	else with ntptr[index]^ do 
	  begin
	    if number > i then missing := missing + 1
	    else if number = i then
	      begin
	        if used then output_number := i - missing
	        else 
		  begin
		    missing := missing + 1;
		    output_number := UNKNOWN_TOKEN_NUMBER;
		  end;
	        ntptr[index] := next;
	      end
	    else { < is a no-no }
	      begin
		assert(ASSERT_BUCKET_UNORDERED);
		number_dictionary;
		goto 90 { return } ;
	      end;
	  end;
	if index = LAST_NUMBERED_TOKEN_INDEX then index := 0
	else index := index + 1;
      end;
    dic.highest := dic.highest - missing;
  90:
  end { renumber_dictionary } ;


begin { output_numbered_dictionary }
  if final_output then renumber_dictionary
		  else number_dictionary;

  case dic.kind of

    IDENTIFIER_NUMBER:

      for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
	begin
          nt := dic.table[i];
	  while nt <> NIL do with nt^ do
	    begin
              if used then
                if output_number = UNKNOWN_TOKEN_NUMBER then
	          begin
	            assert(225 { UNKNOWN found });
		    writeln(cmplog, ' output_numbered_dictionary (id)');
		  end
		else
                  begin
		    pipe_dump_char(f, '!');
                    pipe_dump_integer(f, output_number);
		    pipe_dump_char(f, ' ');
                    pipe_dump_alpha(f, identifier_p^.name);
                    pipe_dump_CRLF(f);
                  end;
              nt := next;
	    end;
        end;

   STRING_NUMBER:

      for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
        begin
          nt := dic.table[i];
          while nt <> NIL do with nt^ do
	    begin
              if used then
                if output_number = UNKNOWN_TOKEN_NUMBER then
	          begin
	            assert(225 { UNKNOWN found });
		    writeln(cmplog, ' output_numbered_dictionary (string)');
		  end
		else
                  begin
		    pipe_dump_char(f, '!');
                    pipe_dump_integer(f, output_number);
                    pipe_dump_string_quoted(f, string_p);
                    pipe_dump_CRLF(f);
                  end;
              nt := next;
            end;
	end;

    OTHERWISE

      begin
	assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
      end;

  end { case } ;

  pipe_dump_char(f,';');   pipe_dump_CRLF(f);

end { output_numbered_dictionary } ;


procedure dump_numbered_dictionary(var f: textfile;
			    var dic: numbered_dictionary);
  { dump the numbered dictionary to file f (for debugging purposes) }
  var
    i: numbered_token_table_range;  { current bucket index }
    nt: numbered_token_ptr;         { current element of bucket }
begin
  write(f, ' Number Out-number Used');

  case dic.kind of

    IDENTIFIER_NUMBER:
      begin
        writeln(f, ' Identifier');  writeln(f);

        for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
	  begin
            nt := dic.table[i];
	    while nt <> NIL do with nt^ do
              begin
                write(f, ' ', number:6, output_number:11);
		if used then write(f, '    T ')
		        else write(f, '    F ');
                if identifier_p = NIL then write(f, '<NIL> (bad!)')
                else writealpha(f, identifier_p^.name);
		writeln(f);
                nt := next;
              end;
          end;
      end;

   STRING_NUMBER:
     begin
       writeln(f, ' String');  writeln(f);

        for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
	  begin
            nt := dic.table[i];
	    while nt <> NIL do with nt^ do
              begin
                write(f, ' ', number:6, output_number:11);
		if used then write(f, '    T ')
		        else write(f, '    F ');
                if string_p = NIL then write(f, '<NIL> (bad!)')
                else writestring(f, string_p);
		writeln(f);
                nt := next;
              end;
          end;
      end;

    OTHERWISE

      begin
        writeln(f, ' ???? (bad)');
	assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
      end;

  end { case } ;

  writeln(f);
end { dump_numbered_dictionary } ;


procedure release_numbered_dictionary(var dic: numbered_dictionary);
  { releases of all entries into the dictionary by insertion into
    freelists.  This disposal affects ONLY the numbered_token
    and numbered_token_list records in the dictionary -- it does
    not affect the XTRINGs and NAME_ELEMENTs to which they refer. 
    When done, the dictionary is empty, has same type, and is ready to go. }
  var
    i: numbered_token_table_range;  { current bucket index }
begin
  with dic do
    begin
      for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
	begin
	  while table[i] <> NIL do release_numbered_token(table[i], kind);
	  release_all_numbered_token_lists(inverted_table[i]);
	end;
      highest := 0;
      active := TRUE;
    end;
end { release_numbered_dictionary } ;


procedure init_numbered_dictionary(*var dic: numbered_dictionary; 
			  token_kind: numbered_token_type*);
  { Initializes the dictionary to empty -- it is assumed to contain
    garbage values. }
  var
    i: numbered_token_table_range;  { current bucket index }
begin
  with dic do
    begin
      highest := 0;
      kind := token_kind;
      active := TRUE;
      for i := 0 to LAST_NUMBERED_TOKEN_INDEX do
	begin
	  table[i] := NIL;
	  inverted_table[i] := NIL;
	end;
    end;
end { init_numbered_dictionary } ;


(**){------------- NUMBERED_TOKEN PARSING --------------}


procedure parse_numbered_dictionary(var dic: numbered_dictionary);
  { Parses a numbered dictionary section of the parse file.
    The dic.kind field is expected to indicate the type of token 
    expected, and dic is expected to have been initialized. 
    The routine ends with sy being the token following the SEMI
    which ends the dictionary (or (an error condition) the ENDSY
    or ENDOFDATASY that was prematurely encountered)   }
  label
    10, { cycle }
    90; { return }
  var
    end_symbols: setofsymbols;  { symbols indicating the end of the section }
    skip_symbols: setofsymbols; { symbols for recovery (heaven forbid) }
    kind: numbered_token_type;  { value of dic.kind }
    tok: numbered_token;        { the token that has just been parsed }
    assert_expected_token: 
      assert_range;             { assertion message for expected token }
    tokptr: numbered_token_ptr; { returned ptr to table entry }
    token_sy: symbols;          { expected token symbol (STRINGS or IDENT)}
begin
  end_symbols := [SEMI,ENDOFDATASY,ENDSY];
  skip_symbols := end_symbols + [EXCLAMATION,SEMI];
  kind := dic.kind;
  init_numbered_token(tok, dic.kind);
  case kind of
    IDENTIFIER_NUMBER:
      begin
	tok.identifier_p := NIL;
	token_sy := IDENT;
	assert_expected_token := ASSERT_EXPECTED_IDENT;
      end;
    STRING_NUMBER:
      begin
	tok.string_p := NIL;
	token_sy := STRINGS;
	assert_expected_token := ASSERT_EXPECTED_STRINGS;
      end;
    OTHERWISE 
      begin
	assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	skip(end_symbols);
	goto 90 { return } ;
      end;
  end;

  while not (sy in end_symbols) do
    begin
      if sy = EXCLAMATION then insymbol
      else
	begin
	  assert(ASSERT_EXPECTED_EXCLAMATION);
	  skip(skip_symbols);
	  goto 10 { cycle } ;
	end;
      if sy <> CONSTANT then
	begin
	  assert(ASSERT_EXPECTED_CONSTANT);
	  skip(skip_symbols);
	  goto 10 { cycle } ;
	end;
      if const_val <= 0 then
	begin
	  assert(124 { entry number out of range });
	  skip(skip_symbols);
	  goto 10 { cycle } ;
	end;
      tok.number := const_val;  insymbol;
      if sy <> token_sy then
	begin
	  assert(assert_expected_token);
	  skip(skip_symbols);
	  goto 10 { cycle } ;
	end;
      case kind of 
	IDENTIFIER_NUMBER: tok.identifier_p := id.name;
	STRING_NUMBER: tok.string_p := lex_string;
	OTHERWISE 
	  begin
	    assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	    skip(end_symbols);
	    goto 90 { return } ;
	  end;
      end;
      tokptr := insert_numbered_token(tok, dic);  
      tokptr^.used := FALSE;
      insymbol;
    10:
    end;
  if sy <> SEMI then
    begin
      assert(116 { unexpected end of data });
    end
  else insymbol;
90:
end { parse_numbered_dictionary } ;


function parse_numbered_token(var dic: numbered_dictionary): 
  numbered_token_ptr;
  { Parses a numbered token of the given type.  If syntax errors
    prevent this, or it is not found in the table, returns NIL.
    Otherwise, returns a pointer to the dictionary entry of the token. 
    Expects the token to be of the same type as the dictionary, and 
    expects that it can be found in the dictionary. }
  label
    90; { return }
  var
    tok: numbered_token;       { for parsed value of number }
    found: numbered_token_ptr; { found dictionary entry } 
begin
  parse_numbered_token := NIL;
  case dic.kind of
    IDENTIFIER_NUMBER: if sy <> SHARP then
      begin
	assert(114 { expected # });
	insymbol;
	goto 90 { return } ;
      end;
    STRING_NUMBER: if sy <> DOLLAR then
      begin
	assert(115 { expected $ });
	insymbol;
	goto 90 { return } ;
      end;
    OTHERWISE
      begin
	assert(ASSERT_UNRECOGNIZED_TOKEN_TYPE);
	insymbol;
	goto 90 { return } ;
      end;
  end;
  insymbol; { eat the prefix }
  init_numbered_token(tok, dic.kind);
  if sy = CONSTANT then
    begin
      if (const_val <= 0) then
        begin
	  assert(124 { out of range });
	  goto 90 { return } ;
	end;
      tok.number := const_val;
      insymbol;
      found := find_numbered_token(tok, dic);
      if found = NIL then
        begin
          assert(207 { numbered token not found });
          goto 90 { return } ;
        end;
    end
  else if sy = STRINGS then
    begin
      if dic.kind <> STRING_NUMBER then
        begin
          assert(123 { expected numb string });  goto 90 { return } ;
        end;
      tok.string_p := lex_string;  insymbol;
      found := insert_numbered_token(tok, dic);
    end
  else if sy = IDENT then
    begin
      if dic.kind <> IDENTIFIER_NUMBER then
        begin
          assert(122 { expected numb id });  goto 90 { return } ;
        end;
      tok.identifier_p := id.name;  insymbol;
      found := insert_numbered_token(tok, dic);
    end
  else
    begin
      if dic.kind = STRING_NUMBER then assert(123)
                                  else assert(122);
      writeln(cmplog, 'sy=', ord(sy):1);
      goto 90 { return } ;
    end;
  parse_numbered_token := found;
90:
end { parse_numbered_token } ;
  

(**)     { ------- display error summaries ------- }


procedure display_error_summaries;
  { display error information for the entire compile on each output file }


  procedure display_error_message(var f: textfile);
    { display the error total with attention to number }
  begin
    if num_errors = 0 then
      writeln(f, ' No errors detected')
    else if num_errors = 1 then
      writeln(f, ' 1 error detected')
    else
      writeln(f, ' ', num_errors:1, ' errors detected');
  end { display_error_message } ;


  procedure display_warning_message(var f: textfile);
    { display the warning total with attention to number }
  begin
    if num_warnings = 0 then
      writeln(f, ' No warnings detected')
    else if num_warnings = 1 then
      writeln(f, ' 1 warning detected')
    else
      writeln(f, ' ', num_warnings:1, ' warnings detected');
  end { display_warning_message } ;


  procedure display_oversight_message(var f: textfile);
    { display the oversight total with attention to number }
  begin
    if num_oversights = 0 then
      writeln(f, ' No oversights detected')
    else if num_oversights = 1 then
      writeln(f, ' 1 oversight detected')
    else
      writeln(f, ' ', num_oversights:1, ' oversights detected');
  end { display_oversight_message } ;


  procedure display_baseball_message(var f: textfile);
    { display a Baseball message if appropriate }
  begin
    if produce_amusing_messages then
      if (num_errors = 0) and (num_oversights = 0) and (num_warnings = 0) then
        writeln(f, ' No men left on base')
      else if num_errors >= max_errors then
        writeln(f, ' Extreme bogosity in this design')
      else if num_errors = 1 then
        writeln(f, ' 1 error?  Close, but no cigar');
  end { display_baseball_message } ;


begin { display_error_summaries }
  if debug_20 then writeln(outfile, ' enter display_error_summaries');
  if PrintCmpLst then
    begin
      writeln(CmpLst);
      writeln(CmpLst);
      display_error_message(CmpLst);
      display_oversight_message(CmpLst);
      display_warning_message(CmpLst);
      display_baseball_message(CmpLst);
    end;

  writeln(monitor);
  write(monitor,'  ');  display_error_message(monitor);
  write(monitor,'  ');  display_oversight_message(monitor);
  write(monitor,'  ');  display_warning_message(monitor);
  write(monitor,'  ');  display_baseball_message(monitor);

  writeln(CmpLog);
  write(CmpLog,'  ');  display_error_message(CmpLog);
  write(CmpLog,'  ');  display_oversight_message(CmpLog);
  write(CmpLog,'  ');  display_warning_message(CmpLog);
  write(CmpLog,'  ');  display_baseball_message(CmpLog);

  if PrintCmpErr then 
    if last_error <> 0 then writeln(CmpErr, 'end_error;');
  if debug_20 then writeln(outfile, ' exit display_error_summaries');
end { display_error_summaries } ;


(**)     { ------- parameter sorting ------- }


{ Parameter lists are sorted so that SIZE is first, followed by the other
  parameters in leicographic order of parameter name.  Note that no
  name can appear more than once in a parameter list. }

function compare_parameter_names(name1, name2: name_ptr): compare_type;
begin
  case compare_identifiers(name1, name2) of
    LT: 
      if (name2 = SIZE_prop_name) then 
        compare_parameter_names := GT
      else compare_parameter_names := LT;
    GT: 
      if (name1 = SIZE_prop_name) then 
        compare_parameter_names := LT
      else compare_parameter_names := GT;
    EQ: compare_parameter_names := EQ;
  end;
end { compare_parameter_names } ;
      

procedure sort_param_properties(var head: property_ptr);
  { Sorts the (parameter) properties in compare_parameter_names order 
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and n-squared), but are quietly handled. }
  var
    next_element: property_ptr;  { next element to be checked }
    parent: property_ptr;        { parent of next_element }
    insert_point: property_ptr;  { new parent of next_element }
    comparison: compare_type;    { relation of elements being checked }
begin
  parent := head;
  if parent = NIL then next_element := NIL
		  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      case compare_parameter_names(next_element^.name, parent^.name) of
	EQ: 
	  begin
	  { assert(ASSERT_DUPLICATE_PARAMETERS); }{ who cares - just delete it}
	    delete_property(parent^.next);
	  end;
        GT: parent := next_element;
        LT: { out of order - move it }
	  begin
	    parent^.next := next_element^.next;
	    case compare_parameter_names(next_element^.name, head^.name) of
	      EQ:
		begin
		  next_element^.next := NIL;
		  delete_property(next_element);
		end;
	      LT:
		begin
		  next_element^.next := head;
		  head := next_element;
		end;

	      GT:
		begin
		  insert_point := head;
		  comparison := 
		    compare_parameter_names(next_element^.name, 
		                            insert_point^.next^.name);
		  while comparison = GT do
		    begin
		      insert_point := insert_point^.next;
		      comparison := 
		        compare_parameter_names(next_element^.name,
			                        insert_point^.next^.name);
		    end;
		  if comparison = EQ then
		    begin
		      next_element^.next := NIL;
		      release_property(next_element);
		    end
		  else
		    begin 
		      next_element^.next := insert_point^.next;
		      insert_point^.next := next_element;
		    end;
		end { GT } ;
	    end { case } ;
	  end { LT -> out of order } ;
      end { case } ;
      next_element := parent^.next;
    end { while } ;
end { sort_param_properties } ;


(**)     { ------- error routine ------- }


procedure error(*error_num: error_range*);
  { write out offending line and display error }


  procedure dump_error_message(error_num: error_range);
    { display the error message to the appropriate files }


    procedure write_error(var f: textfile; num: error_range;
                          indent: boolean);
      { write the error message (and possibly the parse string) to the file }
    begin
      writeln(f);
      if (num IN parse_errors) and not ignore_parse_errors then
        print_input_line(f, num, indent);
      if indent then write(f, '  ');
      if command = COMPERR_COMMAND then write(f, ' <COMPERR>')
      else write(f, ' #', num_errors:1);
      writeln(f, ' ERROR(', num:1, '): ', error_strings[num]);
    end { write_error } ;


    procedure write_oversight(var f: textfile; num: error_range;
                              indent: boolean);
      { write the oversight message (and possibly the parse string) to file }
    begin
      writeln(f);
      if (num IN parse_errors) and not ignore_parse_errors then 
        print_input_line(f, num, indent);
      if indent then write(f, '  ');
      if command = COMPERR_COMMAND then write(f, ' <COMPERR>')
      else write(f, ' #', num_oversights:1);
      writeln(f, ' OVERSIGHT(', num:1, '): ', error_strings[num]);
    end { write_oversight } ;

    
    procedure write_warning(var f: textfile; num: error_range; 
                            indent: boolean);
      { write the warning message (and possibly the parse string) to the file }
    begin
      writeln(f);
      if (num IN parse_errors) and not ignore_parse_errors then
        print_input_line(f, num, indent);
      if indent then write(f, '  ');
      if command = COMPERR_COMMAND then write(f, ' <COMPERR>')
      else write(f, ' #', num_warnings:1);
      writeln(f, ' WARNING(', num:1, '): ', error_strings[num]);
    end { write_warning } ;

    
  begin { dump_error_message }
    if (error_num IN warning_errors) then
      begin
        if display_warnings and not (error_num IN suppress_errors) then
          begin
            num_warnings := num_warnings + 1;
	    if command = COMPERR_COMMAND then indent := 11
	    else indent := width_of_integer(num_warnings) + 3;
            errors_encountered := errors_encountered + [error_num];
            if PrintCmpLst then write_warning(CmpLst, error_num, FALSE)
                           else write_warning(monitor, error_num, FALSE);
          end;
        write_warning(CmpLog, error_num, PrintCmpLst);
        if debug_25 then
          begin
            writeln(Outfile, 'at error:');
            dump_parse_state(outfile, TRUE);
          end;
        if debugging then write_warning(outfile, error_num, FALSE);
      end
    else if (error_num IN oversight_errors) then
      begin
        if display_oversights and not (error_num IN suppress_errors) then
          begin
            num_oversights := num_oversights + 1;
	    if command = COMPERR_COMMAND then indent := 11
	    else indent := width_of_integer(num_oversights) + 3;
            errors_encountered := errors_encountered + [error_num];
            if PrintCmpLst then write_oversight(CmpLst, error_num, FALSE)
                           else write_oversight(monitor, error_num, FALSE);
          end;
        write_oversight(CmpLog, error_num, PrintCmpLst);
        if debug_25 then
          begin
            writeln(Outfile, 'at error:');
            dump_parse_state(outfile, TRUE);
          end;
        if debugging then write_oversight(outfile, error_num, FALSE);
      end
    else
      begin
	errors_encountered := errors_encountered + [error_num];
	num_errors := num_errors + 1;
	if command = COMPERR_COMMAND then indent := 11
	else indent := width_of_integer(num_errors) + 3;

	if PrintCmpLst then write_error(CmpLst, error_num, FALSE)
		       else write_error(monitor, error_num, FALSE);

	write_error(CmpLog, error_num, PrintCmpLst);
	if debug_25 then
	  begin
	    writeln(Outfile, 'at error:');
	    dump_parse_state(outfile, TRUE);
	  end;
	if debugging then write_error(outfile, error_num, FALSE);

	if (error_num IN echo_to_monitor_errors) and PrintCmpLst then
	      write_error(monitor, error_num, PrintCmpLst);
      end;
  end { dump_error_message } ;


  procedure output_graphics_editor_error(num: error_range);
    { output some stuff to the graphics editor }
    var
      stack_pos: stack_index_range;   { index into the parse stack }
      done: boolean;                  { TRUE when correct signal found }
  begin
    if not (num IN warning_errors) then
      begin
        if last_error <> 0 then writeln(CmpErr, 'end_error;');
        writeln(CmpErr, 'error');
        writeln(CmpErr, '  message = ''#', num_errors:1, ' ERROR(',
                        num:1, '): ', error_strings[num], ''';');
        if (num IN parse_errors) and not ignore_parse_errors then
          begin
            write(CmpErr, '  signal = ');
            if how_to_parse = parse_transparently then
              begin
                stack_pos := stack_top;  done := FALSE;
                while (stack_pos > 0) and not done do
                  if stack[stack_pos].how <> parse_transparently then
                    done := TRUE
                  else
                    stack_pos := stack_pos - 1;
                print_string(CmpErr, stack[stack_pos].str);
              end
            else
              print_string(CmpErr, instring);

            writeln(CmpErr, ';');
          end;
      end;
  end { output_graphics_editor_error } ;


begin { error }
  dump_error_message(error_num);

  { output some graphics editor stuff }
  if PrintCmpErr then output_graphics_editor_error(error_num);

  last_error := error_num;
  ok_to_print_error := not(error_num IN suppress_errors) and
                   (not(error_num IN warning_errors) or display_warnings) and
                   (not(error_num IN oversight_errors) or display_oversights);
  if (error_num IN parse_errors) and not ignore_parse_errors then
    error_dump_current_parse_environment;
end { error } ;
    
            
procedure error_dump_context(context: property_ptr; extra_indent: integer);
  { identify this context for the current error message }
  var
    param: property_ptr;  { current parameter }
begin
  if context = NIL then
    begin
      error_dump_indent(indent + extra_indent);
      error_dump_alpha('No parameters.  ');
      error_dump_CRLF;
    end;
  param := context;
  while param <> NIL do
    begin
      error_dump_indent(indent + extra_indent);
      error_dump_alpha(param^.name^.name);
      error_dump_char('=');
      error_dump_char(OUTPUT_QUOTE_CHAR);
      error_dump_string(param^.text);
      error_dump_char(OUTPUT_QUOTE_CHAR);
      error_dump_CRLF;
      param := param^.next;
    end;
end { error_dump_context } ;


procedure error_without_parse_line(*num: integer*);
  { print error message, but don't do special "parse error" processing.
    This is for use by C++ or C modules that handle parse errors separately. }
  var
    save: boolean;
begin
  save := ignore_parse_errors;
  ignore_parse_errors := TRUE;
  error(num);
  ignore_parse_errors := save;
end { error_without_parse_line } ;


procedure assert_without_parse_line(*num: integer*);
  { print assert message, but don't do special "parse error" processing.
    This is for use by C++ or C modules that handle parse errors separately. }
  var
    save: boolean;
begin
  save := ignore_parse_errors;
  ignore_parse_errors := TRUE;
  assert(num);
  ignore_parse_errors := save;
end { assert_without_parse_line } ;


procedure error_dump_standard_indent;
  { for use by C++ stuff so it does not need to directly access "indent" }
begin
    error_dump_indent(indent);
end { error_dump_standard_indent } ;


procedure error_dump_current_context;
  { for use by C++ stuff so it does not need to directly access the PASCAL
    data structures. }
  var
    props: property_ptr;


  function props_from_symbol_table(ids: identifier_ptr): property_ptr;
    var
      head: property_ptr;
  begin
    head := NIL;
    while ids <> NIL do
      begin
        add_to_prop_list(head, ids^.name, ids^.definition);
	ids := ids^.next;
      end;
    sort_param_properties(head);
    props_from_symbol_table := head;
  end { props_from_symbol_table } ;


begin
    if current_mtree_node^.father_node = NIL then
      error_dump_context(specified_context, 8 { length of "Drawing=" })
    else
      begin { An error on a plumbing body -- probably a selection error }
	{ Assume that the drawing has not been read, thus the symbol table
	  reflects just the parameters in the instance. }

        props := props_from_symbol_table(current_mtree_node^.symbol_table);
	error_dump_context(props, 8 { length of "Drawing=" });
	release_entire_property_list(props);
      end;
end { error_dump_current_context } ;


(**)     { ------- assertion failure routine ------- }


procedure assert(*assertion_num: assert_range*);
  { display the assertion failure message to the appropriate files }

  
  procedure write_assertion_message(var f: textfile;  num: assert_range;
                                    indent: boolean);
    { display the message }
  begin
    if (num in parse_asserts) and not ignore_parse_errors then
      print_input_line(f, 0, indent);
    if indent then write(f, '  ');
    writeln(f, ' ASSERTION FAILURE(', num:1, '): ', assert_strings[num]);
    if not ignore_parse_errors then error_dump_current_parse_environment;

    if produce_amusing_messages then
      begin
        if indent then write(f, '  ');
        if (num MOD 4) = 0 then
         writeln(f, ' There''s something wicked in the state of Denmark')
        else if (num MOD 4) = 1 then
          writeln(f, ' Bogons have been sighted!')
        else if (num MOD 4) = 2 then
          writeln(f, ' Extreme brain damage has been detected!')
        else if (num MOD 4) = 3 then
          writeln(f, ' Help me Landru! Help me Landru!');
      end;
  end { write_assertion_message } ;


begin { assert }
  error(187);      { tell the normal world about internal screw up }
  write_assertion_message(CmpLog, assertion_num, PrintCmpLst);
  if (command = COMPERR_COMMAND) and PrintCmpLst then
    write_assertion_message(CmpLst, assertion_num, FALSE);
  if debugging then write_assertion_message(outfile, assertion_num, FALSE);
end { assert } ;


(**)     { ------- Close all files used by Compiler ------- }


procedure close_all_files;
  { close the files still open }
begin
  if debug_20 then writeln(outfile, ' enter close_all_files -- bye bye');
  if PrintCmpErr then 
    begin
      writeln(CmpErr, 'END.');
      close_file(CmpErr, CmpErr_file_name, nullstring);
    end;
  if not debugging then
    if file_exists(temp_file_name) then if remove_file(temp_file_name) then ;
  close_file(monitor, MONITOR_FILE_NAME, nullstring);
  close_file(CmpLog, CMPLOG_FILE_NAME, nullstring);
  if debugging then close_file(outfile, DEBUG_FILE_NAME, nullstring);
end { close_all_files } ;


(**){--------------- NEW & RELEASE for SCHEMA STRUCTURES --------}


{---------------------------------------------------------------}
{ All new routines for schema objects obtain a new object and   }
{ insert it to the head of the list.  All release routines      }
{ (for these) delete the object from its list.                  }
{ All release_entire... routines and release_all.. routines     }
{ relase an entire list and  return NIL.                        }
{ Examples:                                                     }
{   new_object(head_of_list);                                   }
{   new_object(parent_of_new_one^.next);                        }
{   release_object(head_of_list);                               }
{   release_entire_list(head_of_list);                          }
{   release_object(parent_of_one_to_delete^.next);              }
{---------------------------------------------------------------}


procedure new_text_macro(var head: text_macro_ptr);
  { Gets a new text_macro (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: text_macro_ptr; { new one }
begin
  if free_text_macros <> NIL then
    begin  
      newone := free_text_macros;  
      free_text_macros := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_TEXT_MACRO, 3*POINTER_SIZE+BOOL_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      name := NIL;
      text := NIL;
      reserved := FALSE;
    end;
  head := newone;
end { new_text_macro } ;


procedure release_text_macro(var head: text_macro_ptr);
  { Releases a text_macro for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: text_macro_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_text_macros;
      free_text_macros := old;
    end;
end { release_text_macro } ;


procedure release_all_text_macros(var head: text_macro_ptr);
  { releases a text_macro list by insertion into freelist. Returns NIL. }
  var
    last: text_macro_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_text_macros;
      free_text_macros := head;
      head := NIL;
    end;
end { release_all_text_macros } ;


procedure new_expandable_id(var head: expandable_id_ptr);
  { Gets a new expandable_id (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: expandable_id_ptr; { new one }
begin
  if free_expandable_ids <> NIL then
    begin  
      newone := free_expandable_ids;  
      free_expandable_ids := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_EXPANDABLE_ID, 2*POINTER_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      name := NIL;
    end;
  head := newone;
end { new_expandable_id } ;


procedure release_expandable_id(var head: expandable_id_ptr);
  { Releases a expandable_id for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: expandable_id_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_expandable_ids;
      free_expandable_ids := old;
    end;
end { release_expandable_id } ;


procedure release_all_expandable_ids(var head: expandable_id_ptr);
  { releases a expandable_id list by insertion into freelist. Returns NIL. }
  var
    last: expandable_id_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_expandable_ids;
      free_expandable_ids := head;
      head := NIL;
    end;
end { release_all_expandable_ids } ;


procedure new_dependency_list(var head: dependency_list_ptr);
  { Gets a new text_macro (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: dependency_list_ptr; { new one }
begin
  if free_dependency_lists <> NIL then
    begin  
      newone := free_dependency_lists;  
      free_dependency_lists := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_DEPENDENCY_LIST, 2*POINTER_SIZE+INT_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      file_name := NIL;
      last_modified_time := 0;
    end;
  head := newone;
end { new_dependency_list } ;


procedure release_dependency_list(var head: dependency_list_ptr);
  { Releases a dependency_list for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: dependency_list_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_dependency_lists;
      free_dependency_lists := old;
    end;
end { release_dependency_list } ;


procedure release_all_dependency_lists(var head: dependency_list_ptr);
  { releases a dependency_list list by insertion into freelist. Returns NIL. }
  var
    last: dependency_list_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_dependency_lists;
      free_dependency_lists := head;
      head := NIL;
    end;
end { release_all_dependency_lists } ;


procedure new_compiled_context_list(var head: compiled_context_list_ptr);
  { Gets a new compiled_context_list element,
    initializes it and inserts it at the head of the list. }
  var
    newone: compiled_context_list_ptr; { new one }
begin
  if free_compiled_context_lists <> NIL then
    begin  
      newone := free_compiled_context_lists;  
      free_compiled_context_lists := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_COMPILED_CONTEXT_LIST, 2*POINTER_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      context := NIL;
      dirty := FALSE;
      dirty_for_pass_2 := FALSE;
    end;
  head := newone;
end { new_compiled_context_list } ;


procedure release_compiled_context_list(var head: compiled_context_list_ptr);
  { Releases a compiled_context_list for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: compiled_context_list_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_compiled_context_lists;
      free_compiled_context_lists := old;
    end;
end { release_compiled_context_list } ;


procedure release_all_compiled_context_lists(var head: compiled_context_list_ptr);
  { releases a compiled_context_list list by insertion into freelist. Returns NIL. }
  var
    last: compiled_context_list_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_compiled_context_lists;
      free_compiled_context_lists := head;
      head := NIL;
    end;
end { release_all_compiled_context_lists } ;


procedure new_paged_schema(var head: paged_schema_ptr);
  { Gets a new paged_schema (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: paged_schema_ptr; { new one }
begin
  if free_paged_schemas <> NIL then
    begin  
      newone := free_paged_schemas;  
      free_paged_schemas := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_PAGED_SCHEMA, 
			   7*POINTER_SIZE+3*INT_SIZE+BOOL_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      drawing_type := NIL;
      version := 0;
      page := 0;
      last_modified_time := 0;
      expandable_ids := NIL;
      local_text_macros := NIL;
      dependencies := NIL;
      properties := NIL;
      compiled_contexts := NIL;
      { has_expr := FALSE; } { obsolete }
      make_performed := FALSE;
    end;
  head := newone;
end { new_paged_schema } ;


procedure release_paged_schema(var head: paged_schema_ptr);
  { Releases a paged_schema for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: paged_schema_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      release_all_expandable_ids(head^.expandable_ids);
      release_all_numbered_token_lists(head^.properties);
      release_all_text_macros(head^.local_text_macros);
      release_all_dependency_lists(head^.dependencies);
      release_all_compiled_context_lists(head^.compiled_contexts);
      old := head;
      head := head^.next;
      old^.next := free_paged_schemas;
      free_paged_schemas := old;
    end;
end { release_paged_schema } ;


procedure release_all_paged_schemas(var head: paged_schema_ptr);
  { releases a paged_schema list by insertion into freelist. Returns NIL. }
begin
  while head <> NIL do release_paged_schema(head);
end { release_all_paged_schemas } ;


procedure new_parameter(var head: parameter_ptr);
  { Gets a new parameter (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: parameter_ptr; { new one }
begin
  if free_parameters <> NIL then
    begin  
      newone := free_parameters;  
      free_parameters := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_PARAMETER, 3*POINTER_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      name := NIL;
      text := NIL;
    end;
  head := newone;
end { new_parameter } ;


procedure release_parameter(var head: parameter_ptr);
  { Releases a parameter for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: parameter_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_parameters;
      free_parameters := old;
    end;
end { release_parameter } ;


procedure release_all_parameters(var head: parameter_ptr);
  { releases a parameter list by insertion into freelist. Returns NIL. }
  var
    last: parameter_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_parameters;
      free_parameters := head;
      head := NIL;
    end;
end { release_all_parameters } ;


procedure new_context_definition(var head: context_definition_ptr);
  { Gets a new context_definition (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: context_definition_ptr; { new one }
begin
  if free_context_definitions <> NIL then
    begin  
      newone := free_context_definitions;  
      free_context_definitions := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_CONTEXT_DEFINITION,
                           2*POINTER_SIZE+2*INT_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      number := 0;
      version := 1;
      parameters := NIL;
    end;
  head := newone;
end { new_context_definition } ;


procedure release_context_definition(var head: context_definition_ptr);
  { Releases a context_definition for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: context_definition_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      release_all_parameters(head^.parameters);
      old := head;
      head := head^.next;
      old^.next := free_context_definitions;
      free_context_definitions := old;
    end;
end { release_context_definition } ;


procedure release_all_context_definitions(var head: context_definition_ptr);
  { releases a context_definition list by insertion into freelist. 
    Returns NIL. }
begin
  while head <> NIL do release_context_definition(head);
end { release_all_context_definitions } ;


procedure new_property_attribute(var head: property_attribute_ptr);
  { Gets a new property_attribute (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: property_attribute_ptr; { new one }
begin
  if free_property_attributes <> NIL then
    begin  
      newone := free_property_attributes;  
      free_property_attributes := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_PROPERTY_ATTRIBUTE,
                           2*POINTER_SIZE+INT_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      property := NIL;
      attributes := [];
    end;
  head := newone;
end { new_property_attribute } ;


procedure release_property_attribute(var head: property_attribute_ptr);
  { Releases a property_attribute for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: property_attribute_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      old := head;
      head := head^.next;
      old^.next := free_property_attributes;
      free_property_attributes := old;
    end;
end { release_property_attribute } ;


procedure release_all_property_attributes(var head: property_attribute_ptr);
  { releases a property_attribute list by insertion into freelist. 
    Returns NIL. }
  var
    tail: property_attribute_ptr;
begin
  if head <> NIL then
    begin
      tail := head;
      while tail^.next <> NIL do tail := tail^.next;
      tail^.next := free_property_attributes;
      free_property_attributes := head;
      head := NIL;
    end;
end { release_all_property_attributes } ;


procedure release_all_schema_fields(var schema: schema_definition);
  { releases all fields of the schema. When done, all is as if the
    schema had just been initialized. }
begin
  with schema do
    begin
      release_numbered_dictionary(id_dictionary);
      release_numbered_dictionary(string_dictionary);
      release_all_paged_schemas(paged_schemas);
      release_all_text_macros(used_global_TMs);
      release_all_context_definitions(contexts);
      release_all_property_attributes(used_properties);
      release_entire_property_list(local_TMs);
      local_TMs_defined := FALSE;
      file_name := nullstring;
      directory := NIL;
      file_accessible := FALSE;
      changed := FALSE;
      bubble_check := FALSE;
      enable_cardinal_tap := FALSE;
    end;
end { release_all_schema_fields } ;


(**){----------- SCHEMA HANDLING --------------------------------}


procedure dump_text_macros(*var f: textfile; list: text_macro_ptr*);
  { dump the list of text macros to f for debugging purposes. }
  var
    tm: text_macro_ptr;   { current text macro }
begin
  tm := list;
  if tm = NIL then writeln(f, ' <NIL>')
  else repeat
    write(f, ' ');
    writealpha(f, tm^.name^.identifier_p^.name);
    write(f, '=');
    writestring(f, tm^.text^.string_p);
    tm := tm^.next;
    if tm = NIL then writeln(f, ';')
    else
      begin
        writeln(f, ',');  write(f, '   ');
      end;
  until tm = NIL;
end { dump_text_macros } ;


procedure add_to_dependency_list(fi: plumbing_page_ptr);
  { adds the file name to the dependency list for the page being compiled,
    inserting it into the dictionary for the schema file. }
  var
    entry: dependency_list_ptr;    { an entry already in list }
    found: boolean;                { TRUE iff name is already in list }
    number: numbered_token_ptr;    { schema string dictionary entry for name }
    name: xtring;                  { name of file being added }
begin
  name := fi^.filename;
  if debug_24 then
    begin
      write(outfile, ' depends on ');
      dump_string(outfile, name);
      writeln(outfile);
    end;

  entry := paged_schema_of_this_page.dependencies;  found := FALSE;
  while not found and (entry <> NIL) do
    if entry^.file_name^.string_p = name then found := TRUE
                                         else entry := entry^.next;
  if not found then
    begin
      if fi^.last_modified_time = 0 then
        if not get_time_stamp(name, fi^.last_modified_time) then ;
      number := enter_numbered_string(name, 
	          schema_of_drawing_being_compiled.string_dictionary);
      if number <> NIL then
        begin
          new_dependency_list(paged_schema_of_this_page.dependencies);
          paged_schema_of_this_page.dependencies^.file_name := number;
	  paged_schema_of_this_page.dependencies^.last_modified_time :=
	    fi^.last_modified_time;
	end;
    end;
end { add_to_dependency_list } ;


procedure log_used_global_TMs_in_schema(var schema: schema_definition);
  { This routine updates the global text macro list in the schema file.
    It first removes the old one and then creates a new one by perusing
    the expandable id lists and adding an appropriate entry for each 
    expandable id (whether globally defined or not).  Undefined
    identifiers are output with nullstring as their definition (and not
    reserved).
    
    This routine is to be called immediately before outputting the
    schema file for the drawing being compiled. 
    The expandable id lists are assumed to be sorted in 
    ascending order of id number.  The list is guaranteed to be kosher
    (in order, with no NIL numbered tokens or NIL numbered_token values) }
  var
    current_page: paged_schema_ptr;     { schema of current page }
    current_tm: text_macro_ptr;         { current expandable id }
    current_exp_id: expandable_id_ptr;  { current expandable id }
    nullstring_tok: numbered_token_ptr; { numbered token for nullstring }


  procedure insert_TM(name: numbered_token_ptr);
    { Insert name into used_global_TMs list if not already there.
      Update current_tm to point to the element representing name. }
    var
      temp: text_macro_ptr;    { current element in search }
      done: boolean;           { TRUE when element or insert point is found }
      def: numbered_token_ptr; { definition of text macro (if new) }        
      found: boolean;          { TRUE iff entry already exists }
  begin

    { safety check  - orders TM list even if exp id list is not }

    if current_tm <> NIL then
      if current_tm^.name^.number >= name^.number then
	begin
	  { the exp_id list must be out of order - could put an
	    assertion message here. }
	  current_tm := NIL;  { start search at head of list }
	end;
    
    { find element or insertion point }

    if current_tm = NIL then temp := schema.used_global_TMs
    else temp := current_tm^.next;
    done := FALSE;
    while (temp <> NIL) and not done do
      if temp^.name^.number < name^.number then
	begin
	  current_tm := temp;
	  temp := temp^.next;
	end
      else done := TRUE;

    { insert if not there }

    if current_tm = NIL then found := FALSE
    else if current_tm^.name^.number = name^.number then found := TRUE
    else found := FALSE;

    def := NIL;
    if not found then
      if ([UNRESERVED,RESERVED] * name^.identifier_p^.kind = []) then
        begin
          def := nullstring_tok;
	  if name^.identifier_p^.definition <> nullstring then
	    assert(237 { should be null !! });
	  end
      else
        def := enter_numbered_string(name^.identifier_p^.definition,
                                     schema.string_dictionary);

    if def <> NIL then
      begin
	{ if entry to table was non-kosher, def will be NIL, with
	  assertion violation already reported. }
	new_text_macro(schema.used_global_TMs);
	current_tm := schema.used_global_TMs;
	current_tm^.name := name;
	current_tm^.text :=  def;
	current_tm^.reserved := (RESERVED in name^.identifier_p^.kind);
      end;
  end { insert_TM } ;


begin { log_used_global_TMs_in_schema }
  if debug_24 then writeln(outfile, ' log_used_global_TMs_in_schema');
  nullstring_tok :=
    enter_numbered_string(nullstring, schema.string_dictionary);
  release_all_text_macros(schema.used_global_TMs);
  current_page := schema.paged_schemas;
  while current_page <> NIL do
    begin
      current_exp_id := current_page^.expandable_ids;
      current_tm := NIL;
      while current_exp_id <> NIL do
	begin
	  insert_TM(current_exp_id^.name);
	  current_exp_id := current_exp_id^.next;
	end;
      current_page := current_page^.next;
    end;
end { log_used_global_TMs_in_schema } ;

  
procedure enter_local_TM(var page: paged_schema;
                         name: name_ptr; val: xtring);
  { enter the local text macro def into the given page.  These are to
    be sorted by name token number.  There will be NO duplicates. }
  var
    tm: text_macro_ptr;      { list entry created from name and val }
    parent: text_macro_ptr;  { parent of tm in sorted list }
    done: boolean;           { TRUE when insertion point is found }
begin
  if debug_24 then 
    begin
      write(Outfile, ' defines local TM: ');
      writealpha(Outfile, name^.name);
      write(Outfile, '=');
      writestring(Outfile, val);
      writeln(Outfile);
    end;

  tm := NIL;
  new_text_macro(tm);
  tm^.name := 
    enter_numbered_id(name, schema_of_drawing_being_compiled.id_dictionary);
  tm^.text := 
    enter_numbered_string(val, 
                          schema_of_drawing_being_compiled.string_dictionary);

  if (tm^.text = NIL) or (tm^.name = NIL) then
    release_text_macro(tm) { assertion failure in enter_numbered... }
  else
    begin
      parent := page.local_text_macros;
      if parent <> NIL then
        if parent^.name^.number > tm^.name^.number then
	  parent := NIL
	else if parent^.name^.number = tm^.name^.number then
	  begin
	    assert(0);
	    writeln(CmpLog, ' Duplicate TM name in enter_local_TM !!');
	    parent := NIL;
	  end
	else
	  begin
	    done := FALSE;
	    while (parent^.next <> NIL) and not done do
	      begin
                if parent^.next^.name^.number < tm^.name^.number then
		  parent := parent^.next
	        else if parent^.next^.name^.number = tm^.name^.number then
	          begin
	            assert(0);
	            writeln(CmpLog,
		      ' Duplicate TM name in enter_local_TM !!');
		    done := TRUE;
	          end
	        else done := TRUE;
	      end;
	  end;

      if parent = NIL then
        begin
          tm^.next := page.local_text_macros;
          page.local_text_macros := tm;
	end
      else
        begin
          tm^.next := parent^.next;
          parent^.next := tm;
	end
    end;
end { enter_local_TM } ;


procedure enter_expandable_id(*id: name_ptr*);
  { enter the id into the expandable id list for the page being compiled.  
    (This list is headed by paged_schema_of_this_page.expandable_ids. 
     The ids are sorted by token number (within schema of this page
     dictionary) }
  label
    90; { return }
  var
    tok: numbered_token;        { for passing to insert_numbered_token }
    newtok: numbered_token_ptr; { table entry for this id }
    element: expandable_id_ptr; { new or found element for list }
    parent: expandable_id_ptr;  { parent of element }
    found: boolean;             { TRUE if element found in list }
begin
  if debug_24 then 
    begin
       write(outfile, ' enter_expandable_id ');
       if id = NIL then write(outfile, 'NIL')
       else print_alpha(outfile, id^.name);
       if PERMANENT in id^.kind then writeln(outfile, ' permanent');
       if page_being_compiled = 0 then
         writeln(outfile, '   not compiling a page -- ignored');
     end;
       
  if id = NIL then
    begin
      assert(ASSERT_NIL_NAME_TO_ENTER_EXPANDABLE);
      goto 90 { return } ;
    end;

  if page_being_compiled = 0 then goto 90 { return } ;
  { not compiling a page (just examining versions) -- ignore }

  if PERMANENT in id^.kind then goto 90 { return } ; { don't log these }

  { number the id }

  init_numbered_token(tok, IDENTIFIER_NUMBER);
  tok.identifier_p := id;
  newtok := 
    insert_numbered_token(tok, schema_of_drawing_being_compiled.id_dictionary);
  if newtok = NIL then
    begin
      assert(ASSERT_FAILED_ENTER_EXPANDABLE_ID);
      goto 90 { return } ;
    end;

  { find id or place to add it to the list }

  parent := NIL;
  element := paged_schema_of_this_page.expandable_ids;
  found := FALSE;
  while (element <> NIL) and not found do
    if element^.name = NIL then
      begin
	assert(205 { Nil token value });
        if parent = NIL then
	  begin
	    release_expandable_id(paged_schema_of_this_page.expandable_ids);
	    element := paged_schema_of_this_page.expandable_ids;
	  end
	else
	  begin
	    release_expandable_id(parent^.next);
	    element := parent^.next;
	  end;
      end
    else if element^.name^.number = newtok^.number then found := TRUE
    else if element^.name^.number > newtok^.number then element := NIL
    else
      begin
	parent := element;
	element := element^.next;
      end;


  if not found then
    begin
      if debug_24 then writeln(outfile, '   new entry');
      if parent = NIL then
	begin
	  new_expandable_id(paged_schema_of_this_page.expandable_ids);
	  element := paged_schema_of_this_page.expandable_ids;
	end
      else
	begin
	  new_expandable_id(parent^.next);
	  element := parent^.next;
	end;
      element^.name := newtok;
    end
  else if debug_24 then writeln(outfile, '   found it');
  
  { report the expandable id to data services }
  report_expandable_id_to_ds(id);
90:
end { enter_expandable_id } ;


procedure compute_current_local_TM_context(current_page: paged_schema_ptr;
                                           page_read: boolean);
  { Update schema.local_TMs to reflect the local text macros defined
    on all pages.  Assume that it is not currently valid.  current_page
    is the (old) schema representation of the current page .  If page_read, 
    then use the values just read for the page instead of those stored in
    the schema (in current_page).  This procedure has the side effect of
    checking the currently defined values for errors and dirtying the pages
    where such errors are found. NOTE: error messages are issued only
    for the current page and only if page_read. }
  var
    page: paged_schema_ptr; { current page of schema }
    found: boolean;         { TRUE when first page of this module is found }
    done: boolean;          { TRUE when one with all pages of module }
    prop: property_ptr;     { TM found in list }
    current_TM:
      text_macro_ptr;       { current TM from schema page }
begin
  if debug_23 or debug_24 then
    writeln(Outfile, ' compute_current_local_TM_context:');

  release_entire_property_list(schema_of_drawing_being_compiled.local_TMs);

  page := schema_of_drawing_being_compiled.paged_schemas;
  found := FALSE;
  while (page <> NIL) and not found do
    if (page^.drawing_type = current_page^.drawing_type) and
       (page^.version = current_page^.version) then found := TRUE
    else page := page^.next;

  done := FALSE;
  while (page <> NIL) and not done do
    begin
      if (page = current_page) and page_read then
        current_TM := paged_schema_of_this_page.local_text_macros
      else current_TM := page^.local_text_macros;

      while current_TM <> NIL do
        begin
          if find_property(
            schema_of_drawing_being_compiled.local_TMs,
            current_tm^.name^.identifier_p, prop) then
            begin
              if current_TM^.text^.string_p <> prop^.text then
                if (page = current_page) and page_read then
                  begin
                    error(114 { text macro already exists });
                    error_dump_body_name(DEFINE_string);
                    error_dump_text_macro(
                      current_tm^.name^.identifier_p);
                  end
                else mark_dirty_for_pass_2(page);
            end
          else
            if RESERVED IN current_TM^.name^.identifier_p^.kind then
              begin
                if (page = current_page) and page_read then
                  begin
                    error(105 { reserved TM name });
                    error_dump_body_name(DEFINE_string);
                    error_dump_text_macro(
                      current_TM^.name^.identifier_p);
                  end
                else mark_dirty_for_pass_2(page);
              end
            else
              add_to_prop_list(
                schema_of_drawing_being_compiled.local_TMs,
                current_TM^.name^.identifier_p,
                current_TM^.text^.string_p);

          current_TM := current_TM^.next;
        end;

      page := page^.next;
      if page <> NIL then
        if (page^.drawing_type <> current_page^.drawing_type) or
           (page^.version <> current_page^.version) then 
          done := TRUE;
    end;

  schema_of_drawing_being_compiled.local_TMs_defined := TRUE;

  if debug_23 or debug_24 then
    dump_property_list(Outfile, schema_of_drawing_being_compiled.local_TMs);
end { compute_current_local_TM_context } ;


procedure sort_expandable_ids(var head: expandable_id_ptr);
  { Sorts the expandable ids in ascending order of id number. 
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and not efficient), but are 
    quietly handled. }
  var
    next_element: expandable_id_ptr;  { next element to be checked }
    parent: expandable_id_ptr;        { parent of next_element }
    insert_point: expandable_id_ptr;  { new parent of next_element 
                                        (if it must be moved) }
begin
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      if next_element^.name^.number = parent^.name^.number then
        begin
          assert(ASSERT_DUPLICATE_EXPANDABLE_ID_NUMBERS);
          release_expandable_id(parent^.next);
        end
      else if next_element^.name^.number > parent^.name^.number then
          parent := next_element
      else { out of order - move it }
        begin
          parent^.next := next_element^.next;
          if next_element^.name^.number = head^.name^.number then
            begin
              assert(ASSERT_DUPLICATE_EXPANDABLE_ID_NUMBERS);
              next_element^.next := NIL;
              release_expandable_id(next_element);
            end
          else if next_element^.name^.number < head^.name^.number then
            begin
              next_element^.next := head;
              head := next_element;
            end
          else
            begin
              insert_point := head;
              while insert_point^.next^.name^.number < 
                next_element^.name^.number do
                insert_point := insert_point^.next;
              if insert_point^.next^.name^.number = 
                next_element^.name^.number then
                begin
                  assert(ASSERT_DUPLICATE_EXPANDABLE_ID_NUMBERS);
                  next_element^.next := NIL;
                  release_expandable_id(next_element);
                end
              else
                begin
                  next_element^.next := insert_point^.next;
                  insert_point^.next := next_element^.next;
                end;
            end;
        end { out of order } ;
      next_element := parent^.next;
    end { while } ;
end { sort_expandable_ids } ;


procedure sort_text_macros(var head: text_macro_ptr);
  { Sorts the text macros in ascending order of name token number (like
    expandable ids).
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and not efficient), but are 
    quietly handled. }
  var
    next_element: text_macro_ptr;  { next element to be checked }
    parent: text_macro_ptr;        { parent of next_element }
    insert_point: text_macro_ptr;  { new parent of next_element 
                                        (if it must be moved) }
begin
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      if next_element^.name^.number = parent^.name^.number then
        begin
          assert(0);
	  writeln(CmpLog, ' Duplicate TM logged!');
          release_text_macro(parent^.next);
        end
      else if next_element^.name^.number > parent^.name^.number then
          parent := next_element
      else { out of order - move it }
        begin
          parent^.next := next_element^.next;
          if next_element^.name^.number = head^.name^.number then
            begin
              assert(0);
	      writeln(CmpLog, ' Duplicate TM logged!');
              next_element^.next := NIL;
              release_text_macro(next_element);
            end
          else if next_element^.name^.number < head^.name^.number then
            begin
              next_element^.next := head;
              head := next_element;
            end
          else
            begin
              insert_point := head;
              while insert_point^.next^.name^.number < 
	            next_element^.name^.number do
                insert_point := insert_point^.next;
              if insert_point^.next^.name^.number = 
                 next_element^.name^.number then
                begin
                  assert(0);
	          writeln(CmpLog, ' Duplicate TM logged!');
                  next_element^.next := NIL;
                  release_text_macro(next_element);
                end
              else
                begin
                  next_element^.next := insert_point^.next;
                  insert_point^.next := next_element^.next;
                end;
            end;
        end { out of order } ;
      next_element := parent^.next;
    end { while } ;
end { sort_text_macros } ;


procedure log_property_use(*id: name_ptr*);
  { enter the id into the used property list for the page being compiled.  
    (This list is headed by paged_schema_of_this_page.properties). 
    The ids are sorted by token number (within schema of this page
    dictionary) }
  label
    90; { return }
  var
    tok: numbered_token;              { for passing to insert_numbered_token }
    newtok: numbered_token_ptr;       { table entry for this id }
    element: numbered_token_list_ptr; { new or found element for list }
    parent: numbered_token_list_ptr;  { parent of element }
    found: boolean;                   { TRUE if element found in list }
begin
  if debug_24 then 
    begin
       write(outfile, ' log_property_use ');
       if id = NIL then write(outfile, 'NIL')
       else print_alpha(outfile, id^.name);
       writeln(outfile);
       if page_being_compiled = 0 then
         writeln(outfile, '   not compiling a page -- ignored');
     end;
       
  if id = NIL then
    begin
      assert(0 { not expected });
      writeln(cmplog, ' NIL id passed to log_property_use');
      goto 90 { return } ;
    end;

  if page_being_compiled = 0 then
    { not compiling a page (just examining versions) -- ignore }
    begin
      assert(0 { This should no longer happen });
      Writeln(CmpLog, ' Examining versions in log_property_use');
      goto 90 { return } ;
    end; 

  { number the id }

  init_numbered_token(tok, IDENTIFIER_NUMBER);
  tok.identifier_p := id;
  newtok := 
    insert_numbered_token(tok, 
                          schema_of_drawing_being_compiled.id_dictionary);
  if newtok = NIL then
    begin
      assert(ASSERT_FAILED_ENTER_EXPANDABLE_ID);
      goto 90 { return } ;
    end;

  { find id or place to add it to the list }

  parent := NIL;
  element := paged_schema_of_this_page.properties;
  found := FALSE;
  while (element <> NIL) and not found do
    if element^.token = NIL then
      begin
        assert(205 { Nil token value });
        if parent = NIL then
          begin
            release_numbered_token_list(paged_schema_of_this_page.properties);
            element := paged_schema_of_this_page.properties;
          end
        else
          begin
            release_numbered_token_list(parent^.next);
            element := parent^.next;
          end;
      end
    else if element^.token^.number = newtok^.number then found := TRUE
    else if element^.token^.number > newtok^.number then element := NIL
    else
      begin
        parent := element;
        element := element^.next;
      end;

  if not found then
    begin { insert a new one }
      if parent = NIL then
        begin
          new_numbered_token_list(paged_schema_of_this_page.properties);
          element := paged_schema_of_this_page.properties;
        end
      else
        begin
          new_numbered_token_list(parent^.next);
          element := parent^.next;
        end;
      element^.token := newtok;
      if debug_24 then writeln(outfile, '   new entry');
    end;
90:
end { log_property_use } ;


procedure sort_propertm_attributes(var head: property_attribute_ptr);
  { Sorts the property names in ascending order of id number. 
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and not efficient), but are 
    quietly handled. }
  var
    next_element: property_attribute_ptr;  { next element to be checked }
    parent: property_attribute_ptr;        { parent of next_element }
    insert_point: property_attribute_ptr;  { new parent of next_element 
                                             (if it must be moved) }
    done: boolean;                         { TRUE when head is legal }
begin
  done := FALSE;
  while (head <> NIL) and not done do
    if head^.property = NIL then 
      begin
        assert(213 { Nil token referenced });
        release_property_attribute(head);
      end
    else done := TRUE;
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      if next_element^.property = NIL then
        begin
          assert(213 { Nil token referenced });
          release_property_attribute(parent^.next);
        end
      else if next_element^.property^.number = parent^.property^.number then
        begin
          assert(ASSERT_DUPLICATE_PROPERTY_NUMBERS);
          release_property_attribute(parent^.next);
        end
      else if next_element^.property^.number > parent^.property^.number then
          parent := next_element
      else { out of order - move it }
        begin
          parent^.next := next_element^.next;
          if next_element^.property^.number = head^.property^.number then
            begin
              assert(ASSERT_DUPLICATE_PROPERTY_NUMBERS);
              next_element^.next := NIL;
              release_property_attribute(next_element);
            end
          else if next_element^.property^.number < head^.property^.number then
            begin
              next_element^.next := head;
              head := next_element;
            end
          else
            begin
              insert_point := head;
              while insert_point^.next^.property^.number < 
                next_element^.property^.number do
                insert_point := insert_point^.next;
              if insert_point^.next^.property^.number = 
                next_element^.property^.number then
                begin
                  assert(ASSERT_DUPLICATE_PROPERTY_NUMBERS);
                  next_element^.next := NIL;
                  release_property_attribute(next_element);
                end
              else
                begin
                  next_element^.next := insert_point^.next;
                  insert_point^.next := next_element^.next;
                end;
            end;
        end { out of order } ;
      next_element := parent^.next;
    end { while } ;
end { sort_property_attributes } ;


function funky_compare_parameters(parm1: parameter_ptr;
                                  parm2: property_ptr): compare_type;
  { compares parameters according to the following.
      1. SIZE parameter is less than other parameter names.
      2. Lexicographic order of rest of parameter names. 
      3. Lexicographic order of value.  (redundant)
    Note the different types of the operands }
begin
  case compare_identifiers(parm1^.name^.identifier_p, parm2^.name) of
    LT: 
      if (parm2^.name = SIZE_prop_name) then 
        funky_compare_parameters := GT
      else funky_compare_parameters := LT;
    GT: 
      if (parm1^.name^.identifier_p = SIZE_prop_name) then 
        funky_compare_parameters := LT
      else funky_compare_parameters := GT;
    EQ: funky_compare_parameters := 
      compare_strings(parm1^.text^.string_p, parm2^.text);
  end;
end { funky_compare_parameters } ;


function compare_parameters(parm1, parm2: parameter_ptr): compare_type;
  { compares parameters according to the following.
      1. SIZE parameter is less than other parameter names.
      2. Lexicographic order of rest of parameter names. 
      3. Lexicographic order of value. (redundant) }
begin
  case compare_identifiers(parm1^.name^.identifier_p,
                           parm2^.name^.identifier_p ) of
    LT: 
      if (parm2^.name^.identifier_p = SIZE_prop_name) then 
        compare_parameters := GT
      else compare_parameters := LT;
    GT: 
      if (parm1^.name^.identifier_p = SIZE_prop_name) then 
        compare_parameters := LT
      else compare_parameters := GT;
    EQ: compare_parameters := 
      compare_strings(parm1^.text^.string_p, parm2^.text^.string_p);
  end;
end { compare_parameters } ;


procedure sort_parameters(var head: parameter_ptr);
  { Sorts the parameters in compare_parameter_names order 
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and n-squared), but are quietly handled. 
    Repeated parameters are deleted }
  var
    next_element: parameter_ptr;  { next element to be checked }
    parent: parameter_ptr;        { parent of next_element }
    insert_point: parameter_ptr;  { new parent of next_element }
    comparison: compare_type;     { relation of elements being checked }
begin
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      case compare_parameter_names(next_element^.name^.identifier_p,
                                   parent^.name^.identifier_p) of
        EQ: 
          begin
          { assert(ASSERT_DUPLICATE_PARAMETERS); }{ who cares - just delete it}
            release_parameter(parent^.next);
          end;
        GT: parent := next_element;
        LT: { out of order - move it }
          begin
            parent^.next := next_element^.next;
            case compare_parameter_names(next_element^.name^.identifier_p,
                                         head^.name^.identifier_p) of
              EQ:
                begin
                { assert(ASSERT_DUPLICATE_PARAMETERS); }
                  next_element^.next := NIL;
                  release_parameter(next_element);
                end;
              LT:
                begin
                  next_element^.next := head;
                  head := next_element;
                end;

              GT:
                begin
                  insert_point := head;
                  comparison := compare_parameter_names(
                    next_element^.name^.identifier_p,
                    insert_point^.next^.name^.identifier_p);
                  while comparison = GT do
                    begin
                      insert_point := insert_point^.next;
                      comparison := compare_parameter_names(
                        next_element^.name^.identifier_p,
                        insert_point^.next^.name^.identifier_p);
                    end;
                  if comparison = EQ then
                    begin
                    { assert(ASSERT_DUPLICATE_PARAMETERS); }
                      next_element^.next := NIL;
                      release_parameter(next_element);
                    end
                  else
                    begin 
                      next_element^.next := insert_point^.next;
                      insert_point^.next := next_element;
                    end;
                end { GT } ;
            end { case } ;
          end { LT -> out of order } ;
      end { case } ;
      next_element := parent^.next;
    end { while } ;
end { sort_parameters } ;


function compare_parameter_lists(context1, 
                                 context2: parameter_ptr): compare_type;
  { compares parameter lists }
  var
    parm1: parameter_ptr;   { current parameter in context1 }
    parm2: parameter_ptr;   { current parameter in context2 }
    done: boolean;          { TRUE when comparison has been made }
begin
  parm1 := context1;  parm2 := context2;
  done := FALSE;
  repeat
    if (parm1 = NIL) then
      if (parm2 = NIL) then 
        begin
          compare_parameter_lists := EQ;  done := TRUE;
        end
      else 
        begin
          compare_parameter_lists := LT;  done := TRUE;
        end
    else
      if (parm2 = NIL) then
        begin
          compare_parameter_lists := GT;  done := TRUE;
        end
      else case compare_parameters(parm1, parm2) of
        LT: 
          begin
            compare_parameter_lists := LT;  done := TRUE;
          end;
        GT: 
          begin
            compare_parameter_lists := GT;  done := TRUE;
          end;
        EQ:
          begin
            parm1 := parm1^.next;  parm2 := parm2^.next;
          end;
      end { case }
  until done;
end { compare_parameter_lists } ;


function funky_compare_parameter_lists(
  context1: parameter_ptr; context2: property_ptr): compare_type;
  { compares parameter lists where 1 is a parameter list and 2 is
    a property_list list }
  var
    parm1: parameter_ptr;   { current parameter in context1 }
    parm2: property_ptr;    { current parameter in context2 }
    done: boolean;          { TRUE when comparison has been made }
begin
  parm1 := context1;  parm2 := context2;
  done := FALSE;
  repeat
    if (parm1 = NIL) then
      if (parm2 = NIL) then 
        begin
          funky_compare_parameter_lists := EQ;  done := TRUE;
        end
      else 
        begin
          funky_compare_parameter_lists := LT;  done := TRUE;
        end
    else
      if (parm2 = NIL) then
        begin
          funky_compare_parameter_lists := GT;  done := TRUE;
        end
      else case funky_compare_parameters(parm1, parm2) of
        LT: 
          begin
            funky_compare_parameter_lists := LT;  done := TRUE;
          end;
        GT: 
          begin
            funky_compare_parameter_lists := GT;  done := TRUE;
          end;
        EQ:
          begin
            parm1 := parm1^.next;  parm2 := parm2^.next;
          end;
      end { case }
  until done;
end { funky_compare_parameter_lists } ;


procedure sort_contexts(var head: context_definition_ptr);
  { Sorts the contexts according to their parameter lists 
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and not efficient), but are 
    quietly handled. }
  var
    next_element: context_definition_ptr;  { next element to be checked }
    parent: context_definition_ptr;        { parent of next_element }
    insert_point: context_definition_ptr;  { new parent of next_element }
    done: boolean;                         { TRUE when insert point found }
begin
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      case compare_parameter_lists(next_element^.parameters, 
                                   parent^.parameters) of
        EQ: { redundant entry -- delete it }
          begin
            assert(236 { redundant context entries });
            release_context_definition(parent^.next);
          end;
        GT: parent := next_element;
        LT: { out of order - move it }
          begin
            parent^.next := next_element^.next;
            case compare_parameter_lists(next_element^.parameters, 
                                         head^.parameters) of
              EQ:
                begin
                  assert(236 { redundant context entries });
                  next_element^.next := NIL;
                  release_context_definition(next_element);
                end;
              LT:
                begin
                  next_element^.next := head;
                  head := next_element;
                end;
              GT:
                begin
                  insert_point := head;  done := FALSE;
                  repeat
                    case 
                      compare_parameter_lists(next_element^.parameters, 
                                              insert_point^.next^.parameters)
                                              of
                      EQ: { redundant }
                        begin
                          assert(236);
                          next_element^.next := NIL;
                          release_context_definition(next_element);
                        end;
                      LT: { insert here }
                        begin
                          next_element^.next := insert_point^.next;
                          insert_point^.next := next_element;
                          done := TRUE;
                        end;
                      GT: insert_point := insert_point^.next;
                    end { case } ;
                  until done;
                end { GT } ;
            end { case } ;
          end { LT -> out of order } ;
      end { case } ;
      next_element := parent^.next;
    end { while } ;
end { sort_contexts } ;


function find_context_definition_insertion_point(
  parms: property_ptr; contexts: context_definition_ptr;
  var parent: context_definition_ptr): context_definition_ptr;
  { Finds the context matching the parameter list.  Both must be
    sorted before calling this routine.  If not found, NIL is
    returned.  In either case, returns a ptr to the parent of the
    context (NIL if context is or would be first element of list. }
  var
    current_context: context_definition_ptr;   { current element of contexts }
    current_parm: property_ptr;                { current element of parms }
    result: context_definition_ptr;            { found context }
    done: boolean;                             { TRUE when we find context or
                                                 go too far }
begin
  result := NIL;  parent := NIL;
  current_context := contexts;  current_parm := parms;  done := FALSE;
  while (current_context <> NIL) and not done do
    case funky_compare_parameter_lists(current_context^.parameters, parms) of
      LT:
        begin
          parent := current_context;
          current_context := current_context^.next;
        end;
      GT: done := TRUE;
      EQ:
        begin
          done := TRUE;
          result := current_context;
        end;
    end;
  find_context_definition_insertion_point := result;
end { find_context_definition_insertion_point } ;
  

function find_context_definition(
  parms: property_ptr; 
  contexts: context_definition_ptr): context_definition_ptr;
  { Finds the context matching the parameter list.  Both must be
    sorted before calling this routine.  If not found, NIL is
    returned. }
  var
    dummy: context_definition_ptr;   { dummy parent }
begin
  find_context_definition := 
    find_context_definition_insertion_point(parms, contexts, dummy);
end { find_context_definition } ;


function enter_context_definition(
  parms: property_ptr; 
  var schema: schema_definition): context_definition_ptr;
  { Finds the context matching the parameter list.  Both must be
    sorted before calling this routine.  If not found, one is created. }
  label
    90; { return } 
  var
    cont: context_definition_ptr;    { the context found/created }
    parent: context_definition_ptr;  { parent of cont }
    dic_error: boolean;              { TRUE iff numbered dictionary error }


  function copy_parameters(source: property_ptr; 
                           var dic_error: boolean): parameter_ptr;
    { return a copy of the source list, entering things into the
      dictionaries of the current schema. dic_error indicates an
      error in entering something, in which case the parms are not
      copied }
    var
      head: parameter_ptr;           { head of returned list }
      tail: parameter_ptr;           { tail of returned list }
      current: property_ptr;         { current element of source list }
  begin
    head := NIL;  tail := NIL;  current := source;  dic_error := FALSE;
    while current <> NIL do
      begin
        if head = NIL then 
          begin
            new_parameter(head);  tail := head;
          end
        else
          begin
            new_parameter(tail^.next);  tail := tail^.next;
          end;
        tail^.name := enter_numbered_id(current^.name,
                                        schema.id_dictionary);
        if tail^.name = NIL then dic_error := TRUE;
        tail^.text := enter_numbered_string(current^.text,
                                            schema.string_dictionary);
        if tail^.text = NIL then dic_error := TRUE;
        current := current^.next;
      end { while } ;
    if dic_error then release_all_parameters(head);
    copy_parameters := head;
  end { copy_parameters } ;
  

begin { enter_context_definition }
  cont := find_context_definition_insertion_point(parms, 
                                                  schema.contexts, parent);
  if cont = NIL then
    begin
      new_context_definition(cont);
      if schema.highest_context_number = MAXINT then
        begin
          assert(240 { integer overflow });
          writeln(CmpLog, ' In enter_context_definition');
          cont^.number := 0;
        end
      else
        begin
          schema.highest_context_number := schema.highest_context_number + 1;
          cont^.number := schema.highest_context_number;
        end;
      cont^.parameters := copy_parameters(parms, dic_error);
      if dic_error or (cont^.number = 0) then
        begin
          { This should never actually happen - but if it does, kill
            this instance by returning NIL }
          release_context_definition(cont);
          enter_context_definition := NIL;
          goto 90 { return } ;
        end;
      if parent = NIL then
        begin
          cont^.next := schema.contexts;
          schema.contexts := cont;
        end
      else
        begin
          cont^.next := parent^.next;
          parent^.next := cont;
        end;
    end;
  enter_context_definition := cont;
90:
end { enter_context_definition } ;


function find_context_number(contexts: context_definition_ptr;
                             number: natural_number): context_definition_ptr;
  { find the context having number as its number }
  var
    current: context_definition_ptr; { current context }
    found: boolean;                  { TRUE when found }
begin
  current := contexts;  found := FALSE;
  while (current <> NIL) and not found do
    if current^.number = number then found := TRUE
    else current := current^.next;
  find_context_number := current;
end { find_context_number } ;


function compare_paged_schemas(var page1, 
                                   page2: paged_schema): compare_type;
  { compares paged schemas by type, version, page.  The pages are not
    altered (pass by reference is for efficiency). }
begin
  case compare_identifiers(page1.drawing_type^.identifier_p, 
                           page2.drawing_type^.identifier_p) of
    LT: compare_paged_schemas := LT;
    GT: compare_paged_schemas := LT;
    EQ:
      if page1.version < page2.version then compare_paged_schemas := LT
      else if page1.version > page2.version then compare_paged_schemas := GT
      else if page1.page < page2.page then compare_paged_schemas := LT
      else if page1.page > page2.page then compare_paged_schemas := GT
      else compare_paged_schemas := EQ;
  end;
end { compare_paged_schemas } ;


procedure sort_paged_schemas(var head: paged_schema_ptr);
  { Sorts the paged_schemas.
    The sort is order N for the following 2 cases.
      1. already in order.
      2. in opposite order.
    other cases are not expected (and not efficient), but are 
    quietly handled. }
  var
    next_element: paged_schema_ptr;  { next element to be checked }
    parent: paged_schema_ptr;        { parent of next_element }
    insert_point: paged_schema_ptr;  { new parent of next_element }
    comparison: compare_type;        { saves last compare }
begin
  parent := head;
  if parent = NIL then next_element := NIL
                  else next_element := parent^.next;
  while next_element <> NIL do
    begin
      case compare_paged_schemas(next_element^, 
                                 parent^) of
        EQ: parent := next_element; 
        GT: parent := next_element;
        LT: { out of order - move it }
          begin
            parent^.next := next_element^.next;
            case compare_paged_schemas(next_element^, parent^) of
              EQ:
                begin
                  next_element^.next := head;
                  head := next_element;
                end;
              LT:
                begin
                  next_element^.next := head;
                  head := next_element;
                end;
              GT:
                begin
                  insert_point := head;
                  comparison := 
                    compare_paged_schemas(next_element^, insert_point^.next^);
                  while comparison = GT do
                    begin
                      insert_point := insert_point^.next;
                      comparison := 
                        compare_paged_schemas(next_element^,
                                              insert_point^.next^);
                    end;
                  next_element^.next := insert_point^.next;
                  insert_point^.next := next_element^.next;
                end { GT } ;
            end { case } ;
          end { LT -> out of order } ;
      end { case } ;
      next_element := parent^.next;
    end { while } ;
end { sort_paged_schemas } ;


function insert_schema_page(var page_spec: paged_schema;  { not altered }
                            var element: paged_schema_ptr { altered }):
  paged_schema_ptr;
  { insert a page corresponding to page_spec ahead of
    element. Initialize the drawing_type, version and page of the
    new element.
    Return with element = the inserted element and also return the ptr }
begin
  new_paged_schema(element);
  with element^ do
    begin
      drawing_type := page_spec.drawing_type;
      version := page_spec.version;
      page := page_spec.page;
    end;
  insert_schema_page := element;
end { insert_schema_page } ;
    

function find_schema_page(var schema: schema_definition;
                          var page_spec: paged_schema { unchanged } ): 
			  paged_schema_ptr;
  { Findthe old schema page corresponding to page_spec and return a
    pointer to it (or NIL, if unfound). }
  var
    current: paged_schema_ptr; { current element }
    done: boolean;             { TRUE iff search has ended }
begin
  current := schema.paged_schemas;  done := FALSE;
  while (current <> NIL) and not done do
    if compare_paged_schemas(current^, page_spec) = LT then 
      current := current^.next
    else done := TRUE;
  find_schema_page := current;
end { find_schema_page } ;


function enter_schema_page(var schema: schema_definition;
                           var page_spec: paged_schema; { unchanged }
                           var parent: paged_schema_ptr;
			   var is_new: boolean): paged_schema_ptr;
  { Find/create the old schema page corresponding to page_spec and return a
    pointer to it. Also return a pointer to its parent (NIL if root).
    Schema_spec is unchanged, but passed by reference for efficiency. 
    Return is_new TRUE iff a new page has been added. }
  var
    current: paged_schema_ptr; { current/found element }
    comparison: compare_type;  { remembers last comparison }
begin
  parent := NIL;  current := schema.paged_schemas;
  is_new := TRUE;
  comparison := LT;
  while (current <> NIL) and (comparison = LT) do
    begin
      comparison := 
        compare_paged_schemas(current^, page_spec);
      if comparison = LT then
        begin
          parent := current;
          current := current^.next;
        end;
    end;
  if comparison = EQ then
    begin
      if debug_24 then writeln(outfile, '   found page');
      enter_schema_page := current;
      is_new := FALSE;
    end
  else
    if parent = NIL then
      begin
        if debug_24 then writeln(outfile, '   adding page');
        enter_schema_page := 
          insert_schema_page(page_spec, schema.paged_schemas);
      end
    else
      begin
        if debug_24 then writeln(outfile, '   adding page');
        enter_schema_page := insert_schema_page(page_spec, parent^.next);
      end;
end { enter_schema_page } ;


(**){--------------- SCHEMA FILE I/O ------------------------------}


procedure parse_schema_file(var schema: schema_definition);
  { Parses the schema file into schema (which is presumed to have
    already been initialized).  The schema file is assumed to have
    been freshly opened as the current parse file }
  label
    90;  { return }

  var
    id_prefix_sy: symbols;     { initialized = SHARP and then used as const }
    string_prefix_sy: symbols; { initialized = DOLLAR and then used as const }
    end_symbols: setofsymbols;         { symbols marking the end of a section }
    final_end_symbols: setofsymbols;   { symbols marking end of data }
    file_type_found: file_types;       { type of file we have }

    end_page_symbols: setofsymbols;    { symbols indicating end of a page }
    legal_at_id_list: setofsymbols;    { symbols legal when we could be
                                         starting a schema id list element   }
    legal_at_local_TM: setofsymbols;   { symbols legal when we could be
                                         starting a local text macro element }
    end_of_TM_element: setofsymbols;   { symbols legal at the end of a
                                         local text macro entry (or the
                                         start of the next one) }
    legal_at_dependencies:
      setofsymbols;                    { symbols legal when we could have
                                         a dependency list }
    end_of_dependency_element:
      setofsymbols;                    { symbols legal after an element of a
                                         dependency list }
    legal_at_result_list:
      setofsymbols;                    { symbols legal when we could be
                                         looking at a result file list }
    legal_at_page_properties:
      setofsymbols;                    { symbols legal when we could be 
                                         looking at a page's property list }
    legal_at_time: setofsymbols;       { symbols legal when we could be
                                         looking at a :<time> }
    context_table: avl_ptr;            { table of contexts sorted by number }


  function parse_schema_version: boolean;
    { parse the version number and return TRUE if it exists and matches the
      current number.   This number is incremented whenever a change is
      made to the syntax or semantics of the schema file or the expansion
      file. }
    var
      val: boolean;         { return value }
  begin
    if sy = CONSTANT then
      begin
        val := (const_val = SCHEMA_SYNTAX_VERSION);
        insymbol;
      end
    else val := FALSE;
    parse_schema_version := val;
    if (debug_23 or debug_24) and not val then 
      writeln(Outfile, 'Schema syntax number outdated');
  end { parse_schema_version } ;
  

  procedure parse_directives(var schema: schema_definition);
    { parse the directive number and separate it into its bit fields }
  begin
    if sy <> CONSTANT then assert(ASSERT_EXPECTED_CONSTANT)
    else
      begin
        schema.bubble_check := bit_and(const_val, BUBBLE_CHECK_MASK) <> 0;
        schema.enable_cardinal_tap :=
	  bit_and(const_val, CARDINAL_TAP_MASK) <> 0;
        insymbol;
      end;
  end { parse_directives } ;
  

  function parse_paged_schemas: paged_schema_ptr;
    { parses the paged schema section of a schema file and returns a
      sorted list }
    label
      10; { cycle }
    var
      ps: paged_schema_ptr;              { head of list of paged schemas }


    function parse_time(var stamp: time_stamp): boolean;
      { parses a time stamp - return TRUE iff found, FALSE and 0 if not }
      var
        sign: -1..1;      { "sign" of partial time-stamp in schema file }
    begin
      if sy = MINUS then
        begin
          sign := -1;
          insymbol;
        end
      else sign := 1;

      if (sy <> CONSTANT) then 
        begin
	  assert(ASSERT_EXPECTED_CONSTANT);
	  parse_time := FALSE;
	end
      else
        begin
	  parse_time := TRUE;
          stamp := const_val * sign;
          insymbol; { eat the high byte }
	end;
    end { parse_time } ;


    function parse_schema_id_list(var head: expandable_id_ptr): boolean;
      { parses and sorts the expandable id list of a schema file.
        Sort is as done by sort_expandable_ids.  Return FALSE if
        error is discovered. }
      label
        90; { return }
      var
        exp_id: expandable_id_ptr;           { current expandable id }
        nid: numbered_token_ptr;             { just parsed numbered id }
    begin
      parse_schema_id_list := TRUE;
      head := NIL;

      if not (sy in legal_at_id_list) then
        begin
          assert(ASSERT_EXPECTED_ID_LIST);
          parse_schema_id_list := FALSE;
          goto 90 { return } ;
        end;

      if sy <> MINUS then goto 90 { return } ;

      insymbol; { eat the - }
      while not (sy in legal_at_local_TM) do
        begin
          if sy <> id_prefix_sy then
            begin
              assert(ASSERT_EXPECTED_ID_NUMBER);
              skip(legal_at_local_TM);
	      parse_schema_id_list := FALSE;
            end
          else
            begin
              nid := parse_numbered_token(schema.id_dictionary);
              if nid = NIL then 
                begin
                  parse_schema_id_list := FALSE;
                  skip(legal_at_local_TM);
                end
              else 
                begin
                  new_expandable_id(exp_id);
                  exp_id^.name := nid;
                  exp_id^.next := head;
                  head := exp_id;
                end;
            end;
        end { while } ;
      sort_expandable_ids(head);
    90: { return }
    end { parse_schema_id_list } ;


    function parse_local_TMs(var head: text_macro_ptr): boolean;
      { parses the local text macros section of a paged schema.
        Return FALSE if error is detected. }
      label
        90; { return }
      var
        nid: numbered_token_ptr;            { just parsed id number }
        str: numbered_token_ptr;            { just parsed string number }
    begin
      parse_local_TMs := TRUE;  head := NIL;

      if not (sy in legal_at_local_TM) then
        begin
          assert(ASSERT_EXPECTED_LOCAL_TM);
          parse_local_TMs := FALSE;
          goto 90 { return } ;
        end;

      if sy <> AMPERSAND then goto 90 { return } ;

      insymbol; { eat the & }
      while sy = id_prefix_sy do
        begin 
          nid := parse_numbered_token(schema.id_dictionary);
          if nid = NIL then skip(end_of_TM_element)
          else if sy <> string_prefix_sy then
            begin
              assert(ASSERT_EXPECTED_NUMBERED_STRING);
              skip(end_of_TM_element);  parse_local_TMs := FALSE;
            end
          else
            begin { nid ok }
              str := parse_numbered_token(schema.string_dictionary);
              if str = NIL then 
                begin
                  skip(end_of_TM_element);  parse_local_TMs := FALSE;
                end
              else
                begin
                  new_text_macro(head);
                  with head^ do 
                    begin
                      name := nid;
                      text := str;
                      reserved := FALSE;
                    end;
                end;
            end { nid ok } ;
        end { while } ;
	
      sort_text_macros(head);

    90: { return }
    end { parse_local_TMs } ;


    function parse_dependencies(var head: dependency_list_ptr): boolean;
      { parses the file dependencies section of a schema file.  Return
        FALSE if error discovered. }
      label
        90; { return }
      var
        str: numbered_token_ptr;           { just parsed string number }
    begin
      parse_dependencies := FALSE;  head := NIL;

      if not (sy in legal_at_dependencies) then
        begin
          assert(ASSERT_EXPECTED_DEPENDENCIES);
          goto 90 { return } ;
        end;

      if sy = LPAREN then
        begin
          insymbol; { eat the ( }
          while sy = string_prefix_sy do
            begin
              str := parse_numbered_token(schema.string_dictionary);
              if str = NIL then goto 90 { return };
	      new_dependency_list(head);
              head^.file_name := str;
	      if not parse_time(head^.last_modified_time) then
	        goto 90 { return };
            end;
	end;
      parse_dependencies := TRUE;
    90:
    end { parse_dependencies } ;


    function parse_properties(var head: numbered_token_list_ptr): boolean;
      { parses the properties used section of a page.  Return
        FALSE if error discovered. }
      label
        90; { return }
      var
        id_token: numbered_token_ptr;    { parsed property name }
    begin
      parse_properties := TRUE;  head := NIL;
      if not (sy in legal_at_page_properties) then
        begin
          assert(158 { expected ) });
          skip(end_page_symbols);
          goto 90 { return } ;
       end;

      if sy <> PLUS then goto 90 { return } ;

      insymbol; { eat the + }
      while sy = id_prefix_sy do
        begin
          id_token := parse_numbered_token(schema.id_dictionary);
          if id_token = NIL then
            begin
              skip(end_page_symbols + [id_prefix_sy]);
              parse_properties := FALSE;
            end
          else
            begin
              new_numbered_token_list(head);
              head^.token := id_token;
            end;
        end;
    90:
    end { parse_properties } ;


    function parse_compiled_contexts(var head: compiled_context_list_ptr):
      boolean;
      { parse the compiled context list specification.  Use context_table
        (declared in parse_schema_file) to locate the context_definition
        associated with each context number.  Return FALSE if error
        has occurred. The list is not sorted. }
      label 
        90; { return }
      var
        dummy_context: context_definition_ptr; { for supplying key to
                                                 avl_find }
        object: avl_object_ptr;                { type required for avl_find }
        found: avl_ptr;                        { context found in table }
    begin
      head := NIL;
      parse_compiled_contexts := FALSE;
      if not (sy in legal_at_result_list) then
        begin
          assert(158 { expected ) });
          goto 90 { return } ;
        end;

      new_context_definition(dummy_context);
      object.context_number := dummy_context;
{     object.tag := AVL_CONTEXT_NUMBER;                       }(*AVL*)
      while sy = RPAREN do
        begin
          insymbol; { eat the ) }
          if sy <> CONSTANT then
            begin
              assert(ASSERT_EXPECTED_CONSTANT);
              release_context_definition(dummy_context);
              goto 90 { return } ;
            end;

          dummy_context^.number := const_val;
          found := avl_find(object, context_table, AVL_CONTEXT_NUMBER);
          if found = NIL then
            begin
              assert(0 { should never happen });
              writeln(cmplog, ' Unable to find context number in table!!');
              release_context_definition(dummy_context);
              goto 90 { return } ;
            end;

          insymbol; { eat context_number }

          new_compiled_context_list(head);
          head^.context := found^.object.context_number;
          if sy = IDENT then
	    if id.name = D_identifier then
	      begin
	        head^.dirty := TRUE;
		insymbol;
	      end;
        end;
      parse_compiled_contexts := TRUE;
      release_context_definition(dummy_context);
    90: { for returns }
    end { parse_compiled_contexts } ;


  begin { parse_paged_schemas }
    ps := NIL;
    parse_paged_schemas := NIL;

    while not (sy in end_symbols) do
      begin
        if sy = EQUAL then insymbol
        else
          begin
            assert(178 { expected = });
            skip(end_page_symbols);
            goto 10 { cycle } ;
          end;
        if sy <> id_prefix_sy then
          begin
            assert(ASSERT_EXPECTED_NUMBERED_ID);
            skip(end_page_symbols);
            goto 10 { cycle } ;
          end;
        new_paged_schema(ps);
        with ps^ do 
          begin
            drawing_type := parse_numbered_token(schema.id_dictionary);
            if drawing_type = NIL then
              begin
                release_paged_schema(ps);
                skip(end_page_symbols);
                goto 10 { cycle } ;
              end;
            if sy <> PERIOD then
              begin
                assert(ASSERT_EXPECTED_PERIOD);
                release_paged_schema(ps);
                skip(end_page_symbols);
                goto 10 { cycle } ;
              end;
            insymbol; { eat the . }
            if sy <> CONSTANT then
              begin
                assert(ASSERT_EXPECTED_CONSTANT);
                release_paged_schema(ps);
                skip(end_page_symbols);
                goto 10 { cycle } ;
              end;
            version := const_val;  insymbol; { eat the version number }
            if sy <> PERIOD then
              begin
                assert(ASSERT_EXPECTED_PERIOD);
                release_paged_schema(ps);
                skip(end_page_symbols);
                goto 10 { cycle } ;
              end;
            insymbol; { eat the . }
            if sy <> CONSTANT then
              begin
                assert(ASSERT_EXPECTED_CONSTANT);
                release_paged_schema(ps);
                skip(end_page_symbols);
                goto 10 { cycle } ;
              end;
            page := const_val;  insymbol; { eat the page number }

            if not parse_time(last_modified_time) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;

	    if sy = IDENT then
	      begin
		if id.name <> E_identifier then
		  begin
		    assert(190 { misc. parse error });
		    writeln(CmpLog, ' Expected E');
		    skip(end_page_symbols);
		    release_paged_schema(ps);
		    goto 10 { cycle } ;
		  end;
		{ has_expr := TRUE; } { obsolete }
		insymbol;  { eat the E }
	      end
	    { else has_expr := FALSE } { obsolete } ;

            if not parse_compiled_contexts(compiled_contexts) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;

            if not parse_schema_id_list(expandable_ids) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;

            if not parse_local_TMs(local_text_macros) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;

            if not parse_dependencies(dependencies) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;

            if not parse_properties(properties) then
              begin
                skip(end_page_symbols);
                release_paged_schema(ps);
                goto 10 { cycle } ;
              end;
          end { with ps^ } ;
      10:
      end { while } ;
    if sy = SEMI then insymbol
    else
      begin
        assert(116 { unexpected end of data });
      end;
    sort_paged_schemas(ps);
    parse_paged_schemas := ps;
  end { parse_paged_schemas } ;


  function parse_used_global_TMs: text_macro_ptr;
    { parses the used global text macros section of a schema file
      (these are not sorted and do not need to be). }
    var
      head: text_macro_ptr;              { head of list for return }
      end_of_TM_element: setofsymbols; { symbols indicating 
                                           start of next item }
      nid: numbered_token_ptr;           { just parsed id number }
      str: numbered_token_ptr;           { just parsed string number }


    function parse_reserved: boolean;
      { parses the reserved spec within a used_global_tm spec and
        returns value for the "reserved" field of that record. }
    begin
      parse_reserved := FALSE;
      if not (sy in ([COLON,id_prefix_sy] + end_symbols)) then
        begin
          assert(ASSERT_EXPECTED_RESERVED);
          skip(end_of_TM_element);
        end
      else
        begin
          if sy = COLON then
            begin
              insymbol; { eat the : }
              if sy <> IDENT then 
                begin
                  assert(ASSERT_EXPECTED_R);
                  skip(end_of_TM_element);
                end
              else if id.name <> R_identifier then
                begin
                  assert(ASSERT_EXPECTED_R);
                  skip(end_of_TM_element);
                end
              else
                begin
                  insymbol; { eat the R }
                  parse_reserved := TRUE;
                end;
            end;
        end;
    end { parse_reserved } ;


  begin { parse_used_global_TMs }
    head := NIL;
    end_of_TM_element := end_symbols + [id_prefix_sy];

    while not (sy in end_symbols) do
      if sy <> id_prefix_sy then
        begin
          assert(ASSERT_EXPECTED_NUMBERED_ID);
          skip(end_of_TM_element);
        end
      else
        begin { parse a TM spec }
          nid := parse_numbered_token(schema.id_dictionary);
          if nid = NIL then skip(end_of_TM_element)
          else if sy <> string_prefix_sy then
            begin
              assert(ASSERT_EXPECTED_NUMBERED_STRING);
              skip(end_of_TM_element);
            end
          else
            begin { nid ok }
              str := parse_numbered_token(schema.string_dictionary);
              if str = NIL then skip(end_of_TM_element)
              else
                begin
                  new_text_macro(head);
                  with head^ do 
                    begin
                      name := nid;
                      text := str;
                      reserved := parse_reserved;
                    end;
                end;
            end { nid ok } ;
        end { parse a TM spec } ;
    if sy = SEMI then insymbol
    else
      begin
        assert(116 { unexpected end of data });
      end;

    parse_used_global_TMs := head;
  end { parse_used_global_TMs } ;


  function parse_used_properties: property_attribute_ptr;
    { parses the used properties section of a schema file }
    label
      10;  { cycle }
    var
      head: property_attribute_ptr;      { head of list for return }
      nid: numbered_token_ptr;           { just parsed id number }


    procedure unpack_attributes(int: integer; var attributes: name_type_set);
      { unpack the integer attribute representation into the set }
    begin
      attributes := [];
      if bit_and(int, ET_PERMIT_BODY) <> 0 then 
        attributes := attributes + [PERMIT_BODY];
      if bit_and(int, ET_PERMIT_PIN) <> 0 then 
        attributes := attributes + [PERMIT_PIN];
      if bit_and(int, ET_PERMIT_SIGNAL) <> 0 then 
        attributes := attributes + [PERMIT_SIGNAL];
      if bit_and(int, ET_INHERIT_BODY) <> 0 then 
        attributes := attributes + [INHERIT_BODY];
      if bit_and(int, ET_INHERIT_PIN) <> 0 then 
        attributes := attributes + [INHERIT_PIN];
      if bit_and(int, ET_INHERIT_SIGNAL) <> 0 then 
        attributes := attributes + [INHERIT_SIGNAL];
      if bit_and(int, ET_FILTER) <> 0 then 
        attributes := attributes + [DONT_OUTPUT];
      if bit_and(int, ET_CONTROL) <> 0 then 
        attributes := attributes + [IS_ET_CONTROL];
      if bit_and(int, ET_PARAMETER) <> 0 then 
        attributes := attributes + [IS_PARAMETER];
      if bit_and(int, ET_INT_PARAMETER) <> 0 then 
        attributes := attributes + [IS_INT_PARAMETER];
    end { unpack_attributes } ;


  begin { parse_used_properties }
    head := NIL;

    while not (sy in end_symbols) do
      begin
        if sy <> id_prefix_sy then
          begin
            assert(ASSERT_EXPECTED_NUMBERED_ID);
            skip(end_symbols + [id_prefix_sy]);
            goto 10 { cycle } ;
          end;

        nid := parse_numbered_token(schema.id_dictionary);
        if nid = NIL then
          begin
            skip(end_symbols + [id_prefix_sy]);
            goto 10 { cycle } ;
          end;

        if sy <> EQUAL then
          begin
            assert(178 { expected = });
            skip(end_symbols + [id_prefix_sy]);
            goto 10 { cycle } ;
          end;
        insymbol; { eat = }

        if sy <> CONSTANT then
          begin
            assert(ASSERT_EXPECTED_CONSTANT);
            skip(end_symbols + [id_prefix_sy]);
            goto 10 { cycle } ;
          end;
        
        new_property_attribute(head);
        head^.property := nid;
        unpack_attributes(const_val, head^.attributes);
      10: { for cycle }
      end;
    if sy = SEMI then insymbol
    else
      begin
        assert(116 { unexpected end of data });
      end;
    parse_used_properties := head;
  end { parse_used_property_attributes } ;


  function parse_contexts: context_definition_ptr;
    { parses CONTEXTS section of schema file  The contexts are then
      sorted. }
    var
      head: context_definition_ptr;          { head of list for return }
      end_of_context_symbols: setofsymbols;  { symbols to find for recovery }
      legal_at_parameters: setofsymbols;     { symbols legal when expecting
                                               parameter specs or the 
                                               following item. }
      context_number: natural_number;        { the context number }


    function parse_parameters: parameter_ptr;
      { parses  and sorts the parameter list associtated with a context }
      var
        head: parameter_ptr;        { head of list for return }
        nid: numbered_token_ptr;    { just parsed id number }
    begin
      head := NIL;
      if (sy = CONSTANT) then
        begin
          new_parameter(head);
          head^.name := enter_numbered_id(SIZE_prop_name, 
                                          schema.id_dictionary);
          head^.text := enter_numbered_string(number_to_string(const_val),
                                              schema.string_dictionary);
          if (head^.name = NIL) or (head^.text = NIL) then
            release_parameter(head);
          insymbol;
        end;
      while not (sy in end_of_context_symbols) do
        begin
          if not (sy = id_prefix_sy) then
            begin
              assert(126 { expected parameters or next thing });
              skip(legal_at_parameters);
            end
          else
            begin
              nid := parse_numbered_token(schema.id_dictionary);
              if nid = NIL then skip(legal_at_parameters)
              else if sy = string_prefix_sy then
                begin
                  new_parameter(head);
                  head^.name := nid;
                  head^.text := 
                    parse_numbered_token(schema.string_dictionary);
                  if head^.text = NIL then 
                    begin
                      release_parameter(head);
                    end;
                end
              else
                begin
                  assert(123 { expected a numbered string });
                  skip(legal_at_parameters);
                end;
            end { ok to start } ;
        end { while } ;
      sort_parameters(head);
      parse_parameters := head;
    end { parse_parameters } ;


  begin { parse_contexts }
    head := NIL;
    end_of_context_symbols := end_symbols + [PERCENT];
    legal_at_parameters := end_of_context_symbols + [id_prefix_sy];

    while not (sy in end_symbols) do
      if sy <> PERCENT then
        begin
          assert(ASSERT_EXPECTED_PERCENT);
          skip(end_of_context_symbols);
        end
      else
        begin
          insymbol; { eat the % }
          if sy <> CONSTANT then
            begin
              assert(ASSERT_EXPECTED_CONSTANT);
              skip(end_of_context_symbols);
            end
          else
            begin { context number there }
              context_number := const_val;
              insymbol;
                 
              if sy <> CONSTANT then
                begin
                  assert(ASSERT_EXPECTED_CONSTANT);
                  skip(end_of_context_symbols);
                end
              else
                begin
                  new_context_definition(head);
                  head^.number := context_number;
                  head^.version := const_val;
                  insymbol; { eat version number }
                  head^.parameters := parse_parameters;
                end;
            end { context name there }
        end;

    if sy = SEMI then insymbol
    else
      begin
        assert(116 { unexpected end of data });
      end;

    sort_contexts(head);    { sorts list by parameters and deletes illegal
                              entries if found }
    parse_contexts := head;
  end { parse_contexts } ;


  function sort_contexts_by_number(head: context_definition_ptr): avl_ptr;
    { return the root of an avl tree that orders the contexts by number }
    var
      tree: avl_ptr;            { root of tree for return }
      current: avl_object_ptr;  { current context }
      dummy: avl_ptr;           { current table entry }
  begin
    tree := NIL;
    current.context_number := head;
    while current.context_number <> NIL do
      begin
        dummy := avl_insert(current, tree, AVL_CONTEXT_NUMBER);
        current.context_number := current.context_number^.next;
      end;
    sort_contexts_by_number := tree;
  end { sort_contexts_by_number } ;


begin { parse_schema_file }

  { tolerate an empty file }
  
  if sy <> ENDOFDATASY then
    begin

      { parse the schema file }

      file_type_found := get_file_type;
      if file_type_found <> SCHEMA_FILE then
        begin
          { !!! horrible fatal error condition }
          error(FATAL_SCHEMA_FILE_WRONG_TYPE);
          goto 90 { return }
        end;

      if parse_schema_version then
        begin
          { initialize local vars }

          context_table := NIL;
          id_prefix_sy := SHARP;
          string_prefix_sy := DOLLAR;
          final_end_symbols := [ENDSY,ENDOFDATASY];
          end_symbols := [SEMI,ENDSY,ENDOFDATASY];
          end_page_symbols := end_symbols + [EQUAL];
          legal_at_page_properties := end_page_symbols + [PLUS];
          legal_at_dependencies := legal_at_page_properties + [LPAREN];
          end_of_dependency_element := end_page_symbols + [string_prefix_sy];
          legal_at_local_TM := legal_at_dependencies + [AMPERSAND];
          end_of_TM_element := legal_at_dependencies + [id_prefix_sy]; 
          legal_at_id_list := legal_at_local_TM + [MINUS];
          legal_at_result_list := legal_at_id_list + [RPAREN];
          legal_at_time := legal_at_result_list + [COLON,IDENT];
          
          parse_directives(schema);

          parse_numbered_dictionary(schema.string_dictionary);
          if not (sy in final_end_symbols) then
            parse_numbered_dictionary(schema.id_dictionary);

          if not (sy in final_end_symbols) then
            schema.contexts := parse_contexts;
          context_table := sort_contexts_by_number(schema.contexts);
          if not (sy in final_end_symbols) then
            schema.paged_schemas := parse_paged_schemas;
          if not (sy in final_end_symbols) then
            schema.used_global_TMs := parse_used_global_TMs;
          if not (sy in final_end_symbols) then
            schema.used_properties := parse_used_properties;

          release_entire_avl_tree(context_table);
        end;
    end;
90:
end { parse_schema_file } ;


(**)


procedure output_parameters(var f: pipe;
                            parms: parameter_ptr);
  { outputs the parameter body properties for schema and expansion files }
  const
    PARMS_PER_LINE = 5;
  var
    current: parameter_ptr;     { current element }
    count: 0..PARMS_PER_LINE;   { number of parms since CRLF }
begin
  current := parms;  count := 0;
  if current <> NIL then
    if (current^.name^.identifier_p = SIZE_prop_name) then
      begin
        pipe_dump_char(f, ' ');
        pipe_dump_integer(f, 
          string_to_natural_number(current^.text^.string_p));
        current := current^.next;  count := 1;
      end;
  while current <> NIL do with current^ do
    begin
      if count = PARMS_PER_LINE then
        begin
          pipe_dump_CRLF(f);
          count := 1;
        end
      else count := count + 1;
      output_numbered_token(f, name^, IDENTIFIER_NUMBER);
      output_numbered_token(f, text^, STRING_NUMBER);
      current := next;
    end;
  if parms <> NIL then pipe_dump_CRLF(f);
end { output_parameters } ;


procedure output_schema_file(var f: pipe; var schema: schema_definition);
  { output a schema file.  File f must be open. Schema is output for
    final output (which causes output_numbers to be set for numbered
    tokens, effectively renumbering them).  The _continue output routines
    are used to stay within the proper line width. }


  procedure output_current_schema_directives(var f: pipe);
    { output current pertinent directives to the schema file }
    var
      directive_code: natural_number;
  begin
    directive_code := 0;
    if bubble_check then
      directive_code := directive_code + BUBBLE_CHECK_MASK;
    if enable_cardinal_tap then 
      directive_code := directive_code + CARDINAL_TAP_MASK;
    pipe_dump_integer(f, directive_code);
  end { output_current_schema_directives } ;


  procedure output_paged_schemas(var f: pipe; ps: paged_schema_ptr);
    { output the paged schema list to a schema file }
    var
      current: paged_schema_ptr;  { current element }


    procedure output_compiled_contexts(var f: pipe;
                                       contexts: compiled_context_list_ptr);
      { outputs the local text macros defined in this page }
      const
        CONTEXTS_PER_LINE = 15;
      var
        current: compiled_context_list_ptr;  { current element }
        count: 0..CONTEXTS_PER_LINE;         { number of contexts since CRLF }
    begin
      if contexts <> NIL then 
        begin
          current := contexts;  count := 0;
          while current <> NIL do with current^ do
            begin
              if count = CONTEXTS_PER_LINE then
                begin
                  pipe_dump_CRLF(f);
                  count := 1;
                end
              else count := count + 1;
              pipe_dump_char(f, ')');
              pipe_dump_integer(f, context^.number);
	      if (dirty or dirty_for_pass_2) then pipe_dump_char(f, 'D');
              current := next;
	    end;
          pipe_dump_CRLF(f);
        end;
    end { output_compiled_contexts } ;


    procedure output_expandable_ids(var f: pipe; exids: expandable_id_ptr);
      { outputs the expandable ids  }
      const
        EXP_IDS_PER_LINE = 10;
      var
        current: expandable_id_ptr;  { current element }
        count: 0..EXP_IDS_PER_LINE;  { number of expanded ids since CRLF }
    begin
      if exids <> NIL then
        begin
          pipe_dump_char(f, '-');
          current := exids;  count := 0;
          while current <> NIL do with current^ do
            begin
              if count = EXP_IDS_PER_LINE then
                begin
                  pipe_dump_CRLF(f);
                  count := 1;
                end
              else count := count + 1;
              output_numbered_token(f, name^, IDENTIFIER_NUMBER);
              current := next;
            end;
          pipe_dump_CRLF(f);
        end;
    end { output_expandable_ids } ;


    procedure output_local_text_macros(var f: pipe;
                                       tms: text_macro_ptr);
      { outputs the local text macros defined in this page }
      const
        LOCAL_TMS_PER_LINE = 5;
      var
        current: text_macro_ptr;        { current element }
        count: 0..LOCAL_TMS_PER_LINE;   { number of TMs since CRLF }
    begin
      if tms <> NIL then 
        begin
          pipe_dump_char(f, '&');
          current := tms;  count := 0;
          while current <> NIL do with current^ do
            begin
              if count = LOCAL_TMS_PER_LINE then
                begin
                  pipe_dump_CRLF(f);
                  count := 1;
                end
              else count := count + 1;
              output_numbered_token(f, name^, IDENTIFIER_NUMBER);
              output_numbered_token(f, text^, STRING_NUMBER);
            { if reserve then pipe_dump_alpha(f, ':R              '); }
              current := next;
            end;
          pipe_dump_CRLF(f);
        end;
    end { output_local_text_macros } ;


    procedure output_dependencies(var f: pipe;
                                  deps: dependency_list_ptr);
      { outputs the local text macros defined in this page }
      const
        DEPENDENCIES_PER_LINE = 12;
      var
        current: dependency_list_ptr;      { current element }
        count: 0..DEPENDENCIES_PER_LINE;   { number printed since CRLF }
    begin
      if deps <> NIL then 
        begin
          pipe_dump_char(f, '(');
          current := deps;  count := 0;
          while current <> NIL do with current^ do
            begin
              if count = DEPENDENCIES_PER_LINE then
                begin
                  pipe_dump_CRLF(f);
                  count := 1;
                end
              else count := count + 1;
              output_numbered_token(f, file_name^, STRING_NUMBER);
              pipe_dump_char(f, ' ');
	      pipe_dump_integer(f, last_modified_time);
              current := next;
            end;
          pipe_dump_CRLF(f);
        end;
    end { output_dependencies } ;


    procedure output_properties(var f: pipe;
                                props: numbered_token_list_ptr);
      { outputs the local text macros defined in this page }
      const
        PROPERTIES_PER_LINE = 12;
      var
        current: numbered_token_list_ptr; { current element }
        count: 0..PROPERTIES_PER_LINE;    { number of properties since CRLF }
    begin
      if props <> NIL then 
        begin
          pipe_dump_char(f, '+');
          current := props;  count := 0;
          while current <> NIL do with current^ do
            begin
              if count = PROPERTIES_PER_LINE then
                begin
                  pipe_dump_CRLF(f);
                  count := 1;
                end
              else count := count + 1;
              output_numbered_token(f, token^, IDENTIFIER_NUMBER);
              current := next;
            end;
          pipe_dump_CRLF(f);
        end;
    end { output_properties } ;


  begin { output_paged_schemas }
    current := ps;
    while current <> NIL do with current^ do
      begin
        pipe_dump_char(f, '=');
        output_numbered_token(f, drawing_type^, IDENTIFIER_NUMBER);
        pipe_dump_char(f, '.');
        pipe_dump_integer(f, version);
        pipe_dump_char(f, '.');
        pipe_dump_integer(f, page);
        pipe_dump_char(f, ' ');
        pipe_dump_integer(f, last_modified_time);
	(* obsolete
	if has_expr then 
	  begin
	    pipe_dump_char(f, ' ');
	    pipe_dump_char(f, 'E');
	  end;
	*)
        pipe_dump_CRLF(f);
        output_compiled_contexts(f, compiled_contexts);
        output_expandable_ids(f, expandable_ids);
        output_local_text_macros(f, local_text_macros);
        output_dependencies(f, dependencies);
        output_properties(f, properties);
        current := next;
      end;
    pipe_dump_char(f, ';');
    pipe_dump_CRLF(f);
  end { output_paged_schemas } ;


  procedure output_used_global_TMs(var f: pipe;
                                     tms: text_macro_ptr);
    { outputs the used global text macro definitions  }
    const
      GLOBAL_TMS_PER_LINE = 5;
    var
      current: text_macro_ptr;         { current element }
      count: 0..GLOBAL_TMS_PER_LINE;   { number of TMs since CRLF }
  begin
    current := tms;  count := 0;
    while current <> NIL do with current^ do
      begin
        if count = GLOBAL_TMS_PER_LINE then
          begin
            pipe_dump_CRLF(f);
            count := 1;
          end
        else count := count + 1;
        output_numbered_token(f, name^, IDENTIFIER_NUMBER);
        output_numbered_token(f, text^, STRING_NUMBER);
        if reserved then pipe_dump_alpha(f, ':R              ');
        current := next;
      end;
    pipe_dump_char(f, ';');
    pipe_dump_CRLF(f);
  end { output_used_global_TMs } ;


  procedure output_contexts(var f: pipe; cont: context_definition_ptr);
    { Renumber and output the context list -- note that any other
      references to the context by its number are now obsolete.  The
      result file lists refer to the context by pointer, so they remain ok. }
    var 
      current: context_definition_ptr; { current element }
      new_number: natural_number;
  begin
    current := cont;  new_number := 0;
    while current <> NIL do with current^ do 
      begin
        new_number := new_number + 1;
        number := new_number;
        pipe_dump_char(f, '%');
        pipe_dump_integer(f, new_number);
        pipe_dump_char(f, ' ');
        pipe_dump_integer(f, version);
        pipe_dump_char(f, ' ');
        output_parameters(f, parameters);
        current := next;
      end;
      pipe_dump_char(f, ';');
      pipe_dump_CRLF(f);
  end { output_contexts } ;
    

  procedure output_used_properties(var f: pipe; 
                                   props: property_attribute_ptr);
    { output the attributes of properties used in the drawing pages }
    const
      PROPERTIES_PER_LINE = 5;
    var
      current: property_attribute_ptr; { current element }
      count: 0..PROPERTIES_PER_LINE;   { number of properties since CRLF }
  begin
    current := props;  count := 0;
    while current <> NIL do with current^ do
      begin
        if count = PROPERTIES_PER_LINE then
          begin
            pipe_dump_CRLF(f);
            count := 1;
          end
        else count := count + 1;
        output_numbered_token(f, current^.property^, IDENTIFIER_NUMBER);
        pipe_dump_char(f, '=');
        pipe_dump_integer(f,
          et_property_attributes(current^.property^.identifier_p^.kind));
        current := next;
      end;
    pipe_dump_char(f, ';');
    pipe_dump_CRLF(f);
  end { output_used_properties } ;


begin { output_schema_file }
  init_output_continue;
  pipe_dump_alpha(f, 'FILE_TYPE=SCHEMA');
  pipe_dump_char(f, ';');  
  pipe_dump_integer(f, SCHEMA_SYNTAX_VERSION);
  pipe_dump_char(f, ' ');
  output_current_schema_directives(f);
  pipe_dump_CRLF(f);
  output_numbered_dictionary(f, schema.string_dictionary, TRUE);
  output_numbered_dictionary(f, schema.id_dictionary, TRUE);
  output_contexts(f, schema.contexts);
  output_paged_schemas(f, schema.paged_schemas);
  output_used_global_TMs(f, schema.used_global_TMs);
  output_used_properties(f, schema.used_properties);
  pipe_dump_alpha(f, 'END.            ');
  pipe_dump_CRLF(f);
end { output_schema_file } ;


(**){--------------- SCHEMA file access ---------------------------}


function read_schema_file(macro_name: xtring; macro: macro_module_ptr;
                          var schema: schema_definition): boolean;
  { Reads the schema file associated with the macro.  schema fields
    are released before reading the file. Current file is set to
  UNKNOWN_FILE when done, but CmpSchema is left open to preserve
  its advisory lock. }
  var
    extension: xtring;
begin { read_schema_file }
  if debug_20 or debug_23 or debug_24 then 
    begin
      write(outfile, ' --- read_schema_file for ');
      writestring(outfile, macro_name);
      writeln(outfile, ' ---');
    end;

  release_all_schema_fields(schema);
  schema.file_name := nullstring;
  extension := er_extension(macro);
  if extension <> NIL then
    copy_string(er_filename(macro, ord(SCHEMA_FILE), 0, NIL), 
                schema.file_name);

  current_file_name := schema.file_name;

  allowed_key_words := schema_keysys;  parse_SCALDconstants := FALSE;
  upper_case_strings := FALSE;

  schema.file_accessible := FALSE;

  if schema.file_name <> nullstring then
    if open_a_file(current_file_name, CMPSCHEM_FILE) then
      begin
        schema.file_accessible := TRUE;
        parse_schema_file(schema);
        current_file := UNKNOWN_FILE;  current_file_name := nullstring;

        { don't close it -- it is locked to this program and will later
          be written without breaking the lock }
      end
    else 
      begin
        error(232 { unable to access schema });
        error_dump_macro_name(macro_name, 0);
        error_dump_file_name(current_file_name);
        current_file := UNKNOWN_FILE;  current_file_name := nullstring;
      end;

  allowed_key_words := [];  parse_SCALDconstants := TRUE;
  upper_case_strings := TRUE;
  schema.changed := FALSE;
  read_schema_file := schema.file_accessible or (extension = NIL);
  schema_file_open := schema.file_accessible;

  if debug_20 or debug_23 or debug_24 then 
    writeln(outfile, ' --- end read_schema_file ', 
                     schema.file_accessible or (extension = NIL), 
		     ' ---');
end { read_schema_file } ;


procedure write_schema_file(var schema: schema_definition);
 { update used global TMs and writes the schema file for the given schema
   if necessary. }
begin
  enter_critical_section;
  if schema.file_accessible then
    begin
      if debug_31 then kill_self;
      if not schema.changed then 
        begin
	  if close_parse_file(CMPSCHEM_FILE) then ;
	end
      else
        begin
          log_used_global_TMs_in_schema(schema);
          if rewrite_locked_file(CMPSCHEM_FILE, schema.file_name, 
                                 CMPSCHEM_FILE_NAME) then
            begin
              pipe_from_open_file(CmpSchem_pipe, SCHEMA_PIPE, 
                                  schema.file_name);
              output_schema_file(CmpSchem_pipe, schema);
              if debug_24 then
                begin
                  write(outfile, ' Dictionaries for ');
                  dump_string(outfile, schema.file_name);
                  writeln(outfile);  writeln(outfile);
                  dump_numbered_dictionary(outfile, schema.string_dictionary);
                  dump_numbered_dictionary(outfile, schema.id_dictionary);
                end;
              pipe_close(Cmpschem_pipe);
            end
          else error(232 { unable to write a schema file });
        end;


{
      //no explicit unlocking of files, to be done by data services as a part
      //of transaction management.
      if efs_unlock(0, nullstring, schema.file_name, NIL) then ;
}

    end;

  schema.file_accessible := FALSE;
  schema_file_open := FALSE;
  release_string(schema.file_name);
  exit_critical_section;
end { write_schema_file } ;


procedure mark_dirty(page: paged_schema_ptr);
  { Mark all results for the page as dirty. }
  var
    context: compiled_context_list_ptr;  { known contexts for this page }
begin
  context := page^.compiled_contexts;
  while context <> NIL do
    begin
      context^.dirty := TRUE;
      context := context^.next;
    end;
end { mark_dirty } ;


procedure mark_dirty_for_pass_2(*page: paged_schema_ptr*);
  { Mark all results for the page as dirty by reason of changes to
    local text macros in other pages. }
  var
    context: compiled_context_list_ptr;    { known contexts for this page }
begin
  context := page^.compiled_contexts;
  while context <> NIL do
    begin
      context^.dirty_for_pass_2 := TRUE;
      context := context^.next;
    end;
end { mark_dirty_for_pass_2 } ;


procedure reverse_numbered_token_lists(var lst: numbered_token_list_ptr);
  { reverse the list }
  var
    p: numbered_token_list_ptr;    { former parent of current }
    n: numbered_token_list_ptr;    { save lst^.next }
begin
  p := NIL;
  while lst <> NIL do
    begin
      n := lst^.next;  lst^.next := p;  p := lst;  lst := n;
    end;
  lst := p;
end { reverse_numbered_token_lists } ;
  

procedure dump_paged_schema_spec(var f: textfile; page: paged_schema_ptr);
  { report drawing type, version, and page to file f }
begin
  writealpha(f, page^.drawing_type^.identifier_p^.name);
  write(f, '.', page^.version:1, '.', page^.page:1);
end { dump_paged_schema_spec } ;


procedure dump_changed_ids(var f: textfile; 
                           changed_ids: numbered_token_list_ptr);  
  { report the changed ids to file f }
  var
    cid: numbered_token_list_ptr;  { current id }
begin
  write(f, '    changed_ids:');
  if changed_ids = NIL then write(f, ' <none>');
  cid := changed_ids;
  while cid <> NIL do
    begin
      write(f, ' ');
      writealpha(f, cid^.token^.identifier_p^.name);
      cid := cid^.next;
    end;
  writeln(f);
end { dump_changed_ids } ;

      
function changed_TMs(list1, list2: text_macro_ptr): 
  numbered_token_list_ptr;
  { return a list of the identifiers whose definitions differ
    between the 2 lists.  The text macro lists are assumed
    sorted (based on id number of name). The resulting list is returned
    sorted in the same order. }
  var
    tm1: text_macro_ptr;           { current list1 element }
    tm2: text_macro_ptr;           { current list2 element }
    head: numbered_token_list_ptr; { list for return }
    

  procedure insert_tm_name(tm: text_macro_ptr);
    { insert then tm name to the head of the list }
  begin
    new_numbered_token_list(head);
    head^.token := tm^.name;
  end { insert_tm_name } ;


begin { changed_TMs }
  tm1 := list1;  tm2 := list2;  head := NIL;
  while (tm1 <> NIL) or (tm2 <> NIL) do
    if tm1 = NIL then 
      begin
	insert_tm_name(tm2);  tm2 := tm2^.next;
       end
    else if tm2 = NIL then
      begin
	insert_tm_name(tm1);  tm1 := tm1^.next;
      end
    else
      begin
        if tm1^.name^.number = tm2^.name^.number then
	  begin
	    if tm1^.text^.string_p <> tm2^.text^.string_p then
	      insert_tm_name(tm1);
	    tm1 := tm1^.next;  tm2 := tm2^.next;
	  end
        else if tm1^.name^.number < tm2^.name^.number then
	  begin
	    insert_tm_name(tm1);  tm1 := tm1^.next;
	  end
        else
	  begin
	    insert_tm_name(tm2);  tm2 := tm2^.next;
	  end;
      end;
  reverse_numbered_token_lists(head);
  changed_TMs := head;
end { changed_TMs } ;


function changed_global_TMs(tm_list: text_macro_ptr): numbered_token_list_ptr;
  { check the (global) TM list against the currently defined
    global text macros and return a list of ids whose definitions
    have changed.  Return the list in the same order as input list. }
  var
    tm: text_macro_ptr;            { current element of tm_list }
    head: numbered_token_list_ptr; { list to be returned }


  procedure insert_tm_name(tm: text_macro_ptr);
    { insert then tm name to the head of the list }
  begin
    new_numbered_token_list(head);
    head^.token := tm^.name;
  end { insert_tm_name } ;


begin
  tm := tm_list;  head := NIL;
  while tm <> NIL do
    begin
      if (tm^.name^.identifier_p^.definition <> tm^.text^.string_p) then
        insert_tm_name(tm)
      else
        if tm^.reserved then
          begin
            if not (RESERVED in tm^.name^.identifier_p^.kind) then
              insert_tm_name(tm);
	  end
        else if tm^.text^.string_p <> nullstring then
          begin
            if (tm^.name^.identifier_p^.kind * [RESERVED,UNRESERVED]) <>
	       [UNRESERVED] then insert_tm_name(tm);
	  end;
      tm := tm^.next;
    end;
  reverse_numbered_token_lists(head);
  changed_global_TMs := head;
end { changed_global_TMs } ;


function match_an_id(ids: numbered_token_list_ptr;
                     exp_ids: expandable_id_ptr): boolean;
  { return TRUE iff any id in ids is also in exp_ids.  Assume that
    both lists are sorted on id number }
  var
    id: numbered_token_list_ptr;  { current element of ids }
    exp: expandable_id_ptr;       { current element of exp_ids }
    result: boolean;              { answer so far }
begin
  result := FALSE;  id := ids;  exp := exp_ids;
  while not result and (id <> NIL) and (exp <> NIL) do
    begin
      if id^.token^.number < exp^.name^.number then id := id^.next
      else if id^.token^.number = exp^.name^.number then result := TRUE
      else exp := exp^.next;
    end;
  match_an_id := result;
end { match_an_id } ;


procedure check_global_TMs(var schema: schema_definition);
  { checks the global text macros recorded in the schema against
    the currently defined text macros.  Any pages using TMs which 
    have changed are marked as dirty }
  var
    changed_ids: numbered_token_list_ptr;  { ids whose defs have changed }
    page: paged_schema_ptr;                { page being checked }
begin
  if debug_23 then
    begin
      write(outfile, 'check_global_TMs ');
      writestring(outfile, root_macro_name);
      writeln(outfile);
    end;

  changed_ids := changed_global_TMs(schema.used_global_TMs);
  
  if debug_23 then dump_changed_ids(outfile, changed_ids);

  if changed_ids <> NIL then
    begin
      page := schema.paged_schemas;
      while page <> NIL do
        begin
	  if debug_23 then 
	    begin
	      write(outfile, '    ');
	      dump_paged_schema_spec(outfile, page);
	    end;
	  if match_an_id(changed_ids, page^.expandable_ids) then
	    begin
	      if debug_23 then writeln(outfile, ' marked dirty');
	      mark_dirty(page);
	    end
	  else if debug_23 then writeln(outfile, ' unaffected');
	  page := page^.next;
	end;
      release_all_numbered_token_lists(changed_ids);
    end;
if debug_23 then writeln(outfile, 'exit check_global_TMs');
end { check_global_TMs } ;


procedure check_global_changes(var schema: schema_definition);
  { check directives, global text macros and property attributes.
    (property attributes not yet implemented) }
  var
    page: paged_schema_ptr;                { page being checked }
begin
  if (schema.bubble_check <> bubble_check) or
     (schema.enable_cardinal_tap <> enable_cardinal_tap) then
    begin
      if debug_23 then writeln(outfile, 'Boolean directive changed');
      page := schema.paged_schemas;
      while page <> NIL do
        begin
	  mark_dirty(page);
	  if debug_23 then 
            begin
	      write(outfile, '    ');
	      dump_paged_schema_spec(outfile, page);
	      writeln(outfile, ' marked dirty');
	    end;
	  page := page^.next;
	end;
    end
  else
    begin
      check_global_TMs(schema);
    end;
end { check_global_changes } ;


function check_local_TMs(var schema: schema_definition;
                         new_TMs: text_macro_ptr;
		         old_current_page: paged_schema_ptr): boolean;
  { determine whether there are any differences between the macros
    defined by new_TMs and those defined by old_current_page.  If
    there are, then check all pages of schema (other than old_current_page)
    to see if they use any of the changed macros as expandable ids.  
    Those that do are marked dirty.  Return FALSE iff differences are found. }
  var
    changed_ids: numbered_token_list_ptr;  { ids whose defs have changed }
    page: paged_schema_ptr;                { page being checked }
begin
  if debug_23 then 
    begin
      write(outfile, 'check_local_TMs of ');
      writestring(outfile, root_macro_name);
      write(outfile, ' against ');
      dump_paged_schema_spec(outfile, old_current_page);
      writeln(outfile);
      write(Outfile, ' new list: ');
      dump_text_macros(Outfile, new_TMs);
      write(Outfile, ' old list: ');
      dump_text_macros(Outfile, old_current_page^.local_text_macros);
    end;

  changed_ids := changed_TMs(new_TMs, old_current_page^.local_text_macros);
  check_local_TMs := (changed_ids = NIL);

  if debug_23 then dump_changed_ids(outfile, changed_ids);

  if changed_ids <> NIL then
    begin
      page := schema.paged_schemas;
      while page <> NIL do
        begin
	  if page <> old_current_page then
	    begin
	      if debug_23 then 
		begin
		  write(outfile, '    ');
		  dump_paged_schema_spec(outfile, page);
		end;
	      if match_an_id(changed_ids, page^.expandable_ids) then
	        begin
	          mark_dirty_for_pass_2(page);
		  if debug_23 then
		    writeln(outfile, ' marked dirty (by local TMs)');
	        end
	      else if debug_23 then writeln(outfile, ' is unaffected');
            end;
	  page := page^.next;
	end;
      release_all_numbered_token_lists(changed_ids);
    end;
  if debug_23 then writeln(outfile, 'end check_local_TMs');
end { check_local_TMs } ;
			  

function make_current_page: boolean;
  { perform the "make" on the current page and return TRUE if page
    needs to be made and no fatal errors were detected here.
    date on schema file versus page_being_compiled file and 
    other file dependencies.
    Also, if use_usage_lists, then the old_modules_list is read in. }
  var
    current_time: time_stamp;         { last modify time on current file }
    depends_on: dependency_list_ptr;  { files other than current page that
                                        were read when last compiling it }
    dirty: boolean;                   { TRUE iff page dirty for all 
                                        compiled contexts }
    val: boolean;                     { value to be returned }
    conn_file: xtring;                { connectitivity file name
                                        (in buffer owned by C code) }


  function create_compiled_context(page: paged_schema_ptr; 
				   context: context_definition_ptr):
    compiled_context_list_ptr;
    { find or create the compiled_context for the specified context under
      the page. }
    var
      cont: compiled_context_list_ptr;  { current context in list }
      found: boolean;                { TRUE iff context is found }
  begin
    cont := page^.compiled_contexts;  found := FALSE;
    while (cont <> NIL) and not found do
      if cont^.context = context then found := TRUE
      else cont := cont^.next;
    if not found then
      begin
	if (debug_23) then
	  writeln(Outfile, '    new compiled context');
	new_compiled_context_list(page^.compiled_contexts);
	cont := page^.compiled_contexts;
	cont^.context := context;
	cont^.dirty := TRUE;
	cont^.dirty_for_pass_2 := TRUE;
      end;
    create_compiled_context := cont;
  end { create_compiled_context } ;


begin { make_current_page }
  if debug_23 then 
    begin
      write(outfile, 'make_current_page ');
      writestring(outfile, root_macro_name);
      write(outfile, '.');
      dump_paged_schema_spec(outfile, old_schema_page);
      writeln(outfile);
    end;

  if not old_schema_page^.make_performed then
    begin
      old_schema_page^.make_performed := TRUE;
      dirty := FALSE;
        
      conn_file := er_filename(module_being_compiled, ord(CONNECTIVITY), 
                              page_being_compiled, NIL);
      if (ord(conn_file^[0]) = 0) then
        begin
	  dirty := TRUE;
	  if debug_23 then 
	    writeln(Outfile, '    Can''t concoct _cn file name');
	end
      else if not get_time_stamp(conn_file, current_time) then dirty := TRUE
	{ debug_23 prints result of get_time_stamp }
      else if current_time <> old_schema_page^.last_modified_time then
        begin
          dirty := TRUE;
	  if debug_23 then 
	    writeln(Outfile, '    _cn file modified ', 
	            old_schema_page^.last_modified_time:1, '<>',
		    current_time:1);
	  old_schema_page^.last_modified_time := current_time;
	end;

      depends_on := old_schema_page^.dependencies;
      while not dirty and (depends_on <> NIL) do
        if not file_exists(depends_on^.file_name^.string_p) then
          begin
            dirty := TRUE;
            if debug_23 then
              begin
                write(outfile, '    ');
                writestring(outfile, depends_on^.file_name^.string_p);
                writeln(outfile, ' does not exist');
              end;
          end
        else if not get_time_stamp(depends_on^.file_name^.string_p,
	                           current_time) then dirty := TRUE
        else if current_time <> depends_on^.last_modified_time then
	  begin
            dirty := TRUE;
            if debug_23 then
              begin
                write(outfile, '    ');
                writestring(outfile, depends_on^.file_name^.string_p);
                writeln(outfile, ' has been changed');
              end;
	  end
        else depends_on := depends_on^.next;

      if dirty then mark_dirty(old_schema_page); 
    end;

  current_compiled_context := 
    create_compiled_context(old_schema_page, context_being_compiled);

  if make_pass = MAKE_PASS_1 then
    if not file_exists(page_expansion_file_name) then
      begin
        current_compiled_context^.dirty := TRUE;
        if debug_23 then writeln(outfile, '    no expansion file');
      end;

  if make_pass = MAKE_PASS_1 then val := current_compiled_context^.dirty
  else val := current_compiled_context^.dirty_for_pass_2;

  if debug_23 then
    if val then writeln(Outfile, '    make returns TRUE')
    else writeln(Outfile, '    make returns FALSE');

  make_current_page := val;
end { make_current_page } ;
            
     
(**){--------------- NEW & RELEASE for MODULES  and DEPEDENCIES --------}


procedure new_module_list(var head: module_list_ptr);
  { Gets a new object (from freelist, if possible),
    initializes it and inserts it at the head of the list. }
  var
    newone: module_list_ptr; { new one }
begin
  if free_module_lists <> NIL then
    begin  
      newone := free_module_lists;  
      free_module_lists := newone^.next;  
    end
  else
    begin
      new(newone);  
      increment_heap_count(HEAP_MODULE_LIST, 3*POINTER_SIZE+INT_SIZE);
    end;
  with newone^ do
    begin
      next := head;
      drawing := NIL;          { numbered token ptr }
      context := NIL;
      number := 0;
    end;
  head := newone;
end { new_module_list } ;


procedure release_module_list(var head: module_list_ptr);
  { Releases a module_list for re-use. Sets head to
    the former head^.next (so can be used for list deletion). }
  var
    old: module_list_ptr; { saves old head for release }
begin
  if head <> NIL then
    begin
      release_all_parameters(head^.context);
      old := head;
      head := head^.next;
      old^.next := free_module_lists;
      free_module_lists := old;
    end;
end { release_module_list } ;


procedure release_all_module_lists(var head: module_list_ptr);
  { releases a module_list list by insertion into freelist. Returns NIL. }
  var
    last: module_list_ptr; { last element of list }
begin
  if head <> NIL then
    begin
      last := head;  release_all_parameters(last^.context);
      while last^.next <> NIL do
        begin
	  release_all_parameters(last^.context);
	  last := last^.next;
	end;
      last^.next := free_module_lists;
      free_module_lists := head;
      head := NIL;
    end;
end { release_all_module_lists } ;


procedure release_all_module_table_fields(var tbl: module_table);
  { re-initialize the table }
  var
    i: module_table_range;
begin
  with tbl do
    begin
      highest := 0;
      for i := 0 to LAST_MODULE_TABLE_ENTRY do
        release_all_module_lists(table[i]);
    end;
end { release_all_module_table_fields } ;


procedure init_module_table(var tbl: module_table);
  { init the table }
  var
    i: module_table_range;
begin
  with tbl do
    begin
      highest := 0;
      for i := 0 to LAST_MODULE_TABLE_ENTRY do table[i] := NIL;
    end;
end { init_module_table } ;


(**){----------- MODULE HANDLING --------------------------------}


function compare_param_property_lists(context1, 
				      context2: property_ptr): compare_type;
  { compares param_property lists }
  var
    parm1: property_ptr;   { current property in context1 }
    parm2: property_ptr;   { current property in context2 }
    done: boolean;         { TRUE when comparison has been made }
begin
  parm1 := context1;  parm2 := context2;
  repeat
    done := TRUE;
    if (parm1 = NIL) then
      if (parm2 = NIL) then compare_param_property_lists := EQ
      else compare_param_property_lists := LT
    else if (parm2 = NIL) then compare_param_property_lists := GT
    else
      case compare_parameter_names(parm1^.name, parm2^.name) of
        LT: compare_param_property_lists := LT;
        GT: compare_param_property_lists := GT;
        EQ:
          case compare_strings(parm1^.text, parm2^.text) of
            LT: compare_param_property_lists := LT;
            GT: compare_param_property_lists := GT;
            EQ:
              begin
                parm1 := parm1^.next;  parm2 := parm2^.next;  done := FALSE;
              end;
	  end { case } ;
      end { case } ;
  until done;
end { compare_param_property_lists } ;


function compare_modules(mod1, mod2: module_list_ptr): compare_type;
  { compare the module list elements according to 
      1. drawing name
      2. parameters }
begin
  case compare_strings(mod1^.drawing^.string_p, mod2^.drawing^.string_p) of
    LT: compare_modules := LT;
    GT:  compare_modules := GT;
    EQ: compare_modules :=
      compare_parameter_lists(mod1^.context, mod2^.context);
  end;
end { compare_modules } ;


function module_table_index(drawing_name: xtring;
                            context: parameter_ptr): module_table_range;
  { calculate hash table index for mod }
  const
    MAX_STRING_COUNT = 6; { arbitrary limit on number of strings examined }
  var
    i: string_range;              { index into current string }
    sum: integer;                 { sum of char values }
    count: 2..MAX_STRING_COUNT;   { number of strings examined }
    parm: parameter_ptr;          { current param }
begin
  sum := 0;
  for i := 1 to ord(drawing_name^[0]) do sum := sum + ord(drawing_name^[i]);
  count := 2;  parm := context;
  while (parm <> NIL) and (count < MAX_STRING_COUNT) do
    begin
      count := count + 1;
      with parm^.text^ do 
        for i := 1 to ord(string_p^[0]) do sum := sum + ord(string_p^[i]);
      parm := parm^.next;
    end;
  module_table_index := sum mod LAST_MODULE_TABLE_ENTRY;
end { module_table_index } ;


procedure clear_errors;
  { clear error message variables (between pages) }
begin
  num_warnings := 0;
  num_oversights := 0;
  num_errors := 0;
  errors_encountered := [];
end { clear_errors } ;


procedure init_expansion_scalars;
  { initialize expansion scalars and "constant" pointers into
    dictionaries -- expansion dictionaries must be initialized 
    before calling this. }
begin
  unique_NC_number := 0;
  unique_NET_ID_number := 0;
  unique_PATH_number := 0;
  current_mtree_node := NIL;

  expansion_NC_string := 
    enter_numbered_string(NC_signal, expansion_string_dictionary);
  expansion_0_string := 
    enter_numbered_string(Zero_signal, expansion_string_dictionary);
  expansion_1_string := 
    enter_numbered_string(One_signal, expansion_string_dictionary);

  total_number_nodes := 0;
  number_leaf_nodes := 0;
  number_terminal_nodes := 0;
end { init_expansion_scalars } ;


procedure release_synonym_signal_table;
  { release all of the signals in the synonym signal table }
  var
    index: synonym_signal_table_range;    { index into the table }
    next,                                 { next signal in the bucket }
    signal: synonym_signal_ptr;           { current signal in bucket }
    inst: signal_instance_list_ptr;       { for bogus_cmptmp_list }
begin
  for index := 0 to SYNONYM_SIGNAL_TABLE_SIZE do
    begin
      signal := synonym_signal_table[index];
      synonym_signal_table[index] := NIL;
      while signal <> NIL do
        begin
          next := signal^.next;
          release_synonym_signal(signal);
          signal := next;
        end;
    end;

  if bogus_cmptmp_list <> NIL then
    begin
      inst := bogus_cmptmp_list;
      while inst^.next <> NIL do inst := inst^.next;
      inst^.next := free_signal_instance_lists;
      free_signal_instance_lists := bogus_cmptmp_list;
      bogus_cmptmp_list := NIL;
    end;
end { release_synonym_signal_table } ;


procedure release_table_of_signals_fields(var table: table_of_signals);
  { empties the table }
  var
    i: signal_table_range;   { current bucket }
    tail: signal_entry_ptr;  { tail of a bucket }
begin
  for i := 0 to SIGNAL_TABLE_SIZE do
    if table[i] <> NIL then
      begin
	tail := table[i];
	while (tail^.next <> NIL) do tail := tail^.next;
	tail^.next := free_signal_entrys;
	free_signal_entrys := table[i];
	table[i] := NIL;
      end;
end { release_table_of_signals_fields } ;


procedure release_all_signal_definitions(var list: signal_definition_ptr);
  { release list and all fields rooted with it. }
  
  var
    next_one: signal_definition_ptr;  { remembers next }
begin
  while list <> NIL do with list^ do
    begin
      next_one := next;

      release_complete_signal_def(list);

      list := next_one;
    end;
end { release_all_signal_definitions } ;


procedure release_all_mtree_nodes(var node: mtree_node_ptr);
  { release entire mtree and its fields rooted at node }
  var
    next_one: mtree_node_ptr;  { remembers next }
begin
  while node <> NIL do with node^ do
    begin
      next_one := next;
      release_complete_formal_actual_list(params);
      release_all_signal_definitions(signals);
      release_symbol_table(symbol_table);
      release_all_mtree_nodes(son);

      next := free_mtree_nodes;
      free_mtree_nodes := node;

      node := next_one;
      total_number_nodes := total_number_nodes - 1;
    end;
end { release_all_mtree_nodes } ;


procedure release_all_clear_text_actual_lists(
  var ptr: clear_text_actual_list_ptr);
  { release list along with all lists rooted there}
  var
    next_one: clear_text_actual_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      if debug_30 then debug_29 := TRUE;
      release_entire_property_list(properties);
      if debug_30 then debug_29 := FALSE;

      next := free_clear_text_actual_lists;
      free_clear_text_actual_lists := ptr;

      ptr := next_one;
    end;
end { release_all_clear_text_actual_lists } ;


procedure release_all_bindings_lists(var ptr: bindings_list_ptr);
  { release list along with all lists rooted there}
  var
    next_one: bindings_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      release_entire_property_list(pin_properties);
      release_all_clear_text_actual_lists(actual_parameter);

      next := free_bindings_lists;
      free_bindings_lists := ptr;

      ptr := next_one;
    end;
end { release_all_bindings_lists } ;


procedure release_all_invoke_lists(var ptr: invoke_list_ptr);
  { release list of macro defs with along with all lists rooted in
    the macro defs }
  var
    next_one: invoke_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      release_entire_property_list(parameters);
      release_entire_property_list(properties);
      release_all_bindings_lists(bindings);

      next := free_invoke_lists;
      free_invoke_lists := ptr;

      ptr := next_one;
    end;
end { release_all_invoke_lists } ;


procedure release_entire_signal_list(var sl: signal_list_ptr);
  { relase the entire list and any fields rooted in it (there aren't any)}
  var
    last: signal_list_ptr;  { finds last element }
begin
  if sl <> NIL then
    begin
      last := sl;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_signal_lists;
      free_signal_lists := sl;
      sl := NIL;
    end;
end { release_entire_signal_list } ;


procedure release_complete_macro_def(var MDP: macro_def_ptr);
  { release macro def and all lists associated with it.  Return NIL. }
begin
  if MDP <> NIL then with MDP^ do
    begin
      release_entire_signal_list(params);
      release_entire_property_list(properties);
      release_entire_property_list(text_macros);
      release_all_invoke_lists(invokes);

      next := free_macro_defs;
      free_macro_defs := MDP;
    end;
end { release_complete_macro_def } ;


procedure cleanup_root_macro_def;
  { release root macro def and all lists associated with it. 
    root_macro_def is assumed to be kept separate from other macro defs }
  var
    ptr: macro_def_ptr;         { an element }
    next_one: macro_def_ptr;    { remembers next }
begin
  ptr := root_macro_def;
  while ptr <> NIL do
    begin
      next_one := ptr^.next;
      release_complete_macro_def(ptr);
      ptr := next_one;
    end;
  root_macro_def := NIL;
end { cleanup_root_macro_def } ;


procedure re_init_expansion_structures;
  { Release all structures associated with the expansion of a page.
    This includes all macro defs, the mtree, and all signal definitions. 
    re-init expansion dictionaries } 
begin
  cleanup_root_macro_def;
  release_all_mtree_nodes(mtree_root);
  release_table_of_signals_fields(signal_table);
  release_numbered_dictionary(expansion_string_dictionary);
  release_numbered_dictionary(expansion_id_dictionary);
  release_all_module_table_fields(modules_in_page);
  release_synonym_signal_table;
  release_entire_avl_tree(invoke_path_table);
  init_expansion_scalars;
end { re_init_expansion_structures } ;


function get_EXPR_property: xtring;
  { read the EXPR property from the file and return it }
begin
  get_EXPR_property := nullstring;

  if id.name^.name <> 'EXPR            ' then assert(17 { expected EXPR } )
  else
    begin
      insymbol;     { eat the identifier }
      if sy = EQUAL then insymbol;
      if sy <> strings then assert(18 { expected a string })
      else
        begin
          get_EXPR_property := lex_string;
          insymbol;   { eat the string }
        end;

      if sy = SEMI then insymbol else assert(35 { expected a ; });
    end;
end { get_EXPR_property } ;


function check_for_special_body(body_name: xtring): body_type;
  { check the body name for a special body name and return its type }
  var
    type_of_body: body_type;  { type of the body }
    found: boolean;           { TRUE if body found }
begin
  type_of_body := succ(FIRST_BODY);  found := FALSE;
  while (type_of_body < LAST_BODY) and not found do
    if special_body_list[type_of_body] = body_name then found := TRUE
    else type_of_body := succ(type_of_body);

  if found then check_for_special_body := type_of_body
           else check_for_special_body := USER_BODY;
end { check_for_special_body } ;


function is_comment_body(property_list: property_ptr): boolean;
  { return TRUE if the body with the given properties is a COMMENT }
  var
    prop: property_ptr;      { property returned from the search }
begin
  is_comment_body := FALSE;

  if find_property(property_list, COMMENT_BODY_prop_name, prop) then
    is_comment_body := TRUE

  else if find_property(property_list, BODY_TYPE_prop_name, prop) then
    if prop^.text = COMMENT_string then
      is_comment_body := TRUE;
end { is_comment_body } ;


procedure check_for_abbreviation(macro: macro_def_ptr);
  { check for the ABBREV property on the macro.  If it is present,
    make sure it is legal.  If it is not present, then concoct it
    if this is a primitive. }
  var
    abbrev: property_ptr;     { pointer into property list }
    i: string_range;          { index into the abbreviation }
    done: boolean;            { TRUE when search in abbrev is complete }
begin
  if find_property(macro^.properties, ABBREV_prop_name, abbrev) then
    with abbrev^ do
      begin
        if text=nullstring then
          begin
	    { This is not the best error message for this case,
	      but it should be a rare problem, as the user
	      would have to change the connectivity file by hand
	      to do this. }
            error(128 { must be only letters, digits, & _ });
            error_dump_macro_def(macro);
            error_dump_indent(indent);
            error_dump_alpha('Abbreviation=   ');
            error_dump_alpha('<null>          ');
            error_dump_CRLF;
  
            text := concoct_abbrev(macro^.macro_name);
            error_dump_indent(indent);
            error_dump_alpha('New abbrev=     ');
            error_dump_string(text);
	    error_dump_CRLF;
          end;
	  
        i := 1;  done := FALSE;
        while (i <= ord(text^[0])) and not done do
          if not isidentchar[text^[i]] then
            begin
              error(128 { must be only letters, digits, & _ });
              error_dump_macro_def(macro);
              error_dump_indent(indent);
              error_dump_alpha('Abbreviation=   ');
              error_dump_string(text);
              error_dump_CRLF;
  
              text := concoct_abbrev(macro^.macro_name);
              error_dump_indent(indent);
              error_dump_alpha('New abbrev=     ');
              error_dump_string(text);
              error_dump_CRLF;
  
              done := TRUE;
            end
          else
            i := i + 1;
      end;
end { check_for_abbreviation } ;


function generate_unique_PATH_name(var unique_number: natural_number): xtring;
  { generate a unique PATH property for a body without one.  Use the given
    unique number. }
  var
    path: alpha;                { PATH element being created }
    pos: 0..ID_LENGTH;          { index into the new element }


  procedure add_the_number(n: natural_number);
    { add the given number to the path element recursively }
  begin
    if n > 9 then add_the_number(n div 10);
    pos := pos + 1;
    path[pos] := chr((n mod 10) + ord('0'));
  end { add_the_number } ;


begin { generate_unique_PATH_name }
  pos := 0;
  path := null_alpha;
  unique_number := unique_number + 1;
  add_the_number(unique_number);

  generate_unique_PATH_name := make_and_enter_string(path);
end { generate_unique_PATH_name } ;


(**)     { ------- MACRO definition parse ------- }


procedure parse_macro_definition(macro: macro_def_ptr);
  { read in and parse a macro definition file.  The drawing being parsed is
    defined by MACRO. }
  var
    unique_body_number: natural_number;  { serves to make all bodies unique }
    body_name: xtring;                   { current body being parsed }


  procedure display_invoke_error;
    { display the invoking macro and invoked macro names }
  begin
    error_dump_macro_def(macro);
    error_dump_body_name(body_name);
  end { display_invoke_error } ;


  function find_pin_name(var list: bindings_list_ptr; pin_name: xtring):
                                                            bindings_list_ptr;
    { find the pin name in the given list of pin names }
    var
      found: boolean;                  { TRUE with pin name is found }
      binding: bindings_list_ptr;      { pin name list element }
  begin
    binding := list;  found := FALSE;
    while (binding <> NIL) and not found do
      if pin_name = binding^.formal_parameter then found := TRUE
      else binding := binding^.next;

    if found then find_pin_name := binding
    else
      begin
        new_bindings_list(list);
        list^.formal_parameter := pin_name;
        find_pin_name := list;
      end;
  end { find_pin_name } ;
    

  procedure parse_properties(body: body_type);
    { parse the properties associated with a body }
    var
      allowed_properties: property_set;    { set of permitted properties }
      termsys: setofsymbols;               { terminal symbols for SKIP }
      property_name: name_ptr;             { current property name }
      property_value: xtring;              { current property value }
      prop_element: bindings_list_ptr;     { element for pin properties }


    function get_property: boolean;
      { read a property name/property text pair.  If there is no error,
        return FALSE otherwise return TRUE. }
      var
        found_error: boolean;      { TRUE if error found }
    begin
      found_error := TRUE;
      if sy <> IDENT then found_error := FALSE
      else
        begin
          property_name := id.name;   insymbol;
          if sy = EQUAL then insymbol else assert(178 { expected = });
          if sy <> STRINGS then
            begin
              assert(108 { expected a string });  found_error := FALSE;
              skip(termsys);
            end
          else
            begin  property_value := lex_string;  insymbol;  end;
        end;

      get_property := found_error;
    end { get_property } ;

      
    procedure copy_pin_properties(var property_list: property_ptr);
      { copy pin properties from input to property list }
    begin
      repeat
        if get_property then
          if PERMIT_PIN IN property_name^.kind then
            add_to_prop_list(property_list, property_name, property_value)
          else
            begin
              error(153 { not permitted on a pin });
              display_invoke_error;
              error_dump_property(property_name, nullstring);
              error_dump_pin_name_string(prop_element^.formal_parameter);
            end;

        if sy = SEMI then insymbol else assert(35 { expected ; });
      until sy <> IDENT;
    end { copy_pin_properties } ;


(**)     { ------- DEFINE body parsing ------ }


    procedure read_text_macros;
      { read the text macro definitions for the macro and enter into a list }
      var
        dummy: property_ptr;      { dummy value returned from find_property }
    begin
      if debug then disp_line('enter read_define');

      while sy = IDENT do
        begin
          if get_property then
            if find_property(macro^.text_macros, property_name, dummy) then
              begin
                if property_value <> dummy^.text then
		  begin
                    error(114 { text macro already exists });
                    error_dump_macro_def(macro);
                    error_dump_body_name(DEFINE_string);
                    error_dump_text_macro(property_name);
		  end;
              end
            else
              if RESERVED IN property_name^.kind then
                begin
                  error(105 { reserved TM name });
                  error_dump_macro_def(macro);
                  error_dump_body_name(DEFINE_string);
                  error_dump_text_macro(property_name);
                end
              else
                begin
                  add_to_prop_list(macro^.text_macros,
                                   property_name, property_value);

                  if macro = root_macro_def then
		    enter_local_tm(paged_schema_of_this_page,
		                   property_name, property_value);
                end;
          if sy = SEMI then insymbol else assert(35 { expected ; });
        end;

      if debug then disp_line('read_text_macros ');
    end { read_text_macros } ;


(**)     { ------- DRAWING body parsing ------- }


    procedure read_drawing_properties;
      { process the DRAWING body of the macro: the drawing properties }
      var
        dummy: property_ptr;    { dummy property pointer for property search }


      procedure display_error(directory_value: xtring);
        { display the old and new strings to the error files }
      begin
        error_dump_indent(indent);
        error_dump_alpha('Directory refs: ');
        error_dump_string(directory_value);
        error_dump_CRLF;

        error_dump_indent(indent);
        error_dump_alpha('Macro specifies:');
        error_dump_string(property_value);
        error_dump_CRLF;
      end { display_error } ;


    begin { read_drawing_properties }
      if debug then disp_line('enter read_drawin');

      while sy = IDENT do
        begin
          if get_property then
            if property_name = TITLE_prop_name then
              begin
                if macro^.macro_name <> property_value then
                  begin
                    error(182 { it doesn't match! });
                    error_dump_macro_def(macro);
                    display_error(macro^.macro_name);
                  end;
              end
            else if property_name = EXPR_prop_name then
              begin
                check_and_add_to_prop_list(macro^.properties,
                                           EXPR_prop_name, property_value);
              end
            else if property_name = ABBREV_prop_name then
              begin
                if not find_property(macro^.properties,
                                     property_name, dummy) then
                  add_to_prop_list(macro^.properties,
                                   property_name, property_value);
              end
            else
              add_to_prop_list(macro^.properties,
                               property_name, property_value);

          if sy = SEMI then insymbol else assert(35 { expected ; });
        end;

      if debug then disp_line('read_drawing_prop');
    end { read_drawing_properties } ;


(**)     { ------- USER macro invocation parsing ------- }


    procedure read_user_body_properties(invokes: invoke_list_ptr;
                                        reading_parameters: boolean);
      { read the property or parameter list on a user defined macro
        invocation.  If a property is found in the property list that
        has the IS_PARAMETER or IS_INT_PARAMETER attribute, then add it to
        the parameter list. }


      procedure check_and_add(invoke: invoke_list_ptr; is_param: boolean);
        { check the property list and if the property is not there, add it }
        var
          dummy: property_ptr;        { dummy property from find_property }
      begin
        if not (PERMIT_BODY IN property_name^.kind) then
          begin
            error(152 { not permitted on a body });
            display_invoke_error;
            error_dump_property(property_name, nullstring);
          end
        else
	  if property_name = PATH_prop_name then
            if invoke^.path <> nullstring then
              begin
                error(133 { prop already defined });
                display_invoke_error;
                error_dump_property(property_name, nullstring);
              end
	    else
	      begin
	        invoke^.path := property_value;
		current_path_prop := property_value;
	      end
          else if is_param then
            if find_property(invoke^.parameters, property_name, dummy) then
              begin
                error(180 { parameter declared twice });
                display_invoke_error;
                error_dump_property(property_name, nullstring);
              end
            else
	      add_to_prop_list(invoke^.parameters, property_name, 
	                       property_value)
          else { normal body property }
	    if find_property(invoke^.properties, property_name, dummy) then
              begin
                error(133 { prop already defined });
                display_invoke_error;
                error_dump_property(property_name, nullstring);
              end
            else 
	      add_to_prop_list(invoke^.properties, property_name, 
	                       property_value);
      end { check_and_add } ;


    begin { read_user_body_properties }
      if debug then disp_line('enter read_user_b');

      while sy = IDENT do
        begin
          if get_property then
            if reading_parameters or
               (parameter_attributes * property_name^.kind <> []) then
              check_and_add(invokes, TRUE)
            else check_and_add(invokes, FALSE);

          if sy = SEMI then insymbol else assert(35 { expected ; });
        end;

      if debug then disp_line('read_user_body_pr');
    end { read_user_body_properties } ;

      
(**)     { ------- parse properties of macro ------- }


  begin { parse_properties }
    if debug then disp_line('enter parse_prope');

    if debug_20 then writeln(outfile, '        Starting to parse properties');

    insymbol;     { eat the PROPERTY symbol }

    if body = USER_BODY then 
      allowed_properties := [BODY_PROPERTY, PIN_PROPERTY, PARAMETER_PROPERTY]
    else if body = DRAWING_BODY then
      allowed_properties := [BODY_PROPERTY]
    else if body IN bodies_with_bindings then
      allowed_properties := []
    else
      allowed_properties := [BODY_PROPERTY];

    repeat

      { check for BODY properties } 

      if sy = BODYSY then 
        begin
          if not (body_property IN allowed_properties) then 
            begin
              error(109 { not allowed here });
              skip([ENDBODYSY]);
              display_invoke_error;
            end
          else
            begin
              insymbol;  termsys := [SEMI,endbodysy];
              case body of
		MENU_BODY:       skip([ENDBODYSY]);  { ignore it }
                DEFINE_BODY:     read_text_macros;
                DRAWING_BODY:    read_drawing_properties;
                USER_BODY:       read_user_body_properties
                                         (macro^.invokes, READ_AS_PROPERTIES);
              end;
            end;

          if sy = ENDBODYSY then insymbol else assert(12 { no END_BODY });
          if sy = SEMI then insymbol else assert(35 { expected ; });
        end

      { check for PIN properties } 

      else if sy = PINSY then
        begin
          if not (pin_property IN allowed_properties) then
            begin
              error(125 { not allowed here });  skip([ENDPINSY]);
              display_invoke_error;
            end
          else
            begin
              insymbol;  termsys := [SEMI,ENDPINSY];
              repeat
                if sy <> STRINGS then 
                  begin
                    assert(14 { expected pin name });
                    skip([ENDPINSY,STRINGS]);
                  end
                else
                  begin
                    prop_element := find_pin_name(macro^.invokes^.bindings,
                                                  lex_string);
                    insymbol;
                    if sy = COLON then insymbol
                                  else assert(163 { expected : });

                    copy_pin_properties(prop_element^.pin_properties);
                  end;
              until sy <> STRINGS;
            end;
          if sy = ENDPINSY then insymbol else assert(15 { expected END_PIN });
          if sy = SEMI then insymbol else assert(35 { expected ; });
        end

      { check for PARAMETERS }

      else if sy = PARAMETERSY then
        begin
          if not (parameter_property IN allowed_properties) then
            begin
              error(188 { not allowed here });
              skip([ENDPARAMETERSY]);
              display_invoke_error;
            end
          else
            begin
              insymbol;
              termsys := [SEMI,ENDPARAMETERSY];
              read_user_body_properties(macro^.invokes, READ_AS_PARAMETERS);
            end;

          if sy = ENDPARAMETERSY then insymbol else assert(16 { wrong });
          if sy = SEMI then insymbol else assert(35 { expected ; });
        end

      { check for NULL property section or garbage }

      else if sy <> ENDPROPERTYSY then
        begin
          assert(20 { unexpected symbol in property body });
          skip(propbeginsys + [ENDPROPERTYSY]);
        end;

    until not (sy IN propbeginsys);

    if sy = ENDPROPERTYSY then insymbol else assert(21 { expected END_PROP });
    if sy = SEMI then insymbol else assert(35 { expected ; });

    if debug then disp_line('parse_properties ');
  end { parse_properties } ;


(**)     { ------- signal BINDINGs parsing ------- }


  procedure parse_bindings(body: body_type);
    { parse the formal/actual parameter bindings list for the macro or
      special body. }
    var
      pin_name: xtring;                 { pin nam in binding }
      actual_signal: xtring;            { actual signal connected to the pin }
      formal: bindings_list_ptr;        { formal/actual binding }
      actual_properties: property_ptr;  { signal (actual) properties }
      signals_NET_ID: xtring;           { NN property from current prop list }


    function read_pin_and_signal(var pin_name, signal_name: xtring;
                                 var properties: property_ptr): boolean;
      { read and return the next pin name, its actual signal, and any
        properties from the BINDINGS section.  Return TRUE if there
        are no parse errors. }


      procedure read_property_list(var properties: property_ptr);
        { read a property list of the form:
                name = 'text', name = 'text', ..., name = 'text';
          and return in the list PROPERTIES. }
        var
          done: boolean;            { TRUE if property list parsing is done }
          property_name: name_ptr;  { property name }
          property_value: xtring;   { property value }
      begin
        signals_NET_ID := nullstring;

        done := FALSE;
        while (sy = IDENT) and not done do
          begin
            property_name := id.name;
            insymbol;   { eat the identifier }

            if sy = EQUAL then insymbol;

            if sy <> STRINGS then assert(49 { expected a string })
            else
              begin
                property_value := lex_string;
                insymbol;

                if property_name = NET_ID_prop_name then
                  signals_NET_ID := property_value
                else if PERMIT_SIGNAL IN property_name^.kind then
                  add_to_prop_list(properties, property_name, property_value)
                else
                  begin
                    error(151 { not permitted on a signal });
                    error_dump_macro_def(macro);
                    error_dump_body_name(body_name);
                    error_dump_property(property_name, nullstring);
                    error_dump_signal_name_string(signal_name);
                  end;
              end;

            if sy = COMMA then insymbol else done := TRUE;
          end;
      end { read_property_list } ;


    begin { read_pin_and_signal }
      read_pin_and_signal := FALSE;
      properties := NIL;
      pin_name := nullstring;
      signal_name := nullstring;
      signals_NET_ID := nullstring;

      { get the pin name }

      if sy <> STRINGS then 
        begin  assert(23 { expected formal parameter } );  skip([SEMI]);  end
      else
        begin
          pin_name := lex_string;
          insymbol;
          if sy = EQUAL then insymbol else error(2 { expected = });
          if sy <> STRINGS then
            begin  assert(24 { expected actual param });  skip([SEMI]);  end
          else 
            begin
              signal_name := lex_string;
              insymbol;
              if sy = COLON then     { read signal properties }
                begin
                  insymbol;  { eat the : }
                  read_property_list(properties);
                end;

              read_pin_and_signal := TRUE;
            end;
        end;

      if sy = SEMI then insymbol else assert(35 { expected ; });
    end { read_pin_and_signal } ;


    procedure read_declare_bindings;
      { read in the DECLAREd signals for this macro }
    begin
      if debug then disp_line('enter read_declar');

      if macro^.is_leaf_macro then 
        skip([ENDBINDSY])    { we ignore declared signals }
      else
        begin
          error(219 { DECLARE bodies are no longer supported });
          display_invoke_error;
          skip([ENDBINDSY]);
        end;
      if debug then disp_line('read_declares    ');
    end { read_declare_bindings } ;


    procedure read_pin_name_bindings;
      { read in the PIN NAMEs for the macro }
      var
        dummy,                      { dummy string for pin name }
        signal_name: xtring;        { the PIN NAME for the body }
        properties: property_ptr;   { properties of the signal }
    begin
      if debug then disp_line('enter read_pin_na');

      if macro^.is_leaf_macro then
        skip([ENDBINDSY])    { we ignore pin names }
      else
        repeat
          if read_pin_and_signal(dummy, signal_name, properties) then
            begin
              release_entire_property_list(properties);
              new_signal_list(macro^.params);
              macro^.params^.signal_name := fix_signal_name(signal_name);
            end;
        until sy <> STRINGS;

      if debug then disp_line('read_pin_names   ');
    end { read_pin_name_bindings } ;


    function create_NET_ID: xtring;
      { create a unique NET_ID property and return it }
      var
        temp_string: xtring;      { temporary string }
    begin
      unique_NET_ID_number := unique_NET_ID_number + 1;

      create_a_string(temp_string, MAX_STRING_LENGTH);
      temp_string^[0] := chr(0);

      if add_char_to_string(temp_string, UNIQUE_PREFIX_CHAR) then;
      if add_number_to_string(temp_string, unique_NET_ID_number) then;

      create_NET_ID := enter_string(temp_string);

      temp_string^[0] := chr(MAX_STRING_LENGTH);
      release_string(temp_string);
    end { create_NET_ID } ;


  begin { parse_bindings }
    if debug then disp_line('enter parse_bindi');

    if debug_20 then writeln(outfile, '        Starting to parse bindings');

    if sy = BINDINGSY then insymbol else assert(22 { expected BINDING });

    case body of
      DECLARE_BODY:   read_declare_bindings;
      PIN_NAMES_BODY: read_pin_name_bindings;
      USER_BODY:
        repeat
          if read_pin_and_signal(pin_name, actual_signal,
                                 actual_properties) then
            begin
              formal := find_pin_name(macro^.invokes^.bindings, pin_name);
              new_clear_text_actual_list(formal^.actual_parameter);

              if net_processing and (signals_NET_ID = nullstring) then
                signals_NET_ID := create_NET_ID;

              with formal^.actual_parameter^ do
                begin
                  actual_parameter := fix_signal_name(actual_signal);
                  properties := actual_properties;
                  net_id := signals_NET_ID;
                end;
            end;
        until sy <> STRINGS;    
    end { case } ;

    if sy = ENDBINDSY then insymbol else assert(25 { expected END_BINDING });
    if sy = SEMI then insymbol else assert(35 { expected ; });

    if debug then disp_line('parse_bindings   ');
  end { parse_bindings } ;


(**)     { ------- macro INVOKE parsing ------- }


  procedure parse_invoke;
    { parse an macro invocation of the form INVOKE 'name'; ... END_INVOKE; }
    var
      body: body_type;          { type of body being parsed }
      temp: invoke_list_ptr;    { invoke to be released }


    procedure check_for_PATH_property;
      { make sure the PATH property is in the property list of a user macro }
    begin
      if macro^.invokes^.path = nullstring then
        begin
          error(197 { PATH property not found });
          display_invoke_error;
          macro^.invokes^.path := 
	    generate_unique_PATH_name(unique_body_number);
        end;
    end { check_for_PATH_property } ;


    procedure check_for_SIZE_parameter;
      { make sure the SIZE parameter exists in the parameter list }
      var
        prop: property_ptr;         { property returned from search for SIZE }
        search_prop: property_ptr;  { property returned from other searches }
    begin
      if find_property(macro^.invokes^.parameters, SIZE_prop_name, prop) then
        begin
          if find_property(macro^.invokes^.properties,
                           NEEDS_NO_SIZE_prop_name, search_prop) then
            begin
              error(144 { can't have one on this body! });
              display_invoke_error;
            end
          else if find_property(macro^.invokes^.properties,
                                HAS_FIXED_SIZE_prop_name, search_prop) then
            begin
              error(144 { can't have one on this body! });
              display_invoke_error;
              prop^.text := search_prop^.text;
            end
        end
      else { found no SIZE property }
        if find_property(macro^.invokes^.properties,
                         HAS_FIXED_SIZE_prop_name, search_prop) then
          begin
            add_to_prop_list(macro^.invokes^.parameters,
                             SIZE_prop_name, search_prop^.text);
          end;
    end { check_for_SIZE_parameter } ;


    procedure check_pin_names;
      { check all pin names of the body to make sure that all have actual
        parameters specified and "fix" all pin signal names. }
      var
        last,                           { previous element in bindings list }
        pin_name: bindings_list_ptr;    { pin name list element }
        fixed_name: xtring;             { pin name after being fixed }
    begin
      pin_name := macro^.invokes^.bindings;  last := NIL;
      while pin_name <> NIL do
        if pin_name^.actual_parameter = NIL then
          begin
            assert(165 { pin property on non-existent pin });
            write(CmpLog, 'Pin name = ');
            print_string(CmpLog, pin_name^.formal_parameter);
            writeln(CmpLog);
            if last = NIL then macro^.invokes^.bindings := pin_name^.next
            else last^.next := pin_name^.next;
            pin_name := pin_name^.next;
          end
        else
          begin
            fixed_name := fix_signal_name(pin_name^.formal_parameter);
            pin_name^.formal_parameter := fixed_name;
            last := pin_name;  pin_name := pin_name^.next;
          end;
    end { check_pin_names } ;


  begin { parse_invoke }
    if debug then disp_line('enter parse_invok');

    if debug_20 then writeln(outfile, '      Starting to parse an invoke');

    body_name := nullstring;  insymbol;      { eat the INVOKE symbol }

    if sy <> STRINGS then
      begin  assert(26 { missing macro name });  skip([ENDINVOKESY]); end
    else
      begin
        body_name := lex_string;

        { set up current environment for error reporting }

        push_error_info;
        current_body_name := body_name;

        body := check_for_special_body(body_name);

	insymbol;
	if sy = SEMI then insymbol else assert(35 { expected ; });

	if body = USER_BODY then
	  begin
	    new_invoke_list(macro^.invokes);
	    macro^.invokes^.macro_name := body_name;
	    macro^.invokes^.page_number := current_page;
	  end;

	if sy = PROPERTYSY then parse_properties(body);

	if sy = BINDINGSY then
	  if not (body IN bodies_with_bindings) then 
	    begin
	      error(136 { not allowed });
	      skip([ENDINVOKESY]);
	      display_invoke_error;
	    end
	  else
	    begin
	      parse_bindings(body);
	      if body = USER_BODY then check_pin_names;
	    end;

	if body = USER_BODY then
	  if is_comment_body(macro^.invokes^.properties) then
	    begin
	      { body is a COMMENT; ignore it completely! }

	      temp := macro^.invokes;
	      macro^.invokes := temp^.next;
	      release_invoke_list(temp);
	    end
	  else
	    begin
	      check_for_PATH_property;
	      check_for_SIZE_parameter;
	    end;

        pop_error_info;
      end;

    if sy = ENDINVOKESY then insymbol else assert(27 { no END_INVOKE });
    if sy = SEMI then insymbol else assert(35 { expected ; });

    if debug then disp_line('parse_invoke     ');
  end { parse_invoke } ;


begin { parse_macro_definition }
  if debug then disp_line('enter parse_macro');
  if debug_20 then writeln(outfile, '    Starting to parse the macro def');

  allowed_key_words := macrodef_keysys;

  if sy <> MACROSY then assert(28 { expected MACRO })
  else
    begin
      insymbol;     { eat the MACRO symbol }

      unique_body_number := 0;

      while (sy = INVOKESY) do parse_invoke;
    end;

  check_for_abbreviation(macro);

  if sy = ENDMACROSY then insymbol else assert(30 { expected END_MACRO });
  if sy <> PERIOD then assert(44 { expected . });

  if debug_20 then writeln(outfile, '    Done parsing the macro def');
  if debug then disp_line('parse_macro_defin');
end { parse_macro_definition } ;

        
(**)     { ------- read a post 6.0 GED connectivity file ------- }


function parse_connectivity_file(macro: macro_def_ptr): boolean;
  { read a connectivity file produced by a post 6.0 GED.  Check the selection
    expression.  If it exists and the directory has none, or is different,
    this means that a selection was placed one this page alone.  Evaluate
    it.  If it evaluates FALSE, do not process the drawing and return FALSE.
    If it evaluates TRUE, process the drawing and return TRUE. }
  var
    expr: xtring;                        { selection expression for drawing }
    net_table: net_table_ptr;            { head of net number table }
    unique_body_number: natural_number;  { serves to make all bodies unique }


  procedure dump_net_table;
    { dump the current net table to the debug file }
    var
      current_group: net_table_ptr;    { current group in the table }
      index: net_group_range;          { index into the group table }
  begin
    writeln(outfile);
    writeln(outfile, '---- Net table dump ----');

    current_group := net_table;
    while current_group <> NIL do
      begin
        for index := 0 to NET_GROUP_SIZE do
          if current_group^.nets[index] <> NIL then
            with current_group^.nets[index]^ do
              begin
                write(outfile, current_group^.group_number+index:2, '=');
                print_string(outfile, net_name);
                write(outfile, ' (');
                print_string(outfile, net_id);
                writeln(outfile, ')');
                dump_property_list(outfile, properties);
              end;

        current_group := current_group^.next;
      end;

    writeln(outfile);
  end { dump_net_table } ;


  function read_property_list(permission: name_types;
                              object: xtring): property_ptr;
    { read a property list from the input and return it.  Return NIL if
      there are no properties in the input file.  Make sure that every
      property in the list has the specified permission.  If an error
      occurs, use the specified OBJECT in the error message. }
    var
      prop_list: property_ptr;     { current property list }
      property_name: name_ptr;     { name of the property }
      property_value: xtring;      { value of the current property }
  begin
    prop_list := NIL;

    if sy = COLON then insymbol;

    while sy = IDENT do
      begin
        property_name := id.name;
        insymbol;                    { eat the property name ID }

        if sy <> STRINGS then
          begin  assert(18 { expected a string });  skip([IDENT,SEMI]);  end
        else
          begin
            property_value := lex_string;
            insymbol;                { eat the property value string }

            if permission in property_name^.kind then
              add_to_prop_list(prop_list, property_name, property_value)
            else
              begin
                if permission = PERMIT_BODY then
                  error(152 { not permitted on a body })
                else if permission = PERMIT_SIGNAL then
                  error(151 { not permitted on a signal })
                else if permission = PERMIT_PIN then
                  error(153 { not permitted on a body });

                error_dump_current_parse_environment;
                error_dump_property(property_name, property_value);

                if permission = PERMIT_PIN then
                  error_dump_pin_name_string(object)
                else if permission = PERMIT_SIGNAL then
                  error_dump_signal_name_string(object);
              end;
          end;
      end;

    read_property_list := prop_list;
  end { read_property_list } ;


  function find_net_in_table(net_number: net_number_range;
                             var net: net_descriptor_ptr): boolean;
    { find the given net in the table.  If it does not exist, create it
      and return it.  If the net is not already in the table, return FALSE. }
    var    
      current_group: net_table_ptr;      { current group in table }
      last: net_table_ptr;               { last group in table }
      done: boolean;                     { TRUE if group has been found or
                                           created. }
      net_index: net_group_range;        { index into table of nets }
  begin
    { find the table base for the net }

    current_group := net_table;  done := FALSE;  last := NIL;
    while (current_group <> NIL) and not done do
      if (net_number <= current_group^.group_number + NET_GROUP_SIZE) then
        begin
          done := TRUE;
	  if (net_number < current_group^.group_number) then
	    begin  { too far -- need to insert new element }
              new_net_table(current_group);  
              if last <> NIL then
                last^.next := current_group
              else
                net_table := current_group;

              current_group^.group_number :=
                net_number - (net_number MOD (NET_GROUP_SIZE+1));
            end;
	end
      else
        begin
          last := current_group;  current_group := current_group^.next;
        end;

    { create a new table base if not already there }

    if not done then
      begin
        new_net_table(current_group);
        if last <> NIL then
          last^.next := current_group
        else
          net_table := current_group;

        current_group^.group_number :=
                             net_number - (net_number MOD (NET_GROUP_SIZE+1));
      end;
        
    { get the net from the table }

    net_index := net_number - current_group^.group_number;
      
    net := current_group^.nets[net_index];
    if net <> NIL then
      find_net_in_table := TRUE
    else
      begin
        new_net_descriptor(net);
        current_group^.nets[net_index] := net;

        find_net_in_table := FALSE;
      end;
  end { find_net_in_table } ;


  function build_net_id(net_number: net_number_range): xtring;
    { create a net id property from the given net number and current page }
    var
      temp_string: xtring;      { temporary string }
  begin
    if current_page = 1 then
      create_a_string(temp_string, width_of_integer(net_number))
    else
      create_a_string(temp_string,
               width_of_integer(current_page)+width_of_integer(net_number)+1);

    temp_string^[0] := chr(0);

    if current_page <> 1 then
      begin
        if add_number_to_string(temp_string, current_page) then;
        if add_char_to_string(temp_string, '.') then;
      end;
    if add_number_to_string(temp_string, net_number) then;

    build_net_id := enter_and_release_string(temp_string);
  end { build_net_id } ;


  procedure read_nets;
    { read the nets from the input file }
    var
      net_number: net_number_range;    { number of the net being processed }
      net_name: xtring;                { name of the net }
      properties: property_ptr;        { properties of the net }
      net: net_descriptor_ptr;         { descriptor for current net }
  begin
    while sy = CONSTANT do
      begin
        net_number := 0;  net_name := nullstring;  properties := NIL;

        if sy <> CONSTANT then
          begin  assert(19 { expected a constant });  skip([SEMI]);  end
        else
          begin
            net_number := const_val;
            insymbol;                   { eat the net number }

            if sy <> STRINGS then
              begin  assert(18 { expected a string });  skip([SEMI]);  end
            else
              begin
                net_name := lex_string;
                insymbol;               { eat the net name string }

                properties := read_property_list(PERMIT_SIGNAL, net_name);
              end;
          end;

        if find_net_in_table(net_number, net) then
          assert(108 { net already specified })
        else
          begin
            net^.net_name := fix_signal_name(net_name);
            net^.properties := properties;
            net^.net_id := build_net_id(net_number);
          end;

        if sy = SEMI then insymbol else assert(35 { expected a ; });
      end;
  end { read_nets } ;


  procedure read_body;
    { read a body from the input connectivity file }
    var
      body_name: xtring;         { name of the body being read }
      body: body_type;           { type of body }
      body_version: xtring;      { version of the body used }
      XY_position: xtring;       { XY position of the body on the page }
      rotation: xtring;          { rotation of the body }
      directory: xtring;         { directory from which the body was taken }
      path: xtring;              { PATH property on the body }
      parameters: property_ptr;  { parameters attached to the body }
      body_properties:
                  property_ptr;  { body properties attached to the body }


    procedure generate_body_error(body: body_type);
      { generate an error - this body is not allowed }
    begin
      if body = MENU_BODY then error(142 { MENUs not supported })
      else if body = DECLARE_BODY then error(219 { DECLAREs not supported });
      error_dump_current_parse_environment;

      release_entire_property_list(body_properties);
      release_entire_property_list(parameters);
    end { generate_body_error } ;


    procedure set_up_properties(body: invoke_list_ptr;
                                var property: property_ptr);
      { add the properties from the given list (PROPERTY) to the
        given body invocation.  If the property has the PARAMETER attribute,
        add it to the invocation's parameter list otherwise add it to the
        property list. }
      var
        next: property_ptr;           { next property in the list }
    begin
      while property <> NIL do
        begin
          next := property^.next;

          if (parameter_attributes * property^.name^.kind) <> [] then
            check_and_add_to_prop_list(body^.parameters,
                                       property^.name, property^.text)
          else
            check_and_add_to_prop_list(body^.properties,
                                       property^.name, property^.text);

          release_property(property);

          property := next;
        end;

      add_to_prop_list(body^.properties, XY_prop_name, XY_position);
      add_to_prop_list(body^.properties, DIRECTORY_prop_name, directory);
      add_to_prop_list(body^.properties, VER_prop_name, body_version);
    end { set_up_properties } ;


    procedure fix_up_PATH_property(var path: xtring; body: invoke_list_ptr);
      { make sure there is a PATH property and add to the property list }
    begin
      if path = nullstring then
        begin
          error(197 { PATH property not found });
          error_dump_current_parse_environment;
          path := generate_unique_path_name(unique_body_number);
        end;

      body^.path := path;
    end { fix_up_PATH_property } ;


    procedure fix_up_SIZE_parameter(body: invoke_list_ptr);
      { check for the presence of HAS_FIXED_SIZE }
      var
        prop: property_ptr;          { property returned from the search }
        search_prop: property_ptr;   { property returned from search }
    begin
      if find_property(body^.parameters, SIZE_prop_name, prop) then
        begin
          if find_property(body^.properties,
                           NEEDS_NO_SIZE_prop_name, search_prop) then
            begin
              error(144 { can't have one on this body! });
              error_dump_current_parse_environment;
            end
          else if find_property(macro^.invokes^.properties,
                                HAS_FIXED_SIZE_prop_name, search_prop) then
            begin
              error(144 { can't have one on this body! });
              error_dump_current_parse_environment;
              prop^.text := search_prop^.text;
            end
        end

      else { found no SIZE property }
        if find_property(body^.properties,
                         HAS_FIXED_SIZE_prop_name, search_prop) then
          begin
            add_to_prop_list(body^.parameters,
                             SIZE_prop_name, search_prop^.text);
          end;
    end { fix_up_SIZE_parameter } ;


    procedure fix_up_ROTATION_property(rot: xtring; body: invoke_list_ptr);
      { check for a legal rotation and add rotation as property to list.
        Possible rotations are:
             0:  0   degree rotation (default).   LEGAL
             1:  90  degree rotation (up).        LEGAL
             2:  mirror of 0 degrees (left).      LEGAL
             3:  mirror of 90 degrees (down).     LEGAL
             4:  180 degree rotation (left).      ILLEGAL
             5:  270 degree rotation (down).      ILLEGAL }
    begin
      if not (rot^[1] IN ['0','1','2','3']) then
        begin
          error(143 { illegal rotation });
          error_dump_current_parse_environment;
          error_dump_indent(indent);
          if rot^[1] = '4' then
            error_dump_alpha('180 deg rotation')
          else if rot^[1] = '5' then
            error_dump_alpha('270 deg rotation');
          error_dump_CRLF;
        end;

      if (parameter_attributes * ROTATION_prop_name^.kind) <> [] then
        add_to_prop_list(body^.parameters, ROTATION_prop_name, rot)
      else
        add_to_prop_list(body^.properties, ROTATION_prop_name, rot);
    end { fix_up_ROTATION_property } ;


    function read_bindings: bindings_list_ptr;
      { read the bindings section of the current body and return them }
      var
        bindings: bindings_list_ptr;  { list of bindings for the body }
        pin_name: xtring;             { name of the pin }
        properties: property_ptr;     { properties on the pin }
        done: boolean;                { TRUE if done processing nets }
        net_number: net_number_range; { net identifying number }


      procedure set_up_actual_parameter(var actual: clear_text_actual_list_ptr;
                                        net_number: net_number_range);
        { set up the signal name for the given actual (ACTUAL) and the given
          net number (NET_NUMBER). }
        var
          net: net_descriptor_ptr;               { pointer to the actual net }
      begin
        { find the specified net in the NET table }

        if not find_net_in_table(net_number, net) then
          assert(107 { net number not in table })
        else
          begin
            actual^.actual_parameter := net^.net_name;
            actual^.properties := net^.properties;
            actual^.net_id := net^.net_id;
          end;
      end { set_up_actual_parameter } ;


    begin { read_bindings }
      bindings := NIL;

      while sy = STRINGS do
        begin
          pin_name := lex_string;
          insymbol;

          properties := read_property_list(PERMIT_PIN, pin_name);

          new_bindings_list(bindings);
          bindings^.formal_parameter := fix_signal_name(pin_name);
          bindings^.pin_properties := properties;

          done := FALSE;
          repeat
            if sy = CONSTANT then net_number := const_val
                             else assert(9 { expected a net constant });
            insymbol;

            new_clear_text_actual_list(bindings^.actual_parameter);
            set_up_actual_parameter(bindings^.actual_parameter, net_number);

            if sy = COMMA then insymbol else done := TRUE;
          until done;

          if sy = SEMI then insymbol else assert(35 { expected ; });
        end;

      read_bindings := bindings;
    end { read_bindings } ;


    procedure process_DEFINE_body(var property_list: property_ptr);
      { process properties attached to the DEFINE body.  The property list
        is released. }
      var
        next: property_ptr;          { next text macro in the list }
        text_macro: property_ptr;    { current text macro }
        dummy: property_ptr;         { dummy procedure return for search }
    begin
      text_macro := property_list;
      while text_macro <> NIL do
        begin
          next := text_macro^.next;

          if find_property(macro^.text_macros, text_macro^.name, dummy) then
            begin
              if text_macro^.text <> dummy^.text then
	        begin
                  error(114 { text macro already exists });
                  error_dump_current_parse_environment;
                  error_dump_text_macro(text_macro^.name);
		end;
            end
          else if RESERVED IN text_macro^.name^.kind then
            begin
              error(105 { reserved TM name });
              error_dump_current_parse_environment;
              error_dump_text_macro(text_macro^.name);
            end
          else
	    begin
              add_to_prop_list(macro^.text_macros,
                               text_macro^.name, text_macro^.text);
              if macro = root_macro_def then
	        enter_local_tm(paged_schema_of_this_page,
		               text_macro^.name, text_macro^.text);
            end;
		  
          release_property(text_macro);

          text_macro := next;
        end;
    end { process_DEFINE_body } ;


    procedure process_DRAWING_body(var property_list: property_ptr);
      { process the properties attached to the DRAWING body.  The property
        list is released. }
      var
        property: property_ptr;     { current property in the list }
        next: property_ptr;         { next property in the list }
    begin
      property := property_list;
      while property <> NIL do
        begin
          next := property^.next;

          if property^.name = TITLE_prop_name then
            begin
              if macro^.macro_name <> property^.text then
                begin
                  error(182 { it doesn't match! });
                  error_dump_current_parse_environment;
                  error_dump_indent(indent);
                  error_dump_alpha('TITLE prop=     ');
                  error_dump_string(property^.text);
                  error_dump_CRLF;
                end;
            end

          else if property^.name = EXPR_prop_name then
            { ignore this }

          else check_and_add_to_prop_list(macro^.properties,
                                          property^.name, property^.text);

          release_property(property);

          property := next;
        end;
    end { process_DRAWING_body } ;


  begin { read_body }
    insymbol;     { read the body start flag (%) }
    directory := nullstring; 

    if sy <> STRINGS then
      begin  assert(26 { expected macro name });  skip([PERCENT,ENDSY]);  end
    else
      begin
        body_name := lex_string;
        insymbol;             { eat the body name string }

        push_error_info;  current_body_name := body_name;

        body := check_for_special_body(body_name);

        if sy = STRINGS then body_version := lex_string
                        else assert(18 { expected a string });
        insymbol;
        if sy = COMMA then insymbol else assert(10 { expected , });

        if sy = STRINGS then XY_position := lex_string
                        else assert(18 { expected a string });
        insymbol;
        if sy = COMMA then insymbol else assert(10 { expected , });

        if sy = STRINGS then rotation := lex_string
                        else assert(18 { expected a string });
        insymbol;
        if sy = COMMA then insymbol else assert(10 { expected , });

        if sy = STRINGS then directory := lex_string
                        else assert(18 { expected a string });
        insymbol;
        if sy = COMMA then insymbol else assert(10 { expected , });

        if sy = STRINGS then path := lex_string
                        else assert(18 { expected a string });
        insymbol;

        current_path_prop := path;

        if sy = SEMI then insymbol else assert(35 { expected ; });

        parameters := read_property_list(PERMIT_BODY, nullstring);
        if sy = SEMI then insymbol else assert(35 { expected ; });

        body_properties := read_property_list(PERMIT_BODY, nullstring);
        if sy = SEMI then insymbol else assert(35 { expected ; });

        if is_comment_body(body_properties) then
          skip([PERCENT,ENDSY])
        else
          case body of
            MENU_BODY:       generate_body_error(body);

            DEFINE_BODY:     process_DEFINE_body(body_properties);

            DRAWING_BODY:    process_DRAWING_body(body_properties);

            PIN_NAMES_BODY:  begin
                               skip([PERCENT,ENDSY]);
                               release_entire_property_list(parameters);
                               release_entire_property_list(body_properties);
                             end;

            USER_BODY:       begin
                               new_invoke_list(macro^.invokes);
                               macro^.invokes^.macro_name := body_name;
                               macro^.invokes^.page_number := current_page;

                               macro^.invokes^.parameters := parameters;
                               set_up_properties(macro^.invokes,
                                                 body_properties);

                               macro^.invokes^.bindings := read_bindings;

                               fix_up_PATH_property(path, macro^.invokes);
                               fix_up_SIZE_parameter(macro^.invokes);
                               fix_up_ROTATION_property(rotation,
                                                        macro^.invokes);
                             end;

            DECLARE_BODY:    generate_body_error(body);
          end;
          
        pop_error_info;
      end;
  end { read_body } ;


begin { parse_connectivity_file }
  if debug then disp_line('enter parse_conne');

  if debug_20 then
    writeln(outfile, '    Starting to parse the connectivity file');

  net_table := NIL;
  unique_body_number := 0;
  allowed_key_words := directory_keysys;

  if sy = IDENT then expr := get_EXPR_property
                else expr := nullstring;

  if not evaluate_selection_expression(expr) then
    parse_connectivity_file := FALSE
  else
    begin
      parse_connectivity_file := TRUE;

      if sy = CONSTANT then read_nets;

      while sy = PERCENT do read_body;
    
      check_for_abbreviation(macro);

      if expr <> nullstring then
        check_and_add_to_prop_list(macro^.properties, EXPR_prop_name, expr);

      if sy = ENDSY then insymbol else assert(34 { expected END });
      if sy <> PERIOD then assert(44 { expected . });

      if debug_8 or printmacros_ok then dump_net_table;

      release_entire_net_table(net_table);
    end;

  if debug_20 then
    writeln(outfile, '    done parsing the connectivity file');
  if debug then disp_line('parse_connectivit');
end { parse_connectivity_file } ;


(**)     { ------- read a specified macro definition ------- }


function read_macro_def(macro_name: xtring): macro_def_ptr;
  { read the specified macro.  If there is more than one version, read
    the one whose selection expression is TRUE.  Return a pointer to the
    descriptor of the macro definition. }
  var
    MDP: macro_def_ptr;               { macro def to be returned }
    version: macro_module_ptr;        { version of the macro }
    plumbing: plumbing_module_ptr;


  function get_the_macro(version: plumbing_module_ptr;
                         modl: macro_module_ptr): macro_def_ptr;
    { read the pages of the plumbing body into the given macro def }
    var
      curr_file: plumbing_page_ptr;      { current file being read }
      current_file_type: file_types;     { type of the file being read }
      macro_def: macro_def_ptr;          { macro def being read }
      error_detected: boolean;           { TRUE if file error detected }
      read_one_page: boolean;            { TRUE if at least one page read }
  begin
    if debug_20 then writeln(outfile, '  Starting to get the macro');

    new_macro_def(macro_def);

    macro_def^.is_leaf_macro := er_isprim(modl);

    macro_def^.macro_name := macro_name;
    macro_def^.version := modl;
    version^.macro := macro_def;

    push_error_info;
    current_macro_def := macro_def;

    error_detected := FALSE;
    read_one_page := FALSE;

    curr_file := version^.pages;
    while curr_file <> NIL do
      begin
        allowed_key_words := macrodef_keysys + directory_keysys;

        { set up the current parse environment }

        current_page := curr_file^.page_number;
        current_file_name := curr_file^.filename;

        if not open_a_file(curr_file^.filename, STANDARD_FILE) then
          begin
            error(205 { cannot open this file });
            error_dump_current_parse_environment;

            error_detected := TRUE;
          end
        else
          begin
            current_file_type := get_file_type;

            if current_file_type = MACRO_DEFINITION then
              begin
                parse_macro_definition(macro_def);
                read_one_page := TRUE;
              end
            else if current_file_type = CONNECTIVITY then
              begin
                if parse_connectivity_file(macro_def) then
                  read_one_page := TRUE;
              end
            else error(86 { invalid file type });

            if not close_parse_file(STANDARD_FILE) then
              begin
                error(168 { cannot close the file });
                error_dump_file_name(curr_file^.filename);
              end;
          end;

        curr_file := curr_file^.next;
      end;
    allowed_key_words := [];

    if not read_one_page then
      begin
        error(177 { selection expression is false });
        error_dump_macro_def(macro_def);
      end;

    if error_detected or not read_one_page then
      begin
         get_the_macro := NIL;
	 release_complete_macro_def(macro_def);
      end
    else
      begin
        get_the_macro := macro_def;
        macro_def^.next := macro_def_list_root;
        macro_def_list_root := macro_def;
      end;

    pop_error_info;
  end { get_the_macro } ;


  function enter_plumbing_def(name: xtring;
                              version: macro_module_ptr): plumbing_module_ptr;
    { find or create (entering all pages).  Assume it's a drawing. 
      Record all pages in the dependency list of the current root page. }
    var
      ext: name_ptr;
      vers: version_range;
      current: plumbing_module_ptr;
      hash: integer;
      found: boolean;
      i: string_range;


    procedure record_dependencies(pages: plumbing_page_ptr);
    begin
      while pages <> NIL do
        begin
	  add_to_dependency_list(pages);
	  pages := pages^.next;
	end;
    end { record_dependencies } ;


    function enter_pages: plumbing_page_ptr;
      var
	head: plumbing_page_ptr;
	page_num: page_range;
	last_page: plumbing_page_ptr;


      function insert_page(num: page_range; var where: plumbing_page_ptr):
	plumbing_page_ptr;
	var
	  fname: xtring;
	  pg: plumbing_page_ptr;
      begin
	fname := 
	  enter_string(er_filename(version, ord(CONNECTIVITY), num, NIL));
	if fname = nullstring then pg := where
	else
	  begin
	    new(pg);
	    increment_heap_count(HEAP_PLUMBING_PAGE, 
	                         2*POINTER_SIZE+2*INT_SIZE);
	    with pg^ do
	      begin
		next := where;  where := pg;
      
		page_number := num;
		filename := fname;
		last_modified_time := 0;
	      end;
	  end;
	insert_page := pg;
      end { insert_page } ;


    begin { enter_pages }
      if debug_24 then
        begin
	  write(Outfile, 'Enter_pages of plumbing ');
	  dump_string(Outfile, name);
	  write(Outfile, '.');
	  dump_string(Outfile, er_extension(version));
	  writeln(Outfile, '.', er_version(version):1);
	end;

      head := NIL;  last_page := NIL;
      page_num := er_page(version);
      while page_num <> 0 do
	begin
	  if last_page = NIL then
	    last_page := insert_page(page_num, head)
	  else 
	    last_page := insert_page(page_num, last_page^.next);
	  page_num := er_page(version);
	end;
      enter_pages := head;
    end { enter_pages } ;


  begin { enter_plumbing_def }
    ext := name_from_string(er_extension(version));
    vers := er_version(version);

    hash := 0;
    for i := 1 to ord(name^[0]) do hash := hash + ord(name^[i]);
    hash := hash mod (LAST_PLUMBING_BUCKET + 1);
    current := plumbing_table[hash];  found := FALSE;
    while (current <> NIL) and not found do
      if (current^.macro_name = name) and
	 (current^.extension = ext) and 
	 (current^.version_number = vers) then found := TRUE
      else current := current^.next;

    if current = NIL then
      begin
        new(current);
	increment_heap_count(HEAP_PLUMBING_MODULE, 5*POINTER_SIZE+INT_SIZE);
	with current^ do
	  begin
	    next := plumbing_table[hash];
	    plumbing_table[hash] := current;

	    macro_name := name;
	    extension := ext;
	    version_number := vers;
	    pages := NIL;
	    macro := NIL;

            pages := enter_pages;
	  end;
      end;

    record_dependencies(current^.pages);
    enter_plumbing_def := current;
  end { enter_plumbing_def } ;


  function concoct_forced_primitive(name: xtring;
				    version: macro_module_ptr): macro_def_ptr;
    { Build data structures that whould have been built if the connectivity
      file existed for PRIM.1.1 }
    var
      macro: macro_def_ptr;   { Value for return }
  begin
    new_macro_def(macro);
    macro^.next := root_macro_def;  root_macro_def := macro;
  
    macro^.is_leaf_macro := TRUE;
    macro^.macro_name := name;
    macro^.version := version;
  
    add_to_prop_list(macro^.properties,ABBREV_prop_name, concoct_abbrev(name));
  
    { ignore properties to define the non-graphical model -- this is 
      an error }

    concoct_forced_primitive := macro;
  end { concoct_forced_primitive } ;


begin { read_macro_def }
  if debug then
    disp_line('enter read_Mdef  ');

  if debug_20 then writeln(outfile, 'Starting to read a macro def');

  MDP := NIL;
  version := select_module(macro_name, nullstring, 0);
  if version <> NIL then
    begin
      if er_extension(version) = NIL then
	{ illegal, but possible -- error emitted elsewhere }

        { !!! CHANGE this to emit the error here, or else }
	MDP := concoct_forced_primitive(macro_name, version)
      else
        begin
	  plumbing := enter_plumbing_def(macro_name, version);
	  MDP := plumbing^.macro;
	  if MDP = NIL then  { macro hasn't yet been read in }
	    begin
	      MDP := get_the_macro(plumbing, version);
	      if printmacros_ok and (MDP <> NIL) then
	        print_macro(outfile, MDP);
	    end;
	end;
    end;

  read_macro_def := MDP;

  if debug then disp_line('read_Mdef        ');
end { read_macro_def } ;


(**)     { ------- read a macro page ------------------------- }


function read_macro_page(macro_name: xtring): macro_def_ptr;
  { read the current page of the macro into a macro definition.
    Return a pointer to the descriptor of the macro definition. }
  var
    MDP: macro_def_ptr;               { macro def to be returned }


  function get_the_page(version: macro_module_ptr): macro_def_ptr;
    { read the page of the macro into the given macro def }
    var
      current_file_type: file_types;     { type of the file being read }
      macro_def: macro_def_ptr;          { macro def being read }
      error_detected: boolean;           { TRUE if file error detected }
  begin
    if debug_20 then writeln(outfile, '  Starting to get the page');

    new_macro_def(macro_def);
    macro_def^.next := root_macro_def;  root_macro_def := macro_def;

    get_the_page := macro_def;
    macro_def^.is_leaf_macro := er_isprim(version);
    macro_def^.macro_name := macro_name;
    macro_def^.version := version;

    push_error_info;
    current_macro_def := macro_def;

    error_detected := FALSE;

    allowed_key_words := macrodef_keysys + directory_keysys;

    { set up the current parse environment }

    current_page := page_being_compiled;
    current_file_name := nullstring;
    copy_string(er_filename(module_being_compiled, ord(CONNECTIVITY), 
                            page_being_compiled, NIL),
                current_file_name);

    if (current_file_name <> nullstring) then
      if not open_a_file(current_file_name, STANDARD_FILE) then
	begin
	  error(205 { cannot open this file });
	  error_dump_current_parse_environment;
  
	  error_detected := TRUE;
	end
      else
	begin
	  current_file_type := get_file_type;
  
	  if current_file_type = MACRO_DEFINITION then
	    parse_macro_definition(macro_def)
	  else if current_file_type = CONNECTIVITY then
	    begin
	      if parse_connectivity_file(macro_def) then ;
	    end
	  else 
	    begin
	      error(86 { invalid file type });
	      error_detected := TRUE;
	    end;
  
	  if not close_parse_file(STANDARD_FILE) then
	    begin
	      error(168 { cannot close the file });
	      error_dump_file_name(current_file_name);
	    end;
	end;

    release_string(current_file_name);
    allowed_key_words := [];
    pop_error_info;
    if error_detected then get_the_page := NIL
		      else get_the_page := macro_def;
  end { get_the_page } ;


begin { read_macro_page }
  if debug then
    disp_line('enter read_macro_');

  if debug_20 then writeln(outfile, 'Starting to read a macro page');

  MDP := NIL;
  if (module_being_compiled = NIL)  then assert(227 { not allowed})
  else
    begin
      if extension_being_compiled = null_name then assert(227)
      else MDP := get_the_page(module_being_compiled);

      if printmacros_ok and (MDP <> NIL) then print_macro(outfile, MDP);
    end;

  read_macro_page := MDP;

  if debug then disp_line('read_Mpage       ');
end { read_macro_page } ;


(**)     { ------- scope utilities ------- }


function determine_scope(scope_value: xtring): scope_type;
  { determine the scope from the value given (SCOPE_VALUE) }
  var
    scope: scope_type;      { scope as determined }
    found: boolean;         { TRUE if entry in table is found }
begin
  scope := succ(FIRST_SCOPE);  found := FALSE;
  while (scope < LAST_SCOPE) and not found do
    if scope_table[scope] = scope_value then found := TRUE
    else scope := succ(scope);

  if scope = LAST_SCOPE then scope := UNKNOWN_SCOPE;

  determine_scope := scope;
end { determine_scope } ;


(**)     { ------- signal utilities ------- }


function create_a_subscript(width: natural_number): subscript_ptr;
  { create a bit subscript of the specified width }
  var
    sub: subscript_ptr;       { subscript being created }
begin
  sub := NIL;  new_subscript(sub);
  if left_to_right then
    begin  sub^.left_index := 0;  sub^.right_index := width-1;  end
  else
    begin  sub^.left_index := width-1;  sub^.right_index := 0;  end;

  create_a_subscript := sub;
end { create_a_subscript } ;


function unique_NC_name: xtring;
  { create a unique name for an NC signal }
  var
    number: alpha;                      { used to create string to return }
    pos: id_range;                      { index into NUMBER }
    temp: xtring;                       { string to be returned }


  procedure convert_number_to_char(n: integer);
    { add the given number to the name buffer recursively }
  begin
    if n > 9 then convert_number_to_char(n div 10);
    pos := pos + 1;  number[pos] := chr((n mod 10)+ord('0'));
  end { convert_number_to_char } ;


begin { unique_NC_name }
  number := special_NC_name;  number[1] := chr(NC_prefix_char);  pos := 3;
  convert_number_to_char(unique_NC_number);
  unique_NC_number := unique_NC_number + 1;

  temp := make_and_enter_string(number);
  unique_NC_name := temp;
end { unique_NC_name } ;


function is_NC_signal(signal_name: xtring): boolean;
  { check the signal to see if it is an NC signal and return TRUE if so }
begin
  is_NC_signal := (signal_name^[1] = chr(NC_prefix_char));
end { is_NC_signal } ;


function is_NC_def(def: signal_definition_ptr): boolean;
  { return TRUE if the signal definition describes an NC signal }
begin
  is_NC_def := is_NC_signal(def^.signal^.name);
end { is_NC_def } ;


function is_unnamed_signal(signal_name: xtring): boolean;
  { return TRUE if the signal is an UNNAMED signal }
  var
    i: id_range;           { index into alpha }
    alpha_name: alpha;     { alpha UNNAMED signal name }
    done: boolean;         { TRUE if '$' is found in name }
begin
  is_unnamed_signal := FALSE;
  if ord(signal_name^[0]) > UNNAMED_SIGNAL_NAME_LENGTH then
    begin
      alpha_name := NULL_ALPHA;
      i := 1;  done := FALSE;
      while (i <= UNNAMED_SIGNAL_NAME_LENGTH) and not done do
        if signal_name^[i] = '$' then done := TRUE
        else
          begin  alpha_name[i] := signal_name^[i];  i := i + 1;  end;
      is_unnamed_signal := (alpha_name = UNNAMED_signal) or
                           (alpha_name = short_UNNAMED_signal);
    end;
end { is_unnamed_signal } ;


function is_strange_signal(signal: signal_descriptor_ptr): boolean;
  { return TRUE if the signal is UNNAMED or NC }
  var
    strange: boolean;
begin
  strange := is_NC_signal(signal^.signal_name);
  if not strange then
    strange := is_unnamed_signal(signal^.signal_name);

  is_strange_signal := strange;
end { is_strange_signal } ;


(**)     { ------- generate an expanded string ------- }


function expand_text_macros(TM_name: name_ptr; str: xtring): xtring;
  { expand all the text macros in the input string (str) and return the
    exanded string.  If TM_name is an integer parameter, then identifiers
    are logged as hard expandable ids, else they are logged as soft. }
  var
    s: xtring;                  { string to be created }
    pos: string_range;          { position within the string for copy }
    save_debug: boolean;
begin
  if debug_33 then
    begin
      save_debug := debug;  debug := TRUE;
    end;

  copy_input := TRUE;  current_pos := 0;  copy_error := FALSE;
  if TM_name = NIL then assert(215 { not ok! });

  parse_string(str, PARSE_SEPARATELY);
  while (sy <> ENDOFDATASY) and not copy_error do
    begin  
      current_pos := copy_pos;  
      insymbol;  
    end;

  if copy_error then
    begin
      error(116 { expanded string exceeds the max length });
      error_dump_text_macro(TM_name);
    end;

  pop_parsed_string(str);
  create_a_string(s, copy_pos);
  for pos := 1 to copy_pos do s^[pos] := copy_buffer[pos];
  expand_text_macros := enter_and_release_string(s);
  copy_input := FALSE;  copy_error := FALSE;

  if debug_33 then debug := save_debug;
end { expand_text_macros } ;


function find_text_macro(node: mtree_node_ptr; text_macro_name: name_ptr):
                                                                       xtring;
  { find the given text macro starting at the given node.  Return the
    definition of the text macro.  If it cannot be found, return NULL. }
  var
    curr_node: mtree_node_ptr;      { current mtree node }
    id: identifier_ptr;             { identifier from table }
    found: boolean;                 { TRUE if name found in the table }
begin
  if text_macro_name^.definition <> nullstring then
    find_text_macro := text_macro_name^.definition
  else
    begin
      find_text_macro := nullstring;

      curr_node := node;  found := FALSE;
      while (curr_node <> NIL) and not found do
        if found_id(curr_node, text_macro_name, id) then
          found := TRUE
        else
          curr_node := curr_node^.father_node;

      if found then
        find_text_macro := id^.definition;
    end;
end { find_text_macro } ;


(**)     { ------- expand text macros in property values ------- }


function TM_prefix_in_string(str: xtring): boolean;
  { return TRUE iff the text macro prefix char exists in the string }
  var
    found: boolean;     { TRUE iff we find it }
    i: string_range;    { index into str }
begin
  found := FALSE;  i := 0;
  while not found and (i < ord(str^[0])) do
    if str^[i] = TM_PARAMETER_PREFIX_CHAR then found := TRUE
    else i := i + 1;
  TM_prefix_in_string := found;
end { TM_prefix_in_string } ;


function expand_property_value_TMs(node: mtree_node_ptr;
                                   property_name: name_ptr;
                                   property_val: xtring): xtring;
  { expand any text macros found and return the result. node gives the
    context. NOTE: property_val is never assigned to anything here, so
    this proc does nothing to prevent the calling procedure from releasing
    it later.  The result is, however, entered in the string table. }
  type
    buffer_index = 0..ID_LENGTH;

  var
    result: xtring;        { expanded value }
    ch: char;              { current character from the input string }
    delimiter_char: char;  { character delimiting text macro }
    index: string_range;   { index into the current string }
    j: buffer_index;       { index into the text macro name }
    done: boolean;         { TRUE when text macro name found }
    buffer: alpha;         { text buffer for text macro }
    text_macro: name_ptr;  { text macro name to be expanded }
    definition: xtring;    { text macro definition }
    ovf_error: boolean;    { TRUE if overflow error has been found }
    found_error: boolean;  { TRUE if error with formation of current id has
                             been found }


  procedure get_char(var ch: char);
    { get the next character from the input string }
  begin
    if index < ord(property_val^[0]) then
      begin  index := index + 1;  ch := property_val^[index];  end
    else
      ch := chr(EOL);
  end { get_char } ;
    
    
  procedure report_overflow_error;
    { if not already done, report that the result has overflowed. }
  begin
    if not ovf_error then
      begin
        error(22 { string overflow });
        error_dump_body_node(node);
        error_dump_property(property_name, property_val);
        error_dump_expanded_value(result);
        ovf_error := TRUE;
      end;
  end { report_overflow_error } ;


  procedure dump_buffer(end_of_buffer: buffer_index);
    { copy the buffer to the result }
    var
      i: buffer_index;      { index into the buffer }
  begin
    if not add_char_to_string(result, TM_PARAMETER_PREFIX_CHAR) then
      report_overflow_error;
    for i := 1 to end_of_buffer do
      if not add_char_to_string(result, buffer[i]) then
        report_overflow_error;
  end { dump_buffer } ;
    
    
begin { expand_property_value_TMs }
  if debug_18 then
    begin
      write(outfile, 'Entering expanded_property_value_TMs: node=');
      if node = NIL then writeln(outfile, '<NIL>')
      else
        begin
          print_string(outfile, node^.macro_name);  writeln(outfile);
        end;
      writeln(outfile, 'Property name=', property_name^.name);
      write(outfile, 'Property value=');
      print_string(outfile, property_val);
      writeln(outfile);
    end;

  create_a_string(result, MAX_STRING_LENGTH);  result^[0] := chr(0);

  index := 0;  get_char(ch);  ovf_error := FALSE;
  while not ovf_error and (ch <> chr(EOL)) do
    begin
      if ch <> TM_PARAMETER_PREFIX_CHAR then
        begin
          if not add_char_to_string(result, ch) then report_overflow_error;
          get_char(ch);
        end
      else
        begin
          if debug_18 then writeln(outfile, '--found TM');

          get_char(ch);    { eat the '%' prefix }

          if (ch = '''') or (ch = '"') then
            begin  delimiter_char := ch;  get_char(ch);  end
          else
            delimiter_char := ' ';

          found_error := FALSE;
          buffer := NULL_ALPHA;  j := 0;  done := FALSE;
          while (ch <> chr(EOL)) and not done do
            if delimiter_char = ' ' then
              if isidentchar[ch] then
                begin
                  if j < ID_LENGTH then
                    begin  j := j + 1;  buffer[j] := ch;  end;
                  get_char(ch);
                end
              else
                done := TRUE
            else
              if ch = delimiter_char then
                begin  get_char(ch);  done := TRUE;  end
              else
                begin
                  if isidentchar[ch] then
                    begin
                      if j < ID_LENGTH then
                        begin  j := j + 1;  buffer[j] := ch;  end;
                    end
                  else if not found_error then
                    begin
                      error(126 { text macro name is not an identifier });
                      error_dump_body_node(node);
                      error_dump_property(property_name, property_val);
                      found_error := TRUE;
                    end;
                  get_char(ch);
                end;

          { text macro name has been removed from the input string.
            Find the text macro in the current symbol table }

          if debug_18 then writeln(outfile, '--TM found=', buffer);

          if not isupper[buffer[1]] then
            { not a text macro name - maybe just some character }
            dump_buffer(j)
          else
            begin
              text_macro := enter_name(buffer);
	      enter_expandable_id(text_macro);
              definition := find_text_macro(node, text_macro);

              if debug_18 then
                begin
                  writeln(outfile, '--TM def=');
                  print_string_with_quotes(outfile, definition);
                  writeln(outfile);
                end;

              if definition = nullstring then
                begin
                  error(106 { TM does not exist });
                  error_dump_body_node(node);
                  error_dump_property(text_macro, nullstring);
                  error_dump_text_macro(text_macro);
                end
              else
                { to allow nested text macros, place recursive call here.
                  Need to pay attention to the node! }

                if not add_string_to_string(result, definition) then
                  report_overflow_error;
            end;
        end;
    end { while } ;

  expand_property_value_TMs := enter_string(result);

  result^[0] := chr(MAX_STRING_LENGTH);
  release_string(result);
end { expand_property_value_TMs } ;


function expand_property_list_TMs(node: mtree_node_ptr;
                                  props: property_ptr): property_ptr;
  var
    prop: property_ptr;        { current property }
    result: property_ptr;      { list for return }
    exp_value: xtring;         { current expanded property value }
  { return a list of properties with values expanded. order is assumed to
    be unimportant }
begin
  prop := props;  result := NIL;
  while prop <> NIL do
    begin
      exp_value := expand_property_value_TMs(node, prop^.name, prop^.text);
      add_to_prop_list(result, prop^.name, exp_value);
      prop := prop^.next;
    end;
  expand_property_list_TMs := result;
end { expand_property_list_TMs } ;


(**)     { ------- parse a signal name and return descriptor ------- }


function parse_signal_name(signal_name: xtring; use_NAC: boolean): 
                                                signal_descriptor_ptr;
  { parse the specified signal into its various components and return a
    descriptor.  It assumed that the context of the signal is active
    so that all expression and text macro evaluations can be correctly
    performed. }
  var
    property_name: name_ptr;         { current property name }
    property_value: xtring;          { current property value }
    negated,                         { TRUE if signal is negated }
    done: boolean;                   { TRUE when entire string is parsed }
    bit_subscript: subscript_ptr;    { temp bit subscript }
    last,                            { last descriptor created }
    SDP: signal_descriptor_ptr;      { signal descriptor to be returned }
    syntax_index: signal_syntax_range;  { index into syntax table }
    found_scope: boolean;            { TRUE if SCOPE property found }
    scope: scope_type;               { scope of signal }
    rep_prop_value: xtring;          { value of the replication property }
    found_no_assertion: boolean;     { TRUE if no assertion char found }
    is_NC: boolean;                  { TRUE if signal is NC }
    is_UNNAMED: boolean;             { TRUE if signal is UNNAMED }


  function get_property(terminal: symbols): boolean;
    { parse the property decoding special ones and return TRUE if no error.
      Assume that identifiers not properly followed by strings are undefined
      macros - thus needing to be logged as MUST_BE_DEFINED expandable_ids }
    var
      ok: boolean;                   { function value to be returned }
  begin
    ok := FALSE;

    if sy <> IDENT then
      begin  error(1 { expected identifier });  skip([terminal]);  end
    else
      begin
        property_name := id.name;  insymbol;

        if sy = EQUAL then insymbol else error(2 { expected = });

        if sy <> STRINGS then
          begin  
            error(33 { expected a string });  
            enter_expandable_id(property_name);
            skip([terminal]);  
          end
        else
          begin
            property_value := lex_string;  insymbol;  ok := TRUE;

            { expand property value TMs using % mechanism }

            property_value := expand_property_value_TMs(current_mtree_node,
                                                        property_name,
                                                        property_value);
          end;
      end;

    get_property := ok;
  end { get_property } ;


  procedure convert_into_binary(var signal_name: xtring);
    { convert CONST_VAL into an equivalent binary representation in string }
    var
      val: integer;                  { value of the constant }
      pos: string_range;             { index into the string being created }
  begin
    if const_width = 0 then assert(31 { illegal width });

    create_a_string(signal_name, const_width);
    for pos := 1 to const_width do signal_name^[pos] := '0';
    val := const_val;  pos := const_width;
    while (val > 0) and (pos > 0) do
      begin
        signal_name^[pos] := chr((val MOD 2) + ord('0'));
        val := val DIV 2;  pos := pos - 1;
      end;

    signal_name := enter_and_release_string(signal_name);
  end { convert_into_binary } ;


  procedure get_signal_name(SDP: signal_descriptor_ptr);
    { parse the signal name.  It may be a name or a constant.  If the
      signal name = NC, generate a unique name for it. }
  begin
    if sy = STRINGS then     { it's a signal name }
      begin
        SDP^.is_const := FALSE;      { just to make sure }
        if lex_string = NC_signal then
          begin
            SDP^.signal_name := unique_NC_name;
            SDP^.kind := UNDEFINED;
            SDP^.polarity := NO_POLARITY;
            scope := LOCAL;
            is_NC := TRUE;
          end
        else
          SDP^.signal_name := lex_string;
          if is_unnamed_signal(SDP^.signal_name) then
            begin
              scope := LOCAL;
              SDP^.kind := UNDEFINED;
              SDP^.polarity := UNKNOWN_POLARITY;
              is_UNNAMED := TRUE;
            end;

        insymbol;
      end

    else if (sy = SIGNALCONST) or (sy = CONSTANT) then
      begin
        SDP^.is_const := TRUE;
        scope := SIG_CONST;

        convert_into_binary(SDP^.signal_name);     { uses CONST_VAL }
        if ord(SDP^.signal_name^[0]) > 1 then
          begin
            SDP^.kind := VECTOR;
            SDP^.bit_subscript :=
                              create_a_subscript(ord(SDP^.signal_name^[0]));
          end;
        insymbol;
      end

    else error(83 { expected signal name or constant });
  end { get_signal_name } ;


  procedure process_replication(SDP: signal_descriptor_ptr);
    { if a replication factor was specified, set the corresponding field
      in SDP^.  If the signal is an NC change the KIND field to VECTOR
      and represent the "replicated" NC as a vector of that many bits --
      this insures that they are not synonymed together. }
      
    var
      temp: integer;           { value of expression }
  begin
    if rep_prop_value <> nullstring then
      begin
        parse_string(rep_prop_value, PARSE_SEPARATELY);
        temp := expression(NO_RELOPS);
        if sy <> ENDOFDATASY then
          begin
            error(58 { extraneous junk });
            error_dump_indent(indent);
            error_dump_alpha('Processing REP= ');
            error_dump_string(signal_name);
            error_dump_CRLF;
          end;

        if (temp <= 0) or (temp > MAX_BIT_VALUE) then
          begin  error(84 { too big });  temp := 1;  end;

        pop_parsed_string(rep_prop_value);

	if is_NC then
	  begin
	    SDP^.kind := VECTOR;
	    SDP^.bit_subscript := create_a_subscript(temp);
	  end
	else SDP^.replication_factor := temp;
      end;

  end { process_replication } ;


  procedure fix_UNNAMED_signal_name;
    { add a unique number to the end of the signal name to make unique }
    var
      temp: xtring;          { temporary string for new name creation }
      i: string_range;       { index into the signal name }
      length: string_range;  { length of the original signal name }
  begin
    length := ord(SDP^.signal_name^[0]);
    create_a_string(temp, length+2);
    for i := 1 to length do
      temp^[i] := SDP^.signal_name^[i];

    temp^[length+1] := '$';
    temp^[length+2] := 'A';

    SDP^.signal_name := enter_and_release_string(temp);
  end { fix_UNNAMED_signal_name } ;


  procedure fix_name_starting_with_paren;
    { Signal name begins with '('.  Issue error message and prepend the
      signal class 'ILL$' }
    var
      temp: xtring;          { temporary string for new name creation }
      length: string_range;  { length of the original signal name }
  begin
    length := min(ord(SDP^.signal_name^[0]) + 4, MAX_STRING_LENGTH);
    create_a_string(temp, length);
    temp^[0] := chr(0);
    if add_alpha_to_string(temp, 'ILL$            ') then ;
    if add_string_to_string(temp, SDP^.signal_name) then ;

    error(54 { Don't start signal name with '(' });
    error_dump_current_parse_environment;
    error_dump_signal_descriptor(SDP);
    error_dump_indent(INDENT);
    error_dump_alpha('Name changed to:');
    error_dump_string(temp);
    error_dump_CRLF;

    SDP^.signal_name := enter_and_release_string(temp);
  end { fix_name_starting_with_paren } ;


  procedure fix_complemented_constant(signal: signal_descriptor_ptr);
    { complement the bits in the constant signal name }
    var
      i: string_range;        { index into the signal name }
      new_name: xtring;       { new name for the signal }
      length: string_range;   { length of the signal name }
  begin
    length := ord(signal^.signal_name^[0]);
    create_a_string(new_name, length);

    for i := 1 to length do
      if signal^.signal_name^[i] = '0' then new_name^[i] := '1'
                                       else new_name^[i] := '0';

    signal^.signal_name := enter_and_release_string(new_name);
  end { fix_complemented_constant } ;


begin { parse_signal_name }
  if debug then disp_line('enter parse_signa');

  { care must be taken to ensure that text macros are handled correctly when
    parsing a signal.  Text macros (without the delimiter characters) are
    permitted in only two places:  within bit subscripts and within general
    property specifications.  The global flag ALLOW_TM_EXPANSION controls
    whether the input parser expands identifiers (that are text macros) or
    not.  It is initially set OFF and is set ON when a subscript is parsed
    (after which it is set off again) and is set ON when a general property
    prefix is found. }

  allow_TM_expansion := FALSE;

  parse_string(signal_name, PARSE_SEPARATELY);

  done := FALSE;  last := NIL;

  repeat
    new_signal_descriptor(SDP);  
    if last = NIL then parse_signal_name := SDP else last^.next := SDP;  
    last := SDP;

    SDP^.kind := SINGLE;
    scope := UNKNOWN_SCOPE;  found_scope := FALSE;
    rep_prop_value := nullstring;
    found_no_assertion := FALSE;
    is_NC := FALSE;
    is_UNNAMED := FALSE;

    negated := FALSE;
    for syntax_index := 1 to SYNTAX_TABLE_SIZE do
      case signal_syntax_table[syntax_index] of

        NEGATION_SPECIFIER:
            begin
              negated := (sy = signal_negation_symbol);
              if negated then insymbol;
            end;

        NAME_SPECIFIER:
            begin
              get_signal_name(SDP);
            end;

        SUBSCRIPT_SPECIFIER:
            begin
              allow_TM_expansion := TRUE;
              bit_subscript := bit_selector;
              allow_TM_expansion := FALSE;
              if SDP^.is_const then
                if bit_subscript <> NIL then
                  begin
                    error(96 { can't have bit subscript on constant! });
                    { NOTE: release that subscript! }
                  end
                else { it's OK.  leave the subscript alone }
              else SDP^.bit_subscript := bit_subscript;

              if SDP^.bit_subscript <> NIL then
                if SDP^.kind = UNDEFINED then assert(153 { UNNAMED w/ width })
                else SDP^.kind := VECTOR;
            end;

        ASSERTION_SPECIFIER:
            begin
              if sy = signal_is_asserted_low_symbol then
                begin
                  SDP^.low_asserted := TRUE;
                  insymbol;
                end
              else if sy = signal_is_asserted_high_symbol then
                begin
                  SDP^.low_asserted := FALSE;
                  insymbol;
                end
              else if signal_is_asserted_high_symbol <> NULLSY then
                if not allow_missing_high_assertion then
                  found_no_assertion := TRUE;
            end;
    
        PROPERTY_SPECIFIER:
            begin
              allow_TM_expansion := TRUE;
              allowed_key_words := allowed_key_words - config_keysys;

              while sy = general_property_prefix_symbol do
                begin
                  insymbol;
                  if get_property(general_property_prefix_symbol) then
                    if property_name = SCOPE_prop_name then
                      SDP^.scope := determine_scope(property_value)
                    else if property_name = REPLICATION_prop_name then
                      rep_prop_value := property_value
                    else if property_name = NO_ASSERT_prop_name then
                      begin
                        use_NAC := TRUE;
                        add_to_prop_list(SDP^.properties, property_name,
                                                          property_value);
                      end
                    else
                      add_to_prop_list(SDP^.properties, property_name,
                                                        property_value);
                end;
              allow_TM_expansion := FALSE;
              allowed_key_words := signal_keysys;
            end;

        null_specifier: ;

      end { case } ;
      
    process_replication(SDP);

    if SDP^.low_asserted then negated := not negated;  

    if (is_UNNAMED or is_NC) and not bubble_check then
      begin
        SDP^.low_asserted := FALSE;
        SDP^.polarity := NO_POLARITY;
      end;

    if SDP^.polarity = NORMAL then
      if negated then
        SDP^.polarity := COMPLEMENTED
      else
        SDP^.polarity := NORMAL;

    { add unique number to end of UNNAMED signals if low asserted.  The new
      6.0 editor never outputs a low asserted unnamed signal. }

    if is_UNNAMED and SDP^.low_asserted then
      fix_UNNAMED_signal_name;

    { make sure that GED assigned assertions for UNNAMEDs are ignored }

    if SDP^.polarity IN [UNKNOWN_POLARITY, NO_POLARITY] then
      SDP^.low_asserted := FALSE;

    if SDP^.is_const then
      begin
        if SDP^.polarity = COMPLEMENTED then fix_complemented_constant(SDP);

        if not const_bubble_check then SDP^.polarity := NO_POLARITY;
      end;

    if scope <> UNKNOWN_SCOPE then
      begin
        if SDP^.scope <> UNKNOWN_SCOPE then
          begin
            error(165 { this signal cannot have SCOPE property });
            error_dump_current_parse_environment;
            error_dump_signal_descriptor(SDP);
          end;
        SDP^.scope := scope;
      end;

    if found_no_assertion and not (is_NC or is_UNNAMED or SDP^.is_const or
       use_NAC) then
      begin
        error(36 { must have high assertion char });
        error_dump_indent(indent);
        error_dump_alpha('High assert char');
        error_dump_alpha(' = "            ');
        error_dump_char(signal_is_asserted_high_char);
        error_dump_char('"');
        error_dump_CRLF;
      end;
      
    if (SDP^.signal_name <> nullstring) then
      if (SDP^.signal_name^[1] = '(') then
        fix_name_starting_with_paren;

    if sy = concatenation_symbol then insymbol else done := TRUE;
  until done;

  allow_TM_expansion := default_TM_expansion;

  if sy <> ENDOFDATASY then error(179 { unexpected junk });
  pop_parsed_string(signal_name);

  if debug then disp_line('parse_signal_name');
end { parse_signal_name } ;
    

function init_data_services : Cint; external c;

function init_expansion_rules : Cint; external c;

function error_documentation_dsobjname( docfile : xtring) : Cint; external c;
function standard_lib_dsobjname( libfile : xtring) : Cint; external c;
function sig_config_dsobjname( configfile : xtring) : Cint; external c;
function textmacro_dsobjname( tmfile : xtring) : Cint; external c;
function std_prop_dsobjname( propfile : xtring) : Cint; external c;

function init_get_signal_configuration : Cint; external c;
function get_signal_configuration( syntax_code : xtring) : Cint; external c;

function init_get_global_tms : Cint; external c;
function get_tm( tm_name : xtring;
                 tm_def : xtring;
	         kind : xtring) : Cint; external c;


function init_get_property_attributes : Cint; external c;
function get_property_attribute( propname : xtring;
                                 attr : xtring) : Cint; external c;

function init_get_directives : Cint; external c;
function get_directive( dvname : xtring;
                      dvval : xtring) : Cint; external c;
function get_directives_end : Cint; external c;


function report_current_dwg_to_ds( dwgname : xtring) : Cint; 
	                                                     external c;
function report_current_version_to_ds( vers : Cint) : Cint; external c;
function report_current_page_to_ds( pg : Cint) : Cint; external c;


function report_used_tm_to_ds( tmname : xtring; 
				 tmval : xtring;
			 	 kind : 	xtring) :Cint; external c;
function report_used_property_to_ds( prop_name : xtring; 
			    	 kind : xtring) : Cint; external c;
function report_dependency_to_ds( dep_name : xtring) : Cint; 
								external c;

{ functions that add and delete relationships between data services objs }

function add_relationship_thro_dsnames( src : xtring; 
				        sink : xtring;
                                        rel_type : xtring) : Cint; 
								external c;

function del_relationship_thro_dsnames( src : xtring; 
				        sink : xtring;
                                        rel_type : xtring) : Cint; 
								external c;

{ if pointers to data services objects are availiable to the pascal 
   routines, then these ds ptrs can be used to specify releationships }
function add_relationship_thro_dsptrs( src : Cint; 
				       sink : Cint;
				       rel_type : xtring) : Cint; 
								external c;


function del_relationship_thro_dsptrs( src : Cint; 
				       sink : Cint;
				       rel_type : xtring) : Cint; 
								external c;


 procedure add_to_bit_union(source: subscript_ptr; var dest: subscript_ptr);
  { Enters the bits mentioned in the source list into the dest list.
    Produces a subscript list that is in canonical order (ascending
    if left_to_right, descending if not) and which is as merged
    as possible (each representing a disjoint non-contiguous subrange). 
    Dest should be in this condition to start with.  (That assumption
    is checked.)  This is useful for keeping track of a set of
    bits. }
  var
    current_source: subscript_ptr;  { current element of source list }


  function test_canonical_order(subs: subscript_ptr): boolean;
    { Tests subscript list for disjoint elements in
      canonical order.  Returns FALSE if wrong. }
    var
      current: subscript_ptr;   { current element in list }
      first: boolean;           { TRUE iff first element }
      last_right: bit_range;    { previous right_index }
      ok: boolean;              { answer to be returned } 
  begin
    ok := TRUE;  first := TRUE;    current := subs;
    if left_to_right then
      while (current <> NIL) and ok do with current^ do
	begin
	  ok := (left_index <= right_index);
  
	  if first then first := FALSE
	  else if ok then
	    if last_right = MAX_BIT_VALUE then ok := false
	    else ok := (left_index > (last_right + 1));
  
	  last_right := right_index;
	  current := next;
	end
    else
      while (current <> NIL) and ok do with current^ do
	begin
	  ok := (left_index >= right_index);
  
	  if first then first := FALSE
	  else if ok then
	    if last_right = 0 then ok := false
	    else ok := (left_index < (last_right - 1));
  
	  last_right := right_index;
	  current := next;
	end;
    test_canonical_order := ok;
  end { test_canonical_order } ;


  procedure insert_subscript_element(left, right: bit_range;
				     var s: subscript_ptr);

    { inserts a subscript element with indicated indices into
      a list immediately ahead of s^.   S is returned pointing
      to the new element.

      Ex:
	insert_subscript_element(head_of_list);
	  or
	insert_subscript_element(parent_of_insertee^.next); }
  begin
    new_subscript(s);
    s^.left_index := left;
    s^.right_index := right;
  end { insert_subscript_element } ;


  procedure delete_subscript_element(var s: subscript_ptr);

    { deletes s^ from the list, setting s to the former s^.next. 

      Ex:
	delete_subscript_element(head_of_list);
	  or
	delete_subscript_element(parent_of_deletee^.next); }
    var
      old_s: subscript_ptr; { element to be disposed }
  begin
    if s = NIL then assert(112 { a no-no })
    else
      begin
	old_s := s;
	s := s^.next;
	old_s^.next := NIL;
	release_subscript(old_s);
      end;
  end { delete_subscript_element } ;


  procedure merge_into_subscript(left, right: bit_range;
				 var dest: subscript_ptr);
    { Merges a subrange into a subscript which is in canonical 
      order.  Merges elements whenever possible. }
    var
      current: subscript_ptr;   { current element of dest }
      parent: subscript_ptr;    { parent of current }
      found: boolean;           { TRUE when we find an element with
				  left_index to the right of left }
      done: boolean;            { TRUE when we are done merging }
      new_one: subscript_ptr;   { element containing left, right 
				  (may or may not be new) }
  begin
    { find first element with left_index to the right of left }

    current := dest;  parent := NIL;  found := FALSE;
    while (current <> NIL) and not found do 
      if left_to_right then
	if current^.left_index > left then found := TRUE
	else 
	  begin
	    parent := current;
	    current := current^.next;
	  end
      else { not left_to_right }
	if current^.left_index < left then found := TRUE
	else 
	  begin
	    parent := current;
	    current := current^.next;
	  end;

    { insert new element or merge range with parent of 
      found element }

    new_one := NIL;
    if parent = NIL then 
      begin
	insert_subscript_element(left, right, dest);
	new_one := dest;
      end
    else
      begin
	if left_to_right then
	  if parent^.right_index >= (left - 1) then
	    begin
	      if parent^.right_index < right then
		parent^.right_index := right;  
	      new_one := parent;
	    end
	  else { new range is disjoint with its parent }
	    begin
	      insert_subscript_element(left, right, parent^.next);
	      new_one := parent^.next;
	    end
	else { not left_to_right }
	  if parent^.right_index <= (left + 1) then
	    begin
	      if parent^.right_index > right then
		parent^.right_index := right;  
	      new_one := parent;
	    end
	  else { new range is disjoint with its parent }
	    begin
	      insert_subscript_element(left, right, parent^.next);
	      new_one := parent^.next;
	    end
      end;

    { merge to the right as far as possible }

    done := FALSE;
    if new_one <> NIL then
      while (new_one^.next <> NIL) and not done do 
	with new_one^ do
	  if left_to_right then
	    if (next^.left_index - 1) <= right_index then
	      begin
		if next^.right_index > right_index then
		  right_index := next^.right_index;
		delete_subscript_element(next);
	      end
	    else done := TRUE
	  else { not left_to_right }
	    if (next^.left_index + 1) >= right_index then
	      begin
		if next^.right_index < right_index then
		  right_index := next^.right_index;
		delete_subscript_element(next);
	      end
	    else done := TRUE;
  end { merge_into_subscript } ;


begin { add_to_bit_union }
  if debug_36 then
    begin
      write(OutFile,'add_to_bit_union(source=');
      dump_bit_subscript(outfile, source, VECTOR);
      write(OutFile,', dest=');
      dump_bit_subscript(outfile, dest, VECTOR);
      writeln(OutFile, ')');
    end;

  if not test_canonical_order(dest) then
    begin { fix it }
      assert(136 { we don't like it, but we can fix it});
      current_source := NIL;
      add_to_bit_union(dest, current_source);
      dest := current_source;
    end;
  current_source := source;
  while current_source <> NIL do with current_source^ do
    begin
      if left_to_right then 
	if left_index <= right_index then
	    merge_into_subscript(left_index, right_index, dest)
	else
	    merge_into_subscript(right_index, left_index, dest)
      else { right_to_left }
	if left_index >= right_index then
	    merge_into_subscript(left_index, right_index, dest)
	else
	    merge_into_subscript(right_index, left_index, dest);
      current_source := next;
    end;
  if debug_36 then
    begin
      write(outfile,'exit add_to_bit_union dest=');
      dump_bit_subscript(outfile, dest, VECTOR);
      writeln(outfile);
    end;
end { add_to_bit_union } ;


function bit_set_from_descriptor(s: signal_descriptor_ptr): subscript_ptr;
  { return a canonicalized (in order and merged) version of the 
    subscript }
  var
    dest: subscript_ptr;
begin
  dest := NIL;
  while s <> NIL do 
    begin
      add_to_bit_union(s^.bit_subscript, dest);
      s := s^.next;
    end;
  bit_set_from_descriptor := dest;
end { bit_set_from_descriptor } ;


function bit_set_from_subscript(s: subscript_ptr): subscript_ptr;
  { return a canonicalized (in order and merged) version of the 
    subscript }
  var
    dest: subscript_ptr;
begin
  dest := NIL;
  add_to_bit_union(s, dest);
  bit_set_from_subscript := dest;
end { bit_set_from_descriptor } ;


function bit_difference(subtrahend, subtractor: subscript_ptr): subscript_ptr;
  { return the set difference subtrahend - subtractor, given 2 canonical
    bit sets }
  var
    temp,result: subscript_ptr;
    left_bit: bit_range;


  procedure add_subrange(low,high: bit_range);
    { merge the subrange into the result }
  begin
    temp^.left_index := low;   { arbitrarily }
    temp^.right_index := high;
    add_to_bit_union(temp, result);
  end { add_subrange } ;


begin { bit_difference }
  if debug_36 then
    begin
      write(OutFile,'bit_difference(subtrahend=');
      dump_bit_subscript(outfile, subtrahend, VECTOR);
      write(OutFile,', subtractor=');
      dump_bit_subscript(outfile, subtractor, VECTOR);
      writeln(OutFile, ')');
    end;

  result := NIL;  temp := NIL;  new_subscript(temp);
  if left_to_right then
    begin
      if subtrahend <> NIL then left_bit := subtrahend^.left_index;
      while (subtrahend <> NIL) and (subtractor <> NIL) do with subtrahend^ do
	begin
	  if (left_bit < subtractor^.left_index) then
	    add_subrange(left_bit, 
	                 min(subtractor^.left_index - 1, right_index));

          if (right_index < subtractor^.right_index) then
	    begin
	      subtrahend := next;  left_bit := left_index;
	    end
	  else if (subtractor^.right_index < right_index) then
	    begin
	      left_bit := subtractor^.right_index + 1;
	      subtractor := subtractor^.next;
	    end
	  else
	    begin
	      subtrahend := next;  left_bit := left_index;
	      subtractor := subtractor^.next;
	    end;
	end;
    end
  else
    begin
      if subtrahend <> NIL then left_bit := subtrahend^.left_index;
      while (subtrahend <> NIL) and (subtractor <> NIL) do with subtrahend^ do
	begin
	  if (left_bit > subtractor^.left_index) then
	    add_subrange(left_bit, 
	                 max(subtractor^.left_index + 1, right_index));

          if (right_index > subtractor^.right_index) then
	    begin
	      subtrahend := next;  left_bit := left_index;
	    end
	  else if (subtractor^.right_index > right_index) then
	    begin
	      left_bit := subtractor^.right_index - 1;
	      subtractor := subtractor^.next;
	    end
	  else
	    begin
	      subtrahend := next;  left_bit := left_index;
	      subtractor := subtractor^.next;
	    end;
	end;
    end;

  if subtrahend <> NIL then 
    begin
      add_subrange(left_bit, subtrahend^.right_index);
      subtrahend := subtrahend^.next;
      add_to_bit_union(subtrahend, result);
    end;

  release_subscript(temp);

  if debug_36 then
    begin
      write(outfile,'bit_difference returns ');
      dump_bit_subscript(outfile, result, VECTOR);
      writeln(outfile);
    end;
  bit_difference := result;
end { bit_difference } ;


function bit_intersection(set1, set2: subscript_ptr): subscript_ptr;
  var
    diff, result: subscript_ptr;
begin
  if debug_36 then
    begin
      write(OutFile,'bit_intersection(');
      dump_bit_subscript(outfile, set1, VECTOR);
      write(Outfile, ', ');
      dump_bit_subscript(outfile, set2, VECTOR);
      writeln(OutFile, ')');
    end;

  diff := bit_difference(set1, set2);
  result := bit_difference(set1, diff);
  release_entire_subscript(diff);

  if debug_36 then
    begin
      write(outfile,'bit_intersection returns ');
      dump_bit_subscript(outfile, result, VECTOR);
      writeln(outfile);
    end;
  bit_intersection := result;
end { bit_intersection } ;


function primitive_directive_found(drawing: xtring): boolean;
  var
    obj: avl_object_ptr;
begin
{ obj.tag := AVL_STRING;                                         }(*AVL*)
  obj.str := drawing;
  primitive_directive_found := 
    avl_find(obj, force_primitives, AVL_STRING) <> NIL;
end { primitive_directive_found } ;


procedure reverse_file_list(var head: file_list_ptr);
  var
    previous: file_list_ptr;  { former parent of head }
    next: file_list_ptr;      { former child of head }
begin
  previous := NIL;
  while head <> NIL do 
    begin
      next := head^.next;
      head^.next := previous;
      previous := head;
      head := next;
    end;
  head := previous;
end { reverse_file_list } ;


(**)     { ------- Expansion control setup ------- }


procedure read_expansion_rules;
  var
    f: file_list_ptr;
    ok: boolean;
begin
  reverse_file_list(expansion_rules_file);
  ok := TRUE;

  f := expansion_rules_file;
  while f <> NIL do
    begin
      if not er_read(f^.file_name) then ok := FALSE;
      f := f^.next;
    end;
  if not ok then error(255 { a fatal error });
end { read_expansion_rules } ;


(**)     


procedure read_master_libraries;
  var
    f: file_list_ptr;
begin
  f := master_library_file;
  while f <> NIL do
    begin
      f := f^.next;
    end;
end { read_master_libraries } ;


procedure PREDS_read_and_check_configuration_file;
  { if configuration directives found, generate configuration file
    otherwise, read configuration from it.  }
  var
    index: signal_syntax_range;      { index into signal syntax table }
    found: boolean;                  { TRUE when name specifier }
    error_occurred: boolean;         { TRUE if error occurred during parse }


  function determine_symbol(var sym: symbols; var ch: char;
                             var name: name_ptr): boolean;
    { determine the symbol, character, or ID from the input file and return
      them.  If an error occurs, return FALSE. }
    var
      specified_character: xtring;  { character specified for symbol }
      ok: boolean;                  { TRUE if all is ok }
  begin
    ok := FALSE;

    sym := NULLSY;  ch := chr(255);  name := null_name;

    create_a_string(specified_character, 1);

    if sy <> STRINGS then
      begin  error(33 { expected a string });  skip([SEMI]);  end

    else if ord(lex_string^[0]) > 1 then
      begin  error(102 { only 1 char });  skip([SEMI]);  end

    else
      begin
        if ord(lex_string^[0]) = 0 then
          begin  sym := NULLSY;  ch := chr(255);  ok := TRUE;  end
        else
          begin
            specified_character^[1] := lex_string^[1];
            ch := specified_character^[1];

            parse_string(specified_character, PARSE_SEPARATELY);
            sym := sy;
            if sym = IDENT then name := id.name;
            pop_parsed_string(specified_character);

            if sym in forbidden_symbols then error(99 { illegal symbol })
                                        else ok := TRUE;
          end;

        insymbol;    { eat the specification }
      end;

    if not ok then error_occurred := TRUE;

    release_string(specified_character);

    determine_symbol := ok;
  end { determine_symbol } ;


  procedure process_syntax;
    { process the signal syntax specification.  The form is:

            <specifier> <specifier> ...      

      where <specifier> is one of the following:

            <negation>
            <assertion>
            <name>
            <subscript>

      <name> and <subscript> MUST always appear. }
    var
      syntax_index: 0..SYNTAX_TABLE_SIZE;   { index into syntax descriptor }
      new_table: signal_syntax_table_type;  { new syntax table }
      encountered: syntax_specifier_set;    { specifiers found }
      specifier: syntax_specifier_type;     { current specifier }
      no_errors: boolean;                   { TRUE if no errors found }


    function get_specifier: syntax_specifier_type;
      { get the syntax specifier and return }
      var
        i: syntax_specifier_type;    { index into specifier table }
        found: boolean;              { TRUE when specifier found }
    begin
      if sy = LESSTHAN then insymbol else error(10 { expected < });

      i := succ(FIRST_SYNTAX_SPECIFIER);  found := FALSE;
      while (i <= pred(LAST_SYNTAX_SPECIFIER)) and not found do
        if syntax_specifier_names[i] = id.name then found := TRUE
        else i := succ(i);

      if not found then
        begin
          error(67 );
	  error_dump_line('Unknown signal syntax specification         ');
          no_errors := FALSE;
          i := NULL_SPECIFIER;
          error_occurred := TRUE;
        end;

      get_specifier := i;
      insymbol;

      if sy = GREATERTHAN then insymbol else error(11 { expected > });
    end { get_specifier } ;


  begin { process_syntax }
    for syntax_index := 1 to SYNTAX_TABLE_SIZE do
      new_table[syntax_index] := null_specifier;

    { read in all the syntax elements }

    syntax_index := 0;  encountered := [];  no_errors := TRUE;
    repeat
      if syntax_index < SYNTAX_TABLE_SIZE then
        begin
          specifier := get_specifier;

          if specifier IN encountered then
            begin  
	       error(67 );
	       error_dump_line('Signal syntax element found twice           ');
	       no_errors := FALSE;  
	    end
          else
            begin
              encountered := encountered + [specifier];
              syntax_index := succ(syntax_index);
              new_table[syntax_index] := specifier;
            end;
        end;
    until (sy <> LESSTHAN) or (syntax_index >= SYNTAX_TABLE_SIZE);

    { general properties must be at the end of the signal }

    new_table[syntax_index] := PROPERTY_SPECIFIER;
    
    if not (NAME_SPECIFIER IN encountered) then
      begin  
        error(67 );
	error_dump_line('Every syntax MUST have a name portion       ');
	no_errors := FALSE;
      end;

    if not (SUBSCRIPT_SPECIFIER IN encountered) then
      begin
        error(67 );
	error_dump_line('Every syntax MUST have a subscript          ');
	no_errors := FALSE;
      end;

    { check the form for temporary restrictions }

    syntax_index := 1;
    if not (new_table[syntax_index] IN [ASSERTION_SPECIFIER,
                                        NEGATION_SPECIFIER,
                                        NAME_SPECIFIER]) then
      begin  
	error(67 );
	error_dump_line('Illegal form for signal syntax              ');
	no_errors := FALSE;  
      end
    else
      begin
        if new_table[syntax_index] <> NAME_SPECIFIER then
          syntax_index := syntax_index + 1;

        if new_table[syntax_index] <> NAME_SPECIFIER then
          begin  
	    error(67 );
	    error_dump_line('Illegal form for signal syntax              ');
	    no_errors := FALSE;  
	  end;
      end;

    if no_errors then signal_syntax_table := new_table
                 else error_occurred := TRUE;
  end { process_SYNTAX_directive } ;


  procedure process_low_assertion;
    { process the low assertion specification }
    var
      sym: symbols;       { symbol specified }
      ch: char;           { character specified }
      name: name_ptr;     { identifier specified }
  begin
    if determine_symbol(sym, ch, name) then
      begin
        if sym = IDENT then
          begin
            name^.kind := name^.kind + [KEY_WORD];
            name^.sy := LOW_ASSERTED_SY;
            sym := LOW_ASSERTED_SY;
          end;

        signal_is_asserted_low_symbol := sym;
        signal_is_asserted_low_char := ch;
      end;
  end { process_low_assertion } ;


  procedure process_high_assertion;
    { process the high assertion specification }
    var
      sym: symbols;       { symbol specified }
      ch: char;           { character specified }
      name: name_ptr;     { identifier specified }
  begin
    if determine_symbol(sym, ch, name) then
      begin
        if sym = IDENT then
          begin
            name^.kind := name^.kind + [KEY_WORD];
            name^.sy := HIGH_ASSERTED_SY;
            sym := HIGH_ASSERTED_SY;
          end;

        signal_is_asserted_high_symbol := sym;
        signal_is_asserted_high_char := ch;
      end;
  end { process_high_assertion } ;


  procedure process_negation;
    { process the negation specification }
    var
      sym: symbols;       { symbol specified }
      ch: char;           { character specified }
      name: name_ptr;     { identifier specified }
  begin
    if determine_symbol(sym, ch, name) then
      begin
        if sym = IDENT then
          begin
            name^.kind := name^.kind + [KEY_WORD];
            name^.sy := NEGATION_SY;
            sym := NEGATION_SY;
          end;

        signal_negation_symbol := sym;
        signal_negation_char := ch;
      end;
  end { process_negation } ;


  procedure process_name_prefix;
    { process the name prefix specification }
    var
      sym: symbols;       { symbol specified }
      ch: char;           { character specified }
      name: name_ptr;     { identifier specified }
  begin
    if determine_symbol(sym, ch, name) then
      begin
        if sym IN expression_symbols + [IDENT] then
          begin  error(99 { illegal symbol });  error_occurred := TRUE;  end
        else
          begin
            name_property_prefix_symbol := sym;
            name_property_prefix_char := ch;
          end;
      end;
  end { process_name_prefix } ;


  procedure process_general_prefix;
    { process the general prefix specification }
    var
      sym: symbols;       { symbol specified }
      ch: char;           { character specified }
      name: name_ptr;     { identifier specified }
  begin
    if determine_symbol(sym, ch, name) then
      begin
        if sym IN expression_symbols + [IDENT] then
          begin  error(99 { illegal symbol });  error_occurred := TRUE;  end
        else
          begin
            general_property_prefix_symbol := sym;
            general_property_prefix_char := ch;
          end;
      end;
  end { process_general_prefix } ;


  procedure process_bit_ordering;
    { process the bit ordering configuration specification }
  begin
    if sy <> IDENT then
      begin
        error(1 { expected IDENT });
        skip([SEMI]);
        error_occurred := TRUE;
        end
    else
      begin    
        if id.name = L_to_R_specifier then left_to_right := TRUE
        else if id.name = R_to_L_specifier then left_to_right := FALSE
        else
          begin  error(52 { invalid });  error_occurred := TRUE;  end;

        insymbol;    { eat the specification }
      end;
  end { process_bit_ordering } ;


  procedure process_subrange;
    { process the subrange configuration specification }
    var
      specifier: xtring;          { character(s) specified }
      sym: symbols;               { symbol specified }
  begin
    specifier := nullstring;
    if sy <> STRINGS then
      begin
        error(33 { expected a string });
        skip([SEMI]);
        error_occurred := TRUE;
      end
    else
      begin
        specifier := lex_string;

        parse_string(specifier, PARSE_SEPARATELY);
        sym := sy;
        pop_parsed_string(specifier);

        if sym = DOTDOTSY then
          begin
            subrangesy := DOTDOTSY;
            fieldsy := COLON;
            insymbol;    { eat the .. }
          end
        else if sym = COLON then
          begin
            subrangesy := COLON;
            fieldsy := COLONCOLONSY;
            insymbol;    { eat the : }
          end
        else
          begin
            error(67 { not permitted });
 	    error_dump_line('Subrange symbol must be .. or :             ');
            skip([SEMI]);
            error_occurred := TRUE;
          end;
      end;
  end { process_subrange } ;

    
  procedure parse_configuration_specification;
    { parse the signal syntax configuration file }
    var
      config_spec: configure_types;    { index into table of configure types }
      found: boolean;                  { TRUE if configuration found }
      specifier: name_ptr;             { configuration specifier from file }
  begin
    while sy = IDENT do
      begin
        specifier := id.name;

        config_spec := succ(FIRST_CONFIGURE_SPECIFIER);  found := FALSE;
        while (config_spec < LAST_CONFIGURE_SPECIFIER) and not found do
          if configure_specifiers[config_spec] = specifier then found := TRUE
          else config_spec := succ(config_spec);

        if not found then
          if (specifier^.name = 'SIGNAL_SYNTAX   ') or
             (specifier^.name = 'SYNTAX          ') then
            begin
              insymbol;     { eat the configuration name }
              if sy = EQUAL then insymbol;
              process_syntax;
            end
          else
            begin
              error(69 { unknown signal syntax specification });
              skip([SEMI]);
              error_occurred := TRUE;
            end
        else
          begin
            insymbol;    { eat the configuration name }
            if sy = EQUAL then insymbol;

            case config_spec of
              CONFIGURE_SUBRANGE:
                  process_subrange;

              CONFIGURE_BIT_ORDERING:
                  process_bit_ordering;

              CONFIGURE_LOW_ASSERTED:
                  process_low_assertion;

              CONFIGURE_HIGH_ASSERTED:
                  process_high_assertion;

              CONFIGURE_NEGATION:
                  process_negation;

              CONFIGURE_NAME_PREFIX:
                  process_name_prefix;

              CONFIGURE_GENERAL_PREFIX:
                  process_general_prefix;

              CONFIGURE_CONCATENATION:
                  skip([SEMI]);
            end { case } ;
          end;

        if sy = SEMI then insymbol else error(12 { expected ; });
      end;
  end { parse_configuration_specification } ;


begin { PREDS_read_and_check_configuration_file }
  allowed_key_words := directory_keysys;

  if not open_a_file(configuration_file, STANDARD_FILE) then
    begin
      error(207 { cannot open the configuration file });
      error_dump_file_name(configuration_file);
    end

  else
    begin
      if get_file_type <> CONFIGURATION_SPEC then
        begin
          error(67 { problem with syntax spec });
	  error_dump_line('Illegal file type for configuration file    ');
          error_dump_file_name(configuration_file);
          error_occurred := TRUE;
        end
      else
        begin
          error_occurred := FALSE;

          parse_configuration_specification;

          if sy = ENDSY then insymbol else error(40 { expected END });
          if sy <> PERIOD then error(37 { expected . });
        end;


      if error_occurred then
        begin
          error(157 { error occurred in this file });
          error_dump_file_name(configuration_file);
        end;

      if not close_parse_file(STANDARD_FILE) then
        begin
          error(168 { cannot close the file });
          error_dump_file_name(configuration_file);
        end;
    end;
  allowed_key_words := [];

  { set up sets of special characters }

  found := FALSE;  
  is_signal_name_terminator[general_property_prefix_char] := TRUE;
  is_signal_name_terminator[concatenation_char          ] := TRUE;
  is_signal_name_terminator[chr(EOL)                    ] := TRUE;

  for index := 1 to SYNTAX_TABLE_SIZE do
    if not found then
      if signal_syntax_table[index] = name_specifier then
        found := TRUE
      else
    else
      case signal_syntax_table[index] of
        NEGATION_SPECIFIER:
            is_signal_name_terminator[signal_negation_char] := TRUE;

        SUBSCRIPT_SPECIFIER:
            is_signal_name_terminator['<'] := TRUE;

        ASSERTION_SPECIFIER:
            begin
              is_signal_name_terminator[signal_is_asserted_low_char] := TRUE;
              is_signal_name_terminator[signal_is_asserted_high_char] := TRUE;
            end;

        PROPERTY_SPECIFIER,
        NULL_SPECIFIER: ;
      end;
end { PREDS_read_and_check_configuration_file } ;


(**)     { ------- read in the compiler directives ------- }


procedure PREDS_read_compiler_directives_file;
  { read in the file containing compiler directives and root macro
    name specification. }
  var
    directive: directive_type;          { directive being parsed }
    temp: integer;                      { temp for expression values }
    nil_ptr: file_list_ptr;             { NIL to implement evacuate }
    found_debug_directive: boolean;     { TRUE if debugging on }
    directives_encountered: 
                        directive_set;  { all directives encountered }
    dummy_boolean: boolean;             { For on/off directives not used
                                          by compiler (linker only) }
    old_umask: integer;                 { For return from umask call }


  function find_directive(name: name_ptr; var directive: directive_type):
                                                                    boolean;
    { search the directive table for the specified name and return its
      directive type if found. }
    var
      search: directive_type;       { directive search index }
      found: boolean;               { TRUE when directive found }
  begin
    search := succ(FIRST_DIRECTIVE);  found := FALSE;
    while (search < LAST_DIRECTIVE) and not found do
      if name = compiler_directive[search] then found := TRUE
      else search := succ(search);

    if (search IN debug_directives) and not found_debug_password then
      begin  found := FALSE;  search := LAST_DIRECTIVE;  end;

    find_directive := found;  directive := search;
  end { find_directive } ;


  function ON_or_OFF(specifier: name_ptr; default: boolean): boolean;
    { if specifier = 'ON' then return TRUE else if specifier = 'OFF' then
      return FALSE, else return the default. }
  begin
    if specifier = ON_specifier then ON_or_OFF := TRUE
    else if specifier = OFF_specifier then ON_or_OFF := FALSE
    else
      begin  error(52 { invalid specifier });  ON_or_OFF := default;  end;
  end { ON_or_OFF } ;


  function local_or_global(specifier: name_ptr; default: boolean): boolean;
    { if specifier = 'LOCAL' then return TRUE else if specifier = 'GLOBAL'
      then return FALSE, else return the default. }
  begin
    if specifier = LOCAL_specifier then local_or_global := TRUE
    else if specifier = GLOBAL_specifier then local_or_global := FALSE
    else
      begin  error(52 { invalid });  local_or_global := default;  end;
  end { local_or_global } ;


  procedure process_PICK_directive;
    label 
      90; { return }
    var
      comptype: name_ptr;
      extension: name_ptr;
      attribute: name_ptr;
      dwgname: xtring;


    procedure add_exception(comptype, ext, att: name_ptr);
      var
        t: selection_exception_ptr;
    begin
      new(t);
      with t^ do
        begin
	  compile_type := comptype;
	  extension := ext;
	  attribute := att;
	  drawings := NIL;
	  next := selection_exceptions;
	  selection_exceptions := t;
	end;
    end;


  procedure add_drawing(dname, context: xtring);
    var
      t: drawing_list_ptr;
  begin
    new(t);
    t^.drawing := dname;
    t^.context := context;
    t^.next := selection_exceptions^.drawings;
    selection_exceptions^.drawings := t;
  end;
  

  begin { process_pick_directive }
    if sy <> LPAREN then
      begin
	error(15 { expected LPAREN });  
	skip([SEMI]);
	goto 90 { return };
      end;
    insymbol;
    if sy <> IDENT then
      begin
	error(1 { expected id });  
	skip([SEMI]);
	goto 90 { return };
      end;
    comptype := id.name; 
    if (comptype = PRIM_extension_name) then 
      begin
        error(66);  
	error_dump_indent(indent);
	error_dump_alpha('LOGIC assumed   ');
	error_dump_CRLF;
	comptype := LOGIC_compile_type;
      end
    else if (comptype = PART_extension_name) then 
      begin
        error(216);  { Already states that LOGIC is assumed }
	comptype := LOGIC_compile_type;
      end;
    insymbol;

    if sy <> RPAREN then
      begin
	error(7 { expected RPAREN });  
	skip([SEMI]);
	goto 90 { return };
      end;
    insymbol;

    if sy <> IDENT then
      begin
	error(1 { expected id });  
	skip([SEMI]);
	goto 90 { return };
      end;
    extension := id.name;  
    if extension = PART_extension_name then extension := PRIM_extension_name;
    insymbol;

    if sy <> LPAREN then 
      begin
	attribute := null_name;
	if extension = PRIM_extension_name then
	  error(26 { need directory type }); { attribute will be fixed later }
      end
    else
      begin
	insymbol;
	if sy <> IDENT then
	  begin
	    error(1 { expected id });  
	    skip([SEMI]);
	    goto 90 { return };
	  end;
	attribute := id.name;
	if attribute = PART_extension_name then
	  attribute := PRIM_extension_name;
	if extension = PRIM_extension_name then
	  begin
	    if attribute = PRIM_extension_name then
	      begin
	        error(28 { not legal SCALD dir type });
		attribute := null_name;  { fix it later }
              end;
	  end
        else
	  begin
	    if (attribute <> SPECIAL_specifier) and 
	       (attribute <> PRIMITIVE_specifier) then 
              begin
		error(27 { expected SPECIAL or PRIMITIVE });
		attribute := null_name;
	      end;
	  end;
	insymbol;

	if sy <> RPAREN then
	  begin
	    error(7 { expected RPAREN });  
	    skip([SEMI]);
	    goto 90 { return };
	  end;
	insymbol;
      end;

    add_exception(comptype, extension, attribute);

    repeat
      if sy <> STRINGS then
	begin
	  error(33 { expected a string });  
	  skip([SEMI]);
	  goto 90 { return };
	end;
      dwgname := lex_string;
      insymbol;
      if sy = MINUS then
	begin
	  insymbol;
	  if sy <> STRINGS then
	    begin
	      error(33 { expected a string });  
	      skip([SEMI]);
	      goto 90 { return };
	    end;
	  add_drawing(dwgname, lex_string);
	  insymbol;
	end
      else add_drawing(dwgname, NIL);
      if sy = COMMA then insymbol
      else if sy <> SEMI then goto 90 { return -- error handled elsewhere };
    until sy = SEMI;
  90:
  end { process_PICK_directive } ;


  procedure process_pick_list;
    var
      t: selection_exception_ptr;
      dwg: drawing_list_ptr;


    procedure reverse(var head: selection_exception_ptr);
      var
	previous: selection_exception_ptr;  { former parent of head }
	next: selection_exception_ptr;      { former child of head }
    begin
      previous := NIL;
      while head <> NIL do 
	begin
	  next := head^.next;
	  head^.next := previous;
	  previous := head;
	  head := next;
	end;
      head := previous;
    end { reverse } ;


  begin { process_pick_list }
    reverse(selection_exceptions);
    t := selection_exceptions;
    while t <> NIL do with t^ do
      begin
        if (extension = PRIM_extension_name) and (attribute = NULL_name) then
	  attribute := specified_compile_type;
        dwg := drawings;
	while dwg <> NIL do
	  begin
	    er_except(compile_type^.name, dwg^.drawing, dwg^.context,
	              extension^.name, attribute^.name);
	    dwg := dwg^.next;
	  end;
        t := next;
      end;
  end { process_pick_list } ;


  procedure process_OUTPUT_file_list;
    { process the output file list and set the control flags }
    var
      file_name: output_file_names;      { name of output file to create }
      done: boolean;                     { if all output controls read }
      found: boolean;                    { TRUE if file name found }
  begin 
    if not (OUTPUT_DIRECTIVE in directives_encountered) then
      files_to_generate := [];

    done := FALSE;
    while not done and (sy <> SEMI) do
      begin
        if sy <> IDENT then
          begin  error(1 { expected ident });  skip([SEMI,COMMA,IDENT]);  end
        else
          begin
            file_name := succ(first_file_name);  found := FALSE;
	    if id.name <> null_name then
	      while (file_name < last_file_name) and not found do
		if output_file[file_name] = id.name then found := TRUE
		else file_name := succ(file_name);

            if found then
	      begin
	        if (file_name in SCALD_only_output_files) then
		  error(3 { SCALD compiler only });
	      end
            else
              begin
                error(97 { unknown output file name });
                file_name := first_file_name;
              end;

            files_to_generate := files_to_generate + [file_name];
            insymbol;
          end;
        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_OUTPUT_file_list } ;


  procedure process_shareable_directive;
    { process the directive and set the umask accordingly. Note that
      SHAREABLE DEFAULT; means to do nothing to the umask. }
    var
       oldumask: integer;
       val: shareable_value;
  begin
    if sy <> IDENT then error(1 { Expected identifier })
    else
      begin
        val := succ(FIRST_SHAREABLE_VALUE);
        while (val < LAST_SHAREABLE_VALUE) and 
              (shareable.values[val] <> id.name) do val := succ(val);
        if val = LAST_SHAREABLE_VALUE then
	  error(17 { unknown SHAREABLE spec })
        else 
          if val <> DEFAULT_SHARING then
	    oldumask := umask(shareable.umasks[val]);
	specified_shareable_value := val;
	insymbol;
      end;
  end { process_shareable_directive } ;


  function add_name_to_library_list(lib_name, add_name: xtring): boolean;
    { check the given name against the current list of libraries.
      If it exists, return FALSE.  If it doesn't exist, add it to the
      list and return TRUE. }
    var
      already_exists: boolean;         { TRUE if file already in the list }
      element,                         { current directory entry }
      last: directory_list_ptr;        { last library visited in the list }
  begin { add_name_to_library_list }
    element := library_list_root;  last := NIL;
    already_exists := FALSE;
    while (element <> NIL) and not already_exists do
      if element^.name = lib_name then 
	already_exists := TRUE
      else
        begin  last := element;  element := element^.next;  end;
    if not already_exists then
      begin
        new_directory_list(element);
        element^.name := lib_name;
        element^.add := add_name;
        if last=NIL then library_list_root := element
                    else last^.next:=element;
      end;
    add_name_to_library_list := not already_exists;
  end { add_name_to_library_list } ;


  procedure process_DIRECTORY_directive;
    { process the scald directory and its shadow directory The procedure
      reads the directories specified in the directory directive and 
      supplies the add package with the scald directory and its associated
      shadow directory. Each scald directory can be associated with only
      one shadow directory. Any additional add directory is ignored. The
      error handling in this code is very gentle. It only reminds the user
      of any error in the lexical manipulation and tries to recover 
      gracefully from the error condition without much ado. Any errors in
      the specification is dealt by the add package }
    var
      done: boolean;              { TRUE if all directory names read }
      scaldir: xtring;            { scald directory }
      add : xtring;             { add directory }
      dir: directory_list_ptr;    { current directory in list }
      last: directory_list_ptr;   { last directory in list }
      found: boolean;             { TRUE if found in list }

  begin { process_DIRECTORY_directive }
    done := FALSE;
    repeat
      scaldir := NIL;
      add := NIL;
      if sy = STRINGS then
        begin
          scaldir := lex_string;
          insymbol;
        end
      else 
        begin
	  error(93 { expected file name });
          skip([SEMI,COMMA]);
        end;

      if ((sy = MINUS) and (scaldir <> NIL) and not done) then
        begin
          insymbol;
          if sy = STRINGS then
            begin
              add := lex_string;
              insymbol;
            end
          else
            begin
	      error(91 { expected shadow directory name });
              skip([SEMI,COMMA]);
            end;
        end;
      
      if sy <> COMMA then done := TRUE
      else insymbol;

      if scaldir <> NIL then
        begin
	  found := FALSE;
	  dir := directory_list_root;  last := NIL;
	  while (dir <> NIL)  and not found do
	    begin
	      if (dir^.name = scaldir) then
		begin
		  found := TRUE;
                  error(87 { file already exists });
		end
	      else
	        begin
		  last := dir;
		  dir := dir^.next;
		end;
            end;
	  if not found then 
	    begin
	      new_directory_list(dir);
	      if last = NIL then directory_list_root := dir
	      else last^.next := dir;
	      dir^.name := scaldir;
	      dir^.add := add;
            end;
        end;
    until done;
  end { process_DIRECTORY_directive } ;
          

  procedure process_DIRECTORY_list;
    { process the list of directories -- inform the A.D.D. package about
      each and report errors }
    var
      element: directory_list_ptr;      { current directory name }
      add_name: xtring;                  { name of add directory }
  begin
    element := directory_list_root;
    while element <> NIL do
      begin
        add_name := element^.add;
	if add_name = nullstring then add_name := NIL;
        element := element^.next;
      end;
  end  { process_DIRECTORY_list };
      

  procedure process_LIBRARY_list;
    { process the LIBRARY directive.  For each library identifier, check
      the master library description and, if found, add the corresponding
      SCALD directory file name to the directory list. }
    var
      element: directory_list_ptr;       { current library name }
      lib_name,                          { name of library }
      add_name: xtring;                  { name of add directory }
  begin
    element := library_list_root;
    while element <> NIL do
      begin
        lib_name := element^.name;
	if lib_name = nullstring then lib_name := NIL; { add package kink }
        add_name := element^.add;
	if add_name = nullstring then add_name := NIL; { add package kink }
        element := element^.next;
      end;
  end  { process_LIBRARY_list };
      

  procedure process_LIBRARY_directive;
    { add each library name to the list of libraries }
    var
      done: boolean;                    { TRUE when done with directive }
      library_name: xtring;             { name of library being specified }
      add: xtring;                    { specified ADD }
  begin
    done := FALSE;
    repeat
      library_name := NIL;
      add := NIL;

      if sy = IDENT then
        begin
          library_name := make_and_enter_string(id.name^.name);
          insymbol; { eat the identifier }
        end
      else if sy = STRINGS then
        begin
          library_name := lex_string;
          insymbol; { eat the the string }
        end
      else
        begin
          error(4 { expected a string or identifier });  
          skip([SEMI,COMMA,STRINGS,IDENT]);
        end;


      if ((sy = MINUS) and (library_name <> NIL)) then 
               { check if there is any shadow directory }
        begin
	  upper_case_strings := FALSE;
          insymbol; { eat the '-' and get ADD name -- don't upshift it }
	  upper_case_strings := TRUE;
          if sy = STRINGS then
            begin
              add := lex_string;
              insymbol; { eat the shadow string }
            end
          else
            error(93 { expected add_dir });
        end;

      if library_name <> NIL then
        begin
          if not add_name_to_library_list(library_name, add) then 
	    error(68 { lib already there });
	end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_LIBRARY_directive } ;


  procedure get_file_name_list(var list: file_list_ptr);
    { read a list of files from the input.  Check to see if the file has
      already been specified.  If not, add it to the list.  Otherwise,
      generate an error. }
    var
      done: boolean;                { TRUE when done with directive }
      file_name: xtring;            { name of file being specified }
      current_file: file_list_ptr;  { current file in the list }
      found: boolean;               { TRUE if entry found in library }
  begin    
    done := FALSE;
    repeat
      if sy <> STRINGS then
        begin
          error(33 { expected a string });  skip([SEMI,COMMA,STRINGS]);
        end
      else
        begin
          file_name := lex_string;
          current_file := list;  found := FALSE;
          while (current_file <> NIL) and not found do
            if current_file^.file_name = file_name then found := TRUE
            else current_file := current_file^.next;

          if found then
            error(38 { file was already specified })
          else
            begin
              new_file_list(list);
              list^.file_name := file_name;
            end;

          insymbol;     { eat the file name }
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { get_file_name_list } ;


  procedure process_debug_controls;
    { process the debug control specifiers }
    var
      control: debug_controls;       { control specified }
      done: boolean;                 { TRUE when all debug controls found }
      found: boolean;                { TRUE when control name found in table }


    procedure process_histograms;
      { process the histogram specifiers }
      var
        hist: histogram_types;       { histogram to be printed }
        done: boolean;               { TRUE if all histograms have been read }
        found: boolean;              { TRUE if specifier found }
    begin
      insymbol;   { eat the PRINTHISTOGRAMS }
      if sy = LPAREN then insymbol else error(15 { expected ( });

      done := FALSE;
      repeat
        if sy <> IDENT then
          begin  error(1 { expected ident });  skip([SEMI,COMMA]);  end
        else
          begin
            hist := succ(FIRST_HISTOGRAM);  found := FALSE;
            while (hist < LAST_HISTOGRAM) and not found do
              if histogram_specifiers[hist] = id.name then found := TRUE
              else hist := succ(hist);

            if found then histograms := histograms + [hist]
            else error(42 { unknown histogram });
          end;

        insymbol;
        if sy = COMMA then insymbol else done := TRUE;
      until done;

      if sy <> RPAREN then error(7 { expected ) });
    end { process_histograms } ;


  begin { process_debug_controls }
    done := FALSE;
    while (sy = IDENT) and not done do
      begin
        control := succ(FIRST_CONTROL);  found := FALSE;
        while (control < LAST_CONTROL) and not found do
          if debug_control_specifier[control] = id.name then found := TRUE
          else control := succ(control);

        case control of
          CONTROL_DUMPTREE:          dumptree_ok := TRUE;
          CONTROL_DUMPSIGNALS:       dumpsignals_ok := TRUE;
          CONTROL_PRINTMACROS:       printmacros_ok := TRUE;
          CONTROL_PRINTDIRECTORY:    printdirectory_ok := TRUE;
          CONTROL_PRINTHISTOGRAMS:   process_histograms;
          CONTROL_DUMPSIGDEFLIST:    dumpsigdeflist_ok := TRUE;
          CONTROL_DUMP_ALL_NAMES:    dump_all_names_ok := TRUE;
          CONTROL_ERULE_XFACE:       
	    begin  
	      er_debug;  trace_erule_xface := TRUE;
	    end;
          LAST_CONTROL,
          FIRST_CONTROL:             error(42 { unknown debug control });
        end;

        insymbol;

        if sy = COMMA then insymbol else done := TRUE;
      end;

    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;
  end { process_debug_controls } ;


  procedure process_debug;
    { process the DEBUG directive }
    var
      debug_number: natural_number;     { debug flag number }
      done: boolean;                    { TRUE when all debug COMMAnds read }
  begin
    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;

    done := FALSE;
    repeat
      if sy = IDENT then
        begin  debug := ON_or_OFF(id.name, debug);  insymbol;  end
      else if sy = CONSTANT then
        begin
          debug_number := const_val;  insymbol;
          case debug_number of
            1:   debug_1 := TRUE;
            2:   debug_2 := TRUE;
            3:   debug_3 := TRUE;
            4:   debug_4 := TRUE;
            5:   debug_5 := TRUE;
            6:   debug_6 := TRUE;
            7:   debug_7 := TRUE;
            8:   debug_8 := TRUE;
            9:   debug_9 := TRUE;
            10:  debug_10 := TRUE;
            11:  debug_11 := TRUE;
            12:  debug_12 := TRUE;
            13:  debug_13 := TRUE;
            14:  debug_14 := TRUE;
            15:  debug_15 := TRUE;
            16:  debug_16 := TRUE;
            17:  debug_17 := TRUE;
            18:  debug_18 := TRUE;
            19:  debug_19 := TRUE;
            20:  debug_20 := TRUE;
            21:  debug_21 := TRUE;
            22:  debug_22 := TRUE;
            23:  debug_23 := TRUE;
            24:  debug_24 := TRUE;
            25:  debug_25 := TRUE;
            26:  debug_26 := TRUE;
            27:  debug_27 := TRUE;
            28:  debug_28 := TRUE;
            29:  debug_29 := TRUE;
            30:  debug_30 := TRUE;
            31:  debug_31 := TRUE;
            32:  debug_32 := TRUE;
            33:  debug_33 := TRUE;
            34:  debug_34 := TRUE;
            35:  debug_35 := TRUE;
            36:  debug_36 := TRUE;
            37:  debug_37 := TRUE;
            38:  debug_38 := TRUE;
            39:  debug_39 := TRUE;
            40:  debug_40 := TRUE;
          end;
        end 
      else
        begin
          error(1 { expected ident });  skip([SEMI, IDENT]);
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_debug } ;


  procedure process_path_debug;
    { process the DEBUG_AT_PATH directive }
    var
      done: boolean;               { TRUE when command completed }
  begin
    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;

    if sy <> STRINGS then
      begin  error(33 { expected a string });  skip([SEMI]);  end
    else
      begin
        path_for_debug := lex_string;  insymbol;
        done := FALSE;
        repeat
          if sy <> CONSTANT then
            begin
              error(52 { invalid });  skip([SEMI,IDENT]);
            end
          else
            if (const_val < 0) or (const_val > MAX_DEBUG_FLAG_NUMBER) then
              begin
                error(52 { not correct });  skip([SEMI,IDENT]);
              end
            else
              begin
                debug_flags := debug_flags + [const_val];
                insymbol;
                debug_at_path := TRUE;
              end;

          if sy = COMMA then insymbol else done := TRUE;
        until done;
      end;
  end { process_path_debug } ;


  procedure process_SUPPRESS_directive;
    { process the SUPPRESS directive }
    var
      done: boolean;            { TRUE when all numbers read in }
  begin
    done := FALSE;
    while ((sy = CONSTANT) or (sy = IDENT)) and not done do
      begin
        if sy = IDENT then
          if id.name = ALL_identifier then
            begin
              suppress_errors := warning_errors + oversight_errors;
              insymbol;
            end
          else
            begin
              error(52 { unexpected specification });
              skip([COMMA,SEMI,CONSTANT,IDENT]);
            end
        else
          if not (const_val IN warning_errors+oversight_errors) then
            begin
              error(92 { invalid number });  skip([SEMI,COMMA]);
            end
          else
            begin
              suppress_errors := suppress_errors + [const_val];  insymbol;
            end;

        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_SUPPRESS_directive } ;


  procedure process_COMPILE_directive(compile_type: name_ptr);
    { process the COMPILE directive and set up the extension for compile }
  begin
    if not TYPE_specified_in_command_line then
      begin
        if (compile_type = PART_extension_name) then
          begin
            error(216 { PART not allowed; LOGIC assumed });
            compile_type := LOGIC_compile_type;
          end;

        if (compile_type = PRIM_extension_name) then
	  error(66 { not allowed });
	specified_compile_type := compile_type;
      end;
  end { process_COMPILE_directive } ;


  procedure process_PRIMITIVE_directive;
    { process the primitive directive - create list of macro names.  If
      the given macro name has a path name in front of it, just save
      the path and make only that instance of the macro a primitive. }
    var
      done: boolean;          { TRUE when all macro names have been read }
      obj: avl_object_ptr;
  begin
{   obj.tag := AVL_STRING;                                         }(*AVL*)
    done := FALSE;
    repeat
      if sy <> STRINGS then
        begin  error(33 { expected string });  skip([SEMI,COMMA]);  end
      else
        begin
          if lex_string^[1] = '(' then 
            begin
              error(3 { SCALD compiler only });
	      error_dump_indent(indent);
	      error_dump_alpha(' ValidCOMPILER d');
	      error_dump_alpha('oes not support ');
	      error_dump_alpha(' path names on t');
	      error_dump_alpha('the PRIMITIVE di');
	      error_dump_alpha('rective         ');
	      error_dump_CRLF;
            end
          else
	    begin
	      obj.str := lex_string;
	      if (avl_insert(obj, force_primitives, AVL_STRING) <> NIL) then ;
            end;

          insymbol;
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_PRIMITIVE_directive } ;


  procedure process_PASSWORD_directive;
    { process the SECRET SCALD PASSWORDS!!!!! }
  begin
    if sy = EQUAL then insymbol;     { allow space or equal }
    if sy <> IDENT then error(1 { expected ident })
    else
      if id.name^.name = CONFIGURE_PASSWORD then
        { do nothing }
      else if id.name^.name = DEBUG_PASSWORD then
        found_debug_password := TRUE;

    insymbol;    { eat the symbol }
  end { process_PASSWORD_directive } ;


  procedure process_filters;
    { parse but ignore this PASS_PROPERTY or FILTER_PROPERTY directive. }
    var
      done: boolean;         { TRUE when done processing input list }
  begin
    done := FALSE;
    while (sy = IDENT) and not done do
      begin
        insymbol;     { eat the identifier }
        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_filters } ;


  procedure process_report_directive;
    { process the REPORT directive }
    var
      report: report_types;    { current report from the table }
      found: boolean;          { TRUE if report id found in the table }
      add_to_list: boolean;    { TRUE if report to be added to the list }
  begin
    while (sy = IDENT) or (sy = minus) do
      begin
        if sy = minus then
          begin  add_to_list := FALSE;  insymbol;  end
        else
          add_to_list := TRUE;

        report := succ(FIRST_REPORT_TYPE);  found := FALSE;
        while (report < LAST_REPORT_TYPE) and not found do
          if report_type_table[report] = id.name then found := TRUE
          else report := succ(report);

        if not found then
          if id.name <> ALL_identifier then
            error(31 { unknown report specification })
          else
            if add_to_list then
	      begin
                reports_to_generate := 
                           [succ(FIRST_REPORT_TYPE)..pred(LAST_REPORT_TYPE)];
              end
            else
              reports_to_generate := []
        else
          if add_to_list then
            if (report in SCALD_only_reports) then error(3 { can't do it })
            else reports_to_generate := reports_to_generate + [report]
          else
            reports_to_generate := reports_to_generate - [report];

        insymbol;    { eat the report name }

        if sy = COMMA then insymbol;
      end;
  end { process_report_directive } ;


  procedure process_COMMAND_directive(val: name_ptr);
    { process the COMMAND directive for the given value }
    var
      i: command_type;  { current command value  for search }
      found: boolean;   { TRUE when command value is found }
  begin
    if not COMMAND_specified_in_command_line then
      begin
        for i := succ(FIRST_COMMAND) to pred(LAST_COMMAND) do
          if val = command_value[i] then 
            begin
              found := TRUE;
              command := i;
            end;
        if not found then error(229 { illegal command value});
        if command = SEPLINK_COMMAND then
          if ROOT_specified_in_command_line or 
            TYPE_specified_in_command_line  then
            begin
              error(228 { incorrect usage of seplink command });
            end;
      end;
  end { process_COMMAND_directive } ;


  procedure process_command_line_arguments;
    { get parameters from a command line.  The line can contain:
      
      SEPCOMP root_drawing compile_type context_name
                  or
      SEPLINK compile_type cmpdraw_file_descriptor design_file_descriptor
                  or
      COMPERR [-w] root_drawing compile_type
              [-a]
	      [-o]
	      [-e]
       
      NOTE: if the file descriptors for the SEPLINK command are
      to be specified in the command line, then the SEPLINK
      command MUST also be specified in the command line. }
    var
      arg: xtring;                 { current argument from command line }
      temp_string: xtring;         { string for conversion to internal }
      len,                         { length of the string parameter }
      i: string_range;             { index into the strings }
      temp_alpha: alpha;           { temp storage for the compile type }
      last_legitimate_arg: 3..5;   { last argument with meaning }


    procedure process_command_arg;
      { process the current arg as COMMAND directive }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMMAND_directive(enter_name(temp_alpha));
          COMMAND_specified_in_command_line := TRUE;
        end;
    end { process_command_arg } ;


    function process_design_descriptor: boolean;
      { process the current arg as  file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          Design_fd := string_to_natural_number(arg);
          process_design_descriptor := TRUE;
        end
      else process_design_descriptor := FALSE;
    end { process_design_descriptor } ;


    function process_cmpdraw_descriptor: boolean;
      { process the current arg as cmpdraw's file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          CmpDraw_fd := string_to_natural_number(arg);
          process_cmpdraw_descriptor := TRUE;
        end
      else process_cmpdraw_descriptor := FALSE;
    end { process_cmpdraw_descriptor } ;


    procedure process_compile_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMPILE_directive(enter_name(temp_alpha));
          TYPE_specified_in_command_line := TRUE;
        end;
    end { process_compile_arg } ;


    procedure process_root_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          root_macro_name := enter_and_release_string(temp_string);
          ROOT_specified_in_command_line := TRUE;
        end;
    end { process_root_arg } ;


    procedure process_context_arg;
      { process the current arg as context name }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          CONTEXT_specified_in_command_line := TRUE;
	  { this is an obsolete concept }
        {  context_being_compiled := enter_and_release_string(temp_string); }
        end;
    end { process_context_arg } ;


  begin { process_command_line_arguments }
    { number of arguments includes the program name }

    if sargc >= 2 then   { there is a COMMAND parameter }
      begin
        sargv(1, arg);
        process_command_arg;
      end;

    if command = SEPLINK_COMMAND then
      begin
        if sargc >= 3 then   { KLUDGE "link" type spec }
          begin
            sargv(2, arg);
            process_compile_arg;
          end;
        if sargc >= 4 then   { there is an open CMDRAW file from linker }
          begin
            sargv(3, arg);
            if not process_cmpdraw_descriptor then
	      begin
	        error(166 { can't access CMPDRAW file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    cmpdraw_specified_in_command_line := TRUE;
          end;
        if sargc >= 5 then   { there is an open DESIGN file from linker }
          begin
            sargv(4, arg);
            if not process_design_descriptor then
	      begin
	        error(234 { can't access DESIGN file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    design_specified_in_command_line := TRUE;
          end;
        last_legitimate_arg := 4;
      end

    else { not the SEPLINK command }
      begin

        i := 2;

        if (command = COMPERR_COMMAND) and (sargc >= i + 1) then
	  begin
	    sargv(i, arg);
	    if ord(arg^[0]) = 2 then if arg^[1] = '-' then
	      begin
	        if (arg^[2] = 'a') or (arg^[2] = 'A') then
		  specified_severity := NO_SEVERITY { dump them all }
	        else if (arg^[2] = 'o') or (arg^[2] = 'O') then
		  specified_severity := OVERSIGHT_SEVERITY
	        else if (arg^[2] = 'e') or (arg^[2] = 'E') then
		  specified_severity := ERROR_SEVERITY { dump them all }
	        else if (arg^[2] = 'w') or (arg^[2] = 'W') then
		  specified_severity := WARNING_SEVERITY
		else
		  begin
		    error(251 { unrecognized argument });
		    error_dump_indent(indent);
		    error_dump_alpha('Argument=       ');
		    error_dump_string(arg);
		    error_dump_CRLF;
		  end;

	        i := i + 1;
	      end;
	  end;

        if sargc >= i + 1 then   { there is a ROOT_DRAWING parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_root_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a COMPILE type parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_compile_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a CONTEXT_NAME parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_context_arg;
          end;
        last_legitimate_arg := i;
      end;

    for i := (last_legitimate_arg + 1) to (sargc - 1) do
      begin
        sargv(i, arg);
        if arg <> nullstring then
          if not (224 in errors_encountered) then error(224 { junk });
      end;

  end { process_command_line_arguments } ;


  procedure welcome;
    { display a welcome message to indicate start of compiler directive parse }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' *************************************');
        writeln(CmpLst, ' *  Reading the compiler directives  *');
        writeln(CmpLst, ' *************************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Reading the compiler directives.');
    writeln(CmpLog);  writeln(CmpLog, ' Reading the compiler directives.');
  end { welcome } ;


begin { PREDS_read_compiler_directives_file }
  welcome;

  process_command_line_arguments;

  { set up the default master library }

  new_file_list(master_library_file);
  master_library_file^.file_name := standard_library_file_name;

  allowed_key_words := directives_keysys;
  if not open_a_file(nullstring, DIRECTIVES_FILE) then
    error(135 { file does not exist! })
  else
    begin
      directives_encountered := [];

      found_debug_directive := FALSE;

      while sy = IDENT do
        begin
          if not find_directive(id.name, directive) then
            begin
              error(51 { unknown directive });
              skip([SEMI] + directives_keysys);
            end

          else if (directive IN directives_encountered) and
                  (directive IN one_time_directives) then
            begin
              error(45 { directive specified more than once });
              skip([SEMI]);
            end

          else
            begin
              if directive IN file_name_directives then
                upper_case_strings := FALSE;

              insymbol;     { eat the directive symbol }

              if sy = EQUAL then insymbol;    { allow an equal }
              case directive of
                ALLOW_PART_NAME_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        allow_PART_NAME_property := ON_or_OFF(id.name,
                                                     allow_PART_NAME_property)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                AMUSING_MESSAGES_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        produce_amusing_messages := ON_or_OFF(id.name,
                                                     produce_amusing_messages)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                BUBBLECHECK_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        bubble_check := ON_or_OFF(id.name, bubble_check)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                COMMAND_DIRECTIVE:
                    begin
                      if sy <> ident then error(1 { expected ident })
                      else process_COMMAND_directive(id.name);
                      insymbol;
                    end;

                COMPILE_DIRECTIVE:
                    begin
                      if sy <> ident then error(1 { expected ident })
                      else process_COMPILE_directive(id.name);
                      insymbol;
                    end;

                CONFIG_FILE_DIRECTIVE:
                    begin
                      if sy <> STRINGS then error(33 { expected name })
                      else configuration_file := lex_string;
                      insymbol;
                    end;

                CONST_BUBBLE_CHK_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        const_bubble_check :=
                                        ON_or_OFF(id.name, const_bubble_check)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

(************************ obsolete for now
                CONTEXT_DIRECTIVE:
                    begin
                      if sy = STRINGS then
                        if CONTEXT_specified_in_command_line then
                          begin   end
                        else
                          context_being_compiled := lex_string
                      else
                        error(33);
                      insymbol;
                    end;
**************************)

                DEBUG_DIRECTIVE:
                    process_debug;

                DEBUG_AT_PATH_DIRECTIVE:
                    process_path_debug;

                DEBUG_CONTROL_DIRECTIVE:
                    process_debug_controls;

                DECLARE_BODIES_DIRECTIVE:
                    begin
                      if sy = IDENT then
		        begin
                          if ON_or_OFF(id.name, FALSE) then
			    error(3 { SCALD compiler only });
			end
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                DEFAULT_FILTER_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        dummy_boolean := ON_or_OFF(id.name, FALSE)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                DEFAULT_L_OR_G_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        scope_is_local := local_or_global(id.name,
                                                          scope_is_local)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                DIRECTORY_DIRECTIVE:
                     process_directory_directive; 

                ENABLE_CARDINAL_TAP_DIRECTIVE:
                    begin
                      if sy = IDENT then
		        begin
                          enable_cardinal_tap := 
			    ON_or_OFF(id.name, enable_cardinal_tap);
                        end
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                ERROR_HELP_DIRECTIVE:
                    begin
                      if sy <> IDENT then error(1 { expected ident })
		      else
		        begin
                          display_error_doc := ON_or_OFF(id.name,
                                                         display_error_doc);
                          insymbol;
			end;
                    end;

                EVACUATE_DIRECTIVE:
                    begin
                      writeln(monitor);  writeln(monitor);
                      writeln(monitor,
                                    ' Evacuate!?  In our moment of triumph?');
                      writeln(monitor,
                                  ' I think you overestimate their chances.');
                      writeln(monitor);  writeln(monitor);
                      nil_ptr := NIL;  nil_ptr := nil_ptr^.next;
                    end;

                EXPANSION_RULES_DIRECTIVE:
                    get_file_name_list(expansion_rules_file);

                FILTER_PROPERTY_DIRECTIVE:
                    process_filters;

                HIERARCHICAL_NWC_DIRECTIVE:
                    begin
                      if sy = IDENT then
		        begin
                          if ON_or_OFF(id.name, FALSE) then
			    error(3 { SCALD compiler only });
                        end
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                LIBRARY_DIRECTIVE:
                    process_LIBRARY_directive;

                LOCALLY_GLOBAL_DIRECTIVE:
                    begin
                      if sy = IDENT then
		        begin
                          if not ON_or_OFF(id.name, TRUE) then
			    error(3 { SCALD compiler only });
			end
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;


                MASTER_LIBRARY_DIRECTIVE:
		    get_file_name_list(master_library_file);

                MAX_ERROR_DIRECTIVE:
                    begin
                      temp := expression(no_relops);
                      if temp <= 0 then error(178 { ridiculous! })
                      else max_errors := temp;
                    end;

                NET_PROCESSING_DIRECTIVE:
                    begin
                      if sy = IDENT then
		        begin
                          if not ON_or_OFF(id.name, TRUE) then
			    error(3 { SCALD compiler only });
			end
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                OUTPUT_DIRECTIVE:
                    process_OUTPUT_file_list;

                OVERSIGHT_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        display_oversights := ON_or_OFF(id.name,
                                                        display_oversights)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                PAGE_SYNONYM_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        dummy_boolean := ON_or_OFF(id.name, FALSE)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                PASS_PROPERTY_DIRECTIVE:
                    process_filters;

                PASSWORD_DIRECTIVE:
                    process_PASSWORD_directive;

                PERMIT_NO_ASSERTION_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        allow_missing_high_assertion := ON_or_OFF(id.name,
                                                 allow_missing_high_assertion)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                PICK_DIRECTIVE:
                    process_PICK_directive;

                PRIMITIVE_DIRECTIVE:
		    process_PRIMITIVE_directive;

                PROPERTY_DIRECTIVE:
                    get_file_name_list(property_file);

                PRINT_WIDTH_DIRECTIVE:
                    begin
                      temp := expression(no_relops);
                      if (temp<MIN_PRINT_WIDTH) or (temp>MAX_PRINT_WIDTH) then
                        error(94 { invalid print width value })
                      else print_width := temp;
                    end;

                REPORT_DIRECTIVE:
                    process_report_directive;

		REPORT_UNKASSERT_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        report_unknown_assertions :=
			  ON_or_OFF(id.name, report_unknown_assertions)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                ROOT_DIRECTIVE:
                    begin
                      if sy = STRINGS then
                        if ROOT_specified_in_command_line then
                          { ignore this one }
                        else
                          root_macro_name := lex_string
                      else
                        error(33 { expected name string });
                      insymbol;
                    end;

                SHADOW_ROOT_DIRECTIVE:
                    begin
                      if sy = STRINGS then shadow_root := lex_string
                      else
                        error(33 { expected a string });
                      insymbol;
                    end;

                SHAREABLE_DIRECTIVE:
		    process_shareable_directive;

                SINGLE_LEVEL_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        single_level_compile := 
			  ON_or_OFF(id.name, single_level_compile)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                SUPPRESS_DIRECTIVE:
                    process_suppress_directive;

                TEXT_MACRO_DIRECTIVE:
                    get_file_name_list(text_macro_file);

                TOKENIZE_PARAMS_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        tokenize_params :=
                          ON_or_OFF(id.name, tokenize_params)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                WARN_DIRECTIVE:
                    begin
                      if sy = IDENT then
                        display_warnings := ON_or_OFF(id.name,
                                                      display_warnings)
                      else
                        error(1 { expected ident });
                      insymbol;
                    end;

                OTHERWISE
                    begin
                      error(51 { unknown directive });
                      skip([SEMI]+directives_keysys);
                    end;
              end { case } ;

              directives_encountered := directives_encountered + [directive];

              upper_case_strings := TRUE;
            end { else } ;

          if sy = SEMI then insymbol else error(12 { expected ; });
        end { while } ;

      if sy = ENDSY then insymbol else error(40 { expected END });
      if sy <> PERIOD then error(37 { expected . });

      if not close_parse_file(DIRECTIVES_FILE) then
        begin
          error(168 { cannot close file });
          error_dump_alpha_file_name('DIRECTIVES FILE ');
        end;
      
      setup_signal_configuration_from_ds_module;

      parse_errors := parse_errors - [68,87,103]; { directory, lib errors }

      { Be sure to set the umask BEFORE specifying the shadow_root }

      if not (SHAREABLE_DIRECTIVE in directives_encountered) then
        old_umask := umask(shareable.umasks[GROUP_SHARING]);

      if shadow_root <> nullstring then
	begin
	end;

      reverse_file_list(expansion_rules_file);
      reverse_file_list(master_library_file);
      {read_master_libraries;}

      {process_library_list;}
      {process_directory_list;}
    end { else not file open } ;

  er_init(evaluate_boolean_expr,
	  error_without_parse_line, 
	  assert_without_parse_line, 
	  error_dump_integer, 
	  error_dump_standard_indent, 
	  error_dump_string, 
	  error_dump_current_context,
	  error_dump_crlf,
	  parse_error_notifier);

  er_type(specified_compile_type^.name);
  if init_expansion_rules <> 0 then
    begin
    end;
  read_expansion_rules;
  process_pick_list;

  allowed_key_words := [];

  files_to_generate := 
    files_to_generate - [CHIPS_FILE,CMPHIER_FILE,CMPEXP_FILE,CMPSYN_FILE];

  write(monitor, '   Compiler directives read ');
  write(CmpLog, '   Compiler directives read ');
  exec_time(last_elapsed_time, last_CPU_time, TRUE);
end { PREDS_read_compiler_directives_file } ;    
    
    
(**)     { ------- output list of all directive values ------- }


procedure report_compiler_directives(var f: textfile);
  { report the values of all of the compiler directives to the given file }
  var
    directive: directive_type;    { current directive to report }


  procedure print_name(var f: textfile; directive: directive_type);
    { print the name of the compiler directive }
  begin
    write(f, ' ');
    print_alpha(f, compiler_directive[directive]^.name);
    write(f, ' ');
  end { print_name } ;


  procedure report_directories(var f: textfile);
    { report the directories being used }
    var
      dir: directory_list_ptr;          { current directory in list }
      first_yet_to_be_output: boolean;  { TRUE if first not yet output }
  begin
    dir := directory_list_root;  first_yet_to_be_output := TRUE;
    while dir <> NIL do
      begin
        if first_yet_to_be_output then print_name(f, DIRECTORY_DIRECTIVE)
	else 
	  begin
	    writeln(f, ',');
	    write(f, ' ':11);
	  end;
        first_yet_to_be_output := FALSE;
	writestring(f, dir^.name);
	if dir^.add <> NIL then 
	  begin
            write(f, '-');
            writestring(f, dir^.add);
	  end;
        dir := dir^.next;
      end;

    if not first_yet_to_be_output then writeln(f, ';');
  end { report_directories } ;


  procedure report_libraries(var f: textfile);
    { report the libraries used }
    var
      first_yet_to_be_output: boolean;  { TRUE if first not yet output }
      library: directory_list_ptr;      { current element in the library }
  begin
    library := library_list_root;  first_yet_to_be_output := TRUE;
    while library <> NIL do
      begin
        if first_yet_to_be_output then  print_name(f, LIBRARY_DIRECTIVE)
        else
          begin  writeln(f, ',');  write(f, ' ':9);  end;
        first_yet_to_be_output := FALSE;
        writestring(f, library^.name);
	if library^.add <> NIL then
	  begin
            write(f, '-');
            writestring(f, library^.add);
	  end;
        library := library^.next;
      end;

    if not first_yet_to_be_output then writeln(f, ';');
  end { report_libraries } ;


  procedure report_output_directive(var f: textfile);
    { report the output files to be created }
    var
      file_name: output_file_names;   { name of the output file }
      first: boolean;                 { TRUE if first element in the list }
  begin
    print_name(f, OUTPUT_DIRECTIVE);  first := TRUE;
    for file_name := succ(FIRST_FILE_NAME) to pred(LAST_FILE_NAME) do
      if file_name IN files_to_generate then
        begin
          if first then first := FALSE else write(f, ', ');
          writealpha(f, output_file[file_name]^.name);
        end;

    writeln(f, ';');
  end { report_output_directive } ;


  procedure report_REPORT_directive(var f: textfile);
    { report the report directive }
    var
      first: boolean;            { TRUE if first report yet to be generated }
      report: report_types;      { current report type }
  begin
    if reports_to_generate <> [] then
      begin
        first := TRUE;
        print_name(f, REPORT_DIRECTIVE);
        for report := succ(FIRST_REPORT_TYPE) to pred(LAST_REPORT_TYPE) do
          if report IN reports_to_generate then
            begin
              if first then first := FALSE else write(f, ', ');
              writealpha(f, report_type_table[report]^.name);
            end;

        writeln(f, ';');
      end;
  end { report_REPORT_directive } ;


  procedure report_shareable_directive(var f: textfile);
    { report whether to be shared  by owner, group or by all }
  begin
    print_name(f, SHAREABLE_DIRECTIVE);
    writealpha(f,shareable.values[specified_shareable_value]^.name);
    writeln(f, ';');
  end;

  procedure report_SUPPRESS_directive(var f: textfile);
    { report the suppressed error messages }
    var
      first: boolean;        { TRUE if first time through loop }
      error: error_range;    { current error candidate }
  begin
    if suppress_errors <> [] then
      begin
        print_name(f, SUPPRESS_DIRECTIVE);

        first := TRUE;
        for error := 0 to MAX_ERROR_NUM do
          if error IN suppress_errors then
            if first then
              begin  write(f, error:1);  first := FALSE;  end
            else
              write(f, ',', error:1);

        writeln(f, ';');
      end;
  end { report_SUPPRESS_directive } ;


  procedure report_bool_directive(directive: directive_type; val: boolean);
    { report the value of an ON/OFF directive }
  begin
    print_name(f, directive);
    if val then writeln(f, 'ON;') else writeln(f, 'OFF;');
  end { report_bool_directive } ;
   

  procedure report_int_directive(directive: directive_type; val: integer);
    { report value of integer directive }
  begin
    print_name(f, directive);
    writeln(f, val:1, ';');
  end { report_int_directive } ;


  procedure report_string_directive(directive: directive_type; val: xtring);
    { report value of string directive }
  begin
    print_name(f, directive);
    writestring(f, val);
    writeln(f, ';');
  end { report_string_directive } ;


  procedure report_file_list_directive(directive: directive_type;
                                       file_name_list: file_list_ptr);
    { report a list of files for the given directive }
    var
      current_file: file_list_ptr;     { current file in the list }
  begin
    current_file := file_name_list;
    while current_file <> NIL do
      begin
        report_string_directive(directive, current_file^.file_name);

        current_file := current_file^.next;
      end;
  end { report_file_list_directive } ;


  procedure report_COMPILE_directive(var f: textfile);
    { report the value of the COMPILE directive }
    var
      id_size: id_range;    { size of compile directive }
  begin
    print_name(f, COMPILE_DIRECTIVE);
    id_size := alpha_length(specified_compile_type^.name);
    writeln(f, specified_compile_type^.name:id_size, ';');
  end { report_COMPILE_directive } ;


  procedure report_DEBUG_directive(var f: textfile);
    { report the debug directive }
  begin
    print_name(f, DEBUG_DIRECTIVE);
    if debug then write(f, 'ON') else write(f, 'OFF');

    if debug_1  then write(f, ',1');
    if debug_2  then write(f, ',2');
    if debug_3  then write(f, ',3');
    if debug_4  then write(f, ',4');
    if debug_5  then write(f, ',5');
    if debug_6  then write(f, ',6');
    if debug_7  then write(f, ',7');
    if debug_8  then write(f, ',8');
    if debug_9  then write(f, ',9');
    if debug_10 then write(f, ',10');
    if debug_11 then write(f, ',11');
    if debug_12 then write(f, ',12');
    if debug_13 then write(f, ',13');
    if debug_14 then write(f, ',14');
    if debug_15 then write(f, ',15');
    if debug_16 then write(f, ',16');
    if debug_17 then write(f, ',17');
    if debug_18 then write(f, ',18');
    if debug_19 then write(f, ',19');
    if debug_20 then write(f, ',20');
    if debug_21 then write(f, ',21');
    if debug_22 then write(f, ',22');
    if debug_23 then write(f, ',23');
    if debug_24 then write(f, ',24');
    if debug_25 then write(f, ',25');
    if debug_26 then write(f, ',26');
    if debug_27 then write(f, ',27');
    if debug_28 then write(f, ',28');
    if debug_29 then write(f, ',29');
    if debug_30 then write(f, ',30');
    if debug_31 then write(f, ',31');
    if debug_32 then write(f, ',32');
    if debug_33 then write(f, ',33');
    if debug_34 then write(f, ',34');
    if debug_35 then write(f, ',35');
    if debug_36 then write(f, ',36');
    if debug_37 then write(f, ',37');
    if debug_38 then write(f, ',38');
    if debug_40 then write(f, ',40');

    writeln(f, ';');
  end { report_DEBUG_directive } ;


  procedure report_DEBUG_AT_PATH_directive(var f: textfile);
    { report the directive assignments }
    var
      first: boolean;          { TRUE if first yet to be output }
      i: debug_flag_range;     { debug flag number (0=DEBUG ON) }
  begin
    if debug_at_path then
      begin
        print_name(f, DEBUG_AT_PATH_DIRECTIVE);
        writestring(f, path_for_debug);
        write(f, ' ');

        first := TRUE;
        for i := 0 to MAX_DEBUG_FLAG_NUMBER do
          if i IN debug_flags then
            begin
              if first then first := FALSE else write(f, ',');

              if i = 0 then write(f, 'ON') else write(f, i:1);
            end;

        writeln(f, ';');
      end;
  end { report_DEBUG_AT_PATH_directive } ;


  procedure report_DEBUG_CONTROL_directive(var f: textfile);
    { report the debug control directive }
    var
      first: boolean;      { TRUE if first yet to be output }
      i: debug_controls;   { index into control table }


    procedure print_control(control: debug_controls);
      { print the given control to the output file }
    begin
      if first then first := FALSE
      else
        begin
          writeln(f, ',');
          write(f, ' ':15);
        end;

      writealpha(f, debug_control_specifier[control]^.name);
    end { print_control } ;


    procedure report_histograms(control: debug_controls);
      { report the histogram specification }
      var
        hist: histogram_types;      { index into the histogram table }
        first: boolean;             { TRUE if first yet to be output }
    begin
      if histograms <> [] then
        begin
          print_control(control);

          write(f, '(');

          first := TRUE;
          for hist := succ(FIRST_HISTOGRAM) to pred(LAST_HISTOGRAM) do
            if hist IN histograms then
              begin
                if first then first := FALSE else write(f, ',');

                writealpha(f, histogram_specifiers[hist]^.name);
              end;

          write(f, ')');
        end;
    end { report_histograms } ;


  begin { report_DEBUG_CONTROL_directive }
    print_name(f, DEBUG_CONTROL_DIRECTIVE);

    first := TRUE;
    for i := succ(FIRST_CONTROL) to pred(LAST_CONTROL) do
      case i of
        control_dumptree:        if dumptree_ok then print_control(i);
        control_dumpsignals:     if dumpsignals_ok then print_control(i);
        control_printmacros:     if printmacros_ok then print_control(i);
        control_printdirectory:  if printdirectory_ok then print_control(i);
        control_printhistograms: report_histograms(i);
        control_dumpsigdeflist:  if dumpsigdeflist_ok then print_control(i);
        control_dump_all_names:  if dump_all_names_ok then print_control(i);
        control_erule_xface:  if trace_erule_xface then print_control(i);
      end;

    writeln(f, ';');
  end { report_DEBUG_CONTROL_directive } ;


  procedure report_filter_directives(var f: textfile);
    { report the PASS and FILTER directives }


    procedure output_property_list(which: xtring);
      { output the properties from the list as specified by WHICH }
      var
        prop: property_ptr;    { current property in the list }
        first: boolean;        { TRUE if first prop yet to be printed }
    begin
      prop := properties_assigned_filters;  first := TRUE;
      while prop <> NIL do
        begin
          if prop^.text = which then
            begin
              if first then first := FALSE
              else
                begin
                  writeln(f, ',');
                  if which = PASS_string then
                    write(f, ' ':15)
                  else
                    write(f, ' ':17);
                end;

              writealpha(f, prop^.name^.name);
            end;

          prop := prop^.next;
        end;

      writeln(f, ';');
    end { output_property_list } ;


  begin { report_filter_directives }
    print_name(f, PASS_PROPERTY_DIRECTIVE);
    output_property_list(PASS_string);

    print_name(f, FILTER_PROPERTY_DIRECTIVE);
    output_property_list(FILTER_string);
  end { report_filter_directives } ;


begin { report_compiler_directives }
  writeln(f);
  writeln(f, ' ------ Global Compiler Directives ------');
  writeln(f);

  for directive := succ(FIRST_DIRECTIVE) to pred(LAST_DIRECTIVE) do
    case directive of
      ALLOW_PART_NAME_DIRECTIVE:
          if not allow_PART_NAME_property then
            report_bool_directive(ALLOW_PART_NAME_DIRECTIVE,
                                  allow_PART_NAME_property);

      AMUSING_MESSAGES_DIRECTIVE:
          if produce_amusing_messages then
            report_bool_directive(AMUSING_MESSAGES_DIRECTIVE,
                                  produce_amusing_messages);

      BUBBLECHECK_DIRECTIVE:
          report_bool_directive(BUBBLECHECK_DIRECTIVE, bubble_check);

      COMPILE_DIRECTIVE:
          report_COMPILE_directive(f);

      CONFIG_FILE_DIRECTIVE:
          if configuration_file <> default_configuration_file then
            report_string_directive(CONFIG_FILE_DIRECTIVE, configuration_file);

      CONST_BUBBLE_CHK_DIRECTIVE:
          report_bool_directive(CONST_BUBBLE_CHK_DIRECTIVE,
                                const_bubble_check);

      DEBUG_DIRECTIVE:
          if found_debug_password then
            report_debug_directive(f);

      DEBUG_AT_PATH_DIRECTIVE:
          if found_debug_password then
            report_debug_at_path_directive(f);

      DEBUG_CONTROL_DIRECTIVE:
          if found_debug_password then
            report_debug_control_directive(f);

      DECLARE_BODIES_DIRECTIVE: { nothing -- not supported here } ;

      DEFAULT_L_OR_G_DIRECTIVE:
          if not scope_is_local then
            begin
              print_name(f, DEFAULT_L_OR_G_DIRECTIVE);
              if scope_is_local then writeln(f, 'LOCAL;')
                                else writeln(f, 'GLOBAL;');
            end;

      DIRECTORY_DIRECTIVE:
          report_directories(f);

      ENABLE_CARDINAL_TAP_DIRECTIVE:
          if not enable_cardinal_tap then
	    report_bool_directive(ENABLE_CARDINAL_TAP_DIRECTIVE, 
				  enable_cardinal_tap);

      ERROR_HELP_DIRECTIVE:
          report_bool_directive(ERROR_HELP_DIRECTIVE, display_error_doc);

      EVACUATE_DIRECTIVE:  ;

      EXPANSION_RULES_DIRECTIVE:
          if expansion_rules_file <> NIL then
            report_file_list_directive(EXPANSION_RULES_DIRECTIVE, 
	                               expansion_rules_file);

      FILTER_PROPERTY_DIRECTIVE:
          report_filter_directives(f);

      LIBRARY_DIRECTIVE:
          report_libraries(f);

      MASTER_LIBRARY_DIRECTIVE:
          if master_library_file <> NIL then
            report_file_list_directive(MASTER_LIBRARY_DIRECTIVE, 
	                               master_library_file);

      MAX_ERROR_DIRECTIVE:
          report_int_directive(MAX_ERROR_DIRECTIVE, max_errors);

      NET_PROCESSING_DIRECTIVE:
          if not net_processing then
            report_bool_directive(NET_PROCESSING_DIRECTIVE, net_processing);

      OUTPUT_DIRECTIVE:
          report_output_directive(f);

      OVERSIGHT_DIRECTIVE:
          report_bool_directive(OVERSIGHT_DIRECTIVE, display_oversights);

      PASS_PROPERTY_DIRECTIVE:  ;

      PASSWORD_DIRECTIVE:  ;

      PERMIT_NO_ASSERTION_DIRECTIVE:
          report_bool_directive(PERMIT_NO_ASSERTION_DIRECTIVE,
                                allow_missing_high_assertion);

      PROPERTY_DIRECTIVE:
          if property_file <> NIL then
            report_file_list_directive(PROPERTY_DIRECTIVE, property_file);

      PRINT_WIDTH_DIRECTIVE:
          report_int_directive(PRINT_WIDTH_DIRECTIVE, print_width);

      REPORT_DIRECTIVE:
          report_REPORT_directive(f);

      SHADOW_ROOT_DIRECTIVE:
          if shadow_root <> nullstring then
            report_string_directive(SHADOW_ROOT_DIRECTIVE, shadow_root);

      SHAREABLE_DIRECTIVE:
	  report_shareable_directive(f);

      SUPPRESS_DIRECTIVE:
          report_suppress_directive(f);

      TEXT_MACRO_DIRECTIVE:
          if text_macro_file <> NIL then
            report_file_list_directive(TEXT_MACRO_DIRECTIVE, text_macro_file);

      TOKENIZE_PARAMS_DIRECTIVE:
          if tokenize_params then
            report_bool_directive(TOKENIZE_PARAMS_DIRECTIVE,
                                  tokenize_params);

      WARN_DIRECTIVE:
          report_bool_directive(WARN_DIRECTIVE, display_warnings);

      OTHERWISE
            ;

    end { case directive of } ;

  writeln(f);
  writeln(f);
  writeln(f, ' Signal syntax:');
  writeln(f);

  output_configuration(f, 3);

  writeln(f);
end { report_compiler_directives } ;


(**)     { ------- reserved text macro routines ------- }


procedure add_global_text_macro(name: name_ptr; definition: xtring;
                                  kind: name_types { RESERVED or UNRESERVED or
                                                     PERMANENT });
    { add the given name to the name table and check its type.  If
      PERMANENT, then also make it RESERVED. }
begin
  if RESERVED in name^.kind then
    error(46 { this TM cannot be redefined })
  else
    begin
      if kind = PERMANENT then 
        name^.kind := name^.kind + [PERMANENT,RESERVED]
      else name^.kind := name^.kind + [kind];
      name^.definition := definition;
    end;
end { add_global_text_macro } ;
   

procedure PREDS_init_global_text_macros;
  { init table of reserved/unreserved global text macro names }
  const
    TM_DEF_LENGTH = 17;

  type
    TM_def_range = 1..TM_DEF_LENGTH;
    TM_def_type = packed array [TM_def_range] of char;

  var
    current_text_macro_file: file_list_ptr;  { current file in the file list }
    
      
  procedure add_standard_TM(name: alpha; def: TM_def_type);
    { create a reserved global text macro of the given name and definition }
    var
      i,                         { index into def }
      pos: TM_def_range;         { length of the definition string }
      hash_name: name_ptr;       { name "hashed" into identifier }
      temp,                      { temp "work" string }
      TM_def: xtring;            { definition of the TM as a string }
  begin
    hash_name := enter_name(name);

    pos := TM_DEF_LENGTH;
    while def[pos] = ' ' do pos := pos - 1;

    create_a_string(temp, pos);
    for i := 1 to pos do temp^[i] := def[i];

    TM_def := enter_and_release_string(temp);

    add_global_text_macro(hash_name, TM_def, PERMANENT);
  end { add_standard_TM } ;


  procedure process_text_macros(file_name: xtring);
    { process the text macros in the given file }
    var
      TM_name: name_ptr;     { name of the current text macro }
      TM_def: xtring;        { definition of the current text macro }
      kind: name_types;      { RESERVED or UNRESERVED }
  begin
    if not open_a_file(file_name, STANDARD_FILE) then
      begin
        error(209 { cannot open text macro file });
        error_dump_file_name(file_name);
      end
    else
      if get_file_type <> SPECIAL_TEXT_MACROS then
        begin
          error(9 { wrong file });
          error_dump_file_name(file_name);

          if not close_parse_file(STANDARD_FILE) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;
        end
      else
        begin
          { set up the current parse environment }

          push_error_info;
          current_file_name := file_name;

          repeat
            if sy <> IDENT then
              begin  error(1 { expected ident });  skip([SEMI,PERIOD]);  end
            else
              begin
                TM_name := id.name;
                insymbol;   { eat the text macro ID }

                if sy = EQUAL then insymbol else error(2 { expected = });
                if sy <> STRINGS then
                  begin
                    error(33 { expected string });  skip([SEMI,PERIOD]);
                  end
                else
                  begin
                    TM_def := lex_string;
                    insymbol;    { eat the text macro definition string }

                    if sy = IDENT then
                      begin
                        if id.name = RESERVED_key_name then
                          begin
                            kind := RESERVED;  insymbol;
                          end
                        else if id.name = UNRESERVED_key_name then
                          begin
                            kind := UNRESERVED; insymbol;
                          end
                        else
                          kind := RESERVED { error message follows - expect ; }
                      end
                    else kind := RESERVED;

                    add_global_text_macro(TM_name, TM_def, kind);
                  end;
              end;
            if sy = SEMI then insymbol else error(12 { expected ; });
          until sy <> IDENT;

          if sy = ENDSY then insymbol else error(40 { expected END });
          if sy <> PERIOD then error(37 { expected . });

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;

          pop_error_info;
        end;
  end { process_text_macros } ;


  procedure welcome;
    { display a message to indicate start of the directory parse }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst, ' *  Reading text macro definitions  *');
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Reading text macro definitions.');
    writeln(CmpLog);  writeln(CmpLog, ' Reading text macro definitions.');
  end { welcome } ;


begin { PREDS_init_global_text_macros }
  welcome;

 add_standard_TM('R               ', 'REP="%1"         '); { replication }
 add_standard_TM('G               ', 'SCOPE="GLOBAL"   '); { global signal }
 add_standard_TM('L               ', 'SCOPE="LOCAL"    '); { local signal }
 add_standard_TM('I               ', 'SCOPE="INTERFACE"'); { interface sig }
 add_standard_TM('NWC             ', 'NOWIDTH=""       '); { width check }
 add_standard_TM('NBC             ', 'NOBUBBLE=""      '); { bubble check }
 add_standard_TM('NAC             ', 'NOASSERT=""      '); { inherit assert }
 add_standard_TM('B               ', 'BUBBLED=""       '); { pin has bubble }
 add_standard_TM('TRUE            ', '1                '); { TRUE constant }
 add_standard_TM('FALSE           ', '0                '); { FALSE constant }

  { read in other standard text macros }

  allowed_key_words := directory_keysys;

 { read standard text macros from the Valid supplied file }

 if standard_text_macro_file <> nullstring then
   process_text_macros(standard_text_macro_file); 

   { read standard text macros from the user supplied file }

 current_text_macro_file := text_macro_file;
 while current_text_macro_file <> NIL do
   begin
     process_text_macros(current_text_macro_file^.file_name);
     current_text_macro_file := current_text_macro_file^.next;
   end;

 allowed_key_words := [];
  write(monitor, '   Text macro definitions read ');
  write(CmpLog, '   Text macro definitions read ');
  exec_time(last_elapsed_time, last_CPU_time, TRUE);
end { PREDS_init_global_text_macros } ;
      

(**)     { ------- read in property properties ------- }


procedure PREDS_read_property_attributes;
  { read the file containing property inheritance information }
  var
    current_property_file: file_list_ptr;  { current attributes file in list }


  procedure process_attributes(file_name: xtring);
    { process the given property attribute file }
    var
      prop_name: name_ptr;          { name of the property read in }
      finished,                     { TRUE when specifier list read }
      done: boolean;                { TRUE when inheritance list read in }
  begin
    if not open_a_file(file_name, standard_file) then
      begin
        error(195 { cannot open attributes file });
        error_dump_file_name(file_name);
      end
    else
      if get_file_type <> property_attributes then
        begin
          error(55 { wrong file });
          error_dump_file_name(file_name);

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;
        end
      else
        begin
          { create the parse environment for error reporting }

          push_error_info;
          current_file_name := file_name;

          repeat
            if sy <> IDENT then
              begin  error(1 { expected ident });  skip([SEMI,ENDSY]);  end
            else
              begin
                prop_name := id.name;
                insymbol;

                if sy = colon then insymbol else error(13 { expected : });

                done := FALSE;
                repeat
                  if sy <> IDENT then
                    begin
                      error(1 { expected indent });  skip([SEMI,ENDSY]);
                    end
                  else
                    if id.name^.name = 'PIN_EQUIVALENT  ' then
                      begin
                        insymbol;
                        error(184 { no longer supported });
                        error_dump_indent(indent);
                        error_dump_alpha('Use inherit(PIN)');
                        error_dump_CRLF;

                        prop_name^.kind := prop_name^.kind + [INHERIT_PIN];
                      end
                    else if id.name^.name = 'PARAMETER       ' then
                      begin
                        insymbol;
                        prop_name^.kind := prop_name^.kind + [IS_PARAMETER];
                        if sy = LPAREN then
                          begin
                            insymbol;
                            if sy <> IDENT then error(1 { expected ident });
                            if id.name^.name = 'INTEGER         ' then
                              prop_name^.kind := prop_name^.kind +
                                                            [IS_INT_PARAMETER]
                            else error(48 { unexpected });
                            insymbol;
                            if sy = RPAREN then insymbol
                                           else error(7 { expected ) });
                          end;
                      end
                    else if id.name^.name = 'INHERIT         ' then
                      begin
                        prop_name^.kind := prop_name^.kind -
                                                       inheritance_attributes;
                        insymbol;
                        if sy = LPAREN then insymbol
                                       else error(15 { expected ( });
                        finished := FALSE;
                        repeat
                          if sy = IDENT then
                            begin
                              if id.name = SIGNAL_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                              [INHERIT_SIGNAL]
                              else if id.name = PIN_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                 [INHERIT_PIN]
                              else if id.name = BODY_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                [INHERIT_BODY]
                              else
                                error(47 { invalid inheritance specifier });
                              insymbol;
                            end;
                          if sy = COMMA then insymbol else finished := TRUE;
                        until finished;
                        if sy = RPAREN then insymbol
                                       else error(7 { expected ) });
                      end
                    else if id.name^.name = 'PERMIT          ' then
                      begin
                        prop_name^.kind := prop_name^.kind -
                                                        permission_attributes;
                        insymbol;
                        if sy = LPAREN then insymbol
                                       else error(15 { expected ( });
                        finished := FALSE;
                        repeat
                          if sy = IDENT then
                            begin
                              if id.name = SIGNAL_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                               [PERMIT_SIGNAL]
                              else if id.name = PIN_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                  [PERMIT_PIN]
                              else if id.name = BODY_prop_name then
                                prop_name^.kind := prop_name^.kind +
                                                                 [PERMIT_BODY]
                              else
                                error(150 { invalid PERMIT specifier });
                              insymbol;
                            end;
                          if sy = COMMA then insymbol else finished := TRUE;
                        until finished;
                        if sy = RPAREN then insymbol
                                       else error(7 { expected ) });
                      end
                    else if id.name^.name = 'FILTER          ' then
                      begin
                        prop_name^.kind := prop_name^.kind + [DONT_OUTPUT];
                        insymbol;
                      end
                    else if id.name^.name = 'PASS            ' then
                      begin
                        prop_name^.kind := prop_name^.kind - [DONT_OUTPUT];
                        insymbol;
                      end
                    else
                      begin
                        error(48 { unexpected });  skip([SEMI,ENDSY]);
                      end;
                  if sy = COMMA then insymbol else done := TRUE;
                until done;
              end;

            if sy = SEMI then insymbol else error(12 { expected ; });
          until sy <> IDENT;

          if sy = ENDSY then insymbol else error(40 { expected END });
          if sy <> PERIOD then error(37 { expected . });

          if not close_parse_file(standard_file) then
            begin
              error(168 { cannot close file });
              error_dump_file_name(file_name);
            end;

          pop_error_info;
        end;
  end { process_attributes } ;


  procedure process_attribute_directives;
    { process the filter directives.  TRUE means to pass, FALSE to filter. }
    var
      prop: property_ptr;   { current property in the list }
  begin
    prop := properties_assigned_filters;
    while prop <> NIL do
      begin
        if prop^.text = PASS_string then
          prop^.name^.kind := prop^.name^.kind - [DONT_OUTPUT]
        else if prop^.text = FILTER_string then
          prop^.name^.kind := prop^.name^.kind + [DONT_OUTPUT];

        prop := prop^.next;
      end;
  end { process_attribute_directives } ;


  procedure init_attributes(prop_name: name_ptr);
    { initialize the inheritance and permission attributes for the given
      property name }
  begin
    prop_name^.kind := prop_name^.kind - inheritance_attributes
                                       - permission_attributes
                                       - parameter_attributes;
  end { init_attributes } ;


  procedure set_up_default_attributes(var name: name_ptr;
                                      attributes: name_type_set);
    { clear all inheritance attributes for the given name }
  begin
    if attributes * permission_attributes <> [] then
      name^.kind := name^.kind - permission_attributes;

    if attributes * inheritance_attributes <> [] then
      name^.kind := name^.kind - inheritance_attributes;

    if attributes * parameter_attributes <> [] then
      name^.kind := name^.kind - parameter_attributes;

    name^.kind := name^.kind + attributes;
  end { set_up_default_attributes } ;


  procedure welcome;
    { display a message to indicate start of the inheritance read }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst, ' *  Reading property attributes  *');
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Reading property attributes.');
    writeln(CmpLog);  writeln(CmpLog, ' Reading property attributes.');
  end { welcome } ;


begin { PREDS_read_property_attributes }
  welcome;

  init_attributes(PATH_prop_name);
  init_attributes(SIZE_prop_name);
  init_attributes(TIMES_prop_name);
  init_attributes(PATH_prop_name);
  init_attributes(REPLICATION_prop_name);
  init_attributes(TITLE_prop_name);
  init_attributes(EXPR_prop_name);
  init_attributes(VERSION_prop_name);
  init_attributes(ABBREV_prop_name);
  init_attributes(SCOPE_prop_name);
  init_attributes(PART_NAME_prop_name);
  init_attributes(TERMINAL_prop_name);
  init_attributes(NET_ID_prop_name);
  init_attributes(NEEDS_NO_SIZE_prop_name);
  init_attributes(HAS_FIXED_SIZE_prop_name);
  init_attributes(COMMENT_BODY_prop_name);
  init_attributes(NO_WIDTH_prop_name);
  init_attributes(NO_ASSERT_prop_name);
  init_attributes(NO_BUBBLE_prop_name);
  init_attributes(CARDINAL_TAP_prop_name);
  init_attributes(BODY_TYPE_prop_name);
  init_attributes(X_identifier);
  init_attributes(X_FIRST_identifier);
  init_attributes(X_STEP_identifier);


  { read the Valid supplied property attributes }


  if DATA_SERVICES_FLAG = 0 then
    begin
      allowed_key_words := directory_keysys;

      if standard_property_file <> nullstring then
        process_attributes(standard_property_file);


      { read the user supplied property attributes }

      current_property_file := property_file;
      while current_property_file <> NIL do
        begin
          process_attributes(current_property_file^.file_name);
          current_property_file := current_property_file^.next;
        end;

      allowed_key_words := [];
    end
  else
    begin
    end;    


  { set up some internal property attributes }

  set_up_default_attributes(SIZE_prop_name,           [PERMIT_BODY,
                                                       IS_PARAMETER,
                                                       IS_INT_PARAMETER]);
  set_up_default_attributes(TIMES_prop_name,          [PERMIT_BODY,
                                                       IS_PARAMETER,
                                                       IS_INT_PARAMETER]);
  set_up_default_attributes(PATH_prop_name,           [PERMIT_BODY]);
  set_up_default_attributes(REPLICATION_prop_name,    [PERMIT_SIGNAL]);
  set_up_default_attributes(TITLE_prop_name,          [PERMIT_BODY]);
  set_up_default_attributes(EXPR_prop_name,           [PERMIT_BODY]);
  set_up_default_attributes(VERSION_prop_name,        [PERMIT_BODY]);
  set_up_default_attributes(ABBREV_prop_name,         [PERMIT_BODY]);
  set_up_default_attributes(SCOPE_prop_name,          [PERMIT_SIGNAL]);
  set_up_default_attributes(PART_NAME_prop_name,      [PERMIT_BODY]);
  set_up_default_attributes(TERMINAL_prop_name,       [PERMIT_BODY]);
  set_up_default_attributes(NET_ID_prop_name,         [PERMIT_SIGNAL]);
  set_up_default_attributes(NEEDS_NO_SIZE_prop_name,  [PERMIT_BODY]);
  set_up_default_attributes(HAS_FIXED_SIZE_prop_name, [PERMIT_BODY]);
  set_up_default_attributes(COMMENT_BODY_prop_name,   [PERMIT_BODY]);
  set_up_default_attributes(NO_WIDTH_prop_name,       [PERMIT_SIGNAL,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(NO_ASSERT_prop_name,      [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(CARDINAL_TAP_prop_name,   [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(NO_BUBBLE_prop_name,      [PERMIT_PIN,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(BODY_TYPE_prop_name,      [PERMIT_BODY]);
  set_up_default_attributes(X_identifier,             [IS_PARAMETER,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(X_FIRST_identifier,       [PERMIT_BODY,
                                                       DONT_OUTPUT]);
  set_up_default_attributes(X_STEP_identifier,        [PERMIT_BODY,
                                                       DONT_OUTPUT]);

  process_attribute_directives;

  write(monitor, '   Property attributes read ');
  write(CmpLog, '   Property attributes read ');
  exec_time(last_elapsed_time, last_CPU_time, TRUE);
end { PREDS_read_property_attributes } ;


procedure forced_exit;
  { if in a critical routine, then do nothing, else clean up and return }
begin
  if in_critical_section <= 0 then
    begin
      enter_critical_section;
      if expansion_file_open then
        begin
          pipe_close(CmpExp_pipe);
          if not remove_file(page_expansion_file_name) then ;
	  { Expansion file is still marked dirty -- it will be recompiled
	    regardless of whether or not the deletion succeeded }
          expansion_file_open := FALSE;
        end;

      if schema_file_open then
        begin
          write_schema_file(schema_of_drawing_being_compiled);
        end;

      pipe_close(CmpDraw_pipe);
      pipe_close(Design_pipe);
      if debugging then writeln(Monitor, '        exiting.');
      halt_with_status(FATAL_COMPLETION);
      { exit_critical_section, obviously }
    end;
end { forced_exit } ;


procedure catch_kill_signal;
  { if this is the first kill signal, then acknowledge and call forced_exit
    to handle clean-up and exit.  Otherwise, complain about the 
    interruption. }


  procedure acknowledge_signal;
    { if debugging, then print something that indicates what happened }
  begin
    if debugging then
      begin
        writeln(Monitor, 'SIGNAL received...');
        writeln(Outfile, 'SIGNAL received...');
      end;
  end { acknowledge_signal } ;


  procedure complain_about_multiple_signals;
    { Politely inform user that he should knock off the continuous
      control-Cs }
  begin
    if monitor_open then
      if produce_amusing_messages then
        writeln(Monitor, 'I''m dying as fast as I can!!')
      else 
        begin
          writeln(Monitor, 'KILL signal already received (cleaning up)...');
          kill_count := kill_count + 1;
          if kill_count >= RIDICULOUS_KILL_COUNT then
            produce_amusing_messages := TRUE;
        end;
  end { complain_about_multiple_signals } ;


begin { catch_kill_signal }
  if kill_received then complain_about_multiple_signals
  else
    begin
      kill_received := TRUE;
      acknowledge_signal;
      forced_exit;
    end;
end { catch_kill_signal } ;


procedure enter_critical_section;
  { increment the semaphore }
begin
  in_critical_section := in_critical_section + 1;
end { enter_critical_section } ;


procedure exit_critical_section;
  { decrement the semaphore and, if not still in critical section, check
    for need to force an exit }
begin
  if in_critical_section = 0 then assert(254 { semaphore underflow })
  else in_critical_section := in_critical_section - 1;
  if (in_critical_section = 0) and kill_received then forced_exit;
end { exit_critical_section } ;


procedure init_interrupt;
  { initialize interrupt variables and enable interrupt catching.  This
    should be one of the first procedure calls made -- it should be
    before init_comp_vms (VMS), but probably after authorize (PC/AT). }
begin
  in_critical_section := 0;
  kill_received := FALSE;
  debugging := FALSE;
  expansion_file_open := FALSE;
  schema_file_open := FALSE;
  kill_count := 0;
  monitor_open := FALSE;
  pipe_init(CmpDraw_pipe);
  pipe_init(Design_pipe);

  def_handler(catch_kill_signal);

end { init_interrupt } ;


procedure kill_self;
  { Kill self via signal (to test signal catching) }
begin

  suicide;


end { kill_self } ;


(**)    { ------- initialization routines ------- }


procedure init;
  { initialize global (and some local) 'constants' and vars }


  procedure init_keywords;
    { init macro keywords }
    var
      id: alpha;              { key word to be added }
      sy: symbols;            { corresponding symbol for the key word }
    

    procedure add_keyword;
      { add the key word to the name table and set its value }
      var
        name: name_ptr;       { name to be added to the name table }
    begin
      name := enter_name(id);
      if KEY_WORD in name^.kind then assert(159 { name already there })
      else
        begin  name^.kind := name^.kind + [KEY_WORD];  name^.sy := sy;  end;
    end { add_keyword } ;
      

  begin { init_keywords }
    id := 'OR              ';  sy := ORSY;           add_keyword;
    id := 'XOR             ';  sy := XORSY;          add_keyword;
    id := 'AND             ';  sy := ANDSY;          add_keyword;
    id := 'MOD             ';  sy := MODSY;          add_keyword;
    id := 'NOT             ';  sy := NOTSY;          add_keyword;
    id := 'ABS             ';  sy := ABSSY;          add_keyword;
    id := 'ORD             ';  sy := ORDSY;          add_keyword;
    id := 'MAX             ';  sy := MAXSY;          add_keyword;
    id := 'MIN             ';  sy := MINSY;          add_keyword;
    id := 'END             ';  sy := ENDSY;          add_keyword;
    id := 'MACRO           ';  sy := MACROSY;        add_keyword;
    id := 'END_MACRO       ';  sy := ENDMACROSY;     add_keyword;
    id := 'INVOKE          ';  sy := INVOKESY;       add_keyword;
    id := 'END_INVOKE      ';  sy := ENDINVOKESY;    add_keyword;
    id := 'PROPERTY        ';  sy := PROPERTYSY;     add_keyword;
    id := 'END_PROPERTY    ';  sy := ENDPROPERTYSY;  add_keyword;
    id := 'PIN             ';  sy := PINSY;          add_keyword;
    id := 'END_PIN         ';  sy := ENDPINSY;       add_keyword;
    id := 'BODY            ';  sy := BODYSY;         add_keyword;
    id := 'END_BODY        ';  sy := ENDBODYSY;      add_keyword;
    id := 'BINDINGS        ';  sy := BINDINGSY;      add_keyword;
    id := 'END_BINDINGS    ';  sy := ENDBINDSY;      add_keyword;
    id := 'PARAMETER       ';  sy := PARAMETERSY;    add_keyword;
    id := 'END_PARAMETER   ';  sy := ENDPARAMETERSY; add_keyword;
    id := 'FILE_TYPE       ';  sy := FILETYPESY;     add_keyword;
  end { init_keywords } ;
      

  procedure init_assertions;
    { init the assertion messages }
  begin
    assert_strings[0]   := 'Unimplemented assertion message             ';
    assert_strings[1]   := 'Reassignment of path element forbidden      ';
    assert_strings[2]   := 'Null path element found in add_path_elem    ';
    assert_strings[3]   := 'Path length exceeded in add_path_element    ';
    assert_strings[4]   := 'NULL string passed to evaluate_string       ';
    assert_strings[5]   := 'Tried to fix instance of non_UNDEFINED      ';
    assert_strings[6]   := 'Non vector signal has non-NIL subscript     ';
    assert_strings[7]   := 'String pointers not at end in insert_quo    ';
    assert_strings[8]   := 'Parse stack underflow                       ';
    assert_strings[9]   := 'Expected a constant describing the net      ';
    assert_strings[10]  := 'Expected ,                                  ';
    assert_strings[11]  := 'Body properties are not permitted here      ';
    assert_strings[12]  := 'Expected END_BODY symbol                    ';
    assert_strings[13]  := 'Pin properties are not permitted here       ';
    assert_strings[14]  := 'Expected pin name string                    ';
    assert_strings[15]  := 'Expected END_PIN symbol                     ';
    assert_strings[16]  := 'Expected END_PARAMETER                      ';
    assert_strings[17]  := 'Expected identifier = EXPR, not this        ';
    assert_strings[18]  := 'Expected a string                           ';
    assert_strings[19]  := 'Expected a constant                         ';
    assert_strings[20]  := 'Unexpected symbol in property body          ';
    assert_strings[21]  := 'Expected END_PROPERTY symbol                ';
    assert_strings[22]  := 'Expected BINDINGS                           ';
    assert_strings[23]  := 'Expected formal parameter name string       ';
    assert_strings[24]  := 'Expected actual parameter name string       ';
    assert_strings[25]  := 'Expected END_BINDINGS                       ';
    assert_strings[26]  := 'Expected macro name                         ';
    assert_strings[27]  := 'Expected END_INVOKE                         ';
    assert_strings[28]  := 'Expected MACRO                              ';
    assert_strings[29]  := 'Unexpected symbol in macro definition       ';
    assert_strings[30]  := 'Expected END_MACRO                          ';
    assert_strings[31]  := 'Illegal width in convert_into_binary        ';
    assert_strings[32]  := 'Expected signal name string                 ';
    assert_strings[33]  := 'X is already in the symbol table            ';
    assert_strings[34]  := 'Expected END                                ';
    assert_strings[35]  := 'Expected ;                                  ';
    assert_strings[36]  := 'Parameter not found in table: expansion     ';
    assert_strings[37]  := 'PATH property not found for invocation      ';
    assert_strings[38]  := 'Undefined formal CSP not found in list      ';
    assert_strings[39]  := 'Created abbreviation not valid              ';
    assert_strings[40]  := 'New synonym lst width incompatible w/old    ';
    assert_strings[41]  := 'Formal/actual list not NIL to evaluate      ';
    assert_strings[42]  := 'Illegal width to resolve undefined inst     ';
    assert_strings[43]  := 'Parameter is not a text macro!              ';
    assert_strings[44]  := 'Expected .                                  ';
    assert_strings[45]  := 'Left and right margins invalid              ';
    assert_strings[46]  := 'Path string has no room!  What happened?    ';
    assert_strings[47]  := 'Parameter is not a text macro!              ';
    assert_strings[48]  := 'Parameter not found in table: P1 status     ';
    assert_strings[49]  := 'Expected property value string              ';
    assert_strings[50]  := 'No appending bit in middle of sub list      '; 
    assert_strings[51]  := 'NIL args to copy subscript element          '; 
    assert_strings[52]  := 'Non-NIL args to copy subscript              '; 
    assert_strings[53]  := 'NIL subscript passed to bit in range        '; 
    assert_strings[54]  := 'NIL sig desc passed to width of sig desc    '; 
    assert_strings[55]  := 'NIL sig inst passed to size of sig inst     '; 
    assert_strings[56]  := 'NIL sig inst passed to width of sig inst    '; 
    assert_strings[57]  := 'NIL subscript passed to find subscript      '; 
    assert_strings[58]  := 'Too small ordinal into nth_bit_subscript    '; 
    assert_strings[59]  := 'Too big ordinal into nth_bit_subscript      '; 
    assert_strings[60]  := 'NIL CS passed to find_bit_in_CS             '; 
    assert_strings[61]  := 'Too big ordinal passed to find_bit_in_CS    '; 
    assert_strings[62]  := 'Bad sub to resolve_instance_of_parameter    '; 
    assert_strings[63]  := 'Non-empty sub to resolve_instance_of_par    '; 
    assert_strings[64]  := '<BAD> basescript to find_basescript         ';
    assert_strings[65]  := 'NIL SD or sig_def passed add_SD_onto_PCS    ';
    assert_strings[66]  := 'Too small ordinal into leading_n_bits...    '; 
    assert_strings[67]  := 'Too big ordinal into leading_n_bits_o...    '; 
    assert_strings[68]  := 'Invalid arguments into create_synonym       '; 
    assert_strings[69]  := 'NIL sig def passed to width_of_sig_def      '; 
    assert_strings[70]  := 'Non-NIL destination ptr in copy_property    '; 
    assert_strings[71]  := 'NIL formal passed to resolve_instance_of    ';
    assert_strings[72]  := 'NIL CSL to find youngest mtree node         '; 
    assert_strings[73]  := 'NIL sig inst to synonym_signal_instances    ';
    assert_strings[74]  := 'NIL arg passed to new_SD_for_create_syno    '; 
    assert_strings[75]  := 'Arg with undef width to create_synonyms     '; 
    assert_strings[76]  := 'Bad first argument passed to map_bit        '; 
    assert_strings[77]  := 'Bad second argument passed to map_bit       '; 
    assert_strings[78]  := 'Processed def into find_base_of_signal1     ';
    assert_strings[79]  := 'Bad bit subscript in find_base_of_signal    ';
    assert_strings[80]  := 'Bad rep_factor passed to replicate_CS       ';
    assert_strings[81]  := 'NIL sig inst into find_base_of_sig_insta    ';
    assert_strings[82]  := 'Real bad sub into find_base_of_sig_insta    ';
    assert_strings[83]  := 'Bad sub into find_base_of_signal_instanc    ';
    assert_strings[84]  := 'Incompatible widths in is_same_constant     ';
    assert_strings[85]  := 'Subscript already > width in insert_subs    ';
    assert_strings[86]  := 'Undefined width SD in augment_sig_descri    ';
    assert_strings[87]  := 'Undefined width SD in augment_sig_descri    ';
    assert_strings[88]  := 'Fix_no_width_signal failed to converge      ';
    assert_strings[89]  := 'Inconsistent width assign in insert_sub1    ';
    assert_strings[90]  := 'Incorrect sub on def & desc in quick_res    ';
    assert_strings[91]  := 'Sig def is undef and desc is VEC or UND     ';
    assert_strings[92]  := 'Out of range sub in synonym_1st_BD_to...    ';
    assert_strings[93]  := 'Convergence failure in fix_no_width_sig1    ';
    assert_strings[94]  := 'Ref of a bit of formal with undef. width    ';
    assert_strings[95]  := 'SI with undef width in insert_subscript1    ';
    assert_strings[96]  := 'No bit lists to insert_subscript1           ';
    assert_strings[97]  := 'Horrible error in synonym bag list          ';
    assert_strings[98]  := 'Width of CS <> width of synonyn element     ';
    assert_strings[99]  := 'Out of range sub in get_next_base_bit       ';
    assert_strings[100] := '1 bit lookup find_base_of_base_desc fail    ';
    assert_strings[101] := 'Out of range offset in subrange_occurs_i    ';
    assert_strings[102] := 'NIL base descriptro to find_base_of_base    ';
    assert_strings[103] := 'Bogus bit number in find_base_of_base_of    ';
    assert_strings[104] := 'Inst with undef width in find_base_of_ba    ';
    assert_strings[105] := 'Bogus bit number in find_base_of_base_of    ';
    assert_strings[106] := 'Quick_synonym failed on 1 bit wide args     ';
    assert_strings[107] := 'Net number not found in the net table       ';
    assert_strings[108] := 'Net already entered in the net table        ';
    assert_strings[109] := 'n is too big in nth_bit_of_signal_inst      ';
    assert_strings[110] := 'signal has undef width in nth_bit_sig_in    ';
    assert_strings[111] := 'n outside rang in nth_bit_signal_inst       ';
    assert_strings[112] := 'WHAT? delete_subscript_element(NIL) ???     ';
    assert_strings[113] := 'Expected identifier.                        ';
    assert_strings[114] := 'Expected #                                  ';
    assert_strings[115] := 'Expected $                                  ';
    assert_strings[116] := 'Unexpected end of data.                     ';
    assert_strings[117] := 'Expected &                                  ';
    assert_strings[118] := 'Expected +                                  ';
    assert_strings[119] := 'Expected D                                  ';
    assert_strings[120] := 'Expected :<time> or rest of page spec       ';
    assert_strings[121] := 'Expected id/macro lists or next page        ';
    assert_strings[122] := 'Expected #<constant> (a numbered id)        ';
    assert_strings[123] := 'Expected $<constant> (a numbered string)    ';
    assert_strings[124] := 'Dictionary entry number out of range        ';
    assert_strings[125] := 'Expected macro list or next page            ';
    assert_strings[126] := 'Expected parm list or next context          ';
    assert_strings[127] := 'Expected (                                  ';
    assert_strings[128] := 'Expected %                                  ';
    assert_strings[129] := 'Expected :R or next item.                   ';
    assert_strings[130] := 'Expected <constant> or $<constant>          ';
    assert_strings[131] := '                                            ';
    assert_strings[132] := 'Expected -                                  ';
    assert_strings[133] := 'NIL formal_actual to gather_pin_properti    ';
    assert_strings[134] := 'NIL macro to a UNIX directory routine       ';
    assert_strings[135] := 'NIL node^.called_by on non-root node        ';
    assert_strings[136] := 'Non-canonical bit order in synonyms tabl    ';
    assert_strings[137] := 'Base cannot be found for signal instance    ';
    assert_strings[138] := 'Too many passes in find base                ';
    assert_strings[139] := 'Undefined signal in find base               ';
    assert_strings[140] := 'Bit must occur on base_BD                   ';
    assert_strings[141] := 'NIL list of actuals in synonyms_actuals     ';
    assert_strings[142] := 'Error in build_SI_from_SD                   ';
    assert_strings[143] := 'Offset into scalar signal                   ';
    assert_strings[144] := 'NIL list of actuals in de_NC_return_actu    ';
    assert_strings[145] := 'PCS is too short in get_bit_of_PCS          ';
    assert_strings[146] := 'NIL PCS in get_bit_of_PCS                   ';
    assert_strings[147] := 'Bad property attr in old_copy_props_to_b    ';
    assert_strings[148] := 'nth_bit_sub ret FALSE in merge_subscrip     ';
    assert_strings[149] := 'NIL instance passed to nth_bit_subscr       ';
    assert_strings[150] := 'Expected version constant                   ';
    assert_strings[151] := 'Expected page number                        ';
    assert_strings[152] := 'Expected file name for macro definition     ';
    assert_strings[153] := 'UNNAMED signal cannot have width            ';
    assert_strings[154] := 'Duplicate parameter found in create_symb    ';
    assert_strings[155] := 'Structure has already been defined          ';
    assert_strings[156] := 'Duplicate text macro definition found       ';
    assert_strings[157] := 'Popped string has wrong parse state         ';
    assert_strings[158] := 'Expected )                                  ';
    assert_strings[159] := 'Key word already found in the name table    ';
    assert_strings[160] := 'TM recursion depth counter underflow        ';
    assert_strings[161] := 'Parse environment stack underflow           ';
    assert_strings[162] := 'Reserved text macro has invalid attribut    ';
    assert_strings[163] := 'NIL subscript for vector                    ';
    assert_strings[164] := 'Expected :                                  ';
    assert_strings[165] := 'Pin property found on non-existent pin      ';
    assert_strings[166] := 'Actual signal is NIL in output_expansion    ';
    assert_strings[167] := 'Non-NIL subscript in fix_instance_width     ';
    assert_strings[168] := 'Could not find old instance for VECTOR      ';
    assert_strings[169] := 'Tried to open two files at once             ';
    assert_strings[170] := 'Tried to open UNKNOWN file type             ';
    assert_strings[171] := 'Tried to close file type not open           ';
    assert_strings[172] := 'Tried to close UNKNOWN file type file       ';
    assert_strings[173] := 'Tried to read file not opened               ';
    assert_strings[174] := 'Constant found at non-root node             ';
    assert_strings[175] := 'Binding has NIL formal and pin name         ';
    assert_strings[176] := 'Expected general property prefix symbol     ';
    assert_strings[177] := 'Expected signal instance specifier          ';
    assert_strings[178] := 'Expected =                                  ';
    assert_strings[179] := 'Expected an identifier                      ';
    assert_strings[180] := 'Unknown scope specification                 ';
    assert_strings[181] := 'Expected >                                  ';
    assert_strings[182] := 'Expected formal param subscript const       ';
    assert_strings[183] := 'Drawing/directory specified more than once  ';
    assert_strings[184] := 'Expected a constant for scope spec          ';
    assert_strings[185] := 'Expected UNDEFINED subscript specifier      ';
    assert_strings[186] := 'Bit lists are not permitted in pin names    ';
    assert_strings[187] := 'Signal to be fixed has known polarity       ';
    assert_strings[188] := 'Scope is UNKNOWN in enter_def_into_stack    ';
    assert_strings[189] := 'Local signal on stack out of order          ';
    assert_strings[190] := 'Misc. parse error from a page compiler file ';
    assert_strings[191] := 'Interface signal not released from node     ';
    assert_strings[192] := 'Cannot fix assertion in signal stack        ';
    assert_strings[193] := 'Choose better base fails to decide          ';
    assert_strings[194] := 'Non-NIL stack in def passed to PUSH         ';
    assert_strings[195] := 'Could not find non-virtual signal           ';
    assert_strings[196] := 'Synonym of 2 non-virtual signals            ';
    assert_strings[197] := 'Actual signal is virtual!                   ';
    assert_strings[198] := 'Assertion error detected in check_and_fi    ';
    assert_strings[199] := 'Determining signal has UNKNOWN polarity     ';
    assert_strings[200] := 'Signal found without NN property            ';
    assert_strings[201] := 'Numbered token table bucket out of order    ';
    assert_strings[202] := 'Duplicate numbered tokens (same value)      ';
    assert_strings[203] := 'Looking for UNKOWN_NUMBERED_TOKEN ???       ';
    assert_strings[204] := '"New" token number already exists!!!        ';
    assert_strings[205] := 'Nil numbered token value encountered!       ';
    assert_strings[206] := 'Nil token field in token list.              ';
    assert_strings[207] := 'Reference to an undefined numbered tok !    ';
    assert_strings[208] := 'Numbered token dictionary overflow.         ';
    assert_strings[209] := 'Unrecognized numbered token type.           ';
    assert_strings[210] := 'Failed call to enter_expandable_id          ';
    assert_strings[211] := 'Enter_expandable_id(NIL) ????               ';
    assert_strings[212] := 'Unrecognized evaluation kind.               ';
    assert_strings[213] := 'Nil token field !!! (it is bad)             ';
    assert_strings[214] := 'Id number duplicated in exp_ids or props    ';
    assert_strings[215] := 'NIL TM_name to expand/substitue_text_mac    ';
    assert_strings[216] := 'Non-canonical base_BD to synonym_1st_BD_    ';
    assert_strings[217] := 'Expected !                                  ';
    assert_strings[218] := 'directory found under different auto-nam    ';
    assert_strings[219] := 'structure not counted in heap estimate      ';
    assert_strings[220] := 'Nil string passed as argument               ';
    assert_strings[221] := 'Nil name passed as argument                 ';
    assert_strings[222] := 'Unrecognized open mode                      ';
    assert_strings[223] := 'Unable to dup a file descriptor             ';
    assert_strings[224] := 'Illegal numbered token dictionary insert    ';
    assert_strings[225] := 'UNKNOWN_TOKEN_NUMBER found in table         ';
    assert_strings[226] := 'Expected sepcomp command                    ';
    assert_strings[227] := 'NIL version or page to read_macro_page      ';
    assert_strings[228] := 'Attempted to rewrite file ""                ';
    assert_strings[229] := 'Directory contains version with no pages    ';
    assert_strings[230] := 'NIL directory field in macro_entry          ';
    assert_strings[231] := 'Non-VECTOR instance to slice_of_instance    ';
    assert_strings[232] := 'NIL subs on VECTOR pin_name in output_ac    ';
    assert_strings[233] := 'illegal id in an id table                   ';
    assert_strings[234] := 'expected a parameter list                   ';
    assert_strings[235] := 'String length exceeded internally           ';
    assert_strings[236] := 'Redundant context definition entries        ';
    assert_strings[237] := 'non-null definition for undefined name!!    ';
    assert_strings[238] := 'illegal make_pass                           ';
    assert_strings[239] := 'number_non_leaf_nodes < 0                   ';
    assert_strings[240] := 'internal integer overflow                   ';
    assert_strings[241] := 'Severe problem with virtual stack ops       ';
    assert_strings[242] := 'nth_bit_of_instance FALSE in fix_basescr    ';
    assert_strings[243] := 'LOGIC prim read with new prim semantics     ';
    assert_strings[244] := 'Illegitimate AVL type                       ';
    assert_strings[245] := 'Mismatched AVL types                        ';
    assert_strings[246] := 'Equal strings have unequal pointers         ';
    assert_strings[247] := 'find_base_of_PCS returns NIL                ';
    assert_strings[248] := 'nth_bit_of_PCS FALSE                        ';
    assert_strings[249] := 'insertion into non-active dictionary        ';
    assert_strings[250] := 'Unable to create unique file name           ';
    assert_strings[251] := 'Signal with DECLARED scope encountered      ';
    assert_strings[252] := 'Algorithm for finding bus binding is broken ';
    assert_strings[253] := 'Unexpected Error while handling bit tap     ';
    assert_strings[254] := 'Underflow of critical section semaphore     ';
    assert_strings[255] := 'Bus binding not found for NAC check !!      ';
    

    parse_asserts := [9..30,32,34,35,44,49,107,108,113..132,150,153,158,
                      162,176..185,190,207,217,226,234];
  end { init_assertions } ;


  procedure init_errors;
    { init the error messages }
  begin
    error_strings[0]   := 'THIS ERROR IS ALWAYS SUPPRESSED             ';
    error_strings[1]   := 'Expected identifier                         ';
    error_strings[2]   := 'Expected =                                  ';
    error_strings[3]   := 'Not supported by ValidPAGECOMP              ';
    error_strings[4]   := 'Expected string or identifier               ';
    error_strings[5]   := 'Expected ,                                  ';
    error_strings[6]   := 'Unrecognized symbol                         ';
    error_strings[7]   := 'Expected )                                  ';
    error_strings[8]   := 'Expected =, <, >, <>, <= or >=              ';
    error_strings[9]   := 'Wrong file type for text macros             ';
    error_strings[10]  := 'Expected <                                  ';
    error_strings[11]  := 'Expected >                                  ';
    error_strings[12]  := 'Expected ;                                  ';
    error_strings[13]  := 'Expected :                                  ';
    error_strings[14]  := 'Unexpected symbol in integer expression     ';
    error_strings[15]  := 'Expected (                                  ';
    error_strings[16]  := 'Bit value invalid                           ';
    error_strings[17]  := 'Unknown SHAREABLE specification             ';
    error_strings[18]  := '                                            ';
    error_strings[19]  := '                                            ';
    error_strings[20]  := 'Unmatched closing comment character         ';
    error_strings[21]  := '                                            ';
    error_strings[22]  := 'String length exceeded                      ';
    error_strings[23]  := 'Illegal character found                     ';
    error_strings[24]  := 'Expression value overflow                   ';
    error_strings[25]  := 'Division by zero                            ';
    error_strings[26]  := 'PRIM in rule requires SCALD directory type  ';
    error_strings[27]  := 'Expected SPECIAL or PRIMITIVE               ';
    error_strings[28]  := 'PRIM (PART) not a legal SCALD directory type';
    error_strings[29]  := 'Extraneous junk after bit list              ';
    error_strings[30]  := 'Unexpected symbol in bit subscript          ';
    error_strings[31]  := 'Unknown REPORT specification                ';
    error_strings[32]  := 'Non-printing character found                ';
    error_strings[33]  := 'Expected a string                           ';
    error_strings[34]  := 'Comment not closed before end of input      ';
    error_strings[35]  := 'Specified parameter # > allowed # params    ';
    error_strings[36]  := 'Signal MUST have high assertion char        ';
    error_strings[37]  := 'Expected .                                  ';
    error_strings[38]  := 'File name has already been specified        ';
    error_strings[39]  := 'Undefined identifier in expression          ';
    error_strings[40]  := 'Expected END                                ';
    error_strings[41]  := 'Identifier length exceeded                  ';
    error_strings[42]  := 'Unknown debug control specifier             ';
    error_strings[43]  := 'Text macro parameter exceeds max length     ';
    error_strings[44]  := 'Constant width value out of range           ';
    error_strings[45]  := 'Directive has already been specified        ';
    error_strings[46]  := 'Duplicate global text macro definition      ';
    error_strings[47]  := 'Invalid specification for inheritance       ';
    error_strings[48]  := 'Unknown property attribute                  ';
    error_strings[49]  := 'Directive unsupported by SCALD compiler     ';
    error_strings[50]  := 'Extraneous junk at end of number            ';{non-parse}
    error_strings[51]  := 'Unknown compiler directive                  ';
    error_strings[52]  := 'Invalid specification for directive         ';
    error_strings[53]  := 'Input line exceeds maximum length           ';
    error_strings[54]  := 'Can''t begin signal name with ''(''            ';
    error_strings[55]  := 'Wrong file type for property attributes     ';
    error_strings[56]  := 'Text macro parameter cannot be found        ';
    error_strings[57]  := 'End of input before end of expression       ';
    error_strings[58]  := 'Extraneous characters at end of expr        ';
    error_strings[59]  := 'Identifier has not been defined             ';
    error_strings[60]  := 'Same shadow directory use more than once    ';
    error_strings[61]  := 'Radix must be in range 2..16                ';
    error_strings[62]  := 'Extraneous junk at end of menu version      ';
    error_strings[63]  := 'Extraneous junk at end of boolean expr      ';
    error_strings[64]  := 'Max text macro nesting depth exceeded       ';
    error_strings[65]  := 'Compile extension name is too long          ';
    error_strings[66]  := 'Compilation to .PRIM files not permitted    ';
    error_strings[67]  := 'Error in signal syntax specification        ';
    error_strings[68]  := 'Library file has already been specified     ';
    error_strings[69]  := 'Ill-formed cardinal tap body                ';
    error_strings[70]  := 'Version number is outside allowed range     ';
    error_strings[71]  := 'Page number is outside allowed range        ';
    error_strings[72]  := 'Duplicate page number                       ';
    error_strings[73]  := 'Tapped bit(s) not found in connected bus    ';
    error_strings[74]  := 'Multiple busses on cardinal tap body        ';
    error_strings[75]  := 'No named bus attached to cardinal tap body  ';
    error_strings[76]  := 'Bool expr already defined for this vers     ';
    error_strings[77]  := 'Specified version is not in directory       ';
    error_strings[78]  := 'Only MENU bodies are allowed here           ';
    error_strings[79]  := 'Expected a version 1 with MENU body(s)      ';
    error_strings[80]  := 'Illegal property on MENU body               ';
    error_strings[81]  := 'Illegal MENU property number                ';
    error_strings[82]  := 'Same MENU expr property found twice         ';
    error_strings[83]  := 'Expected signal name or constant            ';
    error_strings[84]  := 'Replication factor is out of range          ';
    error_strings[85]  := 'Expected FILE_TYPE specification            ';
    error_strings[86]  := 'File is not of the correct type             ';
    error_strings[87]  := 'Directory file name previously specified    ';
    error_strings[88]  := 'Illegal file name in drawing directory      ';
    error_strings[89]  := 'String not closed before the end of line    ';
    error_strings[90]  := '                                            ';
    error_strings[91]  := 'Expected shadow directory name              ';
    error_strings[92]  := 'Invalid (warnings and oversights only)      ';
    error_strings[93]  := 'Expected directory file name                ';
    error_strings[94]  := 'Invalid value for print width               ';
    error_strings[95]  := 'Drawings have not been written with 5.5     ';
    error_strings[96]  := 'Bit subscript on constant not permitted     ';
    error_strings[97]  := 'Unknown output file name                    ';
    error_strings[98]  := 'Extraneous junk at end of file              ';
    error_strings[99]  := 'This symbol cannot be used here             ';
    error_strings[100] := 'Can''t open specified expansion rules file   ';
    error_strings[101] := 'Drawing path name is missing closing )      ';
    error_strings[102] := 'Symbol must be one character                ';
    error_strings[103] := 'Library not found in master directory       ';
    error_strings[104] := 'Wrong FILE_TYPE for master library          ';
    error_strings[105] := 'Reserved text macro name                    ';
    error_strings[106] := 'Cannot find definition for text macro       ';
    error_strings[107] := 'Duplicate library entry in master lib       ';
    error_strings[108] := 'No SIZE in context for SIZEd drawing        ';
    error_strings[109] := 'Body properties are not allowed here        ';
    error_strings[110] := 'Undefined text macro (null value)           ';
    error_strings[111] := 'No directory was specified                  ';
    error_strings[112] := 'Separate AND single drawing compilation     ';
    error_strings[113] := 'Replication is not permitted on pin name    ';
    error_strings[114] := 'Text macro has already been defined         ';
    error_strings[115] := 'Same MENU version property found twice      ';
    error_strings[116] := 'Expanded string exceeds max string len      ';
    error_strings[117] := 'Textmacro and parameters exceeds max len    ';
    error_strings[118] := 'Expression value is empty                   ';
    error_strings[119] := 'NC is not permitted as a pin name           ';
    error_strings[120] := 'Path name exceeds maximum length            ';
    error_strings[121] := 'Path element name exceeds maximum length    ';
    error_strings[122] := 'Drawing has incompatible extensions         ';
    error_strings[123] := 'Selection expr and MENU expr mismatch       ';
    error_strings[124] := 'Versioned drawings not written w 7.0 GED    ';
    error_strings[125] := 'Pin properties are not permitted here       ';
    error_strings[126] := 'Text macro is not an identifier             ';
    error_strings[127] := 'ABBREV property not found for drawing       ';
    error_strings[128] := 'ABBREV value must be letters, digits & _    ';
    error_strings[129] := 'Menu entry for version is not permitted     ';
    error_strings[130] := 'Scalar reference to vector signal           ';
    error_strings[131] := 'Vector reference to scalar signal           ';
    error_strings[132] := 'Concatenated signal as pin name             ';
    error_strings[133] := 'This property has already been defined      ';
    error_strings[134] := 'Terminal drawing is not a primitive part    ';
    error_strings[135] := 'Cannot open compiler directives file        ';
    error_strings[136] := 'Signals cannot be attached to this body     ';
    error_strings[137] := 'Text macro nesting depth exceeded           ';
    error_strings[138] := 'Cannot open error documentation file        ';
    error_strings[139] := 'More than 1 selection expression is true    ';
    error_strings[140] := 'This signal cannot be DECLAREd              ';
    error_strings[141] := 'SIZE property on non SIZE-wide body         ';
    error_strings[142] := 'MENU bodies are not supported               ';
    error_strings[143] := 'Illegal rotation on this body               ';
    error_strings[144] := 'This body should not be given SIZE prop     ';
    error_strings[145] := 'Pin name does not exist                     ';
    error_strings[146] := 'Pin name does not have this bit             ';
    error_strings[147] := 'Root drawing specified as primitive.        ';
    error_strings[148] := 'No root drawing was specified               ';
    error_strings[149] := 'Synonyms must use single assertion          ';
    error_strings[150] := 'PERMIT attribute value invalid              ';
    error_strings[151] := 'This property not permitted on a SIGNAL     ';
    error_strings[152] := 'This property not permitted on a BODY       ';
    error_strings[153] := 'This property not permitted on a PIN        ';
    error_strings[154] := 'Signal''s assertion cannot be determined     ';
    error_strings[155] := 'Attempt to synonym 0 and 1                  ';
    error_strings[156] := 'Signal''s width cannot be determined         ';
    error_strings[157] := 'Error found in configuration file: fatal    ';
    error_strings[158] := 'Signal''s scope conflicts with complement    ';
    error_strings[159] := 'Synonym of unequal width signals            ';
    error_strings[160] := 'Cannot SIZE replicate plumbing drawings     ';
    error_strings[161] := '2 signals w/ timing assertions synonymed    ';
    error_strings[162] := 'Interface and local signals conflict        ';
    error_strings[163] := 'Local and global signals conflict           ';
    error_strings[164] := 'Global and interface signals conflict       ';
    error_strings[165] := 'This signal cannot have scope property      ';
    error_strings[166] := 'Cannot access CMPDRAW file for input        ';
    error_strings[167] := 'Cannot open synonyms file for input         ';
    error_strings[168] := 'Cannot close file                           ';
    error_strings[169] := 'Cannot open file for output                 ';
    error_strings[170] := 'Cannot open master library file             ';
    error_strings[171] := 'Bit subscript increment of 0 not allowed    ';
    error_strings[172] := 'Bit subscript should be right to left       ';
    error_strings[173] := 'Bit subscript should be left to right       ';
    error_strings[174] := 'Vector/scalar conflict between complements  ';
    error_strings[175] := 'Can''t use a remote shadow directory         ';
    error_strings[176] := 'PATH name is not unique                     ';
    error_strings[177] := 'Selection expr for drawing is FALSE         ';
    error_strings[178] := 'Max error value must be >= 1                ';
    error_strings[179] := 'Extraneous junk at end of signal            ';
    error_strings[180] := 'Parameter was declared twice                ';
    error_strings[181] := 'Cannot access drawing directory             ';
    error_strings[182] := 'Drawing title does not match directory      ';
    error_strings[183] := 'X_FIRST must be >= 0 (set to 0)             ';
    error_strings[184] := 'PIN_EQUIVALENT no longer supported          ';
    error_strings[185] := 'SIZE must be >= 0 (set to 1)                ';
    error_strings[186] := 'X_STEP must be > 0 (set to 1)               ';
    error_strings[187] := 'Assertion chk failure: save CMPLOG file     ';
    error_strings[188] := 'Parameters not permitted on this body       ';
    error_strings[189] := 'Timing assertion not allowed on pin name    ';
    error_strings[190] := 'No selection expression evaluates true      ';
    error_strings[191] := 'Drawing not found in the directories        ';
    error_strings[192] := 'PATH name element is not unique             ';
    error_strings[193] := 'No usable extension found for drawing       ';
    error_strings[194] := 'Text macro refers to itself (recursive)     ';
    error_strings[195] := 'Cannot open specified attributes file       ';
    error_strings[196] := 'Default value used for SIZE (1)             ';
    error_strings[197] := 'PATH property not found for body            ';
    error_strings[198] := 'Bit subscript on undefined width pin        ';
    error_strings[199] := 'Pin name conflicts with previous pin        ';
    error_strings[200] := 'Pin name and signal widths do not match     ';
    error_strings[201] := 'Signal fails bubble check on this pin       ';
    error_strings[202] := 'Pin name with NWC cannot have subscript     ';
    error_strings[203] := 'LOGIC primitive used as terminal drawing    ';
    error_strings[204] := 'Pin name cannot use signal negation         ';
    error_strings[205] := 'Cannot open DRAWING file                    ';
    error_strings[206] := 'Cannot open specified directory file        ';
    error_strings[207] := 'Cannot open syntax configuration file       ';
    error_strings[208] := 'Too many errors in this compile!            ';
    error_strings[209] := 'Cannot open specified text macro file       ';
    error_strings[210] := 'Primitive cannot have NWC pin               ';
    error_strings[211] := 'Pin name is vector but used as a scalar     ';
    error_strings[212] := 'A pin name cannot be a constant             ';
    error_strings[213] := 'Versioned drawing must have EXPR prop       ';
    error_strings[214] := 'String not closed before end of signal      ';
    error_strings[215] := 'Pin name is scalar but used as vector       ';
    error_strings[216] := 'PART not allowed; COMPILE LOGIC assumed     ';
    error_strings[217] := 'Fatal error(s) encountered - run stopped    ';
    error_strings[218] := 'Pin subscript must be a simple subrange     ';
    error_strings[219] := 'DECLARE bodies are no longer supported      ';
    error_strings[220] := 'PART_NAME property should not be used       ';
    error_strings[221] := 'Bodies with NWC cannot expand to parts      ';
    error_strings[222] := 'DELETE_DRAWING specifies unfound drawing    ';
    error_strings[223] := '                                            ';
    error_strings[224] := 'Extraneous junk at end of command line      ';
    error_strings[225] := '                                            ';
    error_strings[226] := 'Cannot initialise data services             ';
    error_strings[227] := 'Cannot open expansion file                  ';
    error_strings[228] := 'Incorrect use of seplink command            ';
    error_strings[229] := 'Illegal COMMAND value                       ';
    error_strings[230] := 'Can''t create shadow directory               ';
    error_strings[231] := 'Can''t open compiler-specified file          ';
    error_strings[232] := 'Unable to access schema file                ';
    error_strings[233] := '                                            ';
    error_strings[234] := 'Cannot access DESIGN file for output        ';
    error_strings[235] := 'Signal synonymed to its own complement      ';
    error_strings[236] := '                                            ';
    error_strings[237] := 'Cannot get file "last modified" time        ';
    error_strings[238] := 'Illegal hierarchical drawing recursion      ';


    error_strings[239] := 'Pin or pin bit has no \I signal             ';

    error_strings[240] := '.PRIM and .PART both found for drawing      ';
    error_strings[241] := 'Pin connected to its own complement         ';
    error_strings[242] := 'Different pins on bodies for same module    ';
    error_strings[243] := 'Compiler errors in a drawing                ';
    error_strings[244] := 'Needed module was not loaded                ';
    error_strings[245] := 'ABBREV property conflict in drawing         ';
    error_strings[246] := 'Unable to remove file                       ';
    error_strings[247] := 'Pages of version across SCALD dirs          ';
    error_strings[248] := 'Incorrect page expansion file syntax        ';
    error_strings[249] := '                                            ';
    error_strings[250] := 'Missing ValidPAGECOMP/LINKER results        ';
    error_strings[251] := 'Unrecognized command line argument          ';
    error_strings[252] := 'Illegal drawing directory in SCALD directory';

    error_strings[253] := 'More than 1 DEFAULT selection expression    ';
    error_strings[254] := 'Same special model in more than 1 directory ';
    error_strings[255] := 'Unable to successfully read expansion rules ';
    {New error messages added for data services}
    error_strings[256] := 'Unable to find directives in database.      ';
    error_strings[257] := 'Unable to find global TMs in database.      ';
    error_strings[258] := 'Unable to find prop attr  in database.      ';

    { initialize environment variables for error display }

    environment_stack := NIL;
    init_error_info;

    num_errors := 0;
    num_warnings := 0;
    num_oversights := 0;
    last_error := 0;
    indent := 4;  { actually only defined for the "current" error }

    ok_to_print_error := TRUE;
    errors_encountered := [];
    free_environments := NIL;
    exception_code := NULL_ERROR_CODE;

    { ------- error sets ------- }

    scan_past_errors := [1,2,4..8,10..13,15,33,37,40,83,85,93,179];
    fatal_errors := [65,67,100,111,112,120,135,148,157,166,169,
                     205,206,207,226, 228,229,234,238,252,255];
    warning_errors := [3,8,49,68,107,108,141,154,158,182,184,194,196,203,
		       239,246];
    oversight_errors := [37,40,41,80,92,95,97,123,127,134,140,143,
                         144,174,176,192,197,213,216,220,224,225,251,245];
    parse_errors := [1..48,51..53,55..59,61..68,83..87,89,90,92..94,
                     96,97,99,101..104,107,171..173,178..179,184,216,225,229,
		     248,252];
    echo_to_monitor_errors := [208,217];
    keep_the_page_dirty_errors := [181,191,193,247];
    scope_conflict_errors := [162,163,164];
    ignore_parse_errors := FALSE;
  end { init_errors } ;


  procedure init_sets;
    { initialize various constant sets }
    const
      FIRST_CHAR = 0;
      LAST_CHAR = 255;
    var
      c: char;
  begin
    mulops := [ASTERISK, SLASH, MODSY];
    addops := [PLUS, MINUS];
    relops := [EQUAL, NESY, LESSTHAN, LESY, GREATERTHAN, GESY];
      
    valid_chars[2]  := ['0','1'];
    valid_chars[3]  := valid_chars[2]  + ['2'];
    valid_chars[4]  := valid_chars[3]  + ['3'];
    valid_chars[5]  := valid_chars[4]  + ['4'];
    valid_chars[6]  := valid_chars[5]  + ['5'];
    valid_chars[7]  := valid_chars[6]  + ['6'];
    valid_chars[8]  := valid_chars[7]  + ['7'];
    valid_chars[9]  := valid_chars[8]  + ['8'];
    valid_chars[10] := valid_chars[9]  + ['9'];
    valid_chars[11] := valid_chars[10] + ['A'];
    valid_chars[12] := valid_chars[11] + ['B'];
    valid_chars[13] := valid_chars[12] + ['C'];
    valid_chars[14] := valid_chars[13] + ['D'];
    valid_chars[15] := valid_chars[14] + ['E'];
    valid_chars[16] := valid_chars[15] + ['F'];

    forbidden_symbols := [SEMI,LESSTHAN,GREATERTHAN,CONSTANT,PERCENT,SHARP];
    expression_symbols := [PLUS, MINUS, SLASH, LPAREN, RPAREN, ASTERISK];

    bitsubendsys := [COMMA, GREATERTHAN, ENDOFDATASY];
    propbeginsys := [PINSY, BODYSY, PARAMETERSY];

    allowed_key_words := [];
    schema_keysys := [ENDSY, FILETYPESY];
    expansion_keysys := [ENDSY, FILETYPESY];
    directives_keysys := [ENDSY];
    directory_keysys := [ENDSY, FILETYPESY];
    macrodef_keysys := [MACROSY..FILETYPESY];
    signal_keysys := [ORSY..MAXSY,LOW_ASSERTED_SY..NEGATION_SY];
    config_keysys := [LOW_ASSERTED_SY..NEGATION_SY];

    inheritance_attributes := [INHERIT_BODY, INHERIT_PIN, INHERIT_SIGNAL];
    signal_inheritance_attributes := [INHERIT_PIN, INHERIT_SIGNAL];
    permission_attributes := [PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY];
    default_attributes := [INHERIT_BODY, INHERIT_SIGNAL] +
                          permission_attributes;
    parameter_attributes := [IS_INT_PARAMETER, IS_PARAMETER];

    bodies_with_bindings := [USER_BODY, PIN_NAMES_BODY, DECLARE_BODY];

    for c := chr(FIRST_CHAR) to chr(LAST_CHAR) do
      begin
	islegal[c] := TRUE;
	isdigit[c] := FALSE;
	isidentchar[c] := FALSE;
	isupper[c] := FALSE;
        is_signal_name_terminator[c] := FALSE;
	upshift[c] := c;

	case c of
	  'a','b','c','d','e','f','g','h','i','j','k','l','m','n',
	  'o','p','q','r','s','t','u','v','w','x','y','z' :
	    upshift[c] := chr(ord(c) + ord('A') - ord('a'));

	  'A','B','C','D','E','F','G','H','I','J','K','L','M','N',
	  'O','P','Q','R','S','T','U','V','W','X','Y','Z' :
	    begin
	      isidentchar[c] := TRUE;
	      isupper[c] := TRUE;
	    end;

	  '0','1','2','3','4','5','6','7','8','9' :
	    begin
	      isdigit[c] := TRUE;
	      isidentchar[c] := TRUE;
	    end;

	  ' ','!','"','#','$','%','&','''','(',')','*','+',
	  ',','-','.','/',':',';','<','>','=','?','@','[',

	  '\', 


	  ']','^','{','|','}','~','_','`' : { ok } ;

	  OTHERWISE islegal[c] := FALSE;
	end;
      end;
    isidentchar['_'] := TRUE;
  end { init_sets } ;


  procedure init_linker_comm_structures;
    { init the variables associated with linker communication }
  begin
    sepcomp_list_root := NIL;
    current_sepcomp := NIL;
    last_sepcomp := NIL;
    temp_file_name := make_and_enter_string(DEFAULT_TEMP_FILE);
    compile_command_table[FIRST_COMPILE_COMMAND] := NIL;
    compile_command_table[COMPILE_ROOT]   := enter_name('ROOT            ');
    compile_command_table[COMPILE_SUB]    := enter_name('SEPCOMP         ');
    compile_command_table[CHECK_FOR_PRIM] := enter_name('PRIM            ');
    compile_command_table[STOP_AT_SUBCKT] := enter_name('SUBCKT          ');
    compile_command_table[LAST_COMPILE_COMMAND] := NIL;   
  end { init_linker_comm_structures } ;

  
  procedure init_page_expansion_structures;
    { init the expansion dictionaries }
  begin
    init_numbered_dictionary(expansion_id_dictionary, IDENTIFIER_NUMBER);
    init_numbered_dictionary(expansion_string_dictionary, STRING_NUMBER);
    invoke_path_table := NIL;
  end { init_page_expansion_structures } ;


  procedure init_schema_structures;
    { init the variables declared in for schema handling }
  begin
    with schema_of_drawing_being_compiled do
      begin
	init_numbered_dictionary(id_dictionary, IDENTIFIER_NUMBER);
	init_numbered_dictionary(string_dictionary, STRING_NUMBER);
	paged_schemas := NIL;
	used_global_TMs := NIL;
	contexts := NIL;
	file_name := nullstring;
	directory := NIL;
	file_accessible := FALSE;
	changed := FALSE;
	bubble_check := FALSE;
	used_properties := NIL;
	local_TMs := NIL;
	local_TMs_defined := FALSE;
      end;

    with paged_schema_of_this_page do
      begin
	next := NIL;
	drawing_type := NIL;
	version := 0;
	page := 0;
	expandable_ids := NIL;
	local_text_macros := NIL;
	dependencies := NIL;
      end;

    old_schema_page := NIL;  old_schema_page_parent := NIL;
  end { init_schema_structures } ;


  procedure init_string_structures;
    { init the table describing the discrete string lengths that can be
      created on the heap }
    var
      i: 1..33;                  { index into list of free strings }
      j: hash_string_range;      { index into the string table }
  begin
    for j := 0 to HASH_STRING_TABLE_SIZE do string_table[j] := NIL;

    free_pointers := NIL;
    for i := 1 to 33 do free_strings[i] := NIL;
    s_length[1] := 4;
    s_length[2] := 8;
    s_length[3] := 12;
    s_length[4] := 16;
    s_length[5] := 20;
    s_length[6] := 24;
    s_length[7] := 28;
    s_length[8] := 32;
    s_length[9] := 36;
    s_length[10] := 40;
    s_length[11] := 44;
    s_length[12] := 48;
    s_length[13] := 52;
    s_length[14] := 56;
    s_length[15] := 60;
    s_length[16] := 64;
    s_length[17] := 68;
    s_length[18] := 72;
    s_length[19] := 76;
    s_length[20] := 80;
    s_length[21] := 84;
    s_length[22] := 88;
    s_length[23] := 92;
    s_length[24] := 96;
    s_length[25] := 100;
    s_length[26] := 120;
    s_length[27] := 140;
    s_length[28] := 160;
    s_length[29] := 180;
    s_length[30] := 200;
    s_length[31] := 220;
    s_length[32] := 240;
    s_length[33] := 256;

    create_a_string(nullstring, 0);
  end { init_string_structures } ;


  procedure init_special_bodies;
    { init list of specially recognized macro body names }
    var
      i: scope_type;     { index into table }
  begin
    special_body_list[MENU_BODY     ] :=
                                    make_and_enter_string('MENU            ');
    special_body_list[DEFINE_BODY   ] :=
                                    make_and_enter_string('DEFINE          ');
    special_body_list[DRAWING_BODY  ] :=
                                    make_and_enter_string('DRAWING         ');
    special_body_list[PIN_NAMES_BODY] :=
                                    make_and_enter_string('PIN NAMES       ');
    special_body_list[DECLARE_BODY  ] :=
                                    make_and_enter_string('DECLARE         ');

    MEMORY_prim_name := make_and_enter_string('MEMORY          ');

    scope_table[UNKNOWN_SCOPE] := make_and_enter_string('UNKNOWN         ');
    scope_table[XINTERFACE   ] := make_and_enter_string('INTERFACE       ');
    scope_table[LOCAL        ] := make_and_enter_string('LOCAL           ');
    scope_table[GLOBAL       ] := make_and_enter_string('GLOBAL          ');
    scope_table[DECLARED     ] := make_and_enter_string('DECLARED        ');
    scope_table[SIG_CONST    ] := make_and_enter_string('SIG_CONST       ');

    for i := FIRST_SCOPE to LAST_SCOPE do
      scope_values[ord(i)] := i;
  end { init_special_bodies } ;


  procedure init_directives;
    { initialize the compiler directive tables and flags }
    const
      DUMMY_UMASK = 511; { should never be used, so it is intentionally
                           chosen to cause unaccessible files if used }
    var
      arg: xtring;       { sargv(1) }
      len: string_range; { (alpha) length of COMPERR command specifier }
      i: id_range;       { index into alpha and arg if of correct length }
      matches: boolean;  { TRUE if arg matches interesting alpha so far }
      c: char;           { current (upshifted) char of arg }

      std_lib_str: xtring; { variable used for processing std_lib_dsobjname }
      std_tm_str: xtring; { variable used for processing std_tm_dsobjname }
      error_doc_str: xtring; { used in processing the error_doc_dsobjname}
      config_str: xtring; { used in processing the sig_config_dsobjname }
      prop_str: xtring; { used in processing the std_prop_dsobjname }

    procedure add_to_table(directive: directive_type; name: alpha);
      { add the given directive to the table }
    begin
      compiler_directive[directive] := enter_name(name);
    end { add_to_table } ;


  begin { init_directives }
    add_to_table(ALLOW_PART_NAME_DIRECTIVE,         'ALLOW_PART_NAME ');
    add_to_table(AMUSING_MESSAGES_DIRECTIVE,        'AMUSING_MESSAGES');
    add_to_table(BUBBLECHECK_DIRECTIVE,             'BUBBLE_CHECK    ');
    add_to_table(CLASSGEN_DIRECTIVE,                'CLASS_GEN       ');
    add_to_table(COMMAND_DIRECTIVE,                 'COMMAND         ');
    add_to_table(COMPILE_DIRECTIVE,                 'COMPILE         ');
    add_to_table(CONFIG_FILE_DIRECTIVE,             'CONFIGURE_FILE  ');
    add_to_table(CONST_BUBBLE_CHK_DIRECTIVE,        'CONST_BUBBLE_CHK');
    add_to_table(CONTEXT_DIRECTIVE,                 'CONTEXT         ');
    add_to_table(DEBUG_DIRECTIVE,                   'DEBUG           ');
    add_to_table(DEBUG_AT_PATH_directive,           'DEBUG_AT_PATH   ');
    add_to_table(DEBUG_CONTROL_DIRECTIVE,           'DEBUG_CONTROL   ');
    add_to_table(DECLARE_BODIES_DIRECTIVE,          'DECLARE_BODIES  ');
    add_to_table(DEFAULT_FILTER_DIRECTIVE,          'DEFAULT_FILTER  ');
    add_to_table(DEFAULT_L_OR_G_DIRECTIVE,          'DEFAULT_SCOPE   ');
    add_to_table(DIRECTORY_DIRECTIVE,               'DIRECTORY       ');
    add_to_table(ENABLE_CARDINAL_TAP_DIRECTIVE,     'CARDINAL_TAP    ');
    add_to_table(ERROR_HELP_DIRECTIVE,              'ERROR_HELP      ');
    add_to_table(EVACUATE_DIRECTIVE,                'EVACUATE        ');
    add_to_table(EXPANSION_RULES_DIRECTIVE,         'EXP_RULES_FILE  ');
    add_to_table(FILTER_PROPERTY_DIRECTIVE,         'FILTER_PROPERTY ');
    add_to_table(HIERARCHICAL_NWC_DIRECTIVE,        'HIERARCHICAL_NWC');
    add_to_table(LIBRARY_DIRECTIVE,                 'LIBRARY         ');
    add_to_table(LOCALLY_GLOBAL_DIRECTIVE,          'LOCALLY_GLOBAL  ');
    add_to_table(MASTER_LIBRARY_DIRECTIVE,          'MASTER_LIBRARY  ');
    add_to_table(MAX_ERROR_DIRECTIVE,               'MAX_ERRORS      ');
    add_to_table(NET_PROCESSING_DIRECTIVE,          'NET_PROCESSING  ');
    add_to_table(OUTPUT_DIRECTIVE,                  'OUTPUT          ');
    add_to_table(OVERSIGHT_DIRECTIVE,               'OVERSIGHTS      ');
    add_to_table(PAGE_SYNONYM_DIRECTIVE,            'PAGE_SYNONYM    ');
    add_to_table(PASS_PROPERTY_DIRECTIVE,           'PASS_PROPERTY   ');
    add_to_table(PASSWORD_DIRECTIVE,                'PASSWORD        ');
    add_to_table(PERMIT_NO_ASSERTION_DIRECTIVE,     'PERMIT_NO_ASSERT');
    add_to_table(PICK_DIRECTIVE,                    'PICK            ');
    add_to_table(PRIMITIVE_DIRECTIVE,               'PRIMITIVE       ');
    add_to_table(PROPERTY_DIRECTIVE,                'PROPERTY_FILE   ');
    add_to_table(PRINT_WIDTH_DIRECTIVE,             'PRINT_WIDTH     ');
    add_to_table(READ_ALL_UDIRS_DIRECTIVE,          'READ_ALL_UDIRS  ');
    add_to_table(REPORT_DIRECTIVE,                  'REPORT          ');
    add_to_table(REPORT_UNKASSERT_DIRECTIVE,        'REPORT_UNKASSERT');
    add_to_table(ROOT_DIRECTIVE,                    'ROOT_DRAWING    ');
    add_to_table(SEPARATE_COMPILE_DIRECTIVE,        'SEPARATE_COMPILE');
    add_to_table(SHADOW_ROOT_DIRECTIVE,             'SHADOW_ROOT     ');
    add_to_table(SHAREABLE_DIRECTIVE,               'SHAREABLE       ');
    add_to_table(SINGLE_LEVEL_DIRECTIVE,            'SINGLE_DRAWING  ');
    add_to_table(SUPPRESS_DIRECTIVE,                'SUPPRESS        ');
    add_to_table(TOKENIZE_PARAMS_DIRECTIVE,         'TOKENIZE_PARAMS ');
    add_to_table(TEXT_MACRO_DIRECTIVE,              'TEXT_MACRO_FILE ');
    add_to_table(WARN_DIRECTIVE,                    'WARNINGS        ');
       
    output_file[CMPLST_FILE    ] := enter_name('LIST            ');
    output_file[CMPEXP_FILE    ] := enter_name('EXPAND          ');
    output_file[CMPERR_FILE    ] := enter_name('ERROR           ');
    output_file[CMPSYN_FILE    ] := enter_name('SYNONYM         ');
    output_file[CHIPS_FILE     ] := enter_name('CHIPS           ');
    output_file[CMPHIER_FILE   ] := enter_name('HIERARCHICAL    ');

    SCALD_only_output_files := [CMPHIER_FILE];

    command_value[FIRST_COMMAND  ] := null_name;
    command_value[SEPCOMP_COMMAND] := enter_name('SEPCOMP         ');
    command_value[SEPLINK_COMMAND] := enter_name('SEPLINK         ');
    command_value[COMPERR_COMMAND] := enter_name('COMPERR         ');
    command_value[LAST_COMMAND   ] := null_name;

    command := SEPCOMP_COMMAND;
    if sargc > 1 then 
      begin
        len := alpha_length(command_value[COMPERR_COMMAND]^.name);
        sargv(1, arg);
	if ord(arg^[0]) = len then
	  begin
	    matches := TRUE;
	    for i := 1 to len do
	      begin
	        c := upshift[arg^[i]];
		if c <> command_value[COMPERR_COMMAND]^.name[i] then
		  matches := FALSE;
	      end;
	    if matches then command := COMPERR_COMMAND;
	  end;
      end;

    shareable.values[FIRST_SHAREABLE_VALUE] := null_name;
    shareable.values[DEFAULT_SHARING      ] := enter_name('OFF             ');
    shareable.values[GROUP_SHARING        ] := enter_name('GROUP           ');
    shareable.values[GLOBAL_SHARING       ] := enter_name('ALL             ');
    shareable.values[LAST_SHAREABLE_VALUE ] := null_name;

    shareable.umasks[FIRST_SHAREABLE_VALUE] := DUMMY_UMASK;
    shareable.umasks[DEFAULT_SHARING      ] := DUMMY_UMASK; { not used }
    shareable.umasks[GROUP_SHARING        ] := 2;
    shareable.umasks[GLOBAL_SHARING       ] := 0;
    shareable.umasks[LAST_SHAREABLE_VALUE ] := DUMMY_UMASK;

    found_debug_password := FALSE;
    ROOT_specified_in_command_line := FALSE;
    TYPE_specified_in_command_line := FALSE;
    COMMAND_specified_in_command_line := FALSE;
    CONTEXT_specified_in_command_line := FALSE;

    analog_designer_compile := FALSE;

    debug_directives := [DEBUG_DIRECTIVE,
                         DEBUG_AT_PATH_DIRECTIVE,
                         DEBUG_CONTROL_DIRECTIVE];

    one_time_directives := [succ(FIRST_DIRECTIVE)..pred(LAST_DIRECTIVE)] -
                           debug_directives -
                           [DIRECTORY_DIRECTIVE,
                            FILTER_PROPERTY_DIRECTIVE,
                            LIBRARY_DIRECTIVE,
			    EXPANSION_RULES_DIRECTIVE,
                            MASTER_LIBRARY_DIRECTIVE,
                            OUTPUT_DIRECTIVE,
                            PASS_PROPERTY_DIRECTIVE,
                            PRIMITIVE_DIRECTIVE,
                            PROPERTY_DIRECTIVE,
			    PICK_DIRECTIVE,
                            REPORT_DIRECTIVE,
			    SHADOW_ROOT_DIRECTIVE,
			    SHAREABLE_DIRECTIVE,
                            SUPPRESS_DIRECTIVE,
                            TEXT_MACRO_DIRECTIVE];

    file_name_directives := [CONFIG_FILE_DIRECTIVE,
                             DIRECTORY_DIRECTIVE,
                             EXPANSION_RULES_DIRECTIVE,
                             MASTER_LIBRARY_DIRECTIVE,
                             PROPERTY_DIRECTIVE,
			     SHADOW_ROOT_DIRECTIVE,
                             TEXT_MACRO_DIRECTIVE];

    root_macro_name := nullstring;
    module_being_compiled := NIL;
    page_being_compiled := 0;
    version_being_compiled := 0;
    context_being_compiled := NIL;
    current_compiled_context := NIL;
    specified_context := NIL;
    shadow_root := nullstring;

    default_configuration_file := nullstring;
    error_documentation_file := nullstring;
    standard_library_file_name := nullstring;
    standard_text_macro_file := nullstring;
    standard_property_file := nullstring;

    enable_cardinal_tap := TRUE;
    allow_missing_high_assertion := FALSE;
    allow_PART_NAME_property := TRUE;
    tokenize_params := FALSE;
    report_unknown_assertions := FALSE;

    suppress_errors := [0];
    display_warnings := DEFAULT_WARNINGS;
    display_oversights := DEFAULT_OVERSIGHTS;
    bubble_check := DEFAULT_BUBBLE_CHECK;
    const_bubble_check := DEFAULT_CONST_BUBBLE_CHECK;
    max_errors := DEFAULT_MAX_ERRORS;
    scope_is_local := DEFAULT_SCOPE_IS_LOCAL;
    left_to_right := DEFAULT_LEFT_TO_RIGHT;
    display_error_doc := TRUE;
    net_processing := TRUE;
    force_primitives := NIL;
    produce_amusing_messages := FALSE;
    single_level_compile := FALSE;  { used by comperr -- ignored by
                                      page compiler }

    specified_compile_type := LOGIC_compile_type;

    print_width := MAX_PRINT_WIDTH;

    create_a_string(config_str, MAX_STRING_LENGTH);
    if sig_config_dsobjname(config_str) <> 0 then
      begin
        copy_string(config_str, default_configuration_file);
	configuration_file := default_configuration_file;
      end;
    config_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(config_str);

    create_a_string(error_doc_str, MAX_STRING_LENGTH);
    if error_documentation_dsobjname(error_doc_str) <> 0 then
      begin
        copy_string(error_doc_str, error_documentation_file);
      end;
    error_doc_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(error_doc_str);

    create_a_string(std_lib_str, MAX_STRING_LENGTH);
    if standard_lib_dsobjname(std_lib_str) <> 0 then 
      begin
        copy_string(std_lib_str, standard_library_file_name);
      end;
    std_lib_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(std_lib_str);

    create_a_string(std_tm_str, MAX_STRING_LENGTH);
    if textmacro_dsobjname(std_tm_str) <> 0 then 
      begin
        copy_string(std_tm_str, standard_text_macro_file);
      end;
    std_tm_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(std_tm_str);

    create_a_string(prop_str, MAX_STRING_LENGTH);
    if std_prop_dsobjname(prop_str) <> 0 then 
      begin
        copy_string(prop_str, standard_property_file);
      end;
    prop_str^[0] := chr(MAX_STRING_LENGTH);
    release_string(prop_str);

    { used by the add package to initialise the master library }

    selection_exceptions := NIL;
    selecting_module := FALSE;

    property_file := NIL;
    text_macro_file := NIL;
    expansion_rules_file := NIL;
    master_library_file := NIL;

    PrintCmpLst  := FALSE;
    PrintCmpErr  := FALSE;

    files_to_generate := [succ(FIRST_FILE_NAME)..pred(LAST_FILE_NAME)] -
                         [Chips_file, CmpHier_file, CmpErr_file];

    properties_assigned_filters := NIL;
    read_all_UNIX_directories := FALSE;

    specified_severity := WARNING_SEVERITY; { for COMPERR }
  end { init_directives } ;


  procedure init_report_tables;
    { initialize the report directive tables }
  begin
    reports_to_generate := [(*PATH_NAMES*)];

    report_type_table[PATH_NAMES] := enter_name('PATH_NAMES      ');
    report_type_table[HIERARCHY ] := enter_name('HIERARCHY       ');
    report_type_table[SUMMARY   ] := enter_name('SUMMARY         ');
    SCALD_only_reports := [PATH_NAMES, SUMMARY];
  end { init_report_tables } ;


  procedure init_plumbing_directory;
    { initialize the macro directories  }
    var
      i: plumbing_table_range;
  begin
    for i := 0 to LAST_PLUMBING_BUCKET do plumbing_table[i] := NIL;
  end { init_plumbing_directory } ;


  procedure init_lexical_analyzer;
    { initialize the lexical analyzer }
    var
      i: radix_range;     { index into the table of radix digit sizes (bits) }
  begin
    id.next := NIL;
    sy := nullsy;
    const_val := 0;
    const_width := 0;
    read_state := FINIT;
    stack_top := 0;  parse_stack_pointer := 1;
    line_pos := 0;
    last_sym_pos := 0;
    upper_case_strings := TRUE;
    how_to_parse := PARSE_SEPARATELY;
    copy_input := FALSE;
    current_pos := 0;
    copy_pos := 0;
    current_file := UNKNOWN_FILE;
    parse_SCALDconstants := TRUE;

    create_a_string(lex_string,   MAX_STRING_LENGTH);
    create_a_string(input_buffer, MAX_STRING_LENGTH);
    create_a_string(instring,     MAX_STRING_LENGTH);
    create_a_string(last_string,  MAX_STRING_LENGTH);
    instring^[0] := chr(0);  last_string^[0] := chr(0);

    allow_TM_expansion := default_TM_expansion;
    TM_depth := 1;
    text_macro_recursion := FALSE;

    subrangesy := DOTDOTSY;  fieldsy := COLON;

    for i := MIN_RADIX to MAX_RADIX do
      radix_width[i] := round(ln(i) / 0.6931471805 + 0.4);   { ceil log2(i) }
  end { init_lexical_analyzer } ;


  procedure init_constants;
    { init some global constants }
  begin
    page_expansion_file_name := nullstring;
    page_list_file_name := nullstring;
  end { init_constants } ;


  procedure init_symbols;
    { initialize symbol constants and CONFIGURE directive }
  begin
    configure_specifiers[CONFIGURE_SUBRANGE      ] :=
                                               enter_name('SUBRANGE        ');
    configure_specifiers[CONFIGURE_BIT_ORDERING  ] :=
                                               enter_name('BIT_ORDERING    ');
    configure_specifiers[CONFIGURE_LOW_ASSERTED  ] :=
                                               enter_name('LOW_ASSERTION   ');
    configure_specifiers[CONFIGURE_HIGH_ASSERTED ] :=
                                               enter_name('HIGH_ASSERTION  ');
    configure_specifiers[CONFIGURE_NEGATION      ] :=
                                               enter_name('NEGATION        ');
    configure_specifiers[CONFIGURE_NAME_PREFIX   ] :=
                                               enter_name('NAME_PREFIX     ');
    configure_specifiers[CONFIGURE_GENERAL_PREFIX] :=
                                               enter_name('GENERAL_PREFIX  ');
    configure_specifiers[CONFIGURE_CONCATENATION ] :=
                                               enter_name('CONCATENATION   ');

    signal_negation_symbol         := MINUS;
    signal_negation_char           := '-';

    signal_is_asserted_low_symbol  := ASTERISK;
    signal_is_asserted_low_char    := '*';

    signal_is_asserted_high_symbol := NULLSY;
    signal_is_asserted_high_char   := chr(255);

    name_property_prefix_symbol    := EXCLAMATION;
    name_property_prefix_char      := '!';

    general_property_prefix_symbol := BACKSLASH;
    general_property_prefix_char   := DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR;

    concatenation_symbol           := COLON;
    concatenation_char             := ':';

    class_name_separator_symbol    := DOLLAR;
    text_macro_delimiter_symbol    := PERCENT;

    signal_name_end_sys := [signal_is_asserted_low_symbol,
                            signal_is_asserted_high_symbol,
                            general_property_prefix_symbol,
                            concatenation_symbol,
                            ENDOFDATASY];
  end { init_symbols } ;


  procedure init_file_types;
    { initialize table of file types }
  begin
    file_type_list[MACRO_DEFINITION   ] := enter_name('MACRO_DEFINITION');
    file_type_list[CONNECTIVITY       ] := enter_name('CONNECTIVITY    ');
    file_type_list[SPECIAL_TEXT_MACROS] := enter_name('TEXT_MACROS     ');
    file_type_list[PROPERTY_ATTRIBUTES] := enter_name('ATTRIBUTES      ');
    file_type_list[CONFIGURATION_SPEC ] := enter_name('CONFIGURATION   ');
    file_type_list[MASTER_LIBRARY     ] := enter_name('MASTER_LIBRARY  ');
    file_type_list[SCHEMA_FILE        ] := enter_name('SCHEMA          ');
    file_type_list[EXPANSION_FILE     ] := enter_name('EXPANSION       ');
  end { init_file_types } ;


  procedure init_scalars;
    { initialize standard scalars }
  begin
    macro_def_list_root := NIL;  root_macro_def := NIL;
    unique_PATH_number := 0;
    unique_NC_number := 0;
    unique_NET_ID_number := 0;
    directory_list_root := NIL;
    library_list_root := NIL;
    current_mtree_node := NIL;
    mtree_root := NIL;

    column := 0;     { current output column }
  end { init_scalars } ;


  procedure init_debug_controls;
    { initialize debug flags and directives }


    procedure add_specifier(specifier: debug_controls; name: alpha);
      { add a debug specifier to table }
    begin
      debug_control_specifier[specifier] := enter_name(name);
    end { add_specifier } ;


  begin { init_debug_controls }
    debug := FALSE;
    debugging := FALSE;
    debug_1 := FALSE;
    debug_2 := FALSE;
    debug_3 := FALSE;
    debug_4 := FALSE;
    debug_5 := FALSE;
    debug_6 := FALSE;
    debug_7 := FALSE;
    debug_8 := FALSE;
    debug_9 := FALSE;
    debug_10 := FALSE;
    debug_11 := FALSE;
    debug_12 := FALSE;
    debug_13 := FALSE;
    debug_14 := FALSE;
    debug_15 := FALSE;
    debug_16 := FALSE;
    debug_17 := FALSE;
    debug_18 := FALSE;
    debug_19 := FALSE;
    debug_20 := FALSE;
    debug_21 := FALSE;
    debug_22 := FALSE;
    debug_23 := FALSE;
    debug_24 := FALSE;
    debug_25 := FALSE;
    debug_26 := FALSE;
    debug_27 := FALSE;
    debug_28 := FALSE;
    debug_29 := FALSE;
    debug_30 := FALSE;
    debug_31 := FALSE;
    debug_32 := FALSE;
    debug_33 := FALSE;
    debug_34 := FALSE;
    debug_35 := FALSE;
    debug_36 := FALSE;
    debug_37 := FALSE;
    debug_38 := FALSE;
    debug_39 := FALSE;
    debug_40 := FALSE;

    add_specifier(control_dumptree         , 'DUMPTREE        ');
    add_specifier(control_dumpsignals      , 'DUMPSIGNALS     ');
    add_specifier(control_printmacros      , 'PRINTMACROS     ');
    add_specifier(control_printdirectory   , 'PRINTDIRECTORY  ');
    add_specifier(control_printhistograms  , 'PRINTHISTOGRAMS ');
    add_specifier(control_dumpsigdeflist   , 'DUMPSIGDEFLIST  ');
    add_specifier(control_dump_all_names   , 'DUMP_ALL_NAMES  ');
    add_specifier(control_erule_xface      , 'ERULE           ');

    debug_at_path := FALSE;  undebug_at_path := FALSE;
    path_for_debug := nullstring;  path_for_undebug := nullstring;
    debug_flags := [];  undebug_flags := [];
    dumptree_ok := FALSE;
    dumpsignals_ok := FALSE;
    printmacros_ok := FALSE;
    printdirectory_ok := FALSE;
    dumpsigdeflist_ok := FALSE;
    dump_all_names_ok := FALSE;
    trace_erule_xface := FALSE;

    histograms := [];
    histogram_specifiers[directory_histogram   ] :=
                                               enter_name('DIRECTORY       ');
    histogram_specifiers[signal_histogram      ] :=
                                               enter_name('SIGNAL          ');
    histogram_specifiers[name_table_histogram  ] :=
                                               enter_name('NAME_TABLE      ');
    histogram_specifiers[string_table_histogram] :=
                                               enter_name('STRING_TABLE    ');
  end { init_debug_controls } ;


  procedure init_free_lists;
    { initialize lists of "free" structures }
  begin
    free_signal_instances := NIL;
    free_signal_definitions := NIL;
    free_signal_definition_lists := NIL;
    free_subscripts := NIL;

    free_simple_signals := NIL;
    free_synonym_signals := NIL;
    free_formal_actual_lists := NIL;
    free_actual_lists := NIL;
    free_signal_descriptors := NIL;
    free_signal_descriptors := NIL;
    free_identifiers := NIL;
    free_properties := NIL;
    free_invoke_lists := NIL;
    free_base_descriptors := NIL;
    free_basescripts := NIL;
    free_subscript_properties := NIL;
    free_bit_properties := NIL;
    free_propertied_CSs := NIL;
    free_net_descriptors := NIL;
    free_net_tables := NIL;
    free_numbered_tokens := NIL;
    free_numbered_token_lists := NIL;
    free_text_macros := NIL;
    free_expandable_ids := NIL;
    free_paged_schemas := NIL;
    free_parameters := NIL;
    free_context_definitions := NIL;
    free_module_lists := NIL;
    free_dependency_lists := NIL;
    free_sepcomp_lists := NIL;
    free_mtree_nodes := NIL;
    free_signal_entrys := NIL;
    free_bindings_lists := NIL;
    free_macro_defs := NIL;
    free_clear_text_actual_lists := NIL;
    free_signal_lists := NIL;
    free_avls := NIL;
    free_signal_instance_lists := NIL;
    free_compiled_context_lists := NIL;
    free_property_attributes := NIL;
  end { init_free_list } ;


  procedure init_signals;
    { initialize signal descriptors }
    var
      i: signal_table_range;    { index into the signal table }
  begin
    for i := 0 to SIGNAL_TABLE_SIZE do  signal_table[i] := NIL;

    NC_signal := make_and_enter_string(NO_CONNECT_signal);
    Zero_signal := make_and_enter_string('0               ');
    One_signal := make_and_enter_string('1               ');
  end { init_signals } ;


  procedure init_special_names;
    { initialize some special names }
  begin
    SEPARATE_COMPILE_place_holder :=
                                    make_and_enter_string('*               ');

    FLAG_BODY_string := make_and_enter_string('FLAG_BODY       ');

    COMMENT_string := make_and_enter_string('COMMENT         ');

    PLUMBING_string := make_and_enter_string('PLUMBING        ');

    TRUE_string := make_and_enter_string('TRUE            ');

    FALSE_string := make_and_enter_string('FALSE           ');

    DEFAULT_string := make_and_enter_string('DEFAULT         ');

    PASS_string := make_and_enter_string('PASS            ');

    FILTER_string := make_and_enter_string('FILTER          ');

    SIZE_string := make_and_enter_string(SIZE_prop_name^.name);

    TIMES_string := make_and_enter_string(TIMES_prop_name^.name);

    X_FIRST_string := make_and_enter_string(X_FIRST_identifier^.name);

    X_STEP_string := make_and_enter_string(X_STEP_identifier^.name);

    X_string := make_and_enter_string(X_identifier^.name);    

    CLOSED_string := make_and_enter_string(CLOSED_alpha);

    DEFINE_string := make_and_enter_string(DEFINE_alpha);

    default_SIZE_string := make_and_enter_string(default_SIZE);

    default_X_FIRST_string := make_and_enter_string(default_X_FIRST);

    default_X_STEP_string := make_and_enter_string(default_X_STEP);

    default_X_STEP_for_leaf_string :=
                               make_and_enter_string(default_X_STEP_for_leaf);

    default_X_string := make_and_enter_string(default_X);

    special_pin_name_prefix := make_and_enter_string(LOCAL_signal_prefix);
  end { init_special_names } ;


  procedure init_statistics;
    { initialize structure statistics }
    var
      i: heap_structures;     { index into the table of heap usage }
  begin
    for i := succ(FIRST_HEAP_STRUCTURE) to pred(LAST_HEAP_STRUCTURE) do
      begin  heap_usage[i].number := 0;  heap_usage[i].size := 0;  end;

    total_number_nodes := 0;
    number_terminal_nodes := 0;
    number_leaf_nodes := 0;

    number_global_signals := 0;
    number_local_signals := 0;
    number_interface_signals := 0;
    number_unnamed_signals := 0;
    number_signal_instances := 0;
    number_non_interface_signal_instances := 0;
    total_number_signals := 0;

    number_interfaces_resolved := 0;
    number_quick_resolved := 0;
  end { init_statistics } ;


  procedure init_built_in_identifier_names;
    { initialize predefined identifiers }
    var
      i: name_table_range;       { index into the name table }
  begin
    for i := 0 to NAME_TABLE_SIZE do name_table[i] := NIL;

    UNDEFINED_identifier      := enter_name('UNDEFINED       ');
    ALL_identifier            := enter_name('ALL             ');

    ABBREV_prop_name          := enter_name('ABBREV          ');
    PATH_prop_name            := enter_name('PATH            ');
    SIZE_prop_name            := enter_name('SIZE            ');
    TIMES_prop_name           := enter_name('TIMES           ');
    EXPR_prop_name            := enter_name('EXPR            ');
    TITLE_prop_name           := enter_name('TITLE           ');
    VERSION_prop_name         := enter_name('VERSION         ');
    SIG_NAME_prop_name        := enter_name('SIG_NAME        ');
    AUTO_GEN_prop_name        := enter_name('AUTO_GEN        ');
    SCOPE_prop_name           := enter_name('SCOPE           ');
    NO_WIDTH_prop_name        := enter_name('NOWIDTH         ');
    NO_BUBBLE_prop_name       := enter_name('NOBUBBLE        ');
    BUBBLED_prop_name         := enter_name('BUBBLED         ');
    CARDINAL_TAP_prop_name    := enter_name('BN              ');
    OUTPUT_TYPE_prop_name     := enter_name('OUTPUT_TYPE     ');
    NO_ASSERT_prop_name       := enter_name('NOASSERT        ');
    REPLICATION_prop_name     := enter_name('REP             ');
    TERMINAL_prop_name        := enter_name('TERMINAL        ');
    TERMINAL_prop_name^.kind := TERMINAL_prop_name^.kind + [IS_ET_CONTROL];
    NEEDS_NO_SIZE_prop_name   := enter_name('NEEDS_NO_SIZE   ');
    COMMENT_BODY_prop_name    := enter_name('COMMENT_BODY    ');
    HAS_FIXED_SIZE_prop_name  := enter_name('HAS_FIXED_SIZE  ');
    BODY_TYPE_prop_name       := enter_name('BODY_TYPE       ');
    BODY_TYPE_prop_name^.kind := BODY_TYPE_prop_name^.kind + [IS_ET_CONTROL];
    NET_ID_prop_name          := enter_name('NN              ');
    XY_prop_name              := enter_name('XY              ');
    DIRECTORY_prop_name       := enter_name('DIR             ');
    ROTATION_prop_name        := enter_name('ROT             ');
    VER_prop_name             := enter_name('VER             ');
    CONTEXT_prop_name         := enter_name('CONTEXT         ');
    WARNING_prop_name         := enter_name('WARNING         ');
    OVERSIGHT_prop_name       := enter_name('OVERSIGHT       ');
    ERROR_prop_name           := enter_name('ERROR           ');
    DRAWING_prop_name         := enter_name('DRAWING         ');
    PAGE_prop_name            := enter_name('PAGE            ');
    TYPE_prop_name            := enter_name('TYPE            ');
    PATH_NAME_prop_name       := enter_name('PATH_NAME       ');
    PART_NAME_prop_name       := enter_name('PART_NAME       ');
    BODY_NAME_prop_name       := enter_name('BODY_NAME       ');
    TIME_prop_name            := enter_name('TIME            ');

    SIGNAL_prop_name          := enter_name('SIGNAL          ');
    PIN_prop_name             := enter_name('PIN             ');
    BODY_prop_name            := enter_name('BODY            ');
    SUBCKT_prop_name          := enter_name('SUBCKT          ');
    PRIM_TYPE_prop_name       := enter_name('PRIM_TYPE       ');
    PRIM_FILE_prop_name       := enter_name('PRIM_FILE       ');

    SIM_compile_type          := enter_name('SIM             ');
    LOGIC_compile_type        := enter_name('LOGIC           ');
    PART_extension_name       := enter_name('PART            ');
    PRIM_extension_name       := enter_name('PRIM            ');

    PRIMITIVE_specifier       := enter_name('PRIMITIVE       ');
    SPECIAL_specifier         := enter_name('SPECIAL         ');
 
    null_name                 := enter_name('                ');
    LOCAL_specifier           := enter_name('LOCAL           ');
    GLOBAL_specifier          := enter_name('GLOBAL          ');
    ON_specifier              := enter_name('ON              ');
    OFF_specifier             := enter_name('OFF             ');
    L_to_R_specifier          := enter_name('LEFT_TO_RIGHT   ');
    R_to_L_specifier          := enter_name('RIGHT_TO_LEFT   ');
    X_FIRST_identifier        := enter_name('X_FIRST         ');
    X_STEP_identifier         := enter_name('X_STEP          ');
    X_identifier              := enter_name('X               ');
    X_identifier^.kind := [RESERVED, IS_PARAMETER];

    SS_identifier             := enter_name('S               ');
    D_identifier              := enter_name('D               ');
    I_identifier              := enter_name('I               ');
    R_identifier              := enter_name('R               ');

    E_identifier              := enter_name('E               ');
    P_identifier              := enter_name('P               ');
    C_identifier              := enter_name('C               ');
    L_identifier              := enter_name('L               ');

    { RESERVED and UNRESERVED are non-reserved keywords, and are
      therefore not given the KEY_WORD name_type.  They are parsed as
      identifiers, and the id.name is checked against the following values. }

    RESERVED_key_name         := enter_name('RESERVED        ');
    UNRESERVED_key_name       := enter_name('UNRESERVED      ');
  end { init_built_in_identifier_names } ;


  procedure init_signal_syntax;
    { initialize the signal syntax descriptor }
  begin
    syntax_specifier_names[negation_specifier ]:=enter_name('NEGATION        ');
    syntax_specifier_names[name_specifier     ]:=enter_name('NAME            ');
    syntax_specifier_names[assertion_specifier]:=enter_name('ASSERTION       ');
    syntax_specifier_names[subscript_specifier]:=enter_name('SUBSCRIPT       ');
    syntax_specifier_names[null_specifier     ]:=enter_name('                ');
    syntax_specifier_names[property_specifier ]:=enter_name('GENERAL_PROPS   ');

    signal_syntax_table[1] := NEGATION_SPECIFIER;
    signal_syntax_table[2] := NAME_SPECIFIER;
    signal_syntax_table[3] := SUBSCRIPT_SPECIFIER;
    signal_syntax_table[4] := ASSERTION_SPECIFIER;
    signal_syntax_table[5] := PROPERTY_SPECIFIER;
  end { init_signal_syntax } ;
  
  
  procedure init_synonym_signal_table;
    { initialize the signal table }
    var
      i: synonym_signal_table_range;  { index into the synonym signal table }
  begin
    bogus_cmptmp_list := NIL;
    for i := 0 to SYNONYM_SIGNAL_TABLE_SIZE do
      synonym_signal_table[i] := NIL;
  end { init_synonym_signal_table } ;


  procedure init_efs_structures;
    { init structures for working with EFS files }
  begin
    EFS_PREFIX_string := make_and_enter_string(EFS_PREFIX);
  end { init_efs_structures } ;


begin { init }
  { NOTE: these initialization routines are order sensitive.  The routines
          called first are those that use no other "constant" variables
          for initializations.  The other routines do, and some of them
          must be called in this specific order.  Check very carefully
          before changing any of this. }

  { these initializations do NOT rely on other initializations }

  init_free_lists;    { this must be first because of NEW recording }

  init_sets;
  init_string_structures;
  init_constants;
  init_assertions;
  init_plumbing_directory;
  init_scalars;
  init_statistics;
  init_synonym_signal_table;

  { these initializations rely on other initializations }

  init_built_in_identifier_names;
  init_keywords;
  init_errors;
  init_special_bodies;
  init_signal_syntax;
  init_cli_arg_structures;
  init_directives;
  init_lexical_analyzer;
  init_symbols;
  init_file_types;
  init_debug_controls;
  init_signals;
  init_special_names;
  init_report_tables;
  init_schema_structures;
  init_page_expansion_structures;
  init_efs_structures;
  
  make_pass := NO_PASS;

  create_a_string(TM_expansion_buffer, MAX_STRING_LENGTH);

  remove_logical_file(CMPLST_FILE_NAME);

  if not rewrite_file(monitor, nullstring, MONITOR_FILE_NAME) then
    begin


      halt_with_status(FATAL_COMPLETION);
    end;
  monitor_open := TRUE;
  writeln(monitor);
  if command = COMPERR_COMMAND then write(monitor, COMPERR_WELCOME)
  else write(monitor, WELCOME_MESSAGE);
  dump_string(monitor, vversion);
  writeln(monitor);
  writeln(monitor, COPYRIGHT_NOTICE);

  if not rewrite_file(CmpLog, nullstring, CMPLOG_FILE_NAME) then
    begin


      halt_with_status(FATAL_COMPLETION);
    end;
  writeln(CmpLog, '+---------------------------+':42);
  writeln(CmpLog, '|  SCALD compiler log file  |':42);
  writeln(CmpLog, '+---------------------------+':42);
  writeln(CmpLog);
  write(CmpLog, WELCOME_MESSAGE);
  dump_string(CmpLog, vversion);
  writeln(CmpLog);
  writeln(CmpLog, COPYRIGHT_NOTICE);
  writeln(CmpLog);

  init_linker_comm_structures;
  {add_init(parse_error_notifier)};
  { NOTE: er_init(...) is called in read_compiler_directives_file before processing
    any associated directives (other than DEBUG_CONTROL ERULE;).  This allows
    the presence of that directive to turn on erule debugging before the
    initialization occurs. }
end { init } ;


{------------------------ end procedures --------------------------}


 (**)     { ------- output a string with specified format ------- }


function print_string_formatted(var f: textfile;
                                str: xtring;
                                left_margin, right_margin: print_width_range;
                                pad_the_line: boolean;
                                print_CRLF: boolean): print_width_range;
  { Print the string to the given file and break it up if it does not fit.
    The break up algorithm works as follows:
          1).  If the string length <= space available, print the string
               and pad with blanks if padding is specified (PAD_THE_LINE).
          2).  else break the string into N pieces such that each of the N
               pieces is < the space available and as large as possible.
               Print each of the pieces as follows:
                  a).  First piece is left justified at left margin.
                  b).  Last piece is right justified at right margin.
                  c).  Other pieces are left justified at
		       DEFAULT_INDENT+left margin.
          3).  Print a CRLF if so indicated.
    Strings are broken at a space.  If no space is found such that the
    resulting string is greater than half the space available, then break
    the string DEFAULT_INDENT characters in from the right margin.

    Return the character position of the last character in the last line.
    This is always = RIGHT_MARGIN unless the string is shorter than the
    space available and no padding is performed (PAD_THE_LINE = FALSE).

    It is assumed that, on entry, the current character position in the
    output file is LEFT_MARGIN. }
  var
    space_available: integer;     { space available for the string }
    i,                            { index into the string for output }
    start,                        { starting position of current substring }
    break_pos,                    { best guess break position }
    length: string_range;         { current length of the string }
    blank: integer;               { width of space to be printed }


  function find_nearest_break(last: string_range): string_range;
    { find the nearest place to break the string to the left of LAST.  If
      a position is not found before half the space available is traversed
      then return LAST. }
    var
      pos: string_range;      { index into the string }
      found: boolean;         { TRUE when a break position has been found }
  begin
    pos := last;  found := FALSE;
    while (pos > (last - (space_available DIV 2))) and not found do
      if str^[pos] = ' ' then  found := TRUE  else  pos := pos - 1;
    if found then find_nearest_break := pos
             else find_nearest_break := last;
  end { find_nearest_break } ;


  procedure post_string(start, finish: string_range);
    { print the sub string on the output file }
    var
      i: string_range;           { index into the string }
  begin
    for i := start to finish do write(f, str^[i]);  writeln(f);
    write(f, ' ':left_margin+DEFAULT_INDENT-1);
  end { post_string } ;


begin { print_string_formatted }
  space_available := right_margin - left_margin + 1;
  print_string_formatted := right_margin;
  if (space_available <= 0) then
    begin  assert(45 { invalid });
      left_margin := 1;  space_available := right_margin;
    end;
  length := ord(str^[0]);
  if length <= space_available then
    begin
      for i := 1 to length do write(f, str^[i]);
      if pad_the_line then 
        begin
	  if length < space_available then
	    write(f, ' ':space_available - length);
	end
      else print_string_formatted := left_margin + length;
    end
  else
    begin
      break_pos := find_nearest_break( (length DIV 2) );
      blank := space_available - (length - (break_pos+1)+1) - DEFAULT_INDENT;
      if (break_pos < space_available) and (blank >= 0) then
        begin  post_string(1, break_pos);
          if blank > 0 then write(f, ' ':blank);
          for i := break_pos+1 to length do write(f, str^[i]);
        end
      else
        begin
          break_pos := find_nearest_break(space_available - DEFAULT_INDENT);
          post_string(1, break_pos);
          while (length - (break_pos+1) + 1) > 
	        (space_available - DEFAULT_INDENT) do
            begin
              start := break_pos+1;
              if (start + space_available - 2*DEFAULT_INDENT) >= length then
                break_pos := length - DEFAULT_INDENT
              else
                break_pos := start + space_available - 2*DEFAULT_INDENT;
              break_pos := find_nearest_break(break_pos);
              post_string(start, break_pos);
            end;
          blank := space_available - (length - (break_pos+1)+1) - DEFAULT_INDENT;
          if blank > 0 then write(f, ' ':blank);
          for i := break_pos+1 to length do write(f, str^[i]);
        end;
    end;
  if print_CRLF then writeln(f);
end { print_string_formatted } ;


procedure parse_error_notifier;
  { paramterless procedure called by ADD package to alert compiler to the
    presence of a parse error in some file }
begin
end { parse_error_notifier } ;


  procedure initialise_data_services;

  begin { initialise data services }
    if init_data_services <> 0 then
      begin
        writeln(output, ' Initialising Data services; ');
        {writeln(monitor, ' Initialising Data services; ')};
      end
    else
      begin
	{error(226  cannot initialise data services );}
      end;
  end;  { initialise data services }

  procedure print_name_type_string(str : xtring);
  var 
    i : integer;
  begin { print_name_type_string }
    i := 1;
    writeln(output, 'printing a nametype');
    write(output, '{ ');
    if (ord(str^[i]) = 1) then write(output, 'FIRST_NAME_TYPE, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'PERMANENT, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'RESERVED, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'UNRESERVED, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'KEY_WORD, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'INHERIT_PIN, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'INHERIT_SIGNAL, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'INHERIT_BODY, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'IS_PARAMETER, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'IS_INT_PARAMETER, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'PERMIT_SIGNAL, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'PERMIT_PIN, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'PERMIT_BODY, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'DONT_OUTPUT, ');
    i := i+1;
    if (ord(str^[i]) = 1) then write(output, 'IS_ET_CONTROL ');
    i := i+1;
    writeln(output, ' }');
  end; { print_name_type }


  function resolve_name_types(str : xtring) : name_type_set;
  var 
    kind : name_type_set;
    i : integer;
  begin { resolve_name_types }
    i := 1;
    if (str^[i] = char(1)) then kind := kind + [FIRST_NAME_TYPE];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [PERMANENT];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [RESERVED];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [UNRESERVED];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [KEY_WORD];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [INHERIT_PIN];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [INHERIT_SIGNAL];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [INHERIT_BODY];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [IS_PARAMETER];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [IS_INT_PARAMETER];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [PERMIT_SIGNAL];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [PERMIT_PIN];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [PERMIT_BODY];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [DONT_OUTPUT];
    i := i+1;
    if (str^[i] = char(1)) then kind := kind + [IS_ET_CONTROL];
    i := i+1;
    resolve_name_types := kind;
  end; { resolve_name_types }
    
  function make_string_from_name_types(kind : name_type_set) : xtring;
  var 
    kind_str : xtring;
    i : integer;

  begin { make_string_from_name_types}
    create_a_string(kind_str, ord(LAST_NAME_TYPE));	
    i := 1;
    if FIRST_NAME_TYPE in kind then kind_str^[i] := char(1);	
    i := i+1;
    if PERMANENT in kind then kind_str^[i] := char(1);	
    i := i+1;
    if RESERVED in kind then kind_str^[i] := char(1);	
    i := i+1;
    if UNRESERVED in kind then kind_str^[i] := char(1);	
    i := i+1;
    if KEY_WORD in kind then kind_str^[i] := char(1);	
    i := i+1;
    if INHERIT_PIN in kind then kind_str^[i] := char(1);	
    i := i+1;
    if INHERIT_SIGNAL in kind then kind_str^[i] := char(1);	
    i := i+1;
    if INHERIT_BODY in kind then kind_str^[i] := char(1);	
    i := i+1;
    if IS_PARAMETER in kind then kind_str^[i] := char(1);	
    i := i+1;
    if IS_INT_PARAMETER in kind then kind_str^[i] := char(1);	
    i := i+1;
    if PERMIT_SIGNAL in kind then kind_str^[i] := char(1);	
    i := i+1;
    if PERMIT_PIN in kind then kind_str^[i] := char(1);	
    i := i+1;
    if PERMIT_BODY in kind then kind_str^[i] := char(1);	
    i := i+1;
    if DONT_OUTPUT in kind then kind_str^[i] := char(1);	
    i := i+1;
    if IS_ET_CONTROL in kind then kind_str^[i] := char(1);	
    i := i+1;
    make_string_from_name_types := kind_str;
  end; { make_string_from_name_types }
    
  procedure setup_signal_configuration_from_ds_module;
  var
    i : integer;	
    syntax_code : xtring;
  begin
    if init_get_signal_configuration <> 0 then
      begin
	create_a_string(syntax_code, MAX_STRING_LENGTH);
        { the configuration is coded into this xtring. need to unravel it here }
        if get_signal_configuration(syntax_code) <> 0 then;
      end
    else 
      begin
        PREDS_read_and_check_configuration_file;
      end;
  end;
    
  procedure setup_global_textmacros_from_ds_module;

  { All the global text macros objects are set up }

    var
      alpha_name : alpha;
      tmdef : xtring;
      tmname : xtring;
      tmtype : Cint;
      kind : name_type_set;
      kind_str : xtring;
      name : name_ptr;
      def_str : xtring;

  procedure welcome;
    { display a message to indicate start of the directory parse }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst, ' *  Loading text macro definitions from database *');
        writeln(CmpLst, ' ************************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Loading text macro definitions.');
    writeln(CmpLog);  writeln(CmpLog, ' Loading text macro definitions.');
  end { welcome } ;


  begin { setup_global_textmacros_from_ds_module }
    if init_get_global_tms <> 0 then 
      begin	
        welcome;
	create_a_string(tmname, MAX_STRING_LENGTH);
    	create_a_string(tmdef, MAX_STRING_LENGTH);
    	create_a_string(kind_str, ord(LAST_NAME_TYPE));

    	while (get_tm(tmname, tmdef, kind_str) <> 0) do
      	  begin
            {print_name_type_string(kind_str);}
	    def_str := nullstring;
	    copy_string(tmdef, def_str);
	    copy_from_string(tmname, alpha_name);
            kind := resolve_name_types(kind_str);
	    name := enter_name(alpha_name);

            { PERMANENT is also reserved, reserved not used becuse or error 46 }
            if RESERVED in kind then
	      begin add_global_text_macro(name, def_str, PERMANENT); end
                else if PERMANENT in kind then
                  begin add_global_text_macro(name, def_str, PERMANENT); end
                else if UNRESERVED in kind then
                  add_global_text_macro(name, def_str, UNRESERVED);

          end;

	tmname^[0] := chr(MAX_STRING_LENGTH);
	release_string(tmname);
	tmdef^[0] := chr(MAX_STRING_LENGTH);
	release_string(tmdef);
	release_string(kind_str)
     end
  else
    begin
      error(257 { unable to find global TMs in database });
      PREDS_init_global_text_macros;
    end;		

  end; { setup_global_textmacros_from_ds_module }


  procedure setup_property_attributes_from_ds_module;

  { All the property attribute objects are set up }

    var
      alpha_name : alpha;
      propname : xtring;
      kind : name_type_set;
      attr_str : xtring;
      name : name_ptr;
      def_str : xtring;

  procedure welcome;
    { display a message to indicate start reading property attributes from DS }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst, ' *  Loading property attributes from database *');
        writeln(CmpLst, ' *********************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Loading property attributes.');
    writeln(CmpLog);  writeln(CmpLog, ' Loading property attributes.');
  end { welcome } ;


  begin { setup_property_attributes_from_ds_module }
    if init_get_property_attributes <> 0 then
      begin
	welcome;
	create_a_string(propname, MAX_STRING_LENGTH);
        create_a_string(attr_str, ord(LAST_NAME_TYPE));

        while (get_property_attribute(propname, attr_str) <> 0) do
          begin
	    print_name_type_string(attr_str);
	    copy_from_string(propname, alpha_name);
            kind := resolve_name_types(attr_str);
	    name := enter_name(alpha_name);
            {set_up_default_attributes(name, kind); }
          end;

        propname^[0] := chr(MAX_STRING_LENGTH);
        release_string(propname);
        release_string(attr_str);
      end
    else 
      begin
        error(258 { unable to find property attributes in database });
	PREDS_read_property_attributes;
      end;
  end; { setup_property_attributes_from_ds_module }

  procedure setup_directives_from_ds_module;

    var
      alpha_name : alpha;
      dvname : xtring;
      dvval : xtring;
      dvval_alpha : alpha;
      dvval_name : name_ptr;	
      dvname_id : name_ptr;
      def_str : xtring;

      directive: directive_type;          { directive being parsed }
      temp: integer;                      { temp for expression values }
      nil_ptr: file_list_ptr;             { NIL to implement evacuate }
      found_debug_directive: boolean;     { TRUE if debugging on }
      directives_encountered: 
                          directive_set;  { all directives encountered }
      dummy_boolean: boolean;             { For on/off directives not used
                                          by compiler (linker only) }
      old_umask: integer;                 { For return from umask call }


  procedure welcome;
    { display a welcome message to indicate start of compiler directive parse }
  begin
    if PrintCmpLst then
      begin
        writeln(CmpLst);
        writeln(CmpLst, ' *************************************');
        writeln(CmpLst, ' *  Loading the compiler directives from database *');
        writeln(CmpLst, ' *************************************');
        writeln(CmpLst);
      end;
    writeln(monitor);  writeln(monitor, ' Loading the compiler directives.');
    writeln(CmpLog);  writeln(CmpLog, ' Loading the compiler directives.');
  end { welcome } ;

  function find_directive(name: name_ptr; var directive: directive_type):
                                                                    boolean;
    { search the directive table for the specified name and return its
      directive type if found. }
    var
      search: directive_type;       { directive search index }
      found: boolean;               { TRUE when directive found }
  begin
    search := succ(FIRST_DIRECTIVE);  found := FALSE;
    while (search < LAST_DIRECTIVE) and not found do
      if name = compiler_directive[search] then found := TRUE
      else search := succ(search);

    if (search IN debug_directives) and not found_debug_password then
      begin  found := FALSE;  search := LAST_DIRECTIVE;  end;

    find_directive := found;  directive := search;
  end { find_directive } ;


  function ON_or_OFF(specifier: name_ptr; default: boolean): boolean;
    { if specifier = 'ON' then return TRUE else if specifier = 'OFF' then
      return FALSE, else return the default. }
  begin
    if specifier = ON_specifier then ON_or_OFF := TRUE
    else if specifier = OFF_specifier then ON_or_OFF := FALSE
    else
      begin  error(52 { invalid specifier });  ON_or_OFF := default;  end;
  end { ON_or_OFF } ;


  function local_or_global(specifier: name_ptr; default: boolean): boolean;
    { if specifier = 'LOCAL' then return TRUE else if specifier = 'GLOBAL'
      then return FALSE, else return the default. }
  begin
    if specifier = LOCAL_specifier then local_or_global := TRUE
    else if specifier = GLOBAL_specifier then local_or_global := FALSE
    else
      begin  error(52 { invalid });  local_or_global := default;  end;
  end { local_or_global } ;

  function ON_or_OFF_string(specifier: xtring; default: boolean): boolean;
    { if specifier = 'ON' then return TRUE else if specifier = 'OFF' then
      return FALSE, else return the default. }
  var
   OFF_specifier_string, ON_specifier_string : xtring;
  begin
    if CmpStrEQ(specifier, ON_specifier_string) then
      ON_or_OFF_string := TRUE
    else if CmpStrEQ(specifier, OFF_specifier_string) then
           ON_or_OFF_string := FALSE
    else
      begin  
        error(52 { invalid specifier });  
	ON_or_OFF_string := default; 
      end;
  end { ON_or_OFF_string } ;

  function local_or_global_string(specifier: xtring; default: boolean): boolean;
  var
    LOCAL_specifier_string, GLOBAL_specifier_string : xtring;
    { if specifier = 'LOCAL' then return TRUE else if specifier = 'GLOBAL'
      then return FALSE, else return the default. }
  begin
    if CmpStrEQ(specifier, LOCAL_specifier_string) then
      local_or_global_string := TRUE
    else if CmpStrEQ(specifier, GLOBAL_specifier_string) then
      local_or_global_string := FALSE
    else
      begin  error(52 { invalid });  local_or_global_string := default;  end;
  end { local_or_global_string } ;


  procedure process_PICK_directive;
    label 
      90; { return }
    var
      comptype: name_ptr;
      extension: name_ptr;
      attribute: name_ptr;
      dwgname: xtring;


    procedure add_exception(comptype, ext, att: name_ptr);
      var
        t: selection_exception_ptr;
    begin
      new(t);
      with t^ do
        begin
	  compile_type := comptype;
	  extension := ext;
	  attribute := att;
	  drawings := NIL;
	  next := selection_exceptions;
	  selection_exceptions := t;
	end;
    end;


  procedure add_drawing(dname, context: xtring);
    var
      t: drawing_list_ptr;
  begin
    new(t);
    t^.drawing := dname;
    t^.context := context;
    t^.next := selection_exceptions^.drawings;
    selection_exceptions^.drawings := t;
  end;
  

  begin { process_pick_directive }
    if sy <> LPAREN then
      begin
	error(15 { expected LPAREN });  
	goto 90 { return };
      end;
    insymbol;
    if sy <> IDENT then
      begin
	error(1 { expected id });  
	goto 90 { return };
      end;
    comptype := id.name; 
    if (comptype = PRIM_extension_name) then 
      begin
        error(66);  
	error_dump_indent(indent);
	error_dump_alpha('LOGIC assumed   ');
	error_dump_CRLF;
	comptype := LOGIC_compile_type;
      end
    else if (comptype = PART_extension_name) then 
      begin
        error(216);  { Already states that LOGIC is assumed }
	comptype := LOGIC_compile_type;
      end;
    insymbol;

    if sy <> RPAREN then
      begin
	error(7 { expected RPAREN });  
	goto 90 { return };
      end;
    insymbol;

    if sy <> IDENT then
      begin
	error(1 { expected id });  
	goto 90 { return };
      end;
    extension := id.name;  
    if extension = PART_extension_name then extension := PRIM_extension_name;
    insymbol;

    if sy <> LPAREN then 
      begin
	attribute := null_name;
	if extension = PRIM_extension_name then
	  error(26 { need directory type }); { attribute will be fixed later }
      end
    else
      begin
	insymbol;
	if sy <> IDENT then
	  begin
	    error(1 { expected id });  
	    goto 90 { return };
	  end;
	attribute := id.name;
	if attribute = PART_extension_name then
	  attribute := PRIM_extension_name;
	if extension = PRIM_extension_name then
	  begin
	    if attribute = PRIM_extension_name then
	      begin
	        error(28 { not legal SCALD dir type });
		attribute := null_name;  { fix it later }
              end;
	  end
        else
	  begin
	    if (attribute <> SPECIAL_specifier) and 
	       (attribute <> PRIMITIVE_specifier) then 
              begin
		error(27 { expected SPECIAL or PRIMITIVE });
		attribute := null_name;
	      end;
	  end;
	insymbol;

	if sy <> RPAREN then
	  begin
	    error(7 { expected RPAREN });  
	    goto 90 { return };
	  end;
	insymbol;
      end;

    add_exception(comptype, extension, attribute);

    repeat
      if sy <> STRINGS then
	begin
	  error(33 { expected a string });  
	  goto 90 { return };
	end;
      dwgname := lex_string;
      insymbol;
      if sy = MINUS then
	begin
	  insymbol;
	  if sy <> STRINGS then
	    begin
	      error(33 { expected a string });  
	      goto 90 { return };
	    end;
	  add_drawing(dwgname, lex_string);
	  insymbol;
	end
      else add_drawing(dwgname, NIL);
      if sy = COMMA then insymbol
      else if sy <> SEMI then goto 90 { return -- error handled elsewhere };
    until sy = SEMI;
  90:
  end { process_PICK_directive } ;


  procedure process_pick_list;
    var
      t: selection_exception_ptr;
      dwg: drawing_list_ptr;


    procedure reverse(var head: selection_exception_ptr);
      var
	previous: selection_exception_ptr;  { former parent of head }
	next: selection_exception_ptr;      { former child of head }
    begin
      previous := NIL;
      while head <> NIL do 
	begin
	  next := head^.next;
	  head^.next := previous;
	  previous := head;
	  head := next;
	end;
      head := previous;
    end { reverse } ;


  begin { process_pick_list }
    reverse(selection_exceptions);
    t := selection_exceptions;
    while t <> NIL do with t^ do
      begin
        if (extension = PRIM_extension_name) and (attribute = NULL_name) then
	  attribute := specified_compile_type;
        dwg := drawings;
	while dwg <> NIL do
	  begin
	    er_except(compile_type^.name, dwg^.drawing, dwg^.context,
	              extension^.name, attribute^.name);
	    dwg := dwg^.next;
	  end;
        t := next;
      end;
  end { process_pick_list } ;


  procedure process_OUTPUT_file_list;
    { process the output file list and set the control flags }
    var
      file_name: output_file_names;      { name of output file to create }
      done: boolean;                     { if all output controls read }
      found: boolean;                    { TRUE if file name found }
  begin 
    if not (OUTPUT_DIRECTIVE in directives_encountered) then
      files_to_generate := [];

    done := FALSE;
    while not done and (sy <> SEMI) do
      begin
        if sy <> IDENT then
          begin  error(1 { expected ident });  skip([SEMI,COMMA,IDENT]);  end
        else
          begin
            file_name := succ(first_file_name);  found := FALSE;
	    if id.name <> null_name then
	      while (file_name < last_file_name) and not found do
		if output_file[file_name] = id.name then found := TRUE
		else file_name := succ(file_name);

            if found then
	      begin
	        if (file_name in SCALD_only_output_files) then
		  error(3 { SCALD compiler only });
	      end
            else
              begin
                error(97 { unknown output file name });
                file_name := first_file_name;
              end;

            files_to_generate := files_to_generate + [file_name];
            insymbol;
          end;
        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_OUTPUT_file_list } ;


  procedure process_shareable_directive;
    { process the directive and set the umask accordingly. Note that
      SHAREABLE DEFAULT; means to do nothing to the umask. }
    var
       oldumask: integer;
       val: shareable_value;
  begin
    if sy <> IDENT then error(1 { Expected identifier })
    else
      begin
        val := succ(FIRST_SHAREABLE_VALUE);
        while (val < LAST_SHAREABLE_VALUE) and 
              (shareable.values[val] <> id.name) do val := succ(val);
        if val = LAST_SHAREABLE_VALUE then
	  error(17 { unknown SHAREABLE spec })
        else 
          if val <> DEFAULT_SHARING then
	    oldumask := umask(shareable.umasks[val]);
	specified_shareable_value := val;
	insymbol;
      end;
  end { process_shareable_directive } ;


  function add_name_to_library_list(lib_name, add_name: xtring): boolean;
    { check the given name against the current list of libraries.
      If it exists, return FALSE.  If it doesn't exist, add it to the
      list and return TRUE. }
    var
      already_exists: boolean;         { TRUE if file already in the list }
      element,                         { current directory entry }
      last: directory_list_ptr;        { last library visited in the list }
  begin { add_name_to_library_list }
    element := library_list_root;  last := NIL;
    already_exists := FALSE;
    while (element <> NIL) and not already_exists do
      if element^.name = lib_name then 
	already_exists := TRUE
      else
        begin  last := element;  element := element^.next;  end;
    if not already_exists then
      begin
        new_directory_list(element);
        element^.name := lib_name;
        element^.add := add_name;
        if last=NIL then library_list_root := element
                    else last^.next:=element;
      end;
    add_name_to_library_list := not already_exists;
  end { add_name_to_library_list } ;


  procedure process_DIRECTORY_directive;
    { process the scald directory and its shadow directory The procedure
      reads the directories specified in the directory directive and 
      supplies the add package with the scald directory and its associated
      shadow directory. Each scald directory can be associated with only
      one shadow directory. Any additional add directory is ignored. The
      error handling in this code is very gentle. It only reminds the user
      of any error in the lexical manipulation and tries to recover 
      gracefully from the error condition without much ado. Any errors in
      the specification is dealt by the add package }
    var
      done: boolean;              { TRUE if all directory names read }
      scaldir: xtring;            { scald directory }
      add : xtring;             { add directory }
      dir: directory_list_ptr;    { current directory in list }
      last: directory_list_ptr;   { last directory in list }
      found: boolean;             { TRUE if found in list }

  begin { process_DIRECTORY_directive }
    done := FALSE;
    repeat
      scaldir := NIL;
      add := NIL;
      if sy = STRINGS then
        begin
          scaldir := lex_string;
          insymbol;
        end
      else 
        begin
	  error(93 { expected file name });
          skip([SEMI,COMMA]);
        end;

      if ((sy = MINUS) and (scaldir <> NIL) and not done) then
        begin
          insymbol;
          if sy = STRINGS then
            begin
              add := lex_string;
              insymbol;
            end
          else
            begin
	      error(91 { expected shadow directory name });
              skip([SEMI,COMMA]);
            end;
        end;
      
      if sy <> COMMA then done := TRUE
      else insymbol;

      if scaldir <> NIL then
        begin
	  found := FALSE;
	  dir := directory_list_root;  last := NIL;
	  while (dir <> NIL)  and not found do
	    begin
	      if (dir^.name = scaldir) then
		begin
		  found := TRUE;
                  error(87 { file already exists });
		end
	      else
	        begin
		  last := dir;
		  dir := dir^.next;
		end;
            end;
	  if not found then 
	    begin
	      new_directory_list(dir);
	      if last = NIL then directory_list_root := dir
	      else last^.next := dir;
	      dir^.name := scaldir;
	      dir^.add := add;
            end;
        end;
    until done;
  end { process_DIRECTORY_directive } ;
          

  procedure process_DIRECTORY_list;
    { process the list of directories -- inform the A.D.D. package about
      each and report errors }
    var
      element: directory_list_ptr;      { current directory name }
      add_name: xtring;                  { name of add directory }
  begin
    element := directory_list_root;
    while element <> NIL do
      begin
        add_name := element^.add;
	if add_name = nullstring then add_name := NIL;
{
        if not susedir(element^.name, S_SCALDDIR, add_name, NIL, NIL) then
          process_add_error(element^.name, SCALD_DIRECTORY_FILE);
}
        element := element^.next;
      end;
  end  { process_DIRECTORY_list };
      

  procedure process_LIBRARY_list;
    { process the LIBRARY directive.  For each library identifier, check
      the master library description and, if found, add the corresponding
      SCALD directory file name to the directory list. }
    var
      element: directory_list_ptr;       { current library name }
      lib_name,                          { name of library }
      add_name: xtring;                  { name of add directory }
  begin
    element := library_list_root;
    while element <> NIL do
      begin
        lib_name := element^.name;
	if lib_name = nullstring then lib_name := NIL; { add package kink }
        add_name := element^.add;
	if add_name = nullstring then add_name := NIL; { add package kink }
{
        if not susedir(lib_name, S_LIBRARY, add_name, NIL, NIL) then
          process_add_error(lib_name, SCALD_DIRECTORY_FILE);
}
        element := element^.next;
      end;
  end  { process_LIBRARY_list };
      

  procedure process_LIBRARY_directive;
    { add each library name to the list of libraries }
    var
      done: boolean;                    { TRUE when done with directive }
      library_name: xtring;             { name of library being specified }
      add: xtring;                    { specified ADD }
  begin
    done := FALSE;
    repeat
      library_name := NIL;
      add := NIL;

      if sy = IDENT then
        begin
          library_name := make_and_enter_string(id.name^.name);
          insymbol; { eat the identifier }
        end
      else if sy = STRINGS then
        begin
          library_name := lex_string;
          insymbol; { eat the the string }
        end
      else
        begin
          error(4 { expected a string or identifier });  
          skip([SEMI,COMMA,STRINGS,IDENT]);
        end;


      if ((sy = MINUS) and (library_name <> NIL)) then 
               { check if there is any shadow directory }
        begin
	  upper_case_strings := FALSE;
          insymbol; { eat the '-' and get ADD name -- don't upshift it }
	  upper_case_strings := TRUE;
          if sy = STRINGS then
            begin
              add := lex_string;
              insymbol; { eat the shadow string }
            end
          else
            error(93 { expected add_dir });
        end;

      if library_name <> NIL then
        begin
          if not add_name_to_library_list(library_name, add) then 
	    error(68 { lib already there });
	end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_LIBRARY_directive } ;


  procedure get_file_name_list(var list: file_list_ptr);
    { read a list of files from the input.  Check to see if the file has
      already been specified.  If not, add it to the list.  Otherwise,
      generate an error. }
    var
      done: boolean;                { TRUE when done with directive }
      file_name: xtring;            { name of file being specified }
      current_file: file_list_ptr;  { current file in the list }
      found: boolean;               { TRUE if entry found in library }
  begin    
    done := FALSE;
    repeat
      if sy <> STRINGS then
        begin
          error(33 { expected a string });  skip([SEMI,COMMA,STRINGS]);
        end
      else
        begin
          file_name := lex_string;
          current_file := list;  found := FALSE;
          while (current_file <> NIL) and not found do
            if current_file^.file_name = file_name then found := TRUE
            else current_file := current_file^.next;

          if found then
            error(38 { file was already specified })
          else
            begin
              new_file_list(list);
              list^.file_name := file_name;
            end;

          insymbol;     { eat the file name }
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { get_file_name_list } ;


  procedure process_debug_controls;
    { process the debug control specifiers }
    var
      control: debug_controls;       { control specified }
      done: boolean;                 { TRUE when all debug controls found }
      found: boolean;                { TRUE when control name found in table }


    procedure process_histograms;
      { process the histogram specifiers }
      var
        hist: histogram_types;       { histogram to be printed }
        done: boolean;               { TRUE if all histograms have been read }
        found: boolean;              { TRUE if specifier found }
    begin
      insymbol;   { eat the PRINTHISTOGRAMS }
      if sy = LPAREN then insymbol else error(15 { expected ( });

      done := FALSE;
      repeat
        if sy <> IDENT then
          begin  error(1 { expected ident });  skip([SEMI,COMMA]);  end
        else
          begin
            hist := succ(FIRST_HISTOGRAM);  found := FALSE;
            while (hist < LAST_HISTOGRAM) and not found do
              if histogram_specifiers[hist] = id.name then found := TRUE
              else hist := succ(hist);

            if found then histograms := histograms + [hist]
            else error(42 { unknown histogram });
          end;

        insymbol;
        if sy = COMMA then insymbol else done := TRUE;
      until done;

      if sy <> RPAREN then error(7 { expected ) });
    end { process_histograms } ;


  begin { process_debug_controls }
    done := FALSE;
    while (sy = IDENT) and not done do
      begin
        control := succ(FIRST_CONTROL);  found := FALSE;
        while (control < LAST_CONTROL) and not found do
          if debug_control_specifier[control] = id.name then found := TRUE
          else control := succ(control);

        case control of
          CONTROL_DUMPTREE:          dumptree_ok := TRUE;
          CONTROL_DUMPSIGNALS:       dumpsignals_ok := TRUE;
          CONTROL_PRINTMACROS:       printmacros_ok := TRUE;
          CONTROL_PRINTDIRECTORY:    printdirectory_ok := TRUE;
          CONTROL_PRINTHISTOGRAMS:   process_histograms;
          CONTROL_DUMPSIGDEFLIST:    dumpsigdeflist_ok := TRUE;
          CONTROL_DUMP_ALL_NAMES:    dump_all_names_ok := TRUE;
          CONTROL_ERULE_XFACE:       
	    begin  
	      er_debug;  trace_erule_xface := TRUE;
	    end;
          LAST_CONTROL,
          FIRST_CONTROL:             error(42 { unknown debug control });
        end;

        insymbol;

        if sy = COMMA then insymbol else done := TRUE;
      end;

    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;
  end { process_debug_controls } ;


  procedure process_debug;
    { process the DEBUG directive }
    var
      debug_number: natural_number;     { debug flag number }
      done: boolean;                    { TRUE when all debug COMMAnds read }
  begin
    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;

    done := FALSE;
    repeat
      if sy = IDENT then
        begin  debug := ON_or_OFF(id.name, debug);  insymbol;  end
      else if sy = CONSTANT then
        begin
          debug_number := const_val;  insymbol;
          case debug_number of
            1:   debug_1 := TRUE;
            2:   debug_2 := TRUE;
            3:   debug_3 := TRUE;
            4:   debug_4 := TRUE;
            5:   debug_5 := TRUE;
            6:   debug_6 := TRUE;
            7:   debug_7 := TRUE;
            8:   debug_8 := TRUE;
            9:   debug_9 := TRUE;
            10:  debug_10 := TRUE;
            11:  debug_11 := TRUE;
            12:  debug_12 := TRUE;
            13:  debug_13 := TRUE;
            14:  debug_14 := TRUE;
            15:  debug_15 := TRUE;
            16:  debug_16 := TRUE;
            17:  debug_17 := TRUE;
            18:  debug_18 := TRUE;
            19:  debug_19 := TRUE;
            20:  debug_20 := TRUE;
            21:  debug_21 := TRUE;
            22:  debug_22 := TRUE;
            23:  debug_23 := TRUE;
            24:  debug_24 := TRUE;
            25:  debug_25 := TRUE;
            26:  debug_26 := TRUE;
            27:  debug_27 := TRUE;
            28:  debug_28 := TRUE;
            29:  debug_29 := TRUE;
            30:  debug_30 := TRUE;
            31:  debug_31 := TRUE;
            32:  debug_32 := TRUE;
            33:  debug_33 := TRUE;
            34:  debug_34 := TRUE;
            35:  debug_35 := TRUE;
            36:  debug_36 := TRUE;
            37:  debug_37 := TRUE;
            38:  debug_38 := TRUE;
            39:  debug_39 := TRUE;
            40:  debug_40 := TRUE;
          end;
        end 
      else
        begin
          error(1 { expected ident });  skip([SEMI, IDENT]);
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_debug } ;


  procedure process_path_debug;
    { process the DEBUG_AT_PATH directive }
    var
      done: boolean;               { TRUE when command completed }
  begin
    if not found_debug_directive then
      begin
        debugging := TRUE;
        if not rewrite_file(Outfile, nullstring, DEBUG_FILE_NAME) then
          halt_with_status(FATAL_COMPLETION);
      end;
    found_debug_directive := TRUE;

    if sy <> STRINGS then
      begin  error(33 { expected a string });  end
    else
      begin
        path_for_debug := lex_string;  insymbol;
        done := FALSE;
        repeat
          if sy <> CONSTANT then
            begin
              error(52 { invalid });  skip([SEMI,IDENT]);
            end
          else
            if (const_val < 0) or (const_val > MAX_DEBUG_FLAG_NUMBER) then
              begin
                error(52 { not correct });  skip([SEMI,IDENT]);
              end
            else
              begin
                debug_flags := debug_flags + [const_val];
                insymbol;
                debug_at_path := TRUE;
              end;

          if sy = COMMA then insymbol else done := TRUE;
        until done;
      end;
  end { process_path_debug } ;


  procedure process_SUPPRESS_directive;
    { process the SUPPRESS directive }
    var
      done: boolean;            { TRUE when all numbers read in }
  begin
    done := FALSE;
    while ((sy = CONSTANT) or (sy = IDENT)) and not done do
      begin
        if sy = IDENT then
          if id.name = ALL_identifier then
            begin
              suppress_errors := warning_errors + oversight_errors;
              insymbol;
            end
          else
            begin
              error(52 { unexpected specification });
              skip([COMMA,SEMI,CONSTANT,IDENT]);
            end
        else
          if not (const_val IN warning_errors+oversight_errors) then
            begin
              error(92 { invalid number });  skip([SEMI,COMMA]);
            end
          else
            begin
              suppress_errors := suppress_errors + [const_val];  insymbol;
            end;

        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_SUPPRESS_directive } ;


  procedure process_COMPILE_directive(compile_type: name_ptr);
    { process the COMPILE directive and set up the extension for compile }
  begin
    if not TYPE_specified_in_command_line then
      begin
        if (compile_type = PART_extension_name) then
          begin
            error(216 { PART not allowed; LOGIC assumed });
            compile_type := LOGIC_compile_type;
          end;

        if (compile_type = PRIM_extension_name) then
	  error(66 { not allowed });
	specified_compile_type := compile_type;
      end;
  end { process_COMPILE_directive } ;


  procedure process_PRIMITIVE_directive;
    { process the primitive directive - create list of macro names.  If
      the given macro name has a path name in front of it, just save
      the path and make only that instance of the macro a primitive. }
    var
      done: boolean;          { TRUE when all macro names have been read }
      obj: avl_object_ptr;
  begin
{   obj.tag := AVL_STRING;                                         }(*AVL*)
    done := FALSE;
    repeat
      if sy <> STRINGS then
        begin  error(33 { expected string });  skip([SEMI,COMMA]);  end
      else
        begin
          if lex_string^[1] = '(' then 
            begin
              error(3 { SCALD compiler only });
	      error_dump_indent(indent);
	      error_dump_alpha(' ValidCOMPILER d');
	      error_dump_alpha('oes not support ');
	      error_dump_alpha(' path names on t');
	      error_dump_alpha('the PRIMITIVE di');
	      error_dump_alpha('rective         ');
	      error_dump_CRLF;
            end
          else
	    begin
	      obj.str := lex_string;
	      if (avl_insert(obj, force_primitives, AVL_STRING) <> NIL) then ;
            end;

          insymbol;
        end;

      if sy = COMMA then insymbol else done := TRUE;
    until done;
  end { process_PRIMITIVE_directive } ;


  procedure process_PASSWORD_directive;
    { process the SECRET SCALD PASSWORDS!!!!! }
  begin
    if sy = EQUAL then insymbol;     { allow space or equal }
    if sy <> IDENT then error(1 { expected ident })
    else
      if id.name^.name = CONFIGURE_PASSWORD then
        { do nothing }
      else if id.name^.name = DEBUG_PASSWORD then
        found_debug_password := TRUE;

    insymbol;    { eat the symbol }
  end { process_PASSWORD_directive } ;


  procedure process_filters;
    { parse but ignore this PASS_PROPERTY or FILTER_PROPERTY directive. }
    var
      done: boolean;         { TRUE when done processing input list }
  begin
    done := FALSE;
    while (sy = IDENT) and not done do
      begin
        insymbol;     { eat the identifier }
        if sy = COMMA then insymbol else done := TRUE;
      end;
  end { process_filters } ;


  procedure process_report_directive;
    { process the REPORT directive }
    var
      report: report_types;    { current report from the table }
      found: boolean;          { TRUE if report id found in the table }
      add_to_list: boolean;    { TRUE if report to be added to the list }
  begin
    while (sy = IDENT) or (sy = minus) do
      begin
        if sy = minus then
          begin  add_to_list := FALSE;  insymbol;  end
        else
          add_to_list := TRUE;

        report := succ(FIRST_REPORT_TYPE);  found := FALSE;
        while (report < LAST_REPORT_TYPE) and not found do
          if report_type_table[report] = id.name then found := TRUE
          else report := succ(report);

        if not found then
          if id.name <> ALL_identifier then
            error(31 { unknown report specification })
          else
            if add_to_list then
	      begin
                reports_to_generate := 
                           [succ(FIRST_REPORT_TYPE)..pred(LAST_REPORT_TYPE)];
              end
            else
              reports_to_generate := []
        else
          if add_to_list then
            if (report in SCALD_only_reports) then error(3 { can't do it })
            else reports_to_generate := reports_to_generate + [report]
          else
            reports_to_generate := reports_to_generate - [report];

        insymbol;    { eat the report name }

        if sy = COMMA then insymbol;
      end;
  end { process_report_directive } ;


  procedure process_COMMAND_directive(val: name_ptr);
    { process the COMMAND directive for the given value }
    var
      i: command_type;  { current command value  for search }
      found: boolean;   { TRUE when command value is found }
  begin
    if not COMMAND_specified_in_command_line then
      begin
        for i := succ(FIRST_COMMAND) to pred(LAST_COMMAND) do
          if val = command_value[i] then 
            begin
              found := TRUE;
              command := i;
            end;
        if not found then error(229 { illegal command value});
        if command = SEPLINK_COMMAND then
          if ROOT_specified_in_command_line or 
            TYPE_specified_in_command_line  then
            begin
              error(228 { incorrect usage of seplink command });
            end;
      end;
  end { process_COMMAND_directive } ;


  procedure process_command_line_arguments;
    { get parameters from a command line.  The line can contain:
      
      SEPCOMP root_drawing compile_type context_name
                  or
      SEPLINK compile_type cmpdraw_file_descriptor design_file_descriptor
                  or
      COMPERR [-w] root_drawing compile_type
              [-a]
	      [-o]
	      [-e]
       
      NOTE: if the file descriptors for the SEPLINK command are
      to be specified in the command line, then the SEPLINK
      command MUST also be specified in the command line. }
    var
      arg: xtring;                 { current argument from command line }
      temp_string: xtring;         { string for conversion to internal }
      len,                         { length of the string parameter }
      i: string_range;             { index into the strings }
      temp_alpha: alpha;           { temp storage for the compile type }
      last_legitimate_arg: 3..5;   { last argument with meaning }


    procedure process_command_arg;
      { process the current arg as COMMAND directive }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMMAND_directive(enter_name(temp_alpha));
          COMMAND_specified_in_command_line := TRUE;
        end;
    end { process_command_arg } ;


    function process_design_descriptor: boolean;
      { process the current arg as  file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          Design_fd := string_to_natural_number(arg);
          process_design_descriptor := TRUE;
        end
      else process_design_descriptor := FALSE;
    end { process_design_descriptor } ;


    function process_cmpdraw_descriptor: boolean;
      { process the current arg as cmpdraw's file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          CmpDraw_fd := string_to_natural_number(arg);
          process_cmpdraw_descriptor := TRUE;
        end
      else process_cmpdraw_descriptor := FALSE;
    end { process_cmpdraw_descriptor } ;


    procedure process_compile_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMPILE_directive(enter_name(temp_alpha));
          TYPE_specified_in_command_line := TRUE;
        end;
    end { process_compile_arg } ;


    procedure process_root_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          root_macro_name := enter_and_release_string(temp_string);
          ROOT_specified_in_command_line := TRUE;
        end;
    end { process_root_arg } ;


    procedure process_context_arg;
      { process the current arg as context name }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          CONTEXT_specified_in_command_line := TRUE;
	  { this is an obsolete concept }
        {  context_being_compiled := enter_and_release_string(temp_string); }
        end;
    end { process_context_arg } ;


  begin { process_command_line_arguments }
    { number of arguments includes the program name }

    if sargc >= 2 then   { there is a COMMAND parameter }
      begin
        sargv(1, arg);
        process_command_arg;
      end;

    if command = SEPLINK_COMMAND then
      begin
        if sargc >= 3 then   { KLUDGE "link" type spec }
          begin
            sargv(2, arg);
            process_compile_arg;
          end;
        if sargc >= 4 then   { there is an open CMDRAW file from linker }
          begin
            sargv(3, arg);
            if not process_cmpdraw_descriptor then
	      begin
	        error(166 { can't access CMPDRAW file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    cmpdraw_specified_in_command_line := TRUE;
          end;
        if sargc >= 5 then   { there is an open DESIGN file from linker }
          begin
            sargv(4, arg);
            if not process_design_descriptor then
	      begin
	        error(234 { can't access DESIGN file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    design_specified_in_command_line := TRUE;
          end;
        last_legitimate_arg := 4;
      end

    else { not the SEPLINK command }
      begin

        i := 2;

        if (command = COMPERR_COMMAND) and (sargc >= i + 1) then
	  begin
	    sargv(i, arg);
	    if ord(arg^[0]) = 2 then if arg^[1] = '-' then
	      begin
	        if (arg^[2] = 'a') or (arg^[2] = 'A') then
		  specified_severity := NO_SEVERITY { dump them all }
	        else if (arg^[2] = 'o') or (arg^[2] = 'O') then
		  specified_severity := OVERSIGHT_SEVERITY
	        else if (arg^[2] = 'e') or (arg^[2] = 'E') then
		  specified_severity := ERROR_SEVERITY { dump them all }
	        else if (arg^[2] = 'w') or (arg^[2] = 'W') then
		  specified_severity := WARNING_SEVERITY
		else
		  begin
		    error(251 { unrecognized argument });
		    error_dump_indent(indent);
		    error_dump_alpha('Argument=       ');
		    error_dump_string(arg);
		    error_dump_CRLF;
		  end;

	        i := i + 1;
	      end;
	  end;

        if sargc >= i + 1 then   { there is a ROOT_DRAWING parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_root_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a COMPILE type parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_compile_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a CONTEXT_NAME parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_context_arg;
          end;
        last_legitimate_arg := i;
      end;

    for i := (last_legitimate_arg + 1) to (sargc - 1) do
      begin
        sargv(i, arg);
        if arg <> nullstring then
          if not (224 in errors_encountered) then error(224 { junk });
      end;

  end { process_command_line_arguments } ;


  begin { setup_directives_from_ds_module }    
    if init_get_directives <> 0 then 
      begin
        welcome;	
        create_a_string(dvname, MAX_STRING_LENGTH);
        create_a_string(dvval, MAX_STRING_LENGTH);

        while (get_directive(dvname, dvval) <> 0) do
          begin
	    copy_from_string(dvname, alpha_name);
	    dvname_id := enter_name(alpha_name);

	    directives_encountered := [];	

	    found_debug_directive := FALSE;

            if not find_directive(dvname_id, directive) then
              begin
                error(51 { unknown directive });
              end

            else if (directive IN directives_encountered) and
                (directive IN one_time_directives) then
              begin
                error(45 { directive specified more than once });
              end

           else
             begin
               if directive IN file_name_directives then

                 case directive of
                   ALLOW_PART_NAME_DIRECTIVE:
                     begin
	               if ord(dvval^[0]) <= ID_LENGTH then
	                 begin
	                   allow_PART_NAME_property := ON_or_OFF_string(dvval,
	                                                  allow_PART_NAME_property)
                         end
                       else
                         error(1 { expected ident });
                    end;

                  AMUSING_MESSAGES_DIRECTIVE:
                    begin
	              if ord(dvval^[0]) <= ID_LENGTH then
                        produce_amusing_messages := ON_or_OFF_string(dvval,
                                                      produce_amusing_messages)
                      else   
                        error(1 { expected ident });
                      end;

                 BUBBLECHECK_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       bubble_check := ON_or_OFF_string(dvval, bubble_check)
                     else
                       error(1 { expected ident });
                     end;

                 COMMAND_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then 
	               begin
                         copy_from_string(dvval, dvval_alpha);
                         dvval_name := enter_name(dvval_alpha);
                         process_command_directive(dvval_name);
                       end
	             else error(1 { expected ident });
                   end;

                 COMPILE_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then 
	               begin
                         copy_from_string(dvval, dvval_alpha);
                         dvval_name := enter_name(dvval_alpha);
                         process_COMPILE_directive(dvval_name);
                      end
	            else error(1 { expected ident });
		  end;

                 CONFIG_FILE_DIRECTIVE:
                   begin
                     configuration_file := dvval;
                   end;

                 CONST_BUBBLE_CHK_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       const_bubble_check :=
                                        ON_or_OFF_string(dvval, const_bubble_check)
                     else
                       error(1 { expected ident });
	           end;

(***************************************
                 CONTEXT_DIRECTIVE:
                   begin
                     if sy = STRINGS then
                       if CONTEXT_specified_in_command_line then
                         begin   end
                       else
                         context_being_compiled := lex_string
 
**************************)

                 DEBUG_DIRECTIVE:
                   begin
	             parse_string(dvval, PARSE_SEPARATELY);
                     process_debug;
	             pop_parsed_string(dvval);
		   end;

                 DEBUG_AT_PATH_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     process_path_debug;
	             pop_parsed_string(dvval);
		   end;

                 DEBUG_CONTROL_DIRECTIVE:
		   begin
	             parse_string(dvval, PARSE_SEPARATELY);
                     process_debug_controls;
	             pop_parsed_string(dvval);
		   end;

                 DECLARE_BODIES_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
	               begin
                         if ON_or_OFF_string(dvval, FALSE) then
		           error(3 { SCALD compiler only });
                         end
                     else
                       error(1 { expected ident });
                   end;

                 DEFAULT_FILTER_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       dummy_boolean := ON_or_OFF_string(dvval, FALSE)
                     else
                       error(1 { expected ident });
                   end;

                 DEFAULT_L_OR_G_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       scope_is_local := local_or_global_string(dvval,
                                                          scope_is_local)
                     else
                       error(1 { expected ident });
                   end;

                DIRECTORY_DIRECTIVE:
                  {process_directory_directive}; 

                 ENABLE_CARDINAL_TAP_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       begin
                         enable_cardinal_tap := 
		           ON_or_OFF_string(dvval, enable_cardinal_tap);
                       end
                     else
                       error(1 { expected ident });
                   end;

                 ERROR_HELP_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) > ID_LENGTH then
                       error(1 { expected ident })
                     else
		       begin
                         display_error_doc := ON_or_OFF_string(dvval,
                                                         display_error_doc);
                       end;
                   end;

                 EVACUATE_DIRECTIVE:
                   begin
                     writeln(monitor);  writeln(monitor);
                     writeln(monitor, ' Evacuate!?  In our moment of triumph?');
                     writeln(monitor,' I think you overestimate their chances.');
                     writeln(monitor);  writeln(monitor);
                     nil_ptr := NIL;  nil_ptr := nil_ptr^.next;
                   end;

                 EXPANSION_RULES_DIRECTIVE:
                   {get_file_name_list(expansion_rules_file)};

                 FILTER_PROPERTY_DIRECTIVE:
                   {process_filters};{ ignore- processed by linker}

                 HIERARCHICAL_NWC_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       begin
                         if ON_or_OFF_string(dvval, FALSE) then
		           error(3 { SCALD compiler only });
                       end
                     else
                       error(1 { expected ident });
                   end;

                 LIBRARY_DIRECTIVE:
                   {process_LIBRARY_directive};

                 LOCALLY_GLOBAL_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       begin
                         if not ON_or_OFF_string(dvval, TRUE) then
		           error(3 { SCALD compiler only });
                       end
                     else
                       error(1 { expected ident });
                   end;


                 MASTER_LIBRARY_DIRECTIVE:
                   {get_file_name_list(master_library_file)};

                 MAX_ERROR_DIRECTIVE:
                   begin
		     parse_string(dvval, PARSE_SEPARATELY);
                     temp := expression(no_relops);
                     if temp <= 0 then error(178 { ridiculous! })
                     else max_errors := temp;
		     pop_parsed_string(dvval);
                   end;

                 NET_PROCESSING_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       begin
                         if not ON_or_OFF_string(dvval, TRUE) then
		           error(3 { SCALD compiler only });
                       end
                     else
                      error(1 { expected ident });
                   end;

                 OUTPUT_DIRECTIVE:
                   {process_OUTPUT_file_list};

                 OVERSIGHT_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       display_oversights := ON_or_OFF_string(dvval,
                                                        display_oversights)
                       else
                         error(1 { expected ident });
                   end;

                 PAGE_SYNONYM_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       dummy_boolean := ON_or_OFF_string(dvval, FALSE)
                     else
                       error(1 { expected ident });
                   end;

                 PASS_PROPERTY_DIRECTIVE:
                   {process_filters}; {ignore - linker to process }

                 PASSWORD_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     process_PASSWORD_directive;
                     pop_parsed_string(dvval);
		   end;

                 PERMIT_NO_ASSERTION_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       allow_missing_high_assertion := ON_or_OFF_string(dvval,
                                                 allow_missing_high_assertion)
                     else
                       error(1 { expected ident });
                   end;

                 PICK_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     process_PICK_directive;
	             pop_parsed_string(dvval);
		   end;

                 PRIMITIVE_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);	
                     process_PRIMITIVE_directive;
	             pop_parsed_string(dvval);
		   end;

                 PROPERTY_DIRECTIVE:
                   {get_file_name_list(property_file)};

                 PRINT_WIDTH_DIRECTIVE:
                   begin
		     parse_string(dvval, PARSE_SEPARATELY);	
                     temp := expression(no_relops);
                     if (temp<MIN_PRINT_WIDTH) or (temp>MAX_PRINT_WIDTH) then
                       error(94 { invalid print width value })
                     else print_width := temp;
		     pop_parsed_string(dvval);	
                   end;

                 REPORT_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     process_report_directive;
	             pop_parsed_string(dvval);
		   end;

                 REPORT_UNKASSERT_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       report_unknown_assertions :=
		       ON_or_OFF_string(dvval, report_unknown_assertions)
                     else
                       error(1 { expected ident });
                   end;

                 ROOT_DIRECTIVE:
                   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     if sy = STRINGS then
                       if ROOT_specified_in_command_line then
                         { ignore this one }
                       else
                         root_macro_name := lex_string
                     else
                       error(33 { expected name string });
	             pop_parsed_string(dvval);
                   end;

                 SHADOW_ROOT_DIRECTIVE:
                   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     if sy = STRINGS then shadow_root := lex_string
                     else
                       error(33 { expected a string });
		     pop_parsed_string(dvval);
                   end;

                 SHAREABLE_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);
                     process_shareable_directive;
                     pop_parsed_string(dvval);
		   end;


                 SINGLE_LEVEL_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       single_level_compile := 
                         ON_or_OFF_string(dvval, single_level_compile)
                     else
                       error(1 { expected ident });
                   end;

                 SUPPRESS_DIRECTIVE:
		   begin
                     parse_string(dvval, PARSE_SEPARATELY);	
                     process_suppress_directive;
                     pop_parsed_string(dvval);
		   end;

                 TEXT_MACRO_DIRECTIVE:
                   {get_file_name_list(text_macro_file)};

                 TOKENIZE_PARAMS_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       tokenize_params :=
                         ON_or_OFF_string(dvval, tokenize_params)
                     else
                       error(1 { expected ident });
                   end;

                 WARN_DIRECTIVE:
                   begin
	             if ord(dvval^[0]) <= ID_LENGTH then
                       display_warnings := ON_or_OFF_string(dvval,
                                                      display_warnings)
                     else
                       error(1 { expected ident });
                   end;

                 OTHERWISE
                   begin
                     error(51 { unknown directive });
                   end;
               end { case } ;

             directives_encountered := directives_encountered + [directive];
           end; { else }
         end { while };
  
        dvname^[0] := chr(MAX_STRING_LENGTH);
        release_string(dvname);
        dvval^[0] := chr(MAX_STRING_LENGTH);	
        release_string(dvval)
      end
    else 
      begin
        error(256 { unable to find directives in data base });
        { for time being read old files }
	PREDS_read_compiler_directives_file;
        {halt_with_status(FATAL_COMPLETION);}
      end;
  end; { setup_directives_from_ds_module }


  procedure read_configuration_object(obj_name : xtring);

  begin { read_configuration_object }
  end;  { read_configuration_object }


procedure report_expandable_id_to_ds(*id: name_ptr*);
var
  tmname : xtring;
  tmval : xtring;
  kind : xtring;  
  junk : name_ptr;	

begin
  if id <> NIL then
    begin
      tmname := nullstring;
      tmval := nullstring;
      kind := nullstring;
      junk := id;
      {copy_to_string(id^.name, tmname);}
      copy_to_string(junk^.name, tmname);
      if junk^.definition <> nullstring then copy_string(junk^.definition, tmval);
      kind := make_string_from_name_types(junk^.kind);
      if report_used_tm_to_ds(tmname, tmval, kind) <> 0 then;
    end;
end;


procedure dump_tree_information(var f: textfile; what: dump_debug_info_type);
                                                                      FORWARD;
procedure dump_basescript_list(var f: text; BS: basescript_ptr);      FORWARD;
procedure record_instance_for_synonyms(instance: signal_instance_ptr);
                                                                      FORWARD;


(**)     { ------- initialization routines ------- }


procedure init_output_files;
  { open output files and print list of files to be created }
begin
  if debugging then
    begin  post_compile_time(outfile, list_file);  writeln(outfile);  end;

  post_compile_time(CmpLog, list_file);  writeln(CmpLog);

  if files_to_generate * [CMPERR_FILE] <> [] then writeln(monitor);

  if CMPERR_FILE in files_to_generate then
    if rewrite_file(CmpErr, nullstring, CMPERR_FILE_NAME) then
      begin
        PrintCmpErr := TRUE;
        writeln(monitor, ' Writing editor error info in .......... ',
                         CmpErr_file_name);
        writeln(CmpErr, 'FILE_TYPE=CMP_ERRORS;');
      end;
end { init_output_files } ;


(**)     { ------- Time utility ------- }


(***************************************************************************)
(*                                                                         *)
(*  TIME UTILITIES                                                         *)
(*                                                                         *)
(*                                                                         *)
(*  These utilities are designed to work on the VAX, 370, and 1.  They  *)
(*  do not work for the ELXSI and this file should no be included when     *)
(*  makeing a version for that machine.                                    *)
(*                                                                         *)
(***************************************************************************)


{  There are two MACHINE DEPENDENT functions here:                          }
{                                                                           }
{     elapsed_time -- returns an integer which is                           }
{                     the time of day clock in milliseconds                 }
{                                                                           }
{     CPU_time     -- returns an integer which is                           }
{                     the process clock in milliseconds                     }


function elapsed_time: integer;
  { return the current elapsed time in milliseconds }
  const
    elapsed_clock_units = 1000; { system intrinsic units to millisecs }


    offset_to_hours     = 12;    { 1st char of hrs. in time string }
    offset_to_minutes   = 15;    { 1st char of min. in time string }
    offset_to_seconds   = 18;    { 1st char of sec. in time string }


  var
    current_time: time_string;   { current time in ASCII }
    hours,                       { current number of hours }
    minutes,                     { current number of minutes }
    seconds,                     { current number of seconds }
    hundredths: integer;         { current number of hundredths of seconds }


  function convert (var s: time_string; pos: integer): integer;
    { convert the next two digits of the given time string (from POS) into
      an integer. }
  begin
    convert := 10*(ord(s[pos]) - ord('0')) + (ord(s[pos+1]) - ord('0'));
  end { convert } ;


 begin { elapsed_time }


  seconds := epochsec;   convert_time(seconds, current_time);

  hours := convert(current_time, offset_to_hours);
  minutes := convert(current_time, offset_to_minutes);
  seconds := convert(current_time, offset_to_seconds);


  hundredths := 0;

  elapsed_time := hours      * (3600 * elapsed_clock_units) +
                  minutes    * (60   * elapsed_clock_units) +
                  seconds    * (1    * elapsed_clock_units) +
                  hundredths * (elapsed_clock_units DIV 100);
end { elapsed_time } ;


function CPU_time: integer;
  { return the current CPU time in milliseconds }
  const


    CPU_clock_units = 16.66; { system intinsic units -- 1/60th seconds }

begin


  CPU_time := trunc(vclock * CPU_clock_units);

end { CPU_time } ;


procedure init_time(*var current_elapsed_time,
                         current_CPU_time: integer*);
  { initialize the starting times }
begin
  current_elapsed_time := elapsed_time;
  current_CPU_time := CPU_time;
end { init_time_and_date } ;


procedure init_time_and_date(*var current_elapsed_time,
                                  current_CPU_time: integer;
                              var current_date: time_string*);
  { initialize the starting times and date for this compilation }
  var
    seconds: integer;               { current time in seconds }
begin
  init_time(current_elapsed_time, current_CPU_time);


  seconds := epochsec;  convert_time(seconds, current_date);

end { init_time_and_date } ;


procedure print_time(var f: textfile; current_time: integer);
  { print the time to the given file.  Output leading zeroes. }
  var
    hours, minutes, seconds,
    hundredths: integer;          { current time specifications }
begin
  { convert an integer (assumed to represent a time in units of
    CLOCK_UNITS) to hours, minutes, etc.  and return as globals. }

  hours := current_time DIV (3600*CLOCK_UNITS);
  current_time := current_time - (hours*3600*CLOCK_UNITS);
  minutes:= current_time DIV (60*CLOCK_UNITS);
  current_time := current_time - (minutes*60*CLOCK_UNITS);
  seconds:= current_time DIV CLOCK_UNITS;
  current_time := current_time - (seconds*CLOCK_UNITS);
  hundredths := current_time DIV (CLOCK_UNITS DIV 100);

  if hours < 10 then write(f, '0', hours:1)
                else write(f, hours:2);
  write(f, ':');
  if minutes < 10 then write(f, '0', minutes:1)
                  else write(f, minutes:2);
  write(f, ':');
  if seconds < 10 then write(f, '0', seconds:1)
                  else write(f, seconds:2);
  write(f, '.');
  if hundredths < 10 then write(f, '0', hundredths:1)
                     else write(f, hundredths:2);
end { print_time } ;


procedure exec_time(*var last_elapsed_time: integer;
                     var last_CPU_time: integer; just_delta: boolean*);
  { display the execution time, both CPU time and elapsed time.  If
    JUST_DELTA, then display only the delta time from last_CPU_time to the
    current CPU time and reset last_elapsed_time and last_CPU_time. }
  var
    current_elapsed_time,               { current elapsed time }
    current_CPU_time:  integer;         { calculated CPU time }


  procedure display_time_summary(var f: textfile);
    { write time summaries to the given file }
  begin
    writeln(f);
    write(f, ' Start time   = ');
    print_time(f, last_elapsed_time);  writeln(f);
    write(f, ' Ending time  = ');
    print_time(f, current_elapsed_time);  writeln(f);
    write(f, ' Elapsed time = ');
    if last_elapsed_time < current_elapsed_time then
      print_time(f, current_elapsed_time - last_elapsed_time)
    else
      print_time(f, (24*60*60*1000+current_elapsed_time) - last_elapsed_time);
    writeln(f);
    write(f, ' CPU time     = ');
    print_time(f, current_CPU_time - last_CPU_time);  writeln(f);
  end { display_time_summary } ;


begin { exec_time }
  current_elapsed_time := elapsed_time;    { get the current elapsed time }
  current_CPU_time     := CPU_time;        { get the current CPU time }
  
  if just_delta then
    begin
      write(monitor, '(');
      print_time(monitor, current_CPU_time - last_CPU_time);
      writeln(monitor, ')');
      write(CmpLog, '(');
      print_time(CmpLog, current_CPU_time - last_CPU_time);
      writeln(CmpLog, ')');
    end
  else
    begin
      display_time_summary(monitor);  writeln(monitor);
      display_time_summary(CmpLog);
      if PrintCmpLst then display_time_summary(CmpLst); { only one goes here }
    end;
  last_elapsed_time := current_elapsed_time;
  last_CPU_time := current_CPU_time;
end { exec_time } ;


(**)     { ------- compile time reporting ------- }


procedure post_compile_time(*var f: textfile; file_kind: file_kind_type*);
  { output the compile time to the specified output file }
  var
    i: 1..TIME_BUFFER_LENGTH;         { index into the compile date }
begin
  if file_kind = data_file then write(f, 'TIME=''');
  write(f, ' Compilation on ');


  for i := 1 to TIME_BUFFER_LENGTH do
    if islegal[compile_date[i]] then write(f, compile_date[i]);


  if file_kind = data_file then write(f, ''';');
  writeln(f);
end { post_compile_time } ;


function get_compile_time: xtring;
  { return the compile time as a string }
  var
    i: 1..TIME_BUFFER_LENGTH;         { index into the compile date }
    temp: xtring;                     { buffer for string building }
begin
  create_a_string(temp, MAX_STRING_LENGTH);  temp^[0] := chr(0);
  
  if add_alpha_to_string(temp, ' Compilation on ') then ;
  if add_char_to_string(temp, ' ') then ;

  for i := 1 to TIME_BUFFER_LENGTH do
    if islegal[compile_date[i]] then
      if add_char_to_string(temp, compile_date[i]) then ;
  get_compile_time := enter_string(temp);
  temp^[0] := chr(MAX_STRING_LENGTH);
  release_string(temp);
end { get_compile_time } ;


(**)     { ------- check the path name for debug enable ------- }


procedure check_path_debug(node: mtree_node_ptr);
  { check the current PATH property against the match path name and set the
    debug flags if a match is found. }
  var
    i: debug_flag_range;      { enumerates all debug flags for test }
    prop: property_ptr;       { path property }
begin
  if find_property(node^.called_by^.properties, PATH_prop_name, prop) then
    begin
      if CmpStrEQ(prop^.text, path_for_debug) then
        begin
          for i := 0 to MAX_DEBUG_FLAG_NUMBER do
            if i IN debug_flags then
              case i of
                0:   debug     := TRUE;
                1:   debug_1   := TRUE;
                2:   debug_2   := TRUE;
                3:   debug_3   := TRUE;
                4:   debug_4   := TRUE;
                5:   debug_5   := TRUE;
                6:   debug_6   := TRUE;
                7:   debug_7   := TRUE;
                8:   debug_8   := TRUE;
                9:   debug_9   := TRUE;
                10:  debug_10  := TRUE;
                11:  debug_11  := TRUE;
                12:  debug_12  := TRUE;
                13:  debug_13  := TRUE;
                14:  debug_14  := TRUE;
                15:  debug_15  := TRUE;
                16:  debug_16  := TRUE;
                17:  debug_17 := TRUE;
                18:  debug_18 := TRUE;
                19:  debug_19 := TRUE;
                20:  debug_20 := TRUE;
                21:  debug_21 := TRUE;
                22:  debug_22 := TRUE;
                23:  debug_23 := TRUE;
                24:  debug_24 := TRUE;
                25:  debug_25 := TRUE;
                26:  debug_26 := TRUE;
                27:  debug_27 := TRUE;
                28:  debug_28 := TRUE;
                29:  debug_29 := TRUE;
                30:  debug_30 := TRUE;
                31:  debug_31 := TRUE;
                32:  debug_32 := TRUE;
              end;
          debug_at_path := FALSE;
        end;

      if CmpStrEQ(prop^.text, path_for_undebug) then
        begin
          for i := 0 to MAX_DEBUG_FLAG_NUMBER do
            if i IN undebug_flags then
              case i of
                0:   debug     := FALSE;
                1:   debug_1   := FALSE;
                2:   debug_2   := FALSE;
                3:   debug_3   := FALSE;
                4:   debug_4   := FALSE;
                5:   debug_5   := FALSE;
                6:   debug_6   := FALSE;
                7:   debug_7   := FALSE;
                8:   debug_8   := FALSE;
                9:   debug_9   := FALSE;
                10:  debug_10  := FALSE;
                11:  debug_11  := FALSE;
                12:  debug_12  := FALSE;
                13:  debug_13  := FALSE;
                14:  debug_14  := FALSE;
                15:  debug_15  := FALSE;
                16:  debug_16  := FALSE;
                17:  debug_17 := FALSE;
                18:  debug_18 := FALSE;
                19:  debug_19 := FALSE;
                20:  debug_20 := FALSE;
                21:  debug_21 := FALSE;
                22:  debug_22 := FALSE;
                23:  debug_23 := FALSE;
                24:  debug_24 := FALSE;
                25:  debug_25 := FALSE;
                26:  debug_26 := FALSE;
                27:  debug_27 := FALSE;
                28:  debug_28 := FALSE;
                29:  debug_29 := FALSE;
                30:  debug_30 := FALSE;
                31:  debug_31 := FALSE;
                32:  debug_32 := FALSE;
              end;
          undebug_at_path := FALSE;
        end;
    end;
end { check_path_debug } ;


(**)     { ------- dump routines ------- }


function copy_bit_subscript(source_subscript: subscript_ptr): subscript_ptr;
                                                                      FORWARD;

procedure dump_bit_property_list(var f: textfile;
                                 list: bit_property_ptr);             FORWARD;


procedure dump_subscript_property(var f: textfile;
                                  prop: subscript_property_ptr);      FORWARD;


procedure dump_subscript_property_list(var f: textfile;
                                       list: subscript_property_ptr); FORWARD;


procedure dump_path_name(var f: textfile;  node: mtree_node_ptr);
  { dump the path name to f, with parens }
  var
    prop: property_ptr;  { path property }
begin
  if node^.called_by = NIL then prop := NIL
  else if find_property(node^.called_by^.properties,
                        PATH_prop_name, prop) then  ;

  if (prop <> NIL) then
    begin
      write(f, '(');
      if prop <> NIL then print_string(f, prop^.text);
      write(f, ')');
    end;
end { dump_path_name } ;


procedure print_signal_name(var f: textfile; polarity: signal_polarity;
                            name: xtring; is_const: boolean;
                            node: mtree_node_ptr);
  { write the signal name with path name to the file with closing ' }
begin
  write(f, OUTPUT_QUOTE_CHAR);
  if is_const or (node = NIL) then dump_signal_polarity(f, polarity)
  else
    begin
      dump_signal_polarity(f, polarity);
      dump_path_name(f, node);
    end;

  print_string_repeat_quotes(f, name);

  write(f, OUTPUT_QUOTE_CHAR);
end { print_signal_name } ;


procedure dump_virtual_spec(var f: textfile; def: signal_definition_ptr);
  { dump a specification of the "virtualness" of the def }
begin
  if (def^.net_id <> nullstring) or not def^.is_virtual_base then
    begin
      write(f, ' (');
      print_string(f, def^.net_id);
      if not def^.is_virtual_base then write(f, '+');
      write(f, ') ');
    end;
end { dump_virtual_spec } ;


procedure dump_signal_instance_noCRLF(var f: textfile;
                                      instance: signal_instance_ptr);
  { print the signal instance to the specified file with no CRLF }
    var
      negation: signal_polarity; { Whether or not to print a negation char }


  procedure dump_constant(var f: textfile; instance: signal_instance_ptr);
    { dump out a constant bit by bit as a concatenated signal.
      A constant is, by definition, bit numbered starting with 0 }
    var
      signal_name: xtring;       { name of the signal (constant digits) }
      length: string_range;      { length of the constant 'signal name' }
      bit: -1..MAX_BIT_VALUE;    { bit being printed }
      sub: subscript_ptr;        { current subscript }
      first_digit: boolean;      { TRUE if this is the first digit of const }
      replication: replication_range;    { replication of the signal }
      rep_value: replication_range;      { current replicated value }
      last_bit: char;                    { last constant output value }


    procedure write_bit(bit: bit_range);
      { write out the bit.  If complemented, then complement it }
      var
        ch: char;        { constant 'digit' to be output }
    begin
      if left_to_right then ch := signal_name^[bit+1]
                       else ch := signal_name^[length-bit];
      if ch = last_bit then rep_value := rep_value + 1
      else
        begin
          if first_digit then first_digit := FALSE
          else
            begin
              write(f, OUTPUT_QUOTE_CHAR);
              if rep_value > 1 then
                write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR,
                         'REP=''', rep_value:1, '''');
              rep_value := 1;
              write(f, concatenation_char);
            end;

          write(f, OUTPUT_QUOTE_CHAR);

          write(f, ch);
        end;

      last_bit := ch;
    end { write_bit } ;


  begin { dump_constant }
    signal_name := instance^.defined_by^.signal^.name;
    first_digit := TRUE;  replication := instance^.replication_factor;
    last_bit := chr(0);  rep_value := 1;
    repeat
      sub := instance^.bit_subscript;  length := ord(signal_name^[0]);
      if sub = NIL then write_bit(0)    { it's a scalar }
      else
        while sub <> NIL do
          begin
            bit := sub^.left_index;
            if bit <= sub^.right_index then
              repeat
                write_bit(bit);  bit := bit + 1;
              until bit > sub^.right_index
            else
              repeat
                write_bit(bit);  bit := bit - 1;
              until bit < sub^.right_index;
            sub := sub^.next;
          end;

      replication := replication - 1;
    until replication <= 0;
    write(f, OUTPUT_QUOTE_CHAR);

    if rep_value > 1 then
      write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR,
               'REP=''', rep_value:1, '''');
  end { dump_constant } ;


begin { dump_signal_instance_noCRLF }
  if instance <> NIL then
    with instance^.defined_by^ do
      if is_const then
        dump_constant(f, instance)
      else
        begin
	  if instance^.low_asserted then
	    if polarity = COMPLEMENTED then negation := NORMAL
	    else if polarity = NORMAL then negation := COMPLEMENTED
	    else negation := polarity
	  else negation := polarity;

          print_signal_name(f, negation, signal^.name, is_const, node);

          dump_bit_subscript(f, instance^.bit_subscript, kind);

          if instance^.low_asserted then write (f, '*');

          if debugging then
            dump_virtual_spec(f, instance^.defined_by);

          if instance^.replication_factor <> 1 then
            write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR, 'REP=''',
                     instance^.replication_factor:1, '''');
        end;
end { dump_signal_instance_noCRLF } ;


procedure dump_signal_instance(var f:textfile; instance: signal_instance_ptr);
  { dump the given signal instance to the given file with a CRLF }
begin
  dump_signal_instance_noCRLF(f, instance);
  writeln(f);
end { dump_signal_instance } ;


(**)     { ------- dump a signal definition ------- }


procedure dump_signal_definition(var f: textfile; sig: signal_definition_ptr);
  { dump the given signal definition and its signal instances }
  var
    instance: signal_instance_ptr;     { the instance to be dumped }
begin
  if sig = NIL then writeln(f)
  else
    begin
      print_signal_name(f, sig^.polarity, sig^.signal^.name,
                           sig^.is_const, sig^.node);

      dump_virtual_spec(f, sig);

      if sig^.kind = VECTOR then
        dump_left_and_right(f, sig^.left_index, sig^.right_index)
      else if sig^.kind = UNDEFINED then
        write(f, '<UNDEFINED>');

      if sig^.is_const then writeln(f)
      else
        begin
          write(f, ' {');
          writestring(f, scope_table[sig^.scope]);
          write(f, '} ->defined in: ');
          writestring(f, sig^.node^.macro_name);
          writeln(f, '(', sig^.node^.level:1, ')');
        end;

      instance := sig^.instances;
      while instance <> NIL do
        begin
          write(f, '    ');

          dump_signal_instance(f, instance);

          instance := instance^.next;
        end;

      if sig^.synonym_bits <> NIL then writeln(f, '  -- properties --');
      dump_bit_property_list(f, sig^.properties);
    end;
end { dump_signal_definition } ;


procedure dump_def(var f: textfile; sig: signal_definition_ptr);
  { dump the signal definition to the given file }
begin
  if sig = NIL then writeln(f, '<NIL sig def>')
  else 
    begin
      if sig^.signal = NIL then write(f, '<NIL sig^.signal>')
      else print_signal_name(f, sig^.polarity, sig^.signal^.name,
                                sig^.is_const, NIL);

      dump_virtual_spec(f, sig);

      if sig^.kind = VECTOR then
        dump_left_and_right(f, sig^.left_index, sig^.right_index)
      else if sig^.kind = UNDEFINED then
        write(f, '<UNDEFINED>');

      writeln(f);
    end;
end { dump_def } ;


procedure dump_virtual_defs(var f: textfile; def: signal_definition_ptr);
  { dump the given signal definition and all of its virtual defs }
  var
    found: boolean;                        { TRUE if base def found }
    current_def,                           { current def in search }
    virtual_def: signal_definition_ptr;    { current virtual def }
begin
  if not def^.is_virtual_base then
    begin
      write(f, 'Def supplied is not virtual base: ');
      dump_def(f, def);

      { this def is not the non-virtual base: find the correct def }

      current_def := def^.node^.signals;  found := FALSE;
      while (current_def <> NIL) and not found do
        if (current_def^.signal^.name = def^.signal^.name) and
	   (current_def^.polarity = def^.polarity) then
          found := TRUE
        else
          current_def := current_def^.next;

      if found then def := current_def else assert(195);
    end;

  write(f, 'Virtual base signal: ');
  dump_def(f, def);

  virtual_def := def^.next_virtual_def;
  while virtual_def <> NIL do
    begin
      write(f, '            virtual: ');
      dump_def(f, virtual_def);

      virtual_def := virtual_def^.next_virtual_def;
    end;
end { dump_virtual_defs } ;


(**)     { ------- dump a list of signal definitions ------- }


procedure dump_signal_definition_list(var f: textfile;
                                      list: signal_definition_list_ptr);
  { dump the signal definitions in the given list }
  var
    current_signal: signal_definition_list_ptr; { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal^.definition);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_signal_definition_list } ;


procedure dump_list_of_signal_definitions(var f: textfile;
                                          list: signal_definition_ptr);
  { dump a list of signal definitions headed by the given signal def }
  var
    current_signal: signal_definition_ptr;    { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_list_of_signal_definitions } ;


procedure dump_signal_definitions_with_basescripts(
  var f: textfile;  list: signal_definition_ptr);
  { dump a list of signal definitions (with basescripts) 
    headed by the given signal def }
  var
    current_signal: signal_definition_ptr;    { current signal in the list }
begin
  current_signal := list;
  while current_signal <> NIL do
    begin
      dump_signal_definition(f, current_signal);

      writeln(f, '  -- basescripts --');
      dump_basescript_list(f, current_signal^.synonym_bits);

      current_signal := current_signal^.next;
    end;

  writeln(f);
end { dump_signal_definitions_with_basescripts } ;


(**)     { ------- dump the signal scope ------- }


procedure print_signal_scope(var f: textfile;  scope: scope_type);
  { print the signal scope to the given file }
begin
  case scope of
    UNKNOWN_SCOPE:  ;
    XINTERFACE:     write(f, general_property_prefix_char, 'I');
    LOCAL:          write(f, general_property_prefix_char, 'L');
    GLOBAL:         write(f, general_property_prefix_char, 'G');
    DECLARED:       write(f, general_property_prefix_char, 'D');
    SIG_CONST:      ;
  end;
end { print_signal_scope } ;


(**)     { ------- dump a concatenated list of signals ------- }


procedure dump_propertied_CS(var f: textfile; signal: propertied_CS_ptr);
  { dump the concatenated signal to the specified file }
  var
    PCSP: propertied_CS_ptr;      { concatenated signal being printed }
    prop: property_ptr;           { current property in the property list }
begin
  PCSP := signal;
  if PCSP = NIL then writeln(f, '<NIL>');
  while PCSP <> NIL do
    begin
      if debug_11 then
        case PCSP^.control of
          IGNORE_ALL:     write(f, 'IA>');
          IGNORE_PIN:     write(f, 'IP>');
          NORMAL_SIGNAL:  write(f, 'NS>');
        end;

      dump_signal_instance_noCRLF(f, PCSP^.instance);

      prop := PCSP^.properties;
      while prop <> NIL do
        begin
          write(f, DEFAULT_GENERAL_PROPERTY_PREFIX_CHAR);
          writealpha(f, prop^.name^.name);
          write(f, '=');
          print_string_with_quotes(f, prop^.text);

          prop := prop^.next;
          writeln(f);
        end;

      PCSP := PCSP^.next;

      if PCSP <> NIL then
        begin  writeln(f, ':');  write(f, '    ');  end;
    end;

  writeln(f);
end { dump_propertied_CS } ;


(**)     { ------- dump a formal/actual parameter list ------- }


procedure dump_actual_list_element(var f: textfile; actual: actual_list_ptr);
  { dump the given acutal list element to the given file }
begin
  write(f, '  Actual (');
  if actual^.width_is_unknown then write(f, 'width unknown')
                              else write(f, 'width known');
  write(f, ';assertion ');
  case actual^.assertion_state of
    ASSERTION_KNOWN: write(f, 'KNOWN');
    ASSERTION_UNKNOWN: write(f, 'UNKNOWN');
    ASSERTION_CHECKED: write(f, 'CHECKED');
    OTHERWISE write(f, ord(actual^.assertion_state):1);
  end;
  write(f, '): ');
 
  write(f, '    ');

  dump_propertied_CS(f, actual^.signal);
end { dump_actual_list_element } ;


procedure dump_actual_list(var f: textfile; actual_list: actual_list_ptr);
  { dump all of the elements of the given actual list }
  var
    actual: actual_list_ptr;     { current actual list element }
begin
  actual := actual_list;
  while actual <> NIL do
    begin
      dump_actual_list_element(f, actual);

      actual := actual^.next;
    end;
end { dump_actual_list } ;


procedure dump_simple_signal(var f: textfile; signal: simple_signal_ptr);
  { dump the given signal to the given file }
begin
  dump_polarity(f, signal^.polarity);
  print_string_with_quotes(f, signal^.signal_name);
  dump_bit_subscript(f, signal^.bit_subscript, signal^.kind);
end { dump_simple_signal } ;


procedure dump_formal_actual(var f: textfile; FAP: formal_actual_ptr);
  { dump the given formal/actual }
  var
    actual: actual_list_ptr;   { current actual on formal }
begin
  if FAP <> NIL then
    begin
      write(f, 'Formal (width=', FAP^.width:1, '; pol=');
      dump_polarity(f, FAP^.polarity);
      write(f, '): ');
      if FAP^.formal_parameter <> NIL then
        dump_signal_instance(f, FAP^.formal_parameter)
      else
        begin
          dump_simple_signal(f, FAP^.pin_name);  writeln(f);
        end;
          

      if FAP^.properties <> NIL then
        begin
          writeln(f, '  Subscript properties:');
          dump_subscript_property_list(f, FAP^.properties);
        end;

      actual := FAP^.actual_parameter;
      while actual <> NIL do
        begin
          dump_actual_list_element(f, actual);

          actual := actual^.next;
        end;
    end;
end { dump_formal_actual } ;


procedure dump_formal_actual_list(var f: textfile;
                                  list: formal_actual_ptr);
  { dump the list of formal/actual signals }
  var
    FAP: formal_actual_ptr;    { current pair to be printed }
begin
  writeln(f, 'Dump of the Formal/Actual list');

  FAP := list;
  while FAP <> NIL do
    begin
      dump_formal_actual(f, FAP);

      FAP := FAP^.next;
    end;
end { dump_formal_actual_list } ;


(**)     { ------- dump a signal stack ------- }


procedure dump_def_stack(var f: textfile; signal_def: signal_definition_ptr);
  { dump the stack starting with the given signal definition (SIGNAL_DEF) }
  var
    def: signal_definition_ptr;    { current definition in the stack }
    last_level: level_range;       { last level of the stack }
begin
  def := signal_def;
  if def <> NIL then
    if def^.is_const then writeln(f, '  constant stack')
    else
      begin
        last_level := MAX_TREE_DEPTH;
        while def <> NIL do
          begin
            write(f, '  ');
            dump_path_name(f, def^.node);
            writestring(f, def^.node^.macro_name);
            write(f, ' (lev=', def^.node^.level:1, ');  scope=');
            writestring(f, scope_table[def^.scope]);
            writeln(f);

            if last_level <= def^.node^.level then
              begin
                writeln(f, '  ** BOGUS STACK!! **');
                def := NIL;
              end
            else
              begin
                last_level := def^.node^.level;
                def := def^.stack;
              end;
          end;
      end;
end { dump_def_stack } ;


procedure dump_stack(var f: textfile; entry: signal_entry_ptr);
  { dump the signal stack associated with ENTRY }
begin
  writeln(f);
  writestring(f, entry^.name);  writeln(f, '  -> the NORMAL stack <-');
  dump_def_stack(f, entry^.high_asserted);

  writestring(f, entry^.name);  writeln(f, '  -> the COMPLEMENTED stack <-');
  dump_def_stack(f, entry^.low_asserted);
end { dump_stack } ;


(**)     { ------- dump an mtree node  ------- }


procedure dump_mtree_node(var f: textfile; node: mtree_node_ptr);
  { print the node (pathn and macro name) to f unless it is the root node }
  var
    prop: property_ptr;       { path property }
begin
  if node^.father_node <> NIL then
    begin
      write(f, 'Body=''');
      print_string(f, node^.macro_name);
      write(f,'''');
      if node^.called_by = NIL then writeln(f)
      else
        if not find_property(node^.called_by^.properties,
	                     PATH_prop_name, prop) then writeln(f)
        else
          begin
            write(f, '  Path (''');
            print_string(f, prop^.text);
            writeln(f, ')''');
          end;

      if node^.father_node^.father_node <> NIL then
        begin
          write(f, 'Drawing=''');
	  print_string(f, node^.father_node^.macro_name);
	  writeln(f, '''');
        end;
    end;
end { dump_mtree_node } ;


(**)     { ------- dump a signal definition to the error files ------- }


procedure error_dump_signal_def(def: signal_definition_ptr);
  { dump a signal definition to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, def^.polarity);

    print_string(f, def^.signal^.name);

    if def^.kind = VECTOR then
      dump_left_and_right(f, def^.left_index, def^.right_index);

    if not def^.is_const then
      if (def^.scope <> LOCAL) or not scope_is_local then
        print_signal_scope(f, def^.scope);
  end { print_signal } ;


begin { error_dump_signal_def }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');
  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_def } ;


procedure error_dump_subscript(s: subscript_ptr);
begin
  if ok_to_print_error then
    begin
      dump_bit_subscript(CmpLog, s, VECTOR);
      if PrintCmpLst then dump_bit_subscript(CmpLst, s, VECTOR)
                     else dump_bit_subscript(Monitor, s, VECTOR);
      if debugging then dump_bit_subscript(Outfile, s, VECTOR);
    end;
end {  error_dump_subscript } ;


procedure error_dump_signal_instance(instance: signal_instance_ptr);
  { dump a signal instance to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript,
                          instance^.defined_by^.kind);

    if instance^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               instance^.replication_factor:1);

    if not instance^.defined_by^.is_const then
      print_signal_scope(f, instance^.defined_by^.scope);
  end { print_signal } ;


begin { error_dump_signal_instance }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_instance } ;


(**)     { ------- dump a signal descriptor to the error files ------- }


procedure error_dump_signal_descriptor(*signal: signal_descriptor_ptr*);
  { dump a signal descriptor to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, signal^.polarity);

    print_string(f, signal^.signal_name);

    dump_bit_subscript(f, signal^.bit_subscript, signal^.kind);

    if signal^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               signal^.replication_factor:1);

    print_signal_scope(f, signal^.scope);
  end { print_signal } ;


begin { error_dump_signal_descriptor }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  signal = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_signal_descriptor } ;


(**)     { ------- dump a formal sig descrip to the error files ------- }


procedure error_dump_formal(formal: signal_descriptor_ptr);
  { dump a formal signal descriptor to the error files }
  var
    p: property_ptr;      { used to search for bubbled property }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, formal^.polarity);

    print_string(f, formal^.signal_name);

    dump_bit_subscript(f, formal^.bit_subscript, formal^.kind);
  end { print_signal } ;


begin { error_dump_formal }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_char(' ');

  if find_property(formal^.properties, BUBBLED_prop_name, p) then
    error_dump_alpha('(has BUBBLE)    ')
  else
    error_dump_alpha('(no BUBBLE)     ');

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal } ;


(**)     { ------- dump a formal sig def to the error files ------- }


procedure error_dump_formal_sig_def(formal: signal_definition_ptr);
  { dump a formal signal definition to the error files }
  var
    p: bit_property_ptr;      { used to search for bubbled property }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, formal^.polarity);

    print_string(f, formal^.signal^.name);

    if formal^.kind = VECTOR then
      dump_left_and_right(f, formal^.left_index, formal^.right_index);
  end { print_signal } ;


begin { error_dump_formal_sig_def }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_char(' ');

  if find_bit_property(formal^.properties, BUBBLED_prop_name, p) then
    error_dump_alpha('(has BUBBLE)    ')
  else
    error_dump_alpha('(no BUBBLE)     ');

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal_sig_def } ;


(**)     { ------- dump a formal param instance ------- }


procedure error_dump_formal_instance(instance: signal_instance_ptr);
  { dump a formal signal instance to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript, instance^.defined_by^.kind);
  end { print_signal } ;


begin { error_dump_formal_instance }
  error_dump_indent(INDENT);
  error_dump_alpha('Pin name=       ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);

  error_dump_CRLF;

  if PrintCmpErr and ok_to_print_error then
    begin
      write(CmpErr, '  pin_name = ''');
      print_signal(CmpErr);
      writeln(CmpErr, ''';');
    end;
end { error_dump_formal_instance } ;


(**)     { ------- dump a list of pin names ------- }


procedure error_dump_all_pin_names(pin_name_list: formal_actual_ptr);
  { dump a list of pin names to the error files }
  var
    element: formal_actual_ptr;    { element of formal/actual list }


  procedure print_signal(var f: textfile; instance: signal_instance_ptr);
    { print the signal }
  begin
    dump_signal_polarity(f, instance^.defined_by^.polarity);

    print_string(f, instance^.defined_by^.signal^.name);

    dump_bit_subscript(f, instance^.bit_subscript, instance^.defined_by^.kind);

    if instance^.replication_factor <> 1 then
      write(f, general_property_prefix_char, 'R ',
               instance^.replication_factor:1);
  end { print_signal } ;


begin { error_dump_all_pin_names }
  error_dump_indent(INDENT);
  error_dump_alpha('Pins of the body');
  error_dump_char(':');
  error_dump_CRLF;

  element := pin_name_list;
  while element <> NIL do
    begin
      error_dump_indent(indent + DEFAULT_INDENT);
      if ok_to_print_error then
        if PrintCmpLst then print_signal(CmpLst, element^.formal_parameter)
                       else print_signal(monitor, element^.formal_parameter);

      print_signal(CmpLog, element^.formal_parameter);

      if debugging then print_signal(outfile, element^.formal_parameter);

      error_dump_CRLF;

      element := element^.next;
    end;
end { error_dump_all_pin_names } ;


(**)     { ------- dump a signal to the error files ------- }


procedure error_dump_signal(polarity: signal_polarity; name: xtring;
                            sub: subscript_ptr);
  { dump a signal name for error listings }


  procedure print_signal(var f: textfile);
    { print the signal to the file }
  begin
    dump_signal_polarity(f, polarity);

    print_string(f, name);

    if sub = NIL then dump_bit_subscript(f, sub, SINGLE)
                 else dump_bit_subscript(f, sub, VECTOR);
  end { print_signal } ;


begin
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);

  if debugging then print_signal(outfile);
end { error_dump_signal } ;


(**)     { ------- dump a concatenated signal to the error files ------- }


procedure error_dump_propertied_CS(signal: propertied_CS_ptr);
  { dump a concatenated signal to the error files }


  procedure print_signal(var f: textfile);
    { print the signal }
    var
      PCSP: propertied_CS_ptr;   { current signal to be output }
  begin
    PCSP := signal;
    while PCSP <> NIL do
      with PCSP^.instance^ do
        begin
          dump_signal_polarity(f, defined_by^.polarity);

          print_string(f, defined_by^.signal^.name);

          dump_bit_subscript(f, bit_subscript, defined_by^.kind);

          if replication_factor <> 1 then
            write(f, general_property_prefix_char, 'R ', replication_factor:1);

          if PCSP^.next <> NIL then
            begin  
	      writeln(f, ':');  write(f, ' ':indent + (2 * DEFAULT_INDENT));
            end;

          PCSP := PCSP^.next;
        end;
  end { print_signal } ;


begin { error_dump_propertied_CS }
  error_dump_indent(INDENT);
  error_dump_alpha('Signal=         ');

  if ok_to_print_error then
    if PrintCmpLst then print_signal(CmpLst) else print_signal(monitor);

  print_signal(CmpLog);
  if debugging then print_signal(outfile);

  error_dump_CRLF;
end { error_dump_propertied_CS } ;


(**)     { ------- dump a path name to the error files ------- }


procedure error_dump_path_name(node: mtree_node_ptr);
  { print the path name to the error files }
  var
    prop: property_ptr;  { path property }
begin
  if ok_to_print_error then
    begin
      if node^.called_by = NIL then prop := NIL
      else if find_property(node^.called_by^.properties, 
	                    PATH_prop_name, prop) then  ;

      if (prop <> NIL) then
        begin
          error_dump_char('(');
	  if prop <> NIL then error_dump_string(prop^.text);
	  error_dump_char(')');
        end;
    end;
end { error_dump_path_name } ;


(**)     { ------- dump an mtree node to the error files ------- }


procedure error_dump_mtree_node(node: mtree_node_ptr);
  { print the node (path and macro name) on the error files unless it
    is the root }
  var
    prop: property_ptr;  { path property }
begin
  if node^.father_node <> NIL then
    begin
      error_dump_indent(INDENT);
      error_dump_alpha('Body=           ');
      error_dump_path_name(node);
      error_dump_string(node^.macro_name);
      error_dump_CRLF;
  
      if node^.father_node^.father_node <> NIL then
        begin
          error_dump_alpha('Drawing=        ');
	  error_dump_string(node^.father_node^.macro_name);
	  error_dump_CRLF;
        end;
    end;
end { error_dump_mtree_node } ;


(**)     { ------- subscript utilities ------- }


function bits_in_common(subscript1, subscript2: subscript_ptr): boolean;
  { return TRUE if the given subscripts have any bits in common }
  var
    sub1,                        { current element of first subscript }
    sub2: subscript_ptr;         { current element of second subscript }
    found: boolean;              { TRUE if a bit in common was found }
    left,                        { left index of current first subscript }
    right: bit_range;            { right index of current first subscript }
begin
  sub1 := subscript1;  found := FALSE;
  while (sub1 <> NIL) and not found do
    begin
      left := sub1^.left_index;
       right := sub1^.right_index;

      sub2 := subscript2;
      while (sub2 <> NIL) and not found do
        begin
          if sub2^.left_index >= sub2^.right_index then
            begin
              if (left <= sub2^.left_index) and
                 (left >= sub2^.right_index) then
                found := TRUE
              else if (right <= sub2^.left_index) and
                      (right >= sub2^.right_index) then
                found := TRUE;
            end
          else
            if (left >= sub2^.left_index) and
               (left <= sub2^.right_index) then
              found := TRUE
            else if (right >= sub2^.left_index) and
                    (right <= sub2^.right_index) then
              found := TRUE;
            
          if not found then sub2 := sub2^.next;
        end;

      if not found then sub1 := sub1^.next;
    end;

  bits_in_common := found;
end { bits_in_common } ;


(**)     { ------- subscript property utilities ------- }


  (************************************************************************)
  (*                                                                      *)
  (*  Subscript properties are used to represent properties on a signal.  *)
  (*  Each property list has an associated subscript describing the bits  *)
  (*  of the signal possessing that property.                             *)
  (*                                                                      *)
  (*  It is assumed that:                                                 *)
  (*      1.  Properties that refer to the entire signal are given left   *)
  (*          and right indexes of -1.                                    *)
  (*      2.  A specific left and right index only appears once in a      *)
  (*          subscript property list.                                    *)
  (*  There is no attempt to compress subscripts.                         *)
  (*                                                                      *)
  (************************************************************************)


procedure dump_subscript_property(*var f: textfile;
                                  prop: subscript_property_ptr*);
  { dump the given subscript property (PROP) to the given file (F). }
begin
  if prop <> NIL then
    begin
      write(f, '  <', prop^.left_index:1);
      if prop^.left_index <> prop^.right_index then
        write(f, '..', prop^.right_index:1);
      writeln(f, '>:');

      dump_property_list(f, prop^.properties);
    end;
end { dump_subscript_property } ;


procedure dump_subscript_property_list(*var f: textfile;
                                       list: subscript_property_ptr*);
  { dump the given subscript property list (LIST) to the given file (F). }
  var
    prop: subscript_property_ptr;    { current property }
begin
  prop := list;
  while prop <> NIL do
    begin
      dump_subscript_property(f, prop);

      prop := prop^.next;
    end;
end { dump_subscript_property_list } ;


procedure delete_duplicate_subscript_properties
                                      (var properties: subscript_property_ptr;
                                       property_name: name_ptr;
                                       property_value: xtring);
  { delete the given property from any property lists other than the one
    referring to the entire bit subscript }
  var
    previous_prop,                          { previous element in list }
    next_prop,                              { next element in the list }
    current_prop: subscript_property_ptr;   { current element in the list }
    previous,                               { previous property in list }
    next,                                   { next property in the list }
    prop: property_ptr;                     { current property in the list }
begin
  current_prop := properties;  previous_prop := NIL;
  while current_prop <> NIL do
    begin
      next_prop := current_prop^.next;

      if (current_prop^.left_index <> -1) then
        begin
          { search for and delete identical properties to one added }

          prop := current_prop^.properties;  previous := NIL;
          while prop <> NIL do
            if (prop^.name = property_name) and
               (prop^.text = property_value) then
              begin
                next := prop^.next;
                if previous = NIL then
                  current_prop^.properties^.next := next
                else
                  previous^.next := next;
                release_property(prop);
                prop := next;
              end
            else
              begin  previous := prop;  prop := prop^.next;  end;

          { if all properties have been deleted from the subscript
            property, remove subscript property from the list }

          if current_prop^.properties = NIL then
            if previous_prop = NIL then
              begin
                properties := next_prop;
                release_subscript_property(current_prop);
                current_prop := NIL;
              end
            else
              begin
                previous_prop^.next := next_prop;
                release_subscript_property(current_prop);
                current_prop := previous_prop;
              end;
        end { if } ;

      previous_prop := current_prop;
      current_prop := next_prop;
    end { while } ;
end { delete_duplicate_subscript_properties } ;


procedure add_properties_to_subscript_property
                                   (var property_list: subscript_property_ptr;
                                    left_bit, right_bit: bit_range;
                                    properties: property_ptr);
  { add the properties from the given property list (PROPERTIES) to the given
    destination list (PROPERTY_LIST).  The subscript for which the property
    applies is given by LEFT_BIT and RIGHT_BIT.  If these are -1, the
    property applies to the entire signal (this is also the representation
    for a scalar's bits). }
  var
    source_prop: property_ptr;        { current source property }
    prop: subscript_property_ptr;     { current property in the list }
    found: boolean;                   { TRUE if subscript bits found }
begin
  if properties <> NIL then
    begin
      { find the proper subscript property element }

      prop := property_list;  found := FALSE;
      while (prop <> NIL) and not found do
        begin
          if (prop^.left_index = left_bit) and
             (prop^.right_index = right_bit) then
            found := TRUE;

          if not found then prop := prop^.next;
        end;

      if not found then
        begin
          new_subscript_property(property_list);
          prop := property_list;
          prop^.left_index := left_bit;
          prop^.right_index := right_bit;
        end;

      { add the properties to the list }

      source_prop := properties;
      while source_prop <> NIL do
        begin
          add_to_prop_list(prop^.properties,
                           source_prop^.name, source_prop^.text);

          if (left_bit = -1) and (right_bit = -1) then
            delete_duplicate_subscript_properties(property_list,
                                                  source_prop^.name,
                                                  source_prop^.text);

          source_prop := source_prop^.next;
        end;
    end;
end { add_properties_to_subscript_property } ;


procedure add_pin_properties_to_subscript_property
                                   (var property_list: subscript_property_ptr;
                                    left_bit, right_bit: bit_range;
                                    properties: property_ptr);
  { add the inherit pin properties from the given property list (PROPERTIES)
    to the given destination list (PROPERTY_LIST).  The subscript for which
    the property applies is given by LEFT_BIT and RIGHT_BIT.  If these are -1,
    the property applies to the entire signal (this is also the representation
    for a scalar's bits).  }
  var
    props: property_ptr;              { new property list of just pin props }
    source_prop: property_ptr;        { current source property }
begin
  source_prop := properties;  props := NIL;
  while source_prop <> NIL do
    begin
      if INHERIT_PIN IN source_prop^.name^.kind then
        add_to_prop_list(props, source_prop^.name, source_prop^.text);

      source_prop := source_prop^.next;
    end;

  if props <> NIL then
    begin
      new_subscript_property(property_list);
      property_list^.properties := props;
      property_list^.left_index := left_bit;
      property_list^.right_index := right_bit;
    end;
end { add_pin_properties_to_subscript_property } ;


procedure copy_unique_properties_to_subscript
                                      (var properties: subscript_property_ptr;
                                       prop_list: property_ptr);
  { copy the properties in the given list (PROP_LIST) to the given
    subscript property list (PROPERTIES).  Do not copy the property if it
    already appears in the list.  A subscript of -1 implies that the property
    is a property of the entire signal.  This routine assumes that the
    properties to be added to the destination list apply to every bit of the
    signal. }
  var
    