#include <stdio.h>
#include "lib/misc/platform.h"


typedef void (*void_function_ptr)();


static void_function_ptr saved_notifier;
static char *saved_link;

static void fake_notifier()
{
#ifdef SVS
    handler_wrap(saved_notifier, saved_link);
#else
    /* Note -- for VMS, we assume we don't really need the static link.  To
       really set it, we would need to slam it into R1 right here. */
    (*saved_notifier)(saved_link);
#endif SVS
}


void
#if SVS || PMAX
add_init(static_link, parse_error_notifier)
#else
add_init(parse_error_notifier, static_link)
#endif !SVS && !PMAX
#ifdef VMS
void_function_ptr *parse_error_notifier; /* VMS passes address by reference */
#else
void_function_ptr parse_error_notifier;
#endif VMS
char *static_link;
{
#ifdef VMS
    saved_notifier = *parse_error_notifier;
    saved_link = 0;  /* Assume we don't really need it */
#else
    /* Note registers a4 and a5 already saved by def_handler() for S32 */
    saved_notifier = parse_error_notifier;
    saved_link = static_link;
#endif VMS
#ifdef DEBUG
    fprintf(stderr, "add_init(0x%x) static link 0x%x\n", saved_notifier, saved_link);
#endif

    /*s_parse_error(fake_notifier);*/
}
