(**)     { ------- system dependent external routines  ------- }


#if !VAX
#define BYVALUE
#else
#include "add/add_vmsext.pas"
#define BYVALUE %IMMED
#endif
function bit_and(BYVALUE a, b: longint): longint;  cexternal;
   

#if VAX
function PAS$FAB(var fi: unsafe_file): fab_ptr; external;
procedure SYS$EXIT(BYVALUE halt_code: integer);  external;
#endif
#if UNIX
{ (The following function has params in usual order -- need to 
  reverse them in calls from SVS }
function dup2(oldfd,newfd : Cint) : Cint;  cexternal;

function creadln(var f: inputfile;  line: xtring): Cint;  cexternal;
function cfclose(var f: inputfile): boolean; cexternal;
function cfdsc(var f: inputfile): Cint;  cexternal;
function creset(var f: inputfile; var logical: alpha;
                name: xtring; buffer_size: Cint): boolean;  cexternal;
function ds_creset(var f: inputfile; var logical: alpha;
                name: xtring; buffer_size: Cint): boolean;  cexternal;
function delete_file(name: xtring): boolean; cexternal;
procedure def_handler(procedure handler);  cexternal;
procedure suicide;  cexternal;
#if PC_AT
procedure auth(s: svs_string);  cexternal; 
#endif
procedure exit(code: integer);  cexternal;
#endif UNIX


function umask(BYVALUE new_umask: Cint): Cint;  cexternal;
  

{ The following are mine, so parameter reversal is handled in the C code }


function gettime(BYVALUE name: xtring; var stamp: Cint): boolean;  cexternal;
function vversion: xtring;  cexternal;
procedure unbuf_stderr; cexternal;
function delete_logical_file(var name: alpha): boolean; cexternal;
function file_exists(BYVALUE name: xtring): boolean; cexternal;
procedure add_init(procedure parse_err_notifier); cexternal;


#if UNIX
function efs_lock(uid: Cint; node, name, err: xtring): boolean;
  { lock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
cexternal;


function efs_unlock(uid: Cint; node, name, err: xtring): boolean;
  { unlock name (EFS path name) on node (redundant, but this pointer
    is used as a partial key in the table of remote slaves).  uid
    must be set to reflect the current effective user id (and is used
    as a partial key in the table of remote slaves). Return TRUE iff
    successful.  If err is non-NIL then assume it points to a buffer
    of MAX_STRING_LENGTH + 1 bytes and return an error message in it
    upon failure. }
cexternal; 


#endif UNIX
(* --------------  Expansion control ------------------------------------*)


{ Functions provided by expansion control module }

procedure er_init(function parse_bool(s: xtring): longint;
                  procedure err(n: longint);
                  procedure err_assert(n: longint);
                  procedure err_int(n: longint);
                  procedure err_indent;
                  procedure err_string(s: xtring);
                  procedure err_context;
                  procedure err_crlf;
                  procedure err_add
		  );  cexternal;
  { init expansion control }

procedure er_type(var compile_type: alpha);  cexternal;
  { set up expansion control for compile type }

function er_read(BYVALUE filename: xtring): boolean; cexternal;
  { read expansion rules file -- return TRUE if ok (else fatal error) }

function er_select(BYVALUE drawing_name, context: xtring; 
  BYVALUE check_for_prim: longint): macro_module_ptr;  cexternal;
  { select module to be compiled for given drawing. If check_for_prim is 
    non-0, ignore "Drawing not found" and "No acceptable extension found"
    errors -- it's single_drawing on mode. }

procedure er_release(var modl: macro_module_ptr);  cexternal;
  { release version and set to NIL }

function er_special(BYVALUE modl: macro_module_ptr): xtring;  cexternal;
  { returns special non-graphical model for current module }

function er_extension(BYVALUE modl: macro_module_ptr): xtring;  cexternal;
  { returns extension (drawing type, e.g. LOGIC) of chosen module }

function er_version(BYVALUE modl: macro_module_ptr): version_range;  cexternal;
  { returns version number }

function er_page(BYVALUE modl: macro_module_ptr): page_range;  cexternal;
  { returns NEXT page number -- this is an iterator }

function er_dirtype(BYVALUE modl: macro_module_ptr): xtring;  cexternal;
  { returns type of SCALD directory containing the selected module.  (If
    module is a combined special/primitive, then this is the type of the
    directory containing the .PRIM or .PART.) }

function er_filename(BYVALUE modl: macro_module_ptr;
                     BYVALUE which_file: longint; { ord of file_types value }
		     BYVALUE page: natural_number;
		     BYVALUE context: xtring): xtring;  cexternal;
  { returns next page number }

function er_isprim(BYVALUE modl: macro_module_ptr): boolean;  cexternal;
  { returns TRUE iff this is a primitive -- that is it is a PRIM or PART
    extension and/or a special or a drawing type that is forced to
    primitive. }

function er_force_to_prim(BYVALUE modl: macro_module_ptr): boolean;  cexternal;
  { returns TRUE iff this is a non-PRIM/PART extension that is to be
    forced to primitive. }

function er_issimple(BYVALUE modl: macro_module_ptr): page_range;  cexternal;
  { if this is a single-versioned, single-paged primitive, return the
    page number, else return 0. }

function er_samedwg(BYVALUE modl1, modl2: macro_module_ptr): boolean;  cexternal;
  { TRUE iff both modules are from the same drawing AND scald directory }

procedure er_dump;  cexternal;
  { Dump SCALD directories }


procedure er_except(var comptype: alpha; 
	            BYVALUE drawing: xtring;  BYVALUE context: xtring;
                    var extension, attribute: alpha);  cexternal;
  { Pick the given extension(attribute) when compiling drawing for comptype }

procedure er_debug;  cexternal;
  { Turn on interface debugging -- messages to stderr }
