(**){ ---- comperr output to list file --------------------------------}


{ these procedures are isolated here so that experimentation can be done
  with using system specific i/o to speed things up.  note that if
  this is done the error dump routines may need to be changed as well
  as they will also write to this file. }


function open_comperr_list: boolean;
  { open cmplst for use by comperr, returning true iff successful }
begin
  open_comperr_list := rewrite_file(cmplst, nullstring, cmplst_file_name);
end { open_comperr_list } ;


procedure close_comperr_list;
  { close cmplst from use by comperr }
begin
  close_file(cmplst, cmplst_file_name, nullstring);
end { close_comperr_list } ;


procedure cat_to_cmplst(modl: comperr_module_ptr;
			version: macro_module_ptr;
                        page: page_range;
			filename: xtring);
  { cat the named file to cmplst or write a message indicating why not }
  const
    C_EOF = 2;  { code returned by creadln indicating end of file }
  var
#if !VAX
    line: xtring;                              { current line }
#else
    line: varystring;
#endif

  procedure gather_error_number(
#if !VAX
				line: xtring);
#else
                                var line: varystring);
#endif
    const
      LPAREN = '(';
    var
      number: longint;
      i,len: string_range;
  begin
    number := 0;
    i := 3;
  
#if !VAX
    len := ord(line^[0]);
    while (i < len) and (line^[i] <> LPAREN) do i := i + 1;
    if i < len then
      begin
	i := i + 1;
	while (i < len) and (number <= max_error_num) and
	      isdigit[line^[i]] do
	  begin
	    number := number * 10 + (ord(line^[i]) - ord('0'));
	    i := i + 1;
	  end;
	if number <= max_error_num then
	  errors_encountered := errors_encountered + [number];
      end;
#else
  len := length(line);
    while (i < len) and (line[i] <> LPAREN) do i := i + 1;
    if i < len then
      begin
        i := i + 1;
        while (i < len) and (number <= max_error_num) and
              isdigit[line[i]] do
          begin
            number := number * 10 + (ord(line[i]) - ord('0'));
            i := i + 1;
          end;
        if number <= MAX_ERROR_NUM then
          errors_encountered := errors_encountered + [number];
      end;
#endif !VAX
  end { gather_error_number } ;


  procedure check_single_drawing_from_linker;
  begin
#if !VAX
    if Creadln(CmpStan, line) <> C_EOF then
      if (ord(line^[0]) > 0) and (line^[1] = 'S') then
        single_level_compile := TRUE
      else if (ord(line^[0]) > 0) and (line^[1] = 'F') then
        single_level_compile := FALSE
      else
	begin
	  dump_string(CmpLst, line);
	  writeln(CmpLst);
	  if line^[2] = '#' then gather_error_number(line);
	end;
#else
    if not eof(CmpStan) then
      begin
        readln(CmpStan, line);
        if (length(line) > 0) and (line[1] = 'S') then
          single_level_compile := TRUE
        else if (length(line) > 0) and (line[1] = 'F') then
          single_level_compile := FALSE
        else
          begin
            writeln(CmpLst, line);
            if length(line) > 2 then
              if line[2] = '#' then gather_error_number(line);
          end;
      end;
#endif !VAX
  end { check_single_drawing_from_linker } ;


begin { cat_to_cmplst }
  if reset_file(filename, STANDARD_FILE) then
    begin
#if !VAX
      create_a_string(line, MAX_STRING_LENGTH);
#endif
      if (page = 0) then check_single_drawing_from_linker;
#if !VAX
      while Creadln(CmpStan, line) <> C_EOF do
        begin
          dump_string(CmpLst, line);
	  writeln(CmpLst);
	  if line^[2] = '#' then gather_error_number(line);
	end;
      release_string(line);
#else
      while not eof(CmpStan) do
        begin
          readln(CmpStan, line);
          writeln(CmpLst, line);
          if length(line) > 2 then
            if line[2] = '#' then gather_error_number(line);
        end;
#endif !VAX
      if close_parse_file(STANDARD_FILE) then ;
    end
  else
    begin
      if page = 0 then
        begin
	  { Missing linker listing file }
	  error(250 { Missing results });
	  error_dump_indent(indent);
	  error_dump_alpha('Drawing=        ');
          error_dump_string(modl^.drawing^.macro_name);
          error_dump_CRLF;
	  error_dump_context(modl^.context, 8 { size of 'Drawing='});
          error_dump_indent(indent);
          error_dump_alpha('Missing linker l');
          error_dump_alpha('isting file.    ');
	  error_dump_CRLF;
	  error_dump_indent(indent);
	  error_dump_alpha('Compile type=   ');
	  error_dump_alpha(specified_compile_type^.name);
	  error_dump_CRLF;
	end
      else error_dump_missing_page(modl, version, page, LISTING_FILE);
    end;
end { cat_to_cmplst } ;


procedure linker_list_heading;
  { Write a heading to cmplst indicating that the linker list file follows }
begin
  writeln(CmpLst);
  writeln(CmpLst, ' ValidLINKER error messages');
  writeln(CmpLst, ' --------------------------');
  writeln(CmpLst);
end { linker_list_heading } ;


procedure page_list_heading;
  { Write a heading to cmplst indicating that the following files are 
    compiler page lists }
begin
  page(CmpLst);
  writeln(CmpLst);
  write(CmpLst, ' ValidPAGECOMP error messages');
  case specified_severity of
    NO_SEVERITY:
      writeln(CmpLst, ' (for all pages)');
    WARNING_SEVERITY:
      writeln(CmpLst, ' (for pages with WARNINGs or worse)');
    OVERSIGHT_SEVERITY:
      writeln(CmpLst, ' (for pages with OVERSIGHTs or ERRORs');
    ERROR_SEVERITY:
      writeln(CmpLst, ' (for pages with ERRORs)');
    OTHERWISE writeln(Cmplst);
  end;

  write(CmpLst, ' ----------------------------');
  case specified_severity of
    NO_SEVERITY:
      writeln(CmpLst, '----------------');
    WARNING_SEVERITY:
      writeln(CmpLst, '-----------------------------------');
    OVERSIGHT_SEVERITY:
      writeln(CmpLst, '-------------------------------------');
    ERROR_SEVERITY:
      writeln(CmpLst, '------------------------');
    OTHERWISE writeln(Cmplst);
  end;

  writeln(CmpLst);

  if single_level_compile then 
    begin
      writeln(CmpLst, ' (SINGLE_DRAWING ON)');
      writeln(CmpLst, ' -------------------');
      writeln(CmpLst);
    end;
end { page_list_heading } ;


procedure comperr_goodbye;
  { write a message indicating the comperr is done }
begin
  writeln(CmpLst);
  writeln(CmpLst, ' End of listing');
  writeln(CmpLst, ' --------------');
end { comperr_goodbye } ;
