
  procedure process_COMMAND_directive(val: name_ptr);
    { process the COMMAND directive for the given value }
    var
      i: command_type;  { current command value  for search }
      found: boolean;   { TRUE when command value is found }
  begin
    if not COMMAND_specified_in_command_line then
      begin
        for i := succ(FIRST_COMMAND) to pred(LAST_COMMAND) do
          if val = command_value[i] then 
            begin
              found := TRUE;
              command := i;
            end;
        if not found then error(229 { illegal command value});
        if command = SEPLINK_COMMAND then
          if ROOT_specified_in_command_line or 
            TYPE_specified_in_command_line  then
            begin
              error(228 { incorrect usage of seplink command });
            end;
      end;
  end { process_COMMAND_directive } ;


  procedure process_command_line_arguments;
    { get parameters from a command line.  The line can contain:
      
      SEPCOMP root_drawing compile_type context_name
                  or
      SEPLINK compile_type cmpdraw_file_descriptor design_file_descriptor
                  or
      COMPERR [-w] root_drawing compile_type
              [-a]
	      [-o]
	      [-e]
       
      NOTE: if the file descriptors for the SEPLINK command are
      to be specified in the command line, then the SEPLINK
      command MUST also be specified in the command line. }
    var
      arg: xtring;                 { current argument from command line }
      temp_string: xtring;         { string for conversion to internal }
      len,                         { length of the string parameter }
      i: string_range;             { index into the strings }
      temp_alpha: alpha;           { temp storage for the compile type }
      last_legitimate_arg: 3..5;   { last argument with meaning }


    procedure process_command_arg;
      { process the current arg as COMMAND directive }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMMAND_directive(enter_name(temp_alpha));
          COMMAND_specified_in_command_line := TRUE;
        end;
    end { process_command_arg } ;


    function process_design_descriptor: boolean;
      { process the current arg as  file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          Design_fd := string_to_natural_number(arg);
          process_design_descriptor := TRUE;
        end
      else process_design_descriptor := FALSE;
    end { process_design_descriptor } ;


    function process_cmpdraw_descriptor: boolean;
      { process the current arg as cmpdraw's file descriptor }
    begin
      if ord(arg^[0]) > 0 then 
        begin
          { NOTE: there really should be a check to see that arg is a
	    natural number, and then fail if it isn't }
          CmpDraw_fd := string_to_natural_number(arg);
          process_cmpdraw_descriptor := TRUE;
        end
      else process_cmpdraw_descriptor := FALSE;
    end { process_cmpdraw_descriptor } ;


    procedure process_compile_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          temp_alpha := NULL_ALPHA;
          if len > ID_LENGTH then len := ID_LENGTH;
          for i := 1 to len do temp_alpha[i] := upshift[arg^[i]];
          process_COMPILE_directive(enter_name(temp_alpha));
          TYPE_specified_in_command_line := TRUE;
        end;
    end { process_compile_arg } ;


    procedure process_root_arg;
      { process the current arg as compile type }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          root_macro_name := enter_and_release_string(temp_string);
          ROOT_specified_in_command_line := TRUE;
        end;
    end { process_root_arg } ;


    procedure process_context_arg;
      { process the current arg as context name }
      var
        i: string_range;             { index into the strings }
    begin
      len := ord(arg^[0]);
      if len > 0 then
        begin
          create_a_string(temp_string, len);
          for i := 1 to len do temp_string^[i] := upshift[arg^[i]];
          CONTEXT_specified_in_command_line := TRUE;
	  { this is an obsolete concept }
        {  context_being_compiled := enter_and_release_string(temp_string); }
        end;
    end { process_context_arg } ;


  begin { process_command_line_arguments }
    { number of arguments includes the program name }

    if sargc >= 2 then   { there is a COMMAND parameter }
      begin
        sargv(1, arg);
        process_command_arg;
      end;

    if command = SEPLINK_COMMAND then
      begin
        if sargc >= 3 then   { KLUDGE "link" type spec }
          begin
            sargv(2, arg);
            process_compile_arg;
          end;
        if sargc >= 4 then   { there is an open CMDRAW file from linker }
          begin
            sargv(3, arg);
            if not process_cmpdraw_descriptor then
	      begin
	        error(166 { can't access CMPDRAW file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    cmpdraw_specified_in_command_line := TRUE;
          end;
        if sargc >= 5 then   { there is an open DESIGN file from linker }
          begin
            sargv(4, arg);
            if not process_design_descriptor then
	      begin
	        error(234 { can't access DESIGN file});
		error_dump_indent(indent);
		error_dump_alpha('descriptor=     ');
		error_dump_string(arg);
		error_dump_CRLF;
	      end;
	    design_specified_in_command_line := TRUE;
          end;
        last_legitimate_arg := 4;
      end

    else { not the SEPLINK command }
      begin

        i := 2;

        if (command = COMPERR_COMMAND) and (sargc >= i + 1) then
	  begin
	    sargv(i, arg);
	    if ord(arg^[0]) = 2 then if arg^[1] = '-' then
	      begin
	        if (arg^[2] = 'a') or (arg^[2] = 'A') then
		  specified_severity := NO_SEVERITY { dump them all }
	        else if (arg^[2] = 'o') or (arg^[2] = 'O') then
		  specified_severity := OVERSIGHT_SEVERITY
	        else if (arg^[2] = 'e') or (arg^[2] = 'E') then
		  specified_severity := ERROR_SEVERITY { dump them all }
	        else if (arg^[2] = 'w') or (arg^[2] = 'W') then
		  specified_severity := WARNING_SEVERITY
		else
		  begin
		    error(251 { unrecognized argument });
		    error_dump_indent(indent);
		    error_dump_alpha('Argument=       ');
		    error_dump_string(arg);
		    error_dump_CRLF;
		  end;

	        i := i + 1;
	      end;
	  end;

        if sargc >= i + 1 then   { there is a ROOT_DRAWING parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_root_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a COMPILE type parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_compile_arg;
          end;
        i := i + 1;

        if sargc >= i + 1 then   { there is a CONTEXT_NAME parameter }
          begin
            sargv(i, arg);
            if arg <> nullstring then process_context_arg;
          end;
        last_legitimate_arg := i;
      end;

    for i := (last_legitimate_arg + 1) to (sargc - 1) do
      begin
        sargv(i, arg);
        if arg <> nullstring then
          if not (224 in errors_encountered) then error(224 { junk });
      end;

  end { process_command_line_arguments } ;
