procedure clear_errors;
  { clear error message variables (between pages) }
begin
  num_warnings := 0;
  num_oversights := 0;
  num_errors := 0;
  errors_encountered := [];
end { clear_errors } ;


procedure init_expansion_scalars;
  { initialize expansion scalars and "constant" pointers into
    dictionaries -- expansion dictionaries must be initialized 
    before calling this. }
begin
  unique_NC_number := 0;
  unique_NET_ID_number := 0;
  unique_PATH_number := 0;
  current_mtree_node := NIL;

  expansion_NC_string := 
    enter_numbered_string(NC_signal, expansion_string_dictionary);
  expansion_0_string := 
    enter_numbered_string(Zero_signal, expansion_string_dictionary);
  expansion_1_string := 
    enter_numbered_string(One_signal, expansion_string_dictionary);

  total_number_nodes := 0;
  number_leaf_nodes := 0;
  number_terminal_nodes := 0;
end { init_expansion_scalars } ;


procedure release_synonym_signal_table;
  { release all of the signals in the synonym signal table }
  var
    index: synonym_signal_table_range;    { index into the table }
    next,                                 { next signal in the bucket }
    signal: synonym_signal_ptr;           { current signal in bucket }
    inst: signal_instance_list_ptr;       { for bogus_cmptmp_list }
begin
  for index := 0 to SYNONYM_SIGNAL_TABLE_SIZE do
    begin
      signal := synonym_signal_table[index];
      synonym_signal_table[index] := NIL;
      while signal <> NIL do
        begin
          next := signal^.next;
          release_synonym_signal(signal);
          signal := next;
        end;
    end;

  if bogus_cmptmp_list <> NIL then
    begin
      inst := bogus_cmptmp_list;
      while inst^.next <> NIL do inst := inst^.next;
      inst^.next := free_signal_instance_lists;
      free_signal_instance_lists := bogus_cmptmp_list;
      bogus_cmptmp_list := NIL;
    end;
end { release_synonym_signal_table } ;


procedure release_table_of_signals_fields(var table: table_of_signals);
  { empties the table }
  var
    i: signal_table_range;   { current bucket }
    tail: signal_entry_ptr;  { tail of a bucket }
begin
  for i := 0 to SIGNAL_TABLE_SIZE do
    if table[i] <> NIL then
      begin
	tail := table[i];
	while (tail^.next <> NIL) do tail := tail^.next;
	tail^.next := free_signal_entrys;
	free_signal_entrys := table[i];
	table[i] := NIL;
      end;
end { release_table_of_signals_fields } ;


procedure release_all_signal_definitions(var list: signal_definition_ptr);
  { release list and all fields rooted with it. }
  
  var
    next_one: signal_definition_ptr;  { remembers next }
begin
  while list <> NIL do with list^ do
    begin
      next_one := next;

      release_complete_signal_def(list);

      list := next_one;
    end;
end { release_all_signal_definitions } ;


procedure release_all_mtree_nodes(var node: mtree_node_ptr);
  { release entire mtree and its fields rooted at node }
  var
    next_one: mtree_node_ptr;  { remembers next }
begin
  while node <> NIL do with node^ do
    begin
      next_one := next;
      release_complete_formal_actual_list(params);
      release_all_signal_definitions(signals);
      release_symbol_table(symbol_table);
      release_all_mtree_nodes(son);

      next := free_mtree_nodes;
      free_mtree_nodes := node;

      node := next_one;
      total_number_nodes := total_number_nodes - 1;
    end;
end { release_all_mtree_nodes } ;


procedure release_all_clear_text_actual_lists(
  var ptr: clear_text_actual_list_ptr);
  { release list along with all lists rooted there}
  var
    next_one: clear_text_actual_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      if debug_30 then debug_29 := TRUE;
      release_entire_property_list(properties);
      if debug_30 then debug_29 := FALSE;

      next := free_clear_text_actual_lists;
      free_clear_text_actual_lists := ptr;

      ptr := next_one;
    end;
end { release_all_clear_text_actual_lists } ;


procedure release_all_bindings_lists(var ptr: bindings_list_ptr);
  { release list along with all lists rooted there}
  var
    next_one: bindings_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      release_entire_property_list(pin_properties);
      release_all_clear_text_actual_lists(actual_parameter);

      next := free_bindings_lists;
      free_bindings_lists := ptr;

      ptr := next_one;
    end;
end { release_all_bindings_lists } ;


procedure release_all_invoke_lists(var ptr: invoke_list_ptr);
  { release list of macro defs with along with all lists rooted in
    the macro defs }
  var
    next_one: invoke_list_ptr;    { remembers next }
begin
  while ptr <> NIL do with ptr^ do
    begin
      next_one := next;
      release_entire_property_list(parameters);
      release_entire_property_list(properties);
      release_all_bindings_lists(bindings);

      next := free_invoke_lists;
      free_invoke_lists := ptr;

      ptr := next_one;
    end;
end { release_all_invoke_lists } ;


procedure release_entire_signal_list(var sl: signal_list_ptr);
  { relase the entire list and any fields rooted in it (there aren't any)}
  var
    last: signal_list_ptr;  { finds last element }
begin
  if sl <> NIL then
    begin
      last := sl;
      while last^.next <> NIL do last := last^.next;
      last^.next := free_signal_lists;
      free_signal_lists := sl;
      sl := NIL;
    end;
end { release_entire_signal_list } ;


procedure release_complete_macro_def(var MDP: macro_def_ptr);
  { release macro def and all lists associated with it.  Return NIL. }
begin
  if MDP <> NIL then with MDP^ do
    begin
      release_entire_signal_list(params);
      release_entire_property_list(properties);
      release_entire_property_list(text_macros);
      release_all_invoke_lists(invokes);

      next := free_macro_defs;
      free_macro_defs := MDP;
    end;
end { release_complete_macro_def } ;


procedure cleanup_root_macro_def;
  { release root macro def and all lists associated with it. 
    root_macro_def is assumed to be kept separate from other macro defs }
  var
    ptr: macro_def_ptr;         { an element }
    next_one: macro_def_ptr;    { remembers next }
begin
  ptr := root_macro_def;
  while ptr <> NIL do
    begin
      next_one := ptr^.next;
      release_complete_macro_def(ptr);
      ptr := next_one;
    end;
  root_macro_def := NIL;
end { cleanup_root_macro_def } ;


procedure re_init_expansion_structures;
  { Release all structures associated with the expansion of a page.
    This includes all macro defs, the mtree, and all signal definitions. 
    re-init expansion dictionaries } 
begin
  cleanup_root_macro_def;
  release_all_mtree_nodes(mtree_root);
  release_table_of_signals_fields(signal_table);
  release_numbered_dictionary(expansion_string_dictionary);
  release_numbered_dictionary(expansion_id_dictionary);
  release_all_module_table_fields(modules_in_page);
  release_synonym_signal_table;
  release_entire_avl_tree(invoke_path_table);
  init_expansion_scalars;
end { re_init_expansion_structures } ;
