(**){-------------------- ADD Error handling -----------------------}


procedure process_add_error(scalddir: xtring; kind: file_types);
  var
    num: longint;             { ADD error number }
    file_name: xtring;        { name of file having the problem }
    line: xtring;             { text of the line having a parse problem }
    line_number: longint;     { position of line in file }
    column: longint;          { position of char where error was found }
    save: boolean;            { saves ignore_parse_errors value }


  procedure dump_add_error_line(line: xtring;  column: longint);
  begin
    if line <> NIL then
      begin
	error_dump_CRLF;
        error_dump_indent(1);
        error_dump_string(line);
	error_dump_CRLF;
	if column > 0 then error_dump_indent(column);
	error_dump_char('^');
	{ CRLF will be emitted by following call to error() or assert() }
      end;
  end { dump_add_eror_line } ;


  procedure display_library_error;
    { display the contents of the library }
    var
      library_name: xtring;    { current library in the list }
      iterator_state: xtring;  { for use by iterator }
      code: longint;           { condition returned by iterator }
  begin
    code := slibsinit(library_name, iterator_state);
    while (code = S_ITR_ERROR) do 
      code := slibs(library_name, iterator_state);
    if code = S_ITR_DONE  then
      begin
        error_dump_indent(indent);
        error_dump_alpha('Master directory');
        error_dump_alpha(' is empty       ');
        error_dump_CRLF;
      end
    else
      begin
        error_dump_indent(indent);
        error_dump_alpha('Library contents');
        error_dump_char(':');
        error_dump_CRLF;

        repeat
          error_dump_indent(indent + 4);
          error_dump_string(library_name);
          error_dump_CRLF;
	  repeat
	    code := slibs(library_name, iterator_state);
	  until code <> S_ITR_ERROR;
        until code = S_ITR_DONE;
      end;
  end { display_library_error } ;


begin { process_add_error }
  save := ignore_parse_errors;
  ignore_parse_errors := TRUE;
  ok_to_print_error := TRUE;
  num := serror(file_name, line, line_number, column);
  dump_add_error_line(line, column);
  case num of
    S_NO_ERROR: { nothing } ;
    S_ILLEGAL_SCALD:
      begin
        assert(0);
	writeln(CmpLog, ' Illegal SCALD name specified');
	if debugging then writeln(Outfile, ' Illegal SCALD name specified');
      end;
    S_REMOTE_ADD:
      begin
        error(175 { Can't use remote shadow dir });
	error_dump_directory_name(file_name);
      end;
    S_IDENTIFIER:
      begin
        assert(0);
	writeln(CmpLog, ' Illegal identifier passed to ADD package');
	if debugging then 
	  writeln(Outfile, ' Illegal identifier passed to ADD package');
      end;
    S_ADD_NOCREATE:
      begin
        error(230 { Can't create shadow directory });
	error_dump_directory_name(file_name);
      end;
    S_DIR_NOCREATE:
      begin
        error(230 { Can't create shadow directory });
	error_dump_directory_name(file_name);
      end;
    S_SDIR_NOTFOUND:
      begin
        assert(0);
	writeln(CmpLog, ' Specified unused SCALD dir to ADD package');
	if debugging then
	  writeln(Outfile, ' Specified unused SCALD dir to ADD package');
        error_dump_file_name(file_name);
      end;
    S_NO_OPEN:
      begin
        case kind of
	  { Emit file-type dependent error code }
	  MASTER_LIBRARY: error(170);
	  OTHERWISE error(206 { Cannot open specified directory file });
	end;
	error_dump_file_name(file_name);
      end;
    S_NULL_PARAM:
      begin
        assert(0);
	writeln(CmpLog, ' Bad NIL param to ADD package');
	if debugging then writeln(Outfile, ' Bad NIL param to ADD package');
      end;
    S_ASSERT:
      begin
        assert(0);
	writeln(CmpLog, ' Internal ADD assertion check failure');
	if debugging then
	  writeln(Outfile, ' Internal ADD assertion check failure');
      end;
    S_LIB_NOTFOUND:
      begin
        error(103 { lib not foundin master directory });
        error_dump_indent(indent);
	error_dump_alpha('Library name:   ');
	error_dump_char(' ');
        error_dump_string(scalddir);
	error_dump_CRLF;
	display_library_error;
      end;
    S_EOL_IN_STR:
      begin
        error(89 { string not closed before EOL });
	error_dump_file_name(file_name);
      end;
    S_EXP_ID:
      begin
        error(1 { expected id });
	error_dump_file_name(file_name);
      end;
    S_EXP_STRING:
      begin
        error(33 { expected string });
	error_dump_file_name(file_name);
      end;
    S_EXP_SEMI:
      begin
        error(12 { expected ; });
	error_dump_file_name(file_name);
      end;
    S_EXP_EQ:
      begin
        error(2 { expected = });
	error_dump_file_name(file_name);
      end;
    S_FILE_TYPE:
      begin
        error(86 { file not of correct type });
	error_dump_file_name(file_name);
      end;
    S_NO_FILETYPE:
      begin
        error(85 { expected FILE_TYPE });
	error_dump_file_name(file_name);
      end;
    S_UNKNOWN_SY:
      begin
        error(6 { Unrecognized symbol });
	error_dump_file_name(file_name);
      end;
    S_PARSED_ID:
      begin
        error(41 { identifier length exceeded });
	error_dump_file_name(file_name);
      end;
    S_ADD_INUSE:
      begin
        error(60 { Same shadow directory used more than once });
	error_dump_directory_name(file_name);
      end;
    S_COLLISION:
      begin
        assert(183 { Drawing/directory re-specified });
	error_dump_file_name(file_name);
      end;
    S_EXP_END:
      begin
        error(40 { expected END });
	error_dump_file_name(file_name);
      end;
    S_EXP_EOF:
      begin
        error(98 { Extraneous junk at end of file });
	error_dump_file_name(file_name);
      end;
    S_ILL_DWGDIR:
      begin
        error(252 { Illegal drawing directory in SCALD dir });
	error_dump_file_name(file_name);
      end;
    OTHERWISE
      begin
        assert(0);
	Writeln(CmpLog, ' Unrecognized ADD error number ', num:1);
        if debugging then
	  Writeln(CmpLog, ' Unrecognized ADD error number ', num:1);
      end;
  end { case } ;

  if line <> NIL then
    begin
      error_dump_indent(indent);
      error_dump_alpha('Line number=    ');
      error_dump_integer(line_number);
      error_dump_CRLF;
    end; 
  ignore_parse_errors := save;
end { process_add_error } ;


procedure parse_error_notifier;
  { paramterless procedure called by ADD package to alert compiler to the
    presence of a parse error in some file }
begin
  process_add_error(nullstring, FIRST_FILE_TYPE { unknown });
end { parse_error_notifier } ;
