# handler_wrap(entry_point, static_link)
#	void (*entry_point)(); /* address of PASCAL interrupt handler */
#	char *static_link;     /* static link for interrupt handler */
#
# handler_wrap1(entry_point, static_link, parameter)
#	void (*entry_point)(); /* address of PASCAL interrupt handler */
#	char *static_link;     /* static link for interrupt handler */
#       char *parameter;       /* to be passed to PASCAL routine */
#
# handler_wrap calls a parameterless PASCAL routine passed by reference, 
# setting up the specified static link.
# nahdler_wrap1 calls PASCAL routine taking 1 4-byte parameter.
#
# Since SVS seems to treat registers more sanely in its NS32000 version
# than its MC68000 version, it is not necessary to do the kinds of register
# saving and restoring that are necessary in the MC68000 version of this
# wrapper.
#
	.text
	.align 1
        .globl _handler_wrap
_handler_wrap:
	enter [],$0
	cmpqd $0,0xc(fp)      # If static link is 0, don't push it
        beq nostatic
	movd 0xc(fp),tos      # push the static link (PASCAL will pop it)
nostatic:
	movd 0x8(fp),r0       # get the address of the PASCAL procedure
	jsr  r0               # call the PASCAL procedure
	exit []
	ret $0
        .globl _handler_wrap1
_handler_wrap1:
	enter [],$0
	movd 0x10(fp),tos     # push the parameter
	cmpqd $0,0xc(fp)      # If static link is 0, don't push it
        beq nostatic1
	movd 0xc(fp),tos      # push the static link (PASCAL will pop it)
nostatic1:
	movd 0x8(fp),r0       # get the address of the PASCAL procedure
	jsr  r0               # call the PASCAL procedure
	exit []
	ret $0
