 {-----------------------------  TYPES  --------------------------------}


  {---------------------}
  { miscellaneous types }
  {---------------------}

#if !SVS
#define longint integer
#endif

  natural_number    = 0..MAXINT;                  { natural number range }
  radix_range       = MIN_RADIX .. MAX_RADIX;     { valid radix range }
  Cint      = longint;
  set_of_char = set of char;


  {---------------------------------------------------------------------}
  { A STRING is represented as a pointer to a packed array of char:     }
  {                                                                     }
  {    string = ^packed array [0..255] of char;                         }
  {                                                                     }
  { Each string, however, is usually less than 255 characters.  The     }
  { actual length of the string is found in the first byte:  string^[0].}
  { The length of the string is static;  it should not be changed once  }
  { the string has been created.                                        }
  {                                                                     }
  { Strings can be up to 255 characters long.  The programmer must make }
  { sure that characters are not written beyond the end of the string.  }
  {                                                                     }
  { Strings are created on the heap in quantized lengths.  There are 33 }
  { different length arrays created.  The CREATE_A_STRING routine       }
  { creates an array on the heap big enough to support the given string.}
  { Strings may be released for use at a later time (RELEASE_STRING).   }
  {                                                                     }
  { Strings are hashed into a table so that string compare for equality }
  { can be done by comparing pointers.                                  }
  {---------------------------------------------------------------------}

  {------- string types ---------------}

  xtring = sstring;

  freeptr = ^free_element;
  free_element = record
                   next: freeptr;     { next in linked list of free strings }
                   str: xtring;       { ^ free string element }
                 end;            

  hash_string_ptr = ^hash_string;
  hash_string = record
                  next_hash_string: hash_string_ptr;   { next in bucket }
                  str: xtring;                         { the string }
                end;

  hash_string_range = 0..HASH_STRING_TABLE_SIZE;   { size of hash table }

  hash_string_table_type = array [hash_string_range] of hash_string_ptr;


  { for h of type string_hack and xtring x, use the following to write
    x to some file --
      h.i := ord(x) + 1;
      write(f, h.s^:ord(x^[0]));
    this is MUCH faster than 1 char at a time and works on all of
    our supported platforms.                                         }

  nolength_string = packed array[1..MAX_STRING_LENGTH] of char;
  string_hack = 
#if VAX
                [volatile]            
#endif             
                           record
    case boolean of
      TRUE: (i: longint);
      FALSE:(s: ^nolength_string);
  end;

  output_line_range = 0..MAX_OUTPUT_FILE_LENGTH;  { output file line length }

  {-----------------------------------------------------------------}
  {  An exception handler is used to intercept Pascal run-time and  }
  {  operating system errors so that the Compiler can handle them.  }
  {  This is especially true for file opening and I/O.  This type   }
  {  is used to characterize the error that occurred.               }
  {-----------------------------------------------------------------}


  { EXCEPTION_ERROR_TYPE is used to specify the exception encountered }

  exception_error_type = (NULL_ERROR_CODE,       { no exception encountered }
                          OPEN_CREATE_FAIL,      { file open/create failure }
                          OPEN_ACCESS_FAIL,      { file open/access failure }
                          CLOSE_FAIL,            { file close failure }
                          RESET_FAIL,            { file RESET failure }
                          REWRITE_FAIL,          { file REWRITE failure }
                          STACK_OVERFLOW);       { STACK overflow }


  {----------------------------------------------------------------------}
  {  The Compiler has a lexical analyzer that scans the input character  }
  {  stream and returns a series of tokens representing objects in the   }
  {  input.  These tokens are described via the following type.          }
  {----------------------------------------------------------------------}

  symbols = (NULLSY,                   { no symbol read }
             CONSTANT,                 { constant - string of digits }
             IDENT,                    { identifier }
             SIGNALCONST,              { constant with radix specification }
             STRINGS,                  { character string }

             { -- ASCII characters -- }
             SPACE, EXCLAMATION, QUOTE, SHARP, DOLLAR, PERCENT, AMPERSAND,
             LPAREN, RPAREN, ASTERISK, PLUS, COMMA, MINUS, PERIOD, SLASH,
             COLON, SEMI, LESSTHAN, EQUAL, GREATERTHAN, QUESTION, ATSY,
             LBRACKET, BACKSLASH, RBRACKET, CIRCUMFLEX, UNDERBAR,
             ACCENTGRAVE, VERTICALBAR, TILDA,
             
             { -- two-character symbols -- }
             LESY, GESY, NESY, LTSY, GTSY, DOTDOTSY, COLONCOLONSY,
             
             { -- arithmetic key words -- }
             ORSY, MODSY, ANDSY, NOTSY, ABSSY, ORDSY, MINSY, MAXSY,
     
             { -- special signal key words -- }
             LOW_ASSERTED_SY, HIGH_ASSERTED_SY, NEGATION_SY,

             { -- special key words -- }
             ENDSY,

             { -- macro symbols -- }
             MACROSY, ENDMACROSY, INVOKESY, ENDINVOKESY, PROPERTYSY, 
             ENDPROPERTYSY, PINSY, ENDPINSY, BODYSY, 
             ENDBODYSY, BINDINGSY, ENDBINDSY, PARAMETERSY, ENDPARAMETERSY,
             
             { -- file symbols -- }
             FILETYPESY,

	     { -- separate compilation keywords -- }
	     SEPCOMPSY,
             
             { -- end of type and input data -- }
             ENDOFDATASY);

  setofsymbols = set of symbols;


  {-------------------------------------------------------------------}
  { An IDENTIFIER is used to describe an array of characters of fixed }
  { length.  All identifiers are hashed into a table and identifier   }
  { comparison for equality can be done by comparing pointers.  Each  }
  { identifier has a set of attributes used to interpret its meaning  }
  { when the identifier is a property name.  When the identifier is   }
  { found in the context of input parsing, the SY field is used to    }
  { specify whether the identifier is a symbol and which it is.       }
  {-------------------------------------------------------------------}

  
  id_range = 1..ID_LENGTH;                    { range of an identifier }
  alpha = packed array [id_range] of char;    { identifier type }


  {-----------------------------------------------------------------------}
  { Each identifier has attributes that describe its characteristics:     }
  {    PERMANENT        a text macro whose definition is assumed to never }
  {                     change, so will not be logged in schema files for }
  {                     use in "make" operations.  These should also be   }
  {                     RESERVED (though having the PERMANENT attribute   }
  {                     does not, by itself, imply this).                 }
  {    RESERVED         a global reserved (standard) text macro read from }
  {                     a text macro file.  This can not be overridden by }
  {                     local text macros or parameters.                  }
  {    UNRESERVED       a global unreserved text macro read from a text   }
  {                     macro file.  This can be overridden by local text }
  {                     macros or parameters.                             }
  {    KEY_WORD         a key word token (in some context).               }
  {    INHERIT_PIN      inherits from pin to signal to pin if property.   }
  {    INHERIT_SIGNAL   inherits from signal to signal across synomyms.   }
  {    INHERIT_BODY     inherits from father to son - on output.          }
  {    IS_PARAMETER     is parsed and expanded if body property.          }
  {    IS_INT_PARAMETER parsed as integer expression if body property.    }
  {    PERMIT_SIGNAL    permitted to be connected to a signal.            }
  {    PERMIT_PIN       permitted to be connected to a pin.               }
  {    PERMIT_BODY      permitted to be connected to a body.              }
  {    DONT_OUTPUT      property not output to files.                     }
  {-----------------------------------------------------------------------}

  name_types = (FIRST_NAME_TYPE,
                PERMANENT, RESERVED, UNRESERVED, KEY_WORD,
                INHERIT_PIN, INHERIT_SIGNAL, INHERIT_BODY,
                IS_PARAMETER, IS_INT_PARAMETER,
                PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY,
                DONT_OUTPUT,
                LAST_NAME_TYPE);

  name_type_set = packed set of name_types;


  name_ptr = ^name_element;
  name_element = record
                   next: name_ptr;           { next in hash table thread }
                   name: alpha;              { identifier name }
                   kind: name_type_set;
                   definition: xtring;       { if RESERVED in kind }
                   sy: symbols;              { if KEY_WORD in kind }
                 end;

  name_table_range = 0..NAME_TABLE_SIZE;      { range of identifier table }

  name_table_type = array [name_table_range] of name_ptr;




#if VAX
  time_string = packed array [1..TIME_BUFFER_LENGTH] of char;
#endif
#if IBM
  time_string = alfa;
#endif 



  {-------------------------------------------------------------------------}
  { Symbol tables are used to store text macros, structures, and parameters }
  { for each drawing instance (mtree node).  Each table is organized as a   }
  { binary tree.                                                            }
  {-------------------------------------------------------------------------}

  compare_type = (LT, EQ, GT);       { for comparing links in tree }

  identifier_ptr = ^identifier;
  identifier = record
                 next: identifier_ptr;    { used to link fields of a record }
                 name: name_ptr;          { name of this identifier }
                 definition: xtring;      { definition of the identifier }
		 resolves: boolean;       { True if definition was resolved
					    without error }
               end;



  {---------------------------------}
  { A property is a name/value pair }
  {---------------------------------}
  
  property_types = (BODY_PROPERTY, PIN_PROPERTY, PARAMETER_PROPERTY);

  property_set = set of property_types;
  
  property_ptr  = ^property_list;
  property_list = record
                    next: property_ptr;   { ^ next property in the list }
                    name: name_ptr;       { property name }
                    text: xtring;         { property value }
                  end;


{-----------------------------------------------------------------------}
{ Records are scratch records for sargv and sargc, (which imitate       }
{ UNIX argv and argc).  They must be initialized by calling             }
{ init_cli_structures.  They are not to be accessed directly            }
{ other than by sargc and sargv, as they may or may not be used         }
{ depending on the implementation of those routines on the              }
{ current operating system.                                             }
{                                                                       }
{ These ideally would be local and static to those routines, but that   }
{ is not always possible in PASCAL.                                     }
{-----------------------------------------------------------------------}


  { scratch structures for sargv and sargc }
  cli_arg_range = 0..MAX_CLI_ARG_NUMBER;   
  cli_arg_index = -1..MAX_CLI_ARG_NUMBER;
  cli_arg_array_type =  array[cli_arg_range] of xtring;


  {-----------------------------------------------------------------------}
  {  Error handling is done through a number of common routines.  Errors  }
  {  are specified by number.  The current environment in which parsing   }
  {  takes place is described by a stack.  The top of the stack describes }
  {  the current environment.  This is output whenever a parse error is   }
  {  detected or can be output explicitly.                                }
  {-----------------------------------------------------------------------}

  error_range   = 0..MAX_ERROR_NUM;
  error_set     = set of error_range;
  error_message = packed array [1..ERROR_MESSAGE_LENGTH] of char;
  error_type    = array [error_range] of error_message;




  {-------------------------------------------------------------------}
  { The lexical analyzer scans the input stream returning a string of }
  { tokens (see SYMBOLS type).  When a new input stream is opened for }
  { scanning, the old stream can be pushed onto a stack so that the   }
  { scanner can return to it when done with the new stream.  This is  }
  { how, for example, text macros are processed.                      }
  {-------------------------------------------------------------------}


  parse_type = (PARSE_TRANSPARENTLY,       { parse string transparently }
                PARSE_SEPARATELY);         { parse string stand-alone }

  { NOTE on parse_type: PARSE_TRANSPARENTLY implies that the current
    string is a text macro definition.  This implication is important, as
    it is used to control the TM nesting depth count.  When a string
    that has been parsed "transparently" is popped, the depth is decremented.
    See parse_string and pop_parse_string (procedures). }

  parse_state = (FINIT, FINPUT, FGOT_CHAR);    { input scanner state }

  parse_file_type = (UNKNOWN_FILE,       { state when no file is open }
                     DIRECTIVES_FILE,    { directives file is open (infile) }
                     STANDARD_FILE,      { standard file is open (CmpStan) }
                     TEMP_FILE,          { Temp file is open (CmpTmp)}
                     CMPDRAW_FILE,       { cmpdraw file is in use (CmpDraw)}
		     CMPSCHEM_FILE);     { Schema file is in use 
		                           NOTE: if the drawing is going to
					   be compiled, then CmpSchemI stays
					   open until readly to write it
					   out to keep it locked }

  saved_parse_info = record
                       str: xtring;         { save of INSTRING }
                       last_pos,            { save of LAST_SYM_POS }
                       pos: string_range;   { save of LINEPOS }
                       state: parse_state;  { save of READ_STATE }
                       last: char;          { save of LASTCHAR }
                       symbol: symbols;     { save of SY }
                       constant: longint;   { save of CONST_VAL }
                       how: parse_type;     { save of HOW_TO_PARSE }
                       allow_TM: boolean;   { save of ALLOW_TM_EXPAND }
                       keys: setofsymbols;  { save of ALLOWED_KEY_WORDS }
                     end;

  parse_stack = array [1..MAX_STACK] of saved_parse_info;
  
  stack_index_range = 0..MAX_STACK;

  radix_characters = array[radix_range] of set_of_char;

  digit_width_list = array[radix_range] of natural_number;
  

  {------------------------------------------------------------------------}
  { The parser consists of a number of procedures designed to parse, using }
  { the lexical analyzer, the input files or contents of strings.          }
  {------------------------------------------------------------------------}


  syntax_specifier_type = (FIRST_SYNTAX_SPECIFIER,
                           NEGATION_SPECIFIER,
                           NAME_SPECIFIER,
                           SUBSCRIPT_SPECIFIER,
                           ASSERTION_SPECIFIER,
                           PROPERTY_SPECIFIER,
                           NULL_SPECIFIER,
                           LAST_SYNTAX_SPECIFIER);

  syntax_specifier_set = set of syntax_specifier_type;

  syntax_specifier_name_type = array [syntax_specifier_type] of name_ptr;

  signal_syntax_range = 1..SYNTAX_TABLE_SIZE;

  signal_syntax_table_type =
                         array [signal_syntax_range] of syntax_specifier_type;



  textfile = text;

{ open_mode = (READ_MODE, WRITE_MODE, UNBUF_READ, UNBUF_WRITE);       }(*370*)
{ open_mode = (READ_MODE, WRITE_MODE, UNBUF_READ, UNBUF_WRITE);     }(*ELXSI*)

  { -- generic file list -- }

  file_list_ptr = ^file_list_type;
  file_list_type = record
                     next: file_list_ptr;     { next file in the list }
                     file_name: xtring;       { name of the file }
                   end;



  { NOTE:  the file types are those expected by the Compiler.  There is
           one special consideration:  the ALLOWED_DIRECTORY element MUST
           appear before the LOGIC_DIRECTORY element.  This is because the
           ALLOWED_DIRECTORY element specifies the directory type that
           primitives to be output appear in (which may, in some cases be
           a LOGIC DIRECTORY) and we always need the ALLOWED_DIRECTORY
           file type to mark directories that contain valid primitives. }

  file_types = (FIRST_FILE_TYPE,
		ALLOWED_DIRECTORY,       { compile destination directory  }
		LOGIC_DIRECTORY,         { generic LOGIC_DIR              }
                PROPERTY_ATTRIBUTES,     { PROPERTY attributes file       }
                CONFIGURATION_SPEC,      { signal configuration file      }
                DIRECTORY_FILE,          { post 7.x SCALD directory       }
                LAST_FILE_TYPE);

  set_of_file_types = set of file_types;

  list_of_file_types = array [file_types] of name_ptr;
  extension_type = (LOGIC_EXTENSION,
                    PRIM_EXTENSION,
                    PART_EXTENSION, 
                    SPECIFIED_EXTENSION,
                    UNKNOWN_EXTENSION);



  body_type = (FIRST_BODY,
               MENU_BODY,
               DEFINE_BODY,
               DRAWING_BODY,
               PIN_NAMES_BODY,
               USER_BODY,
               DECLARE_BODY,
               LAST_BODY);

  body_list = array [body_type] of xtring;


  { -- configure types -- }

  configure_types = (FIRST_CONFIGURE_SPECIFIER,
                     CONFIGURE_SUBRANGE,
                     CONFIGURE_BIT_ORDERING,
                     CONFIGURE_LOW_ASSERTED,
                     CONFIGURE_HIGH_ASSERTED,
                     CONFIGURE_NEGATION,
                     CONFIGURE_NAME_PREFIX,       { not configurable }
                     CONFIGURE_GENERAL_PREFIX,
                     CONFIGURE_CONCATENATION,     { not configurable }
                     LAST_CONFIGURE_SPECIFIER);

  configure_specifier_type = array [configure_types] of name_ptr;

  { -- directive types:  these are declared in alphabetical order so
                         that output can be done alphabetically  -- }

  directive_type = (FIRST_DIRECTIVE,
                    ALLOW_PART_NAME_DIRECTIVE,
                    AMUSING_MESSAGES_DIRECTIVE,
                    BUBBLECHECK_DIRECTIVE,
                (*  CLASSGEN_DIRECTIVE,  *)
                    CARDINAL_TAP_DIRECTIVE,
                    COMMAND_DIRECTIVE,
                    COMPILE_DIRECTIVE,
                    CONFIG_FILE_DIRECTIVE,
                    CONST_BUBBLE_CHK_DIRECTIVE,
                    CONTEXT_DIRECTIVE,
                    DEBUG_DIRECTIVE,
                    DEBUG_AT_PATH_DIRECTIVE,
                    DEBUG_CONTROL_DIRECTIVE,
                    DECLARE_BODIES_DIRECTIVE,
                    DEFAULT_FILTER_DIRECTIVE,
                    DEFAULT_L_OR_G_DIRECTIVE,
                    DIRECTORY_DIRECTIVE,
                    ERROR_HELP_DIRECTIVE,
                    EVACUATE_DIRECTIVE,
                    EXPANSION_RULES_DIRECTIVE,
                    FILTER_PROPERTY_DIRECTIVE,
                    HIERARCHICAL_NWC_DIRECTIVE,
		    LOCALLY_GLOBAL_DIRECTIVE,
                    LIBRARY_DIRECTIVE,
                    MASTER_LIBRARY_DIRECTIVE,
                    MAX_ERROR_DIRECTIVE,
		    MERGE_DRAWINGS_DIRECTIVE,
                    NESTED_TM_PARAMS_DIRECTIVE,
                    NET_PROCESSING_DIRECTIVE,
                    OUTPUT_DIRECTIVE,
                    OVERSIGHT_DIRECTIVE,
                    PAGE_SYNONYM_DIRECTIVE,
                    PASS_PROPERTY_DIRECTIVE,
                    PASSWORD_DIRECTIVE,
                    PICK_DIRECTIVE,
                    PERMIT_NO_ASSERTION_DIRECTIVE,
                    PRIMITIVE_DIRECTIVE,
                    PROPERTY_DIRECTIVE,
                    PRINT_WIDTH_DIRECTIVE,
                    READ_ALL_UDIRS_DIRECTIVE,
                    REPORT_DIRECTIVE,
		    REPORT_UNKASSERT_DIRECTIVE,
                    ROOT_DIRECTIVE,
                    SHADOW_ROOT_DIRECTIVE,
                    SEPARATE_COMPILE_DIRECTIVE,
		    SHAREABLE_DIRECTIVE,
                    SINGLE_LEVEL_DIRECTIVE,
                    SUPPRESS_DIRECTIVE,
                    TEXT_MACRO_DIRECTIVE,
                    TOKENIZE_PARAMS_DIRECTIVE,
                    WARN_DIRECTIVE,
                    LAST_DIRECTIVE);

  directive_set = set of directive_type;
  directive_list = array [directive_type] of name_ptr;
  output_file_names = (FIRST_FILE_NAME,
                       CMPEXP_FILE,
                       CMPSYN_FILE,
                       CMPLST_FILE,
                       CMPERR_FILE,
                       CHIPS_FILE,
                       CMPHIER_FILE,
                       LAST_FILE_NAME);

  output_file_list = array [output_file_names] of name_ptr;

  file_kind_type = (LIST_FILE, DATA_FILE);        { see post_compile_time }

  { ------------------------------------------------------------------- }
  {                                                                     }
  { data types for temporary storage for printing pin_section of CMPEXP }
  { and chips file                                                      }

  temp_prop_ptr = ^temp_prop_list;
  temp_prop_list = record
		    next : temp_prop_ptr; { ^ next temp_prop in the list }
		    name : xtring;        { temp_prop name }
		    value: xtring;        { temp_prop value }
                   end;

  sig_ptr  = ^sig_list;
  sig_list = record
                    next : sig_ptr;       { ^ next signal in the list }
                    name : xtring;        { signal name }
                    left : longint;       { signal left }
                    right: longint;       { signal right }
                    proptr: temp_prop_ptr; { ^ head of sig_prop_list }
                   end;


  pin_ptr  = ^pin_list;
  pin_list = record
                    next : pin_ptr;       { ^ next pin in the list }
                    name : xtring;        { pin name }
                    left : longint;       { pin left }
                    right: longint;       { pin right }
                    proptr: temp_prop_ptr; { ^ head of pin properties }
                    sigptr: sig_ptr;      { ^ head of sig_list }
                   end;


