procedure new_pin(var p: pin_ptr);
  { create a new pin element }
begin
  if free_pin <> NIL then
    begin  p := free_pin;  free_pin := p^.next;  end
  else
      new(p);

  p^.next := NIL;
  p^.name := nullstring;
  p^.proptr := NIL;
  p^.sigptr := NIL;
end { new_pin } ;


procedure new_temp_prop(var p: temp_prop_ptr);
  { create a new pin element }
begin
  if free_temp_prop <> NIL then
    begin  p := free_temp_prop;  free_temp_prop := p^.next;  end
  else
      new(p);

  p^.next := NIL;
  p^.name := nullstring;
  p^.value := nullstring;
end { new_pin } ;


procedure new_signal(var p: sig_ptr);
  { create a new signal element }
begin
  if free_signal <> NIL then
    begin  p := free_signal;  free_signal := p^.next;  end
  else
      new(p);

  p^.next := NIL;
  p^.name := nullstring;
  p^.proptr := NIL;
end { new_signal } ;


procedure append_to_signal_list(var signal_list: sig_ptr;
                           signal_name: xtring;
                           signal_left,signal_right: longint);
  { append the given signal to signal_list }
  var
    P: sig_ptr;      { new signal created }
begin
  new_signal(P); 
  P^.name := signal_name;
  P^.left := signal_left; 
  P^.right := signal_right; 
  P^.proptr := NIL;
  P^.next := NIL;  
  signal_list := P;
end { append_to_signal_list } ;


procedure add_to_pin_list(var pin_list: pin_ptr;
                           pin_name: xtring;
                           pin_left,pin_right:longint);
  { add the given pin to head of pin list }
  var
    P: pin_ptr;      { new pin created }
begin
  new_pin(P); 
  P^.name := pin_name;
  P^.left := pin_left;
  P^.right := pin_right;
  P^.next := pin_list;  
  P^.sigptr := NIL;  
  P^.proptr := NIL;  
  pin_list := P;
end { add_to_pin_list } ;


procedure append_to_prop_list(var prop_list: temp_prop_ptr;
                           prop_name,prop_value: xtring);
  { add the given property to head of property list }
  var
    P: temp_prop_ptr;      { new property created }
begin
  new_temp_prop(P); 
  P^.name := prop_name;
  P^.value := prop_value;
  P^.next := NIL;  
  prop_list := P;
end { add_to_temp_prop_list } ;


procedure release_complete_prop_list(var prop_list: temp_prop_ptr);
  var
    prop, tail: temp_prop_ptr;
begin
  if prop_list <> NIL then
    begin
      prop := prop_list;  tail := NIL;
      while prop <> NIL do
        begin
          release_string(prop^.name);
          release_string(prop^.value);
          tail := prop;
          prop := prop^.next;
        end;
      tail^.next := free_temp_prop;
      free_temp_prop := prop_list;
      prop_list := NIL;
    end;
end { release_complete_prop_list } ;


procedure release_complete_signal_list(var signal_list: sig_ptr);
  var
    signal, tail: sig_ptr;
begin
  if signal_list <> NIL then
    begin
      signal := signal_list;  tail := NIL;
      while signal <> NIL do
        begin
          release_complete_prop_list(signal^.proptr);
          release_string(signal^.name);
          tail := signal;
          signal := signal^.next;
        end;
      tail^.next := free_signal;
      free_signal := signal_list;
      signal_list := NIL;
    end;
end { release_complete_signal_list } ;


procedure release_complete_pin_list(var pin_list: pin_ptr);
  var
    pin, tail: pin_ptr;
begin
  if pin_list <> NIL then
    begin
      pin := pin_list;  tail := NIL;
      while pin <> NIL do
        begin
          release_complete_prop_list(pin^.proptr);
          release_complete_signal_list(pin^.sigptr);
          release_string(pin^.name);
          tail := pin;
          pin := pin^.next;
        end;
      tail^.next := free_pin;
      free_pin := pin_list;
      pin_list := NIL;
    end;
end { release_complete_pin_list } ;


procedure print_property(var f:textfile;propname,propvalue:xtring);

   {prints property to f in the form propname='propvalue'}

begin { print_property }
   print_string_continue(f,propname);
   print_char_continue(f,'=');
   print_string_quoted_continue(f,propvalue);
end { print_property };
    
procedure print_subrange(var f:textfile;left,right:longint);

   { prints subrange of the signal to given file }

begin
   if (left <> -1 ) then begin
      print_char_continue(f,'<');
      if (left = right) then 
         print_integer_continue(f,left)
      else 
      begin
         print_integer_continue(f,left);
         print_char_continue(f,'.');
         print_char_continue(f,'.');
         print_integer_continue(f,right);
      end;
      print_char_continue(f,'>');
      end;
end { print_subrange };


function find_pin_prop(prop_list: temp_prop_ptr;  name: alpha;
                       var property: temp_prop_ptr): boolean;
  { look for the given property in an unordered list of properties }
  var
    prop: temp_prop_ptr;       { current property element }
    temp_string : xtring;      { temporary string }
    found: boolean;           { TRUE when property found }
begin
  property := NIL;  prop := prop_list;  found := FALSE;
  temp_string := nullstring;
  copy_to_string(name,temp_string);
  while (prop <> NIL) and not found do
    if ( compare_strings(temp_string,prop^.name) = EQ ) then
      begin  property := prop;  found := TRUE;  end
    else  prop := prop^.next;

  find_pin_prop:= found;
end { find_property } ;

procedure print_bindings(pin_list: pin_ptr);

var
   current_prop   : temp_prop_ptr;
   current_pin    : pin_ptr;
   current_signal : sig_ptr;
   temp_string    : xtring;      { temporary string }


begin { print_bindings }

   temp_string := nullstring;
   current_pin := pin_list;
   print_alpha_continue(CmpExp,' BINDINGS       ');
   print_CRLF_continue(CmpExp);
   while current_pin <> NIL do begin

       print_char_continue(CmpExp,' ');
       print_char_continue(CmpExp,' ');
       print_string_quoted_continue(CmpExp,current_pin^.name);
       print_subrange(CmpExp,current_pin^.left,current_pin^.right);
       if (current_pin^.left <> -1) then
	    print_char_continue(CmpExp,' ');
       if find_pin_prop(current_pin^.proptr,'BUBBLED         ',current_prop) 
	  then begin
	     print_char_continue(CmpExp,GENERAL_PROPERTY_PREFIX_CHAR);
	     print_property(CmpExp,current_prop^.name,current_prop^.value);
	     end;
       if find_pin_prop(current_pin^.proptr,'OUTPUT_TYPE     ',current_prop) 
	  then begin
	     print_char_continue(CmpExp,GENERAL_PROPERTY_PREFIX_CHAR);
	     print_property(CmpExp,current_prop^.name,current_prop^.value);
	     end;

       print_char_continue(CmpExp,'=');
       current_signal := current_pin^.sigptr;
       while current_signal <> NIL do begin

           print_string_quoted_continue(CmpExp,current_signal^.name);
           print_subrange(CmpExp,current_signal^.left,current_signal^.right);

           current_prop := current_pin^.proptr;
	   copy_to_string('BUBBLED         ',temp_string);
	   while current_prop <> NIL do begin

	       if not (compare_strings(temp_string,current_prop^.name) = EQ)
		  then begin
	             print_char_continue(CmpExp,GENERAL_PROPERTY_PREFIX_CHAR);
	             print_property(CmpExp,current_prop^.name,current_prop^.value);
		     end;
	       current_prop := current_prop^.next;
	       end {printing pin properties};

           current_prop := current_signal^.proptr;
	   while current_prop <> NIL do begin

	       print_char_continue(CmpExp,GENERAL_PROPERTY_PREFIX_CHAR);
	       print_property(CmpExp,current_prop^.name,current_prop^.value);
	       current_prop := current_prop^.next;
	       end {printing signal properties};

           current_signal := current_signal^.next;
	   if current_signal <> NIL then begin
	      print_char_continue(CmpExp,':');
              print_CRLF_continue(CmpExp);
	      end;
	      
           end {printing signal(s) attached to the pin};

       print_char_continue(CmpExp,';');
       print_CRLF_continue(CmpExp);

       current_pin := current_pin^.next;
       end {printing pin(s) attached to the primitive};
   print_alpha_continue(CmpExp,' END_BINDINGS   ');
   print_char_continue(CmpExp,';');
   print_CRLF_continue(CmpExp);
end {print_bindings};
