#include "lib/misc/platform.h"
#if !PMAX
#if VAX
[INHERIT('[-.SHARED]VOPEN')] 
#endif VAX
program expgen(input,output,monitor,CmpExp,Chips,CmpErr,CmpLog,CmpLst,
	       CmpSyn,infile,CmpStan);
#endif !PMAX

{----------------------------------------------------------------------}
{                                                                      }
{   program to generate compiler expansion, chips and synonym files    }
{   in the old format (Version 7.5 or earlier)                         }
{                                                                      }
{   - this program is using generalised interface routines             }
{     for the purpose of interfacing to the linker core                }
{                                                                      }
{----------------------------------------------------------------------}


#if SVS
  uses 
    {$U vopen.obj} vopenunit, 
    {$U unixtime.obj} unixtime;
#define OTHERWISE otherwise:
#endif SVS

#if SUN || PMAX
#include "vopen.h" 
#include "unixtime.h" 
#endif SUN || PMAX

#if VAX
#define BYVALUE %IMMED
#else
#define BYVALUE
#endif

#if VAX || PMAX
#define cexternal external 
#endif VAX || PMAX

#if SUN
#define cexternal external c
#endif SUN



{ Data Structures }

const
#include "consts.h"
type
#include "types.h"
var
#include "vars.h"



{ external "C" functions and procedures }

function vversion: xtring;
  { return the address of a staticly allocated xtring containing
    the current version string for ValidCOMPILER. }
cexternal;

procedure unbuf_stderr; cexternal;

#if SUN || PMAX
procedure exit(code: integer); cexternal;
#endif SUN || PMAX 

{ external procedures : linker core (new)interface routines }

#include "et.h"


#if PMAX
#define OTHERWISE otherwise:

type 
  prog_name_type = packed array[1..80] of char;
var
  program_name : prog_name_type;

procedure authorize(var name: prog_name_type);  external;
procedure remoteauthconfig(x,y,z: integer);  external;

program expgen(input,output,monitor,CmpExp,Chips,CmpErr,CmpLog,CmpLst, 
	       CmpSyn,infile,CmpStan); 
#endif PMAX

#if S32
procedure link; 
#endif S32

#include "proc1.p"
#include "parser.p"
#include "proc2.p"
#include "args.p"
#include "input.p"
#include "proc3.p"
#include "proc4.p"
#include "init.p"
#include "output.p"

begin { link/main }
#if PMAX
    argv(0, program_name);
    authorize(program_name);
    remoteauthconfig(0,0,0);
#endif
    unbuf_stderr;
    init_time_and_date(start_elapsed_time,start_CPU_time,compile_date);
    init;
    last_elapsed_time := start_elapsed_time;
    last_CPU_time := start_CPU_time;
    read_linker_directives_file;
    if root_macro_name = nullstring then
    begin
      error(148 { no root drawing name });
    end
    else
    begin
      dumpfiles;
    end;
(*  display_error_summaries;  *) (* too confusing to look at *)
    exec_time(start_elapsed_time,start_CPU_time,FALSE);

#if S32
end { link }; 


begin 
  link; 
#endif S32
end { main program }.

