(* NOTE -- this file now declares the constant max_string_length
   and the types string_range, char_array and sstring, so you
   should not also declare them.

   Sstring is a Valid (SCALD) string, with char count in the first byte.  
   Some of our programs use sstring for this type and some use xtring.
   There are many ways to resolve the conflict for those that use
   xtring.
*)

   
(* If platform is undefined, assume SUN *)
#ifndef S32
#ifndef PC_AT
#ifndef VAX
#ifndef SUN
#define SUN
#define ShX_undef_SUN
#endif SUN
#endif VAX
#endif PC_AT
#endif S32

#ifdef S32
#define SVS
#endif S32
#ifdef PC_AT
#define SVS
#endif PC_AT

#ifdef EXTERNAL
#define ShXEXTERNAL EXTERNAL
#undef EXTERNAL
#endif EXTERNAL

#ifdef SVS
unit vopenunit;
interface
#define EXTERNAL
#endif SVS

#ifdef SUN
#define EXTERNAL external;
#ifdef longint
#define ShXlongint longint
#undef longint
#endif longint
#define longint integer
#endif SUN

#ifdef VAX
#define EXTERNAL forward;
#define longint integer
[INHERIT('SYS$LIBRARY:STARLET'), ENVIRONMENT('VOPEN.PEN')]
module vopen;
#endif VAX

const
    stderrname = 'STANDARD_ERROR';
    stdoutname = 'STANDARD_OUTPUT';
#ifndef CMS
    alfasize = 16;
#endif
    max_string_length = 255;
    bigenvalsize = 560;   { lcf added  & changed - used to be 255 }
    { This must be big enough to hold a termcap entry if we have to pick it
    up from the environment.  Some of the termcap entries for the Ann Arbor
    Ambassador -- which resembles the BBN window package -- are as big as
    558 chars. }
type
#ifndef CMS
    alfa = packed array [1..alfasize] of char;
#endif
    binaryfile = file of longint;              { for binary output files }
    open_mode = (read_mode, write_mode, unbuf_read, unbuf_write);
    big_env_val_str = packed array [1..bigenvalsize] of char;

    string_range  = 0..max_string_length;
    char_array = packed array[string_range] of char;
    sstring = ^char_array;

#ifndef CMS
function vopen(
    var fi : text;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code : longint
    ) : boolean; EXTERNAL
{ Vopen is used by the compiler, simulator etc. to open UNIX files by treating
an environment variable for that file's name as a logical name for the file. 
It is also capable of opening files directly by name -- if strname is non-NIL
and has non-0 length, then it is used as the name of the file. 
ret_code is a system-dependent error code -- it is an ioresult code for
the S32 and an errno code for the SUN.  It can be converted into an SVS
code (for use with write_ioresult) by calling to_ioresult(ret_code). }

procedure write_ioresult(var fi : text; iores : longint); EXTERNAL
{ Given an error code returned by ioresult, print the appropriate error
message on file f. }

function to_ioresult(sys_code: longint): longint;  EXTERNAL
{ Given a system dependent error code (as returned by vopen), return
  an approximately equivalent ioresult error code }

function text_file_descr(var f: text): longint; EXTERNAL
{ Get the UNIX file descriptor for this file.  Returns meaningless garbage
if the file is not open. }

function vclose(var fi : text): boolean; EXTERNAL

function vbinopen(
    var fi : binaryfile;
    logname : alfa;
    strname : sstring;
    mode : open_mode;
    var ret_code: longint
    ) : boolean; EXTERNAL
{ Same as fopen, but for binary files.  Used for Simulator trace file. }

function vbinclose(var fi : binaryfile): boolean; EXTERNAL

function get_environment_variable(
    vbl: alfa;
    var val: big_env_val_str
    ): boolean; EXTERNAL
{ Get the contents of an environment variable; return true if the variable
was defined.  Used by the Simulator to get screen length and width from
the environment. }
#endif CMS

(* Clean up defines *)
#ifdef ShX_undef_SUN
#undef SUN
#undef ShX_undef_SUN
#endif ShX_undef_SUN

#undef EXTERNAL
#ifdef ShXEXTERNAL
#define EXTERNAL ShXEXTERNAL
#undef ShXEXTERNAL
#endif ShXEXTERNAL

#ifdef longint
#undef longint
#endif longint

#ifdef ShXlongint
#define longint ShXlongint
#undef ShXlongint
#endif ShXlongint
