 {-----------------------------  TYPES  --------------------------------}


#if !SVS
#define longint integer
#endif

  {---------------------}
  { miscellaneous types }
  {---------------------}

  xtring = sstring;          { sstring is declared in vopen }

  Cstring = ^char_array;     { a null-terminated string as used in the C
                               language }

  natural_number    = 0..MAXINT;                  { natural number range }
  short_int         = -32767..32767;              { a short integer }
  radix_range       = MIN_RADIX .. MAX_RADIX;     { valid radix range }
  unique_number     = natural_number;             { for NC signal creation }
  output_line_range = 0..MAX_OUTPUT_FILE_LENGTH;  { output file line length }

  compare_type = (LT, EQ, GT);       { for comparing links in tree }

#if VAX
  varystring = varying[MAX_STRING_LENGTH] of char; 
#endif
#if PMAX
  varystring = packed array[1..MAX_STRING_LENGTH] of char; 
#endif

  bit_range = -1..MAX_BIT_VALUE;

  set_of_char = set of char;


  {-----------------------------------------------------------------}
  {  An exception handler is used to intercept Pascal run-time and  }
  {  operating system errors so that the Compiler can handle them.  }
  {  This is especially true for file opening and I/O.  This type   }
  {  is used to characterize the error that occurred.               }
  {-----------------------------------------------------------------}


  { EXCEPTION_ERROR_TYPE is used to specify the exception encountered }

  exception_error_type = (NULL_ERROR_CODE,       { no exception encountered }
                          OPEN_CREATE_FAIL,      { file open/create failure }
                          OPEN_ACCESS_FAIL,      { file open/access failure }
                          CLOSE_FAIL,            { file close failure }
                          RESET_FAIL,            { file RESET failure }
                          REWRITE_FAIL,          { file REWRITE failure }
                          BUFFER_NOT_ALLOCATED,  { file buffer not allocated }
                          INAPPROPRIATE_FILE_TYPE,{ just that }
                          LINE_LENGTH_EXCEEDED,  { output line len exceeded }
                          HEAP_OVERFLOW,         { HEAP overflow }
                          STACK_OVERFLOW);       { STACK overflow }


  { special types needed by VAX/VMS exception processor }

  signal_parameter_type = array [0..9] of longint;
  mechanism_parameter_type = array [0..4] of longint;


  { special types needed by the 370/CMS exception processor }

  errortype = 1..90;               { number of exception errors }
  erroractions = (XHALT,           { terminate program }
                  XPMSG,           { print pascal diagnostic }
                  XUMSG,           { print user's message }
                  XTRACE,          { print a trace back }
                  XDEBUG,          { invoke the debugger }
                  XDECERR,         { decrement error counter }
                  XRESERVED6, XRESERVED7, XRESERVED8, XRESERVED9,
                  XRESERVEDA, XRESERVEDB, XRESERVEDC, XRESERVEDD,
                  XRESERVEDE, XRESERVEDF);

  errorset = set of erroractions;

  {----------------------------------------------------------------------}
  {  The Compiler has a lexical analyzer that scans the input character  }
  {  stream and returns a series of tokens representing objects in the   }
  {  input.  These tokens are described via the following type.          }
  {----------------------------------------------------------------------}

  symbols = (NULLSY,                   { no symbol read }
             CONSTANT,                 { constant - string of digits }
             IDENT,                    { identifier }
             SIGNALCONST,              { constant with radix specification }
             STRINGS,                  { character string }

             { -- ASCII characters -- }
             SPACE, EXCLAMATION, QUOTE, SHARP, DOLLAR, PERCENT, AMPERSAND,
             LPAREN, RPAREN, ASTERISK, PLUS, COMMA, MINUS, PERIOD, SLASH,
             COLON, SEMI, LESSTHAN, EQUAL, GREATERTHAN, QUESTION, ATSY,
             LBRACKET, BACKSLASH, RBRACKET, CIRCUMFLEX, UNDERBAR,
             ACCENTGRAVE, VERTICALBAR, TILDA,
             
             { -- two-character symbols -- }
             LESY, GESY, NESY, LTSY, GTSY, DOTDOTSY, COLONCOLONSY,
             
             { -- special key words -- }
             ENDSY,

             { -- expansion file symbols -- }
             PRIMITIVESY, ENDPRIMITIVESY,BODYSY,ENDBODYSY,
             PINSY, ENDPINSY, SIGNALSY, ENDSIGNALSY,
             BINDINGSY, ENDBINDINGSY,
             
             { -- file symbols -- }
             FILETYPESY,

             { -- end of type and input data -- }
             ENDOFDATASY);

  setofsymbols = set of symbols;


  {-------------------------------------------------------------------}
  { An IDENTIFIER is used to describe an array of characters of fixed }
  { length.  All identifiers are hashed into a table and identifier   }
  { comparison for equality can be done by comparing pointers.  Each  }
  { identifier has a set of attributes used to interpret its meaning  }
  { when the identifier is a property name.  When the identifier is   }
  { found in the context of input parsing, the SY field is used to    }
  { specify whether the identifier is a symbol and which it is.       }
  {-------------------------------------------------------------------}

  
  id_range = 1..ID_LENGTH;                    { range of an identifier }
  alpha = packed array [id_range] of char;    { identifier type }



  {-----------------------------------------------------------------------}
  { Each identifier has attributes that describe its characteristics:     }
  {    PERMANENT        a text macro whose definition is assumed to never }
  {                     change, so will not be logged in schema files for }
  {                     use in "make" operations.  These should also be   }
  {                     RESERVED (though having the PERMANENT attribute   }
  {                     does not, by itself, imply this).                 }
  {    RESERVED         a global reserved (standard) text macro read from }
  {                     a text macro file.  This can not be overridden by }
  {                     local text macros or parameters.                  }
  {    UNRESERVED       a global unreserved text macro read from a text   }
  {                     macro file.  This can be overridden by local text }
  {                     macros or parameters.                             }
  {    KEY_WORD         a key word token (in some context).               }
  {    INHERIT_PIN      inherits from pin to signal to pin if property.   }
  {    INHERIT_SIGNAL   inherits from signal to signal across synomyms.   }
  {    INHERIT_BODY     inherits from father to son - on output.          }
  {    IS_PARAMETER     is parsed and expanded if body property.          }
  {    IS_INT_PARAMETER parsed as integer expression if body property.    }
  {    PERMIT_SIGNAL    permitted to be connected to a signal.            }
  {    PERMIT_PIN       permitted to be connected to a pin.               }
  {    PERMIT_BODY      permitted to be connected to a body.              }
  {    DONT_OUTPUT      property not output to files.                     }
  {    IS_ET_CONTROL    property is needed for controlling et (linker)    }
  {                         so it is output even if DONT_OUTPUT is set.   }
  {                         (TERMINAL is an example of this).             }
  {-----------------------------------------------------------------------}

  name_types = (FIRST_NAME_TYPE,
                PERMANENT, RESERVED, UNRESERVED, KEY_WORD,
                INHERIT_PIN, INHERIT_SIGNAL, INHERIT_BODY,
                IS_PARAMETER, IS_INT_PARAMETER,
                PERMIT_SIGNAL, PERMIT_PIN, PERMIT_BODY,
                DONT_OUTPUT, IS_ET_CONTROL,
                LAST_NAME_TYPE);

  name_type_set = set of name_types;


  name_ptr = ^name_element;
  name_element = record
                   next: name_ptr;           { next in hash table thread }
                   name: alpha;              { identifier name }
                   kind: packed set of name_types; 
                   definition: xtring;       { if RESERVED in kind }
                   sy: symbols;              { if KEY_WORD in kind }
                 end;

  name_table_range = 0..NAME_TABLE_SIZE;      { range of identifier table }

  name_table_type = array [name_table_range] of name_ptr;


  identifier_ptr = ^identifier;
  identifier = record
                 next: identifier_ptr;    { used to link fields of a record }
                 name: name_ptr;          { name of this identifier }
                 definition: xtring;      { definition of the identifier }
		 resolves: boolean;       { True if definition was resolved
					    without error }
               end;


  { length of the input line buffer }

  line_buffer_type = packed array [1..INPUT_BUFFER_LENGTH] of char;




#if VAX
  time_string = packed array [1..TIME_BUFFER_LENGTH] of char;
#endif
#if IBM
  time_string = alfa;
#endif



  {---------------------------------------------------------------------}
  { A STRING is represented as a pointer to a packed array of char:     }
  {                                                                     }
  {    string = ^packed array [0..255] of char;                         }
  {                                                                     }
  { Each string, however, is usually less than 255 characters.  The     }
  { actual length of the string is found in the first byte:  string^[0].}
  { The length of the string is static;  it should not be changed once  }
  { the string has been created.                                        }
  {                                                                     }
  { Strings can be up to 255 characters long.  The programmer must make }
  { sure that characters are not written beyond the end of the string.  }
  {                                                                     }
  { Strings are created on the heap in quantized lengths.  There are 33 }
  { different length arrays created.  The CREATE_A_STRING routine       }
  { creates an array on the heap big enough to support the given string.}
  { Strings may be released for use at a later time (RELEASE_STRING).   }
  {                                                                     }
  { Strings are hashed into a table so that string compare for equality }
  { can be done by comparing pointers.                                  }
  {---------------------------------------------------------------------}

  {------- string types ---------------}

  freeptr = ^free_element;
  free_element = record
                   next: freeptr;     { next in linked list of free strings }
                   str: xtring;       { ^ free string element }
                 end;            

  hash_string_ptr = ^hash_string;
  hash_string = record
                  next_hash_string: hash_string_ptr;   { next in bucket }
                  str: xtring;                         { the string }
                end;

  hash_string_range = 0..HASH_STRING_TABLE_SIZE;   { size of hash table }

  hash_string_table_type = array [hash_string_range] of hash_string_ptr;


#if SVS
  svs_string = string[MAX_STRING_LENGTH];
#endif 

  { for h of type string_hack and xtring x, use the following to write xtring
    x to some file --
      h.i := ord(x) + 1;
      write(f, h.s^:ord(x^[0]));
    this is MUCH faster than 1 char at a time and works on all of
    our supported platforms.                                         }

  nolength_string = packed array[1..MAX_STRING_LENGTH] of char;
#if VAX
  string_hack = [volatile] record
#else
  string_hack = record
#endif
    case boolean of
      TRUE: (i: longint);
      FALSE:(s: ^nolength_string);
  end;
    { UNIX types }

    Cshort    = integer;
    Cu_short  = integer; { C interprets as unsigned }
    Cint      = longint;
    Clong     = longint;
    Cptr      = longint;
  
    Cfile = record  { See file fio.c for use of this record }
      f: Cptr;
      buffer: packed array[1..BUFSIZ] of char;
    end;


{-----------------------------------------------------------------------}
{ Records are scratch records for sargv and sargc, (which imitate       }
{ UNIX argv and argc).  They must be initialized by calling             }
{ init_cli_structures.  They are not to be accessed directly            }
{ other than by sargc and sargv, as they may or may not be used         }
{ depending on the implementation of those routines on the              }
{ current operating system.                                             }
{                                                                       }
{ These ideally would be local and static to those routines, but that   }
{ is not always possible in PASCAL.                                     }
{-----------------------------------------------------------------------}


  { scratch structures for sargv and sargc }
  cli_arg_range = 0..MAX_CLI_ARG_NUMBER;   
  cli_arg_index = -1..MAX_CLI_ARG_NUMBER;
  cli_arg_array_type =  array[cli_arg_range] of xtring;


  {-----------------------------------------------------------------------}
  {  Error handling is done through a number of common routines.  Errors  }
  {  are specified by number.  The current environment in which parsing   }
  {  takes place is described by a stack.  The top of the stack describes }
  {  the current environment.  This is output whenever a parse error is   }
  {  detected or can be output explicitly.                                }
  {-----------------------------------------------------------------------}

  assert_range  = 0..MAX_ASSERT_NUM;
  error_range   = 0..MAX_ERROR_NUM;
  assert_set    = set of assert_range;
  error_set     = set of error_range;
  error_message = packed array [1..40] of char;
  error_type    = array [error_range] of error_message;
  assert_type   = array [assert_range] of error_message;
  message_type  = packed array [1..MESSAGE_LENGTH] of char;

  output_page_range = 0..MAXINT;


  {-------------------------------------------------------------------}
  { debug flags are used to enable/disable output to the OUTFILE file }
  {-------------------------------------------------------------------}

  debug_controls = (FIRST_CONTROL,
                    CONTROL_DUMPTREE,         { symbol table dumps }
                    CONTROL_DUMPSIGNALS,      { signal def dump at end }
                    CONTROL_PRINTMACROS,      { macro def dump }
                    CONTROL_PRINTDIRECTORY,   { SCALD directory dump }
                    CONTROL_PRINTHISTOGRAMS,  { histograms of hash tables }
                    CONTROL_DUMPSIGDEFLIST,   { dump of node's signals }
                    CONTROL_DUMP_ALL_NAMES,   { dump of NAME hash table }
                    LAST_CONTROL);

  debug_control_list = array [debug_controls] of name_ptr;

  debug_flag_range = 0..MAX_DEBUG_FLAG_NUMBER;

  histogram_types = (FIRST_HISTOGRAM,
                     DIRECTORY_HISTOGRAM,     { SCALD directory histogram }
                     SIGNAL_HISTOGRAM,        { signal table histogram }
                     NAME_TABLE_HISTOGRAM,    { name hash table histogram }
                     STRING_TABLE_HISTOGRAM,  { string hash table histogram }
                     LAST_HISTOGRAM);

  histogram_table = array [histogram_types] of name_ptr;

  dump_debug_info_type = (DEBUG_DUMP_SYNONYMS,
                          DEBUG_DUMP_SIGNAL_DEFINITIONS,
                          DEBUG_GATHER_SYNONYM_STATS);



  {-------------------------------------------------------------------}
  { The lexical analyzer scans the input stream returning a string of }
  { tokens (see SYMBOLS type).  When a new input stream is opened for }
  { scanning, the old stream can be pushed onto a stack so that the   }
  { scanner can return to it when done with the new stream.  This is  }
  { how, for example, text macros are processed.                      }
  {-------------------------------------------------------------------}


  parse_state = (FINIT, FINPUT, FGOT_CHAR);    { input scanner state }

  parse_file_type = (UNKNOWN_FILE,       { state when no file is open }
                     STANDARD_FILE);

  radix_characters = array[radix_range] of set_of_char;
  digit_width_list = array[radix_range] of natural_number;
  


  textfile = text;             { output files }
#if UNIX
  inputfile = Cfile;
#else
  inputfile = text;
#endif 

  avl_ptr = ^avl;

  property_ptr = ^property_type;
  property_type = record            { data object for an avl tree }
    name: name_ptr;                 { property name }
    count: integer;                 { number of times property (same name
                                      and text) occurs on the object }
    case boolean of     
      TRUE: (text: xtring);         { property value }
      FALSE: (next: property_ptr);  { threads the free list }
  end;
      
  signal_ptr = ^signal_type;
  signal_type = record
    next: signal_ptr;
    name: xtring;
    properties: avl_ptr;
    left: bit_range;
    right: bit_range;
  end;

  pin_ptr = ^pin_type;
  pin_type = record            { data object for an avl tree }
    name: xtring;
    signals: signal_ptr;
    properties: avl_ptr;       { properties listed on pin }
    left: bit_range;
    right: bit_range;
  end;

  primitive_ptr = ^primitive_type;
  primitive_type = record     { data object for an avl tree }
    name: xtring;              { PATH_NAME -- better be unique }
    kind: xtring;              { type of primitive (such as '2 AND') }
    pinprops: avl_ptr;         { PIN to END_PIN pin properties }
    pins: avl_ptr;             { pins of the primtive }
    properties: avl_ptr;       { body properties }
    line_number: longint;      { of occurance of PRIMITIVE in file }
  end;

{----------------------------------------------------------------------}
{ The following types are used to construct AVL (height-balanced       }
{ binary) trees.  An AVL record contains all of the tree maintenance   }
{ fields and an field which points to the object entered in the tree.  }
{ The AVL_OBJECT_PTR can point to any 1 of a list of objects.  It      }
{ also can (using conditional complilation mechanism) contain a TAG    }
{ field which can remember what kind of object is presumed to be       }
{ represented.  This allows a run-time type checking to be performed   }
{ within the avl_compare function.   The BALANCE_FACTOR field of an    }
{ AVL keeps track of the difference between the left subtree of the    }
{ node and the right subtree of the node.  As long as the tree is      }
{ balanced, these heights can never differ by more than 1, so an       }
{ enumerated type is used.                                             }
{----------------------------------------------------------------------}
  balance_factor_type = (LEFT_HEAVY_BF, EVEN_BF, RIGHT_HEAVY_BF);
  avl_type = (AVL_FIRST,
              AVL_PRIMITIVE,
	      AVL_PIN,
	      AVL_PROPERTY,
	      AVL_SIGNAL,
	      AVL_LAST);

  avl_object_ptr = record
    case
  {      tag:                                         }(*AVL*)
              avl_type of
      AVL_FIRST: (bogus: ^integer);
      AVL_PRIMITIVE: (prim: primitive_ptr);
      AVL_PIN: (pin: pin_ptr);
      AVL_PROPERTY: (prop: property_ptr);
      AVL_SIGNAL:(sig: signal_ptr);
      AVL_LAST: (bogus2: ^integer);
  end;

  avl = record                       { the nodes of the tree }
    left_child: avl_ptr;
    right_child: avl_ptr;
    balance_factor: balance_factor_type;
    object: avl_object_ptr;
  end;


  avl_object_list_ptr = ^avl_object_list_type;
  avl_object_list_type = record      { for keeping temp lists of things }
    next: avl_object_list_ptr;
    object: avl_object_ptr;
  end;


