

function enter_primitive(var root: avl_ptr; prim: primitive_ptr): boolean;
  var
    object: avl_object_ptr;
    found: avl_ptr;
begin
{ object.tag := AVL_PRIMITIVE;                     }(*AVL*)
  object.prim := prim;
  found := avl_find(object, root, AVL_PRIMITIVE);
  if (found <> NIL) then enter_primitive := FALSE
  else
    begin
      found := avl_insert(object, root, AVL_PRIMITIVE);
      enter_primitive := (found <> NIL);
    end;
end { enter_primitive } ;


function enter_signal(var root: avl_ptr; sig: signal_ptr): boolean;
  var
    object: avl_object_ptr;
    found: avl_ptr;
begin
{ object.tag := AVL_SIGNAL;                     }(*AVL*)
  object.sig := sig;
  found := avl_find(object, root, AVL_SIGNAL);
  if (found <> NIL) then enter_signal := FALSE
  else
    begin
      found := avl_insert(object, root, AVL_signal);
      enter_signal := (found <> NIL);
    end;
end { enter_signal } ;


function enter_pin(prim: primitive_ptr; pin: pin_ptr): boolean;
  var
    object: avl_object_ptr;
    found: avl_ptr;
begin
{ object.tag := AVL_pin;                     }(*AVL*)
  object.pin := pin;
  found := avl_find(object, prim^.pins, AVL_pin);
  if (found <> NIL) then enter_pin := FALSE
  else
    begin
      found := avl_insert(object, prim^.pins, AVL_pin);
      enter_pin := (found <> NIL);
    end;
end { enter_pin } ;


function enter_property(var root: avl_ptr; name: name_ptr; text: xtring):
  property_ptr;
  { return a pointer to the entered property }
  var
    object: avl_object_ptr;
    found: avl_ptr;
begin
{ object.tag := AVL_PROPERTY                 }(*AVL*)
  if free_properties = NIL then new(object.prop)
  else
    begin
      object.prop := free_properties;
      free_properties := free_properties^.next;
    end;
  object.prop^.name := name;
  object.prop^.text := text;
  object.prop^.count := 1;
  found := avl_insert(object, root, AVL_PROPERTY);
  if found = NIL then
    parse_error('ASSERTION FAILURE: Failed property table entry !!')
  else
    begin
      enter_property := found^.object.prop;
      if found^.object.prop <> object.prop then
        begin
          release_property(object.prop);
	  found^.object.prop^.count := found^.object.prop^.count + 1;
        end;
    end;
end { enter_property } ;


procedure copy_properties(source: avl_ptr; var dest: avl_ptr);
  var
    prop: property_ptr;
begin
  if source <> NIL then
    begin
      prop := enter_property(dest, source^.object.prop^.name,
                                   source^.object.prop^.text);
      if source^.object.prop^.count > 1 then
        prop^.count := prop^.count - 1 + source^.object.prop^.count;

      if source^.left_child <> NIL then
        copy_properties(source^.left_child, dest);
      if source^.right_child <> NIL then
        copy_properties(source^.right_child, dest);
    end;
end { copy_properties } ;
