procedure parse_expansion_file(var top, topsig: avl_ptr);
  const
    REP_SPECIAL = TRUE;      { parameter value for parse_backslash_prop... }
    REP_NOT_SPECIAL = FALSE; { parameter value for parse_backslash_prop... }


  function parse_backslash_properties(var props: avl_ptr;
                                      parse_rep: boolean): natural_number;
    { if check_properties then return the properties in props.
      If parse_rep then return the integer value of the rep property
      and elide it from the list.  1 is returned if not parse_rep or rep
      is not encountered.}
    var
      name: name_ptr;
  begin
    parse_backslash_properties := 1;
    while sy = BACKSLASH do
      begin
        insymbol;
        if sy <> IDENT then parse_error('Expected property name');
	name := id.name;
        insymbol;
        if sy <> EQUAL then parse_error('Expected =');
        insymbol;
        if sy <> STRINGS then parse_error('Expected property value');
	if parse_rep and (name = REP_prop_name) then
	  parse_backslash_properties := string_to_natural_number(lex_string)
	else if check_properties then
	  if enter_property(props, name, lex_string) = NIL then ;
        insymbol;
      end;
  end { parse_backslash_properties } ;


  procedure parse_body_properties(prim: primitive_ptr);
    { if check_properties then build the property table. 
      In any case, set the name (PATH_NAME) and line_number fields. }
    var
      name: name_ptr;
      save_keys: setofsymbols;
  begin
    save_keys := allowed_key_words;  allowed_key_words := [ENDBODYSY];
    if sy <> BODYSY then parse_error('Expected BODY');
    insymbol;
    while sy = IDENT do
      begin
	name := id.name;
        insymbol;
        if sy <> EQUAL then parse_error('Expected =');
        insymbol;
        if sy <> STRINGS then parse_error('Expected property value');
	if name = PATH_NAME_prop_name then
	  begin
	    prim^.name := lex_string;
	    prim^.line_number := input_line_number;
	  end;
	if check_properties then
	  if enter_property(prim^.properties, name, lex_string) = NIL then ;
        insymbol;
	if sy <> SEMI then parse_error('Expected ;');
	insymbol;
      end;
    if sy <> ENDBODYSY then parse_error('Expected END_BODY');
    if prim^.name = nullstring then parse_error('Expected PATH_NAME');
    insymbol;
    if sy <> SEMI then parse_error('Expected ;');
    allowed_key_words := save_keys;
    insymbol;
  end { parse_body_properties } ;


  procedure parse_subrange(var left, right: bit_range);
  begin
    if sy = LESSTHAN then
      begin
        insymbol;
	if sy <> CONSTANT then parse_error('Expected constant');
	left := const_val;
	insymbol;
	if sy = DOTDOTSY then
	  begin
	    insymbol;
	    if sy <> CONSTANT then parse_error('Expected constant');
	    right := const_val;
	    insymbol;
	  end
	else right := left;
	if sy <> GREATERTHAN then parse_error('Expected >');
	insymbol;
      end
    else
      begin
        left := SCALAR_BIT;  right := SCALAR_BIT;
      end;
  end { parse_subrange } ;


  procedure parse_actual(pin: pin_ptr);
    var
      name: xtring;
      left: bit_range;
      right: bit_range;
      last: signal_ptr;
      rep: natural_number;
      prop_root: avl_ptr;


    procedure append_signal;
      label
        90; { return }
      var
        sig: signal_ptr;


	procedure merge_NCs(width: natural_number);
	begin
	  if last^.left = 0 then last^.right := last^.right + width - 1
	  else if last^.right = 0 then last^.left := last^.left + width - 1
	  else assert(158);
	end { merge_NCs } ;


    begin { append_signal }
      if name = NC_string then
        begin
	  if left = SCALAR_BIT then 
	    begin  left := 0;  right := 0;  end;
          if last <> NIL then
            if last^.name = NC_string then
	      begin
                if (left <> 0) and (right <> 0) then
		  parse_error('Ill formed NC in expansion file');
	        merge_NCs(abs(left - right) + 1);
	        goto 90 { return } ;
	      end;
	end;
      new(sig);
      sig^.next := NIL;
      sig^.name := name;
      sig^.left := left;
      sig^.right := right;
      sig^.properties := prop_root;
      prop_root := NIL;
      if last = NIL then pin^.signals := sig
                    else last^.next := sig;
      last := sig;
    90:
    end { append_signal } ;


    procedure modify_right_index;
    begin
      last^.right := right;
      release_all_properties(prop_root);
    end { modify_right_index } ;


  begin { parse_actual }
    last := NIL;
    prop_root := NIL;
    while sy = STRINGS do
      begin
	name := lex_string;
	insymbol;
	if sy = LESSTHAN then parse_subrange(left, right)
	else
	  begin  left := SCALAR_BIT;  right := SCALAR_BIT;  end;
        if sy = BACKSLASH 
	  then rep := parse_backslash_properties(prop_root, REP_SPECIAL)
	else rep := 1;
        if rep <> 1 then
	  repeat
	    append_signal;
	    rep := rep - 1;
	  until (rep <= 0)
        else if last = NIL then append_signal
	else if left = SCALAR_BIT then append_signal
	else if name <> last^.name then append_signal
	else if not compare_properties(prop_root, last^.properties) then
	  append_signal
	else { same signal -- same properties }
	  if left = right then
	    if (last^.left >= last^.right) and (left = (last^.right - 1)) then
	      modify_right_index
	    else
	      if (last^.left <= last^.right) and 
	         (left = (last^.right + 1)) then modify_right_index
              else append_signal
	  else if left > right then
	    if (last^.left >= last^.right) and (left = (last^.right - 1)) then
	      modify_right_index
	    else append_signal
	  else { left < right }
	    if (last^.left <= last^.right) and (left = (last^.right + 1)) then
	      modify_right_index
	    else append_signal;
	if sy = COLON then insymbol;
      end;
    if sy <> SEMI then parse_error('Expected ;');
    insymbol;
  end { parse_actual } ;


  procedure parse_bindings(prim: primitive_ptr);
    var
      pin: pin_ptr;
      dummy: natural_number;
      save_keys: setofsymbols;
  begin
    save_keys := allowed_key_words;  allowed_key_words := [ENDBINDINGSY];
    insymbol;
    while sy = STRINGS do
      begin
        new(pin);
	pin^.signals := NIL;
	pin^.name := lex_string;
	pin^.properties := NIL;
	insymbol;
	if sy = LESSTHAN then parse_subrange(pin^.left, pin^.right)
	else  begin  pin^.left := SCALAR_BIT;  pin^.right := SCALAR_BIT;  end;
	if not enter_pin(prim, pin) then
	  begin
	    write(monitor, 'Pin ');
	    writestring(monitor, pin^.name);
	    write(monitor, ' already exists on primitive ');
	    writestring(monitor, prim^.name);
	    writeln(monitor);
	    halt_with_status(FATAL_COMPLETION);
	  end;
	if sy = BACKSLASH then 
	  dummy := parse_backslash_properties(pin^.properties, 
	           REP_NOT_SPECIAL);
	if sy <> EQUAL then parse_error('Expected =');
	insymbol;
	if sy <> STRINGS then parse_error('Expected signal name');
	parse_actual(pin);
      end;
    if sy <> ENDBINDINGSY then parse_error('Expected END_BINDING');
    insymbol;
    if sy <> SEMI then parse_error('Expected ;');
    allowed_key_words := save_keys;
    insymbol;
  end { parse_bindings } ;


  procedure parse_pin_section(var toppin: avl_ptr);
    { if check_properties, then parse the PIN section and build a
      table of propertied pins with toppin pointing to the root.
      Otherwise, skip it.  NOTE: Signal_types are used to represent
      the pins in this section, as they have the right fields and
      the compare routines for the signal section can thus be re-used
      to compare these. }
    var
      pin: signal_ptr;
      prop: name_ptr;
      save_keys: setofsymbols;
  begin
    if sy = PINSY then
      begin
        save_keys := allowed_key_words;  allowed_key_words := [ENDPINSY];
        insymbol;
        if (not check_properties) and (sy <> ENDPINSY) then
	  skip([ENDPINSY]);
	while (sy = STRINGS) do
	  begin
            new(pin);  
	    pin^.next := NIL;  pin^.properties := NIL;
	    pin^.name := lex_string;
	    insymbol;
	    if sy = LESSTHAN then parse_subrange(pin^.left, pin^.right)
	    else
	      begin  pin^.left := SCALAR_BIT;  pin^.right := SCALAR_BIT;  end;
	    if sy <> COLON then parse_error('Expected :');
	    insymbol;
            if not enter_signal(toppin, pin) then
              begin
	        write(monitor, 'Pin ');
	        writestring(monitor, pin^.name);
		dump_left_and_right(monitor, pin^.left, pin^.right);
	        writeln(' already exists');
	        halt_with_status(FATAL_COMPLETION);
	      end;

	    while (sy = IDENT) do
	      begin
		prop := id.name;
		insymbol;
		if sy <> EQUAL then parse_error('Expected =');
		insymbol;
		if sy <> STRINGS then parse_error('Expected property value');
		if enter_property(pin^.properties, prop, lex_string) <> NIL
		  then ;
		insymbol;
		if sy = SEMI then insymbol;
	      end;
	  end;
	if sy <> ENDPINSY then parse_error('Expected END_PIN');
	insymbol;
	if sy <> SEMI then parse_error('Expected ;');
	allowed_key_words := save_keys;
	insymbol;
      end;
  end { parse_pin_section } ;
      

  procedure parse_primitives;
    var
      prim: primitive_ptr;
  begin
    while sy = PRIMITIVESY do
      begin
        insymbol;
	if sy <> STRINGS then parse_error('Expected type of primitive');
        new(prim);
        prim^.pinprops := NIL;
	prim^.pins := NIL;
        prim^.name := nullstring; { set by parse_body_properties }
	prim^.kind := lex_string;
	prim^.properties := NIL;
	prim^.line_number := 0;   { set by parse_body_properties }
	insymbol;
	if sy <> SEMI then parse_error('Expected ;');
	insymbol;
        if sy = PINSY then parse_pin_section(prim^.pinprops);
	if sy <> BODYSY then parse_error('Expected BODY');
	parse_body_properties(prim);
        if not enter_primitive(top, prim) then 
          begin
	    write(monitor, 'Primitive ');
	    writestring(monitor, prim^.name);
	    writeln(' already exists');
	    halt_with_status(FATAL_COMPLETION);
	  end;
        if sy = BINDINGSY then parse_bindings(prim);
	if sy <> ENDPRIMITIVESY then parse_error('Expected END_PRIMITIVE');
	insymbol;
	if sy <> SEMI then parse_error('Expected ;');
	insymbol;
      end;
  end { parse_primitives } ;


  procedure parse_signals;
    { if check_properties, then parse the SIGNAL section and build a
      table of propertied signals with topsig pointing to the root.
      Otherwise, skip it. }
    var
      sig: signal_ptr;
      prop: name_ptr;
      save_keys: setofsymbols;
  begin
    if sy = SIGNALSY then
      begin
        save_keys := allowed_key_words;  allowed_key_words := [ENDSIGNALSY];
        insymbol;
        if (not check_properties) and (sy <> ENDSIGNALSY) then
	  skip([ENDSIGNALSY]);
	while (sy = STRINGS) do
	  begin
            new(sig);  
	    sig^.next := NIL;  sig^.properties := NIL;
	    sig^.name := lex_string;
	    insymbol;
	    if sy = LESSTHAN then parse_subrange(sig^.left, sig^.right)
	    else
	      begin  sig^.left := SCALAR_BIT;  sig^.right := SCALAR_BIT;  end;
	    if sy <> COLON then parse_error('Expected :');
	    insymbol;
            if not enter_signal(topsig, sig) then
              begin
	        write(monitor, 'Signal ');
	        writestring(monitor, sig^.name);
		dump_left_and_right(monitor, sig^.left, sig^.right);
	        writeln(' already exists');
	        halt_with_status(FATAL_COMPLETION);
	      end;

	    while (sy = IDENT) do
	      begin
		prop := id.name;
		insymbol;
		if sy <> EQUAL then parse_error('Expected =');
		insymbol;
		if sy <> STRINGS then parse_error('Expected property value');
		if enter_property(sig^.properties, prop, lex_string) <> NIL
		  then ;
		insymbol;
		if sy = COMMA then insymbol;
	      end;
	    if sy <> SEMI then parse_error('Expected ;');
	    insymbol;
	  end;
	if sy <> ENDSIGNALSY then parse_error('Expected END_SIGNALS');
	insymbol;
	if sy <> SEMI then parse_error('Expected ;');
	allowed_key_words := save_keys;
	insymbol;
      end;
  end { parse_signals } ;
      

  begin { parse_expansion_file }
    top := NIL;  topsig := NIL;
    if (sy <> FILETYPESY) then parse_error('Expected FILE_TYPE');
    skip([PRIMITIVESY,SIGNALSY]);
    if sy = PRIMITIVESY then parse_primitives;
    if not (sy in [ENDSY,SIGNALSY]) then
      parse_error('Expected END or SIGNALS');
    if sy = SIGNALSY then parse_signals;
    if sy <> ENDSY then parse_error('Expected END');
    insymbol;
    if sy <> PERIOD then parse_error('Expected .');
  end { parse_expansion_file } ;

