#include "lib/misc/platform.h"

(*****************************************************************************

                          Copyright 1985
                             
                    VALID LOGIC SYSTEMS INCORPORATED


This  listing  contains  confidential  proprietary information which is not to
be disclosed to unauthorized persons without the written consent of an officer
of Valid Logic Systems Incorporated.

The  copyright  notice  appearing  above  is  included  to  provide  statutory
protection  in the event of  unauthorized or unintentional  public disclosure.

Luigi "Kneebreaker" Cordola knows where your children live!

*****************************************************************************)


(**)


#if !PMAX
#if VAX
[INHERIT('[-.SHARED]VOPEN','SYS$LIBRARY:STARLET')] 
#endif
program expdiff(input, output, monitor);
#endif !PMAX

#if SVS
  uses
    {$U vopen.obj} vopenunit,
    {$U unixtime.obj} unixtime;
#define OTHERWISE otherwise:
#endif
#if SUN || PMAX
#include "vopen.h" 
#include "unixtime.h"
#endif

#if SUN
#define cexternal external c 
#endif

#if PMAX || VAX
#define cexternal external
#endif

#if VAX
#define BYVALUE %IMMED
#else
#define BYVALUE
#endif


const
#include "consts.h"

(**)

type
#include "types.h"

(**)

var
#include "vars.h"


#include "externals.p"


#if PMAX
#define OTHERWISE otherwise:
program expdiff(input, output, monitor);
#endif
#if SVS
procedure main_procedure;
  { Forces other procedures to levels > 1 so names aren't shortened }

#endif
#include "procs.p"
#include "insymbol.p"
#include "avlcompare.p"
#include "heap.p"
#include "avldebug.p"
#include "../avl/insert.p"
#include "../avl/traverse.p"
#include "table.p"
#include "compare.p"
#include "parse.p"


function can_open_files: boolean;
begin
  can_open_files := TRUE;

  if not open_a_file(file1, STANDARD_FILE) then
    begin
      can_open_files := FALSE;
      write(monitor, ' Can''t open file ');
      writestring(monitor, file1);
      writeln(monitor);
    end
  else if close_parse_file(STANDARD_FILE) then ;

  if not open_a_file(file2, STANDARD_FILE) then
    begin
      can_open_files := FALSE;
      write(monitor, ' Can''t open file ');
      writestring(monitor, file2);
      writeln(monitor);
    end
  else if close_parse_file(STANDARD_FILE) then ;
                                                                  
#if UNIX
  { The following causes buffered ouput to standard out }
  if not rewrite_file(outfile, dev_null, 'OUTFILE         ') then
    begin
      can_open_files := FALSE;
      writeln(monitor, ' Can''t write to /dev/null');
    end
  else
    begin
#if SVS
      { reverse parameters for SVS }
      if dup2(text_file_descr(outfile), 1) = -1 then
#else
      if dup2(1, text_file_descr(outfile)) = -1 then
#endif 
        begin
	  can_open_files := FALSE;
	  writeln(monitor, ' Can''t access standard output');
	end;
    end;
#endif UNIX
end { can_open_files } ;


procedure process_directives;
  var
    arg_number: natural_number;
    arg: xtring;
    done: boolean;
    i: string_range;


  procedure print_usage;
  begin
    writeln(monitor, 'Usage: expdiff [-p][+p] <file1> <file2>');
    halt_with_status(FATAL_COMPLETION);
  end { print_usage } ;


  procedure process_flag(ch: char; val: boolean);
  begin
    case ch of
      'p': check_properties := val;
      'P': check_properties := val;
      OTHERWISE print_usage;
    end;
  end { process_flag } ;


begin { process directives }
  arg_number := 1;  done := FALSE;
  while ((arg_number < (sargc - 1)) and not done) do
    begin
      sargv(arg_number, arg);
      if ord(arg^[0]) > 0 then
        if arg^[1] = '-' then
	  begin
	    for i := 2 to ord(arg^[0]) do process_flag(arg^[i], FALSE);
	    arg_number := arg_number + 1;
	  end
        else if arg^[1] = '+' then
	  begin
	    for i := 2 to ord(arg^[0]) do process_flag(arg^[i], TRUE);
	    arg_number := arg_number + 1;
	  end
	else done := TRUE
      else done := TRUE;
    end;
  if sargc < (arg_number + 2) then print_usage;
  file1 := arg;
  arg_number := arg_number + 1;
  sargv(arg_number, file2);

  arg_number := arg_number + 1;
  while arg_number < sargc do
    begin
      sargv(arg_number, arg);
      if (arg^[0] <> chr(0)) then print_usage;
      arg_number := arg_number + 1;
    end;
end { process directives } ;


#include "timeutils.p"


begin { main procedure }
  init_time_and_date(start_elapsed_time, start_CPU_time, compile_date);
  last_elapsed_time := start_elapsed_time;
  last_CPU_time := start_CPU_time;

  init;
  process_directives;
  if can_open_files then
    begin
      writeln(monitor);
      write(monitor, ' Reading file1 ');
      writestring(monitor, file1);
      writeln(monitor, '...');
      if open_a_file(file1, STANDARD_FILE) then
        parse_expansion_file(prim_table_1, sig_table_1)
      else halt_with_status(FATAL_COMPLETION);
      if close_parse_file(STANDARD_FILE) then ;
      write(monitor, '     done ');
      exec_time(last_elapsed_time, last_CPU_time, TRUE);

      writeln(monitor);
      write(monitor, ' Reading file2 ');
      writestring(monitor, file2);
      writeln(monitor, '...');
      if open_a_file(file2, STANDARD_FILE) then
        parse_expansion_file(prim_table_2, sig_table_2)
      else halt_with_status(FATAL_COMPLETION);
      if close_parse_file(STANDARD_FILE) then ;
      write(monitor, '     done ');
      exec_time(last_elapsed_time, last_CPU_time, TRUE);

      writeln(monitor);
      write(monitor, ' Comparing data ');
      if check_properties then
        writeln(monitor, '(connectivity and properties)...')
      else
        writeln(monitor, '(connectivity only)...');
#if UNIX
      compare_netlists(outfile, prim_table_1, prim_table_2);
      compare_signal_sections(outfile, sig_table_1, sig_table_2);
      close_file(outfile, 'OUTFILE         '); 
#else
      compare_netlists(output, prim_table_1, prim_table_2);
      compare_signal_sections(output, sig_table_1, sig_table_2);
      close_file(output, 'OUTPUT          ');
#endif
    end
  else halt_with_status(FATAL_COMPLETION);


  if detected_differences then
    begin
      write(monitor, '     Detected differences ');
      exec_time(last_elapsed_time, last_CPU_time, TRUE);
      exec_time(start_elapsed_time, start_CPU_time, FALSE);
      halt_with_status(DIFFERENCE_COMPLETION);
    end
  else
    begin
      write(monitor, '     Equivalent! ');
      exec_time(last_elapsed_time, last_CPU_time, TRUE);
      exec_time(start_elapsed_time, start_CPU_time, FALSE);
      halt_with_status(SUCCESSFUL_COMPLETION);
    end;

#if SVS
end { main_procedure } ;
begin { main }
  main_procedure;
#endif SVS
end.
