
function primitive_order(prim1, prim2: primitive_ptr): compare_type;
begin
  if ord(prim1^.name) < ord(prim2^.name) then primitive_order := LT
  else if ord(prim1^.name) = ord(prim2^.name) then primitive_order := EQ
  else primitive_order := GT;
end { primitive_order } ;


function pin_order(pin1, pin2: pin_ptr): compare_type;
begin
  if ord(pin1^.name) < ord(pin2^.name) then pin_order := LT
  else if ord(pin1^.name) = ord(pin2^.name) then
    begin
      if pin1^.left < pin2^.left then pin_order := LT
      else if pin1^.left = pin2^.left then pin_order := EQ
      else pin_order := GT;
    end
  else pin_order := GT;
end { pin_order } ;


function signal_order(signal1, signal2: signal_ptr): compare_type;
begin
  if ord(signal1^.name) < ord(signal2^.name) then signal_order := LT
  else if ord(signal1^.name) = ord(signal2^.name) then
    begin
      if signal1^.left < signal2^.left then signal_order := LT
      else if signal1^.left = signal2^.left then signal_order := EQ
      else signal_order := GT;
    end
  else signal_order := GT;
end { signal_order } ;


function property_order(prop1, prop2: property_ptr): compare_type;
begin
  if ord(prop1^.name) < ord(prop2^.name) then property_order := LT
  else if ord(prop1^.name) = ord(prop2^.name) then
    begin
      if ord(prop1^.text) < ord(prop2^.text) then property_order := LT
      else if ord(prop1^.text) = ord(prop2^.text) then property_order := EQ
      else property_order := GT;
    end
  else property_order := GT;
end { property_order } ;


function avl_compare(obj1, obj2: avl_object_ptr; kind: avl_type): compare_type;
  { compare the 2 avl objects as appropriate for their type }
begin
{ if not ((obj1.tag = obj2.tag) and (obj2.tag = kind)) then     }(*AVL*)
{   begin                                                       }(*AVL*)
{     assert(245);                                              }(*AVL*)
{   end                                                         }(*AVL*)
{ else                                                          }(*AVL*)
    case kind of
      AVL_PRIMITIVE: 
        avl_compare := primitive_order(obj1.prim, obj2.prim);
      AVL_PIN: 
        avl_compare := pin_order(obj1.pin, obj2.pin);
      AVL_PROPERTY:
        avl_compare := property_order(obj1.prop, obj2.prop);
      AVL_SIGNAL:
        avl_compare := signal_order(obj1.sig, obj2.sig);
      OTHERWISE assert(244 { Oh No! });
    end;
end { avl_compare } ;


