#include "add/v_add.h"
#include "add/add.h"
#include "add/buffer.h"
#include "add/extern.h"
#include "lib/misc/platform.h"

#include <ctype.h>
#include <stdio.h>

#ifdef BSD42
#include <strings.h>
#endif
#ifdef SYS5
#include <string.h>
#endif

#ifdef UNIX
#define SUCCESS_EXIT 0
#define ERROR_EXIT 1
#endif
#ifdef VMS
#define SUCCESS_EXIT 1
#define ERROR_EXIT 2
#endif



/* output files in drawing directory written by pre 1.3 compiler */

#define OLDSCHEMA "OSCHEMA"
#define OLDLINKLST "OLL"
#define OLDPAGEEXP "OPE"
#define OLDPAGELST "OPL"
#define C1_1_6EXP "C116EXP"
#define C1_1_6LST "C116LST"
#define C1_1_6LLI "C116LLI"
#define FILETYPE_DELIMITER "_"
#define MAX_LINE_LENGTH 80
#define str_or_null(s) s ? s : "<NULL>"
#ifdef UNIX
#define DELETE_FILE unlink
#endif
#ifdef VMS
#define DELETE_FILE delete 
#include <rms.h>
#include <descrip.h>
#define toupper _toupper
#define STRING_BUF_SIZE 1024
typedef struct dsc$descriptor_s STRINGDESC;


static void
consdesc(desc, buf, len)
register STRINGDESC *desc;
char *buf;
{
    desc->dsc$w_length = len;
    desc->dsc$a_pointer = buf;
    desc->dsc$b_class = DSC$K_CLASS_S;
    desc->dsc$b_dtype = DSC$K_DTYPE_T;
}


static void
fnamedesc(desc, name)
STRINGDESC *desc;
char *name;
{
    char *p;
    int len;
    
    if (p = index(name, ',')) len = p - name;
    else len = strlen(name);
    consdesc(desc, name, len);
}


static int
fnamedesc_next(desc)
register STRINGDESC *desc;  /* assumed created originally by fnamedesc() */
{
    register char *name, *p;
    int len;

    name = desc->dsc$a_pointer + desc->dsc$w_length;
    if (*name++ && *name) {
	if (p = index(name, ',')) len = p - name;
	else len = strlen(name);
	consdesc(desc, name, len);
	return TRUE;
	}
    return FALSE;
}


#define SUCCESS 1
#define DONE 0
#define ERROR -1

#define VMS_DEFAULTING 2
static int context={0};  /* context for repeated LIB$FIND_FILE */
static STRINGDESC Sdesc;

int
vms_file_arg_init(dd, ss)
    char *dd, *ss;
{
    char *index();
    register char *fuckdec, *p;
    int flags, rc;
    STRINGDESC Ddesc;

    AS(!context);

    fnamedesc(&Sdesc, ss);
    consdesc(&Ddesc, dd, STRING_BUF_SIZE);
    flags = VMS_DEFAULTING;

    rc = LIB$FIND_FILE(&Sdesc, &Ddesc, &context, 0, 0, 0, &flags);

    if (!odd(rc)) {
	if (rc == RMS$_NMF) {
            LIB$FIND_FILE_END(&context);
	    AS(!context);
	    return DONE;
	    }
        rc = ERROR;
        }
    else rc = SUCCESS;

    dd[Ddesc.dsc$w_length-1] = '\0';
    for (p = "; "; *p != '\0'; p++) {
        if ((fuckdec = index(dd, *p)) != 0) {
            *fuckdec = '\0';
            break;
            }
        }

    return rc;
}

int
vms_file_arg_next(dd)
    char *dd;
{
    char *index();
    register char *fuckdec, *p;
    int flags, rc;
    STRINGDESC Ddesc;

    AS(context);

    (void)consdesc(&Ddesc, dd, STRING_BUF_SIZE);
    flags = VMS_DEFAULTING;

    rc = LIB$FIND_FILE(&Sdesc, &Ddesc, &context, 0, 0, 0, &flags);

    if (!odd(rc)) {
	if (rc == RMS$_NMF) {
	    if (fnamedesc_next(&Sdesc)) return vms_file_arg_next(dd);
            LIB$FIND_FILE_END(&context);
	    AS(!context);
	    return DONE;
	    }
        rc = ERROR;
        }
    else rc = SUCCESS;

    dd[Ddesc.dsc$w_length-1] = '\0';
    for (p = "; "; *p != '\0'; p++) {
        if ((fuckdec = index(dd, *p)) != 0) {
            *fuckdec = '\0';
            break;
            }
        }

    return rc;
}

#endif VMS


/* This program cleans all the drawing directories of all the old pre 1.3
compiler page expansion, page list and schema files. These files were all
created by the old(pre 1.3) page  compiler. The 1.3 compiler puts all these
files in an associated shadow directory and hence does not require any the old
files. The main program takes the names of scald directories or master 
libraries or libraries in the command line arguments.                       */


static int exit_status = SUCCESS_EXIT;


main (argc, argv)
int argc;
char *argv[];
{
    void process();
    int i;

    if (argc == 1) { /* no arguments;  */
	fprintf(stderr,
	     "No scald directory specified \n");
    }
    else {
	Sinit_pre_output_files();
	for (i = 1; i < argc; i++) {
#ifdef UNIX
	    process(argv[i]);
#endif
#ifdef VMS
            int rc;
	    char fname[STRING_BUF_SIZE+1];
	    if (rc = vms_file_arg_init(fname, argv[i])) do {
		if (rc == ERROR)
		    fprintf(stderr, " Can't open file %s\n", fname);
		else process(fname);
	    } while (rc = vms_file_arg_next(fname));
#endif VMS
	}
    }
    exit(exit_status);
}


void
process(name)
char *name;
{
    int i = 0;
    int j = 0;
    int error = 0;
    int which;

    static char buffer[MAX_LINE_LENGTH];

    char *s = buffer;
    char *index();
    char *d, *get_substr_from_line(), *upshift();
    char *p, *q, *r;
    FILE *fp, *fopen();
    void add_error_processing();
    void dir_or_lib_used_in_deletion();
    void delete_scald_files();
    void delete_lib_files();
    void print_error();

    if ((fp = fopen(name, "r")) == NULL) {
	fprintf(stderr, "cannot open %s\n", name);
	exit_status = ERROR_EXIT;
    } 
    else {
        fprintf(stderr, "Processing %s\n", name);
	while (!getline(fp,s));
	if (p = index(s,'=')) {
	    r = get_substr_from_line(s,p);
	    if (!strcmp(upshift(r) , "FILE_TYPE")) {
		if (q = index(s, ';')) {
		    d = upshift(get_substr_from_line( p, q));
		    if (strlen(d) > 4 && !strcmp(d + strlen(d) - 4, "_DIR")) {
			dir_or_lib_used_in_deletion(name, S_SCALDDIR);
		    }
		    else  if (!strcmp(d,"MASTER_LIBRARY"))  {
			if (s_usedir(name, S_MASTERLIB, NULL, NULL, NULL)) 
			    delete_lib_files();
			else add_error_processing();
		    }
		    else  {
			fprintf(stderr, "%s",str_or_null(s));
			for(j=(index(p,*d)-s)+1;(--j);fprintf(stderr, " "));
			fprintf(stderr, "^ \n");
			print_error(S_FILE_TYPE);
		    }
		}
		else {
		    fprintf(stderr, "%s",str_or_null(s));
		    d = get_substr_from_line( p, (s+strlen(s)));
		    for(j=((index(p,*d))-s)+strlen(d);
		    (--j);fprintf(stderr, " "));
		    fprintf(stderr, "^ \n");
		    print_error(S_EXP_SEMI);
		} 
	    } 
	    else {
		fprintf(stderr, "%s",str_or_null(s));
		fprintf(stderr, "^\n");
		print_error(S_NO_FILETYPE);
	    }
	}
	else {
	    fprintf(stderr, "%s",str_or_null(s));
	    print_error(S_EXP_EQ);
	}
	fclose(fp);
    }
}


void
dir_or_lib_used_in_deletion(directory, which)
char *directory;
int which;
{
   int j = 0;
   char *file, *line;
   int  line_number, column;

   if (s_usedir(directory, which, NULL, NULL, NULL)) {
#ifdef DEBUG
       fprintf(stderr, " its scald \n");
#endif DEBUG
       s_consider_type(s_directory_type(directory, which));
       delete_scald_files(directory, which, OLDSCHEMA);
       delete_scald_files(directory, which, OLDLINKLST);
       delete_scald_files(directory, which, OLDPAGEEXP);
       delete_scald_files(directory, which, OLDPAGELST);
       delete_scald_files(directory, which, C1_1_6EXP);
       delete_scald_files(directory, which, C1_1_6LST);
       delete_scald_files(directory, which, C1_1_6LLI);
       s_deldir(directory, which);  
   } else if (which == S_SCALDDIR) add_error_processing(); 
}


void
delete_scald_files(directory, which, file_type)
char *file_type, *directory;
int which;
{
    char *s_file_name();
    int i = 0;
    int j = 0;
    char *drawing, *other, *workspace;
    char *filename;
    char *file, *line;
    int  line_number, column;
#ifdef DEBUG
       fprintf(stderr, "IN delete_scald_files \n");
       fprintf(stderr, "%s, %d, %s\n", str_or_null(directory),
		 which, str_or_null(file_type));
#endif DEBUG
        for (i = s_filesinit(directory, which, file_type, NULL,
			     &drawing, &other, &workspace); 
	     (i != S_ITR_DONE); 
	     i = s_files(&drawing, &other, &workspace))  {
	      if (i != S_ITR_ERROR) {
	          filename = s_file_name(directory, which, file_type, drawing,
				    other, (S_NOCREATE | S_FULLSEARCH));
	      if (DELETE_FILE(filename)) 
		    fprintf(stderr, "Failed to delete %s \n", filename);
              }                        
		else add_error_processing();
        }
#ifdef DEBUG
       fprintf(stderr, "out of delete_scald_files \n");
#endif DEBUG
}


void
delete_lib_files()
{
    int i = 0;
    int j = 0;
    char *lib_name, *workspace;
    char *file, *line;
    int  line_number, column;
        for (i = s_libsinit(&lib_name, &workspace); 
	     i != S_ITR_DONE; 
	     i = s_libs(&lib_name, &workspace))  {
	        if (i != S_ITR_ERROR) {
		    dir_or_lib_used_in_deletion(lib_name, S_LIBRARY);
                }
        }
#ifdef DEBUG
       fprintf(stderr,"out of delete_lib_files");
#endif DEBUG
}



int
getline(fp,s)
char *s;
FILE *fp;
{
    int i = 0;
    int flag = 0;
    char c;


    while (((c = getc(fp)) != EOF) && (c != '\n') && (i++ != MAX_LINE_LENGTH)) 
	    {
		*s++ = c;
		if (isspace(c) || (c = EOF)) flag = 1;
            }
    if (c == '\n') *s++ = c;
    *s = '\0';
    if (!flag) return(flag);
    else return(++i);
}


char *
get_substr_from_line(lowerlimit, upperlimit)  
char *lowerlimit, *upperlimit ;
{
    static char buffer[MAX_LINE_LENGTH];
    char *p = buffer;
    char *q ;

	   for (q = lowerlimit; ((q  < upperlimit)  && *q)  ; *q++)
	        if ((*q != ' ') && (*q != '=') && (*q != ';'))  *p++ = *q;

           *p = '\0';
	   return(buffer);
}

char *
upshift(str)
char *str;
{
    char *p, *q;
    p = (char *)malloc(strlen(str) + 1);
    q = p;
    for ( ; *str; str++) {
	if (islower(*str)) *q++ = toupper(*str);
	else *q++ = *str;
    }
    *q = '\0';
    return(p);
}

void
print_error(error_number)
int error_number;
{
    switch(error_number) {  
    case S_NO_ERROR:	    
	 break;
    case S_ILLEGAL_SCALD:    
	 fprintf(stderr, " Illegal SCALD name -- can't calculate the file name \n");
	 break;
    case S_CALC_FNAME:	       
         fprintf(stderr, "Trouble with filename calculations\n");
	 break;
    case S_SDIR_NOTFOUND:       
	 fprintf(stderr, "Specified SCALD directory not found\n");
	 break;
    case S_NO_OPEN:	       
	 fprintf(stderr, "could not open file\n");
	 break;
    case S_NULL_PARAM:	       
	 fprintf(stderr, "Unexpected NULL parameter\n");
	 break;
    case S_ASSERT:	       
	 fprintf(stderr, "Assertion check failure\n");
	 break;
    case S_LIB_NOTFOUND:	    	
	 fprintf(stderr, "Specified library not found\n");
	 break;
    case S_EXP_SEMI:
	 fprintf(stderr, "Expected ;\n");
	 break;
    case S_EXP_EQ:
	 fprintf(stderr, "Missing =\n");
	 break;
    case S_FILE_TYPE:	
	 fprintf(stderr, "Not the expected file type\n");
	 break;
    case S_NO_FILETYPE:
	 fprintf(stderr, "File does not begin with FILE_TYPE = \n");
	 break;
    case S_UNKNOWN_SY:
	 fprintf(stderr, "Unknown symbol in file\n");
	 break;
    case S_COLLISION:
         fprintf(stderr, "Collision in SCALD directory(multiple entries)\n");
	 break;
    case S_EXP_END:
	 fprintf(stderr, "Expected END.\n");
	 break;
    case S_EXP_EOF:
	 fprintf(stderr, "Expected end of file\n");
	 break;
    case S_ILL_DWGDIR:
	 fprintf(stderr, "Illegal drawing directory\n");
	 break;
    default:
	 fprintf(stderr, "Undefined error\n");
	 break;
    }
}

void
add_error_processing()
{
    char *file, *line;
    int i,j = 0;
    int line_number, column;
    j = s_error(&file, &line, &line_number, &column);
    print_error(j);
    if (line) {
        fprintf(stderr, "%s \n", line);
        for (i=1;i<=column;fprintf(stderr, " "),i++);
        fprintf(stderr, "^ \n");
	fprintf(stderr, "In file %s on line number %d \n", 
		    file, line_number);
    } else if (file) fprintf(stderr, "File name: %s \n", file);


#ifdef DEBUG
    fprintf(stderr, "%s , %s, %d, %d, %d  \n", str_or_null(file),
            str_or_null(line), line_number, column, j);
#endif DEBUG
}


