

{ The inorder iterator maintains a stack for each tree being iterated.
  avls are used because they are already part of the package.  The
  stack is threaded though the left_child field.  The tree member
  refered to by the stack entry is indicated by the right_child field. }


procedure avl_push(item: avl_ptr; var stack: avl_ptr);
  var
    stack_item: avl_ptr;
begin
  new_avl(stack_item, AVL_FIRST);
  stack_item^.right_child := item;
  stack_item^.left_child := stack;
  stack :=stack_item;
end { avl_push } ;


procedure avl_pop(var stack: avl_ptr);
  var
   item: avl_ptr;
begin
  item := stack;
  stack := stack^.left_child;
  release_avl(item);
end { avl_pop } ;

  
function avl_inorder_init(root: avl_ptr; var stack: avl_ptr): avl_ptr;
  var
    item: avl_ptr;
begin
  stack := NIL;
  item := root;
  while item <> NIL do
    begin
      avl_push(item, stack);
      item := item^.left_child;
    end;
  if stack <> NIL then item := stack^.right_child;
  avl_inorder_init := item;
end { avl_inorder_init } ;


function avl_inorder(var stack: avl_ptr): avl_ptr;
  var
    item: avl_ptr;
begin
  if stack = NIL then item := NIL
  else
    begin
      item := stack^.right_child;
      avl_pop(stack);
      item := item^.right_child;
      while item <> NIL do
        begin
	  avl_push(item, stack);
	  item := item^.left_child;
	end;
      if stack <> NIL then item := stack^.right_child;
    end;
  avl_inorder := item;
end { avl_inorder } ;
