procedure dump_avl_object(var f: textfile;
                          obj: avl_object_ptr; kind: avl_type);
  { report the key of the object }
begin
  case kind of
    AVL_INVOKE:
      if obj.invoke = NIL then writeln(f, '<NIL>')
      else
        begin
          writestring(f, obj.invoke^.path);
	  write(f, ' ');
	  writestring(f, obj.invoke^.macro_name);
          writeln(f);
        end;
    OTHERWISE writeln(f, '***  UNKOWN AVL TYPE  ***');
  end;
end { dump_avl_object } ;


procedure dump_avl_tree(var f: textfile; root: avl_ptr; kind: avl_type);
  { dump the tree inorder (including level and balance factor) to f }
  var
    level: natural_number;    { current height of the tree }


  procedure dump_avl_node(node: avl_ptr);
    { dump the node }
  begin
    if node <> NIL then
      begin
        level := level + 1;
        dump_avl_node(node^.left_child);

        write(outfile, '  ', level:2, ' ');
        case node^.balance_factor of
          LEFT_HEAVY_BF: write(f, 'LH');
          EVEN_BF: write(f, 'EV');
          RIGHT_HEAVY_BF: write(f, 'RH');
        end;
        write(f, ' ');
	dump_avl_object(f, node^.object, kind);

      dump_avl_node(node^.right_child);
      level := level - 1;
    end;
          
  end { dump_avl_node } ;


begin
  level := 0;
  writeln(f, '----  AVL tree (', ord(kind):1, ') ----');
  dump_avl_node(root);
  writeln(f, '---- end of tree ----');
end { dump_avl_tree } ;
