#include <stream.h>
#include "heap.h"
#include "stringt.h"


static gavlroot(str,string_entry,charP) string_table;
static heap string_heap;


// For tables keyed by string, we can just do pointer subtraction to order
// them.  This is faster than strcmp (but does not result in alphabetical order).
#define string_compare(a,b) (a.ptr_cmp(b))
gavlkey_search(string, string_compare);


string_entry::string_entry(const char* c)
{
    if (!c) fault("Attempt to create NULL string entry");
    if (this) fault("this exists in string_entry::string_entry()");
    this = (string_entry *)string_heap.mem(sizeof(*this));
    str = (char*)string_heap.mem(strlen(c) + 1);
    strcpy(str, c);
    if (this != string_table.insert(this)) fault("String table");
#if COUNT_STRING_REFS
    references = 1;
#endif
}


/*
    The type-cast (char*)c in the following procedure is a hack that is
    necessary because the find function is not defined to take a constant
    argument, as it should.  Such declaration is made difficult by the
    fact that const charP != const char*.
*/
string::string(const char* c)
{
    if (!c) s = 0;
    else {
	if (!(s = string_table.find((char*)c))) s = new string_entry(c);
#if COUNT_STRING_REFS
        else s->references++;
#endif
    }
}


void string::dump(ostream& strm)
{
    gavlinorder(str,string_entry,charP) itr(string_table);
    string_entry *s;
    while (s = itr()) strm << (char*)(s->str) << "\n";
}


string_entry::~string_entry()
{
#if COUNT_STRING_REFS
    string_table.pick(this);
    string_heap.memfree((char*)(str), strlen(str)+1);
    string_heap.memfree(this, sizeof(*this));
    this = 0;
#else
    fault("~string_entry() called on non-reference-counting table");
#endif
}


#if COUNT_STRING_REFS
const string& string::operator=(const string& st)
{
    if (st.s) st.s->references++; // MUST occur before --s->references (a = a)
    if (s && !(--s->references)) delete s;
    s = st.s;
    return *this;
}
#endif
