#ifndef GITERATOR_H
#define GITERATOR_H 1
#include "basictypes.h"
#define GITERATOR(member,classtype) name3(_itr_,classtype,member)
#define GWALK(iterator,lvalue) \
    for ((lvalue)=(iterator)();(lvalue);(lvalue)=(iterator)())

// abstract base class for collections -- exists just so we can exress a reference
// to it
class collection_base {
};


/* The following defines the functions which should be implemented for the iterator
   for any generic collection.  At a minimum, the constructor, init() and next().
   operator()() should also be implemented to type-cast the result and/or to
   implement the iteration entirely inline.  Since the collections themselves
   are made so that their member functions are entirely staticly bound, the
   iterator functions are also staticly bound -- thus the following is little
   more than a template.
*/


class iterator_base {
    collection_base* col;
protected:
    const collection_base& collection() { return *col; }
public:
    iterator_base(const collection_base& c) { col = &c; }
    void init() {}
	// reset state to initial value -- derived class responsibility
    void* operator()() { return 0; } 
	// return the next collection member -- derived class responsibility
};

#endif
