#ifndef	SHAREDQUEUEH
#define	SHAREDQUEUEH

/* SharedQueue.hxx -- declarations for shared queues

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Arrayobid.hxx"
#include "Semaphore.hxx"

extern Class class_SharedQueue;

class SharedQueue : public Object {
	Arrayobid queue;
	int readPosition,writePosition;
	Semaphore valueAvailable;
	Semaphore spaceAvailable;
public:
	SharedQueue(UNSIGNED queueSize =CLTN_DEFAULT_CAPACITY);
	SharedQueue(fileDescTy&,SharedQueue&);
	SharedQueue(istream&,SharedQueue&);
	bool isFull()	{ return spaceAvailable.value() == 0; }
	virtual UNSIGNED capacity();
	virtual void deepenShallowCopy();
	virtual const Class* isA();
	virtual bool isEmpty();
	virtual obid next();
	virtual obid nextPut(const Object&);
	virtual void printOn(ostream& strm);
	virtual obid shallowCopy();		// shouldNotImplement
	virtual UNSIGNED size();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
