#ifndef SEMAPHOREH
#define SEMAPHOREH 

/* Semaphore.hxx -- declarations for Semaphore

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"
#include "LinkedList.hxx"

extern Class class_Semaphore;

class Semaphore: public Object {
	LinkedList waitList;
	short count;
public:
	Semaphore(int initialCount =0)	{ count = initialCount; }
	~Semaphore();
	Semaphore(fileDescTy&,Semaphore&);
	Semaphore(istream&,Semaphore&);
	virtual void deepenShallowCopy();
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object& ob);
	virtual void printOn(ostream& strm);
	virtual obid shallowCopy();	// shouldNotImplement
	virtual void signal();		// signal waiting process 
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	virtual int value();		// read semaphore value 
	virtual void wait();		// wait on semaphore 
};

#endif
