#ifndef	SCHEDULERH
#define	SCHEDULERH

/* Scheduler.hxx -- declarations for the Process Scheduler

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "LinkedList.hxx"

extern Class class_Scheduler;

class Process;

class Scheduler : public Object {
	Process* active_process;
	Process* previous_process;	// ACCESSED BY MACHINE-DEPENDENT CODE! 
	UNSIGNED runCount;		// total # of runnable processes 
	LinkedList runList[MAXPRIORITY+1];
	friend Process;
	friend void init_main_process(const Class&);
public:
	Scheduler();
	Scheduler(fileDescTy&,Scheduler&) {}
	Scheduler(istream&,Scheduler&) {}
	virtual UNSIGNED capacity();
	virtual obid copy();			// shouldNotImplement
	virtual void deepenShallowCopy();	// shouldNotImplement
	virtual const Class* isA();
	virtual void printOn(ostream& strm);
	virtual obid shallowCopy();		// shouldNotImplement
	virtual UNSIGNED size();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	friend unsigned char activePriority();
	friend Process& activeProcess();
	friend void schedule();
	friend void terminateActive();
	friend void yield();
};

extern Scheduler scheduler;

inline unsigned char activePriority()	{ return scheduler.active_process->priority(); }
inline Process& activeProcess()		{ return *scheduler.active_process; }
inline void terminateActive()		{ activeProcess().terminate(); }

#endif
