/* Scheduler.c -- implementation of the Process Scheduler

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	December, 1985

Function:

Class Scheduler provides an interface to the single instance of the
process scheduler, scheduler.

Modification History:

16-Aug-88	rm

1.  osfcn.hxx mode local for BSD

16-Jul-86	K. E. Gorlen

1. Replace reference to prior_AST_state with call to AST_SAVE.

29-Apr-86	K. E. Gorlen

1.  Implement shallowCopy() as shouldNotImplement.

14-Apr-86	K. E. Gorlen

1.  Remove MASSCOMP conditional compilations.
2.  Save/restore AST priority/signal mask in Process context to
    support UCB42BSD -style signals.

12-Apr-86	K. E. Gorlen

1.  Initialize main process via initor2 function.

10-Apr-86	K. E. Gorlen

1.  Disable AST BEFORE checking runCount and re-enable
with astpause().

9-Apr-86	K. E. Gorlen

1.  Call astpause() instead of pause() on MASSCOMP.
	
5-Mar-86	K. E. Gorlen

1.  Define copy() as shouldNotImplement.

28-Feb-86	K. E. Gorlen

1.  Add calls to Process::save() and Process::restore().

*/

#include "Process.hxx"
#include "Scheduler.hxx"
#include "osfcn.hxx"

#define	THIS	Scheduler
#define	BASE	Object
DEFINE_CLASS(Scheduler,Object,1,NULL,init_main_process);

extern const int OOPS_SCHEDCTOR,OOPS_ILLEGALFCN;

Scheduler scheduler; 	// the sole instance of the Scheduler object 

int ast_level =0;	// AST nesting level 

static void init_main_process(const Class&)
{
	scheduler.active_process = new Process(0);	// create MAIN process 
	scheduler.active_process->resume();		// run MAIN process 
}

Scheduler::Scheduler()
{
	if (this != &scheduler) setOOPSerror(OOPS_SCHEDCTOR,DEFAULT,this,className());
	previous_process = 0;
	runCount = 0;
}

void schedule()
{
	scheduler.active_process->checkStack();
	if (AST_ACTIVE) return;
	while (YES) {
		AST_DISABLE;
		while (scheduler.runCount>0) {
			for (register int i=MAXPRIORITY; i>=0; i--) {
				if (scheduler.runList[i].size() > 0) {
					Process* next_process = (Process*)scheduler.runList[i].first();
					if (next_process != scheduler.active_process) {
						AST_SAVE(scheduler.active_process->saved_AST_state);
						scheduler.active_process->save();
						scheduler.previous_process = scheduler.active_process;
						scheduler.active_process = next_process;
						next_process->exchj();
						scheduler.active_process->restore();
						AST_RESTORE(scheduler.active_process->saved_AST_state);
						scheduler.previous_process->checkStack();
					}
					else AST_ENABLE;
					return;
				}
			}
		}
		AST_PAUSE;	// wait for AST/signal
	}
}

void yield()
{
	if (scheduler.runList[activePriority()].size() == 1) schedule();
	else {
		activeProcess().suspend();
		activeProcess().resume();
	}
}

UNSIGNED Scheduler::capacity()	{ return runCount; }

obid Scheduler::copy()
{
	shouldNotImplement("copy");
	return 0;
}

obid Scheduler::shallowCopy()
{
	shouldNotImplement("shallowCopy");
	return 0;
}

void Scheduler::deepenShallowCopy()
{
	shouldNotImplement("deepCopy");
}

UNSIGNED Scheduler::size()	{ return runCount; }
	
void Scheduler::printOn(ostream& strm)
{
	AST_DISABLE;
	strm << className()
		<< "  active process: " << active_process->name()
		<< "  previous process: " << previous_process->name() << "\n";
	for (register i =MAXPRIORITY; i>=0; i--) {
		DO(runList[i],Process*,p) strm << "\t" << *p; OD
	}
	AST_ENABLE;
}

void Scheduler::storer(ostream&)
{
	shouldNotImplement("storeOn");
}

void Scheduler::storer(fileDescTy&) 
{
	shouldNotImplement("storeOn");
}
