/* Random.c -- implementation of pseudo-random number generator

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	December, 1985

Function:
	
A psuedo-random number generator.  The function next() returns random
numbers uniformly distributed over the interval [0.0,1.0].

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

29-Apr-86	K. E. Gorlen

1.  Implement copy() as shallowCopy() and deepenShallowCopy() as {}.

*/

#include "Random.hxx"
#include "oopsconfig.hxx"
#include "oopsIO.hxx"

#define	THIS	Random
#define	BASE	Object
DEFINE_CLASS(Random,Object,1,NULL,NULL);

Random::Random()	{ time(&randx); randx ^= (long)this; }

float Random::next()
{
	register float temp;
	do temp = DRAW(randx)/(float)MAX_INT; while (temp==0);
	return temp;
}

obid Random::copy()		{ return shallowCopy(); }

void Random::deepenShallowCopy()	{}

void Random::printOn(ostream& strm)
{
	strm << randx;
}

Random::Random(istream& strm, Random& where)
{
	this = &where;
	strm >> randx;
}

void Random::storer(ostream& strm)
{
	BASE::storer(strm);
	strm << randx << " ";
}

Random::Random(fileDescTy& fd, Random& where)
{
	this = &where;
	READ_OBJECT_AS_BINARY(fd);
}

void Random::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	STORE_OBJECT_AS_BINARY(fd);
}
