#ifndef POINT3D_H
#define POINT3D_H

/* Point_3d.hxx -- declarations for X-Y-Z coordinates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

3/15/88		N. B. Cohen

1.	Create 3 dimensional points.

30-Oct-86	K. E. Gorlen

1.  Make member variables protected, define access functions.

*/

#include "Object.hxx"
#include <math.h>

extern Class class_Point_3d;

class Point_3d: public Object {
protected:
	double xc,yc,zc;			// x-y coordinate 
public:
	Point_3d(double newx=0,double newy=0,double newz=0){xc=newx;yc=newy;zc=newz;}
	Point_3d(fileDescTy&,Point_3d&);
	Point_3d(istream&,Point_3d&);
	double	x()			{ return xc; }
	double	x(double newx)		{ return xc = newx; }
	double	y()			{ return yc; }
	double	y(double newy)		{ return yc = newy; }
	double	z()			{ return zc; }
	double	z(double newz)		{ return zc = newz; }
	Point_3d	operator+(Point_3d p)	{ return Point_3d(xc+p.xc, yc+p.yc, zc+p.zc); }
	Point_3d	operator-()		{ return Point_3d(-xc,-yc,-zc);}
	Point_3d 	operator-(Point_3d p)	{ return Point_3d(xc-p.xc, yc-p.yc, zc-p.zc); }
	friend Point_3d operator*(Point_3d p, int i) { return Point_3d(i*p.xc, i*p.yc, i*p.zc); }
	friend Point_3d operator*(int i, Point_3d p) { return Point_3d(i*p.xc, i*p.yc, i*p.zc); }
	double 	operator*(Point_3d p)	{ return xc*p.xc + yc*p.yc + zc*p.zc; }
	bool	operator==(Point_3d p)	{ return (xc==p.xc && yc==p.yc && zc==p.zc); }
	bool	operator!=(Point_3d p)	{ return (xc!=p.xc || yc!=p.yc || zc!=p.zc); }
	bool	operator<(Point_3d p)	{ return (yc<p.yc && xc<p.xc && zc<p.zc); }
	bool	operator<=(Point_3d p)	{ return (yc<=p.yc && xc<=p.xc && zc<=p.zc); }
	bool	operator>(Point_3d p)	{ return (yc>p.yc && xc>p.xc && zc>p.zc); }
	bool	operator>=(Point_3d p)	{ return (yc>=p.yc && xc>=p.xc && zc>=p.zc); }
	void	operator+=(Point_3d p)	{ xc += p.xc; yc += p.yc; zc += p.zc; }
	void	operator-=(Point_3d p)	{ xc -= p.xc; yc -= p.yc; zc -= p.zc; }
	void	operator*=(int s)	{ xc *= s; yc *= s; zc *= s;}
	double	dist(Point_3d&);	// calculate dist to a point
	Point_3d	max(Point_3d);
	Point_3d	min(Point_3d);
// ??	Point_3d	transpose()		{ return Point_3d(yc,xc); }
// ?? 	bool	isBelow(Point_3d p)	{ return zc > p.zc; }
// ??	bool	isAbove(Point_3d p)	{ return zc < p.zc; }
// ??	bool	isLeft(Point_3d p)		{ return xc < p.xc; }
// ??	bool	isRight(Point_3d p)	{ return xc > p.xc; }
	virtual	int compare(const Object&);	// compare Point_3ds 
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);	// equality test 
	virtual void printOn(ostream& strm);
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
