#ifndef LOOKUPKEYH
#define LOOKUPKEYH 

/* LookupKey.hxx -- declarations for Dictionary LookupKey

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_LookupKey;

class LookupKey: public Object {
	obid akey;
public:
	LookupKey(const Object& newKey =*nil);
	LookupKey(fileDescTy&,LookupKey&);
	LookupKey(istream&,LookupKey&);
	virtual int compare(const Object&);
	virtual void deepenShallowCopy();
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual obid key();
	virtual obid key(const Object& newkey);
	virtual void printOn(ostream& strm);
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	virtual obid value();
	virtual obid value(const Object& newvalue);
};

#endif
