#ifndef LINKOBIDH
#define LINKOBIDH 

/* Linkobid.hxx -- declarations for singly-linked list Object element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Link.hxx"

extern Class class_Linkobid;

class Linkobid: public Link {
	obid val;
public:
	Linkobid(const Object& newval =*nil);
	Linkobid(fileDescTy&,Linkobid&);
	Linkobid(istream&,Linkobid&);
	virtual UNSIGNED capacity();
	virtual int compare(const Object&);
	virtual void deepenShallowCopy();
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual UNSIGNED size();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
	virtual obid value();
	virtual obid value(const Object& newval);
};

#endif
