#ifndef LINKEDLISTH
#define LINKEDLISTH

/* LinkedList.hxx -- declarations for singly-linked list

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "SeqCltn.hxx"
#include "Link.hxx"

extern Class class_LinkedList;

class LinkedList : public SeqCltn {
	Link* firstLink;	// pointer to first Link of list 
	Link* lastLink;		// pointer to last Link of list 
	UNSIGNED count;		// count of items on list 
	void errDblLnk(const char* fn, const Link& lnk);
	void errEmpty(const char* fn);
	void errNotFound(const char* fn, const Object& ob);
	void IndexRangeErr();
public:
	LinkedList();
	LinkedList(fileDescTy&,LinkedList&);
	LinkedList(istream&,LinkedList&);
	bool operator!=(const LinkedList& a)	{ return !(*this==a); }
	bool operator==(const LinkedList&);
	virtual obid add(const Object&);
	virtual Collection& addContentsTo(Collection& cltn);
	virtual obid addFirst(const Object& ob);
	virtual obid addLast(const Object& ob);
	virtual obid& at(int i);
	virtual void atAllPut(const Object& ob);	// should not implement 
	virtual void deepenShallowCopy();
	virtual obid doNext(DoCltnPos&);
	virtual obid first();
	virtual UNSIGNED hash();
 	virtual int indexOf(const Object& ob);
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0);	// shouldNotImplement 
	virtual const Class* isA();
	virtual bool isEmpty();
	virtual bool isEqual(const Object&);
	virtual obid last();
	virtual UNSIGNED occurrencesOf(const Object&);
	virtual void printOn(ostream& strm);
	virtual obid remove(const Object&);
	virtual obid removeFirst();
	virtual obid removeLast();
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);	// shouldNotImplement 
	virtual void reSize(UNSIGNED newSize);
	virtual UNSIGNED size();
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
