#ifndef FRACTIONH
#define FRACTIONH 

/* Fraction.hxx -- declarations for fractions

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_Fraction;

class Fraction: public Object {
	int n,d;
	Fraction(int num, int den, int dum) {
		n = (dum,num); d = den;
	}
	void parseFraction(istream&);
	void reduce();
public:
	Fraction(int num =0, int den =1);
	Fraction(double);
	Fraction(istream&);
	Fraction(fileDescTy&,Fraction&);
	Fraction(istream&,Fraction&);
	operator double()		{ return (double)n/d; }
	int denominator()		{ return d; }
	int numerator()			{ return n; }
	
	friend Fraction	operator+(Fraction, Fraction);
	friend Fraction	operator-(Fraction u)			{ return Fraction(-u.n,u.d); }
	friend Fraction operator-(Fraction, Fraction);
	friend Fraction operator*(Fraction, Fraction);
	friend Fraction operator/(Fraction, Fraction);
	friend bool	operator<(Fraction u, Fraction v);
	friend bool	operator>(Fraction u, Fraction v)	{ return v<u; }
	friend bool	operator<=(Fraction u, Fraction v);
	friend bool	operator>=(Fraction u, Fraction v)	{ return v<=u; }
	friend bool	operator==(Fraction u, Fraction v)	{ return u.n == v.n && u.d == v.d; }
	friend bool	operator!=(Fraction u, Fraction v)	{ return !(u==v); }
	
	void operator+=(Fraction u)	{ *this = *this + u; }
	void operator-=(Fraction u)	{ *this = *this - u; }
	void operator*=(Fraction u)	{ *this = *this * u; }
	void operator/=(Fraction u)	{ *this = *this / u; }
	
	bool between(const Fraction& min, const Fraction& max);
	Fraction max(const Fraction&);
	Fraction min(const Fraction&);
	
	virtual int compare(const Object&);
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED hash();
	virtual const Class* isA();
	virtual bool isEqual(const Object&);
	virtual void printOn(ostream& strm);
	virtual void scanFrom(istream& strm);
	virtual const Class* species();
	virtual void storer(fileDescTy&);
	virtual void storer(ostream&);
};

#endif
