/* Float.c -- implementation of Float object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: {decvax!}seismo!elsie!cecil!keith
	December, 1985

Function:
	
Provides an object that contains a double.

Modification History:

06-Oct-86	S. M. Orlow

1.  Added binary I/O constructor, storer, and reader functions

1-Oct-86	K. E. Gorlen

1. C++ Release 1.1: restore use of default argument in constructor.

29-Apr-86	K. E. Gorlen

1.  Implement copy() as shallowCopy() and deepenShallowCopy() as {}.

24-Mar-86	S. M. Orlow

1.  Initialized constructors replaced to work around C++ bug.
	
7-Jan-86	K. E. Gorlen

1.  Add Float::species().

2.  Modify Float::isEqual to use species().
*/

#include "Float.hxx"
#include "oopsIO.hxx"

#define	THIS	Float
#define	BASE	Object
DEFINE_CLASS(Float,Object,1,NULL,NULL);

Float::Float(istream& strm)	{ parseFloat(strm); }

int Float::compare(const Object& ob)
{
	assertArgSpecies(ob,class_Float,"compare");
	register double t = val-((Float*)&ob)->val;
	if (t < 0) return -1;
	if (t > 0) return 1;
	return 0;
}

obid Float::copy()		{ return shallowCopy(); }

void Float::deepenShallowCopy()	{}

static union {
	UNSIGNED asint[2];
	double asdouble;
} hun;

UNSIGNED Float::hash()
{
	hun.asdouble = val;
	return hun.asint[0] ^ hun.asint[1];
}

bool Float::isEqual(const Object& ob)
{
	return ob.isSpecies(class_Float) && val==((Float*)&ob)->val;
}

const Class* Float::species()	{ return &class_Float; }

void Float::printOn(ostream& strm)
{
	strm << val;
}

void Float::scanFrom(istream& strm)	{ parseFloat(strm); }

Float::Float(istream& strm, Float& where)
{
	this = &where;
	strm >> val;
}

void Float::storer(ostream& strm)
{
	BASE::storer(strm);
	strm << val << " ";
}

Float::Float(fileDescTy& fd, Float& where)
{
	this = &where;
	READ_OBJECT_AS_BINARY(fd);
}

void Float::storer(fileDescTy& fd) 
{
	BASE::storer(fd);
	STORE_OBJECT_AS_BINARY(fd);
}
