#ifndef	BITBOARDH
#define	BITBOARDH

/* BitBoard.hxx -- Declarations for class BitBoard

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

*/

#include "Object.hxx"

extern Class class_BitBoard;

class BitBoard: public Object {
	union {
		unsigned long m[2];
		unsigned char c[8];
	};
public:
	BitBoard()			{}
	BitBoard(UNSIGNED i);
	BitBoard(unsigned long i, unsigned long j) { m[0] = i;  m[1] = j; }
	BitBoard(fileDescTy&,BitBoard&);
	BitBoard(istream&,BitBoard&);
	BitBoard operator~()		{ return BitBoard(~m[0], ~m[1]); }
	BitBoard operator-(BitBoard n)	{ return BitBoard(m[0]&~n.m[0], m[1]&~n.m[1]); }
	bool operator>(BitBoard n)	{ return m[0] == (m[0]|n.m[0])
						&& m[0] != n.m[0]
						&& m[1] == (m[1]|n.m[1])
						&& m[1] != n.m[1]; }
	bool operator<(BitBoard n)	{ return n > *this; }
	bool operator>=(BitBoard n)	{ return m[0] == (m[0]|n.m[0])
						&& m[1] == (m[1]|n.m[1]); }
	bool operator<=(BitBoard n)	{ return n >= *this; }
	bool operator==(BitBoard n)	{ return m[0] == n.m[0] && m[1] == n.m[1]; }
	bool operator!=(BitBoard n)	{ return m[0] != n.m[0] || m[1] != n.m[1]; }
	BitBoard operator|(BitBoard n)	{ return BitBoard(m[0]|n.m[0], m[1]|n.m[1]); }
	BitBoard operator&(BitBoard n)	{ return BitBoard(m[0]&n.m[0], m[1]&n.m[1]); }
	BitBoard operator^(BitBoard n)	{ return BitBoard(m[0]^n.m[0], m[1]^n.m[1]); }
 	void operator-=(BitBoard n)	{ m[0] &= ~n.m[0]; m[1] &= ~n.m[1]; }
	void operator&=(BitBoard n)	{ m[0] &= n.m[0]; m[1] &= n.m[1]; }
	void operator^=(BitBoard n)	{ m[0] ^= n.m[0]; m[1] ^= n.m[1]; }
	void operator|=(BitBoard n)	{ m[0] |= n.m[0]; m[1] |= n.m[1]; }
	unsigned count();
	bool	includes(UNSIGNED i);
	virtual UNSIGNED	capacity();
	virtual obid	copy();			// { return shallowCopy(); }
	virtual void	deepenShallowCopy();	// {}
	virtual UNSIGNED	hash();
	virtual const Class*	isA();
	virtual bool	isEmpty();
	virtual bool	isEqual(const Object&);
	virtual void	printOn(ostream& s);
	virtual UNSIGNED	size();
	virtual const Class*	species();
	virtual void storer(fileDescTy&);
	virtual void	storer(ostream&);
};

extern BitBoard squareBitBoard[64];
extern BitBoard rankBitBoard[8];
extern BitBoard fileBitBoard[8];
extern unsigned char bit_count[256];

inline BitBoard::BitBoard(UNSIGNED i)	{ *this = squareBitBoard[i]; }
	
inline unsigned BitBoard::count()
{
	register unsigned char* p = c;
	register unsigned n = 0;
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	n += bit_count[*p++];
	return n;
}

inline bool BitBoard::includes(UNSIGNED i)
{
	return (m[0] & squareBitBoard[i].m[0]) || (m[1] & squareBitBoard[i].m[1]);
}

#endif
