#ifndef BH_GROWINGBUF_H
#define BH_GROWINGBUF_H 1
#include "basictypes.h"
#include "heap.h"


/* A buffer that grows when it overflows. */


class GrowingBuf {
    char* buf;
    char* end;
    char* pos;
    heap* h;
    char allocated;
    void grow(unsigned minimum);
public:
    ~GrowingBuf();
    GrowingBuf(heap&);
	// heap is used to allocate internal buffer and the object itself (if needed)
    GrowingBuf();
	// allocated using new

    GrowingBuf& operator<<(char*);
    GrowingBuf& operator<<(long);
    GrowingBuf& put(char c) 
	{ if (pos>=end) grow(1);  *pos++ = c;  return *this; }

    void uppercase();
    void lowercase();

    void clear() { pos = buf; }
    void backchar() { if (pos>buf) pos--; }

    operator char*() { *pos = 0;  return buf; }
        // Permits any alteration of the string that does not increase its length.
        // (shortening is ok).
};
#endif
