/*--------------------------------------------------------------------------*/
/* Function prototypes for Ryle Design's excellent PCHRT High Resolution	*/
/* Timer package conditionally used for instrumentation.					*/
/*																			*/
/*		Ryle Design															*/
/*		P.O. Box 22															*/
/*		Mt. Pleasant, MI  48804												*/
/*		(517) 773-0587														*/
/*--------------------------------------------------------------------------*/

void t_entry   (int TimerNum);				/* Start specified timer		*/
void t_exit    (int TimerNum);				/* Stop specified timer			*/
void t_name    (int TimerNum, char *Name);	/* Associate name with timer    */
											/* for report					*/
void t_report  (int Destination);			/* Produce report of timer      */
											/* activity						*/
void t_resume  (int TimerNum);				/* Resume a suspended timer		*/
int  t_start   (void);						/* Initialize PCHRT functions	*/
void t_stop    (void);						/* Shut down PCHRT functions	*/
void t_suspend (int TimerNum);				/* Suspend an active timer		*/