program A2Z;

uses DOS, CRT;

{
  ARC/PAK to ZIP converter

  Calling specification:
    A2Z [/C] filespec [/S]
}

{
  Feel free to use this code in any application/environment.  I would
  appreciate a mention in your doc file if it's used in anything that
  you distribute.  I apologise for the uncommented nature; I never
  wrote it with intent to distribute the source.
}

{
  Ian McLean                      Voice:  404 428 7829
  3365 Timber Lake Road
  Kennesaw, GA
  30144
}

const
  DataNext:             string[5]= 'CFCF!';
  PKZIP:                DirStr= {'U:\PKZIP.EXE';  } 'UNCONFIGURED';
  PKUNPAK:              DirStr= {'U:\PKXARC.EXE'; } 'UNCONFIGURED';
  PAK:                  DirStr= {'U:\PAK.EXE';    } 'UNCONFIGURED';
  AsciiLvl:             char='4';
  BinLvl:               char='4';  {206 bytes}

var
  ConvSpec:             PathStr;
  OldExitProc:          pointer;
  ConvBelow:            boolean;
  FilesToConv:          longint;
  BytesToConv:          longint;
  ConvDir:              DirStr;
  ConvName:             NameStr;
  ConvExt:              ExtStr;
  Search:               boolean;
  Saved:                longint;
  FNum:                 longint;

procedure HaltWithMsg(M: string);
begin
  WriteLn(M);
  Halt;
end;

function FileFound(S: ComStr): boolean;
var
  SRec:                 SearchRec;
begin
  SRec.Name := '*';
  FindFirst(S,0,SRec);
  FileFound := (SRec.Name<>'*');
end;

procedure DisplayProgHeader;
begin
  WriteLn;
  WriteLn('A2Z - ARC/PAK to ZIP converter');
  WriteLn('by Ian McLean');
  WriteLn('version 1.3, Feb 11 1989');
end;

procedure Configure;
var
  A:                    file of byte;
  L:                    longint;
  MatchUp:              byte;
  C:                    char;
begin
  if not FileFound('A2Z.EXE') then
    HaltWithMsg('A2Z.EXE must be in the current directory when invoking configuration.');
  DisplayProgHeader;
  repeat
    WriteLn;
    WriteLn('Enter the name and path for PKZIP.  Please include a drive letter, path,');
    WriteLn('and extention:');
    ReadLn(PKZIP);
  until FileFound(PKZIP);
  repeat
    WriteLn;
    WriteLn('Enter the name and path for PKUNPAK.  Please include a drive letter, path,');
    WriteLn('and extention:');
    ReadLn(PKUNPAK);
  until FileFound(PKUNPAK);
  repeat
    WriteLn;
    WriteLn('Enter the name and path for PAK.  Please include a driver letter, path name,');
    WriteLn('and extention:');
    ReadLn(PAK);
  until FileFound(PAK);
  WriteLn;
  Write('Compression level for binary files: ');
  repeat
    repeat until KeyPressed;
    BinLvl := ReadKey;
  until BinLvl in ['1'..'4'];
  WriteLn(BinLvl);
  Write('Compression level for ASCII files:  ');
  repeat
    repeat until KeyPressed;
    AsciiLvl := ReadKey;
  until AsciiLvl in ['1'..'4'];
  WriteLn(AsciiLvl);
  WriteLn;
  Assign(A, 'A2Z.EXE');
  Reset(A);
  L := FileSize(A)-1;
  MatchUp := 5;
  repeat
    Seek(A, L);
    Read(A, byte(C));
    Dec(L);
    case MatchUp of
      5:   if C=DataNext[MatchUp] then Dec(MatchUp);
      else if C=DataNext[MatchUp] then Dec(MatchUp) else MatchUp := 5;
    end;
  until (MatchUp=0) or (L=0);
  if MatchUp<>0 then
    HaltWithMsg('Unable to find configuration data area.  Corrupted A2Z.EXE!');
  Seek(A, L+6);
  for L := 0 to 203 do Write(A, Mem[seg(PKZIP):ofs(PKZIP)+L]);
  Close(A);
end;

procedure DeleteFile(N: PathStr);
var
  F:                    file;
begin
  Assign(F, N);
  Erase(F);
end;

procedure DeleteDirectory(N: PathStr);
var
  SRec:                 SearchRec;
begin
  SRec.Name := '*';
  FindFirst(N+'\*.*',0,SRec);
  if SRec.Name<>'*' then
  begin
    DeleteFile(N+'\'+SRec.Name);
    repeat
      SRec.Name := '*';
      FindNext(SRec);
      if SRec.Name<>'*' then DeleteFile(N+'\'+SRec.Name);
    until SRec.Name='*';
  end;
end;

procedure NewExitProc;
begin
  DeleteDirectory('A2ZTEMP!.@#$');
  {$I-}
  RmDir('A2ZTEMP!.@#$');
  {$I+}
  if IOResult<>0 then WriteLn('Unable to remove temporary directory.');
  ExitProc := OldExitProc;
end;

procedure MakeTemp;
begin
  {$I-}
  MkDir('A2ZTEMP!.@#$');
  {$I+}
  if IOResult<>0 then HaltWithMsg('Unable to create temporary directory.');
  OldExitProc := ExitProc;
  ExitProc := @NewExitProc;
end;

procedure CheckSubs;
begin
  if (PKZIP='UNCONFIGURED') or (PKUNPAK='UNCONFIGURED') or
    (PAK='UNCONFIGURED') then
  begin
    WriteLn('This copy of A2Z has not been configured.  After you''re finished configuring,');
    WriteLn('run A2Z again.');
    Configure;
    Halt;
  end;
  if not FileFound(PKZIP) then
    HaltWithMsg('Unable to open --> '+PKZIP);
  if not FileFound(PKUNPAK) then
    HaltWithMsg('Unable to open --> '+PKUNPAK);
end;

procedure ShowInfo;
begin
  DisplayProgHeader;
  WriteLn;
  WriteLn('A2Z [/C] filespec [/S]');
  WriteLn;
  WriteLn('Where:');
  WriteLn('  /C  configured A2Z');
  WriteLn('  or  [filespec] is the files to convert to ZIPs.  Wildcards are okay.');
  WriteLn('      to convert all ARC and PAK files in the current directory, eg, type:');
  WriteLn('        A2Z *.*');
  WriteLn('      note that A2Z will only convert files with ARC or PAK as an extention.');
  WriteLn('  /S  this indicates that subdirectories "below" the one specified in the');
  WriteLn('      convert spec should also be converted');
  Halt;
end;

procedure CheckForConfigCall;
begin
  if (ParamCount=0) or (ParamCount>2) then ShowInfo;
  if (ParamStr(1)='/C') or (ParamStr(1)='/c') then
  begin
    Configure;
    Halt;
  end;
  ConvSpec := FExpand(ParamStr(1));
  ConvBelow := false;
  if (ParamCount=2) then if ((ParamStr(2)='/S') or (ParamStr(2)='/s')) then
    ConvBelow := true
    else ShowInfo;
  FSplit(ConvSpec, ConvDir,ConvName,ConvExt);
  if ConvExt='' then ConvExt := '.*';
  if ConvName='' then ConvName := '*';
  ConvSpec := ConvName+ConvExt;
end;

procedure IPP;
interrupt;
begin
  InLine(
      $06/                   {          push    es                      }
      $1E/                   {          push    ds                      }
      $53/                   {          push    bx                      }
      $57/                   {          push    di                      }
      $BB/$3F/$3F/           {          mov     bx, 3f3fh               }
      $8E/$C3/               {          mov     es, bx                  }
      $BB/$3F/$3F/           {          mov     bx, 3f3fh               }
      $26/$8B/$3F/           {          mov     di, word ptr [es:bx]    }
      $26/$8E/$5F/$02/       {          mov     ds, word ptr [es:bx+2]  }
      $88/$05/               {          mov     byte ptr [di], al       }
      $26/$FF/$07/           {          inc     word ptr [es:bx]        }
      $5F/                   {          pop     di                      }
      $5B/                   {          pop     bx                      }
      $1F/                   {          pop     ds                      }
      $07/                   {          pop     es                      }
      $3C/$0A/               {          cmp     al, 10                  }
      $75/$28/               {          jne     looper                  }
      $50/                   {          push    ax                      }
      $52/                   {          push    dx                      }
      $51/                   {          push    cx                      }
      $53/                   {          push    bx                      }
      $B4/$03/               {          mov     ah, 3                   }
      $B7/$00/               {          mov     bh, 0                   }
      $CD/$10/               {          int     10h                     }
      $80/$FE/$18/           {          cmp     dh, 24                  }
      $75/$15/               {          jne     popper                  }
      $FE/$CE/               {          dec     dh                      }
      $B7/$00/               {          mov     bh, 0                   }
      $B4/$02/               {          mov     ah, 2                   }
      $CD/$10/               {          int     10h                     }
      $B8/$01/$06/           {          mov     ax, 0601h               }
      $B7/$07/               {          mov     bh, 7                   }
      $B9/$00/$11/           {          mov     cx, 1100h               }
      $BA/$4F/$18/           {          mov     dx, 184fh               }
      $CD/$10/               {          int     10h                     }
      $5B/                   {  popper: pop     bx                      }
      $59/                   {          pop     cx                      }
      $5A/                   {          pop     dx                      }
      $58/                   {          pop     ax                      }
      $9C/                   {  looper: pushf                           }
      $9A/$00/$00/$00/$00/   {          call    far [0:0]               }
      $CF);                  {          iret                            }
end;


var
  OldSeg,OldOfs:        word;
  OldExitProc2:         pointer;
  Reg:                  Registers;
  CmdY:                 byte;
  BufData:              longint;
  BufferSeg:            word;
  BufferOfs:            word;
  BufferPtr:            pointer;
  BufferLen:            word;

procedure NewExitProc2;
begin
  Reg.AH := $25;
  Reg.AL := $29;
  Reg.DS := OldSeg;
  Reg.DX := OldOfs;
  MsDos(Reg);
  Window(1,1,80,25);
  GotoXY(1,24);
  TextAttr := $07;
  ClrEol;
  WriteLn('Thank you for using A2Z!');
  ExitProc := OldExitProc2;
end;

procedure ResetBuffer;
begin
  MemW[seg(BufData):ofs(BufData)] := BufferOfs;
  MemW[seg(BufData):ofs(BufData)+2] := BufferSeg;
  MemW[seg(IPP):ofs(IPP)+21] := seg(BufData);
  MemW[seg(IPP):ofs(IPP)+26] := ofs(BufData);
end;

function BufSize: word;
begin
  BufSize := MemW[seg(BufData):ofs(BufData)]-BufferOfs;
end;

function InBuffer(S: string): integer;
var
  L,M:                  word;
  X:                    byte;
begin
  X := 1;
  L := BufferOfs;
  M := BufSize;
  while (X<=length(S)) and (L<=M) do
  begin
    if Mem[BufferSeg:L]=byte(S[X]) then Inc(X) else X := 1;
    Inc(L);
  end;
  if X>length(S) then InBuffer := L-length(S) else InBuffer := -1;
end;

procedure InstallInterruptHandler;
begin
  BufferLen := $4000;
  GetMem(BufferPtr,BufferLen);
  BufferSeg := seg(BufferPtr^);
  BufferOfs := ofs(BufferPtr^);
  ResetBuffer;
  Reg.AH := $35;
  Reg.AL := $29;
  MsDos(Reg);
  OldSeg := Reg.ES;
  OldOfs := Reg.BX;
  MemW[seg(IPP):ofs(IPP)+90] := Reg.BX;
  MemW[seg(IPP):ofs(IPP)+92] := Reg.ES;
  Reg.AL := $29;
  Reg.AH := $25;
  Reg.DS := seg(IPP);
  Reg.DX := ofs(IPP)+16;
  MsDos(Reg);
  OldExitProc2 := ExitProc;
  ExitProc := @NewExitProc2;
  TextAttr := $07;
  ClrScr;
  GotoXY(1,15);
  TextAttr := $70;
  Write('DOS COMMAND:');
  ClrEol;
  WriteLn;
  ClrEol;
  TextAttr := $07;
  Window(1,1,80,13);
  GotoXY(1,1);
  CmdY := 18;
end;

procedure ExecCommand(Cmd,Parm: string);
var
  OX,OY: byte;
begin
  ResetBuffer;
  OX := WhereX;
  OY := WhereY;
  Window(1,1,80,25);
  GotoXY(14,15);
  TextAttr := $70;
  Write(Cmd,' ',Parm);
  GotoXY(1,CmdY);
  TextAttr := $07;
  Exec(Cmd,Parm);
  CmdY := WhereY;
  GotoXY(14,15);
  TextAttr := $70;
  ClrEol;
  WriteLn;
  ClrEol;
  TextAttr := $07;
  Window(1,1,80,13);
  GotoXY(OX,OY);
end;

function ArchiveBad: boolean;
begin
  if (InBuffer('error in')<>-1) or (InBuffer('Insufficent Memory')<>-1) or
     (InBuffer('Disk full')<>-1) or (InBuffer('Unknown comp')<>-1) or
     (InBuffer('CRC check')<>-1) or (InBuffer('run-time')<>-1) then
  ArchiveBad := true else ArchiveBad := false;
end;

function PakBad: boolean;
begin
  if (InBuffer('Could not open')<>-1) or (InBuffer('Unknown')<>-1) or
     (InBuffer('CRC ')<>-1) or (InBuffer('Unable')<>-1) then
  PakBad := true else PakBad := false;
end;

function ZipBad: boolean;
begin
  if (InBuffer('can''t create')<>-1) or (InBuffer('disk full')<>-1) or
     (InBuffer('memory ')<>-1) or (InBuffer('run-time')<>-1) then
     ZipBad := true else ZipBad := false;
end;

var
  Dir:                  string;
  ErrorYet:             boolean;

procedure LogError(Msg: string);
var
  EL:                   text;
begin
  Assign(EL, 'A2Z.LOG');
  if not ErrorYet then
  begin
    ErrorYet := true;
    Rewrite(EL);
  end
  else begin
    {$I-}
    Append(EL);
    {$I+}
    if IOResult<>0 then Rewrite(EL);
  end;
  WriteLn(Msg);
  WriteLn(EL, Msg);
  Close(EL);
end;

procedure RewriteError;
var
  EL:                   text;
begin
  Assign(EL, 'A2Z.LOG');
  Rewrite(EL);
  Close(EL);
end;

procedure ConvertFile(N: ComStr);
var
  L:                    string;
  T:                    text;
  C:                    string[20];
  NName:                NameStr;
  NDir:                 DirStr;
  NExt:                 ExtStr;
  Z:                    string;
  Code:                 integer;
  Okay:                 boolean;
  FilesInArc:           word;
  UnarcedSize:          longint;
  ArcedSize:            longint;
  SRec:                 SearchRec;
  ArcComment:           string[60];
  ArcDate:              longint;
  P:                    integer;
  R:                    Registers;
begin
  Inc(FNum);
  WriteLn;
  TextAttr := $0F;
  WriteLn('Converting ',N,'  Saved: ',Saved,' bytes   File ',FNum,' of ',FilesToConv);
  TextAttr := $07;
  SRec.Name := '*';
  FindFirst(N,0,SRec);
  ArcDate := SRec.Time;
  Write('Analyzing...');
  ExecCommand(PKUNPAK,'-V '+N);
  WriteLn(' done.');
  if ArchiveBad then
  begin
    LogError('Error in archive '+N+'; file skipped.');
    exit;
  end;
  P := InBuffer('Searching');
  if P=-1 then
  begin
    LogError('Error in archive '+N+'; file skipped.');
    exit;
  end;
  ArcComment := '';
  P := P+11;
  repeat
    Inc(P);
  until char(Mem[BufferSeg:P]) in [' ',#13,#10];
  if char(Mem[BufferSeg:P])=' ' then
  begin
    repeat
      Inc(P);
    until char(Mem[BufferSeg:P])=' ';
    Inc(P);
    repeat
      ArcComment := ArcComment+char(Mem[BufferSeg:P]);
      Inc(P);
    until char(Mem[BufferSeg:P]) in [#10,#13];
  end;
  while ArcComment[length(ArcComment)]=' ' do Dec(ArcComment[0]);
  L := '';
  P := InBuffer(#13+#10+'---- ');
  if P=-1 then
  begin
    LogError('Error in archive '+N+'; file skipped.');
    exit;
  end;
  P := P+52;
  repeat
    L := L+char(Mem[BufferSeg:P]);
    Inc(P);
  until char(Mem[BufferSeg:P]) in [#10,#13];
  DeleteDirectory('A2ZTEMP!.@#$');
  C := '';
  repeat
    C := C+L[1];
    L := copy(L,2,255);
  until L[1]=' ';
  while L[1]=' ' do L := copy(L,2,255);
  Val(C,FilesInArc,Code);
  C := '';
  repeat
    C := C+L[1];
    L := copy(L,2,255);
  until L[1]=' ';
  while L[1]=' ' do L := copy(L,2,255);
  Val(C,UnArcedSize,Code);
  C := '';
  repeat
    C := C+L[1];
    L := copy(L,2,255);
  until L[1] in [#13,#10,#32];
  Val(C,ArcedSize,Code);
  WriteLn(FilesInArc,' files(s), ',ArcedSize,' bytes arced, ',UnArcedSize,' bytes unarced');
  if ArcComment<>'' then
  WriteLn('Archive comment: "',ArcComment,'"');
  if DiskFree(0)<UnarcedSize*3 then
  begin
    LogError('Insufficient free space to convert '+N);
    exit;
  end;
  Write('Extracting files...');
  if pos('.ARC',N)<>0 then
  begin
    ExecCommand(PKUNPAK,N+' A2ZTEMP!.@#$');
    Okay := not ArchiveBad;
  end else
  begin
    ExecCommand(PAK,'e '+N+' A2ZTEMP!.@#$');
    Okay := not PakBad;
  end;
  WriteLn(' done.');
  if not Okay then
  begin
    LogError('Error extracting archive '+N+'; skipping.');
    exit;
  end;
  Write('Creating ZIP file ');
  FSplit(N, NDir,NName,NExt);
  Z := NDir+NName+'.ZIP';
  Write(Z, '...');
  Assign(T, Z);
  {$I-}
  Erase(T);
  {$I+}
  Code := IOResult;
  if ArcComment='' then
    ExecCommand(PKZIP,Z+' -ea'+AsciiLvl+' -eb'+BinLvl+' A2ZTEMP!.@#$\*.*')
  else
  begin
    Assign(T, 'ZCOMMENT.A2Z');
    Rewrite(T);
    WriteLn(T, ArcComment);
    Close(T);
    R.BX := 0;
    R.AH := $45;
    MsDos(R);
    Code := R.AX;
    Reset(T);
    R.BX := TextRec(T).Handle;
    R.CX := 0;
    R.AH := $46;
    MsDos(R);
    ExecCommand(PKZIP,Z+' -ea'+AsciiLvl+' -eb'+BinLvl+' -a A2ZTEMP!.@#$\*.* -z');
    R.BX := Code;
    R.CX := 0;
    R.AH := $46;
    MsDos(R);
    R.BX := Code;
    R.AH := $3E;
    MsDos(R);
    Close(T);
    Erase(T);
  end;
  WriteLn(' done.');
  if ZipBad then
  begin
    LogError('Unable to create zip file: '+Z+'; archive skipped.');
    exit;
  end;
  FindFirst(Z,0,SRec);
  Assign(T, N);
  {$I-}
  Erase(T);
  {$I+}
  Code := IOResult;
  Saved := Saved+(ArcedSize-SRec.Size);
  Assign(T, Z);
  Reset(T);
  SetFTime(T, ArcDate);
  Close(T);
  Str(ArcedSize-SRec.Size,C);
  LogError('File '+N+' converted to ZIP, '+C+' bytes saved.');
end;


procedure ConvertFiles;

var
  ConvSRec: SearchRec;
  LLen:     byte;

  procedure AddFile;
  begin
    if (ConvSRec.Attr and Directory)=Directory then
       if (ConvSRec.Name[1]<>'.') and ConvBelow then
       begin
         LLen := length(Dir);
         Dir := Dir+ConvSRec.Name+'\';
         ConvertFiles;
         Dir := copy(Dir,1,LLen);
       end;
    if ((ConvSRec.Attr and (SysFile+ReadOnly+Hidden+VolumeID+Directory))=0)
    and ((pos('.ARC',ConvSRec.Name)<>0) or (pos('.PAK',ConvSRec.Name)<>0)) then
      if Search then
      begin
        Inc(FilesToConv);
        Inc(BytesToConv, ConvSRec.Size);
        GotoXY(1,WhereY);
        Write(Dir,ConvSRec.Name);
        ClrEol;
      end
      else ConvertFile(Dir+ConvSRec.Name);
  end;

begin
  ConvSRec.Name := '*';
  FindFirst(Dir+ConvSpec,AnyFile,ConvSRec);
  if ConvSRec.Name<>'*' then
  begin
    AddFile;
    repeat
      ConvSRec.Name := '*';
      FindNext(ConvSRec);
      if ConvSRec.Name<>'*' then AddFile;
    until ConvSRec.Name='*';
  end;
  if Search then
  begin
    GotoXY(1,WhereY);
    Write(Dir);
    ClrEol;
    WriteLn;
  end;
end;

procedure Summarize;
var
  C:                    char;
begin
  if FilesToConv=0 then HaltWithMsg('No files could be found to convert.');
  WriteLn;
  WriteLn(FilesToConv,' files to convert, totaling ',BytesToConv,' bytes.');
  Write('Press any key to begin.');
  repeat until KeyPressed;
  while KeyPressed do C := ReadKey;
  ClrScr;
end;

var
  X: word;
  S: string[20];

begin
  ErrorYet := false;
  CheckForConfigCall;
  CheckSubs;
  MakeTemp;
  InstallInterruptHandler;
  Search := true;
  Dir := ConvDir;
  WriteLn('Searching...');
  FilesToConv := 0;
  BytesToConv := 0;
  ConvertFiles;
  Summarize;
  Search := false;
  FNum := 0;
  Saved := 0;
  ConvertFiles;
{
  InstallInterruptHandler;
  ExecCommand('C:\COMMAND.COM','');
}
  Str(Saved,S);
  LogError(S+' bytes saved total.');
end.
