{*****************************************************************************
 *                                                                           *
 *                       FileForm.Pas By Andrew Farmer                       *
 *              Complete Source Code for FileForm Revision 1.00              *
 *                                                                           *
 *       Copyright (c) 1989 by Andrew D. Farmer, All Rights Reserved.        *
 *                                                                           *
 *                                                                           *
 *     Compiled using Turbo Pascal Version 5.0 By Borland International      *
 *                                                                           *
 *****************************************************************************}

Program FileForm;

{$R-}                 {Range checking off}
{$B+}                 {Boolean complete evaluation on}
{$S+}                 {Stack checking on}
{$I+}                 {I/O checking on}
{$N-}                 {No numeric coprocessor}

Uses Crt, Dos;

Const Version : String[5] = '1.00';
      Level   : String[5] = '';

Var
  Buf                   : Array[1..20480] of Char;
  ThePath               : DirStr;
  TheExt                : ExtStr;
  Count, Count2, N      : Integer;
  TheName               : NameStr;
  TheFile, BackFile     : PathStr;
  Cased                 : String[4];
  TheLine               : String[255];
  TheInText, TheOutText : Text;

Function DownCase(Call:Char):Char;
Begin
  DownCase := Call;
  If Call = 'A' then DownCase := 'a';
  If Call = 'B' then DownCase := 'b';
  If Call = 'C' then DownCase := 'c';
  If Call = 'D' then DownCase := 'd';
  If Call = 'E' then DownCase := 'e';
  If Call = 'F' then DownCase := 'f';
  If Call = 'G' then DownCase := 'g';
  If Call = 'H' then DownCase := 'h';
  If Call = 'I' then DownCase := 'i';
  If Call = 'J' then DownCase := 'j';
  If Call = 'K' then DownCase := 'k';
  If Call = 'L' then DownCase := 'l';
  If Call = 'M' then DownCase := 'm';
  If Call = 'N' then DownCase := 'n';
  If Call = 'O' then DownCase := 'o';
  If Call = 'P' then DownCase := 'p';
  If Call = 'Q' then DownCase := 'q';
  If Call = 'R' then DownCase := 'r';
  If Call = 'S' then DownCase := 's';
  If Call = 'T' then DownCase := 't';
  If Call = 'U' then DownCase := 'u';
  If Call = 'V' then DownCase := 'v';
  If Call = 'W' then DownCase := 'w';
  If Call = 'X' then DownCase := 'x';
  If Call = 'Y' then DownCase := 'y';
  If Call = 'Z' then DownCase := 'z';
End;

Function MixCase(Switch:String):String;
Var
  NextUp : Boolean;
Begin
  NextUp := True;
  For N := 1 to Length(switch) do
  Begin
    If NextUp = True then switch[N] := UpCase(switch[N]);
    If NextUp = False then switch[N] := DownCase(switch[N]);
    If Switch[N] in ['!','@','#','$','%','^','&','*','(',')','-','_','=','+',
    '[','{',']','}',';',':','''','"','`','~','\','|',',','<','.','>','/','?',
    ' '] then NextUp := True else NextUp := False;
  End;
  MixCase := Switch;
End;

Procedure COMMAND_LINE;
Begin
  If ParamCount <> 2 then 
  Begin;
    Writeln('Usage: FileForm [UP|DOWN|MIX] [FileName]');
    Writeln;
    Writeln(' - UP will UpCase the entire file.');
    Writeln(' - DOWN will DownCase the entire file.');
    Writeln(' - MIX will MixCase the entire file.');
    If ParamCount = 0 then Halt(0);
    If ParamCount <> 2 then Halt(1);
  End;
  Cased := ParamStr(1);
  For N := 1 to Length(Cased) do
  Cased[N] := UpCase(Cased[N]);
  If (Cased <> 'UP') and (Cased <> 'DOWN') and (Cased <> 'MIX') then
  Begin
    Writeln(Cased,' is an invalid command line option, aborting');
    Halt(1);
  End;
  TheFile := ParamStr(2);
End; {Procedure COMMAND_LINE}

Procedure Banner;
Begin
  Writeln;
  Writeln('FileForm, Revision: ',version,level,' - Copyright 1989 by Andrew Farmer of 1:163/115.');
  Writeln;
End; {Procedure Banner}

Begin
  Assign(Input,''); Reset(Input); Assign(Output,''); Rewrite(Output);
  Banner;
  Command_Line;
  TheFile := FExpand(TheFile);
  TheFile := MixCase(TheFile);
  FSplit(TheFile,ThePath,TheName,TheExt);
  Assign(TheInText,TheFile);
  {$I-} Reset(TheInText); {$I+}
  If IORESULT <> 0 then
  Begin
    Writeln('Cannot open or read from ''',TheFile,''', aborting');
    Halt(1);
  End;
  Close(TheInText);
  {$I-} Rename(TheInText,ThePath + TheName + '.Afi'); {$I+}
  If IORESULT <> 0 then
  Begin
    Writeln('Cannot make a backup of ''',TheFile,''', aborting');
    Halt(1);
  End;
  BackFile := ThePath + TheName + '.Afi';
  Assign(TheOutText,TheFile);
  {$I-} Rewrite(TheOutText); {$I+}
  If IORESULT <> 0 then
  Begin
    Writeln('Cannot open or write to ''',TheFile,''', aborting');
    Halt(1);
  End;
  Assign(TheInText,BackFile);
  SetTextBuf(TheInText,Buf);
  {$I-} Reset(TheInText) {$I+};
  If IORESULT <> 0 then
  Begin
    Writeln('Cannot open or read from temporary backup file, aborting');
    Halt(1);
  End;
  Count := 0;
  Writeln('Processing the file: ',TheFile); 
  Repeat
    Count := Count + 1;
    Readln(TheInText,TheLine);
    If Cased = 'MIX' then TheLine := MixCase(TheLine);
    If (Cased = 'UP') then Begin For N := 1 to Length(TheLine) do TheLine[N] := UpCase(TheLine[N]); End;
    If (Cased = 'DOWN') then Begin For N := 1 to Length(TheLine) do TheLine[N] := DownCase(TheLine[N]); End;
    Writeln(TheOutText,TheLine);
  Until EOF(TheInText);
  Gotoxy(1,WhereY-1);
  ClrEol;
  Writeln(Cased,'cased ',Count,' Lines in the file ',TheFile,'.');
  Close(TheInText);
  Close(TheOutText);
  Erase(TheInText);
  Halt(0);
End.
