/*  Bootsec - Examine information in a disk's boot sector.
**	      by Jay
*/

#include "stdio.h"

#define BUFLEN	 512

struct bsec {
	char jump[3];
	unsigned char oemname[8];	/* text name */
	unsigned int  secsize;		/* bytes per sector */
	unsigned char secs_clust;	/* sectors per cluster */
	unsigned int  resrvdsec;	/* reserved sectors (for boot record) */
	unsigned char fat_copies;	/* number of fat copies */
	unsigned int  dir_entries;	/* number of directory entries */
	unsigned int  totsectors;	/* total number of sectors */
	unsigned char media_id; 	/* media ID byte */
	unsigned int  secs_fat; 	/* sectors per fat */
	unsigned int  secs_track;	/* number of sectors per track */
	unsigned int  heads;		/* number of heads (sides) */
	unsigned int  hiddn_secs;	/* number of hidden sectors */
};

struct regval {
	int ax, bx, cx, dx, si, di, ds, es;
};

struct segval {
	int scs, sss, sds, ses;
};

union {
    char dbuf[BUFLEN];
    struct bsec btsec;
} onion;

#define diskbuf onion.dbuf
#define bootsec onion.btsec


main( argc, argv )
int argc;
char *argv[];
{
    struct segval segments;
    struct regval registers;

    segread( &segments );		/* avoid changing current seg regs */
    registers.ds = segments.sds;
    registers.es = segments.ses;

    if( argc == 2 ) {				/* drive specified */
	registers.ax = (*argv[1] & 0x0F) - 1;	/* no error check here! */
    } else {
	registers.ax = 0x1900;
	sysint21( &registers, &registers );	/* get current drive into ax */
    }

    registers.bx = diskbuf;			/* destination */
    registers.cx = 01;				/* read one sector */
    registers.dx = 0;				/* logical sector 0 */
    sysint( 0x25, &registers, &registers );

    if( registers.ax & 0xFE00 ) _exit(1);	/* some disk error - quit */

    printf( "\n" );
    printf( "OEM name:                  '%-8s'\n", bootsec.oemname );
    printf( "Bytes per sector:           %-12x    %u\n", bootsec.secsize, bootsec.secsize );
    printf( "Sectors per cluster:        %-12x    %u\n", bootsec.secs_clust, bootsec.secs_clust );
    printf( "Number of reserved sectors: %-12x    %u\n", bootsec.resrvdsec, bootsec.resrvdsec );
    printf( "Number of FAT copies:       %-12x    %u\n", bootsec.fat_copies, bootsec.fat_copies );
    printf( "Root directory entries:     %-12x    %u\n", bootsec.dir_entries, bootsec.dir_entries);
    printf( "Total sectors on disk:      %-12x    %u\n", bootsec.totsectors, bootsec.totsectors );
    printf( "Media ID byte:              %2x\n", bootsec.media_id );
    printf( "Sectors used for each FAT:  %-12x    %u\n", bootsec.secs_fat, bootsec.secs_fat );
    printf( "Sectors per track:          %-12x    %u\n", bootsec.secs_track, bootsec.secs_track );
    printf( "Number of sides:            %-12x    %u\n", bootsec.heads, bootsec.heads );
    printf( "Number of hidden sectors:   %-12x    %u\n", bootsec.hiddn_secs, bootsec.hiddn_secs );
    printf( "\n\n" );
}
